/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.core.explorer;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.explorer.ExplorerSupport;
import org.openide.awt.Mnemonics;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.actions.Presenter;

final class ExplorerContextMenuFactory {
    private static final Logger LOGGER = Logger.getLogger(ExplorerContextMenuFactory.class.getName());
    private static final String SELECTION_ACTIONS_FILE = "VisualVM/ExplorerPopupSelection";
    private static final String NOSELECTION_ACTIONS_FILE = "VisualVM/ExplorerPopupNoSelection";
    private static ExplorerContextMenuFactory sharedInstance;

    ExplorerContextMenuFactory() {
    }

    static synchronized ExplorerContextMenuFactory instance() {
        if (sharedInstance == null) {
            sharedInstance = new ExplorerContextMenuFactory();
        }
        return sharedInstance;
    }

    JPopupMenu createPopupMenu() {
        List<Action>[] actionsArray = this.getActions();
        List<Action> defaultActions = actionsArray[0];
        List<Action> actions = actionsArray[1];
        if (defaultActions.size() == 0 && actions.size() == 0) {
            return null;
        }
        JPopupMenu popupMenu = new JPopupMenu();
        boolean realDefaultAction = true;
        if (!defaultActions.isEmpty()) {
            for (Action defaultAction : defaultActions) {
                DataSourceItem defaultItem = new DataSourceItem(defaultAction);
                if (realDefaultAction) {
                    defaultItem.setFont(defaultItem.getFont().deriveFont(1));
                    realDefaultAction = false;
                }
                popupMenu.add(defaultItem);
            }
        }
        if (!defaultActions.isEmpty() && !actions.isEmpty()) {
            popupMenu.addSeparator();
        }
        if (!actions.isEmpty()) {
            for (Action action : actions) {
                if (action == null) {
                    popupMenu.addSeparator();
                    continue;
                }
                popupMenu.add(ExplorerContextMenuFactory.createItem(action));
            }
        }
        return popupMenu;
    }

    Action getDefaultActionFor(Set<DataSource> dataSources) {
        if (dataSources.isEmpty()) {
            return null;
        }
        List<Action> defaultActions = this.getActions()[0];
        return defaultActions.isEmpty() ? null : defaultActions.get(0);
    }

    private List<Action>[] getActions() {
        if (ExplorerSupport.sharedInstance().getSelectedDataSources().isEmpty()) {
            return this.getNoSelectionActions();
        }
        return this.getSelectionActions();
    }

    private List<Action>[] getSelectionActions() {
        FileObject actionsFO = FileUtil.getConfigFile((String)SELECTION_ACTIONS_FILE);
        return this.getActions(actionsFO, true);
    }

    private List<Action>[] getNoSelectionActions() {
        FileObject actionsFO = FileUtil.getConfigFile((String)NOSELECTION_ACTIONS_FILE);
        return this.getActions(actionsFO, false);
    }

    private List<Action>[] getActions(FileObject actionsFO, boolean allowDefaultActions) {
        ArrayList<Action> defaultActions = new ArrayList<Action>();
        ArrayList<Action> actions = new ArrayList<Action>();
        if (actionsFO != null) {
            DataObject[] menuItems;
            DataFolder actionsDF = DataFolder.findFolder((FileObject)actionsFO);
            for (DataObject menuItemDO : menuItems = actionsDF.getChildren()) {
                FileObject fobj = menuItemDO.getPrimaryFile();
                if (fobj.isFolder()) {
                    LOGGER.log(Level.WARNING, "Nested menus not supported for Applications context menu: " + fobj, fobj);
                    continue;
                }
                InstanceCookie menuItemCookie = (InstanceCookie)menuItemDO.getCookie(InstanceCookie.class);
                try {
                    ArrayList<Action> actionsList;
                    Object menuItem = menuItemCookie.instanceCreate();
                    boolean isDefaultAction = false;
                    Object isDefaultActionObj = fobj.getAttribute("default");
                    if (isDefaultActionObj != null) {
                        try {
                            isDefaultAction = (Boolean)isDefaultActionObj;
                            if (!allowDefaultActions && isDefaultAction) {
                                LOGGER.log(Level.WARNING, "Default actions not supported for " + actionsFO.getPath() + ": " + menuItem, menuItem);
                            }
                        }
                        catch (Exception e) {
                            LOGGER.log(Level.WARNING, "Cannot determine whether context menu action is default: " + isDefaultActionObj, isDefaultActionObj);
                        }
                    }
                    ArrayList<Action> arrayList = actionsList = isDefaultAction ? defaultActions : actions;
                    if (menuItem instanceof Action) {
                        Action action = (Action)menuItem;
                        if (!action.isEnabled()) continue;
                        actionsList.add(action);
                        continue;
                    }
                    if (menuItem instanceof JSeparator) {
                        if (isDefaultAction) {
                            LOGGER.log(Level.WARNING, "Separator cannot be added to default actions " + menuItem, menuItem);
                            continue;
                        }
                        actionsList.add(null);
                        continue;
                    }
                    LOGGER.log(Level.WARNING, "Unsupported context menu item: " + menuItem, menuItem);
                }
                catch (Exception ex) {
                    LOGGER.log(Level.SEVERE, "Unable to resolve context menu action: " + menuItemDO, menuItemDO);
                }
            }
        }
        return new List[]{this.cleanupActions(defaultActions), this.cleanupActions(actions)};
    }

    private List<Action> cleanupActions(List<Action> actions) {
        int lastItemIndex;
        Action lastCleanAction;
        boolean leadingNull = true;
        Action lastAction = null;
        ArrayList<Action> cleanActions = new ArrayList<Action>();
        for (Action action : actions) {
            if (action == null) {
                if (!leadingNull && lastAction != null) {
                    cleanActions.add(null);
                }
            } else {
                cleanActions.add(action);
                leadingNull = false;
            }
            lastAction = action;
        }
        if (!cleanActions.isEmpty() && (lastCleanAction = (Action)cleanActions.get(lastItemIndex = cleanActions.size() - 1)) == null) {
            cleanActions.remove(lastItemIndex);
        }
        return cleanActions;
    }

    private static JMenuItem createItem(Action action) {
        if (action instanceof Presenter.Popup) {
            return ((Presenter.Popup)action).getPopupPresenter();
        }
        return new DataSourceItem(action);
    }

    private static class DataSourceItem
    extends JMenuItem {
        public DataSourceItem(Action action) {
            super(action);
            this.setIcon(null);
            this.setToolTipText(null);
            String name = (String)action.getValue("Name");
            if (name != null) {
                Mnemonics.setLocalizedText((AbstractButton)this, (String)name);
            }
        }
    }
}

