/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jfr.views.gc;

import org.graalvm.visualvm.core.ui.DataSourceView;
import org.graalvm.visualvm.core.ui.DataSourceViewProvider;
import org.graalvm.visualvm.jfr.JFRSnapshot;
import org.graalvm.visualvm.jfr.model.JFREventChecker;
import org.graalvm.visualvm.jfr.views.gc.JFRSnapshotGcView;

public final class JFRSnapshotGcViewProvider
extends DataSourceViewProvider<JFRSnapshot> {
    static final String EVENT_GARBAGE_COLLECTION = "jdk.GarbageCollection";
    static final String EVENT_GC_CONFIGURATION = "jdk.GCConfiguration";
    static final String EVENT_HEAP_CONFIGURATION = "jdk.GCHeapConfiguration";
    static final String EVENT_YOUNG_GEN_CONFIGURATION = "jdk.YoungGenerationConfiguration";
    static final String EVENT_SURVIVOR_CONFIGURATION = "jdk.GCSurvivorConfiguration";
    static final String EVENT_TLAB_CONFIGURATION = "jdk.GCTLABConfiguration";
    static final String PREFIX_GCPHASE = "jdk.GCPhase";
    static final String EVENT_GCPHASE_CONCURRENT = "jdk.GCPhaseConcurrent";
    static final String EVENT_GCPHASE_PARALLEL = "jdk.GCPhaseParallel";
    static final String EVENT_GCPHASE_PAUSE = "jdk.GCPhasePause";
    static final String EVENT_GCPHASE_PAUSE_LVL1 = "jdk.GCPhasePauseLevel1";
    static final String EVENT_GCPHASE_PAUSE_LVL2 = "jdk.GCPhasePauseLevel2";
    static final String EVENT_GCPHASE_PAUSE_LVL3 = "jdk.GCPhasePauseLevel3";
    static final String EVENT_GCPHASE_PAUSE_LVL4 = "jdk.GCPhasePauseLevel4";

    protected boolean supportsViewFor(JFRSnapshot jfrSnapshot) {
        return true;
    }

    protected DataSourceView createView(JFRSnapshot jfrSnapshot) {
        return new JFRSnapshotGcView(jfrSnapshot);
    }

    public static final class EventChecker_Phases
    extends JFREventChecker {
        public EventChecker_Phases() {
            super(EventChecker_Phases.checkedTypes());
        }

        static String[] checkedTypes() {
            return new String[]{JFRSnapshotGcViewProvider.EVENT_GCPHASE_CONCURRENT, JFRSnapshotGcViewProvider.EVENT_GCPHASE_PARALLEL, JFRSnapshotGcViewProvider.EVENT_GCPHASE_PAUSE, JFRSnapshotGcViewProvider.EVENT_GCPHASE_PAUSE_LVL1, JFRSnapshotGcViewProvider.EVENT_GCPHASE_PAUSE_LVL2, JFRSnapshotGcViewProvider.EVENT_GCPHASE_PAUSE_LVL3, JFRSnapshotGcViewProvider.EVENT_GCPHASE_PAUSE_LVL4};
        }
    }

    public static final class EventChecker
    extends JFREventChecker {
        public EventChecker() {
            super(EventChecker.checkedTypes());
        }

        static String[] checkedTypes() {
            return new String[]{JFRSnapshotGcViewProvider.EVENT_GARBAGE_COLLECTION, JFRSnapshotGcViewProvider.EVENT_GC_CONFIGURATION, JFRSnapshotGcViewProvider.EVENT_YOUNG_GEN_CONFIGURATION, JFRSnapshotGcViewProvider.EVENT_SURVIVOR_CONFIGURATION, JFRSnapshotGcViewProvider.EVENT_TLAB_CONFIGURATION};
        }
    }
}

