/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.application.options;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Timer;
import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.application.jvm.Jvm;
import org.graalvm.visualvm.application.jvm.JvmFactory;
import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.datasource.DataSourceContainer;
import org.graalvm.visualvm.core.datasupport.DataChangeEvent;
import org.graalvm.visualvm.core.datasupport.DataChangeListener;
import org.graalvm.visualvm.core.ui.DataSourceWindowManager;
import org.graalvm.visualvm.host.Host;
import org.netbeans.api.sendopts.CommandException;
import org.netbeans.spi.sendopts.Env;
import org.netbeans.spi.sendopts.Option;
import org.netbeans.spi.sendopts.OptionProcessor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public final class Open
extends OptionProcessor {
    private Option openpid = Option.requiredArgument((char)'\uffff', (String)"openpid");
    private Option openid = Option.requiredArgument((char)'\uffff', (String)"openid");
    private static final int TIMEOUT = 5000;
    private static final String ID = "visualvm.id";

    public Open() {
        this.openpid = Option.shortDescription((Option)this.openpid, (String)"org.graalvm.visualvm.application.options.Bundle", (String)"MSG_OPENPID");
        this.openid = Option.shortDescription((Option)this.openid, (String)"org.graalvm.visualvm.application.options.Bundle", (String)"MSG_OPENID");
    }

    protected Set<Option> getOptions() {
        HashSet<Option> options = new HashSet<Option>();
        options.add(this.openpid);
        options.add(this.openid);
        return options;
    }

    protected void process(Env env, Map<Option, String[]> optionValues) throws CommandException {
        DataSourceContainer container;
        Set apps;
        int idx;
        Integer pid = null;
        String id = null;
        String[] pids = optionValues.get(this.openpid);
        String[] ids = optionValues.get(this.openid);
        Integer viewIndex = null;
        if (pids != null && pids.length > 0) {
            String pidStr = pids[0];
            idx = pidStr.indexOf(64);
            if (idx > -1) {
                try {
                    viewIndex = Integer.valueOf(pidStr.substring(idx + 1));
                }
                catch (NumberFormatException e) {
                    throw new CommandException(0, NbBundle.getMessage(Open.class, (String)"MSG_VIEWIDX_FAILED", (Object[])new Object[]{e.toString()}));
                }
                pidStr = pidStr.substring(0, idx);
            }
            try {
                pid = Integer.valueOf(pidStr);
            }
            catch (NumberFormatException e) {
                throw new CommandException(0, NbBundle.getMessage(Open.class, (String)"MSG_PID_FAILED", (Object[])new Object[]{e.toString()}));
            }
        }
        if (ids != null && ids.length > 0) {
            String idStr = ids[0];
            idx = idStr.indexOf(64);
            if (idx > -1) {
                try {
                    viewIndex = Integer.valueOf(idStr.substring(idx + 1));
                }
                catch (NumberFormatException e) {
                    throw new CommandException(0, NbBundle.getMessage(Open.class, (String)"MSG_VIEWIDX_FAILED", (Object[])new Object[]{e.toString()}));
                }
                idStr = idStr.substring(0, idx);
            }
            id = "-Dvisualvm.id=" + idStr;
        }
        if (this.openApplication(id, pid, viewIndex, apps = (container = Host.LOCALHOST.getRepository()).getDataSources(Application.class))) {
            return;
        }
        Listener l = new Listener(id, pid, viewIndex, container);
        container.addDataChangeListener((DataChangeListener)l, Application.class);
    }

    private boolean openApplication(String id, Integer pid, Integer viewIndex, Set<Application> apps) {
        for (Application app : apps) {
            String args;
            Jvm jvm;
            if (pid != null && app.getPid() == pid.intValue()) {
                int index = viewIndex != null ? viewIndex - 1 : 0;
                DataSourceWindowManager.sharedInstance().openDataSource((DataSource)app, true, index);
                return true;
            }
            if (id == null || !(jvm = JvmFactory.getJVMFor(app)).isBasicInfoSupported() || (args = jvm.getJvmArgs()) == null || !args.contains(id)) continue;
            int index = viewIndex != null ? viewIndex - 1 : 0;
            DataSourceWindowManager.sharedInstance().openDataSource((DataSource)app, true, index);
            return true;
        }
        return false;
    }

    private class Listener
    implements DataChangeListener<Application>,
    ActionListener {
        private final Integer pid;
        private final String id;
        private final Integer viewIndex;
        private final DataSourceContainer container;
        private volatile boolean removed;
        private final Timer timer;

        private Listener(String i, Integer p, Integer x, DataSourceContainer c) {
            this.id = i;
            this.pid = p;
            this.viewIndex = x;
            this.container = c;
            this.timer = new Timer(5000, this);
            this.timer.start();
        }

        public synchronized void dataChanged(DataChangeEvent<Application> event) {
            Set added = event.getAdded();
            if (Open.this.openApplication(this.id, this.pid, this.viewIndex, added) && !this.removed) {
                this.container.removeDataChangeListener((DataChangeListener)this);
                this.removed = true;
                this.timer.stop();
            }
        }

        @Override
        public synchronized void actionPerformed(ActionEvent e) {
            if (!this.removed) {
                this.container.removeDataChangeListener((DataChangeListener)this);
                this.removed = true;
                String msg = "";
                if (this.pid != null) {
                    msg = NbBundle.getMessage(Open.class, (String)"MSG_NO_APP_PID", (Object[])new Object[]{Integer.toString(this.pid)});
                }
                if (this.id != null) {
                    msg = NbBundle.getMessage(Open.class, (String)"MSG_NO_APP_ID");
                }
                NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)msg, 2);
                DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)desc);
            }
        }
    }
}

