/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.internal.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IType;
import org.openjdk.jmc.flightrecorder.CouldNotLoadRecordingException;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.internal.EventArray;
import org.openjdk.jmc.flightrecorder.internal.parser.RepositoryBuilder;
import org.openjdk.jmc.flightrecorder.internal.util.CanonicalConstantMap;
import org.openjdk.jmc.flightrecorder.parser.IEventSinkFactory;
import org.openjdk.jmc.flightrecorder.parser.IParserExtension;

public class LoaderContext {
    private final RepositoryBuilder repositoryBuilder = new RepositoryBuilder();
    private final IEventSinkFactory sinkFactory;
    private final ConcurrentHashMap<Object, CanonicalConstantMap<Object>> constantsByType = new ConcurrentHashMap();
    private final boolean hideExperimentals;
    private final List<? extends IParserExtension> extensions;

    public LoaderContext(List<? extends IParserExtension> extensions, boolean hideExperimentals) {
        this.extensions = extensions;
        this.hideExperimentals = hideExperimentals;
        IEventSinkFactory sinkFactory = this.repositoryBuilder;
        for (int i = extensions.size() - 1; i >= 0; --i) {
            sinkFactory = extensions.get(i).getEventSinkFactory(sinkFactory);
        }
        this.sinkFactory = sinkFactory;
    }

    public CanonicalConstantMap<Object> getConstantPool(Object poolKey) {
        CanonicalConstantMap<Object> newMap = new CanonicalConstantMap<Object>();
        CanonicalConstantMap existing = this.constantsByType.putIfAbsent(poolKey, newMap);
        return existing == null ? newMap : existing;
    }

    public boolean hideExperimentals() {
        return this.hideExperimentals;
    }

    public String getValueInterpretation(String eventTypeId, String fieldId) {
        for (IParserExtension iParserExtension : this.extensions) {
            String vi = iParserExtension.getValueInterpretation(eventTypeId, fieldId);
            if (vi == null) continue;
            return vi;
        }
        return null;
    }

    public IEventSinkFactory getSinkFactory() {
        return this.sinkFactory;
    }

    public EventArray[] buildEventArrays() throws CouldNotLoadRecordingException {
        this.sinkFactory.flush();
        Iterator<RepositoryBuilder.EventTypeEntry> eventTypes = this.repositoryBuilder.getEventTypes();
        ArrayList<EventArray> eventArrays = new ArrayList<EventArray>();
        while (eventTypes.hasNext()) {
            Collection<IItem[]> sortedArrays;
            RepositoryBuilder.EventTypeEntry ete = eventTypes.next();
            ete.eventType.addExtraAttribute(0, JfrAttributes.EVENT_TYPE);
            List attributes = ete.eventType.getAttributes();
            if (attributes.contains(JfrAttributes.START_TIME)) {
                int endTimeIndex = attributes.indexOf(JfrAttributes.END_TIME);
                int durationIndex = attributes.indexOf(JfrAttributes.DURATION);
                if (endTimeIndex >= 0 && durationIndex < 0) {
                    ete.eventType.addExtraAttribute(endTimeIndex, JfrAttributes.DURATION);
                } else if (durationIndex >= 0 && endTimeIndex < 0) {
                    ete.eventType.addExtraAttribute(durationIndex + 1, JfrAttributes.END_TIME);
                }
            }
            if ((sortedArrays = ete.buildSortedArrays()).isEmpty()) {
                eventArrays.add(new EventArray(new IItem[0], (IType<IItem>)ete.eventType, ete.category));
                continue;
            }
            for (IItem[] ea : sortedArrays) {
                eventArrays.add(new EventArray(ea, (IType<IItem>)ete.eventType, ete.category));
            }
        }
        return eventArrays.toArray(new EventArray[eventArrays.size()]);
    }
}

