/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.filters.plugin.operator;

import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.gephi.filters.spi.Category;
import org.gephi.filters.spi.EdgeFilter;
import org.gephi.filters.spi.Filter;
import org.gephi.filters.spi.FilterBuilder;
import org.gephi.filters.spi.FilterProperty;
import org.gephi.filters.spi.Operator;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.Subgraph;
import org.gephi.project.api.Workspace;
import org.openide.util.NbBundle;

public class NOTBuilderEdge
implements FilterBuilder {
    public Category getCategory() {
        return new Category(NbBundle.getMessage(NOTBuilderEdge.class, (String)"Operator.category"));
    }

    public String getName() {
        return NbBundle.getMessage(NOTBuilderEdge.class, (String)"NOTBuilderEdge.name");
    }

    public Icon getIcon() {
        return null;
    }

    public String getDescription() {
        return NbBundle.getMessage(NOTBuilderEdge.class, (String)"NOTBuilderEdge.description");
    }

    public Filter getFilter(Workspace workspace) {
        return new NotOperatorEdge();
    }

    public JPanel getPanel(Filter filter) {
        return null;
    }

    public void destroy(Filter filter) {
    }

    public static class NotOperatorEdge
    implements Operator {
        public int getInputCount() {
            return 1;
        }

        public String getName() {
            return NbBundle.getMessage(NOTBuilderEdge.class, (String)"NOTBuilderEdge.name");
        }

        public FilterProperty[] getProperties() {
            return null;
        }

        public Graph filter(Subgraph[] graphs) {
            if (graphs.length > 1) {
                throw new IllegalArgumentException("Not Filter accepts a single graph in parameter");
            }
            Subgraph graph = graphs[0];
            Graph mainGraph = graph.getView().getGraphModel().getGraph();
            for (Edge e : mainGraph.getEdges()) {
                Node source = e.getSource();
                Node target = e.getTarget();
                if (!graph.contains(source) || !graph.contains(target)) continue;
                Edge edgeInGraph = graph.getEdge(source, target, e.getType());
                if (edgeInGraph == null) {
                    graph.addEdge(e);
                    continue;
                }
                graph.removeEdge(edgeInGraph);
            }
            return graph;
        }

        public Graph filter(Graph graph, Filter[] filters) {
            if (filters.length > 1) {
                throw new IllegalArgumentException("Not Filter accepts a single filter in parameter");
            }
            Filter filter = filters[0];
            if (filter instanceof EdgeFilter && ((EdgeFilter)filter).init(graph)) {
                EdgeFilter edgeFilter = (EdgeFilter)filter;
                ArrayList<Edge> edgesToRemove = new ArrayList<Edge>();
                for (Edge e : graph.getEdges()) {
                    if (!edgeFilter.evaluate(graph, (Element)e)) continue;
                    edgesToRemove.add(e);
                }
                graph.removeAllEdges(edgesToRemove);
                edgeFilter.finish();
            }
            return graph;
        }
    }
}

