/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.jruby.ParseResult;
import org.jruby.Ruby;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyModule;
import org.jruby.RubySymbol;
import org.jruby.compiler.Compilable;
import org.jruby.ir.IRClosure;
import org.jruby.ir.IREvalScript;
import org.jruby.ir.IRFlags;
import org.jruby.ir.IRFor;
import org.jruby.ir.IRManager;
import org.jruby.ir.IRMethod;
import org.jruby.ir.IRModuleBody;
import org.jruby.ir.IRScopeType;
import org.jruby.ir.IRScriptBody;
import org.jruby.ir.instructions.CallBase;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.interpreter.FullInterpreterContext;
import org.jruby.ir.interpreter.InterpreterContext;
import org.jruby.ir.operands.Label;
import org.jruby.ir.operands.LocalVariable;
import org.jruby.ir.operands.Self;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.passes.AddCallProtocolInstructions;
import org.jruby.ir.passes.CompilerPass;
import org.jruby.ir.passes.CompilerPassScheduler;
import org.jruby.ir.passes.UnboxingPass;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.representations.BasicBlock;
import org.jruby.ir.transformations.inlining.CFGInliner;
import org.jruby.ir.transformations.inlining.SimpleCloneInfo;
import org.jruby.ir.util.IGVDumper;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.util.ByteList;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public abstract class IRScope
implements ParseResult {
    public static final Logger LOG = LoggerFactory.getLogger(IRScope.class);
    private static final Collection<IRClosure> NO_CLOSURES = Collections.EMPTY_LIST;
    private static final AtomicInteger globalScopeCount = new AtomicInteger();
    private final int scopeId;
    private final int lineNumber;
    private final IRScope lexicalParent;
    private final StaticScope staticScope;
    private final IRManager manager;
    private ByteList name;
    private List<IRClosure> nestedClosures;
    protected int nextClosureIndex;
    private List<IRScope> lexicalChildren;
    protected InterpreterContext interpreterContext;
    protected FullInterpreterContext fullInterpreterContext;
    protected FullInterpreterContext optimizedInterpreterContext;
    private int nextLabelIndex = 0;
    Map<RubySymbol, LocalVariable> localVars;
    private boolean alreadyHasInline;
    private String inlineFailed;
    public Compilable compilable;
    private boolean hasBreakInstructions;
    private boolean hasLoops;
    private boolean hasNonLocalReturns;
    private boolean receivesClosureArg;
    private boolean receivesKeywordArgs;
    private boolean accessesParentsLocalVariables;
    private boolean maybeUsingRefinements;
    private boolean canCaptureCallersBinding;
    private boolean canReceiveBreaks;
    private boolean canReceiveNonLocalReturns;
    private boolean usesZSuper;
    private boolean needsCodeCoverage;
    private boolean usesEval;

    protected IRScope(IRScope s2, IRScope lexicalParent) {
        this.lexicalParent = lexicalParent;
        this.manager = s2.manager;
        this.lineNumber = s2.lineNumber;
        this.staticScope = s2.staticScope;
        this.nextClosureIndex = s2.nextClosureIndex;
        this.interpreterContext = null;
        this.localVars = new HashMap<RubySymbol, LocalVariable>(s2.localVars);
        this.scopeId = globalScopeCount.getAndIncrement();
        this.setupLexicalContainment();
    }

    public IRScope(IRManager manager, IRScope lexicalParent, ByteList name2, int lineNumber, StaticScope staticScope) {
        this.manager = manager;
        this.lexicalParent = lexicalParent;
        this.name = name2;
        this.lineNumber = lineNumber;
        this.staticScope = staticScope;
        this.nextClosureIndex = 0;
        this.interpreterContext = null;
        if (this.parentMaybeUsingRefinements()) {
            this.setIsMaybeUsingRefinements();
        }
        this.localVars = new HashMap<RubySymbol, LocalVariable>(1);
        this.scopeId = globalScopeCount.getAndIncrement();
        this.setupLexicalContainment();
    }

    private void setupLexicalContainment() {
        if (this.manager.isDryRun() || RubyInstanceConfig.IR_WRITING || RubyInstanceConfig.RECORD_LEXICAL_HIERARCHY) {
            this.lexicalChildren = new ArrayList<IRScope>(1);
            if (this.lexicalParent != null) {
                this.lexicalParent.addChildScope(this);
            }
        }
    }

    public int getScopeId() {
        return this.scopeId;
    }

    public int hashCode() {
        return this.scopeId;
    }

    public boolean equals(Object other) {
        return other != null && this.getClass() == other.getClass() && this.scopeId == ((IRScope)other).scopeId;
    }

    protected void addChildScope(IRScope scope) {
        if (this.lexicalChildren == null) {
            this.lexicalChildren = new ArrayList<IRScope>(1);
        }
        this.lexicalChildren.add(scope);
    }

    public List<IRScope> getLexicalScopes() {
        if (this.lexicalChildren == null) {
            this.lexicalChildren = new ArrayList<IRScope>(1);
        }
        return this.lexicalChildren;
    }

    public void addClosure(IRClosure closure) {
        if (this.nestedClosures == null) {
            this.nestedClosures = new ArrayList<IRClosure>(1);
        }
        this.nestedClosures.add(closure);
    }

    public void removeClosure(IRClosure closure) {
        if (this.nestedClosures != null) {
            this.nestedClosures.remove(closure);
        }
    }

    public Label getNewLabel(String prefix) {
        return new Label(prefix, this.nextLabelIndex++);
    }

    public Label getNewLabel() {
        return this.getNewLabel("LBL");
    }

    public Collection<IRClosure> getClosures() {
        return this.nestedClosures == null ? NO_CLOSURES : this.nestedClosures;
    }

    public IRManager getManager() {
        return this.manager;
    }

    public void setIsMaybeUsingRefinements() {
        this.maybeUsingRefinements = true;
    }

    public boolean parentMaybeUsingRefinements() {
        for (IRScope s2 = this; s2 != null; s2 = s2.getLexicalParent()) {
            if (s2.maybeUsingRefinements()) {
                return true;
            }
            if (!(s2 instanceof IREvalScript)) continue;
            return false;
        }
        return false;
    }

    public boolean maybeUsingRefinements() {
        return this.maybeUsingRefinements;
    }

    public IRScope getLexicalParent() {
        return this.lexicalParent;
    }

    @Override
    public StaticScope getStaticScope() {
        return this.staticScope;
    }

    public boolean isWithinEND() {
        for (IRScope current2 = this; current2 != null && current2 instanceof IRClosure; current2 = current2.getLexicalParent()) {
            if (!((IRClosure)current2).isEND()) continue;
            return true;
        }
        return false;
    }

    public IRMethod getNearestMethod() {
        IRScope current2;
        for (current2 = this; current2 != null && !(current2 instanceof IRMethod); current2 = current2.getLexicalParent()) {
        }
        return (IRMethod)current2;
    }

    public IRScope getNearestTopLocalVariableScope() {
        IRScope current2;
        for (current2 = this; current2 != null && !current2.isTopLocalVariableScope(); current2 = current2.getLexicalParent()) {
        }
        return current2;
    }

    public boolean isScopeContainedBy(IRScope parentScope) {
        for (IRScope current2 = this; current2 != null; current2 = current2.getLexicalParent()) {
            if (parentScope != current2) continue;
            return true;
        }
        return false;
    }

    public int getNearestModuleReferencingScopeDepth() {
        int n = 0;
        IRScope current2 = this;
        while (!(current2 instanceof IRModuleBody)) {
            if (current2 == null || current2 instanceof IREvalScript) {
                return -1;
            }
            if ((current2 = current2.getLexicalParent()) instanceof IRFor) continue;
            ++n;
        }
        return n;
    }

    public String getId() {
        return this.getName().idString();
    }

    public RubySymbol getName() {
        return this.getManager().getRuntime().newSymbol(this.name);
    }

    public ByteList getByteName() {
        return this.name;
    }

    public void setByteName(ByteList name2) {
        this.name = name2;
    }

    public void setFileName(String filename2) {
        this.getRootLexicalScope().setFileName(filename2);
    }

    @Deprecated
    public String getFileName() {
        return this.getFile();
    }

    @Override
    public String getFile() {
        return this.getRootLexicalScope().getFile();
    }

    @Deprecated
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public int getLine() {
        return this.lineNumber;
    }

    public IRScope getRootLexicalScope() {
        IRScope current2;
        for (current2 = this; current2 != null && !current2.isScriptScope(); current2 = current2.getLexicalParent()) {
        }
        return current2;
    }

    public boolean isNestedInClosure(IRClosure closure) {
        for (IRScope s2 = this; s2 != null && !s2.isTopLocalVariableScope(); s2 = s2.getLexicalParent()) {
            if (s2 != closure) continue;
            return true;
        }
        return false;
    }

    public void setHasBreakInstructions() {
        this.hasBreakInstructions = true;
    }

    public boolean hasBreakInstructions() {
        return this.hasBreakInstructions;
    }

    public void setReceivesKeywordArgs() {
        this.receivesKeywordArgs = true;
    }

    public boolean receivesKeywordArgs() {
        return this.receivesKeywordArgs;
    }

    public void setReceivesClosureArg() {
        this.receivesClosureArg = true;
    }

    public boolean receivesClosureArg() {
        return this.receivesClosureArg;
    }

    public void setAccessesParentsLocalVariables() {
        this.accessesParentsLocalVariables = true;
    }

    public boolean accessesParentsLocalVariables() {
        return this.accessesParentsLocalVariables;
    }

    public void setHasLoops() {
        this.hasLoops = true;
    }

    public boolean hasLoops() {
        return this.hasLoops;
    }

    public void setHasNonLocalReturns() {
        this.hasNonLocalReturns = true;
    }

    public boolean hasNonLocalReturns() {
        return this.hasNonLocalReturns;
    }

    public void setCanCaptureCallersBinding() {
        this.canCaptureCallersBinding = true;
    }

    public boolean canCaptureCallersBinding() {
        return this.canCaptureCallersBinding;
    }

    public void setCanReceiveBreaks() {
        this.canReceiveBreaks = true;
    }

    public boolean canReceiveBreaks() {
        return this.canReceiveBreaks;
    }

    public void setCanReceiveNonlocalReturns() {
        this.canReceiveNonLocalReturns = true;
    }

    public boolean canReceiveNonlocalReturns() {
        return this.canReceiveNonLocalReturns;
    }

    public void setUsesEval() {
        this.usesEval = true;
    }

    public boolean usesEval() {
        return this.usesEval;
    }

    public void setUsesZSuper() {
        this.usesZSuper = true;
    }

    public boolean usesZSuper() {
        return this.usesZSuper;
    }

    public void setNeedsCodeCoverage() {
        this.needsCodeCoverage = true;
    }

    public boolean needsCodeCoverage() {
        return this.needsCodeCoverage;
    }

    public List<CompilerPass> getExecutedPasses() {
        return this.fullInterpreterContext == null ? new ArrayList(1) : this.fullInterpreterContext.getExecutedPasses();
    }

    private void runCompilerPasses(FullInterpreterContext fic, List<CompilerPass> passes, IGVDumper dumper) {
        if (dumper != null) {
            dumper.dump(fic.getCFG(), "Start");
        }
        CompilerPassScheduler scheduler = IRManager.schedulePasses(passes);
        for (CompilerPass pass2 : scheduler) {
            pass2.run(fic);
            if (dumper == null) continue;
            dumper.dump(fic.getCFG(), pass2.getShortLabel());
        }
        if (RubyInstanceConfig.IR_UNBOXING) {
            UnboxingPass pass3 = new UnboxingPass();
            pass3.run(fic);
            if (dumper != null) {
                dumper.dump(fic.getCFG(), pass3.getShortLabel());
            }
        }
        if (dumper != null) {
            dumper.close();
        }
    }

    public InterpreterContext allocateInterpreterContext(List<Instr> instructions, int tempVariableCount, EnumSet<IRFlags> flags2) {
        this.interpreterContext = new InterpreterContext(this, instructions, tempVariableCount, flags2);
        if (RubyInstanceConfig.IR_COMPILER_DEBUG) {
            LOG.info(this.interpreterContext.toString(), new Object[0]);
        }
        return this.interpreterContext;
    }

    public InterpreterContext allocateInterpreterContext(Supplier<List<Instr>> instructions, int tempVariableCount, EnumSet<IRFlags> flags2) {
        this.interpreterContext = new InterpreterContext(this, instructions, tempVariableCount, flags2);
        if (RubyInstanceConfig.IR_COMPILER_DEBUG) {
            LOG.info(this.interpreterContext.toString(), new Object[0]);
        }
        return this.interpreterContext;
    }

    private Instr[] cloneInstrs() {
        SimpleCloneInfo cloneInfo = new SimpleCloneInfo(this, false);
        Instr[] instructions = this.interpreterContext.getInstructions();
        int length2 = instructions.length;
        Instr[] newInstructions = new Instr[length2];
        for (int i2 = 0; i2 < length2; ++i2) {
            newInstructions[i2] = instructions[i2].clone(cloneInfo);
        }
        return newInstructions;
    }

    public synchronized FullInterpreterContext prepareFullBuild() {
        if (this.optimizedInterpreterContext != null) {
            return this.optimizedInterpreterContext;
        }
        if (this.fullInterpreterContext != null) {
            return this.fullInterpreterContext;
        }
        for (IRScope iRScope : this.getClosures()) {
            iRScope.prepareFullBuild();
        }
        FullInterpreterContext fic = new FullInterpreterContext(this, this.cloneInstrs(), this.interpreterContext.getTemporaryVariableCount(), (EnumSet<IRFlags>)this.interpreterContext.getFlags().clone());
        this.runCompilerPasses(fic, this.getManager().getCompilerPasses(this), this.dumpToIGV());
        this.getManager().optimizeIfSimpleScope(fic);
        new AddCallProtocolInstructions().run(fic);
        fic.generateInstructionsForInterpretation();
        this.fullInterpreterContext = fic;
        return fic;
    }

    public String getFullyQualifiedName() {
        if (this.getLexicalParent() == null) {
            return this.getId();
        }
        return this.getLexicalParent().getFullyQualifiedName() + "::" + this.getId();
    }

    public IGVDumper dumpToIGV() {
        String spec;
        if (RubyInstanceConfig.IR_DEBUG_IGV != null && ((spec = RubyInstanceConfig.IR_DEBUG_IGV).contains(":") && spec.equals(this.getFileName() + ":" + this.getLineNumber()) || spec.equals(this.getFileName()))) {
            return new IGVDumper(this.getFullyQualifiedName() + "; line " + this.getLineNumber());
        }
        return null;
    }

    public synchronized BasicBlock[] prepareForCompilation() {
        if (this.optimizedInterpreterContext != null) {
            return this.optimizedInterpreterContext.getLinearizedBBList();
        }
        if (this.fullInterpreterContext != null) {
            return this.fullInterpreterContext.getLinearizedBBList();
        }
        for (IRScope iRScope : this.getClosures()) {
            iRScope.prepareForCompilation();
        }
        FullInterpreterContext fic = new FullInterpreterContext(this, this.cloneInstrs(), this.interpreterContext.getTemporaryVariableCount(), (EnumSet<IRFlags>)this.interpreterContext.getFlags().clone());
        this.runCompilerPasses(fic, this.getManager().getJITPasses(this), this.dumpToIGV());
        BasicBlock[] basicBlockArray = fic.linearizeBasicBlocks();
        this.fullInterpreterContext = fic;
        return basicBlockArray;
    }

    public Map<BasicBlock, Label> buildJVMExceptionTable(FullInterpreterContext fic) {
        HashMap<BasicBlock, Label> map2 = new HashMap<BasicBlock, Label>(1);
        for (BasicBlock bb : fic.getLinearizedBBList()) {
            BasicBlock rescueBB = fic.getCFG().getRescuerBBFor(bb);
            if (rescueBB == null) continue;
            map2.put(bb, rescueBB.getLabel());
        }
        return map2;
    }

    public abstract IRScopeType getScopeType();

    public String toString() {
        return String.valueOf((Object)this.getScopeType()) + ' ' + this.getId() + '[' + this.getFile() + ':' + this.getLine() + "]<" + this.toStringCompileForm() + ">";
    }

    public String toStringCompileForm() {
        return this.optimizedInterpreterContext != null ? "optimized" : (this.fullInterpreterContext != null ? "full" : "startup");
    }

    public String debugOutput() {
        return this.toStringInstrs();
    }

    public String toStringInstrs() {
        if (this.fullInterpreterContext != null) {
            return "Instructions:\n" + this.fullInterpreterContext.toStringInstrs();
        }
        return this.interpreterContext.toStringInstrs();
    }

    public Variable getSelf() {
        return Self.SELF;
    }

    public Map<RubySymbol, LocalVariable> getLocalVariables() {
        return this.localVars;
    }

    public void setNextLabelIndex(int index2) {
        this.nextLabelIndex = index2;
    }

    public int getNextLabelIndex() {
        return this.nextLabelIndex;
    }

    public LocalVariable lookupExistingLVar(RubySymbol name2) {
        return this.localVars.get(name2);
    }

    protected LocalVariable findExistingLocalVariable(RubySymbol name2, int depth) {
        return this.localVars.get(name2);
    }

    public LocalVariable getLocalVariable(RubySymbol name2, int scopeDepth) {
        LocalVariable lvar = this.findExistingLocalVariable(name2, scopeDepth);
        if (lvar == null) {
            lvar = this.getNewLocalVariable(name2, scopeDepth);
        } else if (lvar.getScopeDepth() != scopeDepth) {
            lvar = lvar.cloneForDepth(scopeDepth);
        }
        return lvar;
    }

    public LocalVariable getNewLocalVariable(RubySymbol name2, int scopeDepth) {
        assert (scopeDepth == 0) : "Scope depth is non-zero for new-var request " + name2 + " in " + this;
        LocalVariable lvar = new LocalVariable(name2, scopeDepth, this.getStaticScope().addVariable(name2.idString()));
        this.localVars.put(name2, lvar);
        return lvar;
    }

    public boolean hasBeenBuilt() {
        return true;
    }

    public FullInterpreterContext getExecutionContext() {
        return this.fullInterpreterContext;
    }

    public InterpreterContext getInterpreterContext() {
        return this.interpreterContext;
    }

    public FullInterpreterContext getFullInterpreterContext() {
        return this.fullInterpreterContext;
    }

    public FullInterpreterContext getOptimizedInterpreterContext() {
        return this.optimizedInterpreterContext;
    }

    protected void depends(Object obj) {
        assert (obj != null) : "Unsatisfied dependency and this depends() was set up wrong.  Use depends(build()) not depends(build).";
    }

    private FullInterpreterContext inlineFailed(String reason2) {
        this.inlineFailed = reason2;
        return null;
    }

    private FullInterpreterContext inlineMethodCommon(IRMethod methodToInline, RubyModule implClass, long callsiteId, int classToken, boolean cloneHost) {
        CallBase call2;
        FullInterpreterContext newContext;
        this.alreadyHasInline = true;
        if (this.getFullInterpreterContext() == null) {
            this.prepareFullBuild();
        }
        if (!methodToInline.getClosures().isEmpty()) {
            boolean accessInaccessibleLocalVariables = false;
            for (IRClosure closure : methodToInline.getClosures()) {
                if (!closure.accessesParentsLocalVariables()) continue;
                accessInaccessibleLocalVariables = true;
                break;
            }
            if (accessInaccessibleLocalVariables) {
                return this.inlineFailed("inline a method which contains nested closures which access methods lvars");
            }
        }
        if ((newContext = this.getFullInterpreterContext().duplicate()) == null) {
            return this.inlineFailed("FIXME: BBs are not linearized???");
        }
        BasicBlock basicBlock = newContext.findBasicBlockOf(callsiteId);
        String error2 = new CFGInliner(newContext).inlineMethod(methodToInline, implClass, classToken, basicBlock, call2 = (CallBase)basicBlock.siteOf(callsiteId), cloneHost);
        return error2 == null ? newContext : this.inlineFailed(error2);
    }

    public void inlineMethod(IRMethod methodToInline, RubyModule metaclass, long callsiteId, int classToken, boolean cloneHost) {
        if (this.alreadyHasInline) {
            return;
        }
        FullInterpreterContext newContext = this.inlineMethodCommon(methodToInline, metaclass, callsiteId, classToken, cloneHost);
        if (newContext == null) {
            if (IRManager.IR_INLINER_VERBOSE) {
                LOG.info("Inline of " + methodToInline + " into " + this + " failed: " + this.inlineFailed + ".", new Object[0]);
            }
            return;
        }
        if (IRManager.IR_INLINER_VERBOSE) {
            LOG.info("Inline of " + methodToInline + " into " + this + " succeeded.", new Object[0]);
        }
        newContext.generateInstructionsForInterpretation();
        this.optimizedInterpreterContext = newContext;
        this.manager.getRuntime().getJITCompiler().getTaskFor(this.manager.getRuntime().getCurrentContext(), this.compilable).run();
    }

    public void inlineMethodJIT(IRMethod methodToInline, RubyModule implClass, long callsiteId, int classToken, boolean cloneHost) {
        if (this.alreadyHasInline) {
            return;
        }
        FullInterpreterContext newContext = this.inlineMethodCommon(methodToInline, implClass, callsiteId, classToken, cloneHost);
        Ruby runtime2 = this.manager.getRuntime();
        if (newContext == null) {
            if (IRManager.IR_INLINER_VERBOSE) {
                LOG.info("Inline of " + methodToInline + " into " + this + " failed: " + this.inlineFailed + ".", new Object[0]);
            }
            runtime2.getInlineStats().incrementInlineFailedCount();
            return;
        }
        if (IRManager.IR_INLINER_VERBOSE) {
            LOG.info("Inline of " + methodToInline + " into " + this + " succeeded.", new Object[0]);
        }
        runtime2.getInlineStats().incrementInlineSuccessCount();
        newContext.linearizeBasicBlocks();
        this.optimizedInterpreterContext = newContext;
        runtime2.getJITCompiler().getTaskFor(this.manager.getRuntime().getCurrentContext(), this.compilable).run();
    }

    public void inlineMethodCompiled(IRMethod methodToInline, RubyModule implClass, long callsiteId, int classToken, boolean cloneHost) {
        if (this.alreadyHasInline) {
            return;
        }
        FullInterpreterContext newContext = this.inlineMethodCommon(methodToInline, implClass, callsiteId, classToken, cloneHost);
        if (newContext == null) {
            if (IRManager.IR_INLINER_VERBOSE) {
                LOG.info("Inline of " + methodToInline + " into " + this + " failed: " + this.inlineFailed + ".", new Object[0]);
            }
            return;
        }
        if (IRManager.IR_INLINER_VERBOSE) {
            LOG.info("Inline of " + methodToInline + " into " + this + " succeeded.", new Object[0]);
        }
        newContext.linearizeBasicBlocks();
        this.optimizedInterpreterContext = newContext;
        this.manager.getRuntime().getJITCompiler().getTaskFor(this.manager.getRuntime().getCurrentContext(), this.compilable).run();
    }

    public int getNextClosureId() {
        ++this.nextClosureIndex;
        return this.nextClosureIndex;
    }

    public boolean isModuleBody() {
        return false;
    }

    public boolean isNonSingletonClassBody() {
        return false;
    }

    public boolean isTopLocalVariableScope() {
        return true;
    }

    public boolean isScriptScope() {
        return false;
    }

    public boolean inliningAllowed() {
        return !this.alreadyHasInline;
    }

    public void captureParentRefinements(ThreadContext context) {
        if (this.maybeUsingRefinements()) {
            for (IRScope cur = this.getLexicalParent(); cur != null; cur = cur.getLexicalParent()) {
                RubyModule overlay = cur.staticScope.getOverlayModuleForRead();
                if (overlay == null || overlay.getRefinements().isEmpty()) continue;
                RubyModule myOverlay = this.staticScope.getOverlayModuleForWrite(context);
                myOverlay.getRefinementsForWrite().putAll(overlay.getRefinements());
                break;
            }
        }
    }

    public void cleanupAfterExecution() {
    }

    public boolean executesOnce() {
        return false;
    }

    public void persistScopeHeader(IRWriterEncoder file2) {
        if (RubyInstanceConfig.IR_WRITING_DEBUG) {
            System.out.println("IRScopeType = " + (Object)((Object)this.getScopeType()));
        }
        file2.encode(this.getScopeType());
        if (RubyInstanceConfig.IR_WRITING_DEBUG) {
            System.out.println("Line # = " + this.getLine());
        }
        file2.encode(this.getLine());
        if (RubyInstanceConfig.IR_WRITING_DEBUG) {
            System.out.println("# of temp vars = " + this.getInterpreterContext().getTemporaryVariableCount());
        }
        file2.encode(this.getInterpreterContext().getTemporaryVariableCount());
        file2.encode(this.getNextLabelIndex());
    }

    public void persistScopeFlags(IRWriterEncoder file2) {
        file2.encode(this.getInterpreterContext().getFlags());
        file2.encode(this.hasBreakInstructions());
        file2.encode(this.hasLoops());
        file2.encode(this.hasNonLocalReturns());
        file2.encode(this.receivesClosureArg());
        file2.encode(this.receivesKeywordArgs());
        file2.encode(this.accessesParentsLocalVariables());
        file2.encode(this.maybeUsingRefinements());
        file2.encode(this.canCaptureCallersBinding());
        file2.encode(this.canReceiveBreaks());
        file2.encode(this.canReceiveNonlocalReturns());
        file2.encode(this.usesZSuper());
        file2.encode(this.needsCodeCoverage());
        file2.encode(this.usesEval());
    }

    public static EnumSet<IRFlags> allocateInitialFlags(IRScope scope) {
        if (scope instanceof IREvalScript || scope instanceof IRScriptBody) {
            return EnumSet.of(IRFlags.BINDING_HAS_ESCAPED);
        }
        return EnumSet.noneOf(IRFlags.class);
    }
}

