/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ViewportUI;
import org.openide.explorer.propertysheet.PropUtils;

class MarginViewportUI
extends ViewportUI
implements ComponentListener,
ContainerListener {
    private JViewport viewport;
    private int lastHeight = -1;
    private int stringWidth = -1;
    private int stringHeight = -1;
    private int ascent = -1;
    Rectangle scratch = new Rectangle();
    private String emptyString = "THIS IS A BUG";
    Color marginColor = UIManager.getColor("controlShadow");
    private int marginWidth = PropUtils.getMarginWidth();
    private boolean marginPainted = false;
    Dimension lastKnownSize = new Dimension();

    private MarginViewportUI(JViewport jViewport) {
        this.viewport = jViewport;
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new MarginViewportUI((JViewport)jComponent);
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        Color color = UIManager.getColor("controlShadow");
        if (color == null) {
            color = Color.LIGHT_GRAY;
        }
        jComponent.setForeground(color);
        Color color2 = UIManager.getColor("Tree.background");
        if (color2 == null) {
            color2 = Color.WHITE;
        }
        jComponent.setBackground(color2);
        Font font = UIManager.getFont("Tree.font");
        if (font == null) {
            font = UIManager.getFont("controlFont");
        }
        if (font != null) {
            jComponent.setFont(font);
        }
        jComponent.addContainerListener(this);
        Component[] componentArray = jComponent.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            componentArray[i].addComponentListener(this);
        }
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        JViewport jViewport = (JViewport)jComponent;
        Component[] componentArray = jViewport.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            componentArray[i].removeComponentListener(this);
        }
        jViewport.removeContainerListener(this);
    }

    public void setEmptyString(String string) {
        this.emptyString = string;
        this.stringWidth = -1;
        this.stringHeight = -1;
    }

    public void setMarginColor(Color color) {
        this.marginColor = color;
    }

    public void setMarginWidth(int n) {
        this.marginWidth = n;
    }

    public void setMarginPainted(boolean bl) {
        if (this.marginPainted != bl) {
            this.marginPainted = bl;
            this.viewport.repaint();
        }
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        Component component = ((JViewport)jComponent).getView();
        if (component != null) {
            this.lastKnownSize = component.getSize();
        }
        if (this.stringWidth == -1) {
            this.calcStringSizes(jComponent.getFont(), graphics);
        }
        if (this.shouldPaintEmptyMessage()) {
            graphics.setFont(jComponent.getFont());
            graphics.setColor(jComponent.getForeground());
            Rectangle rectangle = this.getEmptyMessageBounds();
            if (graphics.hitClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height)) {
                graphics.drawString(this.emptyString, rectangle.x, rectangle.y + this.ascent);
            }
        }
    }

    private void calcStringSizes(Font font, Graphics graphics) {
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        this.stringWidth = fontMetrics.stringWidth(this.emptyString);
        this.stringHeight = fontMetrics.getHeight();
        this.ascent = fontMetrics.getMaxAscent();
    }

    private Rectangle getEmptyMessageBounds() {
        Insets insets = this.viewport.getInsets();
        this.scratch.x = insets.left + ((this.viewport.getWidth() - (insets.left + insets.right)) / 2 - this.stringWidth / 2);
        this.scratch.y = insets.top + ((this.viewport.getHeight() - (insets.top + insets.bottom)) / 2 - this.stringHeight / 2);
        this.scratch.width = this.stringWidth;
        this.scratch.height = this.stringHeight;
        return this.scratch;
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        graphics.setColor(jComponent.getBackground());
        boolean bl = this.shouldPaintMargin();
        int n = bl ? this.marginWidth : 0;
        graphics.fillRect(n, 0, jComponent.getWidth() - n, jComponent.getHeight());
        if (bl) {
            graphics.setColor(this.marginColor);
            graphics.fillRect(0, 0, this.marginWidth, jComponent.getHeight());
        }
        this.paint(graphics, jComponent);
    }

    private void scheduleRepaint(Dimension dimension) {
        int n;
        if (this.marginPainted || dimension.height > 10 == this.lastKnownSize.height > 10) {
            // empty if block
        }
        if ((n = Math.abs(dimension.height - this.lastKnownSize.height)) == 0) {
            // empty if block
        }
        Insets insets = this.viewport.getInsets();
        this.viewport.repaint(insets.left, insets.top, this.marginWidth, this.viewport.getHeight() - (insets.top + insets.bottom));
        Rectangle rectangle = this.getEmptyMessageBounds();
        this.viewport.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    private boolean shouldPaintEmptyMessage() {
        Dimension dimension = this.viewport.getView().getSize();
        return dimension.height < 10;
    }

    private boolean shouldPaintMargin() {
        return this.marginPainted & !this.shouldPaintEmptyMessage();
    }

    @Override
    public void componentAdded(ContainerEvent containerEvent) {
        containerEvent.getChild().addComponentListener(this);
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentRemoved(ContainerEvent containerEvent) {
        containerEvent.getChild().removeComponentListener(this);
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        this.scheduleRepaint(((Component)componentEvent.getSource()).getSize());
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
        this.scheduleRepaint(((Component)componentEvent.getSource()).getSize());
    }
}

