/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.wireprotocol;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.graalvm.visualvm.lib.jfluid.wireprotocol.Command;

public class RootClassLoadedCommand
extends Command {
    private int[] allLoadedClassLoaderIds;
    private String[] allLoadedClassNames;
    private byte[][] cachedClassFileBytes;
    private int[] allLoadedClassesSuper;
    private int[][] allLoadedClassesInterfaces;
    private int[] parentLoaderIds;
    private int classCount;

    public RootClassLoadedCommand(String[] allLoadedClassNames, int[] loaderIds, byte[][] cachedClassFileBytes, int[] loadedClassesSuper, int[][] loadedClassesInterfaces, int classCount, int[] parentLoaderIds) {
        super(17);
        this.allLoadedClassNames = allLoadedClassNames;
        this.allLoadedClassLoaderIds = loaderIds;
        this.cachedClassFileBytes = cachedClassFileBytes;
        this.allLoadedClassesSuper = loadedClassesSuper;
        this.allLoadedClassesInterfaces = loadedClassesInterfaces;
        this.classCount = classCount;
        this.parentLoaderIds = parentLoaderIds;
    }

    RootClassLoadedCommand() {
        super(17);
    }

    public int[] getAllLoadedClassLoaderIds() {
        return this.allLoadedClassLoaderIds;
    }

    public String[] getAllLoadedClassNames() {
        return this.allLoadedClassNames;
    }

    public byte[][] getCachedClassFileBytes() {
        byte[][] res = this.cachedClassFileBytes;
        this.cachedClassFileBytes = null;
        return res;
    }

    public int[] getAllLoaderSuperClassIds() {
        return this.allLoadedClassesSuper;
    }

    public int[][] getAllLoadedInterfaceIds() {
        return this.allLoadedClassesInterfaces;
    }

    public int[] getParentLoaderIds() {
        int[] newParentLoaderIds = new int[this.parentLoaderIds.length];
        System.arraycopy(this.parentLoaderIds, 0, newParentLoaderIds, 0, this.parentLoaderIds.length);
        return newParentLoaderIds;
    }

    public String toString() {
        return "RootClassLoadedCommand, classes: " + this.classCount + ", " + super.toString();
    }

    void readObject(ObjectInputStream gin) throws IOException {
        int i;
        int i2;
        GZIPInputStream eix = new GZIPInputStream((InputStream)gin, 32768);
        ObjectInputStream in = new ObjectInputStream(eix);
        byte[] EMPTY = new byte[]{};
        this.classCount = in.readInt();
        this.allLoadedClassNames = new String[this.classCount];
        for (i2 = 0; i2 < this.classCount; ++i2) {
            this.allLoadedClassNames[i2] = in.readUTF().replace('.', '/').intern();
        }
        this.allLoadedClassLoaderIds = new int[this.classCount];
        for (i2 = 0; i2 < this.classCount; ++i2) {
            this.allLoadedClassLoaderIds[i2] = in.readInt();
        }
        int len = in.readInt();
        if (len == 0) {
            this.cachedClassFileBytes = null;
        } else {
            this.cachedClassFileBytes = new byte[len][];
            for (i = 0; i < len; ++i) {
                int bytesLen = in.readInt();
                if (bytesLen == -1) continue;
                if (bytesLen == 0) {
                    this.cachedClassFileBytes[i] = EMPTY;
                    continue;
                }
                this.cachedClassFileBytes[i] = new byte[bytesLen];
                in.readFully(this.cachedClassFileBytes[i]);
            }
        }
        this.allLoadedClassesSuper = new int[this.classCount];
        for (i = 0; i < this.classCount; ++i) {
            this.allLoadedClassesSuper[i] = in.readInt();
        }
        this.allLoadedClassesInterfaces = new int[this.classCount][];
        for (i = 0; i < this.classCount; ++i) {
            int ilen = in.readInt();
            this.allLoadedClassesInterfaces[i] = new int[ilen];
            for (int j = 0; j < ilen; ++j) {
                this.allLoadedClassesInterfaces[i][j] = in.readInt();
            }
        }
        len = in.readInt();
        this.parentLoaderIds = new int[len];
        for (i = 0; i < len; ++i) {
            this.parentLoaderIds[i] = in.readInt();
        }
    }

    void writeObject(ObjectOutputStream gout) throws IOException {
        int i;
        GZIPOutputStream eox = new GZIPOutputStream((OutputStream)gout, 32768);
        ObjectOutputStream out = new ObjectOutputStream(eox);
        out.writeInt(this.classCount);
        for (i = 0; i < this.classCount; ++i) {
            out.writeUTF(this.allLoadedClassNames[i]);
        }
        for (i = 0; i < this.classCount; ++i) {
            int loaderId = this.allLoadedClassLoaderIds[i];
            if (loaderId == -1) {
                loaderId = 0;
            }
            out.writeInt(loaderId);
        }
        if (this.cachedClassFileBytes == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.classCount);
            for (i = 0; i < this.classCount; ++i) {
                if (this.cachedClassFileBytes[i] == null) {
                    out.writeInt(-1);
                    continue;
                }
                out.writeInt(this.cachedClassFileBytes[i].length);
                if (this.cachedClassFileBytes[i].length <= 0) continue;
                out.write(this.cachedClassFileBytes[i]);
            }
        }
        for (i = 0; i < this.classCount; ++i) {
            out.writeInt(this.allLoadedClassesSuper[i]);
        }
        for (i = 0; i < this.classCount; ++i) {
            int[] ifacesIds = this.allLoadedClassesInterfaces[i];
            if (ifacesIds != null) {
                out.writeInt(ifacesIds.length);
                for (int j = 0; j < ifacesIds.length; ++j) {
                    out.writeInt(ifacesIds[j]);
                }
                continue;
            }
            out.writeInt(0);
        }
        out.writeInt(this.parentLoaderIds.length);
        for (i = 0; i < this.parentLoaderIds.length; ++i) {
            out.writeInt(this.parentLoaderIds[i]);
        }
        out.flush();
        eox.finish();
        this.allLoadedClassNames = null;
        this.allLoadedClassLoaderIds = null;
        this.cachedClassFileBytes = null;
        this.allLoadedClassesSuper = null;
        this.allLoadedClassesInterfaces = null;
        this.parentLoaderIds = null;
    }
}

