/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.bc;

import java.io.IOException;
import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.bcpg.ECDHPublicBCPGKey;
import org.bouncycastle.bcpg.MPInteger;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.EphemeralKeyPair;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.KeyEncoder;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.Wrapper;
import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.generators.EphemeralKeyPairGenerator;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.operator.PGPPad;
import org.bouncycastle.openpgp.operator.PublicKeyKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.RFC6637KDFCalculator;
import org.bouncycastle.openpgp.operator.bc.BcImplProvider;
import org.bouncycastle.openpgp.operator.bc.BcPGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.bc.BcPGPKeyConverter;
import org.bouncycastle.openpgp.operator.bc.BcUtil;

public class BcPublicKeyKeyEncryptionMethodGenerator
extends PublicKeyKeyEncryptionMethodGenerator {
    private SecureRandom random;
    private BcPGPKeyConverter keyConverter = new BcPGPKeyConverter();

    public BcPublicKeyKeyEncryptionMethodGenerator(PGPPublicKey pGPPublicKey) {
        super(pGPPublicKey);
    }

    public BcPublicKeyKeyEncryptionMethodGenerator setSecureRandom(SecureRandom secureRandom) {
        this.random = secureRandom;
        return this;
    }

    protected byte[] encryptSessionInfo(PGPPublicKey pGPPublicKey, byte[] byArray) throws PGPException {
        try {
            if (pGPPublicKey.getAlgorithm() != 18) {
                AsymmetricBlockCipher asymmetricBlockCipher = BcImplProvider.createPublicKeyCipher(pGPPublicKey.getAlgorithm());
                AsymmetricKeyParameter asymmetricKeyParameter = this.keyConverter.getPublicKey(pGPPublicKey);
                if (this.random == null) {
                    this.random = new SecureRandom();
                }
                asymmetricBlockCipher.init(true, (CipherParameters)new ParametersWithRandom((CipherParameters)asymmetricKeyParameter, this.random));
                return asymmetricBlockCipher.processBlock(byArray, 0, byArray.length);
            }
            ECDHPublicBCPGKey eCDHPublicBCPGKey = (ECDHPublicBCPGKey)pGPPublicKey.getPublicKeyPacket().getKey();
            X9ECParameters x9ECParameters = BcUtil.getX9Parameters(eCDHPublicBCPGKey.getCurveOID());
            ECDomainParameters eCDomainParameters = new ECDomainParameters(x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN());
            ECKeyPairGenerator eCKeyPairGenerator = new ECKeyPairGenerator();
            eCKeyPairGenerator.init((KeyGenerationParameters)new ECKeyGenerationParameters(eCDomainParameters, this.random));
            EphemeralKeyPairGenerator ephemeralKeyPairGenerator = new EphemeralKeyPairGenerator((AsymmetricCipherKeyPairGenerator)eCKeyPairGenerator, new KeyEncoder(){

                public byte[] getEncoded(AsymmetricKeyParameter asymmetricKeyParameter) {
                    return ((ECPublicKeyParameters)asymmetricKeyParameter).getQ().getEncoded(false);
                }
            });
            EphemeralKeyPair ephemeralKeyPair = ephemeralKeyPairGenerator.generate();
            ECPrivateKeyParameters eCPrivateKeyParameters = (ECPrivateKeyParameters)ephemeralKeyPair.getKeyPair().getPrivate();
            ECPoint eCPoint = BcUtil.decodePoint(eCDHPublicBCPGKey.getEncodedPoint(), x9ECParameters.getCurve()).multiply(eCPrivateKeyParameters.getD()).normalize();
            RFC6637KDFCalculator rFC6637KDFCalculator = new RFC6637KDFCalculator(new BcPGPDigestCalculatorProvider().get(eCDHPublicBCPGKey.getHashAlgorithm()), eCDHPublicBCPGKey.getSymmetricKeyAlgorithm());
            KeyParameter keyParameter = new KeyParameter(rFC6637KDFCalculator.createKey(eCDHPublicBCPGKey.getCurveOID(), eCPoint, pGPPublicKey.getFingerprint()));
            Wrapper wrapper = BcImplProvider.createWrapper(eCDHPublicBCPGKey.getSymmetricKeyAlgorithm());
            wrapper.init(true, (CipherParameters)new ParametersWithRandom((CipherParameters)keyParameter, this.random));
            byte[] byArray2 = PGPPad.padSessionData(byArray);
            byte[] byArray3 = wrapper.wrap(byArray2, 0, byArray2.length);
            byte[] byArray4 = new MPInteger(new BigInteger(1, ephemeralKeyPair.getEncodedPublicKey())).getEncoded();
            byte[] byArray5 = new byte[byArray4.length + 1 + byArray3.length];
            System.arraycopy(byArray4, 0, byArray5, 0, byArray4.length);
            byArray5[byArray4.length] = (byte)byArray3.length;
            System.arraycopy(byArray3, 0, byArray5, byArray4.length + 1, byArray3.length);
            return byArray5;
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new PGPException("exception encrypting session info: " + invalidCipherTextException.getMessage(), (Exception)((Object)invalidCipherTextException));
        }
        catch (IOException iOException) {
            throw new PGPException("exception encrypting session info: " + iOException.getMessage(), iOException);
        }
    }
}

