/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.parser;

import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.io.IOException;
import java.io.Reader;
import org.apache.batik.parser.ParseException;
import org.apache.batik.parser.PointsHandler;
import org.apache.batik.parser.PointsParser;
import org.apache.batik.parser.ShapeProducer;

public class AWTPolylineProducer
implements PointsHandler,
ShapeProducer {
    protected GeneralPath path;
    protected boolean newPath;
    protected int windingRule;

    public static Shape createShape(Reader reader, int n) throws IOException, ParseException {
        PointsParser pointsParser = new PointsParser();
        AWTPolylineProducer aWTPolylineProducer = new AWTPolylineProducer();
        aWTPolylineProducer.setWindingRule(n);
        pointsParser.setPointsHandler(aWTPolylineProducer);
        pointsParser.parse(reader);
        return aWTPolylineProducer.getShape();
    }

    @Override
    public void setWindingRule(int n) {
        this.windingRule = n;
    }

    @Override
    public int getWindingRule() {
        return this.windingRule;
    }

    @Override
    public Shape getShape() {
        return this.path;
    }

    @Override
    public void startPoints() throws ParseException {
        this.path = new GeneralPath(this.windingRule);
        this.newPath = true;
    }

    @Override
    public void point(float f, float f2) throws ParseException {
        if (this.newPath) {
            this.newPath = false;
            this.path.moveTo(f, f2);
        } else {
            this.path.lineTo(f, f2);
        }
    }

    @Override
    public void endPoints() throws ParseException {
    }
}

