/*
 * Decompiled with CFR 0.152.
 */
package processing.app.helpers;

public class Ticks {
    private final int tickCount;
    private final double[] ticks;
    private double tickMin;
    private double tickMax;
    private double tickStep;

    public Ticks(double min, double max, int tickCount) {
        double range = max - min;
        double exp = range == 0.0 ? 0.0 : Math.floor(Math.log10(range / (double)(tickCount - 1)));
        double scale = Math.pow(10.0, exp);
        double rawTickStep = range / (double)(tickCount - 1) / scale;
        for (double potentialStep : new double[]{1.0, 1.5, 2.0, 2.5, 3.0, 4.0, 5.0, 6.0, 8.0, 10.0}) {
            if (potentialStep < rawTickStep) continue;
            this.tickStep = potentialStep * scale;
            this.tickMin = this.tickStep * Math.floor(min / this.tickStep);
            this.tickMax = this.tickMin + this.tickStep * (double)(tickCount - 1);
            if (this.tickMax >= max) break;
        }
        this.tickCount = tickCount -= (int)Math.floor((this.tickMax - max) / this.tickStep);
        this.ticks = new double[tickCount];
        for (int i = 0; i < tickCount; ++i) {
            this.ticks[i] = this.tickMin + (double)i * this.tickStep;
        }
    }

    public double getTick(int i) {
        return this.ticks[i];
    }

    public int getTickCount() {
        return this.tickCount;
    }
}

