/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import processing.app.I18n;
import processing.app.helpers.PreferencesMap;
import processing.app.helpers.PreferencesMapException;
import processing.app.helpers.StringReplacer;

public class CompilerUtils {
    public File findCompiledSketch(PreferencesMap prefs) throws PreferencesMapException {
        List<String> paths = Arrays.asList("{build.path}/sketch/{build.project_name}.with_bootloader.hex", "{build.path}/sketch/{build.project_name}.hex", "{build.path}/{build.project_name}.with_bootloader.hex", "{build.path}/{build.project_name}.hex", "{build.path}/sketch/{build.project_name}.bin", "{build.path}/{build.project_name}.bin", "{build.path}/sketch/{build.project_name}.elf", "{build.path}/{build.project_name}.elf");
        Optional<File> sketch = paths.stream().map(path -> StringReplacer.replaceFromMapping(path, prefs)).map(File::new).filter(File::exists).findFirst();
        return sketch.orElseThrow(() -> new IllegalStateException(I18n.tr("No compiled sketch found")));
    }
}

