/*
 * Decompiled with CFR 0.152.
 */
package processing.app.debug;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import processing.app.debug.MessageConsumer;
import processing.app.debug.MessageSiphon;
import processing.app.debug.RunnerException;
import processing.app.helpers.PreferencesMap;
import processing.app.helpers.ProcessUtils;
import processing.app.helpers.StringReplacer;

public class Sizer
implements MessageConsumer {
    private long textSize;
    private long dataSize;
    private long eepromSize;
    private RunnerException exception;
    private PreferencesMap prefs;
    private String firstLine;
    private Pattern textPattern;
    private Pattern dataPattern;
    private Pattern eepromPattern;

    public Sizer(PreferencesMap _prefs) {
        this.prefs = _prefs;
        this.textPattern = Pattern.compile((String)this.prefs.get("recipe.size.regex"));
        this.dataPattern = null;
        String pref = (String)this.prefs.get("recipe.size.regex.data");
        if (pref != null) {
            this.dataPattern = Pattern.compile(pref);
        }
        this.eepromPattern = null;
        pref = (String)this.prefs.get("recipe.size.regex.eeprom");
        if (pref != null) {
            this.eepromPattern = Pattern.compile(pref);
        }
    }

    public long[] computeSize() throws RunnerException {
        int r = 0;
        try {
            String pattern = (String)this.prefs.get("recipe.size.pattern");
            String[] cmd = StringReplacer.formatAndSplit(pattern, this.prefs);
            this.exception = null;
            this.textSize = -1L;
            this.dataSize = -1L;
            this.eepromSize = -1L;
            Process process = ProcessUtils.exec(cmd);
            MessageSiphon in = new MessageSiphon(process.getInputStream(), this);
            MessageSiphon err = new MessageSiphon(process.getErrorStream(), this);
            boolean running = true;
            while (running) {
                try {
                    in.join();
                    err.join();
                    r = process.waitFor();
                    running = false;
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (Exception e) {
            this.exception = new RunnerException(e.toString() == null ? e.getClass().getName() + r : e.toString() + r);
        }
        if (this.exception != null) {
            throw this.exception;
        }
        if (this.textSize == -1L) {
            throw new RunnerException(this.firstLine);
        }
        return new long[]{this.textSize, this.dataSize, this.eepromSize};
    }

    @Override
    public void message(String s) {
        Matcher eepromMatcher;
        Matcher dataMatcher;
        Matcher textMatcher;
        if (this.firstLine == null) {
            this.firstLine = s;
        }
        if ((textMatcher = this.textPattern.matcher(s.trim())).matches()) {
            if (this.textSize < 0L) {
                this.textSize = 0L;
            }
            this.textSize += Long.parseLong(textMatcher.group(1));
        }
        if (this.dataPattern != null && (dataMatcher = this.dataPattern.matcher(s.trim())).matches()) {
            if (this.dataSize < 0L) {
                this.dataSize = 0L;
            }
            this.dataSize += Long.parseLong(dataMatcher.group(1));
        }
        if (this.eepromPattern != null && (eepromMatcher = this.eepromPattern.matcher(s.trim())).matches()) {
            if (this.eepromSize < 0L) {
                this.eepromSize = 0L;
            }
            this.eepromSize += Long.parseLong(eepromMatcher.group(1));
        }
    }
}

