"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const Parser = require("web-tree-sitter");
function initializeParser() {
    return __awaiter(this, void 0, void 0, function* () {
        yield Parser.init();
        const parser = new Parser();
        /**
         * See https://github.com/tree-sitter/tree-sitter/tree/master/lib/binding_web#generate-wasm-language-files
         *
         * To compile and use a new tree-sitter-bash version:
         *    cd server
         *    yarn add web-tree-sitter
         *    yarn add --dev tree-sitter-bash tree-sitter-cli
         *    npx tree-sitter build-wasm node_modules/tree-sitter-bash
         *
         * Note down the versions (from the package.json) below and then run
         *    yarn remove tree-sitter-bash tree-sitter-cli
         *
         * The current files was compiled with:
         * "tree-sitter-bash": "^0.19.0",
         * "tree-sitter-cli": "^0.20.0"
         */
        const lang = yield Parser.Language.load(`${__dirname}/../tree-sitter-bash.wasm`);
        parser.setLanguage(lang);
        return parser;
    });
}
exports.initializeParser = initializeParser;
//# sourceMappingURL=parser.js.map