/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.function.SingleNumericParameterFunction;
import tim.prune.gui.WholeNumberField;

public class ChooseSingleParameter
extends GenericFunction {
    private SingleNumericParameterFunction _parent = null;
    private JDialog _dialog = null;
    private JLabel _descLabel = null;
    private WholeNumberField _numberField = null;
    private JButton _okButton = null;

    public ChooseSingleParameter(App app, SingleNumericParameterFunction singleNumericParameterFunction) {
        super(app);
        this._parent = singleNumericParameterFunction;
    }

    @Override
    public String getNameKey() {
        return this._parent.getNameKey();
    }

    @Override
    public void begin() {
        if (this._dialog == null) {
            this._dialog = new JDialog(this._parentFrame, I18nManager.getText(this._parent.getNameKey()), true);
            this._dialog.setLocationRelativeTo(this._parentFrame);
            this._dialog.setDefaultCloseOperation(2);
            this._dialog.getContentPane().add(this.makeDialogComponents());
            this._dialog.pack();
        }
        this._descLabel.setText(I18nManager.getText(this._parent.getDescriptionKey()));
        int n = this._parent.getCurrentParamValue();
        if (n > 0) {
            this._numberField.setValue(n);
        } else {
            this._numberField.setText("");
        }
        this._dialog.setVisible(true);
        this.enableOkButton();
    }

    private JPanel makeDialogComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this._descLabel = new JLabel(I18nManager.getText(this._parent.getDescriptionKey()));
        jPanel.add((Component)this._descLabel, "North");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(8, 8));
        this._numberField = new WholeNumberField(4);
        jPanel2.add((Component)this._numberField, "North");
        jPanel.add((Component)jPanel2, "Center");
        this._numberField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ChooseSingleParameter.this.enableOkButton();
            }
        });
        this._numberField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                int n = keyEvent.getKeyCode();
                if (n == 27) {
                    ChooseSingleParameter.this._dialog.dispose();
                } else if (n == 10) {
                    ChooseSingleParameter.this.finish();
                }
                super.keyReleased(keyEvent);
            }
        });
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(2));
        this._okButton = new JButton(I18nManager.getText("button.ok"));
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ChooseSingleParameter.this.finish();
            }
        };
        this._okButton.addActionListener(actionListener);
        this._okButton.setEnabled(false);
        jPanel3.add(this._okButton);
        JButton jButton = new JButton(I18nManager.getText("button.cancel"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ChooseSingleParameter.this._dialog.dispose();
            }
        });
        jPanel3.add(jButton);
        jPanel.add((Component)jPanel3, "South");
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 15));
        return jPanel;
    }

    private void enableOkButton() {
        this._okButton.setEnabled(this._numberField.getValue() >= this._parent.getMinAllowedValue() && this._numberField.getValue() <= this._parent.getMaxAllowedValue());
    }

    private void finish() {
        if (this._numberField.getValue() >= this._parent.getMinAllowedValue() && this._numberField.getValue() <= this._parent.getMaxAllowedValue()) {
            this._parent.completeFunction(this._numberField.getValue());
            this._dialog.dispose();
        }
    }
}

