/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.data.Field;
import tim.prune.function.olc.OlcArea;
import tim.prune.function.olc.OlcDecoder;
import tim.prune.gui.GuiGridLayout;

public class PlusCodeFunction
extends GenericFunction {
    private JDialog _dialog = null;
    private JTextField _codeField = null;
    private JButton _okButton = null;

    public PlusCodeFunction(App app) {
        super(app);
    }

    @Override
    public String getNameKey() {
        return "function.enterpluscode";
    }

    @Override
    public void begin() {
        if (this._dialog == null) {
            this._dialog = new JDialog(this._parentFrame, I18nManager.getText(this.getNameKey()), true);
            this._dialog.setLocationRelativeTo(this._parentFrame);
            this._dialog.setDefaultCloseOperation(2);
            this._dialog.getContentPane().add(this.makeDialogComponents());
            this._dialog.pack();
        }
        this._codeField.setText("");
        this.enableOK();
        this._dialog.setVisible(true);
    }

    private Component makeDialogComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 10));
        jPanel.add((Component)new JLabel(I18nManager.getText("dialog.pluscode.desc")), "North");
        JPanel jPanel2 = new JPanel();
        GuiGridLayout guiGridLayout = new GuiGridLayout(jPanel2);
        this._codeField = new JTextField("", 12);
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                PlusCodeFunction.this.enableOK();
                if (keyEvent.getKeyCode() == 27) {
                    PlusCodeFunction.this._dialog.dispose();
                }
            }
        };
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                PlusCodeFunction.this.enableOK();
            }
        };
        this._codeField.addKeyListener(keyAdapter);
        this._codeField.addMouseListener(mouseAdapter);
        JLabel jLabel = new JLabel(I18nManager.getText("dialog.pluscode.code"));
        jLabel.setHorizontalAlignment(4);
        guiGridLayout.add(jLabel);
        guiGridLayout.add(this._codeField);
        jPanel.add((Component)jPanel2, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(2));
        this._okButton = new JButton(I18nManager.getText("button.ok"));
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (PlusCodeFunction.this._okButton.isEnabled()) {
                    PlusCodeFunction.this.finish();
                }
            }
        };
        this._okButton.addActionListener(actionListener);
        this._okButton.setEnabled(false);
        this._codeField.addActionListener(actionListener);
        jPanel3.add(this._okButton);
        JButton jButton = new JButton(I18nManager.getText("button.cancel"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PlusCodeFunction.this._dialog.dispose();
            }
        });
        jPanel3.add(jButton);
        jPanel.add((Component)jPanel3, "South");
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 15));
        return jPanel;
    }

    private void enableOK() {
        String string = this._codeField.getText();
        this._okButton.setEnabled(string != null && string.length() > 7 && string.indexOf(32) < 0 && string.indexOf(44) < 0);
    }

    private void finish() {
        OlcArea olcArea = OlcDecoder.decode(this._codeField.getText());
        if (olcArea == null) {
            JOptionPane.showMessageDialog(this._parentFrame, I18nManager.getText("dialog.pluscode.nothingfound"), I18nManager.getText(this.getNameKey()), 0);
        } else if (this.loadTrack(olcArea)) {
            this._dialog.dispose();
        }
    }

    private boolean loadTrack(OlcArea olcArea) {
        if (olcArea == null) {
            return false;
        }
        Field[] fieldArray = new Field[]{Field.LATITUDE, Field.LONGITUDE, Field.WAYPT_NAME};
        this._app.autoAppendNextFile();
        if (olcArea.minLat == olcArea.maxLat && olcArea.minLon == olcArea.maxLon) {
            Object[][] objectArray = new String[][]{new String[3]};
            objectArray[0][0] = "" + olcArea.minLat;
            objectArray[0][1] = "" + olcArea.minLon;
            objectArray[0][2] = this._codeField.getText();
            this._app.informDataLoaded(fieldArray, objectArray, null, null);
        } else {
            Object[][] objectArray = new String[6][];
            int n = 0;
            while (n < 5) {
                objectArray[n] = new String[3];
                objectArray[n][0] = "" + (n % 4 == 0 || n == 3 ? olcArea.minLat : olcArea.maxLat);
                objectArray[n][1] = "" + (n % 4 == 0 || n == 1 ? olcArea.minLon : olcArea.maxLon);
                objectArray[n][2] = null;
                ++n;
            }
            objectArray[5] = new String[3];
            objectArray[5][0] = "" + (olcArea.minLat + olcArea.maxLat) / 2.0;
            objectArray[5][1] = "" + (olcArea.minLon + olcArea.maxLon) / 2.0;
            objectArray[5][2] = this._codeField.getText();
            this._app.informDataLoaded(fieldArray, objectArray, null, null);
        }
        return true;
    }
}

