/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function;

import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.helpers.DefaultHandler;
import tim.prune.App;
import tim.prune.I18nManager;
import tim.prune.data.DataPoint;
import tim.prune.data.Field;
import tim.prune.data.Latitude;
import tim.prune.data.Longitude;
import tim.prune.function.OpenCachingDeXmlHandler;
import tim.prune.function.search.GenericDownloaderFunction;
import tim.prune.function.search.SearchResult;

public class SearchOpenCachingDeFunction
extends GenericDownloaderFunction {
    private static final int MAX_DISTANCE = 50;

    public SearchOpenCachingDeFunction(App app) {
        super(app);
    }

    @Override
    public String getNameKey() {
        return "function.searchopencachingde";
    }

    @Override
    protected String getColumnKey(int n) {
        if (n == 0) {
            return "dialog.wikipedia.column.name";
        }
        return "dialog.wikipedia.column.distance";
    }

    @Override
    public void run() {
        this._statusLabel.setText(I18nManager.getText("confirm.running"));
        DataPoint dataPoint = this._app.getTrackInfo().getCurrentPoint();
        if (dataPoint == null) {
            return;
        }
        double d = dataPoint.getLatitude().getDouble();
        double d2 = dataPoint.getLongitude().getDouble();
        this.submitSearch(d, d2);
        if (this._errorMessage == null && this._trackListModel.isEmpty()) {
            this._errorMessage = I18nManager.getText("dialog.geocaching.nonefound");
        }
        this._statusLabel.setText(this._errorMessage == null ? "" : this._errorMessage);
    }

    private void submitSearch(double d, double d2) {
        Object object;
        Serializable serializable;
        String string = "https://opencaching.de/search.php?searchto=searchbydistance&showresult=1&output=XML&sort=bydistance&lat=" + d + "&lon=" + d2 + "&distance=" + 50 + "&unit=km";
        OpenCachingDeXmlHandler openCachingDeXmlHandler = new OpenCachingDeXmlHandler();
        InputStream inputStream = null;
        try {
            serializable = new URL(string);
            object = SAXParserFactory.newInstance().newSAXParser();
            inputStream = serializable.openStream();
            ((SAXParser)object).parse(inputStream, (DefaultHandler)openCachingDeXmlHandler);
        }
        catch (Exception exception) {
            this._errorMessage = String.valueOf(exception.getClass().getName()) + " - " + exception.getMessage();
        }
        try {
            inputStream.close();
        }
        catch (Exception exception) {}
        serializable = openCachingDeXmlHandler.getTrackList();
        this._trackListModel.addTracks((ArrayList<SearchResult>)serializable);
        if (this._trackListModel.isEmpty() && (object = openCachingDeXmlHandler.getErrorMessage()) != null && !((String)object).equals("")) {
            this._app.showErrorMessageNoLookup(this.getNameKey(), (String)object);
            this._errorMessage = object;
        }
    }

    @Override
    protected void loadSelected() {
        int n = this._trackTable.getSelectedRowCount();
        if (n < 1) {
            return;
        }
        int[] nArray = this._trackTable.getSelectedRows();
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray[n2];
            if (n3 >= 0 && n3 < this._trackListModel.getRowCount()) {
                String string = this._trackListModel.getTrack(n3).getLatitude();
                String string2 = this._trackListModel.getTrack(n3).getLongitude();
                if (string != null && string2 != null) {
                    DataPoint dataPoint = new DataPoint(new Latitude(string), new Longitude(string2), null);
                    dataPoint.setFieldValue(Field.WAYPT_NAME, this._trackListModel.getTrack(n3).getTrackName(), false);
                    this._app.createPoint(dataPoint);
                }
            }
            ++n2;
        }
        this._cancelled = true;
        this._dialog.dispose();
    }
}

