/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.coor.conversion;

import java.util.ArrayList;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.tools.I18n;

public final class LatLonParser {
    public static final String SOUTH = I18n.trc("compass", "S");
    public static final String NORTH = I18n.trc("compass", "N");
    public static final String WEST = I18n.trc("compass", "W");
    public static final String EAST = I18n.trc("compass", "E");
    private static final char N_TR = NORTH.charAt(0);
    private static final char S_TR = SOUTH.charAt(0);
    private static final char E_TR = EAST.charAt(0);
    private static final char W_TR = WEST.charAt(0);
    private static final String DEG = "\u00b0";
    private static final String MIN = "\u2032";
    private static final String SEC = "\u2033";
    private static final Pattern P = Pattern.compile("([+|-]?\\d+[.,]\\d+)|([+|-]?\\d+)|(\u00b0|o|deg)|('|\u2032|min)|(\"|\u2033|sec)|([,;])|([NSEW" + N_TR + S_TR + E_TR + W_TR + "])|\\s+|(.+)", 2);
    private static final Pattern P_XML = Pattern.compile("lat=[\"']([+|-]?\\d+[.,]\\d+)[\"']\\s+lon=[\"']([+|-]?\\d+[.,]\\d+)[\"']");
    private static final String FLOAT = "(\\d+(\\.\\d*)?)";
    private static final String DMS = "(?<neg1>-)?(?=\\d)(?:(?<single>(\\d+(\\.\\d*)?))|((?<degree>(\\d+(\\.\\d*)?))d)?((?<minutes>(\\d+(\\.\\d*)?))')?((?<seconds>(\\d+(\\.\\d*)?))\")?)(?:[NE]|(?<neg2>[SW]))?";
    private static final Pattern P_DMS = Pattern.compile("^(?<neg1>-)?(?=\\d)(?:(?<single>(\\d+(\\.\\d*)?))|((?<degree>(\\d+(\\.\\d*)?))d)?((?<minutes>(\\d+(\\.\\d*)?))')?((?<seconds>(\\d+(\\.\\d*)?))\")?)(?:[NE]|(?<neg2>[SW]))?$");

    private LatLonParser() {
    }

    public static LatLon parse(String coord) {
        LatLonHolder latLon = new LatLonHolder();
        Matcher mXml = P_XML.matcher(coord);
        if (mXml.matches()) {
            LatLonParser.setLatLonObj(latLon, Double.valueOf(mXml.group(1).replace(',', '.')), 0.0, 0.0, "N", Double.valueOf(mXml.group(2).replace(',', '.')), 0.0, 0.0, "E");
        } else {
            Matcher m = P.matcher(coord);
            StringBuilder sb = new StringBuilder();
            ArrayList<Object> list = new ArrayList<Object>();
            while (m.find()) {
                if (m.group(1) != null) {
                    sb.append('R');
                    list.add(Double.valueOf(m.group(1).replace(',', '.')));
                    continue;
                }
                if (m.group(2) != null) {
                    sb.append('Z');
                    list.add(Double.valueOf(m.group(2)));
                    continue;
                }
                if (m.group(3) != null) {
                    sb.append('o');
                    continue;
                }
                if (m.group(4) != null) {
                    sb.append('\'');
                    continue;
                }
                if (m.group(5) != null) {
                    sb.append('\"');
                    continue;
                }
                if (m.group(6) != null) {
                    sb.append(',');
                    continue;
                }
                if (m.group(7) != null) {
                    sb.append('x');
                    String c = m.group(7).toUpperCase(Locale.ENGLISH);
                    if ("N".equalsIgnoreCase(c) || "S".equalsIgnoreCase(c) || "E".equalsIgnoreCase(c) || "W".equalsIgnoreCase(c)) {
                        list.add(c);
                        continue;
                    }
                    list.add(c.replace(N_TR, 'N').replace(S_TR, 'S').replace(E_TR, 'E').replace(W_TR, 'W'));
                    continue;
                }
                if (m.group(8) == null) continue;
                throw new IllegalArgumentException("invalid token: " + m.group(8));
            }
            String pattern = sb.toString();
            Object[] params = list.toArray();
            if (pattern.matches("Ro?,?Ro?")) {
                LatLonParser.setLatLonObj(latLon, params[0], 0.0, 0.0, "N", params[1], 0.0, 0.0, "E");
            } else if (pattern.matches("xRo?,?xRo?")) {
                LatLonParser.setLatLonObj(latLon, params[1], 0.0, 0.0, params[0], params[3], 0.0, 0.0, params[2]);
            } else if (pattern.matches("Ro?x,?Ro?x")) {
                LatLonParser.setLatLonObj(latLon, params[0], 0.0, 0.0, params[1], params[2], 0.0, 0.0, params[3]);
            } else if (pattern.matches("Zo[RZ]'?,?Zo[RZ]'?|Z[RZ],?Z[RZ]")) {
                LatLonParser.setLatLonObj(latLon, params[0], params[1], 0.0, "N", params[2], params[3], 0.0, "E");
            } else if (pattern.matches("xZo[RZ]'?,?xZo[RZ]'?|xZo?[RZ],?xZo?[RZ]")) {
                LatLonParser.setLatLonObj(latLon, params[1], params[2], 0.0, params[0], params[4], params[5], 0.0, params[3]);
            } else if (pattern.matches("Zo[RZ]'?x,?Zo[RZ]'?x|Zo?[RZ]x,?Zo?[RZ]x")) {
                LatLonParser.setLatLonObj(latLon, params[0], params[1], 0.0, params[2], params[3], params[4], 0.0, params[5]);
            } else if (pattern.matches("ZoZ'[RZ]\"?x,?ZoZ'[RZ]\"?x|ZZ[RZ]x,?ZZ[RZ]x")) {
                LatLonParser.setLatLonObj(latLon, params[0], params[1], params[2], params[3], params[4], params[5], params[6], params[7]);
            } else if (pattern.matches("xZoZ'[RZ]\"?,?xZoZ'[RZ]\"?|xZZ[RZ],?xZZ[RZ]")) {
                LatLonParser.setLatLonObj(latLon, params[1], params[2], params[3], params[0], params[5], params[6], params[7], params[4]);
            } else if (pattern.matches("ZZ[RZ],?ZZ[RZ]")) {
                LatLonParser.setLatLonObj(latLon, params[0], params[1], params[2], "N", params[3], params[4], params[5], "E");
            } else {
                throw new IllegalArgumentException("invalid format: " + pattern);
            }
        }
        return new LatLon(latLon.lat, latLon.lon);
    }

    private static void setLatLonObj(LatLonHolder latLon, Object coord1deg, Object coord1min, Object coord1sec, Object card1, Object coord2deg, Object coord2min, Object coord2sec, Object card2) {
        LatLonParser.setLatLon(latLon, (Double)coord1deg, (Double)coord1min, (Double)coord1sec, (String)card1, (Double)coord2deg, (Double)coord2min, (Double)coord2sec, (String)card2);
    }

    private static void setLatLon(LatLonHolder latLon, double coord1deg, double coord1min, double coord1sec, String card1, double coord2deg, double coord2min, double coord2sec, String card2) {
        LatLonParser.setLatLon(latLon, coord1deg, coord1min, coord1sec, card1);
        LatLonParser.setLatLon(latLon, coord2deg, coord2min, coord2sec, card2);
        if (Double.isNaN(latLon.lat) || Double.isNaN(latLon.lon)) {
            throw new IllegalArgumentException("invalid lat/lon parameters");
        }
    }

    private static void setLatLon(LatLonHolder latLon, double coordDeg, double coordMin, double coordSec, String card) {
        if (coordDeg < -180.0 || coordDeg > 180.0 || coordMin < 0.0 || coordMin >= 60.0 || coordSec < 0.0 || coordSec > 60.0) {
            throw new IllegalArgumentException("out of range");
        }
        double coord = (double)(coordDeg < 0.0 ? -1 : 1) * (Math.abs(coordDeg) + coordMin / 60.0 + coordSec / 3600.0);
        double d = coord = "N".equals(card) || "E".equals(card) ? coord : -coord;
        if ("N".equals(card) || "S".equals(card)) {
            latLon.lat = coord;
        } else {
            latLon.lon = coord;
        }
    }

    public static double parseCoordinate(String angleStr) {
        Matcher in = P_DMS.matcher(angleStr);
        if (!in.find()) {
            throw new IllegalArgumentException(I18n.tr("Unable to parse as coordinate value: ''{0}''", angleStr));
        }
        double value = 0.0;
        if (in.group("single") != null) {
            value += Double.parseDouble(in.group("single"));
        }
        if (in.group("degree") != null) {
            value += Double.parseDouble(in.group("degree"));
        }
        if (in.group("minutes") != null) {
            value += Double.parseDouble(in.group("minutes")) / 60.0;
        }
        if (in.group("seconds") != null) {
            value += Double.parseDouble(in.group("seconds")) / 3600.0;
        }
        if (in.group("neg1") != null ^ in.group("neg2") != null) {
            value = -value;
        }
        return value;
    }

    private static class LatLonHolder {
        private double lat = Double.NaN;
        private double lon = Double.NaN;

        private LatLonHolder() {
        }
    }
}

