/*
 * Decompiled with CFR 0.152.
 */
package mediathek.mac.touchbar;

import com.thizzer.jtouchbar.common.Image;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import jiconfont.icons.FontAwesome;
import jiconfont.swing.IconFontSwing;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class TouchBarUtils {
    private static final float TOUCHBAR_BUTTON_SIZE = 64.0f;
    private static final Logger logger = LogManager.getLogger();
    private static boolean TOUCHBAR_SUPPORTED;

    public static byte[] getImgBytes(@NotNull BufferedImage image) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, "PNG", baos);
        }
        catch (IOException ex) {
            System.out.println(ex.getMessage());
        }
        return baos.toByteArray();
    }

    public static Icon iconFromFontAwesome(FontAwesome glyph) {
        return IconFontSwing.buildIcon(glyph, 64.0f, Color.WHITE);
    }

    public static Image touchBarImageFromIcon(@NotNull Icon icon) {
        return new Image(TouchBarUtils.getImgBytes(TouchBarUtils.iconToImage(icon)));
    }

    public static Image touchBarImageFromFontAwesome(@NotNull FontAwesome glyph) {
        return TouchBarUtils.touchBarImageFromIcon(TouchBarUtils.iconFromFontAwesome(glyph));
    }

    public static BufferedImage iconToImage(@NotNull Icon icon) {
        BufferedImage image = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        Graphics2D g2 = image.createGraphics();
        icon.paintIcon(null, g2, 0, 0);
        g2.dispose();
        return image;
    }

    private static void checkTouchBarSupport() {
        logger.trace("checkTouchBarSupport");
        TOUCHBAR_SUPPORTED = false;
        try {
            Process process = Runtime.getRuntime().exec("bin/mv_touchbar_support");
            if (process.waitFor(2L, TimeUnit.SECONDS)) {
                TOUCHBAR_SUPPORTED = process.exitValue() == 0;
            }
        }
        catch (Exception e) {
            logger.error("Failed to check touchbar support", (Throwable)e);
        }
    }

    public static boolean isTouchBarSupported() {
        return TOUCHBAR_SUPPORTED;
    }

    static {
        TouchBarUtils.checkTouchBarSupport();
    }
}

