/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.wire;

import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOptional;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorSet;
import net.sourceforge.plantuml.ugraphic.color.NoSuchColorException;
import net.sourceforge.plantuml.wire.WireDiagram;

public class CommandComponent
extends SingleLineCommand2<WireDiagram> {
    public CommandComponent() {
        super(false, CommandComponent.getRegexConcat());
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandComponent.class.getName(), RegexLeaf.start(), new RegexLeaf("INDENT", "([\\s\\t]*)"), new RegexLeaf("\\*"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("NAME", "([\\w]+)"), new RegexOptional((IRegex)new RegexConcat(RegexLeaf.spaceOneOrMore(), new RegexLeaf("\\["), new RegexLeaf("WIDTH", "([\\d]+)"), new RegexLeaf("[x*]"), new RegexLeaf("HEIGHT", "([\\d]+)"), new RegexLeaf("\\]"))), new RegexOptional((IRegex)new RegexConcat(RegexLeaf.spaceZeroOrMore(), new RegexLeaf("COLOR", "(#\\w+)?"))), RegexLeaf.spaceZeroOrMore(), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(WireDiagram diagram, LineLocation location, RegexResult arg) throws NoSuchColorException {
        String indent = arg.get("INDENT", 0);
        String name = arg.get("NAME", 0);
        int width = 0;
        int height = 0;
        String widthString = arg.get("WIDTH", 0);
        String heightString = arg.get("HEIGHT", 0);
        if (widthString != null) {
            width = Integer.parseInt(widthString);
            height = Integer.parseInt(heightString);
        }
        String stringColor = arg.get("COLOR", 0);
        HColor color = null;
        if (stringColor != null) {
            color = HColorSet.instance().getColor(diagram.getSkinParam().getThemeStyle(), stringColor);
        }
        return diagram.addComponent(indent, name, width, height, color);
    }
}

