/*
 * Decompiled with CFR 0.152.
 */
package smetana.core;

import java.util.ArrayList;
import java.util.List;
import smetana.core.UnsupportedC;

public class CArray<O>
extends UnsupportedC {
    private final Class<O> cl;
    private final List<O> data;
    private final int offset;

    public String toString() {
        return "Array " + this.cl + " offset=" + this.offset + " [" + this.data.size() + "]" + this.data;
    }

    public static <O> CArray<O> ALLOC__(int size, Class<O> cl) {
        CArray result = new CArray(new ArrayList(), 0, cl);
        super.reallocWithStructure(size);
        return result;
    }

    public static <O> CArray<O> REALLOC__(int size, CArray<O> old, Class<O> cl) {
        if (old == null) {
            return CArray.ALLOC__(size, cl);
        }
        super.reallocWithStructure(size);
        return old;
    }

    private CArray(List<O> data, int offset, Class<O> cl) {
        if (offset > 0) {
            // empty if block
        }
        this.data = data;
        this.offset = offset;
        this.cl = cl;
    }

    public CArray<O> plus_(int delta) {
        return new CArray<O>(this.data, this.offset + delta, this.cl);
    }

    public int minus_(CArray<O> other) {
        if (this.data != other.data) {
            throw new IllegalArgumentException();
        }
        return this.offset - other.offset;
    }

    public O get__(int i) {
        return this.data.get(i + this.offset);
    }

    private void reallocWithStructure(int size) {
        if (this.offset != 0) {
            throw new IllegalStateException();
        }
        try {
            for (int i = 0; i < size; ++i) {
                this.data.add(this.cl.newInstance());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UnsupportedOperationException();
        }
    }
}

