/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.apps.svgbrowser;

import java.io.File;
import org.apache.batik.apps.svgbrowser.JSVGViewerFrame;
import org.apache.batik.apps.svgbrowser.SquiggleInputHandler;
import org.apache.batik.util.ParsedURL;

public class SVGInputHandler
implements SquiggleInputHandler {
    public static final String[] SVG_MIME_TYPES = new String[]{"image/svg+xml"};
    public static final String[] SVG_FILE_EXTENSIONS = new String[]{".svg", ".svgz"};

    public String[] getHandledMimeTypes() {
        return SVG_MIME_TYPES;
    }

    public String[] getHandledExtensions() {
        return SVG_FILE_EXTENSIONS;
    }

    public String getDescription() {
        return "";
    }

    public void handle(ParsedURL parsedURL, JSVGViewerFrame jSVGViewerFrame) {
        jSVGViewerFrame.getJSVGCanvas().loadSVGDocument(parsedURL.toString());
    }

    public boolean accept(File file) {
        return file != null && file.isFile() && this.accept(file.getPath());
    }

    public boolean accept(ParsedURL parsedURL) {
        if (parsedURL == null) {
            return false;
        }
        String string = parsedURL.getPath();
        if (string == null) {
            return false;
        }
        return this.accept(string);
    }

    public boolean accept(String string) {
        if (string == null) {
            return false;
        }
        for (int i = 0; i < SVG_FILE_EXTENSIONS.length; ++i) {
            if (!string.endsWith(SVG_FILE_EXTENSIONS[i])) continue;
            return true;
        }
        return false;
    }
}

