/*
 * Decompiled with CFR 0.152.
 */
package xsbt.boot.internal.shaded.coursier.cache;

import java.io.File;
import java.io.FilenameFilter;
import java.io.Serializable;
import java.net.URI;
import java.util.concurrent.ExecutorService;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.SeqFactory;
import scala.collection.SeqFactory$UnapplySeqWrapper$;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.collection.mutable.ArraySeq;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichChar$;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try$;
import xsbt.boot.internal.shaded.coursier.cache.CachePolicy;
import xsbt.boot.internal.shaded.coursier.cache.CachePolicy$LocalOnly$;
import xsbt.boot.internal.shaded.coursier.cache.CachePolicy$LocalUpdateChanging$;
import xsbt.boot.internal.shaded.coursier.cache.CachePolicy$Update$;
import xsbt.boot.internal.shaded.coursier.credentials.Credentials;
import xsbt.boot.internal.shaded.coursier.credentials.FileCredentials;
import xsbt.boot.internal.shaded.coursier.credentials.FileCredentials$;
import xsbt.boot.internal.shaded.coursier.parse.CachePolicyParser$;
import xsbt.boot.internal.shaded.coursier.parse.CredentialsParser$;
import xsbt.boot.internal.shaded.coursier.paths.CachePath;
import xsbt.boot.internal.shaded.coursier.paths.CoursierPaths;
import xsbt.boot.internal.shaded.coursier.util.Sync$;

public final class CacheDefaults$ {
    public static final CacheDefaults$ MODULE$ = new CacheDefaults$();
    private static File location;
    private static int concurrentDownloadCount;
    private static ExecutorService pool;
    private static Option<Duration> ttl;
    private static int sslRetryCount;
    private static Option<Object> maxRedirections;
    private static final Seq<Option<String>> checksums;
    private static final int bufferSize;
    private static final Seq<CachePolicy.Mixed> noEnvCachePolicies;
    private static volatile byte bitmap$0;

    static {
        checksums = new $colon$colon<Nothing$>((Nothing$)((Object)new Some<String>("SHA-1")), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)None$.MODULE$), Nil$.MODULE$));
        bufferSize = 0x100000;
        noEnvCachePolicies = new $colon$colon<Nothing$>((Nothing$)((Object)CachePolicy$LocalUpdateChanging$.MODULE$), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)CachePolicy$LocalOnly$.MODULE$), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)CachePolicy$Update$.MODULE$), Nil$.MODULE$)));
    }

    private File location$lzycompute() {
        CacheDefaults$ cacheDefaults$ = this;
        synchronized (cacheDefaults$) {
            if ((byte)(bitmap$0 & 1) == 0) {
                location = CachePath.defaultCacheDirectory();
                bitmap$0 = (byte)(bitmap$0 | 1);
            }
        }
        return location;
    }

    public final File location() {
        if ((byte)(bitmap$0 & 1) == 0) {
            return this.location$lzycompute();
        }
        return location;
    }

    private int defaultConcurrentDownloadCount() {
        return 6;
    }

    private int concurrentDownloadCount$lzycompute() {
        CacheDefaults$ cacheDefaults$ = this;
        synchronized (cacheDefaults$) {
            if ((byte)(bitmap$0 & 2) == 0) {
                concurrentDownloadCount = BoxesRunTime.unboxToInt(scala.sys.package$.MODULE$.props().get("xsbt.boot.internal.shaded.coursier.parallel-download-count").flatMap((Function1<String, Option> & Serializable)s -> {
                    String string;
                    return Try$.MODULE$.apply(() -> {
                        String string;
                        return StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(string));
                    }).toOption();
                }).getOrElse(() -> MODULE$.defaultConcurrentDownloadCount()));
                bitmap$0 = (byte)(bitmap$0 | 2);
            }
        }
        return concurrentDownloadCount;
    }

    public final int concurrentDownloadCount() {
        if ((byte)(bitmap$0 & 2) == 0) {
            return this.concurrentDownloadCount$lzycompute();
        }
        return concurrentDownloadCount;
    }

    private ExecutorService pool$lzycompute() {
        CacheDefaults$ cacheDefaults$ = this;
        synchronized (cacheDefaults$) {
            if ((byte)(bitmap$0 & 4) == 0) {
                pool = Sync$.MODULE$.fixedThreadPool(this.concurrentDownloadCount());
                bitmap$0 = (byte)(bitmap$0 | 4);
            }
        }
        return pool;
    }

    public final ExecutorService pool() {
        if ((byte)(bitmap$0 & 4) == 0) {
            return this.pool$lzycompute();
        }
        return pool;
    }

    public final Either<Throwable, Duration> parseDuration(String s) {
        Left left;
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString((String)((Object)s))) && StringOps$.MODULE$.forall$extension(Predef$.MODULE$.augmentString((String)((Object)s)), (Function1<Object, Object> & Serializable)x$1 -> BoxesRunTime.boxToBoolean(CacheDefaults$.$anonfun$parseDuration$1(BoxesRunTime.unboxToChar(x$1))))) {
            return package$.MODULE$.Right().apply(Duration$.MODULE$.Zero());
        }
        if ((s = Try$.MODULE$.apply(() -> CacheDefaults$.$anonfun$parseDuration$2((String)((Object)s)))) instanceof Success) {
            s = (Success)((Object)s);
            s = (Duration)((Success)((Object)s)).value();
            s = package$.MODULE$.Right().apply(s);
        } else if (s instanceof Failure) {
            s = (Failure)((Object)s);
            Throwable t = ((Failure)((Object)s)).exception();
            left = package$.MODULE$.Left().apply(left);
        } else {
            throw new MatchError(left);
        }
        return left;
    }

    private Option<Duration> ttl$lzycompute() {
        CacheDefaults$ cacheDefaults$ = this;
        synchronized (cacheDefaults$) {
            if ((byte)(bitmap$0 & 8) == 0) {
                Option option = Option$.MODULE$.apply(System.getenv("COURSIER_TTL")).flatMap((Function1<String, Option> & Serializable)x$2 -> {
                    String string;
                    return MODULE$.parseDuration(string).toOption();
                });
                ttl = option.orElse((Function0<Option> & Serializable)() -> CacheDefaults$.fromProps$1()).orElse((Function0<Some> & Serializable)() -> new Some<FiniteDuration>(CacheDefaults$.default$1()));
                bitmap$0 = (byte)(bitmap$0 | 8);
            }
        }
        return ttl;
    }

    public final Option<Duration> ttl() {
        if ((byte)(bitmap$0 & 8) == 0) {
            return this.ttl$lzycompute();
        }
        return ttl;
    }

    public final Seq<Option<String>> checksums() {
        return checksums;
    }

    private int defaultSslRetryCount() {
        return 3;
    }

    private int sslRetryCount$lzycompute() {
        CacheDefaults$ cacheDefaults$ = this;
        synchronized (cacheDefaults$) {
            if ((byte)(bitmap$0 & 0x10) == 0) {
                sslRetryCount = BoxesRunTime.unboxToInt(scala.sys.package$.MODULE$.props().get("xsbt.boot.internal.shaded.coursier.sslexception-retry").flatMap((Function1<String, Option> & Serializable)s -> {
                    String string;
                    return Try$.MODULE$.apply(() -> {
                        String string;
                        return StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(string));
                    }).toOption();
                }).filter(x$4 -> x$4 >= 0).getOrElse(() -> MODULE$.defaultSslRetryCount()));
                bitmap$0 = (byte)(bitmap$0 | 0x10);
            }
        }
        return sslRetryCount;
    }

    public final int sslRetryCount() {
        if ((byte)(bitmap$0 & 0x10) == 0) {
            return this.sslRetryCount$lzycompute();
        }
        return sslRetryCount;
    }

    private Option<Object> defaultMaxRedirections() {
        return Option$.MODULE$.apply(BoxesRunTime.boxToInteger(20));
    }

    private Option<Object> maxRedirections$lzycompute() {
        CacheDefaults$ cacheDefaults$ = this;
        synchronized (cacheDefaults$) {
            if ((byte)(bitmap$0 & 0x20) == 0) {
                maxRedirections = CacheDefaults$.prop$1("xsbt.boot.internal.shaded.coursier.http.maxRedirects").orElse((Function0<Option> & Serializable)() -> CacheDefaults$.prop$1("http.maxRedirects")).orElse((Function0<Option> & Serializable)() -> MODULE$.defaultMaxRedirections());
                bitmap$0 = (byte)(bitmap$0 | 0x20);
            }
        }
        return maxRedirections;
    }

    public final Option<Object> maxRedirections() {
        if ((byte)(bitmap$0 & 0x20) == 0) {
            return this.maxRedirections$lzycompute();
        }
        return maxRedirections;
    }

    public final int defaultRetryCount() {
        return 1;
    }

    public final int bufferSize() {
        return bufferSize;
    }

    private Option<String> credentialPropOpt() {
        return Option$.MODULE$.apply(System.getenv("COURSIER_CREDENTIALS")).orElse((Function0<Option> & Serializable)() -> scala.sys.package$.MODULE$.props().get("xsbt.boot.internal.shaded.coursier.credentials")).map((Function1<String, String> & Serializable)s -> {
            String string;
            return StringOps$.MODULE$.dropWhile$extension(Predef$.MODULE$.augmentString(string), (Function1<Object, Object> & Serializable)x$6 -> BoxesRunTime.boxToBoolean(CacheDefaults$.$anonfun$credentialPropOpt$3(BoxesRunTime.unboxToChar(x$6))));
        });
    }

    /*
     * WARNING - void declaration
     */
    private boolean isPropFile(String s) {
        void var1_1;
        return s.startsWith("/") || var1_1.startsWith("file:");
    }

    /*
     * WARNING - void declaration
     */
    public final Seq<Credentials> credentials() {
        if (this.credentialPropOpt().isEmpty()) {
            void var1_1;
            void var2_2;
            Seq configDirs = ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps(CoursierPaths.configDirectories()));
            Seq mainCredentialsFiles = (Seq)configDirs.map((Function1<File, File> & Serializable)configDir -> {
                File file;
                return new File(file, "credentials.properties");
            });
            configDirs = (Seq)configDirs.map((Function1<File, File> & Serializable)configDir -> {
                File file;
                return new File(file, "credentials");
            });
            Seq files = (Seq)configDirs.flatMap((Function1<File, Seq> & Serializable)dir -> {
                File file;
                Option$ option$ = Option$.MODULE$;
                return (Seq)option$.option2Iterable(option$.apply(file.listFiles(new FilenameFilter(){

                    /*
                     * WARNING - void declaration
                     */
                    public final boolean accept(File dir, String name) {
                        void var2_2;
                        return !name.startsWith(".") && var2_2.endsWith(".properties");
                    }
                }))).toSeq().flatten((Function1<File[], ArraySeq.ofRef> & Serializable)xs -> {
                    File[] fileArray;
                    return Predef$.MODULE$.wrapRefArray((Object[])fileArray);
                });
            });
            Option$ option$ = Option$.MODULE$;
            Seq otherFiles = (Seq)((IterableOps)option$.option2Iterable(option$.apply(files)).toSeq().flatten(Predef$.MODULE$.$conforms())).map((Function1<File, FileCredentials> & Serializable)f -> {
                File file;
                return FileCredentials$.MODULE$.apply(file.getAbsolutePath(), true);
            });
            return (Seq)((IterableOps)var2_2.map((Function1<File, FileCredentials> & Serializable)f -> {
                File file;
                return FileCredentials$.MODULE$.apply(file.getAbsolutePath(), true);
            })).$plus$plus(var1_1);
        }
        return (Seq)Option$.MODULE$.option2Iterable(this.credentialPropOpt().filter((Function1<String, Object> & Serializable)s -> BoxesRunTime.boxToBoolean(CacheDefaults$.$anonfun$credentials$7(s)))).toSeq().flatMap((Function1<String, IterableOnce> & Serializable)x0$1 -> {
            IterableOnce<Nothing$> iterableOnce;
            $colon$colon<Nothing$> $colon$colon;
            if (x0$1 != null) {
                x0$1.hashCode();
            }
            if (MODULE$.isPropFile((String)x0$1)) {
                $colon$colon<Nothing$> path0;
                path0 = x0$1.startsWith("file:") ? new File(new URI((String)x0$1)).getAbsolutePath() : path0;
                iterableOnce = new $colon$colon<Nothing$>((Nothing$)((Object)FileCredentials$.MODULE$.apply((String)((Object)$colon$colon), true)), Nil$.MODULE$);
            } else {
                iterableOnce = (IterableOnce)CredentialsParser$.MODULE$.parseSeq((String)((Object)$colon$colon)).either().toSeq().flatten(Predef$.MODULE$.$conforms());
            }
            $colon$colon = iterableOnce;
            return iterableOnce;
        });
    }

    public final Seq<CachePolicy.Mixed> noEnvCachePolicies() {
        return noEnvCachePolicies;
    }

    public final Seq<CachePolicy> cachePolicies() {
        Option option = CacheDefaults$.fromOption$1(Option$.MODULE$.apply(System.getenv("COURSIER_MODE")), "COURSIER_MODE environment variable");
        return (Seq)option.orElse((Function0<Option> & Serializable)() -> CacheDefaults$.fromProps$2()).getOrElse((Function0<Seq> & Serializable)() -> MODULE$.noEnvCachePolicies());
    }

    public static final /* synthetic */ boolean $anonfun$parseDuration$1(char x$1) {
        return x$1 == '0';
    }

    public static final /* synthetic */ Duration $anonfun$parseDuration$2(String s$2) {
        String string;
        return Duration$.MODULE$.apply(string);
    }

    private static final Option fromProps$1() {
        return scala.sys.package$.MODULE$.props().get("xsbt.boot.internal.shaded.coursier.ttl").flatMap((Function1<String, Option> & Serializable)x$3 -> {
            String string;
            return MODULE$.parseDuration(string).toOption();
        });
    }

    private static final FiniteDuration default$1() {
        return new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(24)).hours();
    }

    private static final Option prop$1(String name) {
        String string;
        return scala.sys.package$.MODULE$.props().get(string).flatMap((Function1<String, Option> & Serializable)s -> {
            String string;
            return Try$.MODULE$.apply(() -> {
                String string;
                return StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(string));
            }).toOption();
        }).filter(x$5 -> x$5 >= 0);
    }

    public static final /* synthetic */ boolean $anonfun$credentialPropOpt$3(char x$6) {
        char c;
        return RichChar$.MODULE$.isSpaceChar$extension(Predef$.MODULE$.charWrapper(c));
    }

    public static final /* synthetic */ boolean $anonfun$credentials$7(String s) {
        String string;
        return MODULE$.isPropFile(string);
    }

    public static final /* synthetic */ boolean $anonfun$cachePolicies$1(String x$7) {
        String string;
        return StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(string));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static final /* synthetic */ Option $anonfun$cachePolicies$2(String description$12, String str) {
        String string;
        void var0_5;
        Either<$colon$colon<String>, Seq<CachePolicy>> either;
        boolean bl = false;
        Right right = null;
        if ((either = CachePolicyParser$.MODULE$.cachePolicies((String)((Object)either), MODULE$.noEnvCachePolicies()).either()) instanceof Right) {
            SeqOps seqOps;
            bl = true;
            right = (Right)either;
            Seq seq = (Seq)right.value();
            if (seq != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = Seq$.MODULE$.unapplySeq(seq))) {
                new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps));
                SeqFactory$UnapplySeqWrapper$ seqFactory$UnapplySeqWrapper$ = SeqFactory$UnapplySeqWrapper$.MODULE$;
                if (seqFactory$UnapplySeqWrapper$.lengthCompare$extension(seqFactory$UnapplySeqWrapper$.get$extension(seqOps), 0) == 0) {
                    Console$.MODULE$.err().println(new StringBuilder(40).append("Warning: no mode found in ").append((String)description$12).append(", ignoring it.").toString());
                    None$ description$12 = None$.MODULE$;
                    return var0_5;
                }
            }
        }
        if (bl) {
            void var0_2;
            Seq policies = (Seq)right.value();
            Some<void> some = new Some<void>(var0_2);
            return var0_5;
        }
        if (!(either instanceof Left)) throw new MatchError(either);
        Console$.MODULE$.err().println(new StringBuilder(44).append("Warning: unrecognized mode in ").append(string).append(", ignoring it.").toString());
        None$ none$ = None$.MODULE$;
        return var0_5;
    }

    /*
     * WARNING - void declaration
     */
    private static final Option fromOption$1(Option value, String description) {
        void var1_1;
        return value.filter((Function1<String, Object> & Serializable)x$7 -> BoxesRunTime.boxToBoolean(CacheDefaults$.$anonfun$cachePolicies$1(x$7))).flatMap(arg_0 -> CacheDefaults$.$anonfun$cachePolicies$2((String)var1_1, arg_0));
    }

    private static final Option fromProps$2() {
        return CacheDefaults$.fromOption$1(scala.sys.package$.MODULE$.props().get("xsbt.boot.internal.shaded.coursier.mode"), "Java property coursier.mode");
    }

    private CacheDefaults$() {
    }
}

