/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.editor;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import net.sf.sdedit.Constants;
import net.sf.sdedit.config.ConfigurationManager;
import net.sf.sdedit.config.GlobalConfiguration;
import net.sf.sdedit.editor.Actions;
import net.sf.sdedit.editor.DiagramFileHandler;
import net.sf.sdedit.editor.ExportMapAction;
import net.sf.sdedit.editor.Shortcuts;
import net.sf.sdedit.editor.TabConfigurationAction;
import net.sf.sdedit.editor.apple.AppInstaller;
import net.sf.sdedit.editor.plugin.FileActionProvider;
import net.sf.sdedit.editor.plugin.FileHandler;
import net.sf.sdedit.editor.plugin.Plugin;
import net.sf.sdedit.editor.plugin.PluginRegistry;
import net.sf.sdedit.server.RealtimeServer;
import net.sf.sdedit.ui.Tab;
import net.sf.sdedit.ui.UserInterface;
import net.sf.sdedit.ui.UserInterfaceListener;
import net.sf.sdedit.ui.components.buttons.ActionManager;
import net.sf.sdedit.ui.components.configuration.Bean;
import net.sf.sdedit.ui.components.configuration.ConfigurationAction;
import net.sf.sdedit.ui.impl.LookAndFeelManager;
import net.sf.sdedit.ui.impl.UserInterfaceImpl;
import net.sf.sdedit.util.OS;
import net.sf.sdedit.util.Ref;
import net.sf.sdedit.util.UIUtilities;
import net.sf.sdedit.util.Utilities;

public final class Editor
implements Constants,
UserInterfaceListener {
    private GlobalConfiguration globalConfiguration;
    private UserInterface ui;
    private Actions actions;
    private RealtimeServer server;
    private LinkedList<String> recentFiles;
    private LinkedList<Action> recentFileActions;
    private boolean setup = false;
    private Map<String, Object> globals;
    private ActionManager actionManager;
    private FileActionProvider fileActionProvider;
    private List<FileHandler> fileHandlers;
    private DiagramFileHandler defaultFileHandler;
    private static Editor instance;

    public static Editor getEditor() {
        if (instance == null) {
            instance = new Editor();
        }
        return instance;
    }

    private Editor() {
        UIUtilities.setGlobalFont(ConfigurationManager.getGlobalConfiguration().getGuiFont());
        String laf = ConfigurationManager.getGlobalConfiguration().getLookAndFeel();
        LookAndFeelManager.changeTo(laf);
        this.globals = new HashMap<String, Object>();
        this.fileHandlers = new LinkedList<FileHandler>();
        this.defaultFileHandler = new DiagramFileHandler();
        this.fileHandlers.add(this.defaultFileHandler);
        this.actionManager = new ActionManager();
        this.ui = this.newUI();
        if (OS.TYPE == OS.Type.MAC) {
            AppInstaller.installApplication(this);
        }
        this.recentFiles = new LinkedList();
        this.recentFileActions = new LinkedList();
        this.globalConfiguration = ConfigurationManager.getGlobalConfiguration();
        this.fileActionProvider = new FileActionProvider();
        this.ui.addListener(this);
    }

    public void start() {
        File fileToLoad;
        this.setupUI();
        for (Plugin plugin : PluginRegistry.getInstance()) {
            for (FileHandler handler : plugin.getFileHandlers()) {
                this.addFileHandler(handler);
            }
        }
        this.readRecentFiles();
        if (this.globalConfiguration.isAutostartServer()) {
            try {
                this.startRealtimeServer(this.globalConfiguration.getRealtimeServerPort());
                this.ui.message("Started real-time diagram server @localhost:" + this.server.getPort());
            }
            catch (Exception e) {
                this.ui.errorMessage(e, null, "The real-time diagram server could not be started.");
            }
        }
        this.setup = true;
        if (OS.TYPE == OS.Type.MAC && (fileToLoad = AppInstaller.getFileToLoad()) != null) {
            try {
                this.load(fileToLoad.toURI().toURL());
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                this.ui.errorMessage(e, null, "Cannot load " + fileToLoad.getAbsolutePath());
            }
        }
    }

    private void addFileHandler(FileHandler fileHandler) {
        this.fileHandlers.add(fileHandler);
    }

    public ActionManager getActionManager() {
        return this.actionManager;
    }

    public void registerGlobalObject(String name, Object object) {
        this.globals.put(name, object);
    }

    public Object getGlobalObject(String name) {
        return this.globals.get(name);
    }

    public Iterable<FileHandler> getFileHandlers() {
        final ArrayList<FileHandler> handlers = new ArrayList<FileHandler>();
        handlers.add(this.defaultFileHandler);
        for (Plugin plugin : PluginRegistry.getInstance()) {
            for (FileHandler handler : plugin.getFileHandlers()) {
                handlers.add(handler);
            }
        }
        return new Iterable<FileHandler>(){

            @Override
            public Iterator<FileHandler> iterator() {
                return handlers.iterator();
            }
        };
    }

    private FileHandler findFileHandler(String type) {
        for (FileHandler fileHandler : this.fileHandlers) {
            for (String ext : fileHandler.getFileTypes()) {
                if (!ext.equalsIgnoreCase(type)) continue;
                return fileHandler;
            }
        }
        return null;
    }

    private List<String> getFileTypes() {
        ArrayList<String> fileTypes = new ArrayList<String>();
        for (FileHandler fileHandler : this.fileHandlers) {
            for (String ext : fileHandler.getFileTypes()) {
                fileTypes.add(ext);
            }
        }
        return fileTypes;
    }

    public Tab load(URL url) throws IOException, URISyntaxException {
        String file = url.getFile();
        FileHandler handler = null;
        int d = file.lastIndexOf(46);
        if (d >= 0) {
            String ext = file.substring(d + 1);
            handler = this.findFileHandler(ext);
        }
        if (handler == null) {
            this.ui.errorMessage(null, null, "Cannot handle " + file + "\nSupported file-types are: " + Utilities.join(",", this.getFileTypes()));
            return null;
        }
        return handler.loadFile(url, this.ui);
    }

    @Override
    public void hyperlinkClicked(String hyperlink) {
        if (hyperlink.startsWith("example:")) {
            String file = hyperlink.substring(hyperlink.indexOf(58) + 1);
            this.actions.getExampleAction(file, file).actionPerformed(null);
        } else if (hyperlink.startsWith("help:")) {
            int first = hyperlink.indexOf(58);
            int last = hyperlink.lastIndexOf(58);
            String title = hyperlink.substring(first + 1, last);
            String file = hyperlink.substring(last + 1);
            this.ui.help(title, file.replaceAll(".html", ""), false);
        }
    }

    private void readRecentFiles() {
        String sep = System.getProperty("path.separator");
        String recent = this.globalConfiguration.getRecentFiles();
        if (recent != null && !recent.equals("")) {
            int i = 0;
            for (String file : recent.split(sep)) {
                if (!new File(file).exists()) continue;
                ++i;
                this.recentFiles.add(file);
                Action act = this.actions.getRecentFileAction(file);
                this.recentFileActions.add(act);
                this.ui.addAction("&File.Open &recent file", act, null);
                if (i != this.globalConfiguration.getMaxNumOfRecentFiles()) continue;
                return;
            }
        }
    }

    public List<String> getRecentFiles() {
        return Collections.checkedList(this.recentFiles, String.class);
    }

    public void addToRecentFiles(String file) {
        Action act;
        int max = this.globalConfiguration.getMaxNumOfRecentFiles();
        if (max == 0) {
            return;
        }
        int i = this.recentFiles.indexOf(file);
        if (i >= 0) {
            this.recentFiles.remove(i);
            act = this.recentFileActions.get(i);
            this.recentFileActions.remove(i);
        } else {
            act = this.actions.getRecentFileAction(file);
            this.ui.addAction("&File.Open &recent file", act, null);
            if (this.recentFiles.size() == max) {
                Action last = this.recentFileActions.removeLast();
                this.ui.removeAction("&File.Open &recent file", last);
                this.recentFiles.removeLast();
            }
        }
        this.recentFiles.addFirst(file);
        this.recentFileActions.addFirst(act);
    }

    private void writeRecentFiles() {
        String sep = System.getProperty("path.separator");
        StringBuffer buffer = new StringBuffer();
        for (String file : this.recentFiles) {
            if (buffer.length() > 0) {
                buffer.append(sep);
            }
            buffer.append(file);
        }
        this.globalConfiguration.setRecentFiles(buffer.toString());
    }

    public int startRealtimeServer(int port) throws IOException {
        if (this.isServerRunning()) {
            return 0;
        }
        this.server = new RealtimeServer(port, this);
        this.server.setDaemon(true);
        this.server.start();
        return this.server.getPort();
    }

    public boolean isServerRunning() {
        return this.server != null;
    }

    public void shutDownServer() {
        if (this.isServerRunning()) {
            this.server.shutDown();
            this.server = null;
        }
    }

    private void setupUI() {
        this.addActions();
        this.ui.showUI();
        this.ui.addToolbarSeparator();
        this.ui.addToToolbar(this.actions.helpAction, null);
    }

    private void addActions() {
        this.actions = new Actions(this);
        this.ui.addAction("&File", this.actions.newSequenceDiagramAction, null);
        for (Plugin plugin : PluginRegistry.getInstance()) {
            if (plugin.getNewTabAction() == null) continue;
            this.ui.addAction("&File", plugin.getNewTabAction(), null);
        }
        this.ui.addAction("&File", this.fileActionProvider.getOpenAction(this.ui), this.fileActionProvider.getOpenActivator);
        this.ui.addCategory("&File.Open &recent file", "open");
        this.ui.addAction("&File", this.fileActionProvider.getSaveAction(this.defaultFileHandler, this.ui), this.fileActionProvider.getSaveActivator);
        this.ui.addAction("&File", this.fileActionProvider.getSaveAsAction(this.defaultFileHandler, this.ui), this.fileActionProvider.getSaveActivator);
        Action exportAction = this.actions.getExportAction();
        if (exportAction != null) {
            this.ui.addAction("&File", exportAction, this.actions.nonEmptyDiagramActivator);
        }
        this.ui.addAction("&File", this.actions.closeTabAction, this.actions.canCloseActivator);
        this.ui.addAction("&File", this.actions.closeAllAction, null);
        Action printPDFAction = this.actions.getPrintAction("pdf");
        if (printPDFAction != null) {
            this.ui.addAction("&File", printPDFAction, this.actions.noDiagramErrorActivator);
        }
        this.ui.addAction("&File", this.actions.quitAction, null);
        TabConfigurationAction wrapAction = new TabConfigurationAction("lineWrap", "[control shift W]&Wrap lines", "Wrap lines whose length exceed the width of the text area", "wrap", this.ui);
        TabConfigurationAction threadedAction = new TabConfigurationAction("threaded", Shortcuts.getShortcut(23) + "Enable &multithreading", "Create diagrams with arbitrarily many sequences running concurrently", "threads", this.ui);
        ConfigurationAction<GlobalConfiguration> autoUpdateAction = new ConfigurationAction<GlobalConfiguration>("autoUpdate", "Auto-redraw", "Update diagram as you type", "reload"){

            @Override
            public Bean<GlobalConfiguration> getBean() {
                return ConfigurationManager.getGlobalConfigurationBean();
            }
        };
        ConfigurationAction<GlobalConfiguration> autoScrollAction = new ConfigurationAction<GlobalConfiguration>("autoScroll", "Auto-scrolling", "Scroll automatically to where the message currently being specified is visible", "autoscroll"){

            @Override
            public Bean<GlobalConfiguration> getBean() {
                return ConfigurationManager.getGlobalConfigurationBean();
            }
        };
        this.ui.addAction("&Edit", this.actions.undoAction, this.actions.textTabActivator);
        this.ui.addAction("&Edit", this.actions.redoAction, this.actions.textTabActivator);
        this.ui.addAction("&Edit", this.actions.clearAction, this.actions.textTabActivator);
        this.ui.addConfigurationAction("&Edit", threadedAction, this.actions.textTabActivator);
        this.ui.addAction("&Edit", this.actions.configureGloballyAction, null);
        this.ui.addAction("&Edit", this.actions.configureDiagramAction, this.actions.diagramTabActivator);
        this.ui.addAction("&Edit", this.actions.copyBitmapToClipBoardAction, this.actions.nonEmptyDiagramActivator);
        this.ui.addAction("&Edit", this.actions.copyVectorGraphicsToClipBoardAction, this.actions.nonEmptyDiagramActivator);
        this.ui.addCategory("&View", null);
        this.ui.addConfigurationAction("&View", autoUpdateAction, null);
        this.ui.addConfigurationAction("&View", autoScrollAction, null);
        this.ui.addAction("&View", this.actions.redrawAction, this.actions.diagramTabActivator);
        this.ui.addAction("&View", this.actions.widenAction, this.actions.canConfigureActivator);
        this.ui.addAction("&View", this.actions.narrowAction, this.actions.canNarrowActivator);
        this.ui.addConfigurationAction("&View", wrapAction, this.actions.textTabActivator);
        this.ui.addAction("&View", this.actions.previousAction, this.actions.previousActivator);
        this.ui.addAction("&View", this.actions.nextAction, this.actions.nextActivator);
        this.ui.addAction("&View", this.actions.fullScreenAction, this.actions.supportsFullScreenActivator);
        this.ui.addAction("&View", this.actions.splitLeftRightAction, this.actions.horizontalSplitPossibleActivator);
        this.ui.addAction("&View", this.actions.splitTopBottomAction, this.actions.verticalSplitPossibleActivator);
        if (OS.TYPE != OS.Type.MAC) {
            this.ui.setQuitAction(this.actions.quitAction);
        }
        this.ui.addToToolbar(this.actions.newSequenceDiagramAction, null);
        for (Plugin plugin : PluginRegistry.getInstance()) {
            if (plugin.getNewTabAction() == null) continue;
            this.ui.addToToolbar(plugin.getNewTabAction(), null);
        }
        this.ui.addToToolbar(this.fileActionProvider.getOpenAction(this.ui), this.fileActionProvider.getOpenActivator);
        this.ui.addToToolbar(this.fileActionProvider.getSaveAction(this.defaultFileHandler, this.ui), this.fileActionProvider.getSaveActivator);
        this.ui.addToToolbar(this.fileActionProvider.getSaveAsAction(this.defaultFileHandler, this.ui), this.fileActionProvider.getSaveActivator);
        this.ui.addToToolbar(exportAction, this.actions.nonEmptyDiagramActivator);
        if (printPDFAction != null) {
            this.ui.addToToolbar(printPDFAction, this.actions.noDiagramErrorActivator);
        }
        this.ui.addToolbarSeparator();
        this.ui.addToToolbar(this.actions.configureGloballyAction, null);
        this.ui.addToToolbar(this.actions.configureDiagramAction, this.actions.diagramTabActivator);
        this.ui.addToToolbar(this.actions.redrawAction, this.actions.diagramTabActivator);
        this.ui.addToolbarSeparator();
        this.ui.addToToolbar(this.actions.fullScreenAction, this.actions.supportsFullScreenActivator);
        this.ui.addToToolbar(this.actions.splitLeftRightAction, this.actions.horizontalSplitPossibleActivator);
        this.ui.addToToolbar(this.actions.splitTopBottomAction, this.actions.verticalSplitPossibleActivator);
        this.ui.addToolbarSeparator();
        this.ui.addToToolbar(this.actions.homeAction, this.actions.homeActivator);
        this.ui.addToToolbar(this.actions.previousAction, this.actions.previousActivator);
        this.ui.addToToolbar(this.actions.nextAction, this.actions.nextActivator);
        this.ui.addAction("E&xtras", this.actions.serverAction, null);
        this.ui.addAction("E&xtras", this.actions.filterAction, this.actions.textTabActivator);
        this.ui.addAction("E&xtras", new ExportMapAction(this), this.actions.exportMapFileActivator);
        this.ui.addAction("&Help", this.actions.helpAction, null);
        this.ui.addAction("&Help", this.actions.tutorialAction, null);
        this.ui.addAction("&Help", this.actions.helpOnMultithreadingAction, null);
        this.ui.addAction("&Help", this.actions.asyncNotesAction, null);
        if (OS.TYPE != OS.Type.MAC) {
            this.ui.addAction("&Help", this.actions.showAboutDialogAction, null);
        }
        this.ui.addAction("&Help.&Examples", this.actions.getExampleAction("Ticket order", "order.sdx"), null);
        this.ui.addAction("&Help.&Examples", this.actions.getExampleAction("Breadth first search", "bfs.sdx"), null);
        this.ui.addAction("&Help.&Examples", this.actions.getExampleAction("Levels", "levels.sdx"), null);
        this.ui.addAction("&Help.&Examples", this.actions.getExampleAction("SSH 2 (by courtesy of Carlos Duarte)", "ssh.sdx"), null);
        this.ui.addAction("&Help.&Examples", this.actions.getExampleAction("Webserver", "webserver.sdx"), null);
    }

    public DiagramFileHandler getDefaultFileHandler() {
        return this.defaultFileHandler;
    }

    public boolean isSetup() {
        return this.setup;
    }

    public void quit() {
        if (this.closeAll()) {
            this.writeRecentFiles();
            try {
                ConfigurationManager.storeConfigurations();
            }
            catch (IOException e) {
                e.printStackTrace();
                this.ui.errorMessage(e, null, "Could not save the global preferences file.");
            }
            if (this.server != null) {
                this.server.shutDown();
            }
            this.ui.exit();
            System.exit(0);
        }
    }

    boolean closeAll() {
        boolean confirmed = true;
        Ref<Boolean> noToAll = new Ref<Boolean>(false);
        for (Tab tab : this.ui.getTabContainer().getTabs()) {
            this.ui.selectTab(tab);
            if (!tab.isReadyToBeClosed(noToAll)) {
                confirmed = false;
                break;
            }
            if (!((Boolean)noToAll.t).booleanValue()) continue;
            confirmed = true;
            break;
        }
        if (confirmed) {
            for (Tab tab : this.ui.getTabContainer().getTabs()) {
                tab.close(false);
            }
            return true;
        }
        return false;
    }

    public UserInterface getUI() {
        return this.ui;
    }

    private UserInterface newUI() {
        return new UserInterfaceImpl();
    }

    @Override
    public void tabChanged(Tab previousTab, Tab currentTab) {
        if (previousTab != null) {
            previousTab.deactivate(this.actionManager, this.fileActionProvider);
        }
        if (currentTab != null) {
            currentTab.activate(this.actionManager, this.fileActionProvider);
        }
    }
}

