/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui.components;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import net.sf.sdedit.util.DocUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLTableModel
implements TableModel {
    private List<Element> elements = new ArrayList<Element>();
    private List<String> names;

    public XMLTableModel(Document document) {
        Element root = document.getDocumentElement();
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        for (Element child : DocUtil.select(root, "*", Element.class)) {
            this.elements.add(child);
            for (Element nipote : DocUtil.select(child, "*", Element.class)) {
                names.add(nipote.getNodeName());
            }
        }
        this.names = new ArrayList<String>(names);
    }

    @Override
    public int getRowCount() {
        return this.elements.size();
    }

    @Override
    public int getColumnCount() {
        return this.names.size();
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.names.get(columnIndex);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    public Element getElement(int i) {
        return this.elements.get(i);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        String name;
        Element row = this.elements.get(rowIndex);
        Element value = DocUtil.selectFirst(row, name = this.getColumnName(columnIndex), Element.class);
        return value == null ? null : value.getTextContent();
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
    }

    public void addColumn(TableColumn aColumn) {
    }
}

