/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui.impl;

import java.util.LinkedList;
import java.util.List;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import net.sf.sdedit.ui.Tab;
import net.sf.sdedit.ui.TabListener;
import net.sf.sdedit.ui.components.navigator.ContextActionsProvider;
import net.sf.sdedit.ui.components.navigator.TreeNavigatorPane;
import net.sf.sdedit.ui.components.navigator.TreeNavigatorPaneListener;
import net.sf.sdedit.ui.impl.TabContainer;
import net.sf.sdedit.ui.impl.TabContainerListener;
import net.sf.sdedit.util.Utilities;

public class TabNavigatorContainer
implements TabContainer,
TabListener,
TreeNavigatorPaneListener,
ContextActionsProvider {
    private TreeNavigatorPane navigator;
    private List<TabContainerListener> listeners;
    private Tab previousTab;
    private int id;

    public TabNavigatorContainer(double resizeWeight) {
        this.navigator = new TreeNavigatorPane(resizeWeight);
        this.navigator.setContextActionsProvider(this);
        this.navigator.addListener(this);
        this.listeners = new LinkedList<TabContainerListener>();
        this.id = 0;
    }

    @Override
    public void addCategory(String category, ImageIcon icon) {
        this.navigator.addRootCategory(category, icon);
    }

    @Override
    public String addChildTab(Tab tab, Tab parent, boolean selectIt, Tab previousTab) {
        String title = Utilities.findUniqueName(tab.getTitle(), this.navigator.getAllTitles());
        tab.setTitle(title);
        this.addListener(tab);
        tab.addTabListener(this);
        this.navigator.addComponent(tab.getTitle(), (JComponent)tab, tab.getIcon(), parent, selectIt, (JComponent)previousTab);
        ++this.id;
        tab.setId(this.id);
        return title;
    }

    @Override
    public String addChildTab(Tab tab, Tab parent) {
        return this.addChildTab(tab, parent, true, null);
    }

    @Override
    public void addListener(TabContainerListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public String addTab(Tab tab, boolean selectIt) {
        String title = Utilities.findUniqueName(tab.getTitle(), this.navigator.getAllTitles());
        tab.setTitle(title);
        this.addListener(tab);
        tab.addTabListener(this);
        ++this.id;
        tab.setId(this.id);
        String category = tab.getCategory();
        this.navigator.addComponent(tab.getTitle(), (JComponent)tab, tab.getIcon(), category, selectIt, null);
        return title;
    }

    @Override
    public String addTab(Tab tab) {
        return this.addTab(tab, true);
    }

    @Override
    public JComponent getComponent() {
        return this.navigator;
    }

    @Override
    public Tab getSelectedTab() {
        Tab tab = (Tab)this.navigator.getSelectedComponent();
        return tab;
    }

    @Override
    public int getTabCount() {
        return this.navigator.getCompCount();
    }

    @Override
    public List<Tab> getTabs() {
        LinkedList<Tab> result = new LinkedList<Tab>();
        for (JComponent comp : this.navigator.getAllComponents()) {
            result.add((Tab)comp);
        }
        return result;
    }

    @Override
    public void remove(Tab tab) {
        if (tab.canClose()) {
            Object[] closed = this.navigator.removeComponent(tab, tab.alsoRemoveDescendants());
            for (Tab closedTab : Utilities.castArray(closed, Tab.class)) {
                this.listeners.remove(closedTab);
            }
        }
    }

    @Override
    public void removeListener(TabContainerListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public boolean select(Tab tab) {
        return this.navigator.setSelectedComponent(tab);
    }

    @Override
    public synchronized void componentSelected(JComponent component) {
        Tab currentTab = (Tab)component;
        for (TabContainerListener listener : new LinkedList<TabContainerListener>(this.listeners)) {
            listener.tabSelected(this.previousTab, currentTab);
        }
        this.previousTab = currentTab;
    }

    @Override
    public boolean exists(Tab tab) {
        for (Tab existing : this.getTabs()) {
            if (!existing.equals(tab)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Action> getContextActions(JComponent component) {
        return ((Tab)component).getContextActions();
    }

    @Override
    public boolean existsCategory(String title) {
        return this.navigator.existsCategory(title);
    }

    @Override
    public void titleChanged(Tab tab) {
        this.navigator.setTitle(tab, tab.getTitle());
    }

    @Override
    public void tabIsClosed(Tab tab) {
    }

    @Override
    public Tab[] getSelectedTabs() {
        return Utilities.castArray(this.navigator.getSelectedComponents(), Tab.class);
    }

    @Override
    public List<Tab> getSuccessors(Tab tab) {
        LinkedList<Tab> successors = new LinkedList<Tab>();
        for (JComponent comp : this.navigator.getSuccessors(tab)) {
            successors.add((Tab)comp);
        }
        return successors;
    }

    @Override
    public List<Tab> getDescendants(Tab root) {
        LinkedList<Tab> descendants = new LinkedList<Tab>();
        for (JComponent comp : this.navigator.getDescendants(root)) {
            descendants.add((Tab)comp);
        }
        return descendants;
    }

    @Override
    public Tab getParentTab(Tab tab) {
        return (Tab)this.navigator.getParentComponent(tab);
    }

    @Override
    public void goToNextTab() {
        this.navigator.goToNextComponent();
    }

    @Override
    public void goToPreviousTab() {
        this.navigator.goToPreviousComponent();
    }

    @Override
    public boolean nextTabExists() {
        return this.navigator.nextComponentExists();
    }

    @Override
    public boolean previousTabExists() {
        return this.navigator.previousComponentExists();
    }

    @Override
    public void disableTabHistory() {
        this.navigator.disableHistory();
    }

    @Override
    public void enableTabHistory() {
        this.navigator.enableHistory();
    }
}

