/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.view;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.AbstractDialog;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.view.AbstractParamContainerPanel;
import org.parosproxy.paros.view.AbstractParamPanel;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.view.LayoutHelper;

public class AbstractParamDialog
extends AbstractDialog {
    private static final long serialVersionUID = -5223178126156052670L;
    private static final Logger LOGGER = LogManager.getLogger(AbstractParamDialog.class);
    private int exitResult = 2;
    private JPanel jContentPane = null;
    private JButton btnOK = null;
    private JButton btnCancel = null;
    private AbstractParamContainerPanel jSplitPane;
    private JLabel footer = null;
    private String rootName = null;

    public AbstractParamDialog() {
        this.initialize();
    }

    public AbstractParamDialog(Window parent, boolean modal, String title, String rootName) {
        super(parent, modal);
        this.rootName = rootName;
        this.initialize();
        this.setTitle(title);
    }

    private void initialize() {
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        if (Model.getSingleton().getOptionsParam().getViewParam().getWmUiHandlingOption() == 0) {
            this.setSize(500, 375);
        }
        this.setDefaultCloseOperation(2);
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getJSplitPane(), LayoutHelper.getGBC(0, 0, 1, 1.0, 1.0));
            JPanel footerPane = new JPanel();
            footerPane.setLayout(new GridBagLayout());
            this.footer = new JLabel();
            int x = 0;
            JButton[] extraButtons = this.getExtraButtons();
            if (extraButtons != null) {
                for (JButton button : extraButtons) {
                    footerPane.add((Component)button, LayoutHelper.getGBC(x++, 0, 1, 0.0, 0.0, 0, 17, new Insets(2, 2, 2, 2)));
                }
            }
            footerPane.add((Component)this.footer, LayoutHelper.getGBC(x++, 0, 1, 1.0, new Insets(2, 2, 2, 2)));
            footerPane.add((Component)this.getBtnCancel(), LayoutHelper.getGBC(x++, 0, 1, 0.0, 0.0, 0, 13, new Insets(2, 2, 2, 2)));
            footerPane.add((Component)this.getBtnOK(), LayoutHelper.getGBC(x++, 0, 1, 0.0, 0.0, 0, 13, new Insets(2, 2, 2, 2)));
            this.jContentPane.add((Component)footerPane, LayoutHelper.getGBC(0, 1, 1, 1.0, 0.0));
        }
        return this.jContentPane;
    }

    public void setFooter(String text) {
        this.footer.setText(text);
    }

    public JButton[] getExtraButtons() {
        return null;
    }

    private JButton getBtnOK() {
        if (this.btnOK == null) {
            this.btnOK = new JButton();
            this.btnOK.setName("btnOK");
            this.btnOK.setText(Constant.messages.getString("all.button.ok"));
            this.btnOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        AbstractParamDialog.this.validateParam();
                        AbstractParamDialog.this.saveParam();
                        AbstractParamDialog.this.exitResult = 0;
                        AbstractParamDialog.this.setVisible(false);
                    }
                    catch (Exception ex) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Failed to validate or save the panels: ", (Throwable)ex);
                        }
                        View.getSingleton().showWarningDialog(Constant.messages.getString("options.dialog.save.error", ex.getMessage()));
                    }
                }
            });
        }
        return this.btnOK;
    }

    protected JButton getBtnCancel() {
        if (this.btnCancel == null) {
            this.btnCancel = new JButton();
            this.btnCancel.setName("btnCancel");
            this.btnCancel.setText(Constant.messages.getString("all.button.cancel"));
            this.btnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AbstractParamDialog.this.exitResult = 2;
                    AbstractParamDialog.this.setVisible(false);
                }
            });
        }
        return this.btnCancel;
    }

    private AbstractParamContainerPanel getJSplitPane() {
        if (this.jSplitPane == null) {
            this.jSplitPane = new AbstractParamContainerPanel();
            this.jSplitPane.setVisible(true);
            if (this.rootName != null) {
                this.jSplitPane.getRootNode().setUserObject(this.rootName);
            }
        }
        return this.jSplitPane;
    }

    public void addParamPanel(String[] parentParams, String name, AbstractParamPanel panel, boolean sort) {
        this.getJSplitPane().addParamPanel(parentParams, name, panel, sort);
    }

    public void addParamPanel(String[] parentParams, AbstractParamPanel panel, boolean sort) {
        this.addParamPanel(parentParams, panel.getName(), panel, sort);
    }

    public void removeParamPanel(AbstractParamPanel panel) {
        this.getJSplitPane().removeParamPanel(panel);
    }

    public void showParamPanel(String parent, String child) {
        this.getJSplitPane().showParamPanel(parent, child);
    }

    public void showParamPanel(String name) {
        this.getJSplitPane().showParamPanel(name);
    }

    public void showParamPanel(AbstractParamPanel panel, String name) {
        this.getJSplitPane().showParamPanel(panel, name);
    }

    public void initParam(Object obj) {
        this.getJSplitPane().initParam(obj);
    }

    public void validateParam() throws Exception {
        this.getJSplitPane().validateParam();
    }

    public void saveParam() throws Exception {
        this.getJSplitPane().saveParam();
    }

    protected void expandRoot() {
        this.getJSplitPane().expandRoot();
    }

    protected void expandParamPanelNode(String panelName) {
        this.getJSplitPane().expandParamPanelNode(panelName);
    }

    protected boolean isParamPanelSelected(String panelName) {
        return this.getJSplitPane().isParamPanelSelected(panelName);
    }

    protected boolean isParamPanelOrChildSelected(String panelName) {
        return this.getJSplitPane().isParamPanelOrChildSelected(panelName);
    }

    public int showDialog(boolean showRoot) {
        return this.showDialog(showRoot, null);
    }

    public int showDialog(boolean showRoot, String panel) {
        this.getJSplitPane().showDialog(showRoot, panel);
        this.setVisible(true);
        return this.exitResult;
    }

    protected Collection<AbstractParamPanel> getPanels() {
        return this.getJSplitPane().getPanels();
    }

    public void printTree() {
        this.getJSplitPane().printTree();
    }

    public void renamePanel(AbstractParamPanel panel, String newPanelName) {
        this.getJSplitPane().renamePanel(panel, newPanelName);
    }
}

