/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.attribute;

import java.util.Arrays;
import org.ice4j.StunException;
import org.ice4j.attribute.Attribute;

public class OptionalAttribute
extends Attribute {
    byte[] attributeValue = null;

    protected OptionalAttribute(char attributeType) {
        super(attributeType);
    }

    @Override
    void decodeAttributeBody(byte[] attributeValue, char offset, char length) throws StunException {
        this.attributeValue = new byte[length];
        System.arraycopy(attributeValue, offset, this.attributeValue, 0, length);
    }

    @Override
    public byte[] encode() {
        char type = this.getAttributeType();
        byte[] binValue = new byte[4 + this.attributeValue.length];
        binValue[0] = (byte)(type >> 8);
        binValue[1] = (byte)(type & 0xFF);
        binValue[2] = (byte)(this.getDataLength() >> 8);
        binValue[3] = (byte)(this.getDataLength() & 0xFF);
        System.arraycopy(this.attributeValue, 0, binValue, 4, this.attributeValue.length);
        return binValue;
    }

    @Override
    public char getDataLength() {
        return (char)this.attributeValue.length;
    }

    @Override
    public String getName() {
        return "Unknown Attribute";
    }

    public byte[] getBody() {
        return this.attributeValue;
    }

    public void setBody(byte[] body, int offset, int length) {
        this.attributeValue = new byte[length];
        System.arraycopy(body, offset, this.attributeValue, 0, length);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof OptionalAttribute)) {
            return false;
        }
        return obj == this || Arrays.equals(((OptionalAttribute)obj).attributeValue, this.attributeValue);
    }
}

