/*
 * Decompiled with CFR 0.152.
 */
package edu.umass.cs.benchlab.har;

import edu.umass.cs.benchlab.har.HarDatabaseConfig;
import edu.umass.cs.benchlab.har.HarPage;
import edu.umass.cs.benchlab.har.HarPageTimings;
import edu.umass.cs.benchlab.har.HarWarning;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;

public class HarPages {
    private List<HarPage> pages = new ArrayList<HarPage>();

    public HarPages() {
    }

    public HarPages(JsonParser jp, List<HarWarning> warnings) throws JsonParseException, IOException {
        if (jp.nextToken() != JsonToken.START_ARRAY) {
            throw new JsonParseException("[ missing after \"pages\" element " + jp.getCurrentName(), jp.getCurrentLocation());
        }
        while (jp.nextToken() != JsonToken.END_ARRAY) {
            this.addPage(new HarPage(jp, warnings));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HarPages(HarDatabaseConfig config, long logId) throws SQLException {
        Connection c = config.getConnection();
        String tableName = config.getTablePrefix() + "pages";
        Statement ps = null;
        ResultSet rs = null;
        try {
            ps = c.prepareStatement("SELECT page_id FROM " + tableName + " WHERE log_id=?");
            ps.setLong(1, logId);
            rs = ps.executeQuery();
            while (rs.next()) {
                this.addPage(new HarPage(config, rs.getLong(1)));
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception exception) {}
            config.closeConnection(c);
        }
    }

    public void writeHar(JsonGenerator g) throws JsonGenerationException, IOException {
        g.writeArrayFieldStart("pages");
        for (HarPage page : this.pages) {
            page.writeHar(g);
        }
        g.writeEndArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeJDBC(long logId, HarDatabaseConfig config) throws SQLException {
        String timingsTableName;
        Connection c = config.getConnection();
        String pageTableName = config.getTablePrefix() + HarPage.TABLE_NAME;
        if (!config.isCreatedTable(pageTableName)) {
            try {
                Statement s = c.createStatement();
                s.executeUpdate("CREATE TABLE " + pageTableName + " (page_id " + config.getDbAutoGeneratedId() + ",start_date " + config.getTimestampDbType() + ",id " + config.getStringDbType() + ",title " + config.getStringDbType() + ",comment " + config.getStringDbType() + ",log_id " + config.getLongDbType() + ")");
                s.close();
                config.addCreatedTable(pageTableName);
            }
            catch (Exception s) {
                // empty catch block
            }
        }
        if (!config.isCreatedTable(timingsTableName = config.getTablePrefix() + HarPageTimings.TABLE_NAME)) {
            try {
                Statement s = c.createStatement();
                s.executeUpdate("CREATE TABLE " + config.getTablePrefix() + "page_timings " + " ( page_timings_id " + config.getDbAutoGeneratedId() + ", on_content_load " + config.getLongDbType() + ", on_load " + config.getLongDbType() + ", comment " + config.getStringDbType() + ", page_id " + config.getLongDbType() + ")");
                s.close();
                config.addCreatedTable(timingsTableName);
            }
            catch (Exception s) {
                // empty catch block
            }
        }
        PreparedStatement pagePs = c.prepareStatement("INSERT INTO " + pageTableName + " (start_date,id,title,comment,log_id) VALUES (?,?,?,?,?)", 1);
        PreparedStatement timingsPs = c.prepareStatement("INSERT INTO " + timingsTableName + " (on_content_load,on_load,comment,page_id) VALUES (?,?,?,?)", 1);
        try {
            for (HarPage page : this.pages) {
                page.writeJDBC(config, logId, pagePs, timingsPs);
            }
        }
        finally {
            try {
                if (pagePs != null) {
                    pagePs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (timingsPs != null) {
                    timingsPs.close();
                }
            }
            catch (Exception exception) {}
            config.closeConnection(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFromJDBC(HarDatabaseConfig config, long logId) throws SQLException {
        Connection c = config.getConnection();
        String timingsTableName = config.getTablePrefix() + HarPageTimings.TABLE_NAME;
        Statement timingsPs = null;
        try {
            timingsPs = c.prepareStatement("DELETE FROM " + timingsTableName + " WHERE page_id IN (SELECT page_id FROM " + config.getTablePrefix() + "pages WHERE log_id=?)");
            timingsPs.setLong(1, logId);
            timingsPs.executeUpdate();
            config.dropTableIfEmpty(c, timingsTableName, config);
            config.deleteFromTable(logId, config, "pages");
        }
        finally {
            try {
                if (timingsPs != null) {
                    timingsPs.close();
                }
            }
            catch (Exception exception) {}
            config.closeConnection(c);
        }
    }

    public void addPage(HarPage page) {
        this.pages.add(page);
    }

    public void removePage(HarPage page) {
        this.pages.remove(page);
    }

    public List<HarPage> getPages() {
        return this.pages;
    }

    public void setPages(List<HarPage> pages) {
        this.pages = pages;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("  \"pages\": [");
        if (this.pages != null) {
            boolean first = true;
            for (HarPage page : this.pages) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(page);
            }
        }
        sb.append("]\n");
        return sb.toString();
    }
}

