/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.rights;

import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.Routine;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.MultiValueHashMap;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.rights.GranteeManager;
import org.hsqldb.rights.Right;
import org.hsqldb.types.Type;

public class Grantee
implements SchemaObject {
    boolean isRole;
    private boolean isAdminDirect = false;
    private boolean isAdmin = false;
    boolean isPublic = false;
    boolean isSystem = false;
    protected HsqlNameManager.HsqlName granteeName;
    private MultiValueHashMap directRightsMap;
    HashMap fullRightsMap = new HashMap();
    OrderedHashSet roles;
    private MultiValueHashMap grantedRightsMap;
    protected GranteeManager granteeManager;
    protected Right ownerRights;

    Grantee(HsqlNameManager.HsqlName hsqlName, GranteeManager granteeManager) {
        this.directRightsMap = new MultiValueHashMap();
        this.grantedRightsMap = new MultiValueHashMap();
        this.granteeName = hsqlName;
        this.granteeManager = granteeManager;
        this.roles = new OrderedHashSet();
        this.ownerRights = new Right();
        this.ownerRights.isFull = true;
        this.ownerRights.grantor = GranteeManager.systemAuthorisation;
        this.ownerRights.grantee = this;
    }

    @Override
    public int getType() {
        return 11;
    }

    @Override
    public HsqlNameManager.HsqlName getName() {
        return this.granteeName;
    }

    @Override
    public HsqlNameManager.HsqlName getSchemaName() {
        return null;
    }

    @Override
    public HsqlNameManager.HsqlName getCatalogName() {
        return null;
    }

    @Override
    public Grantee getOwner() {
        return null;
    }

    @Override
    public OrderedHashSet getReferences() {
        return new OrderedHashSet();
    }

    @Override
    public OrderedHashSet getComponents() {
        return null;
    }

    @Override
    public void compile(Session session, SchemaObject schemaObject) {
    }

    @Override
    public String getSQL() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CREATE").append(' ').append("ROLE");
        stringBuilder.append(' ').append(this.granteeName.statementName);
        return stringBuilder.toString();
    }

    @Override
    public long getChangeTimestamp() {
        return 0L;
    }

    public boolean isRole() {
        return this.isRole;
    }

    public boolean isSystem() {
        return this.isSystem;
    }

    public OrderedHashSet getDirectRoles() {
        return this.roles;
    }

    public OrderedHashSet getAllRoles() {
        OrderedHashSet orderedHashSet = this.getGranteeAndAllRoles();
        orderedHashSet.remove(this);
        return orderedHashSet;
    }

    public OrderedHashSet getGranteeAndAllRoles() {
        OrderedHashSet orderedHashSet = new OrderedHashSet();
        this.addGranteeAndRoles(orderedHashSet);
        return orderedHashSet;
    }

    public OrderedHashSet getGranteeAndAllRolesWithPublic() {
        OrderedHashSet orderedHashSet = new OrderedHashSet();
        this.addGranteeAndRoles(orderedHashSet);
        orderedHashSet.add(this.granteeManager.publicRole);
        return orderedHashSet;
    }

    public boolean isAccessible(HsqlNameManager.HsqlName hsqlName, int n) {
        if (this.isFullyAccessibleByRole(hsqlName)) {
            return true;
        }
        Right right = (Right)this.fullRightsMap.get(hsqlName);
        if (right == null) {
            return false;
        }
        return right.canAccess(n);
    }

    public boolean isAccessible(SchemaObject schemaObject) {
        return this.isAccessible(schemaObject.getName());
    }

    public boolean isAccessible(HsqlNameManager.HsqlName hsqlName) {
        if (this.isFullyAccessibleByRole(hsqlName)) {
            return true;
        }
        Right right = (Right)this.fullRightsMap.get(hsqlName);
        if (right != null && !right.isEmpty()) {
            return true;
        }
        if (!this.isPublic) {
            return this.granteeManager.publicRole.isAccessible(hsqlName);
        }
        return false;
    }

    private OrderedHashSet addGranteeAndRoles(OrderedHashSet orderedHashSet) {
        orderedHashSet.add(this);
        for (int i = 0; i < this.roles.size(); ++i) {
            Grantee grantee = (Grantee)this.roles.get(i);
            if (orderedHashSet.contains(grantee)) continue;
            grantee.addGranteeAndRoles(orderedHashSet);
        }
        return orderedHashSet;
    }

    private boolean hasRoleDirect(Grantee grantee) {
        return this.roles.contains(grantee);
    }

    public boolean hasRole(Grantee grantee) {
        return this.getAllRoles().contains(grantee);
    }

    void grant(HsqlNameManager.HsqlName hsqlName, Right right, Grantee grantee, boolean bl) {
        Right right2 = grantee.getAllGrantableRights(hsqlName);
        Right right3 = null;
        if (right == Right.fullRights) {
            if (right2.isEmpty()) {
                return;
            }
            right = right2;
        } else if (!right2.contains(right)) {
            throw Error.error(2000);
        }
        Iterator iterator = this.directRightsMap.get(hsqlName);
        while (iterator.hasNext()) {
            Right right4 = (Right)iterator.next();
            if (right4.grantor != grantee) continue;
            right3 = right4;
            right3.add(right);
            break;
        }
        if (right3 == null) {
            right3 = right.duplicate();
            right3.grantor = grantee;
            right3.grantee = this;
            this.directRightsMap.put(hsqlName, right3);
        }
        if (bl) {
            if (right3.grantableRights == null) {
                right3.grantableRights = right.duplicate();
            } else {
                right3.grantableRights.add(right);
            }
        }
        if (!grantee.isSystem()) {
            grantee.grantedRightsMap.put(hsqlName, right3);
        }
        this.updateAllRights();
    }

    void revoke(SchemaObject schemaObject, Right right, Grantee grantee, boolean bl) {
        HsqlNameManager.HsqlName hsqlName = schemaObject.getName();
        if (schemaObject instanceof Routine) {
            hsqlName = ((Routine)schemaObject).getSpecificName();
        }
        Iterator iterator = this.directRightsMap.get(hsqlName);
        Right right2 = null;
        while (iterator.hasNext()) {
            right2 = (Right)iterator.next();
            if (right2.grantor != grantee) continue;
        }
        if (right2 == null) {
            return;
        }
        if (right2.grantableRights != null) {
            right2.grantableRights.remove(schemaObject, right);
        }
        if (bl) {
            return;
        }
        if (right.isFull) {
            this.directRightsMap.remove(hsqlName, right2);
            grantee.grantedRightsMap.remove(hsqlName, right2);
            this.updateAllRights();
            return;
        }
        right2.remove(schemaObject, right);
        if (right2.isEmpty()) {
            this.directRightsMap.remove(hsqlName, right2);
            grantee.grantedRightsMap.remove(hsqlName, right2);
        }
        this.updateAllRights();
    }

    void revokeDbObject(HsqlNameManager.HsqlName hsqlName) {
        this.directRightsMap.remove(hsqlName);
        this.grantedRightsMap.remove(hsqlName);
        this.fullRightsMap.remove(hsqlName);
    }

    void updateRightsForNewColumn(HsqlNameManager.HsqlName hsqlName, HsqlNameManager.HsqlName hsqlName2) {
        Iterator iterator = this.directRightsMap.get(hsqlName);
        Right right = null;
        while (iterator.hasNext()) {
            right = (Right)iterator.next();
        }
        if (right == null) {
            return;
        }
        right.addNewColumn(hsqlName2);
        this.updateAllRights();
    }

    void updateRightsForNewColumn(HsqlNameManager.HsqlName hsqlName) {
        Iterator iterator = this.grantedRightsMap.get(hsqlName);
        Right right = null;
        while (iterator.hasNext()) {
            right = (Right)iterator.next();
        }
        if (right == null) {
            return;
        }
        this.updateAllRights();
    }

    void clearPrivileges() {
        this.roles.clear();
        this.directRightsMap.clear();
        this.grantedRightsMap.clear();
        this.fullRightsMap.clear();
        this.isAdmin = false;
    }

    public OrderedHashSet getColumnsForAllPrivileges(SchemaObject schemaObject) {
        if (schemaObject instanceof Table) {
            Table table = (Table)schemaObject;
            if (this.isFullyAccessibleByRole(table.getName())) {
                return table.getColumnNameSet();
            }
            Right right = (Right)this.fullRightsMap.get(table.getName());
            return right == null ? Right.emptySet : right.getColumnsForAllRights(table);
        }
        return Right.emptySet;
    }

    public OrderedHashSet getAllDirectPrivileges(SchemaObject schemaObject) {
        Iterator iterator;
        if (schemaObject.getOwner() == this) {
            OrderedHashSet orderedHashSet = new OrderedHashSet();
            orderedHashSet.add(this.ownerRights);
            return orderedHashSet;
        }
        HsqlNameManager.HsqlName hsqlName = schemaObject.getName();
        if (schemaObject instanceof Routine) {
            hsqlName = ((Routine)schemaObject).getSpecificName();
        }
        if ((iterator = this.directRightsMap.get(hsqlName)).hasNext()) {
            OrderedHashSet orderedHashSet = new OrderedHashSet();
            while (iterator.hasNext()) {
                orderedHashSet.add(iterator.next());
            }
            return orderedHashSet;
        }
        return Right.emptySet;
    }

    public OrderedHashSet getAllGrantedPrivileges(SchemaObject schemaObject) {
        Iterator iterator;
        HsqlNameManager.HsqlName hsqlName = schemaObject.getName();
        if (schemaObject instanceof Routine) {
            hsqlName = ((Routine)schemaObject).getSpecificName();
        }
        if ((iterator = this.grantedRightsMap.get(hsqlName)).hasNext()) {
            OrderedHashSet orderedHashSet = new OrderedHashSet();
            while (iterator.hasNext()) {
                orderedHashSet.add(iterator.next());
            }
            return orderedHashSet;
        }
        return Right.emptySet;
    }

    public Right checkSelect(SchemaObject schemaObject, boolean[] blArray) {
        if (schemaObject instanceof Table) {
            Table table = (Table)schemaObject;
            if (this.isFullyAccessibleByRole(table.getName())) {
                return Right.fullRights;
            }
            Right right = (Right)this.fullRightsMap.get(table.getName());
            if (right != null && right.canSelect(table, blArray)) {
                return right;
            }
        }
        throw Error.error(5501, schemaObject.getName().name);
    }

    public Right checkInsert(SchemaObject schemaObject, boolean[] blArray) {
        if (schemaObject instanceof Table) {
            Table table = (Table)schemaObject;
            if (this.isFullyAccessibleByRole(table.getName())) {
                return Right.fullRights;
            }
            Right right = (Right)this.fullRightsMap.get(table.getName());
            if (right != null && right.canInsert(table, blArray)) {
                return right;
            }
        }
        throw Error.error(5501, schemaObject.getName().name);
    }

    public Right checkUpdate(SchemaObject schemaObject, boolean[] blArray) {
        if (schemaObject instanceof Table) {
            Table table = (Table)schemaObject;
            if (this.isFullyAccessibleByRole(table.getName())) {
                return Right.fullRights;
            }
            Right right = (Right)this.fullRightsMap.get(table.getName());
            if (right != null && right.canUpdate(table, blArray)) {
                return right;
            }
        }
        throw Error.error(5501, schemaObject.getName().name);
    }

    public Right checkReferences(SchemaObject schemaObject, boolean[] blArray) {
        if (schemaObject instanceof Table) {
            Table table = (Table)schemaObject;
            if (this.isFullyAccessibleByRole(table.getName())) {
                return Right.fullRights;
            }
            Right right = (Right)this.fullRightsMap.get(table.getName());
            if (right != null && right.canReference(table, blArray)) {
                return right;
            }
        }
        throw Error.error(5501, schemaObject.getName().name);
    }

    public Right checkTrigger(SchemaObject schemaObject, boolean[] blArray) {
        if (schemaObject instanceof Table) {
            Table table = (Table)schemaObject;
            if (this.isFullyAccessibleByRole(table.getName())) {
                return Right.fullRights;
            }
            Right right = (Right)this.fullRightsMap.get(table.getName());
            if (right != null && right.canReference(table, blArray)) {
                return right;
            }
        }
        throw Error.error(5501, schemaObject.getName().name);
    }

    public Right checkDelete(SchemaObject schemaObject) {
        if (schemaObject instanceof Table) {
            Table table = (Table)schemaObject;
            if (this.isFullyAccessibleByRole(table.getName())) {
                return Right.fullRights;
            }
            Right right = (Right)this.fullRightsMap.get(table.getName());
            if (right != null && right.canDelete()) {
                return right;
            }
        }
        throw Error.error(5501, schemaObject.getName().name);
    }

    public Right checkAccess(SchemaObject schemaObject) {
        Right right;
        if (this.isFullyAccessibleByRole(schemaObject.getName())) {
            return Right.fullRights;
        }
        HsqlNameManager.HsqlName hsqlName = schemaObject.getName();
        if (schemaObject instanceof Routine) {
            hsqlName = ((Routine)schemaObject).getSpecificName();
        }
        if ((right = (Right)this.fullRightsMap.get(hsqlName)) != null && !right.isEmpty()) {
            return right;
        }
        throw Error.error(5501, schemaObject.getName().name);
    }

    public void checkSchemaUpdateOrGrantRights(String string) {
        if (!this.hasSchemaUpdateOrGrantRights(string)) {
            throw Error.error(5501, string);
        }
    }

    public boolean hasSchemaUpdateOrGrantRights(String string) {
        if (this.isAdmin()) {
            return true;
        }
        Grantee grantee = this.granteeManager.database.schemaManager.toSchemaOwner(string);
        if (grantee == this) {
            return true;
        }
        return this.hasRole(grantee);
    }

    public boolean isGrantable(SchemaObject schemaObject, Right right) {
        if (this.isFullyAccessibleByRole(schemaObject.getName())) {
            return true;
        }
        Right right2 = this.getAllGrantableRights(schemaObject.getName());
        return right2.contains(right);
    }

    public boolean isGrantable(Grantee grantee) {
        return this.isAdmin;
    }

    public boolean isFullyAccessibleByRole(HsqlNameManager.HsqlName hsqlName) {
        Grantee grantee;
        if (this.isAdmin) {
            return true;
        }
        if (hsqlName.type == 2) {
            grantee = hsqlName.owner;
        } else {
            if (hsqlName.schema == null) {
                return false;
            }
            grantee = hsqlName.schema.owner;
        }
        if (grantee == this) {
            return true;
        }
        return this.hasRole(grantee);
    }

    public void checkAdmin() {
        if (!this.isAdmin()) {
            throw Error.error(5507);
        }
    }

    public boolean isAdmin() {
        return this.isAdmin;
    }

    public boolean isSchemaCreator() {
        return this.isAdmin || this.hasRole(this.granteeManager.schemaRole);
    }

    public boolean canChangeAuthorisation() {
        return this.isAdmin || this.hasRole(this.granteeManager.changeAuthRole);
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public OrderedHashSet visibleGrantees() {
        OrderedHashSet orderedHashSet = new OrderedHashSet();
        GranteeManager granteeManager = this.granteeManager;
        if (this.isAdmin()) {
            orderedHashSet.addAll(granteeManager.getGrantees());
        } else {
            orderedHashSet.add(this);
            Iterator iterator = this.getAllRoles().iterator();
            while (iterator.hasNext()) {
                orderedHashSet.add(iterator.next());
            }
        }
        return orderedHashSet;
    }

    public boolean hasNonSelectTableRight(SchemaObject schemaObject) {
        if (this.isFullyAccessibleByRole(schemaObject.getName())) {
            return true;
        }
        Right right = (Right)this.fullRightsMap.get(schemaObject.getName());
        if (right == null) {
            return false;
        }
        return right.canAccesssNonSelect();
    }

    public boolean hasColumnRights(SchemaObject schemaObject, int[] nArray) {
        if (this.isFullyAccessibleByRole(schemaObject.getName())) {
            return true;
        }
        Right right = (Right)this.fullRightsMap.get(schemaObject.getName());
        if (right == null) {
            return false;
        }
        return right.canAccess((Table)schemaObject, nArray);
    }

    void setAdminDirect() {
        this.isAdminDirect = true;
        this.isAdmin = true;
    }

    boolean updateNestedRoles(Grantee grantee) {
        boolean bl = false;
        if (grantee != this) {
            for (int i = 0; i < this.roles.size(); ++i) {
                Grantee grantee2 = (Grantee)this.roles.get(i);
                bl |= grantee2.updateNestedRoles(grantee);
            }
        }
        if (bl) {
            this.updateAllRights();
        }
        return bl || grantee == this;
    }

    void updateAllRights() {
        this.fullRightsMap.clear();
        this.isAdmin = this.isAdminDirect;
        for (int i = 0; i < this.roles.size(); ++i) {
            Grantee grantee = (Grantee)this.roles.get(i);
            this.addToFullRights(grantee.fullRightsMap);
            this.isAdmin |= grantee.isAdmin();
        }
        this.addToFullRights(this.directRightsMap);
        if (!(this.isRole || this.isPublic || this.isSystem)) {
            this.addToFullRights(this.granteeManager.publicRole.fullRightsMap);
        }
    }

    void addToFullRights(HashMap hashMap) {
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Right right = (Right)hashMap.get(e);
            Right right2 = (Right)this.fullRightsMap.get(e);
            if (right2 == null) {
                right2 = right.duplicate();
                this.fullRightsMap.put(e, right2);
            } else {
                right2.add(right);
            }
            if (right.grantableRights == null) continue;
            if (right2.grantableRights == null) {
                right2.grantableRights = right.grantableRights.duplicate();
                continue;
            }
            right2.grantableRights.add(right.grantableRights);
        }
    }

    private void addToFullRights(MultiValueHashMap multiValueHashMap) {
        Iterator iterator = multiValueHashMap.keySet().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Iterator iterator2 = multiValueHashMap.get(e);
            Right right = (Right)this.fullRightsMap.get(e);
            while (iterator2.hasNext()) {
                Right right2 = (Right)iterator2.next();
                if (right == null) {
                    right = right2.duplicate();
                    this.fullRightsMap.put(e, right);
                } else {
                    right.add(right2);
                }
                if (right2.grantableRights == null) continue;
                if (right.grantableRights == null) {
                    right.grantableRights = right2.grantableRights.duplicate();
                    continue;
                }
                right.grantableRights.add(right2.grantableRights);
            }
        }
    }

    Right getAllGrantableRights(HsqlNameManager.HsqlName hsqlName) {
        if (this.isAdmin) {
            return hsqlName.schema.owner.ownerRights;
        }
        if (hsqlName.schema.owner == this) {
            return this.ownerRights;
        }
        if (this.roles.contains(hsqlName.schema.owner)) {
            return hsqlName.schema.owner.ownerRights;
        }
        OrderedHashSet orderedHashSet = this.getAllRoles();
        for (int i = 0; i < orderedHashSet.size(); ++i) {
            Grantee grantee = (Grantee)orderedHashSet.get(i);
            if (hsqlName.schema.owner != grantee) continue;
            return grantee.ownerRights;
        }
        Right right = (Right)this.fullRightsMap.get(hsqlName);
        return right == null || right.grantableRights == null ? Right.noRights : right.grantableRights;
    }

    private MultiValueHashMap getRights() {
        return this.directRightsMap;
    }

    void grant(Grantee grantee) {
        this.roles.add(grantee);
    }

    void revoke(Grantee grantee) {
        if (!this.hasRoleDirect(grantee)) {
            throw Error.error(2253, grantee.getName().getNameString());
        }
        this.roles.remove(grantee);
    }

    private String roleMapToString(OrderedHashSet orderedHashSet) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < orderedHashSet.size(); ++i) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(',');
            }
            Grantee grantee = (Grantee)orderedHashSet.get(i);
            stringBuilder.append(grantee.getName().getStatementName());
        }
        return stringBuilder.toString();
    }

    HsqlArrayList getRightsSQL() {
        Object object;
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        String string = this.roleMapToString(this.roles);
        if (string.length() != 0) {
            object = new StringBuilder(128);
            ((StringBuilder)object).append("GRANT").append(' ').append(string);
            ((StringBuilder)object).append(' ').append("TO").append(' ');
            ((StringBuilder)object).append(this.getName().getStatementName());
            hsqlArrayList.add(((StringBuilder)object).toString());
        }
        object = this.getRights();
        Iterator iterator = ((MultiValueHashMap)object).keySet().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Iterator iterator2 = ((MultiValueHashMap)object).get(e);
            while (iterator2.hasNext()) {
                Right right = (Right)iterator2.next();
                StringBuilder stringBuilder = new StringBuilder(128);
                HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)e;
                switch (hsqlName.type) {
                    case 3: 
                    case 4: {
                        Table table = this.granteeManager.database.schemaManager.findUserTable(hsqlName.name, hsqlName.schema.name);
                        if (table == null) break;
                        stringBuilder.append("GRANT").append(' ');
                        stringBuilder.append(right.getTableRightsSQL(table));
                        stringBuilder.append(' ').append("ON").append(' ');
                        stringBuilder.append("TABLE").append(' ');
                        stringBuilder.append(hsqlName.getSchemaQualifiedStatementName());
                        break;
                    }
                    case 7: {
                        NumberSequence numberSequence = (NumberSequence)this.granteeManager.database.schemaManager.findSchemaObject(hsqlName.name, hsqlName.schema.name, 7);
                        if (numberSequence == null) break;
                        stringBuilder.append("GRANT").append(' ');
                        stringBuilder.append("USAGE");
                        stringBuilder.append(' ').append("ON").append(' ');
                        stringBuilder.append("SEQUENCE").append(' ');
                        stringBuilder.append(hsqlName.getSchemaQualifiedStatementName());
                        break;
                    }
                    case 13: {
                        Type type = (Type)this.granteeManager.database.schemaManager.findSchemaObject(hsqlName.name, hsqlName.schema.name, 13);
                        if (type == null) break;
                        stringBuilder.append("GRANT").append(' ');
                        stringBuilder.append("USAGE");
                        stringBuilder.append(' ').append("ON").append(' ');
                        stringBuilder.append("DOMAIN").append(' ');
                        stringBuilder.append(hsqlName.getSchemaQualifiedStatementName());
                        break;
                    }
                    case 12: {
                        Type type = (Type)this.granteeManager.database.schemaManager.findSchemaObject(hsqlName.name, hsqlName.schema.name, 13);
                        if (type == null) break;
                        stringBuilder.append("GRANT").append(' ');
                        stringBuilder.append("USAGE");
                        stringBuilder.append(' ').append("ON").append(' ');
                        stringBuilder.append("TYPE").append(' ');
                        stringBuilder.append(hsqlName.getSchemaQualifiedStatementName());
                        break;
                    }
                    case 16: 
                    case 17: 
                    case 24: {
                        SchemaObject schemaObject = this.granteeManager.database.schemaManager.findSchemaObject(hsqlName.name, hsqlName.schema.name, hsqlName.type);
                        if (schemaObject == null) break;
                        stringBuilder.append("GRANT").append(' ');
                        stringBuilder.append("EXECUTE").append(' ');
                        stringBuilder.append("ON").append(' ');
                        stringBuilder.append("SPECIFIC").append(' ');
                        if (schemaObject.getType() == 17) {
                            stringBuilder.append("PROCEDURE");
                        } else {
                            stringBuilder.append("FUNCTION");
                        }
                        stringBuilder.append(' ');
                        stringBuilder.append(hsqlName.getSchemaQualifiedStatementName());
                        break;
                    }
                }
                if (stringBuilder.length() == 0) continue;
                stringBuilder.append(' ').append("TO").append(' ');
                stringBuilder.append(this.getName().getStatementName());
                hsqlArrayList.add(stringBuilder.toString());
            }
        }
        return hsqlArrayList;
    }
}

