/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.Weigher;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.languagetool.AnalyzedSentence;
import org.languagetool.InputSentence;
import org.languagetool.SimpleInputSentence;
import org.languagetool.rules.RuleMatch;

public class ResultCache {
    private final Cache<InputSentence, Map<String, List<RuleMatch>>> remoteMatchesCache;
    private final Cache<InputSentence, List<RuleMatch>> matchesCache;
    private final Cache<SimpleInputSentence, AnalyzedSentence> sentenceCache;

    public ResultCache(long maxSize) {
        this(maxSize, 5L, TimeUnit.MINUTES);
    }

    public ResultCache(long maxSize, long expireAfter, TimeUnit timeUnit) {
        if (maxSize < 0L) {
            throw new IllegalArgumentException("Result cache size must be >= 0: " + maxSize);
        }
        this.matchesCache = CacheBuilder.newBuilder().maximumWeight(maxSize / 2L).weigher((Weigher)new MatchesWeigher()).recordStats().expireAfterAccess(expireAfter, timeUnit).build();
        this.remoteMatchesCache = CacheBuilder.newBuilder().maximumWeight(maxSize / 2L).weigher((Weigher)new RemoteMatchesWeigher()).recordStats().expireAfterAccess(expireAfter, timeUnit).build();
        this.sentenceCache = CacheBuilder.newBuilder().maximumWeight(maxSize / 2L).weigher((Weigher)new SentenceWeigher()).recordStats().expireAfterAccess(expireAfter, timeUnit).build();
    }

    public double hitRate() {
        return (this.matchesCache.stats().hitRate() + this.sentenceCache.stats().hitRate()) / 2.0;
    }

    public double requestCount() {
        return this.matchesCache.stats().requestCount() + this.sentenceCache.stats().requestCount();
    }

    public long hitCount() {
        return this.matchesCache.stats().hitCount() + this.sentenceCache.stats().hitCount();
    }

    public List<RuleMatch> getIfPresent(InputSentence key) {
        return (List)this.matchesCache.getIfPresent((Object)key);
    }

    public AnalyzedSentence getIfPresent(SimpleInputSentence key) {
        return (AnalyzedSentence)this.sentenceCache.getIfPresent((Object)key);
    }

    public void put(InputSentence key, List<RuleMatch> sentenceMatches) {
        this.matchesCache.put((Object)key, sentenceMatches);
    }

    public void put(SimpleInputSentence key, AnalyzedSentence aSentence) {
        this.sentenceCache.put((Object)key, (Object)aSentence);
    }

    public Cache<InputSentence, List<RuleMatch>> getMatchesCache() {
        return this.matchesCache;
    }

    public Cache<InputSentence, Map<String, List<RuleMatch>>> getRemoteMatchesCache() {
        return this.remoteMatchesCache;
    }

    public Cache<SimpleInputSentence, AnalyzedSentence> getSentenceCache() {
        return this.sentenceCache;
    }

    static class SentenceWeigher
    implements Weigher<SimpleInputSentence, AnalyzedSentence> {
        SentenceWeigher() {
        }

        public int weigh(SimpleInputSentence sentence, @NotNull AnalyzedSentence analyzedSentence) {
            return sentence.getText().length() / 75;
        }
    }

    static class RemoteMatchesWeigher
    implements Weigher<InputSentence, Map<String, List<RuleMatch>>> {
        RemoteMatchesWeigher() {
        }

        public int weigh(InputSentence sentence, @NotNull Map<String, List<RuleMatch>> matches) {
            return sentence.getText().length() / 75;
        }
    }

    static class MatchesWeigher
    implements Weigher<InputSentence, List<RuleMatch>> {
        MatchesWeigher() {
        }

        public int weigh(InputSentence sentence, List<RuleMatch> matches) {
            return sentence.getText().length() / 75 + matches.size();
        }
    }
}

