
#ifndef KCMUTILS_EXPORT_H
#define KCMUTILS_EXPORT_H

#ifdef KCMUTILS_STATIC_DEFINE
#  define KCMUTILS_EXPORT
#  define KCMUTILS_NO_EXPORT
#else
#  ifndef KCMUTILS_EXPORT
#    ifdef KF5KCMUtils_EXPORTS
        /* We are building this library */
#      define KCMUTILS_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define KCMUTILS_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef KCMUTILS_NO_EXPORT
#    define KCMUTILS_NO_EXPORT __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef KCMUTILS_DECL_DEPRECATED
#  define KCMUTILS_DECL_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef KCMUTILS_DECL_DEPRECATED_EXPORT
#  define KCMUTILS_DECL_DEPRECATED_EXPORT KCMUTILS_EXPORT KCMUTILS_DECL_DEPRECATED
#endif

#ifndef KCMUTILS_DECL_DEPRECATED_NO_EXPORT
#  define KCMUTILS_DECL_DEPRECATED_NO_EXPORT KCMUTILS_NO_EXPORT KCMUTILS_DECL_DEPRECATED
#endif

#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef KCMUTILS_NO_DEPRECATED
#    define KCMUTILS_NO_DEPRECATED
#  endif
#endif

#define KCMUTILS_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

#define ECM_GENERATEEXPORTHEADER_VERSION_VALUE(major, minor, patch) ((major<<16)|(minor<<8)|(patch))

/* Take any defaults from group settings */
#if !defined(KCMUTILS_NO_DEPRECATED) && !defined(KCMUTILS_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  ifdef KF_NO_DEPRECATED
#    define KCMUTILS_NO_DEPRECATED
#  elif defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#    define KCMUTILS_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#  endif
#endif
#if !defined(KCMUTILS_DISABLE_DEPRECATED_BEFORE_AND_AT) && defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  define KCMUTILS_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#endif

#if !defined(KCMUTILS_NO_DEPRECATED_WARNINGS) && !defined(KCMUTILS_DEPRECATED_WARNINGS_SINCE)
#  ifdef KF_NO_DEPRECATED_WARNINGS
#    define KCMUTILS_NO_DEPRECATED_WARNINGS
#  elif defined(KF_DEPRECATED_WARNINGS_SINCE)
#    define KCMUTILS_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#  endif
#endif
#if !defined(KCMUTILS_DEPRECATED_WARNINGS_SINCE) && defined(KF_DEPRECATED_WARNINGS_SINCE)
#  define KCMUTILS_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#endif

#if defined(KCMUTILS_NO_DEPRECATED)
#  undef KCMUTILS_DEPRECATED
#  define KCMUTILS_DEPRECATED_EXPORT KCMUTILS_EXPORT
#  define KCMUTILS_DEPRECATED_NO_EXPORT KCMUTILS_NO_EXPORT
#elif defined(KCMUTILS_NO_DEPRECATED_WARNINGS)
#  define KCMUTILS_DEPRECATED
#  define KCMUTILS_DEPRECATED_EXPORT KCMUTILS_EXPORT
#  define KCMUTILS_DEPRECATED_NO_EXPORT KCMUTILS_NO_EXPORT
#else
#  define KCMUTILS_DEPRECATED KCMUTILS_DECL_DEPRECATED
#  define KCMUTILS_DEPRECATED_EXPORT KCMUTILS_DECL_DEPRECATED_EXPORT
#  define KCMUTILS_DEPRECATED_NO_EXPORT KCMUTILS_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define KCMUTILS_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define KCMUTILS_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef KCMUTILS_NO_DEPRECATED
#  define KCMUTILS_DISABLE_DEPRECATED_BEFORE_AND_AT 0x55500
#endif
#ifdef KCMUTILS_NO_DEPRECATED_WARNINGS
#  define KCMUTILS_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef KCMUTILS_DEPRECATED_WARNINGS_SINCE
#  ifdef KCMUTILS_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define KCMUTILS_DEPRECATED_WARNINGS_SINCE KCMUTILS_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define KCMUTILS_DEPRECATED_WARNINGS_SINCE 0x55500
#  endif
#endif

#ifndef KCMUTILS_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define KCMUTILS_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef KCMUTILS_DEPRECATED
#  define KCMUTILS_ENABLE_DEPRECATED_SINCE(major, minor) (ECM_GENERATEEXPORTHEADER_VERSION_VALUE(major, minor, 0) > KCMUTILS_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define KCMUTILS_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#if KCMUTILS_DEPRECATED_WARNINGS_SINCE >= 0x54200
#  define KCMUTILS_DEPRECATED_VERSION_5_66(text) KCMUTILS_DECL_DEPRECATED_TEXT(text)
#else
#  define KCMUTILS_DEPRECATED_VERSION_5_66(text)
#endif

#if KCMUTILS_DEPRECATED_WARNINGS_SINCE >= 0x54c00
#  define KCMUTILS_DEPRECATED_VERSION_5_76(text) KCMUTILS_DECL_DEPRECATED_TEXT(text)
#else
#  define KCMUTILS_DEPRECATED_VERSION_5_76(text)
#endif

#if KCMUTILS_DEPRECATED_WARNINGS_SINCE >= 0x55200
#  define KCMUTILS_DEPRECATED_VERSION_5_82(text) KCMUTILS_DECL_DEPRECATED_TEXT(text)
#else
#  define KCMUTILS_DEPRECATED_VERSION_5_82(text)
#endif

#if KCMUTILS_DEPRECATED_WARNINGS_SINCE >= 0x55500
#  define KCMUTILS_DEPRECATED_VERSION_5_85(text) KCMUTILS_DECL_DEPRECATED_TEXT(text)
#else
#  define KCMUTILS_DEPRECATED_VERSION_5_85(text)
#endif
#define KCMUTILS_DEPRECATED_VERSION_5(minor, text)      KCMUTILS_DEPRECATED_VERSION_5_##minor(text)
#define KCMUTILS_DEPRECATED_VERSION(major, minor, text) KCMUTILS_DEPRECATED_VERSION_##major(minor, "Since "#major"."#minor". " text)
#define KCMUTILS_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KCMUTILS_DEPRECATED_VERSION_##major(minor, "Since "#textmajor"."#textminor". " text)
#if defined(__cpp_enumerator_attributes) && __cpp_enumerator_attributes >= 201411
#  define KCMUTILS_ENUMERATOR_DEPRECATED_VERSION(major, minor, text) KCMUTILS_DEPRECATED_VERSION(major, minor, text)
#  define KCMUTILS_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KCMUTILS_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#else
#  define KCMUTILS_ENUMERATOR_DEPRECATED_VERSION(major, minor, text)
#  define KCMUTILS_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#endif

#endif /* KCMUTILS_EXPORT_H */


#ifndef ECM_GENERATEEXPORTHEADER_KCMUTILS_EXPORT_H
#define ECM_GENERATEEXPORTHEADER_KCMUTILS_EXPORT_H


#define KCMUTILS_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

#define ECM_GENERATEEXPORTHEADER_VERSION_VALUE(major, minor, patch) ((major<<16)|(minor<<8)|(patch))

/* Take any defaults from group settings */
#if !defined(KCMUTILS_NO_DEPRECATED) && !defined(KCMUTILS_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  ifdef KF_NO_DEPRECATED
#    define KCMUTILS_NO_DEPRECATED
#  elif defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#    define KCMUTILS_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#  endif
#endif
#if !defined(KCMUTILS_DISABLE_DEPRECATED_BEFORE_AND_AT) && defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  define KCMUTILS_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#endif

#if !defined(KCMUTILS_NO_DEPRECATED_WARNINGS) && !defined(KCMUTILS_DEPRECATED_WARNINGS_SINCE)
#  ifdef KF_NO_DEPRECATED_WARNINGS
#    define KCMUTILS_NO_DEPRECATED_WARNINGS
#  elif defined(KF_DEPRECATED_WARNINGS_SINCE)
#    define KCMUTILS_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#  endif
#endif
#if !defined(KCMUTILS_DEPRECATED_WARNINGS_SINCE) && defined(KF_DEPRECATED_WARNINGS_SINCE)
#  define KCMUTILS_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#endif

#if defined(KCMUTILS_NO_DEPRECATED)
#  undef KCMUTILS_DEPRECATED
#  define KCMUTILS_DEPRECATED_EXPORT KCMUTILS_EXPORT
#  define KCMUTILS_DEPRECATED_NO_EXPORT KCMUTILS_NO_EXPORT
#elif defined(KCMUTILS_NO_DEPRECATED_WARNINGS)
#  define KCMUTILS_DEPRECATED
#  define KCMUTILS_DEPRECATED_EXPORT KCMUTILS_EXPORT
#  define KCMUTILS_DEPRECATED_NO_EXPORT KCMUTILS_NO_EXPORT
#else
#  define KCMUTILS_DEPRECATED KCMUTILS_DECL_DEPRECATED
#  define KCMUTILS_DEPRECATED_EXPORT KCMUTILS_DECL_DEPRECATED_EXPORT
#  define KCMUTILS_DEPRECATED_NO_EXPORT KCMUTILS_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define KCMUTILS_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define KCMUTILS_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef KCMUTILS_NO_DEPRECATED
#  define KCMUTILS_DISABLE_DEPRECATED_BEFORE_AND_AT 0x55500
#endif
#ifdef KCMUTILS_NO_DEPRECATED_WARNINGS
#  define KCMUTILS_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef KCMUTILS_DEPRECATED_WARNINGS_SINCE
#  ifdef KCMUTILS_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define KCMUTILS_DEPRECATED_WARNINGS_SINCE KCMUTILS_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define KCMUTILS_DEPRECATED_WARNINGS_SINCE 0x55500
#  endif
#endif

#ifndef KCMUTILS_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define KCMUTILS_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef KCMUTILS_DEPRECATED
#  define KCMUTILS_ENABLE_DEPRECATED_SINCE(major, minor) (ECM_GENERATEEXPORTHEADER_VERSION_VALUE(major, minor, 0) > KCMUTILS_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define KCMUTILS_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#if KCMUTILS_DEPRECATED_WARNINGS_SINCE >= 0x54200
#  define KCMUTILS_DEPRECATED_VERSION_5_66(text) KCMUTILS_DECL_DEPRECATED_TEXT(text)
#else
#  define KCMUTILS_DEPRECATED_VERSION_5_66(text)
#endif

#if KCMUTILS_DEPRECATED_WARNINGS_SINCE >= 0x54c00
#  define KCMUTILS_DEPRECATED_VERSION_5_76(text) KCMUTILS_DECL_DEPRECATED_TEXT(text)
#else
#  define KCMUTILS_DEPRECATED_VERSION_5_76(text)
#endif

#if KCMUTILS_DEPRECATED_WARNINGS_SINCE >= 0x55200
#  define KCMUTILS_DEPRECATED_VERSION_5_82(text) KCMUTILS_DECL_DEPRECATED_TEXT(text)
#else
#  define KCMUTILS_DEPRECATED_VERSION_5_82(text)
#endif

#if KCMUTILS_DEPRECATED_WARNINGS_SINCE >= 0x55500
#  define KCMUTILS_DEPRECATED_VERSION_5_85(text) KCMUTILS_DECL_DEPRECATED_TEXT(text)
#else
#  define KCMUTILS_DEPRECATED_VERSION_5_85(text)
#endif
#define KCMUTILS_DEPRECATED_VERSION_5(minor, text)      KCMUTILS_DEPRECATED_VERSION_5_##minor(text)
#define KCMUTILS_DEPRECATED_VERSION(major, minor, text) KCMUTILS_DEPRECATED_VERSION_##major(minor, "Since "#major"."#minor". " text)
#define KCMUTILS_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KCMUTILS_DEPRECATED_VERSION_##major(minor, "Since "#textmajor"."#textminor". " text)
#if defined(__cpp_enumerator_attributes) && __cpp_enumerator_attributes >= 201411
#  define KCMUTILS_ENUMERATOR_DEPRECATED_VERSION(major, minor, text) KCMUTILS_DEPRECATED_VERSION(major, minor, text)
#  define KCMUTILS_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KCMUTILS_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#else
#  define KCMUTILS_ENUMERATOR_DEPRECATED_VERSION(major, minor, text)
#  define KCMUTILS_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#endif


#endif /* ECM_GENERATEEXPORTHEADER_KCMUTILS_EXPORT_H */
