/*
 * Copyright (c) 2012, 2021, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2020 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_ko extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_GH = "\uac00\ub098";
        final String metaValue_key_nu = "\uc22b\uc790";
        final Object[][] data = new Object[][] {
            { "ksh", "\ucf5c\ub85c\uadf8\ub2c8\uc548\uc5b4" },
            { "Ogam", "\uc624\uac80 \ubb38\uc790" },
            { "mwl", "\ubbf8\ub780\ub370\uc5b4" },
            { "Zsym", "\uae30\ud638" },
            { "cch", "\uc557\uc0bc\uc5b4" },
            { "mwr", "\ub9c8\ub974\uc640\ub9ac\uc5b4" },
            { "type.nu.lanatham", "\ud0c0\uc774 \ud0d0\ud0d0 \uc22b\uc790" },
            { "Tagb", "\ud0c0\uadf8\ubc18\uc640 \ubb38\uc790" },
            { "Zsye", "\uc774\ubaa8\ud2f0\ucf58" },
            { "ccp", "\ucc28\ud06c\ub9c8\uc5b4" },
            { "egy", "\uace0\ub300 \uc774\uc9d1\ud2b8\uc5b4" },
            { "raj", "\ub77c\uc790\uc2a4\ud0c4\uc5b4" },
            { "Phag", "\ud30c\uc2a4\ud30c \ubb38\uc790" },
            { "tem", "\ud300\ub2c8\uc5b4" },
            { "teo", "\ud14c\uc870\uc5b4" },
            { "rap", "\ub77c\ud30c\ub274\uc774" },
            { "ter", "\ud14c\ub808\ub178\uc5b4" },
            { "AC", "\uc5b4\uc13c\uc158 \uc12c" },
            { "rar", "\ub77c\ub85c\ud1b5\uac00\uc5b4" },
            { "tet", "\ud14c\ud23c\uc5b4" },
            { "AD", "\uc548\ub3c4\ub77c" },
            { "AE", "\uc544\ub78d\uc5d0\ubbf8\ub9ac\ud2b8" },
            { "nl_BE", "\ud50c\ub77c\ub9dd\uc5b4" },
            { "AF", "\uc544\ud504\uac00\ub2c8\uc2a4\ud0c4" },
            { "AG", "\uc564\ud2f0\uac00 \ubc14\ubd80\ub2e4" },
            { "type.ca.ethiopic", "\uc5d0\ud2f0\uc624\ud53c\uc544\ub825" },
            { "glk", "\uae38\ub77c\ud0a4\uc5b4" },
            { "AI", "\uc575\uadc8\ub77c" },
            { "key.tz", "\uc2dc\uac04\ub300" },
            { "AL", "\uc54c\ubc14\ub2c8\uc544" },
            { "AM", "\uc544\ub974\uba54\ub2c8\uc544" },
            { "Teng", "\ud161\uacfc\ub974 \ubb38\uc790" },
            { "AO", "\uc559\uace8\ub77c" },
            { "AQ", "\ub0a8\uadf9 \ub300\ub959" },
            { "AR", "\uc544\ub974\ud5e8\ud2f0\ub098" },
            { "Prti", "\uba85\ubb38 \ud30c\ub77c\ud2f0\uc544 \ubb38\uc790" },
            { "AS", "\uc544\uba54\ub9ac\uce78 \uc0ac\ubaa8\uc544" },
            { "AT", "\uc624\uc2a4\ud2b8\ub9ac\uc544" },
            { "AU", "\uc624\uc2a4\ud2b8\ub808\uc77c\ub9ac\uc544" },
            { "AW", "\uc544\ub8e8\ubc14" },
            { "AX", "\uc62c\ub780\ub4dc \uc81c\ub3c4" },
            { "mye", "\ubbf8\uc608\ub124\uc5b4" },
            { "AZ", "\uc544\uc81c\ub974\ubc14\uc774\uc794" },
            { "BA", "\ubcf4\uc2a4\ub2c8\uc544 \ud5e4\ub974\uccb4\uace0\ube44\ub098" },
            { "BB", "\ubc14\ubca0\uc774\ub3c4\uc2a4" },
            { "ceb", "\uc138\ubd80\uc544\ub178\uc5b4" },
            { "BD", "\ubc29\uae00\ub77c\ub370\uc2dc" },
            { "kum", "\ucfe0\ubbf9\uc5b4" },
            { "BE", "\ubca8\uae30\uc5d0" },
            { "gmh", "\uc911\uc138 \uace0\uc9c0 \ub3c5\uc77c\uc5b4" },
            { "BF", "\ubd80\ub974\ud0a4\ub098\ud30c\uc18c" },
            { "BG", "\ubd88\uac00\ub9ac\uc544" },
            { "BH", "\ubc14\ub808\uc778" },
            { "BI", "\ubd80\ub8ec\ub514" },
            { "BJ", "\ubca0\ub0c9" },
            { "BL", "\uc0dd\ubc14\ub974\ud154\ub808\ubbf8" },
            { "BM", "\ubc84\ubba4\ub2e4" },
            { "kut", "\ucfe0\ud14c\ub124\uc5b4" },
            { "myv", "\uc5d8\uc988\uc57c\uc5b4" },
            { "BN", "\ube0c\ub8e8\ub098\uc774" },
            { "BO", "\ubcfc\ub9ac\ube44\uc544" },
            { "BQ", "\ub124\ub35c\ub780\ub4dc\ub839 \uce74\ub9ac\ube0c" },
            { "BR", "\ube0c\ub77c\uc9c8" },
            { "BS", "\ubc14\ud558\ub9c8" },
            { "xog", "\uc18c\uac00\uc5b4" },
            { "BT", "\ubd80\ud0c4" },
            { "BV", "\ubd80\ubca0\uc12c" },
            { "BW", "\ubcf4\uce20\uc640\ub098" },
            { "BY", "\ubca8\ub77c\ub8e8\uc2a4" },
            { "BZ", "\ubca8\ub9ac\uc988" },
            { "Visp", "\uc2dc\ud654\ubc95" },
            { "type.ca.persian", "\ud398\ub974\uc2dc\uc548\ub825" },
            { "type.nu.hebr", "\ud788\ube0c\ub9ac \uc22b\uc790" },
            { "CA", "\uce90\ub098\ub2e4" },
            { "CC", "\ucf54\ucf54\uc2a4 \uc81c\ub3c4" },
            { "mzn", "\ub9c8\uc794\ub370\ub77c\ub2c8\uc5b4" },
            { "CD", "\ucf69\uace0-\ud0a8\uc0e4\uc0ac" },
            { "CF", "\uc911\uc559 \uc544\ud504\ub9ac\uce74 \uacf5\ud654\uad6d" },
            { "CG", "\ucf69\uace0-\ube0c\ub77c\uc790\ube4c" },
            { "CH", "\uc2a4\uc704\uc2a4" },
            { "CI", "\ucf54\ud2b8\ub514\ubd80\uc544\ub974" },
            { "CK", "\ucfe1 \uc81c\ub3c4" },
            { "CL", "\uce60\ub808" },
            { "Kthi", "\uce74\uc774\uc2dc \ubb38\uc790" },
            { "CM", "\uce74\uba54\ub8ec" },
            { "CN", "\uc911\uad6d" },
            { "CO", "\ucf5c\ub86c\ube44\uc544" },
            { "CP", "\ud074\ub9ac\ud37c\ud134\uc12c" },
            { "CR", "\ucf54\uc2a4\ud0c0\ub9ac\uce74" },
            { "CU", "\ucfe0\ubc14" },
            { "CV", "\uce74\ubcf4\ubca0\ub974\ub370" },
            { "CW", "\ud034\ub77c\uc18c" },
            { "CX", "\ud06c\ub9ac\uc2a4\ub9c8\uc2a4\uc12c" },
            { "CY", "\ud0a4\ud504\ub85c\uc2a4" },
            { "type.nu.bali", "\ubc1c\ub9ac \uc22b\uc790" },
            { "CZ", "\uccb4\ucf54" },
            { "eka", "\uc774\uce74\uc8fd\uc5b4" },
            { "DE", "\ub3c5\uc77c" },
            { "goh", "\uace0\ub300 \uace0\uc9c0 \ub3c5\uc77c\uc5b4" },
            { "ace", "\uc544\uccb4\uc5b4" },
            { "cgg", "\uce58\uac00\uc5b4" },
            { "DG", "\ub514\uc5d0\uace0 \uac00\ub974\uc2dc\uc544" },
            { "gom", "\uace0\uc544 \ucf58\uce78\uc5b4" },
            { "type.nu.deva", "\ub370\ubc14\ub098\uac00\ub9ac \uc22b\uc790" },
            { "DJ", "\uc9c0\ubd80\ud2f0" },
            { "DK", "\ub374\ub9c8\ud06c" },
            { "ach", "\uc544\ucf5c\ub9ac\uc5b4" },
            { "gon", "\uace4\ub514\uc5b4" },
            { "Brai", "\ube0c\ub77c\uc720 \uc810\uc790" },
            { "Brah", "\ube0c\ub77c\ubbf8" },
            { "DM", "\ub3c4\ubbf8\ub2c8\uce74" },
            { "type.nu.armnlow", "\uc544\ub974\uba54\ub2c8\uc544 \uc18c\ubb38\uc790 \uc22b\uc790" },
            { "DO", "\ub3c4\ubbf8\ub2c8\uce74 \uacf5\ud654\uad6d" },
            { "gor", "\uace0\ub860\ud0c8\ub85c\uc5b4" },
            { "got", "\uace0\ud2b8\uc5b4" },
            { "Mtei", "\uba54\uc774\ud14c\uc774 \ub9c8\uc609 \ubb38\uc790" },
            { "zun", "\uc8fc\ub2c8\uc5b4" },
            { "tig", "\ud2f0\uadf8\ub808\uc5b4" },
            { "Takr", "\ud0c0\ud06c\ub9ac \ubb38\uc790" },
            { "DZ", "\uc54c\uc81c\ub9ac" },
            { "pag", "\ud310\uac00\uc2dc\ub09c\uc5b4" },
            { "type.d0.hwidth", "\ubc18\uac01" },
            { "pal", "\ud314\ub808\ube44\uc5b4" },
            { "EA", "\uc138\uc6b0\ud0c0 \ubc0f \uba5c\ub9ac\uc57c" },
            { "chb", "\uce58\ube0c\ucc28\uc5b4" },
            { "pam", "\ud31c\ud321\uac00\uc5b4" },
            { "EC", "\uc5d0\ucf70\ub3c4\ub974" },
            { "pap", "\ud30c\ud53c\uc544\uba3c\ud1a0\uc5b4" },
            { "ada", "\uc544\ub2f9\uba54\uc5b4" },
            { "EE", "\uc5d0\uc2a4\ud1a0\ub2c8\uc544" },
            { "tiv", "\ud2f0\ube0c\uc5b4" },
            { "EG", "\uc774\uc9d1\ud2b8" },
            { "EH", "\uc11c\uc0ac\ud558\ub77c" },
            { "chg", "\ucc28\uac00\ud0c0\uc774\uc5b4" },
            { "pau", "\ud314\ub77c\uc6b0\uc5b4" },
            { "chk", "\ucd94\ud06c\uc5b4" },
            { "chn", "\uce58\ub204\ud06c \uc790\uace4" },
            { "chm", "\ub9c8\ub9ac\uc5b4" },
            { "chp", "\uce58\ud398\uc6b0\uc580" },
            { "cho", "\ucd09\ud1a0\uc5b4" },
            { "chr", "\uccb4\ub85c\ud0a4\uc5b4" },
            { "ER", "\uc5d0\ub9ac\ud2b8\ub9ac\uc544" },
            { "ES", "\uc2a4\ud398\uc778" },
            { "ET", "\uc5d0\ud2f0\uc624\ud53c\uc544" },
            { "EU", "\uc720\ub7fd \uc5f0\ud569" },
            { "elx", "\uc5d8\ub78c\uc5b4" },
            { "type.ca.gregorian", "\uc591\ub825" },
            { "EZ", "\uc720\ub85c\uc874" },
            { "chy", "\uc0e4\uc774\uc5d4\uc5b4" },
            { "type.nu.gujr", "\uad6c\uc790\ub77c\ud2b8 \uc22b\uc790" },
            { "Inds", "\uc778\ub354\uc2a4 \ubb38\uc790" },
            { "ady", "\uc544\ub514\uac8c\uc5b4" },
            { "aeb", "\ud280\ub2c8\uc9c0 \uc544\ub78d\uc5b4" },
            { "FI", "\ud540\ub780\ub4dc" },
            { "FJ", "\ud53c\uc9c0" },
            { "FK", "\ud3ec\ud074\ub79c\ub4dc \uc81c\ub3c4" },
            { "FM", "\ubbf8\ud06c\ub85c\ub124\uc2dc\uc544" },
            { "key.va", "\ubc29\uc5b8" },
            { "FO", "\ud398\ub85c \uc81c\ub3c4" },
            { "Taml", "\ud0c0\ubc00 \ubb38\uc790" },
            { "FR", "\ud504\ub791\uc2a4" },
            { "Kpel", "\ud06c\ud3a0\ub808 \ubb38\uc790" },
            { "tkl", "\ud1a0\ucf08\ub77c\uc6b0\uc81c\ub3c4\uc5b4" },
            { "grb", "\uac8c\ub974\ubcf4\uc5b4" },
            { "root", "\uc5b4\uadfc" },
            { "type.ca.indian", "\uc778\ub3c4\ub825" },
            { "grc", "\uace0\ub300 \uadf8\ub9ac\uc2a4\uc5b4" },
            { "GA", "\uac00\ubd09" },
            { "tkr", "\ucc28\ud6c4\ub974\uc5b4" },
            { "vot", "\ubcf4\ud2f1\uc5b4" },
            { "GB", "\uc601\uad6d" },
            { "pcm", "\ub098\uc774\uc9c0\ub9ac\uc544 \ud53c\uc9c4\uc5b4" },
            { "GD", "\uadf8\ub808\ub098\ub2e4" },
            { "GE", "\uc870\uc9c0\uc544" },
            { "GF", "\ud504\ub791\uc2a4\ub839 \uae30\uc544\ub098" },
            { "GG", "\uac74\uc9c0" },
            { "GH", metaValue_GH },
            { "Tale", "\ud0c0\uc774 \ub808 \ubb38\uc790" },
            { "GI", "\uc9c0\ube0c\ub864\ud130" },
            { "afh", "\uc544\ud504\ub9ac\ud790\ub9ac\uc5b4" },
            { "GL", "\uadf8\ub9b0\ub780\ub4dc" },
            { "enm", "\uc911\uc138 \uc601\uc5b4" },
            { "GM", "\uac10\ube44\uc544" },
            { "GN", "\uae30\ub2c8" },
            { "GP", "\uacfc\ub4e4\ub8e8\ud504" },
            { "GQ", "\uc801\ub3c4 \uae30\ub2c8" },
            { "GR", "\uadf8\ub9ac\uc2a4" },
            { "GS", "\uc0ac\uc6b0\uc2a4\uc870\uc9c0\uc544 \uc0ac\uc6b0\uc2a4\uc0cc\ub4dc\uc704\uce58 \uc81c\ub3c4" },
            { "GT", "\uacfc\ud14c\ub9d0\ub77c" },
            { "GU", "\uad0c" },
            { "GW", "\uae30\ub2c8\ube44\uc0ac\uc6b0" },
            { "tli", "\ud2c0\ub9c1\uae43\uc871\uc5b4" },
            { "tlh", "\ud074\ub9c1\uc628\uc5b4" },
            { "Talu", "\uc2e0 \ud0c0\uc774 \ub8e8\uc5d0" },
            { "GY", "\uac00\uc774\uc544\ub098" },
            { "ckb", "\uc18c\ub77c\ub2c8 \ucfe0\ub974\ub4dc\uc5b4" },
            { "zxx", "\uc5b8\uc5b4 \uad00\ub828 \ub0b4\uc6a9 \uc5c6\uc74c" },
            { "Jurc", "\uc904\uccb8 \ubb38\uc790" },
            { "tly", "\ud0c8\ub9ac\uc26c\uc5b4" },
            { "HK", "\ud64d\ucf69(\uc911\uad6d \ud2b9\ubcc4\ud589\uc815\uad6c)" },
            { "Vaii", "\ubc14\uc774 \ubb38\uc790" },
            { "HM", "\ud5c8\ub4dc \ub9e5\ub3c4\ub110\ub4dc \uc81c\ub3c4" },
            { "HN", "\uc628\ub450\ub77c\uc2a4" },
            { "HR", "\ud06c\ub85c\uc544\ud2f0\uc544" },
            { "agq", "\uc544\uadf8\ud584\uc5b4" },
            { "gsw", "\ub3c5\uc77c\uc5b4(\uc2a4\uc704\uc2a4)" },
            { "type.ca.islamic-umalqura", "\uc774\uc2ac\ub78c\ub825(\uc6c0 \uc54c \ucfe0\ub77c)" },
            { "HT", "\uc544\uc774\ud2f0" },
            { "HU", "\ud5dd\uac00\ub9ac" },
            { "tmh", "\ud0c0\ub9c8\uc139\uc5b4" },
            { "IC", "\uce74\ub098\ub9ac\uc544 \uc81c\ub3c4" },
            { "nan", "\ubbfc\ub09c\uc5b4" },
            { "ID", "\uc778\ub3c4\ub124\uc2dc\uc544" },
            { "peo", "\uace0\ub300 \ud398\ub974\uc2dc\uc544\uc5b4" },
            { "type.nu.kali", "\uce74\uc57c \ub9ac\uc2dd \uc22b\uc790" },
            { "IE", "\uc544\uc77c\ub79c\ub4dc" },
            { "nap", "\ub098\ud3f4\ub9ac\uc5b4" },
            { "%%NDYUKA", "\ub290\ub4c0\uce74 \ubc29\uc5b8" },
            { "naq", "\ub098\ub9c8\uc5b4" },
            { "zza", "\uc790\uc790\uc5b4" },
            { "Tang", "\ud0d5\uad6c\ud2b8 \ubb38\uc790" },
            { "IL", "\uc774\uc2a4\ub77c\uc5d8" },
            { "Nbat", "\ub098\ubc14\ud14c\uc544 \ubb38\uc790" },
            { "IM", "\ub9e8\uc12c" },
            { "IN", "\uc778\ub3c4" },
            { "type.co.eor", "\uc720\ub7fd \uc815\ub82c \uaddc\uce59" },
            { "IO", "\uc601\uad6d\ub839 \uc778\ub3c4\uc591 \uc2dd\ubbfc\uc9c0" },
            { "IQ", "\uc774\ub77c\ud06c" },
            { "IR", "\uc774\ub780" },
            { "IS", "\uc544\uc774\uc2ac\ub780\ub4dc" },
            { "IT", "\uc774\ud0c8\ub9ac\uc544" },
            { "Zmth", "\uc218\ud559 \uae30\ud638" },
            { "type.nu.thai", "\ud0dc\uad6d \uc22b\uc790" },
            { "%%POSIX", "Computer" },
            { "type.nu.beng", "\ubc45\uace8 \uc22b\uc790" },
            { "JE", "\uc800\uc9c0" },
            { "type.ca.islamic", "\uc774\uc2ac\ub78c\ub825" },
            { "JM", "\uc790\uba54\uc774\uce74" },
            { "Beng", "\ubcb5\uace8 \ubb38\uc790" },
            { "JO", "\uc694\ub974\ub2e8" },
            { "JP", "\uc77c\ubcf8" },
            { "%%1606NICT", "\uc911\uc138 \ud6c4\uae30 \ud504\ub791\uc2a4\uc5b4(1606\ub144\uae4c\uc9c0)" },
            { "ain", "\uc544\uc774\ub204\uc5b4" },
            { "Mend", "\uba58\ub370 \ubb38\uc790" },
            { "guz", "\uad6c\uc2dc\uc5b4" },
            { "tog", "\ub2c8\uc544\uc0ac \ud1b5\uac00\uc5b4" },
            { "type.nu.knda", "\uce78\ub098\ub2e4 \uc22b\uc790" },
            { "Kali", "\uce74\uc57c \ub9ac \ubb38\uc790" },
            { "Sidd", "\uc2e4\ub2f4\uc790" },
            { "de_CH", "\uace0\uc9c0 \ub3c5\uc77c\uc5b4(\uc2a4\uc704\uc2a4)" },
            { "type.co.phonetic", "\uc18c\ub9ac\ub098\ub294 \ub300\ub85c \uc815\ub82c \uc21c\uc11c" },
            { "type.ca.buddhist", "\ubd88\uad50\ub825" },
            { "KE", "\ucf00\ub0d0" },
            { "419", "\ub77c\ud2f4 \uc544\uba54\ub9ac\uce74" },
            { "KG", "\ud0a4\ub974\uae30\uc2a4\uc2a4\ud0c4" },
            { "KH", "\uce84\ubcf4\ub514\uc544" },
            { "KI", "\ud0a4\ub9ac\ubc14\uc2dc" },
            { "KM", "\ucf54\ubaa8\ub85c" },
            { "KN", "\uc138\uc778\ud2b8\ud0a4\uce20 \ub124\ube44\uc2a4" },
            { "Knda", "\uce78\ub098\ub2e4 \ubb38\uc790" },
            { "Zinh", "\uad6c\uc804 \ubb38\uc790" },
            { "KP", "\ubd81\ud55c" },
            { "KR", "\ub300\ud55c\ubbfc\uad6d" },
            { "Plrd", "\ud3f4\ub77c\ub4dc \ud45c\uc74c \ubb38\uc790" },
            { "KW", "\ucfe0\uc6e8\uc774\ud2b8" },
            { "tpi", "\ud1a0\ud06c \ud53c\uc2e0\uc5b4" },
            { "KY", "\ucf00\uc774\ub9e8 \uc81c\ub3c4" },
            { "KZ", "\uce74\uc790\ud750\uc2a4\ud0c4" },
            { "Cyrl", "\ud0a4\ub9b4 \ubb38\uc790" },
            { "LA", "\ub77c\uc624\uc2a4" },
            { "LB", "\ub808\ubc14\ub17c" },
            { "LC", "\uc138\uc778\ud2b8\ub8e8\uc2dc\uc544" },
            { "phn", "\ud398\ub2c8\ud0a4\uc544\uc5b4" },
            { "Cyrs", "\uace0\ub300\uad50\ud68c\uc2ac\ub77c\ube0c\uc5b4 \ud0a4\ub9b4\ubb38\uc790" },
            { "gwi", "\uadf8\uc704\uce5c\uc5b4" },
            { "%%LUNA1918", "\ub8e8\ub0981918" },
            { "nds", "\uc800\uc9c0 \ub3c5\uc77c\uc5b4" },
            { "LI", "\ub9ac\ud788\ud150\uc288\ud0c0\uc778" },
            { "LK", "\uc2a4\ub9ac\ub791\uce74" },
            { "akk", "\uc544\uce74\ub4dc\uc5b4" },
            { "cop", "\ucf65\ud2b8\uc5b4" },
            { "LR", "\ub77c\uc774\ubca0\ub9ac\uc544" },
            { "LS", "\ub808\uc18c\ud1a0" },
            { "Phlv", "\ubd81 \ud314\ub77c\ube44 \ubb38\uc790" },
            { "LT", "\ub9ac\ud22c\uc544\ub2c8\uc544" },
            { "LU", "\ub8e9\uc148\ubd80\ub974\ud06c" },
            { "LV", "\ub77c\ud2b8\ube44\uc544" },
            { "Kana", "\uac00\ud0c0\uce74\ub098" },
            { "Sora", "\uc18c\ub77c \uc19c\ud3ad \ubb38\uc790" },
            { "LY", "\ub9ac\ube44\uc544" },
            { "lad", "\ub77c\ub514\ub178\uc5b4" },
            { "vun", "\ubd84\uc870\uc5b4" },
            { "%%LAUKIKA", "\ub77c\uc6b0\ud0a4\uce74" },
            { "lah", "\ub77c\ud55c\ub2e4\uc5b4" },
            { "Mahj", "\ub9c8\ud558\uc790\ub2c8 \ubb38\uc790" },
            { "lag", "\ub791\uae30\uc5b4" },
            { "Thaa", "\ud0c0\ub098 \ubb38\uc790" },
            { "MA", "\ubaa8\ub85c\ucf54" },
            { "MC", "\ubaa8\ub098\ucf54" },
            { "MD", "\ubab0\ub3c4\ubc14" },
            { "Nshu", "\ub204\uc288 \ubb38\uc790" },
            { "ME", "\ubaac\ud14c\ub124\uadf8\ub85c" },
            { "MF", "\uc0dd\ub9c8\ub974\ud0f1" },
            { "lam", "\ub78c\ubc14\uc5b4" },
            { "MG", "\ub9c8\ub2e4\uac00\uc2a4\uce74\ub974" },
            { "MH", "\ub9c8\uc15c \uc81c\ub3c4" },
            { "ale", "\uc54c\ub958\ud2b8\uc5b4" },
            { "Thai", "\ud0c0\uc774 \ubb38\uc790" },
            { "type.nu.vaii", "\ubc14\uc774 \uc22b\uc790" },
            { "MK", "\ubd81\ub9c8\ucf00\ub3c4\ub2c8\uc544" },
            { "ML", "\ub9d0\ub9ac" },
            { "MM", "\ubbf8\uc580\ub9c8" },
            { "MN", "\ubabd\uace8" },
            { "new", "\ub124\uc640\ub974\uc5b4" },
            { "MO", "\ub9c8\uce74\uc624(\uc911\uad6d \ud2b9\ubcc4\ud589\uc815\uad6c)" },
            { "MP", "\ubd81\ub9c8\ub9ac\uc544\ub098\uc81c\ub3c4" },
            { "MQ", "\ub9c8\ub974\ud2f0\ub2c8\ud06c" },
            { "MR", "\ubaa8\ub9ac\ud0c0\ub2c8" },
            { "MS", "\ubaac\ud2b8\uc138\ub77c\ud2b8" },
            { "MT", "\ubab0\ud0c0" },
            { "type.m0.ungegn", "\uc720\uc5d4 \uc9c0\uba85\uc804\ubb38\uac00 \uadf8\ub8f9(UNGEGN)" },
            { "MU", "\ubaa8\ub9ac\uc154\uc2a4" },
            { "alt", "\ub0a8\ubd80 \uc54c\ud0c0\uc774\uc5b4" },
            { "MV", "\ubab0\ub514\ube0c" },
            { "MW", "\ub9d0\ub77c\uc704" },
            { "MX", "\uba55\uc2dc\ucf54" },
            { "type.ca.japanese", "\uc77c\ubcf8\ub825" },
            { "MY", "\ub9d0\ub808\uc774\uc2dc\uc544" },
            { "MZ", "\ubaa8\uc7a0\ube44\ud06c" },
            { "Phli", "\uba85\ubb38 \ud314\ub77c\ube44 \ubb38\uc790" },
            { "NA", "\ub098\ubbf8\ube44\uc544" },
            { "202", "\uc0ac\ud558\ub77c \uc0ac\ub9c9 \uc774\ub0a8 \uc544\ud504\ub9ac\uce74" },
            { "type.ca.hebrew", "\ud788\ube0c\ub9ac\ub825" },
            { "type.co.dictionary", "\uc0ac\uc804 \uc815\ub82c\uc21c" },
            { "NC", "\ub274\uce7c\ub808\ub3c4\ub2c8\uc544" },
            { "%%UCRCOR", "\ud1b5\ud569 \uac1c\uc815 \ud45c\uae30\ubc95" },
            { "NE", "\ub2c8\uc81c\ub974" },
            { "NF", "\ub178\ud37d\uc12c" },
            { "NG", "\ub098\uc774\uc9c0\ub9ac\uc544" },
            { "trv", "\ud0c0\ub85c\ucf54\uc5b4" },
            { "Phlp", "\uc194\ud130 \ud314\ub77c\ube44 \ubb38\uc790" },
            { "NI", "\ub2c8\uce74\ub77c\uacfc" },
            { "Hmng", "\ud30c\ud558\uc6b0 \ubabd \ubb38\uc790" },
            { "NL", "\ub124\ub35c\ub780\ub4dc" },
            { "NO", "\ub178\ub974\uc6e8\uc774" },
            { "NP", "\ub124\ud314" },
            { "NR", "\ub098\uc6b0\ub8e8" },
            { "NU", "\ub2c8\uc6b0\uc5d0" },
            { "Phnx", "\ud398\ub2c8\ud0a4\uc544 \ubb38\uc790" },
            { "rof", "\ub86c\ubcf4\uc5b4" },
            { "tsi", "\ud2b8\uc2ec\uc2dc\uc548\uc5b4" },
            { "NZ", "\ub274\uc9c8\ub79c\ub4dc" },
            { "Merc", "\uba54\ub85c\uc5d0 \ud544\uae30\uccb4" },
            { "rom", "\uc9d1\uc2dc\uc5b4" },
            { "Mero", "\uba54\ub85c\uc5d0 \ubb38\uc790" },
            { "crh", "\ud06c\ub9ac\ubbfc \ud130\ud0a4\uc5b4; \ud06c\ub9ac\ubbfc \ud0c0\ud0c0\ub974\uc5b4" },
            { "ang", "\uace0\ub300 \uc601\uc5b4" },
            { "OM", "\uc624\ub9cc" },
            { "anp", "\uc559\uac00\uc5b4" },
            { "crs", "\uc138\uc774\uc178 \ud06c\ub9ac\uc62c \ud504\ub791\uc2a4\uc5b4" },
            { "Xpeo", "\uace0\ub300 \ud398\ub974\uc2dc\uc544 \ubb38\uc790" },
            { "PA", "\ud30c\ub098\ub9c8" },
            { "type.ca.islamic-civil", "\uc774\uc2ac\ub78c \uc0c1\uc6a9\ub825" },
            { "csb", "\uce74\uc288\ube44\uc544\uc5b4" },
            { "PE", "\ud398\ub8e8" },
            { "PF", "\ud504\ub791\uc2a4\ub839 \ud3f4\ub9ac\ub124\uc2dc\uc544" },
            { "PG", "\ud30c\ud478\uc544\ub274\uae30\ub2c8" },
            { "PH", "\ud544\ub9ac\ud540" },
            { "PK", "\ud30c\ud0a4\uc2a4\ud0c4" },
            { "PL", "\ud3f4\ub780\ub4dc" },
            { "ewo", "\uc774\uc6d0\ub3c4\uc5b4" },
            { "PM", "\uc0dd\ud53c\uc5d0\ub974 \ubbf8\ud074\ub871" },
            { "PN", "\ud54f\ucf00\uc5b8 \uc81c\ub3c4" },
            { "PR", "\ud478\uc5d0\ub974\ud1a0\ub9ac\ucf54" },
            { "PS", "\ud314\ub808\uc2a4\ud0c0\uc778 \uc9c0\uad6c" },
            { "Bali", "\ubc1c\ub9ac \ubb38\uc790" },
            { "PT", "\ud3ec\ub974\ud22c\uac08" },
            { "PW", "\ud314\ub77c\uc6b0" },
            { "nia", "\ub2c8\uc544\uc2a4\uc5b4" },
            { "type.nu.greklow", "\uadf8\ub9ac\uc2a4\uc5b4 \uc18c\ubb38\uc790 \uc22b\uc790" },
            { "PY", "\ud30c\ub77c\uacfc\uc774" },
            { "tum", "\ud23c\ubd80\uce74\uc5b4" },
            { "Hebr", "\ud788\ube0c\ub9ac \ubb38\uc790" },
            { "QA", "\uce74\ud0c0\ub974" },
            { "%%SCOTLAND", "\uc2a4\ucf54\ud2c0\ub79c\ub4dc \ud45c\uc900 \uc601\uc5b4" },
            { "niu", "\ub2c8\uc6e8\uc5b8\uc5b4" },
            { "QO", "\uc624\uc138\uc544\ub2c8\uc544 \uc678\uacfd" },
            { "lez", "\ub808\uc988\uae30\uc548\uc5b4" },
            { "tvl", "\ud22c\ubc1c\ub8e8\uc5b4" },
            { "Tavt", "\ud0dc\uad6d \ubca0\ud2b8\ub0a8 \ubb38\uc790" },
            { "001", "\uc138\uacc4" },
            { "002", "\uc544\ud504\ub9ac\uce74" },
            { "003", "\ubd81\uc544\uba54\ub9ac\uce74" },
            { "RE", "\ub808\uc704\ub2c8\uc639" },
            { "005", "\ub0a8\uc544\uba54\ub9ac\uce74" },
            { "lfn", "\ub9c1\uad6c\uc544 \ud504\ub791\uce74 \ub178\ubc14" },
            { "jbo", "\ub85c\ubc18\uc5b4" },
            { "pnt", "\ud3f0\ud2f1\uc5b4" },
            { "Rjng", "\ub808\uc7a5 \ubb38\uc790" },
            { "009", "\uc624\uc138\uc544\ub2c8\uc544" },
            { "RO", "\ub8e8\ub9c8\ub2c8\uc544" },
            { "RS", "\uc138\ub974\ube44\uc544" },
            { "Mroo", "\ubbc0\ub85c \ubb38\uc790" },
            { "RU", "\ub7ec\uc2dc\uc544" },
            { "RW", "\ub974\uc644\ub2e4" },
            { "Mani", "\ub9c8\ub2c8\uad50 \ubb38\uc790" },
            { "Ugar", "\uc6b0\uac00\ub9ac\ud2b8 \ubb38\uc790" },
            { "Khar", "\uce74\ub85c\uc288\ud2f0 \ubb38\uc790" },
            { "SA", "\uc0ac\uc6b0\ub514\uc544\ub77c\ube44\uc544" },
            { "pon", "\ud3fc\ud398\uc774\uc5b4" },
            { "Mand", "\ub9cc\ub2e4\uc774\uc544 \ubb38\uc790" },
            { "SB", "\uc194\ub85c\ubaac \uc81c\ub3c4" },
            { "twq", "\ud0c0\uc0ac\uc640\ud06c\uc5b4" },
            { "011", "\uc11c\ubd80 \uc544\ud504\ub9ac\uce74" },
            { "SC", "\uc138\uc774\uc178" },
            { "SD", "\uc218\ub2e8" },
            { "013", "\uc911\uc559 \uc544\uba54\ub9ac\uce74" },
            { "SE", "\uc2a4\uc6e8\ub374" },
            { "014", "\ub3d9\ubd80 \uc544\ud504\ub9ac\uce74" },
            { "arc", "\uc544\ub78c\uc5b4" },
            { "Loma", "\ub85c\ub9c8 \ubb38\uc790" },
            { "015", "\ubd81\ubd80 \uc544\ud504\ub9ac\uce74" },
            { "SG", "\uc2f1\uac00\ud3ec\ub974" },
            { "SH", "\uc138\uc778\ud2b8\ud5ec\ub808\ub098" },
            { "type.lb.strict", "\uc904\ubc14\uafc8 - \uc881\uac8c" },
            { "017", "\uc911\ubd80 \uc544\ud504\ub9ac\uce74" },
            { "SI", "\uc2ac\ub85c\ubca0\ub2c8\uc544" },
            { "018", "\ub0a8\ubd80 \uc544\ud504\ub9ac\uce74" },
            { "SJ", "\uc2a4\ubc1c\ubc14\ub974\uc81c\ub3c4-\uc580\ub9c8\uc6ec\uc12c" },
            { "019", "\uc544\uba54\ub9ac\uce74 \ub300\ub959" },
            { "SK", "\uc2ac\ub85c\ubc14\ud0a4\uc544" },
            { "Bamu", "\ubc14\ubb44 \ubb38\uc790" },
            { "Wole", "\uc6b8\ub808\uc544\uc774" },
            { "SL", "\uc2dc\uc5d0\ub77c\ub9ac\uc628" },
            { "SM", "\uc0b0\ub9c8\ub9ac\ub178" },
            { "SN", "\uc138\ub124\uac08" },
            { "SO", "\uc18c\ub9d0\ub9ac\uc544" },
            { "arn", "\ub9c8\ud478\ub465\uad70\uc5b4" },
            { "arp", "\uc544\ub77c\ud30c\ud638\uc5b4" },
            { "type.nu.taml", "\uace0\ub300 \ud0c0\ubc00 \uc22b\uc790" },
            { "SR", "\uc218\ub9ac\ub0a8" },
            { "SS", "\ub0a8\uc218\ub2e8" },
            { "ST", "\uc0c1\ud22c\uba54 \ud504\ub9b0\uc2dc\ud398" },
            { "arq", "\uc54c\uc81c\ub9ac \uc544\ub78d\uc5b4" },
            { "SV", "\uc5d8\uc0b4\ubc14\ub3c4\ub974" },
            { "ars", "\uc544\ub78d\uc5b4(\ub098\uc988\ub514)" },
            { "SX", "\uc2e0\ud2b8\ub9c8\ub974\ud134" },
            { "SY", "\uc2dc\ub9ac\uc544" },
            { "yao", "\uc57c\uc624\uc871\uc5b4" },
            { "SZ", "\uc5d0\uc2a4\uc640\ud2f0\ub2c8" },
            { "arw", "\uc544\ub77c\uc640\ud06c\uc5b4" },
            { "arz", "\uc774\uc9d1\ud2b8 \uc544\ub78d\uc5b4" },
            { "ary", "\ubaa8\ub85c\ucf54 \uc544\ub78d\uc5b4" },
            { "yap", "\uc58d\ud398\uc138\uc5b4" },
            { "TA", "\ud2b8\ub9ac\uc2a4\ud0c4\ub2e4\ucfe0\ub098" },
            { "asa", "\uc544\uc218\uc5b4" },
            { "type.ms.ussystem", "\ubbf8\uad6d \uacc4\ub7c9\ubc95" },
            { "021", "\ubd81\ubd80 \uc544\uba54\ub9ac\uce74" },
            { "TC", "\ud130\ud06c\uc2a4 \ucf00\uc774\ucee4\uc2a4 \uc81c\ub3c4" },
            { "yav", "\uc591\ubcf8\uc5b4" },
            { "TD", "\ucc28\ub4dc" },
            { "Qaag", "\uc800\uc9c0 \ubb38\uc790" },
            { "TF", "\ud504\ub791\uc2a4 \ub0a8\ubd80 \uc9c0\ubc29" },
            { "TG", "\ud1a0\uace0" },
            { "TH", "\ud0dc\uad6d" },
            { "TJ", "\ud0c0\uc9c0\ud0a4\uc2a4\ud0c4" },
            { "029", "\uce74\ub9ac\ube0c \uc81c\ub3c4" },
            { "TK", "\ud1a0\ucf08\ub77c\uc6b0" },
            { "TL", "\ub3d9\ud2f0\ubaa8\ub974" },
            { "ybb", "\uc618\ubc14\uc5b4" },
            { "type.co.searchjl", "\ud55c\uae00 \uc790\uc74c\uc73c\ub85c \uac80\uc0c9" },
            { "TM", "\ud22c\ub974\ud06c\uba54\ub2c8\uc2a4\ud0c4" },
            { "TN", "\ud280\ub2c8\uc9c0" },
            { "TO", "\ud1b5\uac00" },
            { "TR", "\ud130\ud0a4" },
            { "TT", "\ud2b8\ub9ac\ub2c8\ub2e4\ub4dc \ud1a0\ubc14\uace0" },
            { "TV", "\ud22c\ubc1c\ub8e8" },
            { "TW", "\ub300\ub9cc" },
            { "ast", "\uc544\uc2a4\ud22c\ub9ac\uc544\uc5b4" },
            { "rue", "\ub8e8\uc2e0\uc5b4" },
            { "Orkh", "\uc624\ub974\ud63c\uc5b4" },
            { "TZ", "\ud0c4\uc790\ub2c8\uc544" },
            { "nmg", "\ud06c\uc640\uc2dc\uc624\uc5b4" },
            { "Zzzz", "\uc54c \uc218 \uc5c6\ub294 \ubb38\uc790" },
            { "Sind", "\ucfe0\ub2e4\uc640\ub514 \ubb38\uc790" },
            { "UA", "\uc6b0\ud06c\ub77c\uc774\ub098" },
            { "rup", "\uc544\ub85c\ub9c8\ub2c8\uc544\uc5b4" },
            { "030", "\ub3d9\uc544\uc2dc\uc544" },
            { "tyv", "\ud22c\ube44\ub2c8\uc548\uc5b4" },
            { "sw_CD", "\ucf69\uace0 \uc2a4\uc640\ud790\ub9ac\uc5b4" },
            { "034", "\ub0a8\uc544\uc2dc\uc544" },
            { "hai", "\ud558\uc774\ub2e4\uc5b4" },
            { "035", "\ub3d9\ub0a8\uc544\uc2dc\uc544" },
            { "UG", "\uc6b0\uac04\ub2e4" },
            { "hak", "\ud558\uce74\uc5b4" },
            { "type.co.pinyin", "\ubcd1\uc74c\uc21c" },
            { "039", "\ub0a8\uc720\ub7fd" },
            { "Sinh", "\uc2e0\ud560\ub77c \ubb38\uc790" },
            { "UM", "\ubbf8\uad6d\ub839 \ud574\uc678 \uc81c\ub3c4" },
            { "UN", "\uad6d\uc81c\uc5f0\ud569" },
            { "US", "\ubbf8\uad6d" },
            { "haw", "\ud558\uc640\uc774\uc5b4" },
            { "type.co.gb2312han", "\uc911\uad6d\uc5b4 \uac04\uccb4 \uc815\ub82c \uc21c\uc11c (GB2312)" },
            { "UY", "\uc6b0\ub8e8\uacfc\uc774" },
            { "prg", "\ud504\ub7ec\uc2dc\uc544\uc5b4" },
            { "UZ", "\uc6b0\uc988\ubca0\ud0a4\uc2a4\ud0c4" },
            { "tzm", "\uc911\uc559 \ubaa8\ub85c\ucf54 \ud0c0\ub9c8\uc9c0\ud2b8\uc5b4" },
            { "type.co.stroke", "\uc790\ud68d\uc21c" },
            { "nnh", "\ub290\uae30\uc5e0\ubcf8\uc5b4" },
            { "VA", "\ubc14\ud2f0\uce78 \uc2dc\uad6d" },
            { "pro", "\uace0\ub300 \ud504\ub85c\ubc29\uc2a4\uc5b4" },
            { "VC", "\uc138\uc778\ud2b8\ube48\uc13c\ud2b8\uadf8\ub808\ub098\ub518" },
            { "VE", "\ubca0\ub124\uc218\uc5d8\ub77c" },
            { "VG", "\uc601\uad6d\ub839 \ubc84\uc9c4\uc544\uc77c\ub79c\ub4dc" },
            { "VI", "\ubbf8\uad6d\ub839 \ubc84\uc9c4\uc544\uc77c\ub79c\ub4dc" },
            { "VN", "\ubca0\ud2b8\ub0a8" },
            { "VU", "\ubc14\ub204\uc544\ud22c" },
            { "nog", "\ub178\uac00\uc774\uc5b4" },
            { "rwk", "\ub974\uc640\uc5b4" },
            { "non", "\uace0\ub300 \ub178\ub974\uc6e8\uc774\uc5b4" },
            { "053", "\uc624\uc2a4\ud2b8\ub784\ub77c\uc2dc\uc544" },
            { "054", "\uba5c\ub77c\ub124\uc2dc\uc544" },
            { "WF", "\uc648\ub9ac\uc2a4-\ud478\ud22c\ub098 \uc81c\ub3c4" },
            { "type.co.traditional", "\uc804\ud1b5 \uc5ed\ubc95" },
            { "057", "\ubbf8\ud06c\ub85c\ub124\uc2dc\uc544 \uc9c0\uc5ed" },
            { "jgo", "\uc751\uacf0\ubc14\uc5b4" },
            { "lkt", "\ub77c\ucf54\ud0c0\uc5b4" },
            { "type.nu.finance", "\uc7ac\ubb34 \uc22b\uc790" },
            { "%%HEPBURN", "\ud5f5\ubc88\uc2dd \ub85c\ub9c8\uc790 \ud45c\uae30\ubc95" },
            { "type.co.compat", "\ud638\ud658\uc131\uc744 \uc704\ud574 \uc774\uc804 \uc815\ub82c \uc21c\uc11c" },
            { "wae", "\uc6d4\uc800\uc5b4" },
            { "WS", "\uc0ac\ubaa8\uc544" },
            { "Bass", "\ubc14\uc0ac\ubc14\ud750 \ubb38\uc790" },
            { "type.nu.mtei", "\uba54\uc774\ud14c\uc774 \ub9c8\uc609 \uc22b\uc790" },
            { "wal", "\uc6d4\ub77c\uc774\ud0c0\uc5b4" },
            { "was", "\uc640\uc1fc\uc5b4" },
            { "XA", "\uc720\uc0ac \uc5b5\uc591" },
            { "war", "\uc640\ub77c\uc774\uc5b4" },
            { "XB", "\uc720\uc0ac \uc591\ubc29\ud5a5" },
            { "awa", "\uc544\uc640\ud788\uc5b4" },
            { "061", "\ud3f4\ub9ac\ub124\uc2dc\uc544" },
            { "XK", "\ucf54\uc18c\ubcf4" },
            { "type.nu.brah", "\ube0c\ub77c\ubbf8 \uc22b\uc790" },
            { "Gujr", "\uad6c\uc790\ub77c\ud2b8 \ubb38\uc790" },
            { "Zxxx", "\uad6c\uc804" },
            { "Olck", "\uc62c \uce58\ud0a4 \ubb38\uc790" },
            { "wbp", "\uc648\ud53c\ub9ac\uc5b4" },
            { "Batk", "\ubc14\ud0c0\ud06c \ubb38\uc790" },
            { "Blis", "\ube14\ub9ac\uc2a4\uae30\ud638 \ubb38\uc790" },
            { "YE", "\uc608\uba58" },
            { "nqo", "\uc751\ucf54\uc5b4" },
            { "type.co.standard", "\ud45c\uc900 \uc815\ub82c \uc21c\uc11c" },
            { "fan", "\ud321\uadf8\uc5b4" },
            { "fat", "\ud310\ud2f0\uc5b4" },
            { "Sgnw", "\uc218\ud654 \ubb38\uc790" },
            { "YT", "\ub9c8\uc694\ud2b8" },
            { "type.nu.cham", "\ucc38 \uc22b\uc790" },
            { "ZA", "\ub0a8\uc544\ud504\ub9ac\uce74" },
            { "type.nu.sund", "\uc21c\ub2e4 \uc22b\uc790" },
            { "type.lb.loose", "\uc904\ubc14\uafc8 - \ub113\uac8c" },
            { "Deva", "\ub370\ubc14\ub098\uac00\ub9ac \ubb38\uc790" },
            { "type.nu.geor", "\uc870\uc9c0\uc544 \uc22b\uc790" },
            { "type.co.zhuyin", "\uc8fc\uc74c\uc21c" },
            { "Hira", "\ud788\ub77c\uac00\ub098" },
            { "ZM", "\uc7a0\ube44\uc544" },
            { "ZW", "\uc9d0\ubc14\ube0c\uc6e8" },
            { "ZZ", "\uc54c\ub824\uc9c0\uc9c0 \uc54a\uc740 \uc9c0\uc5ed" },
            { "Runr", "\ub8ec \ubb38\uc790" },
            { "type.ms.metric", "\ubbf8\ud130\ubc95" },
            { "type.ca.iso8601", "ISO-8601 \ub2ec\ub825" },
            { "lol", "\ubabd\uace0\uc5b4" },
            { "nso", "\ubd81\ubd80 \uc18c\ud1a0\uc5b4" },
            { "type.nu.telu", "\ud154\ub8e8\uad6c \uc22b\uc790" },
            { "lou", "\ub8e8\uc774\uc9c0\uc560\ub098 \ud06c\ub9ac\uc62c\uc5b4" },
            { "loz", "\ub85c\uc9c0\uc5b4" },
            { "Nkgb", "\ub098\uc2dc \uac8c\ubc14 \ubb38\uc790" },
            { "jmc", "\ub9c8\ucc28\uba54\uc5b4" },
            { "hif", "\ud53c\uc9c0 \ud78c\ub514\uc5b4" },
            { "type.nu.hansfin", "\uc911\uad6d\uc5b4 \uac04\uccb4 \uc7ac\ubb34 \uc22b\uc790" },
            { "hil", "\ud5e4\ub9ac\uac00\ub1ec\uc5b4" },
            { "type.nu.arabext", "\ud655\uc7a5\ud615 \uc544\ub77c\ube44\uc544-\uc778\ub3c4\uc2dd \uc22b\uc790" },
            { "nus", "\ub204\uc5d0\ub974\uc5b4" },
            { "dak", "\ub2e4\ucf54\ud0c0\uc5b4" },
            { "type.nu.fullwide", "\uc804\uc790 \uc22b\uc790" },
            { "hit", "\ud558\ud0c0\uc774\ud2b8\uc5b4" },
            { "dar", "\ub2e4\ub974\uadf8\uc640\uc5b4" },
            { "dav", "\ud0c0\uc774\ud0c0\uc5b4" },
            { "Maya", "\ub9c8\uc57c \uc0c1\ud615 \ubb38\uc790" },
            { "lrc", "\ubd81\ubd80 \ub8e8\ub9ac\uc5b4" },
            { "Copt", "\ucf65\ud2b8 \ubb38\uc790" },
            { "nwc", "\uace0\uc804 \ub124\uc640\ub974\uc5b4" },
            { "udm", "\uc6b0\ub4dc\ub9d0\ud2b8\uc5b4" },
            { "Khmr", "\ud06c\uba54\ub974 \ubb38\uc790" },
            { "Limb", "\ub9bc\ubd80 \ubb38\uc790" },
            { "sad", "\uc0b0\ub2e4\uc6e8\uc5b4" },
            { "type.nu.roman", "\ub85c\ub9c8 \uc22b\uc790" },
            { "sah", "\uc57c\ucfe0\ud2b8\uc5b4" },
            { "type.nu.shrd", "\uc0e4\ub77c\ub2e4 \uc22b\uc790" },
            { "sam", "\uc0ac\ub9c8\ub9ac\uc544 \uc544\ub78d\uc5b4" },
            { "Aghb", "\ucf54\uce74\uc2dc\uc548 \uc54c\ubc14\ub2c8\uc544 \ubb38\uc790" },
            { "saq", "\uc0bc\ubd80\ub8e8\uc5b4" },
            { "sas", "\uc0ac\uc0ac\ud06c\uc5b4" },
            { "sat", "\uc0b0\ud0c8\ub9ac\uc5b4" },
            { "Tfng", "\ud2f0\ud53c\ub098\uadf8 \ubb38\uc790" },
            { "type.d0.npinyin", metaValue_key_nu },
            { "jpr", "\uc720\ub300-\ud398\ub974\uc2dc\uc544\uc5b4" },
            { "type.nu.native", "\uae30\ubcf8 \uc22b\uc790" },
            { "sba", "\ub290\uac10\ubc14\uc774\uc5b4" },
            { "Guru", "\uad6c\ub974\ubb34\ud0a4 \ubb38\uc790" },
            { "%%ALUKU", "\uc54c\ub8e8\uafb8 \ubc29\uc5b8" },
            { "lua", "\ub8e8\ubc14-\ub8f0\ub8e8\uc544\uc5b4" },
            { "%%BISCAYAN", "\ube44\uc2a4\uce74\uc580" },
            { "type.d0.fwidth", "\uc804\uac01" },
            { "sbp", "\uc0c1\uad6c\uc5b4" },
            { "lui", "\ub8e8\uc774\uc138\ub178\uc5b4" },
            { "nyn", "\ub2c8\uc548\ucf5c\uc5b4" },
            { "nym", "\ub2c8\uc554\uc6e8\uc9c0\uc5b4" },
            { "lun", "\ub8ec\ub2e4\uc5b4" },
            { "nyo", "\ub274\ub85c\uc5b4" },
            { "luo", "\ub8e8\uc624\uc5b4" },
            { "fil", "\ud544\ub9ac\ud540\uc5b4" },
            { "hmn", "\ud788\ubab8\uc5b4" },
            { "del", "\ub378\ub77c\uc6e8\uc5b4\uc5b4" },
            { "lus", "\ub8e8\uc0e4\uc774\uc5b4" },
            { "bal", "\ubc1c\ub8e8\uce58\uc5b4" },
            { "den", "\uc2ac\ub77c\ube0c\uc5b4" },
            { "ban", "\ubc1c\ub9ac\uc5b4" },
            { "uga", "\uc720\uac00\ub9ac\ud2f1\uc5b4" },
            { "luy", "\ub8e8\uc57c\uc5b4" },
            { "bas", "\ubc14\uc0ac\uc5b4" },
            { "bax", "\ubc14\ubb38\uc5b4" },
            { "jrb", "\uc720\ub300-\uc544\ub77c\ube44\uc544\uc5b4" },
            { "es_ES", "\uc2a4\ud398\uc778\uc5b4(\uc720\ub7fd)" },
            { "nzi", "\ub290\uc9c0\ub9c8\uc5b4" },
            { "sco", "\uc2a4\ucf54\ud2c0\ub79c\ub4dc\uc5b4" },
            { "scn", "\uc2dc\uce60\ub9ac\uc544\uc5b4" },
            { "aa", "\uc544\ud30c\ub974\uc5b4" },
            { "ab", "\uc555\uce74\uc988\uc5b4" },
            { "Aran", "\ub098\uc2a4\ud0c8\ub9ac\ud06c\uccb4" },
            { "ae", "\uc544\ubca0\uc2a4\ud0c0\uc5b4" },
            { "af", "\uc544\ud504\ub9ac\uce78\uc2a4\uc5b4" },
            { "ak", "\uc544\uce78\uc5b4" },
            { "type.nu.cakm", "\ucc60\ud06c\ub9c8 \uc22b\uc790" },
            { "bbj", "\uace0\ub9d0\ub77c\uc5b4" },
            { "am", "\uc554\ud558\ub77c\uc5b4" },
            { "an", "\uc544\ub77c\uace4\uc5b4" },
            { "Arab", "\uc544\ub78d \ubb38\uc790" },
            { "Jpan", "\uc77c\ubcf8 \ubb38\uc790" },
            { "Hrkt", metaValue_GH },
            { "ar", "\uc544\ub78d\uc5b4" },
            { "as", "\uc544\uc0bc\uc5b4" },
            { "Lina", "\uc120\ud615 \ubb38\uc790(A)" },
            { "av", "\uc544\ubc14\ub9ad\uc5b4" },
            { "Linb", "\uc120\ud615 \ubb38\uc790(B)" },
            { "sdh", "\ub0a8\ubd80 \ucfe0\ub974\ub4dc\uc5b4" },
            { "ay", "\uc544\uc774\ub9c8\ub77c\uc5b4" },
            { "az", "\uc544\uc81c\ub974\ubc14\uc774\uc794\uc5b4" },
            { "Khoj", "\ucf54\uc988\ud0a4 \ubb38\uc790" },
            { "ba", "\ubc14\uc288\ud0a4\ub974\uc5b4" },
            { "type.co.unihan", "\ubd80\uc218\uc21c" },
            { "be", "\ubca8\ub77c\ub8e8\uc2a4\uc5b4" },
            { "bg", "\ubd88\uac00\ub9ac\uc544\uc5b4" },
            { "bi", "\ube44\uc2ac\ub77c\ub9c8\uc5b4" },
            { "type.nu.java", "\uc790\ubc14 \uc22b\uc790" },
            { "bm", "\ubc24\ubc14\ub77c\uc5b4" },
            { "bn", "\ubcb5\uace8\uc5b4" },
            { "bo", "\ud2f0\ubca0\ud2b8\uc5b4" },
            { "dgr", "\ub3c4\uadf8\ub9ac\ube0c\uc5b4" },
            { "br", "\ube0c\ub974\ud0c0\ub274\uc5b4" },
            { "bs", "\ubcf4\uc2a4\ub2c8\uc544\uc5b4" },
            { "see", "\uc138\ub124\uce74\uc5b4" },
            { "Mymr", "\ubbf8\uc580\ub9c8 \ubb38\uc790" },
            { "type.nu.laoo", "\ub77c\uc624 \uc22b\uc790" },
            { "seh", "\uc138\ub098\uc5b4" },
            { "Nkoo", "\uc751\ucf54 \ubb38\uc790" },
            { "sel", "\uc140\ucfe0\ud504\uc5b4" },
            { "ca", "\uce74\ud0c8\ub85c\ub2c8\uc544\uc5b4" },
            { "ses", "\ucf54\uc774\uc57c\ubcf4\ub85c \uc138\ub2c8\uc5b4" },
            { "ce", "\uccb4\uccb8\uc5b4" },
            { "ch", "\ucc28\ubaa8\ub85c\uc5b4" },
            { "%%REVISED", "\uac1c\uc815" },
            { "co", "\ucf54\ub974\uc2dc\uce74\uc5b4" },
            { "Orya", "\uc624\ub9ac\uc57c \ubb38\uc790" },
            { "cr", "\ud06c\ub9ac\uc5b4" },
            { "cs", "\uccb4\ucf54\uc5b4" },
            { "cu", "\uad50\ud68c \uc2ac\ub77c\ube0c\uc5b4" },
            { "cv", "\ucd94\ubc14\uc2dc\uc5b4" },
            { "cy", "\uc6e8\uc77c\uc2a4\uc5b4" },
            { "type.nu.ethi", "\uc5d0\ud2f0\uc624\ud53c\uc544 \uc22b\uc790" },
            { "Yiii", "\uc774 \ubb38\uc790" },
            { "da", "\ub374\ub9c8\ud06c\uc5b4" },
            { "pt_PT", "\ud3ec\ub974\ud22c\uac08\uc5b4(\uc720\ub7fd)" },
            { "de", "\ub3c5\uc77c\uc5b4" },
            { "type.cf.standard", "\ud45c\uc900 \ud1b5\ud654 \ud615\uc2dd" },
            { "bej", "\ubca0\uc790\uc5b4" },
            { "din", "\ub529\uce74\uc5b4" },
            { "Bugi", "\ubd80\uae30 \ubb38\uc790" },
            { "bem", "\ubcb0\ubc14\uc5b4" },
            { "sga", "\uace0\ub300 \uc544\uc77c\ub79c\ub4dc\uc5b4" },
            { "type.nu.mong", "\ubabd\uace8 \uc22b\uc790" },
            { "dv", "\ub514\ubca0\ud788\uc5b4" },
            { "dz", "\uc885\uce74\uc5b4" },
            { "bez", "\ubca0\ub098\uc5b4" },
            { "type.ca.chinese", "\uc74c\ub825" },
            { "Lisu", "\ud504\ub808\uc774\uc800 \ubb38\uc790" },
            { "dje", "\uc790\ub974\ub9c8\uc5b4" },
            { "type.nu.grek", "\uadf8\ub9ac\uc2a4 \uc22b\uc790" },
            { "ee", "\uc5d0\uc6e8\uc5b4" },
            { "bfd", "\ubc14\ud478\ud2b8\uc5b4" },
            { "type.lb.normal", "\uc904\ubc14\uafc8 - \ubcf4\ud1b5" },
            { "ro_MD", "\ubab0\ub3c4\ubc14\uc5b4" },
            { "el", "\uadf8\ub9ac\uc2a4\uc5b4" },
            { "en", "\uc601\uc5b4" },
            { "eo", "\uc5d0\uc2a4\ud398\ub780\ud1a0\uc5b4" },
            { "type.co.big5han", "\uc911\uad6d\uc5b4 \ubc88\uccb4 \uc815\ub82c \uc21c\uc11c (Big5)" },
            { "es", "\uc2a4\ud398\uc778\uc5b4" },
            { "et", "\uc5d0\uc2a4\ud1a0\ub2c8\uc544\uc5b4" },
            { "Hanb", "\uc8fc\uc74c \uc790\ubaa8" },
            { "eu", "\ubc14\uc2a4\ud06c\uc5b4" },
            { "Buhd", "\ubd80\ud788\ub4dc \ubb38\uc790" },
            { "Hang", "\ud55c\uae00" },
            { "Samr", "\uc0ac\ub9c8\ub9ac\uc544 \ubb38\uc790" },
            { "shi", "\ud0c0\uc178\ud788\ud2b8\uc5b4" },
            { "hsb", "\uace0\uc9c0 \uc18c\ub974\ube44\uc544\uc5b4" },
            { "Hani", "\ud55c\uc790" },
            { "%%ULSTER", "\uc5bc\uc2a4\ud130" },
            { "shn", "\uc0e8\uc5b4" },
            { "Hano", "\ud558\ub204\ub204 \ubb38\uc790" },
            { "fa", "\ud398\ub974\uc2dc\uc544\uc5b4" },
            { "Hans", "\uac04\uccb4" },
            { "type.nu.latn", "\uc11c\uc591 \uc22b\uc790" },
            { "Hant", "\ubc88\uccb4" },
            { "ff", "\ud480\ub77c\uc5b4" },
            { "shu", "\ucc28\ub514\uc5b8 \uc544\ub77c\ube44\uc544\uc5b4" },
            { "hsn", "\uc0f9\uc5b4" },
            { "fi", "\ud540\ub780\ub4dc\uc5b4" },
            { "fj", "\ud53c\uc9c0\uc5b4" },
            { "fon", "\ud3f0\uc5b4" },
            { "bgn", "\uc11c\ubd80 \ubc1c\ub85c\uce58\uc5b4" },
            { "yue", "\uad11\ub465\uc5b4" },
            { "fo", "\ud398\ub85c\uc5b4" },
            { "type.m0.bgn", "\ubbf8\uad6d \uc9c0\uba85\uc704\uc6d0\ud68c(BGN)" },
            { "umb", "\uc6c0\ubd84\ub450\uc5b4" },
            { "fr", "\ud504\ub791\uc2a4\uc5b4" },
            { "sid", "\uc2dc\ub2e4\ubaa8\uc5b4" },
            { "fy", "\uc11c\ubd80 \ud504\ub9ac\uc9c0\uc544\uc5b4" },
            { "ga", "\uc544\uc77c\ub79c\ub4dc\uc5b4" },
            { "gd", "\uc2a4\ucf54\ud2c0\ub79c\ub4dc \uac8c\uc77c\uc5b4" },
            { "gl", "\uac08\ub9ac\uc2dc\uc544\uc5b4" },
            { "gn", "\uacfc\ub77c\ub2c8\uc5b4" },
            { "bho", "\ud638\uc988\ud478\ub9ac\uc5b4" },
            { "und", "\uc54c \uc218 \uc5c6\ub294 \uc5b8\uc5b4" },
            { "type.ca.ethiopic-amete-alem", "\uc5d0\ud2f0\uc624\ud53c\uc544 \uc544\uba54\ud14c \uc54c\ub818\ub825" },
            { "gu", "\uad6c\uc790\ub77c\ud2b8\uc5b4" },
            { "gv", "\ub9f9\ud06c\uc2a4\uc5b4" },
            { "type.nu.osma", "\uc624\uc2a4\ub9c8\ub0d0 \uc22b\uc790" },
            { "ha", "\ud558\uc6b0\uc0ac\uc5b4" },
            { "he", "\ud788\ube0c\ub9ac\uc5b4" },
            { "hi", "\ud78c\ub514\uc5b4" },
            { "hup", "\ud6c4\ud30c\uc5b4" },
            { "bik", "\ube44\ucf5c\uc5b4" },
            { "bin", "\ube44\ub2c8\uc5b4" },
            { "ho", "\ud788\ub9ac \ubaa8\ud22c\uc5b4" },
            { "hr", "\ud06c\ub85c\uc544\ud2f0\uc544\uc5b4" },
            { "ht", "\uc544\uc774\ud2f0\uc5b4" },
            { "hu", "\ud5dd\uac00\ub9ac\uc5b4" },
            { "hy", "\uc544\ub974\uba54\ub2c8\uc544\uc5b4" },
            { "hz", "\ud5e4\ub808\ub85c\uc5b4" },
            { "frc", "\ucf00\uc774\uc900 \ud504\ub791\uc2a4\uc5b4" },
            { "ia", "\uc778\ud130\ub9c1\uad6c\uc544" },
            { "Jamo", "\uc790\ubaa8" },
            { "id", "\uc778\ub3c4\ub124\uc2dc\uc544\uc5b4" },
            { "type.nu.tibt", "\ud2f0\ubcb3 \uc22b\uc790" },
            { "ie", "\uc778\ud14c\ub974\ub9c1\uad6c\uc5d0" },
            { "ig", "\uc774\uadf8\ubcf4\uc5b4" },
            { "ii", "\uc4f0\ucd28 \uc774\uc5b4" },
            { "frm", "\uc911\uc138 \ud504\ub791\uc2a4\uc5b4" },
            { "ik", "\uc774\ub204\ud53c\uc544\ud06c\uc5b4" },
            { "fro", "\uace0\ub300 \ud504\ub791\uc2a4\uc5b4" },
            { "io", "\uc774\ub3c4\uc5b4" },
            { "frs", "\ub3d9\ubd80 \ud504\ub9ac\uc2ac\ub780\ub4dc\uc5b4" },
            { "frr", "\ubd81\ubd80 \ud504\ub9ac\uc9c0\uc544\uc5b4" },
            { "is", "\uc544\uc774\uc2ac\ub780\ub4dc\uc5b4" },
            { "it", "\uc774\ud0c8\ub9ac\uc544\uc5b4" },
            { "iu", "\uc774\ub205\ud2f0\ud22c\ud2b8\uc5b4" },
            { "%%HOGNORSK", "\ud638\uadf8\ub178\ub974\uc2a4\ud06c" },
            { "ja", "\uc77c\ubcf8\uc5b4" },
            { "Mlym", "\ub9d0\ub77c\uc584\ub78c \ubb38\uc790" },
            { "Sarb", "\uc61b \ub0a8\ubd80 \uc544\ub77c\ube44\uc544 \ubb38\uc790" },
            { "Sara", "\uc0ac\ub77c\ud2f0" },
            { "doi", "\ub3c4\uadf8\ub9ac\uc5b4" },
            { "type.nu.lepc", "\ub819\ucc28 \uc22b\uc790" },
            { "bkm", "\ucf64\uc5b4" },
            { "sma", "\ub0a8\ubd80 \uc0ac\ubbf8\uc5b4" },
            { "jv", "\uc790\ubc14\uc5b4" },
            { "Shaw", "\uc0e4\ube44\uc548 \ubb38\uc790" },
            { "%%BAUDDHA", "\ubc14\uc6b0\ub2e4" },
            { "mad", "\ub9c8\ub450\ub77c\uc5b4" },
            { "smj", "\ub8f0\ub808 \uc0ac\ubbf8\uc5b4" },
            { "mag", "\ub9c8\uac00\ud788\uc5b4" },
            { "maf", "\ub9c8\ud30c\uc5b4" },
            { "mai", "\ub9c8\uc774\ud2f8\ub9ac\uc5b4" },
            { "smn", "\uc774\ub098\ub9ac \uc0ac\ubbf8\uc5b4" },
            { "ka", "\uc870\uc9c0\uc544\uc5b4" },
            { "bla", "\uc2dd\uc2dc\uce74\uc5b4" },
            { "mak", "\ub9c8\uce74\uc0ac\uc5b4" },
            { "wuu", "\uc6b0\uc5b4" },
            { "sms", "\uc2a4\ucf5c\ud2b8 \uc0ac\ubbf8\uc5b4" },
            { "man", "\ub9cc\ub529\uace0\uc5b4" },
            { "kg", "\ucf69\uace0\uc5b4" },
            { "Goth", "\uace0\ud2b8 \ubb38\uc790" },
            { "ki", "\ud0a4\ucfe0\uc720\uc5b4" },
            { "mas", "\ub9c8\uc0ac\uc774\uc5b4" },
            { "kj", "\ucfe0\uc548\uc57c\ub9c8\uc5b4" },
            { "kk", "\uce74\uc790\ud750\uc5b4" },
            { "kl", "\uadf8\ub9b0\ub780\ub4dc\uc5b4" },
            { "km", "\ud06c\uba54\ub974\uc5b4" },
            { "kn", "\uce78\ub098\ub2e4\uc5b4" },
            { "ko", "\ud55c\uad6d\uc5b4" },
            { "kr", "\uce78\ub204\ub9ac\uc5b4" },
            { "ks", "\uce74\uc288\ubbf8\ub974\uc5b4" },
            { "Cirt", "\ud0a4\ub974\uc4f0" },
            { "Lepc", "\ub819\ucc28 \ubb38\uc790" },
            { "Avst", "\uc544\ubca0\uc2a4\ud0c0 \ubb38\uc790" },
            { "ku", "\ucfe0\ub974\ub4dc\uc5b4" },
            { "kv", "\ucf54\ubbf8\uc5b4" },
            { "kw", "\ucf58\uc6d4\uc5b4" },
            { "ky", "\ud0a4\ub974\uae30\uc2a4\uc5b4" },
            { "snk", "\uc18c\ub2cc\ucf00\uc5b4" },
            { "la", "\ub77c\ud2f4\uc5b4" },
            { "lb", "\ub8e9\uc148\ubd80\ub974\ud06c\uc5b4" },
            { "type.nu.mlym", "\ub9d0\ub77c\uc584\ub78c \uc22b\uc790" },
            { "lg", "\uac04\ub2e4\uc5b4" },
            { "Roro", "\ub871\uace0\ub871\uace0" },
            { "li", "\ub9bc\ubc84\uac70\uc5b4" },
            { "Tibt", "\ud2f0\ubca0\ud2b8 \ubb38\uc790" },
            { "ln", "\ub9c1\uac08\ub77c\uc5b4" },
            { "fur", "\ud504\ub9ac\uc6b8\ub9ac\uc5b4" },
            { "lo", "\ub77c\uc624\uc5b4" },
            { "type.ms.uksystem", "\uc57c\ub4dc\ud30c\uc6b4\ub4dc\ubc95" },
            { "type.nu.lana", "\ud0c0\uc774 \ud0d0 \ud638\ub77c \uc22b\uc790" },
            { "lt", "\ub9ac\ud22c\uc544\ub2c8\uc544\uc5b4" },
            { "lu", "\ub8e8\ubc14-\uce74\ud0c4\uac00\uc5b4" },
            { "lv", "\ub77c\ud2b8\ube44\uc544\uc5b4" },
            { "sog", "\uc18c\uadf8\ub514\uc5d4\uc5b4" },
            { "mg", "\ub9d0\ub77c\uac00\uc2dc\uc5b4" },
            { "mh", "\ub9c8\uc15c\uc5b4" },
            { "type.co.ducet", "\uae30\ubcf8 \uc720\ub2c8\ucf54\ub4dc \uc815\ub82c \uc21c\uc11c" },
            { "mi", "\ub9c8\uc624\ub9ac\uc5b4" },
            { "mk", "\ub9c8\ucf00\ub3c4\ub2c8\uc544\uc5b4" },
            { "ml", "\ub9d0\ub77c\uc584\ub78c\uc5b4" },
            { "mn", "\ubabd\uace8\uc5b4" },
            { "mr", "\ub9c8\ub77c\ud2f0\uc5b4" },
            { "ms", "\ub9d0\ub808\uc774\uc5b4" },
            { "mt", "\ubab0\ud0c0\uc5b4" },
            { "my", "\ubc84\ub9c8\uc5b4" },
            { "Saur", "\uc0ac\uc6b0\ub77c\uc288\ud2b8\ub77c \ubb38\uc790" },
            { "Armn", "\uc544\ub974\uba54\ub2c8\uc544 \ubb38\uc790" },
            { "mdf", "\ubaa8\ud06c\uc0e4\uc5b4" },
            { "mde", "\ub9c8\ubc14\uc5b4" },
            { "dsb", "\uc800\uc9c0 \uc18c\ub974\ube44\uc544\uc5b4" },
            { "Armi", "\uc544\ub78d\uc81c\uad6d \ubb38\uc790" },
            { "na", "\ub098\uc6b0\ub8e8\uc5b4" },
            { "type.co.search", "\ubc94\uc6a9 \uac80\uc0c9" },
            { "nb", "\ub178\ub974\uc6e8\uc774\uc5b4(\ubcf4\ud06c\ub9d0)" },
            { "nd", "\ubd81\ubd80 \uc740\ub370\ubca8\ub808\uc5b4" },
            { "ne", "\ub124\ud314\uc5b4" },
            { "ng", "\ub290\ub3d9\uac00\uc5b4" },
            { "mdr", "\ub9cc\ub2e4\ub974\uc5b4" },
            { "nl", "\ub124\ub35c\ub780\ub4dc\uc5b4" },
            { "nn", "\ub178\ub974\uc6e8\uc774\uc5b4(\ub2c8\ub178\ub974\uc2a4\ud06c)" },
            { "no", "\ub178\ub974\uc6e8\uc774\uc5b4" },
            { "nr", "\ub0a8\ubd80 \uc740\ub370\ubca8\ub808\uc5b4" },
            { "nv", "\ub098\ubc14\ud638\uc5b4" },
            { "kaa", "\uce74\ub77c\uce7c\ud30c\ud06c\uc5b4" },
            { "ny", "\ub0d4\uc790\uc5b4" },
            { "kac", "\uce74\uce5c\uc5b4" },
            { "kab", "\ucee4\ubc14\uc77c\uc5b4" },
            { "oc", "\uc624\ud06c\uc5b4" },
            { "kaj", "\uae4c\uaf2c\ud1a0\ub044\uc5b4" },
            { "kam", "\uce84\ubc14\uc5b4" },
            { "men", "\uba58\ub370\uc5b4" },
            { "oj", "\uc624\uc9c0\ube0c\uc640\uc5b4" },
            { "mer", "\uba54\ub8e8\uc5b4" },
            { "type.nu.armn", "\uc544\ub974\uba54\ub2c8\uc544 \uc22b\uc790" },
            { "om", "\uc624\ub85c\ubaa8\uc5b4" },
            { "kaw", "\uce74\uc704\uc5b4" },
            { "or", "\uc624\ub9ac\uc57c\uc5b4" },
            { "os", "\uc624\uc138\ud2b8\uc5b4" },
            { "%%ALALC97", "ALA-LC \ub85c\ub9c8\uc790 \ud45c\uae30\ubc95(1997\ub144 \uac1c\uc815)" },
            { "kbd", "\uce74\ubc14\ub974\ub514\uc5b4" },
            { "mfe", "\ubaa8\ub9ac\uc2a4\uc580\uc5b4" },
            { "srn", "\uc2a4\ub77c\ub09c \ud1b5\uac00\uc5b4" },
            { "pa", "\ud380\uc7a1\uc5b4" },
            { "dua", "\ub450\uc54c\ub77c\uc5b4" },
            { "srr", "\uc138\ub808\ub974\uc5b4" },
            { "kbl", "\uce74\ub134\ubd80\uc5b4" },
            { "pi", "\ud314\ub9ac\uc5b4" },
            { "pl", "\ud3f4\ub780\ub4dc\uc5b4" },
            { "dum", "\uc911\uc138 \ub124\ub35c\ub780\ub4dc\uc5b4" },
            { "type.nu.saur", "\uc0ac\uc6b0\ub77c\uc288\ud2b8\ub77c \uc22b\uc790" },
            { "type.ca.dangi", "\ub2e8\uae30\ub825" },
            { "%%VALLADER", "\ubc1c\ub77c\ub354" },
            { "ps", "\ud30c\uc288\ud1a0\uc5b4" },
            { "pt", "\ud3ec\ub974\ud22c\uac08\uc5b4" },
            { "mga", "\uc911\uc138 \uc544\uc77c\ub79c\ub4dc\uc5b4" },
            { "key.co", "\uc815\ub82c \uc21c\uc11c" },
            { "kcg", "\ud2f0\uc58d\uc5b4" },
            { "mgh", "\ub9c8\ud06c\ud6c4\uc640-\uba54\ud1a0\uc5b4" },
            { "key.cf", "\ud1b5\ud654 \ud615\uc2dd" },
            { "bra", "\ube0c\ub77c\uc9c0\uc5b4" },
            { "key.ca", "\ub2ec\ub825" },
            { "%%JAUER", "\uc57c\uc6b0\uc5b4" },
            { "Laoo", "\ub77c\uc624 \ubb38\uc790" },
            { "%%SURMIRAN", "\uc11c\ubbf8\uc548" },
            { "mgo", "\uba54\ud0c0\uc5b4" },
            { "type.hc.h23", "24\uc2dc\uac04\uc81c(0\u201323)" },
            { "type.hc.h24", "24\uc2dc\uac04\uc81c(1\u201324)" },
            { "ssy", "\uc0ac\ud638\uc5b4" },
            { "brh", "\ube0c\ub77c\ud6c4\uc774\uc5b4" },
            { "type.nu.mymr", "\ubbf8\uc580\ub9c8 \uc22b\uc790" },
            { "qu", "\ucf00\ucd94\uc544\uc5b4" },
            { "zap", "\uc0ac\ud3ec\ud14c\ud06c\uc5b4" },
            { "brx", "\ubcf4\ub3c4\uc5b4" },
            { "Lana", "\ub780\ub098 \ubb38\uc790" },
            { "kde", "\ub9c8\ucf58\ub370\uc5b4" },
            { "%%VAIDIKA", "\ubc14\uc774\ub514\uce74" },
            { "Ethi", "\uc5d0\ud2f0\uc624\ud53c\uc544 \ubb38\uc790" },
            { "type.hc.h12", "12\uc2dc\uac04\uc81c(1\u201312)" },
            { "type.hc.h11", "12\uc2dc\uac04\uc81c(0\u201311)" },
            { "rm", "\ub85c\ub9cc\uc2dc\uc5b4" },
            { "rn", "\ub8ec\ub514\uc5b4" },
            { "key.cu", "\ud1b5\ud654" },
            { "ro", "\ub8e8\ub9c8\ub2c8\uc544\uc5b4" },
            { "type.nu.orya", "\uc624\ub9ac\uc57c \uc22b\uc790" },
            { "type.nu.hanidec", "\uc911\uad6d\uc5b4 \uc2ed\uc9c4 \uc22b\uc790" },
            { "ru", "\ub7ec\uc2dc\uc544\uc5b4" },
            { "bss", "\uc544\ucfe0\uc988\uc5b4" },
            { "rw", "\ub974\uc644\ub2e4\uc5b4" },
            { "zbl", "\ube14\ub9ac\uc2a4 \uc2ec\ubcfc" },
            { "kea", "\ud06c\ub9ac\uc62c\uc5b4" },
            { "mic", "\ubbf8\ud06c\ub9e5\uc5b4" },
            { "suk", "\uc218\ucfe0\ub9c8\uc5b4" },
            { "Dupl", "\ub4c0\ud50c\ub85c\uc774\uc548 \ubb38\uc790" },
            { "sa", "\uc0b0\uc2a4\ud06c\ub9ac\ud2b8\uc5b4" },
            { "sc", "\uc0ac\ub974\ub514\ub2c8\uc544\uc5b4" },
            { "sus", "\uc218\uc218\uc5b4" },
            { "sd", "\uc2e0\ub514\uc5b4" },
            { "se", "\ubd81\ubd80 \uc0ac\ubbf8\uc5b4" },
            { "min", "\ubbf8\ub0ad\uce74\ubc14\uc6b0\uc5b4" },
            { "sg", "\uc0b0\uace0\uc5b4" },
            { "sh", "\uc138\ub974\ube44\uc544-\ud06c\ub85c\uc544\ud2f0\uc544\uc5b4" },
            { "si", "\uc2f1\ud560\ub77c\uc5b4" },
            { "sux", "\uc218\uba54\ub974\uc5b4" },
            { "sk", "\uc2ac\ub85c\ubc14\ud0a4\uc544\uc5b4" },
            { "sl", "\uc2ac\ub85c\ubca0\ub2c8\uc544\uc5b4" },
            { "Gran", "\uadf8\ub780\ud0c0 \ubb38\uc790" },
            { "sm", "\uc0ac\ubaa8\uc544\uc5b4" },
            { "sn", "\uc1fc\ub098\uc5b4" },
            { "so", "\uc18c\ub9d0\ub9ac\uc544\uc5b4" },
            { "type.nu.arab", "\uc544\ub77c\ube44\uc544-\uc778\ub3c4\uc2dd \uc22b\uc790" },
            { "sq", "\uc54c\ubc14\ub2c8\uc544\uc5b4" },
            { "sr", "\uc138\ub974\ube44\uc544\uc5b4" },
            { "ss", "\uc2dc\uc2a4\uc640\ud2f0\uc5b4" },
            { "type.cf.account", "\ud68c\uacc4 \ud1b5\ud654 \ud615\uc2dd" },
            { "st", "\ub0a8\ubd80 \uc18c\ud1a0\uc5b4" },
            { "Java", "\uc790\ubc14 \ubb38\uc790" },
            { "su", "\uc21c\ub2e4\uc5b4" },
            { "sv", "\uc2a4\uc6e8\ub374\uc5b4" },
            { "sw", "\uc2a4\uc640\ud790\ub9ac\uc5b4" },
            { "type.nu.hantfin", "\uc911\uad6d\uc5b4 \ubc88\uccb4 \uc7ac\ubb34 \uc22b\uc790" },
            { "ibb", "\uc774\ube44\ube44\uc624\uc5b4" },
            { "iba", "\uc774\ubc18\uc5b4" },
            { "ta", "\ud0c0\ubc00\uc5b4" },
            { "142", "\uc544\uc2dc\uc544" },
            { "bua", "\ubd80\ub9ac\uc544\ud0c0" },
            { "143", "\uc911\uc559 \uc544\uc2dc\uc544" },
            { "te", "\ud154\ub8e8\uad6c\uc5b4" },
            { "145", "\uc11c\uc544\uc2dc\uc544" },
            { "tg", "\ud0c0\uc9c0\ud06c\uc5b4" },
            { "th", "\ud0dc\uad6d\uc5b4" },
            { "ti", "\ud2f0\uadf8\ub9ac\ub0d0\uc5b4" },
            { "bug", "\ubd80\uae30\uc5b4" },
            { "kfo", "\ucf54\ub85c\uc5b4" },
            { "tk", "\ud22c\ub974\ud06c\uba58\uc5b4" },
            { "tl", "\ud0c0\uac08\ub85c\uadf8\uc5b4" },
            { "tn", "\uce20\uc640\ub098\uc5b4" },
            { "to", "\ud1b5\uac00\uc5b4" },
            { "bum", "\ubd88\ub8e8\uc5b4" },
            { "dyo", "\uc878\ub77c \ud3ec\ub2c8\uc5b4" },
            { "type.nu.jpan", "\uc77c\ubcf8 \uc22b\uc790" },
            { "tr", "\ud130\ud0a4\uc5b4" },
            { "ts", "\ucd1d\uac00\uc5b4" },
            { "swb", "\ucf54\ubaa8\ub85c\uc5b4" },
            { "Cakm", "\ucc28\ud06c\ub9c8 \ubb38\uc790" },
            { "tt", "\ud0c0\ud0c0\ub974\uc5b4" },
            { "dyu", "\ub4dc\uc728\ub77c\uc5b4" },
            { "tw", "\ud2b8\uc704\uc5b4" },
            { "ty", "\ud0c0\ud788\ud2f0\uc5b4" },
            { "150", "\uc720\ub7fd" },
            { "151", "\ub3d9\uc720\ub7fd" },
            { "154", "\ubd81\uc720\ub7fd" },
            { "dzg", "\ub2e4\uc7a5\uac00\uc5b4" },
            { "155", "\uc11c\uc720\ub7fd" },
            { "ug", "\uc704\uad6c\ub974\uc5b4" },
            { "Ital", "\uace0\ub300 \uc774\ud0c8\ub9ac\uc544 \ubb38\uc790" },
            { "Kore", "\ud55c\uad6d \ubb38\uc790" },
            { "Zyyy", "\uc77c\ubc18 \ubb38\uc790" },
            { "uk", "\uc6b0\ud06c\ub77c\uc774\ub098\uc5b4" },
            { "type.ca.coptic", "\ucf65\ud2b8\ub825" },
            { "ur", "\uc6b0\ub974\ub450\uc5b4" },
            { "xal", "\uce7c\ubbf8\ud06c\uc5b4" },
            { "zen", "\uc81c\ub098\uac00\uc5b4" },
            { "uz", "\uc6b0\uc988\ubca0\ud06c\uc5b4" },
            { "kha", "\uce74\uc2dc\uc5b4" },
            { "nds_NL", "\uc800\uc9c0 \uc0c9\uc2a8\uc5b4" },
            { "Sylo", "\uc2e4\ud5e4\ud2f0 \ub098\uac00\ub9ac" },
            { "ve", "\ubca4\ub2e4\uc5b4" },
            { "Wara", "\ubc14\ub791 \ud06c\uc2dc\ud2f0 \ubb38\uc790" },
            { "type.ca.roc", "\ub300\ub9cc\ub825" },
            { "vi", "\ubca0\ud2b8\ub0a8\uc5b4" },
            { "kho", "\ud638\ud0c4\uc5b4" },
            { "khq", "\ucf54\uc774\ub77c \uce5c\ub2c8\uc5b4" },
            { "key.hc", "\uc2dc\uac04\ud45c\uc2dc\ubc95(12\uc2dc, 24\uc2dc)" },
            { "vo", "\ubcfc\ub77c\ud4cc\ud06c\uc5b4" },
            { "khw", "\ucf54\uc640\ub974\uc5b4" },
            { "syc", "\uace0\uc804 \uc2dc\ub9ac\uc544\uc5b4" },
            { "Osma", "\uc624\uc2a4\ub9c8\ub2c8\uc544 \ubb38\uc790" },
            { "quc", "\ud0a4\uccb4\uc5b4" },
            { "gaa", "\uac00\uc5b4" },
            { "wa", "\uc648\ub860\uc5b4" },
            { "gag", "\uac00\uac00\uc6b0\uc2a4\uc5b4" },
            { "syr", "\uc2dc\ub9ac\uc544\uc5b4" },
            { "Grek", "\uadf8\ub9ac\uc2a4 \ubb38\uc790" },
            { "gan", "\uac04\uc5b4" },
            { "Lydi", "\ub9ac\ub514\uc544 \ubb38\uc790" },
            { "Xsux", "\uc218\uba54\ub974-\uc544\uce74\ub4dc\uc5b4 \uc124\ud615\ubb38\uc790" },
            { "wo", "\uc6d4\ub85c\ud504\uc5b4" },
            { "zgh", "\ud45c\uc900 \ubaa8\ub85c\ucf54 \ud0c0\ub9c8\uc9c0\ud2b8\uc5b4" },
            { "ar_001", "\ud604\ub300 \ud45c\uc900 \uc544\ub78d\uc5b4" },
            { "Cans", "\ud1b5\ud569 \uce90\ub098\ub2e4 \ud1a0\ucc29\uc5b4" },
            { "gay", "\uac00\uc694\uc5b4" },
            { "Mong", "\ubabd\uace8 \ubb38\uc790" },
            { "mnc", "\ub9cc\uc8fc\uc5b4" },
            { "Latf", "\ub3c5\uc77c\uc2dd \ub85c\ub9c8\uc790" },
            { "Hluw", "\uc544\ub098\ud1a8\ub9ac\uc544 \uc0c1\ud615\ubb38\uc790" },
            { "gba", "\uadf8\ubc14\uc57c\uc5b4" },
            { "mni", "\ub9c8\ub2c8\ud478\ub9ac\uc5b4" },
            { "Latn", "\ub85c\ub9c8\uc790" },
            { "Latg", "\uc544\uc77c\ub79c\ub4dc\uc2dd \ub85c\ub9c8\uc790" },
            { "type.nu.hans", "\uc911\uad6d\uc5b4 \uac04\uccb4 \uc22b\uc790" },
            { "type.nu.hant", "\uc911\uad6d\uc5b4 \ubc88\uccb4 \uc22b\uc790" },
            { "xh", "\ucf54\uc0ac\uc5b4" },
            { "type.nu.romanlow", "\ub85c\ub9c8 \uc18c\ubb38\uc790 \uc22b\uc790" },
            { "byn", "\ube0c\ub9b0\uc5b4" },
            { "%%PAMAKA", "\ud30c\ub9c8\uce74 \ubc29\uc5b8" },
            { "Lyci", "\ub9ac\ud0a4\uc544 \ubb38\uc790" },
            { "osa", "\uc624\uc138\uc774\uc9c0\uc5b4" },
            { "byv", "\uba54\ub460\ubc14\uc5b4" },
            { "gbz", "\uc870\ub85c\uc544\uc2a4\ud130 \ub2e4\ub9ac\uc5b4" },
            { "Moon", "\ubb38 \ubb38\uc790" },
            { "moh", "\ubaa8\ud638\ud06c\uc5b4" },
            { "kkj", "\uce74\ucf54\uc5b4" },
            { "yi", "\uc774\ub514\uc2dc\uc5b4" },
            { "mos", "\ubaa8\uc2dc\uc5b4" },
            { "Syrc", "\uc2dc\ub9ac\uc544 \ubb38\uc790" },
            { "Dsrt", "\ub514\uc800\ub81b \ubb38\uc790" },
            { "yo", "\uc694\ub8e8\ubc14\uc5b4" },
            { "type.nu.traditional", "\uc804\ud1b5\uc801\uc778 \uc22b\uc790" },
            { "Syrj", "\uc11c\ubd80 \uc2dc\ub9ac\uc544 \ubb38\uc790" },
            { "ota", "\uc624\uc2a4\ub9cc \ud130\ud0a4\uc5b4" },
            { "Syre", "\uc5d0\uc2a4\ud2b8\ub791\uac94\ub85c\uc2dd \uc2dc\ub9ac\uc544 \ubb38\uc790" },
            { "vai", "\ubc14\uc774\uc5b4" },
            { "za", "\uc8fc\uc559\uc5b4" },
            { "Cari", "\uce74\ub9ac \ubb38\uc790" },
            { "kln", "\uce7c\ub80c\uc9c4\uc5b4" },
            { "zh", "\uc911\uad6d\uc5b4" },
            { "Afak", "\uc544\ud30c\uce74 \ubb38\uc790" },
            { "Bopo", "\uc8fc\uc74c\ubd80\ud638" },
            { "Perm", "\uace0\ub300 \ud398\ub984 \ubb38\uc790" },
            { "key.lb", "\uc904\ubc14\uafc8 \uc2a4\ud0c0\uc77c" },
            { "zu", "\uc904\ub8e8\uc5b4" },
            { "type.co.phonebook", "\uc804\ud654\ubc88\ud638\ubd80\uc21c" },
            { "Geor", "\uc870\uc9c0\uc544 \ubb38\uc790" },
            { "Shrd", "\uc0ac\ub77c\ub2e4 \ubb38\uc790" },
            { "kmb", "\ud0b4\ubd84\ub450\uc5b4" },
            { "type.nu.jpanfin", "\uc77c\ubcf8 \uc7ac\ubb34 \uc22b\uc790" },
            { "Cham", "\uce78 \uace0\uc5b4" },
            { "gez", "\uac8c\uc774\uc988\uc5b4" },
            { "mrj", "\uc11c\ubd80 \ub9c8\ub9ac\uc5b4" },
            { "Syrn", "\ub3d9\ubd80 \uc2dc\ub9ac\uc544 \ubb38\uc790" },
            { "type.nu.mymrshan", "\ubbf8\uc580\ub9c8 \uc0e8 \uc22b\uc790" },
            { "Elba", "\uc5d8\ubc14\uc0b0 \ubb38\uc790" },
            { "Narb", "\uc61b \ubd81\ubd80 \uc544\ub77c\ube44\uc544 \ubb38\uc790" },
            { "type.nu.olck", "\uc62c\uce58\ud0a4 \uc22b\uc790" },
            { "type.co.reformed", "\uac1c\uc815 \uc815\ub82c\uc21c" },
            { "Tglg", "\ud0c0\uac08\ub85c\uadf8 \ubb38\uc790" },
            { "Egyd", "\uace0\ub300 \uc774\uc9d1\ud2b8 \ubbfc\uc911\ubb38\uc790" },
            { "Egyh", "\uace0\ub300 \uc774\uc9d1\ud2b8 \uc2e0\uad00\ubb38\uc790" },
            { "%%ITIHASA", "\uc774\ub760\uc544\uc0ac" },
            { "Palm", "\ud314\ubbf8\ub77c \ubb38\uc790" },
            { "ebu", "\uc5e0\ubd80\uc5b4" },
            { "Egyp", "\uace0\ub300 \uc774\uc9d1\ud2b8 \uc2e0\uc131\ubb38\uc790" },
            { "Geok", "\uadf8\ub8e8\uc9c0\uc57c \ucfe0\uce20\ub9ac \ubb38\uc790" },
            { "koi", "\ucf54\ubbf8\ud398\ub974\uba00\ud06c\uc5b4" },
            { "Hung", "\uace0\ub300 \ud5dd\uac00\ub9ac \ubb38\uc790" },
            { "kok", "\ucf54\uce74\ub2c8\uc5b4" },
            { "%%1901", "\uc804\ud1b5 \ub3c5\uc77c\uc5b4 \ud45c\uae30\ubc95" },
            { "kos", "\ucf54\uc2a4\ub77c\uc774\uc5d4\uc5b4" },
            { "type.nu.limb", "\ub9bc\ubd80 \uc22b\uc790" },
            { "Sund", "\uc21c\ub2e4 \ubb38\uc790" },
            { "kpe", "\ud06c\ud3a0\ub808\uc5b4" },
            { "type.nu.khmr", "\ud06c\uba54\ub974 \uc22b\uc790" },
            { "Tirh", "\ud2f0\ub974\ud6c4\ud0c0 \ubb38\uc790" },
            { "ilo", "\uc774\ub85c\ucf54\uc5b4" },
            { "Cprt", "\ud0a4\ud504\ub85c\uc2a4 \ubb38\uc790" },
            { "mua", "\ubb38\ub2f9\uc5b4" },
            { "type.nu.guru", "\uad74\ubb35\ud0a4 \uc22b\uc790" },
            { "mul", "\ub2e4\uc911 \uc5b8\uc5b4" },
            { "%%PUTER", "\ud4e8\ud130" },
            { "cad", "\uce74\ub3c4\uc5b4" },
            { "key.ms", "\uacc4\ub7c9\ubc95" },
            { "mus", "\ud06c\ub9ac\ud06c\uc5b4" },
            { "Glag", "\uae00\ub77c\uace8 \ubb38\uc790" },
            { "gil", "\ud0a4\ub9ac\ubc14\uc2dc\uc5b4" },
            { "Cher", "\uccb4\ub85c\ud0a4 \ubb38\uc790" },
            { "car", "\uce74\ub9ac\ube0c\uc5b4" },
            { "cay", "\uce74\uc720\uac00\uc5b4" },
            { "type.nu.tamldec", "\ud0c0\ubc00 \uc22b\uc790" },
            { "krc", "\uce74\ub77c\ucc60\uc774-\ubc1c\uce74\ub974\uc5b4" },
            { "inh", "\uc778\uadc0\uc2dc\uc5b4" },
            { "fa_AF", "\ub2e4\ub9ac\uc5b4" },
            { "krl", "\uce74\ub810\ub9ac\uc57c\uc5b4" },
            { "efi", "\uc774\ud53d\uc5b4" },
            { "key.nu", metaValue_key_nu },
            { "kru", "\ucfe0\ub974\ud06c\uc5b4" },
            { "ksb", "\uc0f4\ubc1c\ub77c\uc5b4" },
            { "Telu", "\ud154\ub8e8\uad6c \ubb38\uc790" },
            { "ksf", "\ubc14\ud53c\uc544\uc5b4" },
        };
        return data;
    }
}
