/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.otp.erlang;

import com.ericsson.otp.erlang.Link;
import com.ericsson.otp.erlang.OtpErlangPid;

class Links {
    Link[] links;
    int count;
    int active;

    Links() {
        this(10);
    }

    Links(int n) {
        this.links = new Link[n];
        this.count = 0;
        this.active = 0;
    }

    synchronized boolean addLink(OtpErlangPid otpErlangPid, OtpErlangPid otpErlangPid2, boolean bl) {
        int n = this.find(otpErlangPid, otpErlangPid2);
        if (n != -1) {
            if (this.links[n].getUnlinking() != 0L && bl) {
                this.links[n].setUnlinking(0L);
                ++this.active;
                return true;
            }
            return false;
        }
        if (this.count >= this.links.length) {
            Link[] linkArray = new Link[this.count * 2];
            System.arraycopy(this.links, 0, linkArray, 0, this.count);
            this.links = linkArray;
        }
        this.links[this.count++] = new Link(otpErlangPid, otpErlangPid2);
        ++this.active;
        return true;
    }

    synchronized boolean removeLink(OtpErlangPid otpErlangPid, OtpErlangPid otpErlangPid2) {
        int n = this.find(otpErlangPid, otpErlangPid2);
        if (n != -1) {
            long l = this.links[n].getUnlinking();
            --this.count;
            this.links[n] = this.links[this.count];
            this.links[this.count] = null;
            if (l == 0L) {
                --this.active;
                return true;
            }
        }
        return false;
    }

    synchronized boolean removeActiveLink(OtpErlangPid otpErlangPid, OtpErlangPid otpErlangPid2) {
        int n = this.find(otpErlangPid, otpErlangPid2);
        if (n != -1) {
            long l = this.links[n].getUnlinking();
            if (l != 0L) {
                return false;
            }
            --this.count;
            --this.active;
            this.links[n] = this.links[this.count];
            this.links[this.count] = null;
            return true;
        }
        return false;
    }

    synchronized boolean removeUnlinkingLink(OtpErlangPid otpErlangPid, OtpErlangPid otpErlangPid2, long l) {
        if (l == 0L) {
            return false;
        }
        int n = this.find(otpErlangPid, otpErlangPid2);
        if (n != -1) {
            long l2 = this.links[n].getUnlinking();
            if (l2 != l) {
                return false;
            }
            --this.count;
            this.links[n] = this.links[this.count];
            this.links[this.count] = null;
            return true;
        }
        return false;
    }

    synchronized boolean setUnlinking(OtpErlangPid otpErlangPid, OtpErlangPid otpErlangPid2, long l) {
        if (l == 0L) {
            return false;
        }
        int n = this.find(otpErlangPid, otpErlangPid2);
        if (n != -1 && this.links[n].getUnlinking() == 0L) {
            this.links[n].setUnlinking(l);
            --this.active;
            return true;
        }
        return false;
    }

    synchronized int find(OtpErlangPid otpErlangPid, OtpErlangPid otpErlangPid2) {
        for (int i = 0; i < this.count; ++i) {
            if (!this.links[i].equals(otpErlangPid, otpErlangPid2)) continue;
            return i;
        }
        return -1;
    }

    synchronized OtpErlangPid[] remotePids() {
        OtpErlangPid[] otpErlangPidArray = null;
        if (this.active != 0) {
            int n = 0;
            otpErlangPidArray = new OtpErlangPid[this.active];
            int n2 = 0;
            while (n < this.active) {
                if (this.links[n2].getUnlinking() == 0L) {
                    otpErlangPidArray[n++] = this.links[n2].remote();
                }
                ++n2;
            }
        }
        return otpErlangPidArray;
    }

    synchronized Link[] clearLinks() {
        Link[] linkArray = null;
        if (this.count != 0) {
            linkArray = new Link[this.count];
            for (int i = 0; i < this.count; ++i) {
                linkArray[i] = this.links[i];
                this.links[i] = null;
            }
            this.count = 0;
        }
        return linkArray;
    }
}

