/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.testng.IClass;
import org.testng.IConfigurable;
import org.testng.IInvokedMethodListener;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.Reporter;
import org.testng.SuiteRunState;
import org.testng.TestNGException;
import org.testng.annotations.IConfigurationAnnotation;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.collections.Sets;
import org.testng.internal.BaseInvoker;
import org.testng.internal.ClassHelper;
import org.testng.internal.ConfigMethodArguments;
import org.testng.internal.ConfigurationMethod;
import org.testng.internal.ConstructorOrMethod;
import org.testng.internal.GroupConfigMethodArguments;
import org.testng.internal.IConfigInvoker;
import org.testng.internal.IConfiguration;
import org.testng.internal.IInvocationStatus;
import org.testng.internal.ITestResultNotifier;
import org.testng.internal.InvokedMethod;
import org.testng.internal.Invoker;
import org.testng.internal.MethodHelper;
import org.testng.internal.MethodInvocationHelper;
import org.testng.internal.Parameters;
import org.testng.internal.RuntimeBehavior;
import org.testng.internal.TestListenerHelper;
import org.testng.internal.TestNgMethodUtils;
import org.testng.internal.TestResult;
import org.testng.internal.Utils;
import org.testng.internal.annotations.AnnotationHelper;
import org.testng.internal.invokers.InvokedMethodListenerMethod;
import org.testng.internal.thread.ThreadUtil;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlSuite;

class ConfigInvoker
extends BaseInvoker
implements IConfigInvoker {
    protected final Map<ITestNGMethod, Set<Object>> m_methodInvocationResults = Maps.newConcurrentMap();
    private final boolean m_continueOnFailedConfiguration;
    private final Set<ITestNGMethod> m_executedConfigMethods = ConcurrentHashMap.newKeySet();
    private final Map<String, Boolean> m_beforegroupsFailures = Maps.newConcurrentMap();

    public ConfigInvoker(ITestResultNotifier notifier, Collection<IInvokedMethodListener> invokedMethodListeners, ITestContext testContext, SuiteRunState suiteState, IConfiguration configuration) {
        super(notifier, invokedMethodListeners, testContext, suiteState, configuration);
        this.m_continueOnFailedConfiguration = testContext.getSuite().getXmlSuite().getConfigFailurePolicy() == XmlSuite.FailurePolicy.CONTINUE;
    }

    @Override
    public boolean hasConfigurationFailureFor(ITestNGMethod testNGMethod, String[] groups, IClass testClass, Object instance) {
        boolean result = false;
        Class<?> cls = testClass.getRealClass();
        if (this.m_suiteState.isFailed()) {
            result = true;
        } else {
            boolean hasConfigurationFailures = this.classConfigurationFailed(cls, instance);
            if (hasConfigurationFailures) {
                if (!this.m_continueOnFailedConfiguration) {
                    result = true;
                } else {
                    Set<Object> set = this.getInvocationResults(testClass);
                    result = set.contains(instance);
                }
                return result;
            }
            if (this.m_continueOnFailedConfiguration && this.hasConfigFailure(testNGMethod)) {
                Object key = TestNgMethodUtils.getMethodInvocationToken(testNGMethod, instance);
                result = this.m_methodInvocationResults.get(testNGMethod).contains(key);
            } else if (!this.m_continueOnFailedConfiguration) {
                for (Class clazz : this.m_classInvocationResults.keySet()) {
                    if (!clazz.isAssignableFrom(cls) || !((Set)this.m_classInvocationResults.get(clazz)).contains(instance)) continue;
                    result = true;
                    break;
                }
            }
        }
        for (String group : groups) {
            if (!this.m_beforegroupsFailures.containsKey(group)) continue;
            result = true;
            break;
        }
        return result;
    }

    @Override
    public void invokeBeforeGroupsConfigurations(GroupConfigMethodArguments arguments) {
        String[] groups;
        if (arguments.isGroupFilteringDisabled()) {
            return;
        }
        List filteredMethods = Lists.newArrayList();
        for (String group : groups = arguments.getTestMethod().getGroups()) {
            List<ITestNGMethod> methods = arguments.getGroupMethods().getBeforeGroupMethodsForGroup(group);
            if (methods == null) continue;
            filteredMethods.addAll(methods);
        }
        ITestNGMethod[] beforeMethodsArray = filteredMethods.toArray(new ITestNGMethod[0]);
        if (beforeMethodsArray.length > 0) {
            ITestNGMethod[] filteredConfigurations = (ITestNGMethod[])Arrays.stream(beforeMethodsArray).filter(ConfigInvoker::isGroupLevelConfigurationMethod).toArray(ITestNGMethod[]::new);
            if (filteredConfigurations.length == 0) {
                return;
            }
            ConfigMethodArguments configMethodArguments = new ConfigMethodArguments.Builder().usingConfigMethodsAs(filteredConfigurations).forSuite(arguments.getSuite()).usingParameters(arguments.getParameters()).usingInstance(arguments.getInstance()).forTestMethod(arguments.getTestMethod()).build();
            this.invokeConfigurations(configMethodArguments);
        }
        arguments.getGroupMethods().removeBeforeGroups(groups);
    }

    private static boolean isGroupLevelConfigurationMethod(ITestNGMethod itm) {
        return itm.hasBeforeGroupsConfiguration() || itm.hasAfterGroupsConfiguration();
    }

    @Override
    public void invokeAfterGroupsConfigurations(GroupConfigMethodArguments arguments) {
        String[] groups;
        if (arguments.getTestMethod().getGroups().length == 0) {
            return;
        }
        if (arguments.isGroupFilteringDisabled()) {
            return;
        }
        Map<String, String> filteredGroups = Maps.newHashMap();
        for (String group : groups = arguments.getTestMethod().getGroups()) {
            if (!arguments.getGroupMethods().isLastMethodForGroup(group, arguments.getTestMethod())) continue;
            filteredGroups.put(group, group);
        }
        if (filteredGroups.isEmpty()) {
            return;
        }
        Map<ITestNGMethod, ITestNGMethod> afterMethods = Maps.newHashMap();
        for (String g : filteredGroups.values()) {
            List<ITestNGMethod> methods = arguments.getGroupMethods().getAfterGroupMethodsForGroup(g);
            if (methods == null) continue;
            for (ITestNGMethod m : methods) {
                afterMethods.put(m, m);
            }
        }
        ITestNGMethod[] filteredConfigurations = (ITestNGMethod[])afterMethods.keySet().stream().filter(ConfigInvoker::isGroupLevelConfigurationMethod).toArray(ITestNGMethod[]::new);
        if (filteredConfigurations.length == 0) {
            return;
        }
        ConfigMethodArguments configMethodArguments = new ConfigMethodArguments.Builder().usingConfigMethodsAs(filteredConfigurations).forSuite(arguments.getSuite()).usingParameters(arguments.getParameters()).usingInstance(arguments.getInstance()).forTestMethod(arguments.getTestMethod()).build();
        this.invokeConfigurations(configMethodArguments);
        arguments.getGroupMethods().removeAfterGroups(filteredGroups.keySet());
    }

    @Override
    public void invokeConfigurations(ConfigMethodArguments arguments) {
        if (arguments.getConfigMethods().length == 0) {
            ConfigInvoker.log(5, "No configuration methods found");
            return;
        }
        ITestNGMethod[] methods = TestNgMethodUtils.filterMethods(arguments.getTestClass(), arguments.getConfigMethods(), Invoker.SAME_CLASS);
        Object[] parameters = new Object[]{};
        for (ITestNGMethod tm : methods) {
            if (null == arguments.getTestClass()) {
                arguments.setTestClass(tm.getTestClass());
            }
            TestResult testResult = TestResult.newContextAwareTestResult(tm, this.m_testContext);
            testResult.setStatus(16);
            IConfigurationAnnotation configurationAnnotation = null;
            try {
                Throwable t;
                boolean canProcessMethod;
                Object inst = tm.getInstance();
                if (inst == null) {
                    inst = arguments.getInstance();
                }
                Class<?> objectClass = inst.getClass();
                ConstructorOrMethod method = tm.getConstructorOrMethod();
                configurationAnnotation = AnnotationHelper.findConfiguration(this.annotationFinder(), method);
                boolean alwaysRun = MethodHelper.isAlwaysRun(configurationAnnotation);
                boolean bl = canProcessMethod = MethodHelper.isEnabled(objectClass, this.annotationFinder()) || alwaysRun;
                if (!canProcessMethod) {
                    ConfigInvoker.log(3, "Skipping " + Utils.detailedMethodName(tm, true) + " because " + objectClass.getName() + " is not enabled");
                    continue;
                }
                if (MethodHelper.isDisabled(configurationAnnotation)) {
                    ConfigInvoker.log(3, "Skipping " + Utils.detailedMethodName(tm, true) + " because it is not enabled");
                    continue;
                }
                if (this.hasConfigurationFailureFor(arguments.getTestMethod(), tm.getGroups(), arguments.getTestClass(), arguments.getInstance()) && !alwaysRun) {
                    ConfigInvoker.log(3, "Skipping " + Utils.detailedMethodName(tm, true));
                    InvokedMethod invokedMethod = new InvokedMethod(System.currentTimeMillis(), testResult);
                    this.runInvokedMethodListeners(InvokedMethodListenerMethod.BEFORE_INVOCATION, invokedMethod, testResult);
                    testResult.setStatus(3);
                    this.runInvokedMethodListeners(InvokedMethodListenerMethod.AFTER_INVOCATION, invokedMethod, testResult);
                    this.handleConfigurationSkip(tm, testResult, configurationAnnotation, arguments.getTestMethod(), arguments.getInstance(), arguments.getSuite());
                    continue;
                }
                ConfigInvoker.log(3, "Invoking " + Utils.detailedMethodName(tm, true));
                if (arguments.getTestMethodResult() != null) {
                    ((TestResult)arguments.getTestMethodResult()).setMethod(arguments.getTestMethod());
                }
                parameters = Parameters.createConfigurationParameters(tm.getConstructorOrMethod().getMethod(), arguments.getParameters(), arguments.getParameterValues(), arguments.getTestMethod(), this.annotationFinder(), arguments.getSuite(), this.m_testContext, arguments.getTestMethodResult());
                testResult.setParameters(parameters);
                this.runConfigurationListeners(testResult, arguments.getTestMethod(), true);
                Object newInstance = ConfigInvoker.computeInstance(arguments.getInstance(), inst, tm);
                if (ConfigInvoker.isConfigMethodEligibleForScrutiny(tm)) {
                    if (this.m_executedConfigMethods.add(arguments.getTestMethod())) {
                        this.invokeConfigurationMethod(newInstance, tm, parameters, testResult);
                    }
                } else {
                    this.invokeConfigurationMethod(newInstance, tm, parameters, testResult);
                }
                ConfigInvoker.copyAttributesFromNativelyInjectedTestResult(parameters, arguments.getTestMethodResult());
                this.runConfigurationListeners(testResult, arguments.getTestMethod(), false);
                if (testResult.getStatus() != 3 || (t = testResult.getThrowable()) == null) continue;
                throw t;
            }
            catch (Throwable ex) {
                this.handleConfigurationFailure(ex, tm, testResult, configurationAnnotation, arguments.getTestMethod(), arguments.getInstance(), arguments.getSuite());
                ConfigInvoker.copyAttributesFromNativelyInjectedTestResult(parameters, arguments.getTestMethodResult());
            }
        }
    }

    private void invokeConfigurationMethod(Object targetInstance, ITestNGMethod tm, Object[] params, ITestResult testResult) throws InvocationTargetException, IllegalAccessException {
        tm.setId(ThreadUtil.currentThreadInfo());
        InvokedMethod invokedMethod = new InvokedMethod(System.currentTimeMillis(), testResult);
        this.runInvokedMethodListeners(InvokedMethodListenerMethod.BEFORE_INVOCATION, invokedMethod, testResult);
        if (tm instanceof IInvocationStatus) {
            ((IInvocationStatus)((Object)tm)).setInvokedAt(invokedMethod.getDate());
        }
        if (testResult.getStatus() == 3) {
            testResult.setEndMillis(System.currentTimeMillis());
            Reporter.setCurrentTestResult(testResult);
            this.runInvokedMethodListeners(InvokedMethodListenerMethod.AFTER_INVOCATION, invokedMethod, testResult);
            Reporter.setCurrentTestResult(null);
            return;
        }
        try {
            Reporter.setCurrentTestResult(testResult);
            ConstructorOrMethod method = tm.getConstructorOrMethod();
            IConfigurable configurableInstance = this.computeConfigurableInstance(method, targetInstance);
            if (RuntimeBehavior.isDryRun()) {
                testResult.setStatus(1);
                return;
            }
            if (configurableInstance != null) {
                MethodInvocationHelper.invokeConfigurable(targetInstance, params, configurableInstance, method.getMethod(), testResult);
            } else {
                MethodInvocationHelper.invokeMethodConsideringTimeout(tm, method, targetInstance, params, testResult);
            }
            testResult.setStatus(1);
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            this.throwConfigurationFailure(testResult, ex);
            testResult.setStatus(2);
            throw ex;
        }
        catch (Throwable ex) {
            this.throwConfigurationFailure(testResult, ex);
            testResult.setStatus(2);
            throw new TestNGException(ex);
        }
        finally {
            testResult.setEndMillis(System.currentTimeMillis());
            Reporter.setCurrentTestResult(testResult);
            this.runInvokedMethodListeners(InvokedMethodListenerMethod.AFTER_INVOCATION, invokedMethod, testResult);
            Reporter.setCurrentTestResult(null);
        }
    }

    private void throwConfigurationFailure(ITestResult testResult, Throwable ex) {
        testResult.setStatus(2);
        testResult.setThrowable(ex.getCause() == null ? ex : ex.getCause());
    }

    private IConfigurable computeConfigurableInstance(ConstructorOrMethod method, Object targetInstance) {
        return IConfigurable.class.isAssignableFrom(method.getDeclaringClass()) ? (IConfigurable)targetInstance : this.m_configuration.getConfigurable();
    }

    private void runConfigurationListeners(ITestResult tr, ITestNGMethod tm, boolean before) {
        if (before) {
            TestListenerHelper.runPreConfigurationListeners(tr, tm, this.m_notifier.getConfigurationListeners());
        } else {
            TestListenerHelper.runPostConfigurationListeners(tr, tm, this.m_notifier.getConfigurationListeners());
        }
    }

    private void handleConfigurationSkip(ITestNGMethod tm, ITestResult testResult, IConfigurationAnnotation annotation, ITestNGMethod currentTestMethod, Object instance, XmlSuite suite) {
        this.recordConfigurationInvocationFailed(tm, testResult.getTestClass(), annotation, currentTestMethod, instance, suite);
        testResult.setStatus(3);
        this.runConfigurationListeners(testResult, currentTestMethod, false);
    }

    private boolean hasConfigFailure(ITestNGMethod currentTestMethod) {
        return currentTestMethod != null && this.m_methodInvocationResults.containsKey(currentTestMethod);
    }

    private void handleConfigurationFailure(Throwable ite, ITestNGMethod tm, ITestResult testResult, IConfigurationAnnotation annotation, ITestNGMethod currentTestMethod, Object instance, XmlSuite suite) {
        Throwable cause;
        Throwable throwable = cause = ite.getCause() != null ? ite.getCause() : ite;
        if (this.isSkipExceptionAndSkip(cause)) {
            testResult.setThrowable(cause);
            this.handleConfigurationSkip(tm, testResult, annotation, currentTestMethod, instance, suite);
            return;
        }
        Utils.log("", 3, "Failed to invoke configuration method " + tm.getQualifiedName() + ":" + cause.getMessage());
        this.handleException(cause, tm, testResult, 1);
        testResult.setStatus(2);
        this.runConfigurationListeners(testResult, currentTestMethod, false);
        if (null != annotation) {
            this.recordConfigurationInvocationFailed(tm, testResult.getTestClass(), annotation, currentTestMethod, instance, suite);
        }
    }

    private static boolean isConfigMethodEligibleForScrutiny(ITestNGMethod tm) {
        if (!tm.isBeforeMethodConfiguration()) {
            return false;
        }
        if (!(tm instanceof ConfigurationMethod)) {
            return false;
        }
        ConfigurationMethod cfg = (ConfigurationMethod)tm;
        return cfg.isFirstTimeOnly();
    }

    private boolean classConfigurationFailed(Class<?> cls, Object instance) {
        return this.m_classInvocationResults.entrySet().stream().anyMatch(classSetEntry -> {
            Set obj = (Set)classSetEntry.getValue();
            Class c = (Class)classSetEntry.getKey();
            boolean containsBeforeTestOrBeforeSuiteFailure = obj.contains(null);
            return c == cls || c.isAssignableFrom(cls) && (obj.contains(instance) || containsBeforeTestOrBeforeSuiteFailure);
        });
    }

    private static void copyAttributesFromNativelyInjectedTestResult(Object[] source, ITestResult target) {
        if (source == null || target == null) {
            return;
        }
        Arrays.stream(source).filter(each -> each instanceof ITestResult).findFirst().ifPresent(eachSource -> TestResult.copyAttributes((ITestResult)eachSource, target));
    }

    private void setMethodInvocationFailure(ITestNGMethod method, Object instance) {
        if (method == null) {
            return;
        }
        Set instances = this.m_methodInvocationResults.computeIfAbsent(method, k -> Sets.newHashSet());
        instances.add(TestNgMethodUtils.getMethodInvocationToken(method, instance));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setClassInvocationFailure(Class<?> clazz, Object instance) {
        Map map = this.m_classInvocationResults;
        synchronized (map) {
            Set instances = this.m_classInvocationResults.computeIfAbsent(clazz, k -> Sets.newHashSet());
            instances.add(instance);
        }
    }

    private void recordConfigurationInvocationFailed(ITestNGMethod tm, IClass testClass, IConfigurationAnnotation annotation, ITestNGMethod currentTestMethod, Object instance, XmlSuite suite) {
        if (annotation.getBeforeTestClass() || annotation.getAfterTestClass()) {
            if (this.m_continueOnFailedConfiguration) {
                this.setClassInvocationFailure(testClass.getRealClass(), instance);
            } else {
                this.setClassInvocationFailure(tm.getRealClass(), instance);
            }
        } else if (annotation.getBeforeTestMethod() || annotation.getAfterTestMethod()) {
            if (this.m_continueOnFailedConfiguration) {
                this.setMethodInvocationFailure(currentTestMethod, instance);
            } else {
                this.setClassInvocationFailure(tm.getRealClass(), instance);
            }
        } else if (annotation.getBeforeSuite() || annotation.getAfterSuite()) {
            this.m_suiteState.failed();
        } else if (annotation.getBeforeTest() || annotation.getAfterTest()) {
            this.setClassInvocationFailure(tm.getRealClass(), instance);
            XmlClass[] classes = ClassHelper.findClassesInSameTest(tm.getRealClass(), suite);
            for (XmlClass xmlClass : classes) {
                this.setClassInvocationFailure(xmlClass.getSupportClass(), instance);
            }
        }
        String[] beforeGroups = annotation.getBeforeGroups();
        for (String group : beforeGroups) {
            this.m_beforegroupsFailures.put(group, Boolean.FALSE);
        }
    }

    private static Object computeInstance(Object instance, Object inst, ITestNGMethod tm) {
        if (instance == null || !tm.getConstructorOrMethod().getDeclaringClass().isAssignableFrom(instance.getClass())) {
            return inst;
        }
        return instance;
    }

    private Set<Object> getInvocationResults(IClass testClass) {
        Class<?> cls = testClass.getRealClass();
        Set set = null;
        while (!cls.equals(Object.class) && (set = (Set)this.m_classInvocationResults.get(cls)) == null) {
            cls = cls.getSuperclass();
        }
        if (set == null) {
            throw new IllegalStateException("No failure logs for " + testClass.getRealClass());
        }
        return set;
    }
}

