/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.util.UnmodifiableIterator;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import gnu.trove.TIntHashSet;
import java.util.AbstractSet;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class CompactVirtualFileSet
extends AbstractSet<VirtualFile> {
    private final Set<VirtualFile> weirdFiles;
    private TIntHashSet idSet;
    private BitSet fileIds;
    private boolean frozen;

    public CompactVirtualFileSet() {
        this.weirdFiles = new THashSet();
    }

    public CompactVirtualFileSet(@NotNull Collection<? extends VirtualFile> files2) {
        if (files2 == null) {
            CompactVirtualFileSet.$$$reportNull$$$0(0);
        }
        this.weirdFiles = new THashSet();
        this.addAll(files2);
    }

    @Override
    public boolean contains(Object file2) {
        if (file2 instanceof VirtualFileWithId) {
            BitSet ids = this.fileIds;
            int id = ((VirtualFileWithId)file2).getId();
            if (ids != null) {
                return ids.get(id);
            }
            TIntHashSet idSet = this.idSet;
            if (idSet != null) {
                return idSet.contains(id);
            }
        }
        return this.weirdFiles.contains(file2);
    }

    @Override
    public boolean add(@NotNull VirtualFile file2) {
        boolean added;
        if (file2 == null) {
            CompactVirtualFileSet.$$$reportNull$$$0(1);
        }
        if (this.frozen) {
            throw new UnsupportedOperationException();
        }
        if (file2 instanceof VirtualFileWithId) {
            int id = ((VirtualFileWithId)((Object)file2)).getId();
            BitSet ids = this.fileIds;
            TIntHashSet idSet = this.idSet;
            if (ids != null) {
                added = !ids.get(id);
                ids.set(id);
            } else if (idSet != null) {
                added = idSet.add(id);
                if (idSet.size() > 1000) {
                    this.fileIds = new BitSet();
                    idSet.forEach(i -> {
                        this.fileIds.set(i);
                        return true;
                    });
                    this.idSet = null;
                }
            } else {
                added = this.weirdFiles.add(file2);
                if (this.weirdFiles.size() > 10) {
                    this.idSet = idSet = new TIntHashSet(this.weirdFiles.size());
                    Iterator<VirtualFile> iterator2 = this.weirdFiles.iterator();
                    while (iterator2.hasNext()) {
                        VirtualFile wf = iterator2.next();
                        if (!(wf instanceof VirtualFileWithId)) continue;
                        int i2 = ((VirtualFileWithId)((Object)wf)).getId();
                        idSet.add(i2);
                        iterator2.remove();
                    }
                }
            }
        } else {
            added = this.weirdFiles.add(file2);
        }
        return added;
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    public void freeze() {
        this.frozen = true;
    }

    @Override
    public int size() {
        BitSet ids = this.fileIds;
        TIntHashSet idSet = this.idSet;
        return (ids == null ? 0 : ids.cardinality()) + (idSet == null ? 0 : idSet.size()) + this.weirdFiles.size();
    }

    @Override
    @NotNull
    public Iterator<VirtualFile> iterator() {
        BitSet ids = this.fileIds;
        TIntHashSet idSet = this.idSet;
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        Iterator idsIterator = ids == null ? Collections.emptyIterator() : ContainerUtil.mapIterator(ids.stream().iterator(), id -> {
            ProgressManager.checkCanceled();
            return virtualFileManager.findFileById((int)id);
        });
        Iterator idSetIterator = idSet == null ? Collections.emptyIterator() : ContainerUtil.mapIterator(idSet.iterator(), id -> {
            ProgressManager.checkCanceled();
            return virtualFileManager.findFileById(id);
        });
        Iterator<VirtualFile> weirdFileIterator = this.weirdFiles.iterator();
        return new UnmodifiableIterator<VirtualFile>(ContainerUtil.filterIterator(ContainerUtil.concatIterators(idsIterator, idSetIterator, weirdFileIterator), Objects::nonNull));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vfs/CompactVirtualFileSet";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "add";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "process";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

