/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.psi.codeStyle.FixingLayoutMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.util.text.Matcher;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class WordPrefixMatcher
implements Matcher {
    private final String[] myPatternWords;
    private final String[] myFallbackPatternWords;

    public WordPrefixMatcher(String pattern) {
        this.myPatternWords = NameUtil.nameToWords(pattern);
        String fixedLayout = FixingLayoutMatcher.fixLayout(pattern);
        this.myFallbackPatternWords = fixedLayout != null && !fixedLayout.equals(pattern) ? NameUtil.nameToWords(fixedLayout) : null;
    }

    @Override
    public boolean matches(@NotNull String name) {
        String[] nameWords;
        if (name == null) {
            WordPrefixMatcher.$$$reportNull$$$0(0);
        }
        return WordPrefixMatcher.matches(this.myPatternWords, nameWords = NameUtil.nameToWords(name)) || this.myFallbackPatternWords != null && WordPrefixMatcher.matches(this.myFallbackPatternWords, nameWords);
    }

    private static boolean matches(String[] patternWords, String[] nameWords) {
        return Arrays.stream(patternWords).allMatch(pw -> Arrays.stream(nameWords).anyMatch(nw -> StringUtilRt.startsWithIgnoreCase(nw, pw)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/codeStyle/WordPrefixMatcher", "matches"));
    }
}

