/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.ClassLoweringPass;
import org.jetbrains.kotlin.backend.common.lower.InitializersLoweringBase;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import org.jetbrains.kotlin.backend.jvm.lower.ConstLoweringKt;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrElementBase;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.impl.IrBlockBodyImpl;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.load.java.JavaDescriptorVisibilities;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u00012\u00020\u0002:\u0001\fB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/StaticInitializersLowering;", "Lorg/jetbrains/kotlin/backend/common/lower/InitializersLoweringBase;", "Lorg/jetbrains/kotlin/backend/common/ClassLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "lower", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "Companion", "backend.jvm"})
public final class StaticInitializersLowering
extends InitializersLoweringBase
implements ClassLoweringPass {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JvmBackendContext context;
    @NotNull
    private static final Name clinitName;

    public StaticInitializersLowering(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        super(context2);
        this.context = context2;
    }

    @Override
    @NotNull
    public JvmBackendContext getContext() {
        return this.context;
    }

    @Override
    public void lower(@NotNull IrClass irClass2) {
        Intrinsics.checkNotNullParameter(irClass2, "irClass");
        List staticInitializerStatements2 = CollectionsKt.toMutableList((Collection)this.extractInitializers(irClass2, (Function1<? super IrDeclaration, Boolean>)new Function1<IrDeclaration, Boolean>(this){
            final /* synthetic */ StaticInitializersLowering this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final boolean invoke(@NotNull IrDeclaration it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return it instanceof IrField && ((IrField)it).isStatic() && ConstLoweringKt.constantValue((IrField)it, this.this$0.getContext()) == null || it instanceof IrAnonymousInitializer && ((IrAnonymousInitializer)it).isStatic();
            }
        }));
        Object object = staticInitializerStatements2;
        boolean bl = false;
        if (!object.isEmpty()) {
            List $this$sortBy$iv = staticInitializerStatements2;
            boolean $i$f$sortBy = false;
            if ($this$sortBy$iv.size() > 1) {
                boolean bl2 = false;
                CollectionsKt.sortWith($this$sortBy$iv, new Comparator<T>(){

                    public final int compare(T a, T b) {
                        IrDeclarationOrigin irDeclarationOrigin;
                        IrFieldSymbol irFieldSymbol;
                        boolean bl = false;
                        IrStatement it = (IrStatement)a;
                        boolean bl2 = false;
                        IrElementBase irElementBase = it instanceof IrSetField ? (IrSetField)it : null;
                        IrFieldSymbol irFieldSymbol2 = irFieldSymbol = irElementBase == null ? null : ((IrFieldAccessExpression)irElementBase).getSymbol();
                        IrDeclarationOrigin irDeclarationOrigin2 = irFieldSymbol == null ? null : (irDeclarationOrigin = (irElementBase = (IrField)irFieldSymbol.getOwner()) == null ? null : irElementBase.getOrigin());
                        it = (IrStatement)b;
                        Comparable comparable = Integer.valueOf(Intrinsics.areEqual(irDeclarationOrigin, JvmLoweredDeclarationOrigin.GENERATED_PROPERTY_REFERENCE.INSTANCE) ? 1 : (Intrinsics.areEqual(irDeclarationOrigin, IrDeclarationOrigin.FIELD_FOR_ENUM_ENTRY.INSTANCE) ? 2 : (Intrinsics.areEqual(irDeclarationOrigin, IrDeclarationOrigin.FIELD_FOR_ENUM_VALUES.INSTANCE) ? 3 : (Intrinsics.areEqual(irDeclarationOrigin, IrDeclarationOrigin.FIELD_FOR_OBJECT_INSTANCE.INSTANCE) ? 4 : 5))));
                        bl2 = false;
                        irElementBase = it instanceof IrSetField ? (IrSetField)it : null;
                        IrFieldSymbol irFieldSymbol3 = irFieldSymbol = irElementBase == null ? null : ((IrFieldAccessExpression)irElementBase).getSymbol();
                        IrDeclarationOrigin irDeclarationOrigin3 = irFieldSymbol == null ? null : (irDeclarationOrigin = (irElementBase = (IrField)irFieldSymbol.getOwner()) == null ? null : irElementBase.getOrigin());
                        Integer n = Intrinsics.areEqual(irDeclarationOrigin, JvmLoweredDeclarationOrigin.GENERATED_PROPERTY_REFERENCE.INSTANCE) ? 1 : (Intrinsics.areEqual(irDeclarationOrigin, IrDeclarationOrigin.FIELD_FOR_ENUM_ENTRY.INSTANCE) ? 2 : (Intrinsics.areEqual(irDeclarationOrigin, IrDeclarationOrigin.FIELD_FOR_ENUM_VALUES.INSTANCE) ? 3 : (Intrinsics.areEqual(irDeclarationOrigin, IrDeclarationOrigin.FIELD_FOR_OBJECT_INSTANCE.INSTANCE) ? 4 : 5)));
                        return ComparisonsKt.compareValues(comparable, (Comparable)n);
                    }
                });
            }
            IrClass $this$addFunction$iv = irClass2;
            boolean $i$f$addFunction = false;
            IrFactory $this$addFunction$iv$iv = $this$addFunction$iv.getFactory();
            boolean $i$f$addFunction2 = false;
            Object $this$buildFun$iv$iv$iv = $this$addFunction$iv$iv;
            boolean $i$f$buildFun = false;
            IrFunctionBuilder irFunctionBuilder = new IrFunctionBuilder();
            boolean bl3 = false;
            boolean bl4 = false;
            IrFunctionBuilder $this$buildFun_u24lambda_u2d14$iv$iv$iv = irFunctionBuilder;
            boolean bl5 = false;
            IrFunctionBuilder $this$lower_u24lambda_u2d1 = $this$buildFun_u24lambda_u2d14$iv$iv$iv;
            boolean bl6 = false;
            $this$lower_u24lambda_u2d1.setStartOffset(irClass2.getStartOffset());
            $this$lower_u24lambda_u2d1.setEndOffset(irClass2.getEndOffset());
            $this$lower_u24lambda_u2d1.setName(clinitName);
            $this$lower_u24lambda_u2d1.setOrigin(JvmLoweredDeclarationOrigin.CLASS_STATIC_INITIALIZER.INSTANCE);
            $this$lower_u24lambda_u2d1.setReturnType(this.getContext().getIrBuiltIns().getUnitType());
            DescriptorVisibility descriptorVisibility = JavaDescriptorVisibilities.PACKAGE_VISIBILITY;
            Intrinsics.checkNotNullExpressionValue(descriptorVisibility, "PACKAGE_VISIBILITY");
            $this$lower_u24lambda_u2d1.setVisibility(descriptorVisibility);
            $this$buildFun$iv$iv$iv = DeclarationBuildersKt.buildFunction((IrFactory)$this$buildFun$iv$iv$iv, $this$buildFun_u24lambda_u2d14$iv$iv$iv);
            boolean bl7 = false;
            boolean bl8 = false;
            Object function$iv$iv = $this$buildFun$iv$iv$iv;
            boolean bl9 = false;
            ((IrDeclarationContainer)$this$addFunction$iv).getDeclarations().add((IrDeclaration)function$iv$iv);
            function$iv$iv.setParent($this$addFunction$iv);
            object = $this$buildFun$iv$iv$iv;
            bl = false;
            boolean bl10 = false;
            Object $this$lower_u24lambda_u2d2 = object;
            boolean bl11 = false;
            ((IrFunction)$this$lower_u24lambda_u2d2).setBody((IrBody)PatchDeclarationParentsKt.patchDeclarationParents((IrElement)new IrBlockBodyImpl(irClass2.getStartOffset(), irClass2.getEndOffset(), staticInitializerStatements2), (IrDeclarationParent)$this$lower_u24lambda_u2d2));
        }
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        ClassLoweringPass.DefaultImpls.lower(this, irFile);
    }

    static {
        Name name = Name.special("<clinit>");
        Intrinsics.checkNotNullExpressionValue(name, "special(\"<clinit>\")");
        clinitName = name;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/StaticInitializersLowering$Companion;", "", "()V", "clinitName", "Lorg/jetbrains/kotlin/name/Name;", "getClinitName", "()Lorg/jetbrains/kotlin/name/Name;", "backend.jvm"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Name getClinitName() {
            return clinitName;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

