/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.build.report.metrics;

import java.util.EnumMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.build.report.metrics.BuildAttribute;
import org.jetbrains.kotlin.build.report.metrics.BuildAttributes;
import org.jetbrains.kotlin.build.report.metrics.BuildMetrics;
import org.jetbrains.kotlin.build.report.metrics.BuildMetricsReporter;
import org.jetbrains.kotlin.build.report.metrics.BuildTime;
import org.jetbrains.kotlin.build.report.metrics.BuildTimes;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u000f\u001a\u00020\f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\bH\u0016J\b\u0010\u0015\u001a\u00020\u0011H\u0016J\u0018\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/build/report/metrics/BuildMetricsReporterImpl;", "Lorg/jetbrains/kotlin/build/report/metrics/BuildMetricsReporter;", "()V", "myBuildAttributes", "Lorg/jetbrains/kotlin/build/report/metrics/BuildAttributes;", "myBuildTimeStartNs", "Ljava/util/EnumMap;", "Lorg/jetbrains/kotlin/build/report/metrics/BuildTime;", "", "myBuildTimes", "Lorg/jetbrains/kotlin/build/report/metrics/BuildTimes;", "addAttribute", "", "attribute", "Lorg/jetbrains/kotlin/build/report/metrics/BuildAttribute;", "addMetrics", "metrics", "Lorg/jetbrains/kotlin/build/report/metrics/BuildMetrics;", "endMeasure", "metric", "endNs", "getMetrics", "startMeasure", "startNs", "kotlin-build-common"})
public final class BuildMetricsReporterImpl
implements BuildMetricsReporter {
    @NotNull
    private final EnumMap<BuildTime, Long> myBuildTimeStartNs = new EnumMap(BuildTime.class);
    @NotNull
    private final BuildTimes myBuildTimes = new BuildTimes();
    @NotNull
    private final BuildAttributes myBuildAttributes = new BuildAttributes();

    @Override
    public void startMeasure(@NotNull BuildTime metric, long startNs) {
        Intrinsics.checkNotNullParameter(metric, "metric");
        Object object = this.myBuildTimeStartNs;
        boolean bl = false;
        Map map = object;
        boolean bl2 = false;
        if (map.containsKey(metric)) {
            object = metric + " was restarted before it finished";
            bl = false;
            throw (Throwable)new IllegalStateException(object.toString());
        }
        object = this.myBuildTimeStartNs;
        Long l = startNs;
        boolean bl3 = false;
        object.put(metric, l);
    }

    @Override
    public void endMeasure(@NotNull BuildTime metric, long endNs) {
        Intrinsics.checkNotNullParameter(metric, "metric");
        Long l = this.myBuildTimeStartNs.remove(metric);
        if (l == null) {
            String string2 = metric + " finished before it started";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        Long l2 = l;
        long startNs = ((Number)l2).longValue();
        long durationNs = endNs - startNs;
        this.myBuildTimes.add(metric, durationNs);
    }

    @Override
    public void addAttribute(@NotNull BuildAttribute attribute) {
        Intrinsics.checkNotNullParameter(attribute, "attribute");
        BuildAttributes.add$default(this.myBuildAttributes, attribute, 0, 2, null);
    }

    @Override
    @NotNull
    public BuildMetrics getMetrics() {
        return new BuildMetrics(this.myBuildTimes, this.myBuildAttributes);
    }

    @Override
    public void addMetrics(@Nullable BuildMetrics metrics) {
        if (metrics == null) {
            return;
        }
        this.myBuildAttributes.addAll(metrics.getBuildAttributes());
        this.myBuildTimes.addAll(metrics.getBuildTimes());
    }
}

