/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.collections.immutable.ExtensionsKt;
import kotlinx.collections.immutable.PersistentList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirLookupTrackerComponent;
import org.jetbrains.kotlin.fir.FirLookupTrackerComponentKt;
import org.jetbrains.kotlin.fir.FirRendererKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.extensions.FirExtensionServiceKt;
import org.jetbrains.kotlin.fir.extensions.FirPredicateBasedProvider;
import org.jetbrains.kotlin.fir.extensions.FirPredicateBasedProviderKt;
import org.jetbrains.kotlin.fir.extensions.FirSupertypeGenerationExtension;
import org.jetbrains.kotlin.fir.extensions.FirSupertypeGenerationExtensionKt;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.MainSessionComponentsKt;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraphBuilderKt;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeTypeParameterSupertype;
import org.jetbrains.kotlin.fir.resolve.providers.FirProvider;
import org.jetbrains.kotlin.fir.resolve.transformers.FirSpecificTypeResolverTransformer;
import org.jetbrains.kotlin.fir.resolve.transformers.FirSupertypesResolutionKt;
import org.jetbrains.kotlin.fir.resolve.transformers.SupertypeComputationSession;
import org.jetbrains.kotlin.fir.resolve.transformers.SupertypeComputationStatus;
import org.jetbrains.kotlin.fir.resolve.transformers.body.resolve.LocalClassesNavigationInfo;
import org.jetbrains.kotlin.fir.scopes.FirCompositeScope;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.scopes.ScopesKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.builder.FirErrorTypeRefBuilder;
import org.jetbrains.kotlin.fir.visitors.FirDefaultVisitor;
import org.jetbrains.kotlin.fir.visitors.FirTransformer;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001B;\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0010\b\u0002\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u000fJ\"\u0010\u0013\u001a\u00020\u00022\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0002J\u001a\u0010\u0019\u001a\f\u0012\u0004\u0012\u00020\f0\u000bj\u0002`\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u001e\u0010\u001d\u001a\f\u0012\u0004\u0012\u00020\f0\u000bj\u0002`\u001a2\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u001eH\u0002J\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\n\u0010 \u001a\u0006\u0012\u0002\b\u00030\u0015H\u0002J6\u0010!\u001a\u00020\u00022\n\u0010 \u001a\u0006\u0012\u0002\b\u00030\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\"0\u00112\u0012\b\u0002\u0010#\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00150$H\u0002J@\u0010%\u001a\b\u0012\u0004\u0012\u00020\"0\u00112\n\u0010 \u001a\u0006\u0012\u0002\b\u00030\u00152$\u0010&\u001a \u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0(\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u00110'H\u0002J&\u0010%\u001a\b\u0012\u0004\u0012\u00020\"0\u00112\n\u0010 \u001a\u0006\u0012\u0002\b\u00030\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\"0\u0011J\u001a\u0010)\u001a\u00020\u00022\u0006\u0010*\u001a\u00020+2\b\u0010,\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010-\u001a\u00020\u00022\u0006\u0010.\u001a\u00020/2\b\u0010,\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u00100\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010,\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u00101\u001a\u00020\u00022\u0006\u00102\u001a\u0002032\b\u0010,\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u00104\u001a\u00020\u00022\u0006\u00105\u001a\u0002062\b\u0010,\u001a\u0004\u0018\u00010\u0003H\u0016J\u001e\u00107\u001a\b\u0012\u0004\u0012\u0002H80\u0011\"\u0004\b\u0000\u00108*\b\u0012\u0004\u0012\u0002H80\u0011H\u0002J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\"0\u0011*\u0006\u0012\u0002\b\u00030\u0015H\u0002R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirSupertypeResolverVisitor;", "Lorg/jetbrains/kotlin/fir/visitors/FirDefaultVisitor;", "", "", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "supertypeComputationSession", "Lorg/jetbrains/kotlin/fir/resolve/transformers/SupertypeComputationSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "scopeForLocalClass", "Lkotlinx/collections/immutable/PersistentList;", "Lorg/jetbrains/kotlin/fir/scopes/FirScope;", "localClassesNavigationInfo", "Lorg/jetbrains/kotlin/fir/resolve/transformers/body/resolve/LocalClassesNavigationInfo;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/transformers/SupertypeComputationSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;Lkotlinx/collections/immutable/PersistentList;Lorg/jetbrains/kotlin/fir/resolve/transformers/body/resolve/LocalClassesNavigationInfo;)V", "supertypeGenerationExtensions", "", "Lorg/jetbrains/kotlin/fir/extensions/FirSupertypeGenerationExtension;", "addSupertypesFromExtensions", "klass", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "supertypeRefs", "", "Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;", "prepareFileScopes", "Lorg/jetbrains/kotlin/fir/resolve/transformers/ScopePersistentList;", "file", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "prepareScopeForNestedClasses", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "prepareScopes", "classLikeDeclaration", "resolveAllSupertypes", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "visited", "", "resolveSpecificClassLikeSupertypes", "resolveSuperTypeRefs", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/fir/visitors/FirTransformer;", "visitAnonymousObject", "anonymousObject", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousObject;", "data", "visitElement", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "visitFile", "visitRegularClass", "regularClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "visitTypeAlias", "typeAlias", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "createCopy", "T", "resolve"})
final class FirSupertypeResolverVisitor
extends FirDefaultVisitor<Unit, Object> {
    @NotNull
    private final FirSession session;
    @NotNull
    private final SupertypeComputationSession supertypeComputationSession;
    @NotNull
    private final ScopeSession scopeSession;
    @Nullable
    private final PersistentList<FirScope> scopeForLocalClass;
    @Nullable
    private final LocalClassesNavigationInfo localClassesNavigationInfo;
    @NotNull
    private final List<FirSupertypeGenerationExtension> supertypeGenerationExtensions;

    public FirSupertypeResolverVisitor(@NotNull FirSession session2, @NotNull SupertypeComputationSession supertypeComputationSession, @NotNull ScopeSession scopeSession, @Nullable PersistentList<? extends FirScope> scopeForLocalClass, @Nullable LocalClassesNavigationInfo localClassesNavigationInfo) {
        Intrinsics.checkNotNullParameter(session2, "session");
        Intrinsics.checkNotNullParameter(supertypeComputationSession, "supertypeComputationSession");
        Intrinsics.checkNotNullParameter(scopeSession, "scopeSession");
        this.session = session2;
        this.supertypeComputationSession = supertypeComputationSession;
        this.scopeSession = scopeSession;
        this.scopeForLocalClass = scopeForLocalClass;
        this.localClassesNavigationInfo = localClassesNavigationInfo;
        this.supertypeGenerationExtensions = FirSupertypeGenerationExtensionKt.getSupertypeGenerators(FirExtensionServiceKt.getExtensionService(this.session));
    }

    public /* synthetic */ FirSupertypeResolverVisitor(FirSession firSession, SupertypeComputationSession supertypeComputationSession, ScopeSession scopeSession, PersistentList persistentList, LocalClassesNavigationInfo localClassesNavigationInfo, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            persistentList = null;
        }
        if ((n & 0x10) != 0) {
            localClassesNavigationInfo = null;
        }
        this(firSession, supertypeComputationSession, scopeSession, persistentList, localClassesNavigationInfo);
    }

    @Override
    public void visitElement(@NotNull FirElement element, @Nullable Object data) {
        Intrinsics.checkNotNullParameter(element, "element");
    }

    private final PersistentList<FirScope> prepareFileScopes(FirFile file2) {
        return this.supertypeComputationSession.getOrPutFileScope(file2, (Function0<? extends PersistentList<? extends FirScope>>)new Function0<PersistentList<? extends FirScope>>(file2, this){
            final /* synthetic */ FirFile $file;
            final /* synthetic */ FirSupertypeResolverVisitor this$0;
            {
                this.$file = $file;
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final PersistentList<FirScope> invoke() {
                return ExtensionsKt.toPersistentList((Iterable)CollectionsKt.asReversed(ScopesKt.createImportingScopes$default(this.$file, FirSupertypeResolverVisitor.access$getSession$p(this.this$0), FirSupertypeResolverVisitor.access$getScopeSession$p(this.this$0), false, 8, null)));
            }
        });
    }

    private final PersistentList<FirScope> prepareScopeForNestedClasses(FirClass<?> klass) {
        return this.supertypeComputationSession.getOrPutScopeForNestedClasses(klass, (Function0<? extends PersistentList<? extends FirScope>>)new Function0<PersistentList<? extends FirScope>>(this, klass){
            final /* synthetic */ FirSupertypeResolverVisitor this$0;
            final /* synthetic */ FirClass<?> $klass;
            {
                this.this$0 = $receiver;
                this.$klass = $klass;
                super(0);
            }

            @NotNull
            public final PersistentList<FirScope> invoke() {
                PersistentList scopes = FirSupertypeResolverVisitor.access$prepareScopes(this.this$0, this.$klass);
                FirSupertypeResolverVisitor.resolveAllSupertypes$default(this.this$0, this.$klass, this.$klass.getSuperTypeRefs(), null, 4, null);
                return FirSupertypesResolutionKt.access$pushAll(scopes, FirSupertypesResolutionKt.access$createScopesForNestedClasses(this.$klass, FirSupertypeResolverVisitor.access$getSession$p(this.this$0), FirSupertypeResolverVisitor.access$getScopeSession$p(this.this$0), FirSupertypeResolverVisitor.access$getSupertypeComputationSession$p(this.this$0)));
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void resolveAllSupertypes(FirClassLikeDeclaration<?> classLikeDeclaration, List<? extends FirTypeRef> supertypeRefs, Set<FirClassLikeDeclaration<?>> visited2) {
        void $this$mapTo$iv$iv;
        if (!visited2.add(classLikeDeclaration)) {
            return;
        }
        Iterable $this$map$iv = this.resolveSpecificClassLikeSupertypes(classLikeDeclaration, supertypeRefs);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FirTypeRef firTypeRef = (FirTypeRef)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ConeKotlinType coneKotlinType = FirTypeUtilsKt.getConeType((FirTypeRef)it);
            collection.add(coneKotlinType);
        }
        List supertypes2 = (List)destination$iv$iv;
        for (ConeKotlinType supertype2 : supertypes2) {
            FirClassLikeDeclaration<?> firClassLikeDeclaration;
            if (!(supertype2 instanceof ConeClassLikeType) || (firClassLikeDeclaration = MainSessionComponentsKt.getFirProvider(this.session).getFirClassifierByFqName(((ConeClassLikeType)supertype2).getLookupTag().getClassId())) == null) continue;
            FirClassLikeDeclaration<?> fir = firClassLikeDeclaration;
            this.resolveAllSupertypes(fir, this.supertypeRefs(fir), visited2);
        }
    }

    static /* synthetic */ void resolveAllSupertypes$default(FirSupertypeResolverVisitor firSupertypeResolverVisitor, FirClassLikeDeclaration firClassLikeDeclaration, List list2, Set set, int n, Object object) {
        if ((n & 4) != 0) {
            boolean bl = false;
            set = new LinkedHashSet();
        }
        firSupertypeResolverVisitor.resolveAllSupertypes(firClassLikeDeclaration, list2, set);
    }

    private final List<FirTypeRef> supertypeRefs(FirClassLikeDeclaration<?> $this$supertypeRefs) {
        FirClassLikeDeclaration<?> firClassLikeDeclaration = $this$supertypeRefs;
        return firClassLikeDeclaration instanceof FirRegularClass ? ((FirRegularClass)$this$supertypeRefs).getSuperTypeRefs() : (firClassLikeDeclaration instanceof FirTypeAlias ? CollectionsKt.listOf(((FirTypeAlias)$this$supertypeRefs).getExpandedTypeRef()) : CollectionsKt.emptyList());
    }

    private final PersistentList<FirScope> prepareScopes(FirClassLikeDeclaration<?> classLikeDeclaration) {
        PersistentList<FirScope> persistentList;
        PersistentList<FirScope> persistentList2;
        ClassId classId = classLikeDeclaration.getSymbol().getClassId();
        if (classId.isLocal()) {
            if (this.localClassesNavigationInfo == null) {
                return ExtensionsKt.persistentListOf();
            }
            FirClassLikeDeclaration<?> parent2 = this.localClassesNavigationInfo.getParentForClass().get(classLikeDeclaration);
            if (parent2 != null && parent2 instanceof FirClass) {
                persistentList2 = this.prepareScopeForNestedClasses((FirClass)parent2);
            } else {
                persistentList = this.scopeForLocalClass;
                if (persistentList == null) {
                    return ExtensionsKt.persistentListOf();
                }
                persistentList2 = persistentList;
            }
        } else if (classId.isNestedClass()) {
            Object object;
            ClassId classId2 = classId.getOuterClassId();
            if (classId2 == null) {
                object = null;
            } else {
                ClassId classId3 = classId2;
                FirProvider firProvider = MainSessionComponentsKt.getFirProvider(this.session);
                boolean bl = false;
                boolean bl2 = false;
                ClassId p0 = classId3;
                boolean bl3 = false;
                object = firProvider.getFirClassifierByFqName(p0);
            }
            persistentList = object;
            FirRegularClass outerClassFir = persistentList instanceof FirRegularClass ? (FirRegularClass)((Object)persistentList) : null;
            persistentList = outerClassFir;
            if (persistentList == null) {
                return ExtensionsKt.persistentListOf();
            }
            persistentList2 = this.prepareScopeForNestedClasses((FirClass)((Object)persistentList));
        } else {
            persistentList2 = this.prepareFileScopes(MainSessionComponentsKt.getFirProvider(this.session).getFirClassifierContainerFile(classLikeDeclaration.getSymbol()));
        }
        PersistentList<FirScope> result2 = persistentList2;
        return FirSupertypesResolutionKt.access$pushIfNotNull(result2, FirSupertypesResolutionKt.access$typeParametersScope(classLikeDeclaration));
    }

    private final List<FirTypeRef> resolveSpecificClassLikeSupertypes(FirClassLikeDeclaration<?> classLikeDeclaration, Function2<? super FirTransformer<? super FirScope>, ? super FirScope, ? extends List<? extends FirResolvedTypeRef>> resolveSuperTypeRefs) {
        SupertypeComputationStatus status2 = this.supertypeComputationSession.getSupertypesComputationStatus(classLikeDeclaration);
        if (status2 instanceof SupertypeComputationStatus.Computed) {
            return ((SupertypeComputationStatus.Computed)status2).getSupertypeRefs();
        }
        if (status2 instanceof SupertypeComputationStatus.Computing) {
            return CollectionsKt.listOf(FirSupertypesResolutionKt.access$createErrorTypeRef(classLikeDeclaration, Intrinsics.stringPlus("Loop in supertype definition for ", classLikeDeclaration.getSymbol().getClassId())));
        }
        this.supertypeComputationSession.startComputingSupertypes(classLikeDeclaration);
        PersistentList<FirScope> scopes = this.prepareScopes(classLikeDeclaration);
        FirSpecificTypeResolverTransformer transformer2 = new FirSpecificTypeResolverTransformer(this.session, false, 2, null);
        List<FirTypeRef> resolvedTypesRefs = resolveSuperTypeRefs.invoke(transformer2, new FirCompositeScope((Iterable<? extends FirScope>)scopes));
        this.supertypeComputationSession.storeSupertypes(classLikeDeclaration, resolvedTypesRefs);
        return resolvedTypesRefs;
    }

    @Override
    public void visitRegularClass(@NotNull FirRegularClass regularClass, @Nullable Object data) {
        Intrinsics.checkNotNullParameter(regularClass, "regularClass");
        this.resolveSpecificClassLikeSupertypes((FirClassLikeDeclaration)regularClass, regularClass.getSuperTypeRefs());
        regularClass.acceptChildren(this, null);
    }

    @Override
    public void visitAnonymousObject(@NotNull FirAnonymousObject anonymousObject, @Nullable Object data) {
        Intrinsics.checkNotNullParameter(anonymousObject, "anonymousObject");
        this.resolveSpecificClassLikeSupertypes((FirClassLikeDeclaration)anonymousObject, anonymousObject.getSuperTypeRefs());
        anonymousObject.acceptChildren(this, null);
    }

    @NotNull
    public final List<FirTypeRef> resolveSpecificClassLikeSupertypes(@NotNull FirClassLikeDeclaration<?> classLikeDeclaration, @NotNull List<? extends FirTypeRef> supertypeRefs) {
        Intrinsics.checkNotNullParameter(classLikeDeclaration, "classLikeDeclaration");
        Intrinsics.checkNotNullParameter(supertypeRefs, "supertypeRefs");
        return this.resolveSpecificClassLikeSupertypes(classLikeDeclaration, (Function2<? super FirTransformer<? super FirScope>, ? super FirScope, ? extends List<? extends FirResolvedTypeRef>>)new Function2<FirTransformer<? super FirScope>, FirScope, List<? extends FirResolvedTypeRef>>(classLikeDeclaration, this, supertypeRefs){
            final /* synthetic */ FirClassLikeDeclaration<?> $classLikeDeclaration;
            final /* synthetic */ FirSupertypeResolverVisitor this$0;
            final /* synthetic */ List<FirTypeRef> $supertypeRefs;
            {
                this.$classLikeDeclaration = $classLikeDeclaration;
                this.this$0 = $receiver;
                this.$supertypeRefs = $supertypeRefs;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<FirResolvedTypeRef> invoke(@NotNull FirTransformer<? super FirScope> transformer2, @NotNull FirScope scope2) {
                void destination$iv;
                void $this$mapTo$iv;
                Object object;
                Intrinsics.checkNotNullParameter(transformer2, "transformer");
                Intrinsics.checkNotNullParameter(scope2, "scope");
                if (!ControlFlowGraphBuilderKt.isLocalClassOrAnonymousObject(this.$classLikeDeclaration) && (object = FirLookupTrackerComponentKt.getLookupTracker(FirSupertypeResolverVisitor.access$getSession$p(this.this$0))) != null) {
                    Object object2 = object;
                    FirSupertypeResolverVisitor firSupertypeResolverVisitor = this.this$0;
                    FirClassLikeDeclaration<?> firClassLikeDeclaration = this.$classLikeDeclaration;
                    List<FirTypeRef> list2 = this.$supertypeRefs;
                    boolean bl = false;
                    boolean bl2 = false;
                    Object it = object2;
                    boolean bl3 = false;
                    FirSourceElement fileSource = MainSessionComponentsKt.getFirProvider(FirSupertypeResolverVisitor.access$getSession$p(firSupertypeResolverVisitor)).getFirClassifierContainerFile(firClassLikeDeclaration.getSymbol()).getSource();
                    for (FirTypeRef supertypeRef : list2) {
                        FirLookupTrackerComponentKt.recordTypeLookup((FirLookupTrackerComponent)it, supertypeRef, scope2.getScopeOwnerLookupNames(), fileSource);
                    }
                }
                object = FirSupertypeResolverVisitor.access$createCopy(this.this$0, this.$supertypeRefs);
                boolean bl = false;
                Object object3 = new ArrayList<E>();
                boolean $i$f$mapTo = false;
                for (E item$iv : $this$mapTo$iv) {
                    FirResolvedTypeRef firResolvedTypeRef;
                    void it;
                    FirTypeRef superTypeRef;
                    FirTypeRef firTypeRef = (FirTypeRef)item$iv;
                    void var18_33 = destination$iv;
                    boolean bl4 = false;
                    FirTypeRef $this$coneTypeSafe$iv = superTypeRef = transformer2.transformTypeRef((FirTypeRef)it, scope2);
                    boolean $i$f$coneTypeSafe = false;
                    boolean bl5 = false;
                    FirResolvedTypeRef firResolvedTypeRef2 = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
                    ConeKotlinType coneKotlinType = firResolvedTypeRef2 == null ? null : firResolvedTypeRef2.getType();
                    if (!(coneKotlinType instanceof ConeTypeParameterType)) {
                        coneKotlinType = null;
                    }
                    ConeTypeParameterType typeParameterType = (ConeTypeParameterType)((ConeKotlinType)((ConeTypeParameterType)coneKotlinType));
                    if (typeParameterType != null) {
                        boolean $i$f$buildErrorTypeRef = false;
                        boolean bl6 = false;
                        FirErrorTypeRefBuilder firErrorTypeRefBuilder = new FirErrorTypeRefBuilder();
                        boolean bl7 = false;
                        boolean bl8 = false;
                        FirErrorTypeRefBuilder $this$invoke_u24lambda_u2d2_u24lambda_u2d1 = firErrorTypeRefBuilder;
                        boolean bl9 = false;
                        $this$invoke_u24lambda_u2d2_u24lambda_u2d1.setSource(superTypeRef.getSource());
                        $this$invoke_u24lambda_u2d2_u24lambda_u2d1.setDiagnostic(new ConeTypeParameterSupertype(typeParameterType.getLookupTag().getTypeParameterSymbol()));
                        firResolvedTypeRef = firErrorTypeRefBuilder.build();
                    } else {
                        firResolvedTypeRef = !(superTypeRef instanceof FirResolvedTypeRef) ? (FirResolvedTypeRef)FirSupertypesResolutionKt.access$createErrorTypeRef(superTypeRef, Intrinsics.stringPlus("Unresolved super-type: ", FirRendererKt.render$default(superTypeRef, null, 1, null))) : (FirResolvedTypeRef)superTypeRef;
                    }
                    FirResolvedTypeRef firResolvedTypeRef3 = firResolvedTypeRef;
                    var18_33.add(firResolvedTypeRef3);
                }
                object = destination$iv;
                object3 = this.this$0;
                FirClassLikeDeclaration<?> firClassLikeDeclaration = this.$classLikeDeclaration;
                boolean bl10 = false;
                boolean bl11 = false;
                List it = (List)object;
                boolean bl12 = false;
                FirSupertypeResolverVisitor.access$addSupertypesFromExtensions((FirSupertypeResolverVisitor)object3, firClassLikeDeclaration, it);
                return (List)object;
            }
        });
    }

    private final <T> List<T> createCopy(List<? extends T> $this$createCopy) {
        return new ArrayList($this$createCopy);
    }

    private final void addSupertypesFromExtensions(FirClassLikeDeclaration<?> klass, List<FirResolvedTypeRef> supertypeRefs) {
        if (this.supertypeGenerationExtensions.isEmpty()) {
            return;
        }
        FirPredicateBasedProvider provider = FirPredicateBasedProviderKt.getPredicateBasedProvider(this.session);
        for (FirSupertypeGenerationExtension extension : this.supertypeGenerationExtensions) {
            if (!provider.matches(extension.getPredicate(), klass)) continue;
            Collection collection = supertypeRefs;
            Iterable iterable = extension.computeAdditionalSupertypes(klass, supertypeRefs);
            boolean bl = false;
            CollectionsKt.addAll(collection, iterable);
        }
    }

    @Override
    public void visitTypeAlias(@NotNull FirTypeAlias typeAlias, @Nullable Object data) {
        Intrinsics.checkNotNullParameter(typeAlias, "typeAlias");
        if (typeAlias.getExpandedTypeRef() instanceof FirResolvedTypeRef) {
            return;
        }
        this.resolveSpecificClassLikeSupertypes((FirClassLikeDeclaration)typeAlias, (Function2<? super FirTransformer<? super FirScope>, ? super FirScope, ? extends List<? extends FirResolvedTypeRef>>)new Function2<FirTransformer<? super FirScope>, FirScope, List<? extends FirResolvedTypeRef>>(typeAlias, this){
            final /* synthetic */ FirTypeAlias $typeAlias;
            final /* synthetic */ FirSupertypeResolverVisitor this$0;
            {
                this.$typeAlias = $typeAlias;
                this.this$0 = $receiver;
                super(2);
            }

            @NotNull
            public final List<FirResolvedTypeRef> invoke(@NotNull FirTransformer<? super FirScope> transformer2, @NotNull FirScope scope2) {
                FirResolvedTypeRef firResolvedTypeRef;
                Intrinsics.checkNotNullParameter(transformer2, "transformer");
                Intrinsics.checkNotNullParameter(scope2, "scope");
                FirTypeRef firTypeRef = transformer2.transformTypeRef(this.$typeAlias.getExpandedTypeRef(), scope2);
                FirResolvedTypeRef firResolvedTypeRef2 = firResolvedTypeRef = firTypeRef instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)firTypeRef : null;
                if (firResolvedTypeRef == null) {
                    return CollectionsKt.listOf(FirSupertypesResolutionKt.access$createErrorTypeRef(this.$typeAlias.getExpandedTypeRef(), Intrinsics.stringPlus("Unresolved expanded typeRef for ", this.$typeAlias.getSymbol().getClassId())));
                }
                FirResolvedTypeRef resolvedTypeRef = firResolvedTypeRef;
                ConeKotlinType type2 = resolvedTypeRef.getType();
                if (type2 instanceof ConeClassLikeType) {
                    FirTypeAlias expansionTypeAlias;
                    FirTypeAlias firTypeAlias;
                    FirClassLikeSymbol<?> firClassLikeSymbol = LookupTagUtilsKt.toSymbol(((ConeClassLikeType)type2).getLookupTag(), FirSupertypeResolverVisitor.access$getSession$p(this.this$0));
                    if (firClassLikeSymbol == null) {
                        firTypeAlias = null;
                    } else {
                        FirTypeAliasSymbol firTypeAliasSymbol;
                        FirClassLikeSymbol<?> $this$safeAs$iv = firClassLikeSymbol;
                        boolean $i$f$safeAs = false;
                        FirClassLikeSymbol<?> firClassLikeSymbol2 = $this$safeAs$iv;
                        if (!(firClassLikeSymbol2 instanceof FirTypeAliasSymbol)) {
                            firClassLikeSymbol2 = null;
                        }
                        firTypeAlias = expansionTypeAlias = (firTypeAliasSymbol = (FirTypeAliasSymbol)firClassLikeSymbol2) == null ? null : (FirTypeAlias)firTypeAliasSymbol.getFir();
                    }
                    if (expansionTypeAlias != null) {
                        this.this$0.visitTypeAlias(expansionTypeAlias, (Object)null);
                    }
                }
                return CollectionsKt.listOf(resolvedTypeRef);
            }
        });
    }

    @Override
    public void visitFile(@NotNull FirFile file2, @Nullable Object data) {
        Intrinsics.checkNotNullParameter(file2, "file");
        file2.acceptChildren(this, null);
    }

    public static final /* synthetic */ FirSession access$getSession$p(FirSupertypeResolverVisitor $this) {
        return $this.session;
    }

    public static final /* synthetic */ ScopeSession access$getScopeSession$p(FirSupertypeResolverVisitor $this) {
        return $this.scopeSession;
    }

    public static final /* synthetic */ PersistentList access$prepareScopes(FirSupertypeResolverVisitor $this, FirClassLikeDeclaration classLikeDeclaration) {
        return $this.prepareScopes(classLikeDeclaration);
    }

    public static final /* synthetic */ SupertypeComputationSession access$getSupertypeComputationSession$p(FirSupertypeResolverVisitor $this) {
        return $this.supertypeComputationSession;
    }

    public static final /* synthetic */ List access$createCopy(FirSupertypeResolverVisitor $this, List $receiver) {
        return $this.createCopy($receiver);
    }

    public static final /* synthetic */ void access$addSupertypesFromExtensions(FirSupertypeResolverVisitor $this, FirClassLikeDeclaration klass, List supertypeRefs) {
        $this.addSupertypesFromExtensions(klass, supertypeRefs);
    }
}

