/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.config.KotlinCompilerVersion;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.serialization.deserialization.DeserializationConfiguration;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0010\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0014\u0010\n\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\bR\u0014\u0010\f\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\bR\u0014\u0010\u000e\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\bR\u0014\u0010\u0010\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\bR\u0014\u0010\u0012\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\bR\u0014\u0010\u0014\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\b\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/resolve/CompilerDeserializationConfiguration;", "Lorg/jetbrains/kotlin/serialization/deserialization/DeserializationConfiguration;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "(Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "allowUnstableDependencies", "", "getAllowUnstableDependencies", "()Z", "isJvmPackageNameSupported", "readDeserializedContracts", "getReadDeserializedContracts", "releaseCoroutines", "getReleaseCoroutines", "reportErrorsOnPreReleaseDependencies", "getReportErrorsOnPreReleaseDependencies", "skipMetadataVersionCheck", "getSkipMetadataVersionCheck", "skipPrereleaseCheck", "getSkipPrereleaseCheck", "typeAliasesAllowed", "getTypeAliasesAllowed", "frontend"})
public final class CompilerDeserializationConfiguration
implements DeserializationConfiguration {
    private final boolean skipMetadataVersionCheck;
    private final boolean skipPrereleaseCheck;
    private final boolean reportErrorsOnPreReleaseDependencies;
    private final boolean allowUnstableDependencies;
    private final boolean typeAliasesAllowed;
    private final boolean isJvmPackageNameSupported;
    private final boolean readDeserializedContracts;
    private final boolean releaseCoroutines;

    public CompilerDeserializationConfiguration(@NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        this.skipMetadataVersionCheck = languageVersionSettings.getFlag(AnalysisFlags.INSTANCE.getSkipMetadataVersionCheck());
        this.skipPrereleaseCheck = languageVersionSettings.getFlag(AnalysisFlags.INSTANCE.getSkipPrereleaseCheck());
        this.reportErrorsOnPreReleaseDependencies = !this.getSkipPrereleaseCheck() && !languageVersionSettings.isPreRelease() && !KotlinCompilerVersion.isPreRelease();
        this.allowUnstableDependencies = languageVersionSettings.getFlag(AnalysisFlags.INSTANCE.getAllowUnstableDependencies());
        this.typeAliasesAllowed = languageVersionSettings.supportsFeature(LanguageFeature.TypeAliases);
        this.isJvmPackageNameSupported = languageVersionSettings.supportsFeature(LanguageFeature.JvmPackageName);
        this.readDeserializedContracts = languageVersionSettings.supportsFeature(LanguageFeature.ReadDeserializedContracts);
        this.releaseCoroutines = languageVersionSettings.supportsFeature(LanguageFeature.ReleaseCoroutines);
    }

    @Override
    public boolean getSkipMetadataVersionCheck() {
        return this.skipMetadataVersionCheck;
    }

    @Override
    public boolean getSkipPrereleaseCheck() {
        return this.skipPrereleaseCheck;
    }

    @Override
    public boolean getReportErrorsOnPreReleaseDependencies() {
        return this.reportErrorsOnPreReleaseDependencies;
    }

    @Override
    public boolean getAllowUnstableDependencies() {
        return this.allowUnstableDependencies;
    }

    @Override
    public boolean getTypeAliasesAllowed() {
        return this.typeAliasesAllowed;
    }

    @Override
    public boolean isJvmPackageNameSupported() {
        return this.isJvmPackageNameSupported;
    }

    @Override
    public boolean getReadDeserializedContracts() {
        return this.readDeserializedContracts;
    }

    @Override
    public boolean getReleaseCoroutines() {
        return this.releaseCoroutines;
    }

    @Override
    public boolean getPreserveDeclarationsOrdering() {
        return DeserializationConfiguration.DefaultImpls.getPreserveDeclarationsOrdering(this);
    }
}

