/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.diagnostics;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtStubbedPsiUtil;
import org.jetbrains.kotlin.resolve.constants.ArrayValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.StringValue;
import org.jetbrains.kotlin.resolve.diagnostics.DiagnosticSuppressor;
import org.jetbrains.kotlin.util.ExtensionProvider;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b&\u0018\u0000 -2\u00020\u0001:\b-./01234B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u000eH\u0002J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0013\u001a\u00020\u000eH\u0002J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u0013\u001a\u00020\u000eH&J\u001e\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u001fJ\u0010\u0010\u001a\u001a\u00020\t2\u0006\u0010 \u001a\u00020!H\u0002J(\u0010\"\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020$H\u0002J\u0018\u0010%\u001a\u00020\t2\u0006\u0010&\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\bH\u0014J\u001e\u0010(\u001a\u00020)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00160+2\u0006\u0010,\u001a\u00020\u0019H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR/\u0010\f\u001a#\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u00100\u00100\r\u00a2\u0006\u0002\b\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lorg/jetbrains/kotlin/resolve/diagnostics/KotlinSuppressCache;", "", "()V", "diagnosticSuppressors", "Lorg/jetbrains/kotlin/util/ExtensionProvider;", "Lorg/jetbrains/kotlin/resolve/diagnostics/DiagnosticSuppressor;", "filter", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "", "getFilter", "()Lkotlin/jvm/functions/Function1;", "suppressors", "Ljava/util/concurrent/ConcurrentMap;", "Lorg/jetbrains/kotlin/psi/KtAnnotated;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/kotlin/resolve/diagnostics/KotlinSuppressCache$Suppressor;", "Lorg/jetbrains/annotations/NotNull;", "getOrCreateSuppressor", "annotated", "getSuppressingStrings", "", "", "getSuppressionAnnotations", "", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "isSuppressed", "psiElement", "Lcom/intellij/psi/PsiElement;", "suppressionKey", "severity", "Lorg/jetbrains/kotlin/diagnostics/Severity;", "request", "Lorg/jetbrains/kotlin/resolve/diagnostics/KotlinSuppressCache$SuppressRequest;", "isSuppressedByAnnotated", "debugDepth", "", "isSuppressedByExtension", "suppressor", "diagnostic", "processAnnotation", "", "builder", "Lcom/google/common/collect/ImmutableSet$Builder;", "annotationDescriptor", "Companion", "DiagnosticSuppressRequest", "EmptySuppressor", "MultiSuppressor", "SingularSuppressor", "StringSuppressRequest", "SuppressRequest", "Suppressor", "frontend"})
public abstract class KotlinSuppressCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExtensionProvider<DiagnosticSuppressor> diagnosticSuppressors = ExtensionProvider.Companion.create(DiagnosticSuppressor.Companion.getEP_NAME());
    @NotNull
    private final ConcurrentMap<KtAnnotated, Suppressor> suppressors;
    @NotNull
    private final Function1<Diagnostic, Boolean> filter;

    public KotlinSuppressCache() {
        ConcurrentMap concurrentMap = ContainerUtil.createConcurrentWeakValueMap();
        Intrinsics.checkNotNullExpressionValue(concurrentMap, "createConcurrentWeakValueMap<KtAnnotated, Suppressor>()");
        this.suppressors = concurrentMap;
        this.filter = new Function1<Diagnostic, Boolean>(this){
            final /* synthetic */ KotlinSuppressCache this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final boolean invoke(@NotNull Diagnostic diagnostic) {
                Intrinsics.checkNotNullParameter(diagnostic, "diagnostic");
                return !KotlinSuppressCache.access$isSuppressed(this.this$0, new DiagnosticSuppressRequest(diagnostic));
            }
        };
    }

    @NotNull
    public final Function1<Diagnostic, Boolean> getFilter() {
        return this.filter;
    }

    public final boolean isSuppressed(@NotNull PsiElement psiElement, @NotNull String suppressionKey, @NotNull Severity severity) {
        Intrinsics.checkNotNullParameter(psiElement, "psiElement");
        Intrinsics.checkNotNullParameter(suppressionKey, "suppressionKey");
        Intrinsics.checkNotNullParameter((Object)severity, "severity");
        String string2 = suppressionKey;
        boolean bl = false;
        String string3 = string2.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string3, "(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
        return this.isSuppressed(new StringSuppressRequest(psiElement, severity, string3));
    }

    private final boolean isSuppressed(SuppressRequest request) {
        KtAnnotated ktAnnotated;
        KtAnnotated ktAnnotated2;
        PsiElement element = request.getElement();
        if (!element.isValid()) {
            return true;
        }
        PsiFile file2 = element.getContainingFile();
        if (file2 instanceof KtFile && KtPsiFactoryKt.getDoNotAnalyze((KtFile)file2) != null) {
            return true;
        }
        if (request instanceof DiagnosticSuppressRequest) {
            for (DiagnosticSuppressor suppressor : (List)this.diagnosticSuppressors.get()) {
                if (!this.isSuppressedByExtension(suppressor, ((DiagnosticSuppressRequest)request).getDiagnostic())) continue;
                return true;
            }
        }
        if ((ktAnnotated2 = KtStubbedPsiUtil.getPsiOrStubParent(element, KtAnnotated.class, false)) == null) {
            return false;
        }
        KtAnnotated annotated = ktAnnotated = ktAnnotated2;
        return this.isSuppressedByAnnotated(request.getSuppressKey(), request.getSeverity(), annotated, 0);
    }

    protected boolean isSuppressedByExtension(@NotNull DiagnosticSuppressor suppressor, @NotNull Diagnostic diagnostic) {
        Intrinsics.checkNotNullParameter(suppressor, "suppressor");
        Intrinsics.checkNotNullParameter(diagnostic, "diagnostic");
        return suppressor.isSuppressed(diagnostic);
    }

    private final boolean isSuppressedByAnnotated(String suppressionKey, Severity severity, KtAnnotated annotated, int debugDepth) {
        KtAnnotated ktAnnotated;
        Suppressor suppressor = this.getOrCreateSuppressor(annotated);
        if (suppressor.isSuppressed(suppressionKey, severity)) {
            return true;
        }
        KtAnnotated ktAnnotated2 = KtStubbedPsiUtil.getPsiOrStubParent(suppressor.getAnnotatedElement(), KtAnnotated.class, true);
        if (ktAnnotated2 == null) {
            return false;
        }
        KtAnnotated annotatedAbove = ktAnnotated = ktAnnotated2;
        boolean suppressed = this.isSuppressedByAnnotated(suppressionKey, severity, annotatedAbove, debugDepth + 1);
        Suppressor suppressorAbove = (Suppressor)this.suppressors.get(annotatedAbove);
        if (suppressorAbove != null && suppressorAbove.dominates(suppressor)) {
            Map map = this.suppressors;
            boolean bl = false;
            map.put(annotated, suppressorAbove);
        }
        return suppressed;
    }

    private final Suppressor getOrCreateSuppressor(KtAnnotated annotated) {
        ConcurrentMap<KtAnnotated, Suppressor> $this$getOrPut$iv = this.suppressors;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(annotated);
        if (object == null) {
            Suppressor suppressor;
            boolean bl = false;
            Set<String> strings2 = this.getSuppressingStrings(annotated);
            int n = strings2.size();
            switch (n) {
                case 0: {
                    suppressor = new EmptySuppressor(annotated);
                    break;
                }
                case 1: {
                    suppressor = new SingularSuppressor(annotated, (String)CollectionsKt.first((Iterable)strings2));
                    break;
                }
                default: {
                    suppressor = new MultiSuppressor(annotated, strings2);
                }
            }
            Suppressor suppressor2 = suppressor;
            boolean bl2 = false;
            boolean bl3 = false;
            Suppressor default$iv = suppressor2;
            boolean bl4 = false;
            object = $this$getOrPut$iv.putIfAbsent(annotated, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        Object v = object;
        Intrinsics.checkNotNullExpressionValue(v, "suppressors.getOrPut(annotated) {\n            val strings = getSuppressingStrings(annotated)\n            when (strings.size) {\n                0 -> EmptySuppressor(annotated)\n                1 -> SingularSuppressor(annotated, strings.first())\n                else -> MultiSuppressor(annotated, strings)\n            }\n        }");
        return (Suppressor)v;
    }

    @NotNull
    public abstract List<AnnotationDescriptor> getSuppressionAnnotations(@NotNull KtAnnotated var1);

    private final Set<String> getSuppressingStrings(KtAnnotated annotated) {
        ImmutableSet.Builder<String> builder2 = ImmutableSet.builder();
        for (AnnotationDescriptor annotationDescriptor : this.getSuppressionAnnotations(annotated)) {
            Intrinsics.checkNotNullExpressionValue(builder2, "builder");
            this.processAnnotation(builder2, annotationDescriptor);
        }
        ImmutableCollection immutableCollection = builder2.build();
        Intrinsics.checkNotNullExpressionValue(immutableCollection, "builder.build()");
        return (Set)((Object)immutableCollection);
    }

    private final void processAnnotation(ImmutableSet.Builder<String> builder2, AnnotationDescriptor annotationDescriptor) {
        if (!Intrinsics.areEqual(annotationDescriptor.getFqName(), StandardNames.FqNames.suppress)) {
            return;
        }
        for (ConstantValue<?> arrayValue : annotationDescriptor.getAllValueArguments().values()) {
            if (!(arrayValue instanceof ArrayValue)) continue;
            for (ConstantValue value2 : (List)((ArrayValue)arrayValue).getValue()) {
                if (!(value2 instanceof StringValue)) continue;
                String string2 = (String)((StringValue)value2).getValue();
                boolean bl = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string3.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string4, "(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
                builder2.add((Object)string4);
            }
        }
    }

    public static final /* synthetic */ boolean access$isSuppressed(KotlinSuppressCache $this, SuppressRequest request) {
        return $this.isSuppressed(request);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J&\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/resolve/diagnostics/KotlinSuppressCache$Companion;", "", "()V", "getDiagnosticSuppressKey", "", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "isSuppressedByStrings", "", "key", "strings", "", "severity", "Lorg/jetbrains/kotlin/diagnostics/Severity;", "frontend"})
    public static final class Companion {
        private Companion() {
        }

        private final String getDiagnosticSuppressKey(Diagnostic diagnostic) {
            String string2 = diagnostic.getFactory().getName();
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string4, "(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
            return string4;
        }

        private final boolean isSuppressedByStrings(String key, Set<String> strings2, Severity severity) {
            return severity == Severity.WARNING && strings2.contains("warnings") || strings2.contains(key);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\"\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0000H&J\u0018\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH&J\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/resolve/diagnostics/KotlinSuppressCache$Suppressor;", "", "annotatedElement", "Lorg/jetbrains/kotlin/psi/KtAnnotated;", "(Lorg/jetbrains/kotlin/psi/KtAnnotated;)V", "getAnnotatedElement", "()Lorg/jetbrains/kotlin/psi/KtAnnotated;", "dominates", "", "other", "isSuppressed", "suppressionKey", "", "severity", "Lorg/jetbrains/kotlin/diagnostics/Severity;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "frontend"})
    private static abstract class Suppressor {
        @NotNull
        private final KtAnnotated annotatedElement;

        public Suppressor(@NotNull KtAnnotated annotatedElement) {
            Intrinsics.checkNotNullParameter(annotatedElement, "annotatedElement");
            this.annotatedElement = annotatedElement;
        }

        @NotNull
        public final KtAnnotated getAnnotatedElement() {
            return this.annotatedElement;
        }

        public boolean isSuppressed(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkNotNullParameter(diagnostic, "diagnostic");
            return this.isSuppressed(Companion.getDiagnosticSuppressKey(diagnostic), diagnostic.getSeverity());
        }

        public abstract boolean isSuppressed(@NotNull String var1, @NotNull Severity var2);

        public abstract boolean dominates(@NotNull Suppressor var1);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0001H\u0016J\u0018\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\b\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/resolve/diagnostics/KotlinSuppressCache$EmptySuppressor;", "Lorg/jetbrains/kotlin/resolve/diagnostics/KotlinSuppressCache$Suppressor;", "annotated", "Lorg/jetbrains/kotlin/psi/KtAnnotated;", "(Lorg/jetbrains/kotlin/psi/KtAnnotated;)V", "dominates", "", "other", "isSuppressed", "suppressionKey", "", "severity", "Lorg/jetbrains/kotlin/diagnostics/Severity;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "frontend"})
    private static final class EmptySuppressor
    extends Suppressor {
        public EmptySuppressor(@NotNull KtAnnotated annotated) {
            Intrinsics.checkNotNullParameter(annotated, "annotated");
            super(annotated);
        }

        @Override
        public boolean isSuppressed(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkNotNullParameter(diagnostic, "diagnostic");
            return false;
        }

        @Override
        public boolean isSuppressed(@NotNull String suppressionKey, @NotNull Severity severity) {
            Intrinsics.checkNotNullParameter(suppressionKey, "suppressionKey");
            Intrinsics.checkNotNullParameter((Object)severity, "severity");
            return false;
        }

        @Override
        public boolean dominates(@NotNull Suppressor other) {
            Intrinsics.checkNotNullParameter(other, "other");
            return other instanceof EmptySuppressor;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0001H\u0016J\u0018\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/resolve/diagnostics/KotlinSuppressCache$SingularSuppressor;", "Lorg/jetbrains/kotlin/resolve/diagnostics/KotlinSuppressCache$Suppressor;", "annotated", "Lorg/jetbrains/kotlin/psi/KtAnnotated;", "string", "", "(Lorg/jetbrains/kotlin/psi/KtAnnotated;Ljava/lang/String;)V", "dominates", "", "other", "isSuppressed", "suppressionKey", "severity", "Lorg/jetbrains/kotlin/diagnostics/Severity;", "frontend"})
    private static final class SingularSuppressor
    extends Suppressor {
        @NotNull
        private final String string;

        public SingularSuppressor(@NotNull KtAnnotated annotated, @NotNull String string2) {
            Intrinsics.checkNotNullParameter(annotated, "annotated");
            Intrinsics.checkNotNullParameter(string2, "string");
            super(annotated);
            this.string = string2;
        }

        @Override
        public boolean isSuppressed(@NotNull String suppressionKey, @NotNull Severity severity) {
            Intrinsics.checkNotNullParameter(suppressionKey, "suppressionKey");
            Intrinsics.checkNotNullParameter((Object)severity, "severity");
            ImmutableSet<String> immutableSet = ImmutableSet.of(this.string);
            Intrinsics.checkNotNullExpressionValue(immutableSet, "of(string)");
            return Companion.isSuppressedByStrings(suppressionKey, immutableSet, severity);
        }

        @Override
        public boolean dominates(@NotNull Suppressor other) {
            Intrinsics.checkNotNullParameter(other, "other");
            return other instanceof EmptySuppressor || other instanceof SingularSuppressor && Intrinsics.areEqual(((SingularSuppressor)other).string, this.string);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0001H\u0016J\u0018\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/resolve/diagnostics/KotlinSuppressCache$MultiSuppressor;", "Lorg/jetbrains/kotlin/resolve/diagnostics/KotlinSuppressCache$Suppressor;", "annotated", "Lorg/jetbrains/kotlin/psi/KtAnnotated;", "strings", "", "", "(Lorg/jetbrains/kotlin/psi/KtAnnotated;Ljava/util/Set;)V", "dominates", "", "other", "isSuppressed", "suppressionKey", "severity", "Lorg/jetbrains/kotlin/diagnostics/Severity;", "frontend"})
    private static final class MultiSuppressor
    extends Suppressor {
        @NotNull
        private final Set<String> strings;

        public MultiSuppressor(@NotNull KtAnnotated annotated, @NotNull Set<String> strings2) {
            Intrinsics.checkNotNullParameter(annotated, "annotated");
            Intrinsics.checkNotNullParameter(strings2, "strings");
            super(annotated);
            this.strings = strings2;
        }

        @Override
        public boolean isSuppressed(@NotNull String suppressionKey, @NotNull Severity severity) {
            Intrinsics.checkNotNullParameter(suppressionKey, "suppressionKey");
            Intrinsics.checkNotNullParameter((Object)severity, "severity");
            return Companion.isSuppressedByStrings(suppressionKey, this.strings, severity);
        }

        @Override
        public boolean dominates(@NotNull Suppressor other) {
            Intrinsics.checkNotNullParameter(other, "other");
            return other instanceof EmptySuppressor;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\bb\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/resolve/diagnostics/KotlinSuppressCache$SuppressRequest;", "", "element", "Lcom/intellij/psi/PsiElement;", "getElement", "()Lcom/intellij/psi/PsiElement;", "severity", "Lorg/jetbrains/kotlin/diagnostics/Severity;", "getSeverity", "()Lorg/jetbrains/kotlin/diagnostics/Severity;", "suppressKey", "", "getSuppressKey", "()Ljava/lang/String;", "frontend"})
    private static interface SuppressRequest {
        @NotNull
        public PsiElement getElement();

        @NotNull
        public Severity getSeverity();

        @NotNull
        public String getSuppressKey();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/resolve/diagnostics/KotlinSuppressCache$StringSuppressRequest;", "Lorg/jetbrains/kotlin/resolve/diagnostics/KotlinSuppressCache$SuppressRequest;", "element", "Lcom/intellij/psi/PsiElement;", "severity", "Lorg/jetbrains/kotlin/diagnostics/Severity;", "suppressKey", "", "(Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/diagnostics/Severity;Ljava/lang/String;)V", "getElement", "()Lcom/intellij/psi/PsiElement;", "getSeverity", "()Lorg/jetbrains/kotlin/diagnostics/Severity;", "getSuppressKey", "()Ljava/lang/String;", "frontend"})
    private static final class StringSuppressRequest
    implements SuppressRequest {
        @NotNull
        private final PsiElement element;
        @NotNull
        private final Severity severity;
        @NotNull
        private final String suppressKey;

        public StringSuppressRequest(@NotNull PsiElement element, @NotNull Severity severity, @NotNull String suppressKey) {
            Intrinsics.checkNotNullParameter(element, "element");
            Intrinsics.checkNotNullParameter((Object)severity, "severity");
            Intrinsics.checkNotNullParameter(suppressKey, "suppressKey");
            this.element = element;
            this.severity = severity;
            this.suppressKey = suppressKey;
        }

        @Override
        @NotNull
        public PsiElement getElement() {
            return this.element;
        }

        @Override
        @NotNull
        public Severity getSeverity() {
            return this.severity;
        }

        @Override
        @NotNull
        public String getSuppressKey() {
            return this.suppressKey;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/resolve/diagnostics/KotlinSuppressCache$DiagnosticSuppressRequest;", "Lorg/jetbrains/kotlin/resolve/diagnostics/KotlinSuppressCache$SuppressRequest;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "(Lorg/jetbrains/kotlin/diagnostics/Diagnostic;)V", "getDiagnostic", "()Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "element", "Lcom/intellij/psi/PsiElement;", "getElement", "()Lcom/intellij/psi/PsiElement;", "severity", "Lorg/jetbrains/kotlin/diagnostics/Severity;", "getSeverity", "()Lorg/jetbrains/kotlin/diagnostics/Severity;", "suppressKey", "", "getSuppressKey", "()Ljava/lang/String;", "frontend"})
    private static final class DiagnosticSuppressRequest
    implements SuppressRequest {
        @NotNull
        private final Diagnostic diagnostic;

        public DiagnosticSuppressRequest(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkNotNullParameter(diagnostic, "diagnostic");
            this.diagnostic = diagnostic;
        }

        @NotNull
        public final Diagnostic getDiagnostic() {
            return this.diagnostic;
        }

        @Override
        @NotNull
        public PsiElement getElement() {
            return this.diagnostic.getPsiElement();
        }

        @Override
        @NotNull
        public Severity getSeverity() {
            return this.diagnostic.getSeverity();
        }

        @Override
        @NotNull
        public String getSuppressKey() {
            return Companion.getDiagnosticSuppressKey(this.diagnostic);
        }
    }
}

