/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types.checker;

import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.types.AbstractTypeCheckerContext;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructorSubstitution;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitutor;
import kotlin.reflect.jvm.internal.impl.types.UnwrappedType;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.checker.ClassicTypeCheckerContextKt;
import kotlin.reflect.jvm.internal.impl.types.checker.ClassicTypeSystemContext;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypePreparator;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeRefiner;
import kotlin.reflect.jvm.internal.impl.types.checker.NewTypeVariableConstructor;
import kotlin.reflect.jvm.internal.impl.types.checker.SimpleClassicTypeSystemContext;
import kotlin.reflect.jvm.internal.impl.types.model.KotlinTypeMarker;
import kotlin.reflect.jvm.internal.impl.types.model.SimpleTypeMarker;
import org.jetbrains.annotations.NotNull;

public class ClassicTypeCheckerContext
extends AbstractTypeCheckerContext {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean errorTypeEqualsToAnything;
    private final boolean stubTypeEqualsToAnything;
    private final boolean allowedTypeVariable;
    @NotNull
    private final KotlinTypeRefiner kotlinTypeRefiner;
    @NotNull
    private final KotlinTypePreparator kotlinTypePreparator;
    @NotNull
    private final ClassicTypeSystemContext typeSystemContext;

    public ClassicTypeCheckerContext(boolean errorTypeEqualsToAnything, boolean stubTypeEqualsToAnything, boolean allowedTypeVariable, @NotNull KotlinTypeRefiner kotlinTypeRefiner, @NotNull KotlinTypePreparator kotlinTypePreparator, @NotNull ClassicTypeSystemContext typeSystemContext) {
        Intrinsics.checkNotNullParameter((Object)kotlinTypeRefiner, (String)"kotlinTypeRefiner");
        Intrinsics.checkNotNullParameter((Object)kotlinTypePreparator, (String)"kotlinTypePreparator");
        Intrinsics.checkNotNullParameter((Object)typeSystemContext, (String)"typeSystemContext");
        this.errorTypeEqualsToAnything = errorTypeEqualsToAnything;
        this.stubTypeEqualsToAnything = stubTypeEqualsToAnything;
        this.allowedTypeVariable = allowedTypeVariable;
        this.kotlinTypeRefiner = kotlinTypeRefiner;
        this.kotlinTypePreparator = kotlinTypePreparator;
        this.typeSystemContext = typeSystemContext;
    }

    public /* synthetic */ ClassicTypeCheckerContext(boolean bl, boolean bl2, boolean bl3, KotlinTypeRefiner kotlinTypeRefiner, KotlinTypePreparator kotlinTypePreparator, ClassicTypeSystemContext classicTypeSystemContext, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl2 = true;
        }
        if ((n & 4) != 0) {
            bl3 = true;
        }
        if ((n & 8) != 0) {
            kotlinTypeRefiner = KotlinTypeRefiner.Default.INSTANCE;
        }
        if ((n & 0x10) != 0) {
            kotlinTypePreparator = KotlinTypePreparator.Default.INSTANCE;
        }
        if ((n & 0x20) != 0) {
            classicTypeSystemContext = SimpleClassicTypeSystemContext.INSTANCE;
        }
        this(bl, bl2, bl3, kotlinTypeRefiner, kotlinTypePreparator, classicTypeSystemContext);
    }

    @Override
    @NotNull
    public ClassicTypeSystemContext getTypeSystemContext() {
        return this.typeSystemContext;
    }

    @Override
    @NotNull
    public KotlinTypeMarker refineType(@NotNull KotlinTypeMarker type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        boolean bl = type2 instanceof KotlinType;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = ClassicTypeCheckerContextKt.access$errorMessage(type2);
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return this.kotlinTypeRefiner.refineType((KotlinType)type2);
    }

    @Override
    @NotNull
    public KotlinTypeMarker prepareType(@NotNull KotlinTypeMarker type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        boolean bl = type2 instanceof KotlinType;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = ClassicTypeCheckerContextKt.access$errorMessage(type2);
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return this.kotlinTypePreparator.prepareType(((KotlinType)type2).unwrap());
    }

    @Override
    public boolean isErrorTypeEqualsToAnything() {
        return this.errorTypeEqualsToAnything;
    }

    @Override
    public boolean isStubTypeEqualsToAnything() {
        return this.stubTypeEqualsToAnything;
    }

    @Override
    @NotNull
    public AbstractTypeCheckerContext.SupertypesPolicy.DoCustomTransform substitutionSupertypePolicy(@NotNull SimpleTypeMarker type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        return Companion.classicSubstitutionSupertypePolicy(this.getTypeSystemContext(), type2);
    }

    @Override
    public boolean isAllowedTypeVariable(@NotNull KotlinTypeMarker $this$isAllowedTypeVariable) {
        Intrinsics.checkNotNullParameter((Object)$this$isAllowedTypeVariable, (String)"<this>");
        return $this$isAllowedTypeVariable instanceof UnwrappedType && this.allowedTypeVariable && ((UnwrappedType)$this$isAllowedTypeVariable).getConstructor() instanceof NewTypeVariableConstructor;
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AbstractTypeCheckerContext.SupertypesPolicy.DoCustomTransform classicSubstitutionSupertypePolicy(@NotNull ClassicTypeSystemContext $this$classicSubstitutionSupertypePolicy, @NotNull SimpleTypeMarker type2) {
            Intrinsics.checkNotNullParameter((Object)$this$classicSubstitutionSupertypePolicy, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            boolean bl = type2 instanceof SimpleType;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = ClassicTypeCheckerContextKt.access$errorMessage(type2);
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            TypeSubstitutor substitutor = TypeConstructorSubstitution.Companion.create((KotlinType)((Object)type2)).buildSubstitutor();
            return new AbstractTypeCheckerContext.SupertypesPolicy.DoCustomTransform($this$classicSubstitutionSupertypePolicy, substitutor){
                final /* synthetic */ ClassicTypeSystemContext $this_classicSubstitutionSupertypePolicy;
                final /* synthetic */ TypeSubstitutor $substitutor;
                {
                    this.$this_classicSubstitutionSupertypePolicy = $receiver;
                    this.$substitutor = $substitutor;
                }

                @NotNull
                public SimpleTypeMarker transformType(@NotNull AbstractTypeCheckerContext context, @NotNull KotlinTypeMarker type2) {
                    Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                    Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
                    KotlinType kotlinType = this.$substitutor.safeSubstitute((KotlinType)((Object)this.$this_classicSubstitutionSupertypePolicy.lowerBoundIfFlexible(type2)), Variance.INVARIANT);
                    Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"substitutor.safeSubstitute(\n                        type.lowerBoundIfFlexible() as KotlinType,\n                        Variance.INVARIANT\n                    )");
                    SimpleTypeMarker simpleTypeMarker = this.$this_classicSubstitutionSupertypePolicy.asSimpleType(kotlinType);
                    Intrinsics.checkNotNull((Object)simpleTypeMarker);
                    return simpleTypeMarker;
                }
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

