/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.extremity;

import java.awt.geom.Point2D;
import net.sourceforge.plantuml.svek.extremity.Extremity;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColorUtils;

class ExtremityStateLine2
extends Extremity {
    private UPolygon polygon = new UPolygon();
    private final Point2D dest;
    private final double radius = 5.0;
    private final double angle;

    @Override
    public Point2D somePoint() {
        return this.dest;
    }

    public ExtremityStateLine2(double angle, Point2D center) {
        this.angle = this.manageround(angle);
        this.polygon.addPoint(0.0, 0.0);
        this.dest = new Point2D.Double(center.getX(), center.getY());
        int xWing = 9;
        int yAperture = 4;
        this.polygon.addPoint(-9.0, -4.0);
        int xContact = 5;
        this.polygon.addPoint(-5.0, 0.0);
        this.polygon.addPoint(-9.0, 4.0);
        this.polygon.addPoint(0.0, 0.0);
        this.polygon.rotate(this.angle);
        this.polygon = this.polygon.translate(center.getX(), center.getY());
    }

    @Override
    public void drawU(UGraphic ug) {
        ug.apply(ug.getParam().getColor().bg()).apply(new UTranslate(-5.0 * Math.cos(this.angle), -5.0 * Math.sin(this.angle))).draw(this.polygon);
        ug.apply(new UStroke(1.5)).apply(HColorUtils.WHITE.bg()).apply(new UTranslate(this.dest.getX() - 5.0, this.dest.getY() - 5.0)).draw(new UEllipse(10.0, 10.0));
    }
}

