from typing import Any, Text

class TemplateError(Exception):
    def __init__(self, message: Text | None = ...) -> None: ...
    @property
    def message(self): ...
    def __unicode__(self): ...

class TemplateNotFound(IOError, LookupError, TemplateError):
    message: Any
    name: Any
    templates: Any
    def __init__(self, name, message: Text | None = ...) -> None: ...

class TemplatesNotFound(TemplateNotFound):
    templates: Any
    def __init__(self, names: Any = ..., message: Text | None = ...) -> None: ...

class TemplateSyntaxError(TemplateError):
    lineno: int
    name: Text
    filename: Text
    source: Text
    translated: bool
    def __init__(self, message: Text, lineno: int, name: Text | None = ..., filename: Text | None = ...) -> None: ...

class TemplateAssertionError(TemplateSyntaxError): ...
class TemplateRuntimeError(TemplateError): ...
class UndefinedError(TemplateRuntimeError): ...
class SecurityError(TemplateRuntimeError): ...
class FilterArgumentError(TemplateRuntimeError): ...
