/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal.objects;

import com.google.inject.Injector;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.testng.ITestContext;
import org.testng.annotations.Guice;
import org.testng.internal.annotations.AnnotationHelper;
import org.testng.internal.objects.GuiceHelper;
import org.testng.internal.objects.IObjectDispenser;
import org.testng.internal.objects.pojo.BasicAttributes;
import org.testng.internal.objects.pojo.CreationAttributes;

class GuiceBasedObjectDispenser
implements IObjectDispenser {
    private IObjectDispenser dispenser;
    private static final Map<Integer, GuiceHelper> helpers = new ConcurrentHashMap<Integer, GuiceHelper>();

    GuiceBasedObjectDispenser() {
    }

    @Override
    public void setNextDispenser(IObjectDispenser dispenser) {
        this.dispenser = dispenser;
    }

    @Override
    public Object dispense(CreationAttributes attributes) {
        if (attributes.getBasicAttributes() != null) {
            BasicAttributes sa = attributes.getBasicAttributes();
            if (GuiceBasedObjectDispenser.cannotDispense(sa.getTestClass().getRealClass())) {
                return this.dispenser.dispense(attributes);
            }
            ITestContext ctx = attributes.getContext();
            GuiceHelper helper = helpers.computeIfAbsent(ctx.hashCode(), k -> new GuiceHelper(ctx));
            Injector injector = helper.getInjector(sa.getTestClass(), ctx.getInjectorFactory());
            if (injector == null) {
                return null;
            }
            if (sa.getRawClass() == null) {
                return injector.getInstance(sa.getTestClass().getRealClass());
            }
            return injector.getInstance(sa.getRawClass());
        }
        return this.dispenser.dispense(attributes);
    }

    private static boolean cannotDispense(Class<?> clazz) {
        return AnnotationHelper.findAnnotationSuperClasses(Guice.class, clazz) == null;
    }
}

