/*
 * Decompiled with CFR 0.152.
 */
package jnr.unixsocket.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import jnr.constants.platform.Errno;
import jnr.enxio.channels.Native;
import jnr.enxio.channels.NativeException;

final class Common {
    private int _fd = -1;

    Common(int fd) {
        this._fd = fd;
    }

    void setFD(int fd) {
        this._fd = fd;
    }

    int getFD() {
        return this._fd;
    }

    int read(ByteBuffer dst) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(dst.remaining());
        int n = Native.read(this._fd, buffer);
        buffer.flip();
        dst.put(buffer);
        switch (n) {
            case 0: {
                return -1;
            }
            case -1: {
                Errno lastError = Native.getLastError();
                switch (lastError) {
                    case EAGAIN: 
                    case EWOULDBLOCK: {
                        return 0;
                    }
                }
                throw new NativeException(Native.getLastErrorString(), lastError);
            }
        }
        return n;
    }

    long read(ByteBuffer[] dsts, int offset2, int length2) throws IOException {
        long total2 = 0L;
        for (int i2 = 0; i2 < length2; ++i2) {
            ByteBuffer dst = dsts[offset2 + i2];
            long read2 = this.read(dst);
            if (read2 == -1L) {
                return read2;
            }
            total2 += read2;
        }
        return total2;
    }

    int write(ByteBuffer src) throws IOException {
        int r = src.remaining();
        ByteBuffer buffer = ByteBuffer.allocate(r);
        buffer.put(src);
        buffer.position(0);
        int n = Native.write(this._fd, buffer);
        if (n >= 0) {
            if (n < r) {
                src.position(src.position() - (r - n));
            }
        } else {
            Errno lastError = Native.getLastError();
            switch (lastError) {
                case EAGAIN: 
                case EWOULDBLOCK: {
                    src.position(src.position() - r);
                    return 0;
                }
            }
            throw new NativeException(Native.getLastErrorString(), lastError);
        }
        return n;
    }

    long write(ByteBuffer[] srcs, int offset2, int length2) throws IOException {
        long result2 = 0L;
        for (int index2 = offset2; index2 < length2; ++index2) {
            int w;
            ByteBuffer buffer = srcs[index2];
            int remaining = buffer.remaining();
            int written = 0;
            while ((w = this.write(buffer)) != 0 && (written += w) != remaining) {
            }
            result2 += (long)written;
            if (written < remaining) break;
        }
        return result2;
    }
}

