/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.buf;

import java.io.Serializable;
import org.apache.tomcat.util.res.StringManager;

public abstract class AbstractChunk
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    protected static final StringManager sm = StringManager.getManager(AbstractChunk.class);
    public static final int ARRAY_MAX_SIZE = 0x7FFFFFF7;
    private int hashCode = 0;
    protected boolean hasHashCode = false;
    protected boolean isSet;
    private int limit = -1;
    protected int start;
    protected int end;

    public void setLimit(int n) {
        this.limit = n;
    }

    public int getLimit() {
        return this.limit;
    }

    protected int getLimitInternal() {
        if (this.limit > 0) {
            return this.limit;
        }
        return 0x7FFFFFF7;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public void setEnd(int n) {
        this.end = n;
    }

    public int getOffset() {
        return this.start;
    }

    public void setOffset(int n) {
        if (this.end < n) {
            this.end = n;
        }
        this.start = n;
    }

    public int getLength() {
        return this.end - this.start;
    }

    public boolean isNull() {
        if (this.end > 0) {
            return false;
        }
        return !this.isSet;
    }

    public int indexOf(String string, int n, int n2, int n3) {
        char c = string.charAt(n);
        int n4 = n + n2;
        block0: for (int i = n3 + this.start; i <= this.end - n2; ++i) {
            if (this.getBufferElement(i) != c) continue;
            int n5 = i + 1;
            int n6 = n + 1;
            while (n6 < n4) {
                if (this.getBufferElement(n5++) == string.charAt(n6++)) continue;
                continue block0;
            }
            return i - this.start;
        }
        return -1;
    }

    public void recycle() {
        this.hasHashCode = false;
        this.isSet = false;
        this.start = 0;
        this.end = 0;
    }

    public int hashCode() {
        if (this.hasHashCode) {
            return this.hashCode;
        }
        int n = 0;
        this.hashCode = n = this.hash();
        this.hasHashCode = true;
        return n;
    }

    public int hash() {
        int n = 0;
        for (int i = this.start; i < this.end; ++i) {
            n = n * 37 + this.getBufferElement(i);
        }
        return n;
    }

    protected abstract int getBufferElement(int var1);
}

