// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from LPC15xx_v0.7.svd, see https://github.com/posborne/cmsis-svd/tree/master/data/NXP

// +build nxp,lpc15xx

// LPC15xx Cortex-M3 MCU; up to 64 kB flash; up to 12 kB SRAM; USB device; USART; EEPROM
//

package nxp

import (
	"runtime/interrupt"
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	Device       = "LPC15xx"
	CPU          = "CM3"
	FPUPresent   = false
	NVICPrioBits = 3
)

// Interrupt numbers.
const (
	// Windowed Watchdog Timer (WWDT)
	IRQ_WDT = 0

	// System configuration (SYSCON)
	IRQ_BOD_IRQ = 1

	// Flash controller
	IRQ_FLASH = 2

	// Flash controller
	IRQ_EE = 3

	// DMA controller
	IRQ_DMA = 4

	// Group interrupt 0/1 (GINT0/1)
	IRQ_GINT0 = 5

	// GINT1
	IRQ_GINT1 = 6

	// Pin interrupt and pattern match (PINT)
	IRQ_PIN_INT0 = 7

	// Pin interrupt and pattern match (PINT)
	IRQ_PIN_INT1 = 8

	// Pin interrupt and pattern match (PINT)
	IRQ_PIN_INT2 = 9

	// Pin interrupt and pattern match (PINT)
	IRQ_PIN_INT3 = 10

	// Pin interrupt and pattern match (PINT)
	IRQ_PIN_INT4 = 11

	// Pin interrupt and pattern match (PINT)
	IRQ_PIN_INT5 = 12

	// Pin interrupt and pattern match (PINT)
	IRQ_PIN_INT6 = 13

	// Pin interrupt and pattern match (PINT)
	IRQ_PIN_INT7 = 14

	// Repetitive Interrupt Timer (RIT)
	IRQ_RIT = 15

	// Large State Configurable Timers 0/1 (SCT0/1)
	IRQ_SCT0 = 16

	// SCT1
	IRQ_SCT1 = 17

	// Small State Configurable Timers 2/3 (SCT2/3)
	IRQ_SCT2 = 18

	// SCT3
	IRQ_SCT3 = 19

	// Multi-Rate Timer (MRT)
	IRQ_MRT = 20

	// USART0
	IRQ_UART0 = 21

	// USART1
	IRQ_UART1 = 22

	// USART2
	IRQ_UART2 = 23

	// I2C-bus interface
	IRQ_I2C0 = 24

	// SPI0
	IRQ_SPI0 = 25

	// SPI1
	IRQ_SPI1 = 26

	// Controller Area Network C_CAN0
	IRQ_C_CAN0 = 27

	// USB device controller
	IRQ_USB_IRQ = 28

	// USB device controller
	IRQ_USB_FIQ = 29

	// USB device controller
	IRQ_USBWAKEUP = 30

	// 12-bit ADC controller ADC0/1
	IRQ_ADC0_SEQA = 31

	// 12-bit ADC controller ADC0/1
	IRQ_ADC0_SEQB = 32

	// 12-bit ADC controller ADC0/1
	IRQ_ADC0_THCMP = 33

	// 12-bit ADC controller ADC0/1
	IRQ_ADC0_OVR = 34

	// ADC1
	IRQ_ADC1_SEQA = 35

	// ADC1
	IRQ_ADC1_SEQB = 36

	// ADC1
	IRQ_ADC1_THCMP = 37

	// ADC1
	IRQ_ADC1_OVR = 38

	// 12-bit DAC Modification
	IRQ_DAC = 39

	// Analog comparators ACMP0/1/2/3
	IRQ_CMP0 = 40

	// Analog comparators ACMP0/1/2/3
	IRQ_CMP1 = 41

	// Analog comparators ACMP0/1/2/3
	IRQ_CMP2 = 42

	// Analog comparators ACMP0/1/2/3
	IRQ_CMP3 = 43

	// Quadrature Encoder Interface (QEI)
	IRQ_QEI = 44

	// Real-Time Clock (RTC)
	IRQ_RTC_ALARM = 45

	// Real-Time Clock (RTC)
	IRQ_RTC_WAKE = 46

	// Highest interrupt number on this device.
	IRQ_max = 46
)

// Map interrupt numbers to function names.
// These aren't real calls, they're removed by the compiler.
var (
	_ = interrupt.Register(IRQ_WDT, "WDT_IRQHandler")
	_ = interrupt.Register(IRQ_BOD_IRQ, "BOD_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_FLASH, "FLASH_IRQHandler")
	_ = interrupt.Register(IRQ_EE, "EE_IRQHandler")
	_ = interrupt.Register(IRQ_DMA, "DMA_IRQHandler")
	_ = interrupt.Register(IRQ_GINT0, "GINT0_IRQHandler")
	_ = interrupt.Register(IRQ_GINT1, "GINT1_IRQHandler")
	_ = interrupt.Register(IRQ_PIN_INT0, "PIN_INT0_IRQHandler")
	_ = interrupt.Register(IRQ_PIN_INT1, "PIN_INT1_IRQHandler")
	_ = interrupt.Register(IRQ_PIN_INT2, "PIN_INT2_IRQHandler")
	_ = interrupt.Register(IRQ_PIN_INT3, "PIN_INT3_IRQHandler")
	_ = interrupt.Register(IRQ_PIN_INT4, "PIN_INT4_IRQHandler")
	_ = interrupt.Register(IRQ_PIN_INT5, "PIN_INT5_IRQHandler")
	_ = interrupt.Register(IRQ_PIN_INT6, "PIN_INT6_IRQHandler")
	_ = interrupt.Register(IRQ_PIN_INT7, "PIN_INT7_IRQHandler")
	_ = interrupt.Register(IRQ_RIT, "RIT_IRQHandler")
	_ = interrupt.Register(IRQ_SCT0, "SCT0_IRQHandler")
	_ = interrupt.Register(IRQ_SCT1, "SCT1_IRQHandler")
	_ = interrupt.Register(IRQ_SCT2, "SCT2_IRQHandler")
	_ = interrupt.Register(IRQ_SCT3, "SCT3_IRQHandler")
	_ = interrupt.Register(IRQ_MRT, "MRT_IRQHandler")
	_ = interrupt.Register(IRQ_UART0, "UART0_IRQHandler")
	_ = interrupt.Register(IRQ_UART1, "UART1_IRQHandler")
	_ = interrupt.Register(IRQ_UART2, "UART2_IRQHandler")
	_ = interrupt.Register(IRQ_I2C0, "I2C0_IRQHandler")
	_ = interrupt.Register(IRQ_SPI0, "SPI0_IRQHandler")
	_ = interrupt.Register(IRQ_SPI1, "SPI1_IRQHandler")
	_ = interrupt.Register(IRQ_C_CAN0, "C_CAN0_IRQHandler")
	_ = interrupt.Register(IRQ_USB_IRQ, "USB_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_USB_FIQ, "USB_FIQ_IRQHandler")
	_ = interrupt.Register(IRQ_USBWAKEUP, "USBWAKEUP_IRQHandler")
	_ = interrupt.Register(IRQ_ADC0_SEQA, "ADC0_SEQA_IRQHandler")
	_ = interrupt.Register(IRQ_ADC0_SEQB, "ADC0_SEQB_IRQHandler")
	_ = interrupt.Register(IRQ_ADC0_THCMP, "ADC0_THCMP_IRQHandler")
	_ = interrupt.Register(IRQ_ADC0_OVR, "ADC0_OVR_IRQHandler")
	_ = interrupt.Register(IRQ_ADC1_SEQA, "ADC1_SEQA_IRQHandler")
	_ = interrupt.Register(IRQ_ADC1_SEQB, "ADC1_SEQB_IRQHandler")
	_ = interrupt.Register(IRQ_ADC1_THCMP, "ADC1_THCMP_IRQHandler")
	_ = interrupt.Register(IRQ_ADC1_OVR, "ADC1_OVR_IRQHandler")
	_ = interrupt.Register(IRQ_DAC, "DAC_IRQHandler")
	_ = interrupt.Register(IRQ_CMP0, "CMP0_IRQHandler")
	_ = interrupt.Register(IRQ_CMP1, "CMP1_IRQHandler")
	_ = interrupt.Register(IRQ_CMP2, "CMP2_IRQHandler")
	_ = interrupt.Register(IRQ_CMP3, "CMP3_IRQHandler")
	_ = interrupt.Register(IRQ_QEI, "QEI_IRQHandler")
	_ = interrupt.Register(IRQ_RTC_ALARM, "RTC_ALARM_IRQHandler")
	_ = interrupt.Register(IRQ_RTC_WAKE, "RTC_WAKE_IRQHandler")
)

// Peripherals.
var (
	// General Purpose I/O (GPIO)
	GPIO_PORT = (*GPIO_Type)(unsafe.Pointer(uintptr(0x1c000000)))

	// DMA controller
	DMA = (*DMA_Type)(unsafe.Pointer(uintptr(0x1c004000)))

	// USB device controller
	USB = (*USB_Type)(unsafe.Pointer(uintptr(0x1c00c000)))

	// Cyclic Redundancy Check (CRC) engine
	CRC = (*CRC_Type)(unsafe.Pointer(uintptr(0x1c010000)))

	// Large State Configurable Timers 0/1 (SCT0/1)
	SCT0 = (*SCT0_Type)(unsafe.Pointer(uintptr(0x1c018000)))

	// SCT1
	SCT1 = (*SCT0_Type)(unsafe.Pointer(uintptr(0x1c01c000)))

	// Small State Configurable Timers 2/3 (SCT2/3)
	SCT2 = (*SCT2_Type)(unsafe.Pointer(uintptr(0x1c020000)))

	// SCT3
	SCT3 = (*SCT2_Type)(unsafe.Pointer(uintptr(0x1c024000)))

	// 12-bit ADC controller ADC0/1
	ADC0 = (*ADC_Type)(unsafe.Pointer(uintptr(0x40000000)))

	// 12-bit DAC Modification
	DAC = (*DAC_Type)(unsafe.Pointer(uintptr(0x40004000)))

	// Analog comparators ACMP0/1/2/3
	ACMP = (*ACMP_Type)(unsafe.Pointer(uintptr(0x40008000)))

	// Input multiplexing (INMUX)
	INMUX = (*INMUX_Type)(unsafe.Pointer(uintptr(0x40014000)))

	// Real-Time Clock (RTC)
	RTC = (*RTC_Type)(unsafe.Pointer(uintptr(0x40028000)))

	// Windowed Watchdog Timer (WWDT)
	WWDT = (*WWDT_Type)(unsafe.Pointer(uintptr(0x4002c000)))

	// Switch Matrix (SWM)
	SWM = (*SWM_Type)(unsafe.Pointer(uintptr(0x40038000)))

	// Power Management Unit (PMU)
	PMU = (*PMU_Type)(unsafe.Pointer(uintptr(0x4003c000)))

	// USART0
	USART0 = (*USART0_Type)(unsafe.Pointer(uintptr(0x40040000)))

	// USART1
	USART1 = (*USART0_Type)(unsafe.Pointer(uintptr(0x40044000)))

	// SPI0
	SPI0 = (*SPI0_Type)(unsafe.Pointer(uintptr(0x40048000)))

	// SPI1
	SPI1 = (*SPI0_Type)(unsafe.Pointer(uintptr(0x4004c000)))

	// I2C-bus interface
	I2C0 = (*I2C0_Type)(unsafe.Pointer(uintptr(0x40050000)))

	// Quadrature Encoder Interface (QEI)
	QEI = (*QEI_Type)(unsafe.Pointer(uintptr(0x40058000)))

	// System configuration (SYSCON)
	SYSCON = (*SYSCON_Type)(unsafe.Pointer(uintptr(0x40074000)))

	// Multi-Rate Timer (MRT)
	MRT = (*MRT_Type)(unsafe.Pointer(uintptr(0x400a0000)))

	// Pin interrupt and pattern match (PINT)
	PINT = (*PINT_Type)(unsafe.Pointer(uintptr(0x400a4000)))

	// Group interrupt 0/1 (GINT0/1)
	GINT0 = (*GINT_Type)(unsafe.Pointer(uintptr(0x400a8000)))

	// Repetitive Interrupt Timer (RIT)
	RIT = (*RIT_Type)(unsafe.Pointer(uintptr(0x400b4000)))

	// SCT Input Processing Unit (IPU)
	SCTIPU = (*SCTIPU_Type)(unsafe.Pointer(uintptr(0x400b8000)))

	// Flash controller
	FLASHCTRL = (*FLASHCTRL_Type)(unsafe.Pointer(uintptr(0x400bc000)))

	// USART2
	USART2 = (*USART0_Type)(unsafe.Pointer(uintptr(0x400c0000)))

	// Controller Area Network C_CAN0
	C_CAN0 = (*C_CAN0_Type)(unsafe.Pointer(uintptr(0x400f0000)))

	// I/O pin configuration (IOCON)
	IOCON = (*IOCON_Type)(unsafe.Pointer(uintptr(0x400f8000)))

	// ADC1
	ADC1 = (*ADC_Type)(unsafe.Pointer(uintptr(0x40080000)))

	// GINT1
	GINT1 = (*GINT_Type)(unsafe.Pointer(uintptr(0x400ac000)))
)

// General Purpose I/O (GPIO)
type GPIO_Type struct {
	B    [76]volatile.Register8 // 0x0
	_    [4020]byte
	W    [76]volatile.Register32 // 0x1000
	_    [3792]byte
	DIR  [3]volatile.Register32 // 0x2000
	_    [116]byte
	MASK [3]volatile.Register32 // 0x2080
	_    [116]byte
	PIN  [3]volatile.Register32 // 0x2100
	_    [116]byte
	MPIN [3]volatile.Register32 // 0x2180
	_    [116]byte
	SET  [3]volatile.Register32 // 0x2200
	_    [116]byte
	CLR  [3]volatile.Register32 // 0x2280
	_    [116]byte
	NOT  [3]volatile.Register32 // 0x2300
}

// DMA controller
type DMA_Type struct {
	CTRL       volatile.Register32 // 0x0
	INTSTAT    volatile.Register32 // 0x4
	SRAMBASE   volatile.Register32 // 0x8
	_          [20]byte
	ENABLESET0 volatile.Register32 // 0x20
	_          [4]byte
	ENABLECLR0 volatile.Register32 // 0x28
	_          [4]byte
	ACTIVE0    volatile.Register32 // 0x30
	_          [4]byte
	BUSY0      volatile.Register32 // 0x38
	_          [4]byte
	ERRINT0    volatile.Register32 // 0x40
	_          [4]byte
	INTENSET0  volatile.Register32 // 0x48
	_          [4]byte
	INTENCLR0  volatile.Register32 // 0x50
	_          [4]byte
	INTA0      volatile.Register32 // 0x58
	_          [4]byte
	INTB0      volatile.Register32 // 0x60
	_          [4]byte
	SETVALID0  volatile.Register32 // 0x68
	_          [4]byte
	SETTRIG0   volatile.Register32 // 0x70
	_          [4]byte
	ABORT0     volatile.Register32 // 0x78
	_          [900]byte
	CFG0       volatile.Register32 // 0x400
	CTLSTAT0   volatile.Register32 // 0x404
	XFERCFG0   volatile.Register32 // 0x408
	_          [4]byte
	CFG1       volatile.Register32 // 0x410
	CTLSTAT1   volatile.Register32 // 0x414
	XFERCFG1   volatile.Register32 // 0x418
	_          [4]byte
	CFG2       volatile.Register32 // 0x420
	CTLSTAT2   volatile.Register32 // 0x424
	XFERCFG2   volatile.Register32 // 0x428
	_          [4]byte
	CFG3       volatile.Register32 // 0x430
	CTLSTAT3   volatile.Register32 // 0x434
	XFERCFG3   volatile.Register32 // 0x438
	_          [4]byte
	CFG4       volatile.Register32 // 0x440
	CTLSTAT4   volatile.Register32 // 0x444
	XFERCFG4   volatile.Register32 // 0x448
	_          [4]byte
	CFG5       volatile.Register32 // 0x450
	CTLSTAT5   volatile.Register32 // 0x454
	XFERCFG5   volatile.Register32 // 0x458
	_          [4]byte
	CFG6       volatile.Register32 // 0x460
	CTLSTAT6   volatile.Register32 // 0x464
	XFERCFG6   volatile.Register32 // 0x468
	_          [4]byte
	CFG7       volatile.Register32 // 0x470
	CTLSTAT7   volatile.Register32 // 0x474
	XFERCFG7   volatile.Register32 // 0x478
	_          [4]byte
	CFG8       volatile.Register32 // 0x480
	CTLSTAT8   volatile.Register32 // 0x484
	XFERCFG8   volatile.Register32 // 0x488
	_          [4]byte
	CFG9       volatile.Register32 // 0x490
	CTLSTAT9   volatile.Register32 // 0x494
	XFERCFG9   volatile.Register32 // 0x498
	_          [4]byte
	CFG10      volatile.Register32 // 0x4A0
	CTLSTAT10  volatile.Register32 // 0x4A4
	XFERCFG10  volatile.Register32 // 0x4A8
	_          [4]byte
	CFG11      volatile.Register32 // 0x4B0
	CTLSTAT11  volatile.Register32 // 0x4B4
	XFERCFG11  volatile.Register32 // 0x4B8
	_          [4]byte
	CFG12      volatile.Register32 // 0x4C0
	CTLSTAT12  volatile.Register32 // 0x4C4
	XFERCFG12  volatile.Register32 // 0x4C8
	_          [4]byte
	CFG13      volatile.Register32 // 0x4D0
	CTLSTAT13  volatile.Register32 // 0x4D4
	XFERCFG13  volatile.Register32 // 0x4D8
	_          [4]byte
	CFG14      volatile.Register32 // 0x4E0
	CTLSTAT14  volatile.Register32 // 0x4E4
	XFERCFG14  volatile.Register32 // 0x4E8
	_          [4]byte
	CFG15      volatile.Register32 // 0x4F0
	CTLSTAT15  volatile.Register32 // 0x4F4
	XFERCFG15  volatile.Register32 // 0x4F8
	_          [4]byte
	CFG16      volatile.Register32 // 0x500
	CTLSTAT16  volatile.Register32 // 0x504
	XFERCFG16  volatile.Register32 // 0x508
	_          [4]byte
	CFG17      volatile.Register32 // 0x510
	CTLSTAT17  volatile.Register32 // 0x514
	XFERCFG17  volatile.Register32 // 0x518
}

// USB device controller
type USB_Type struct {
	DEVCMDSTAT   volatile.Register32 // 0x0
	INFO         volatile.Register32 // 0x4
	EPLISTSTART  volatile.Register32 // 0x8
	DATABUFSTART volatile.Register32 // 0xC
	LPM          volatile.Register32 // 0x10
	EPSKIP       volatile.Register32 // 0x14
	EPINUSE      volatile.Register32 // 0x18
	EPBUFCFG     volatile.Register32 // 0x1C
	INTSTAT      volatile.Register32 // 0x20
	INTEN        volatile.Register32 // 0x24
	INTSETSTAT   volatile.Register32 // 0x28
	INTROUTING   volatile.Register32 // 0x2C
	_            [4]byte
	EPTOGGLE     volatile.Register32 // 0x34
}

// Cyclic Redundancy Check (CRC) engine
type CRC_Type struct {
	MODE volatile.Register32 // 0x0
	SEED volatile.Register32 // 0x4
	SUM  volatile.Register32 // 0x8
}

// Large State Configurable Timers 0/1 (SCT0/1)
type SCT0_Type struct {
	CONFIG        volatile.Register32 // 0x0
	CTRL          volatile.Register32 // 0x4
	LIMIT         volatile.Register32 // 0x8
	HALT          volatile.Register32 // 0xC
	STOP          volatile.Register32 // 0x10
	START         volatile.Register32 // 0x14
	DITHER        volatile.Register32 // 0x18
	_             [36]byte
	COUNT         volatile.Register32 // 0x40
	STATE         volatile.Register32 // 0x44
	INPUT         volatile.Register32 // 0x48
	REGMODE       volatile.Register32 // 0x4C
	OUTPUT        volatile.Register32 // 0x50
	OUTPUTDIRCTRL volatile.Register32 // 0x54
	RES           volatile.Register32 // 0x58
	DMAREQ0       volatile.Register32 // 0x5C
	DMAREQ1       volatile.Register32 // 0x60
	_             [140]byte
	EVEN          volatile.Register32 // 0xF0
	EVFLAG        volatile.Register32 // 0xF4
	CONEN         volatile.Register32 // 0xF8
	CONFLAG       volatile.Register32 // 0xFC
	MATCH0        volatile.Register32 // 0x100
	MATCH1        volatile.Register32 // 0x104
	MATCH2        volatile.Register32 // 0x108
	MATCH3        volatile.Register32 // 0x10C
	MATCH4        volatile.Register32 // 0x110
	MATCH5        volatile.Register32 // 0x114
	MATCH6        volatile.Register32 // 0x118
	MATCH7        volatile.Register32 // 0x11C
	MATCH8        volatile.Register32 // 0x120
	MATCH9        volatile.Register32 // 0x124
	MATCH10       volatile.Register32 // 0x128
	MATCH11       volatile.Register32 // 0x12C
	MATCH12       volatile.Register32 // 0x130
	MATCH13       volatile.Register32 // 0x134
	MATCH14       volatile.Register32 // 0x138
	MATCH15       volatile.Register32 // 0x13C
	FRACMAT0      volatile.Register32 // 0x140
	FRACMAT1      volatile.Register32 // 0x144
	FRACMAT2      volatile.Register32 // 0x148
	FRACMAT3      volatile.Register32 // 0x14C
	FRACMAT4      volatile.Register32 // 0x150
	FRACMAT5      volatile.Register32 // 0x154
	_             [168]byte
	MATCHREL0     volatile.Register32 // 0x200
	MATCHREL1     volatile.Register32 // 0x204
	MATCHREL2     volatile.Register32 // 0x208
	MATCHREL3     volatile.Register32 // 0x20C
	MATCHREL4     volatile.Register32 // 0x210
	MATCHREL5     volatile.Register32 // 0x214
	MATCHREL6     volatile.Register32 // 0x218
	MATCHREL7     volatile.Register32 // 0x21C
	MATCHREL8     volatile.Register32 // 0x220
	MATCHREL9     volatile.Register32 // 0x224
	MATCHREL10    volatile.Register32 // 0x228
	MATCHREL11    volatile.Register32 // 0x22C
	MATCHREL12    volatile.Register32 // 0x230
	MATCHREL13    volatile.Register32 // 0x234
	MATCHREL14    volatile.Register32 // 0x238
	MATCHREL15    volatile.Register32 // 0x23C
	FRACMATREL0   volatile.Register32 // 0x240
	FRACMATREL1   volatile.Register32 // 0x244
	FRACMATREL2   volatile.Register32 // 0x248
	FRACMATREL3   volatile.Register32 // 0x24C
	FRACMATREL4   volatile.Register32 // 0x250
	FRACMATREL5   volatile.Register32 // 0x254
	_             [168]byte
	EV0_STATE     volatile.Register32 // 0x300
	EV0_CTRL      volatile.Register32 // 0x304
	EV1_STATE     volatile.Register32 // 0x308
	EV1_CTRL      volatile.Register32 // 0x30C
	EV2_STATE     volatile.Register32 // 0x310
	EV2_CTRL      volatile.Register32 // 0x314
	EV3_STATE     volatile.Register32 // 0x318
	EV3_CTRL      volatile.Register32 // 0x31C
	EV4_STATE     volatile.Register32 // 0x320
	EV4_CTRL      volatile.Register32 // 0x324
	EV5_STATE     volatile.Register32 // 0x328
	EV5_CTRL      volatile.Register32 // 0x32C
	EV6_STATE     volatile.Register32 // 0x330
	EV6_CTRL      volatile.Register32 // 0x334
	EV7_STATE     volatile.Register32 // 0x338
	EV7_CTRL      volatile.Register32 // 0x33C
	EV8_STATE     volatile.Register32 // 0x340
	EV8_CTRL      volatile.Register32 // 0x344
	EV9_STATE     volatile.Register32 // 0x348
	EV9_CTRL      volatile.Register32 // 0x34C
	EV10_STATE    volatile.Register32 // 0x350
	EV10_CTRL     volatile.Register32 // 0x354
	EV11_STATE    volatile.Register32 // 0x358
	EV11_CTRL     volatile.Register32 // 0x35C
	EV12_STATE    volatile.Register32 // 0x360
	EV12_CTRL     volatile.Register32 // 0x364
	EV13_STATE    volatile.Register32 // 0x368
	EV13_CTRL     volatile.Register32 // 0x36C
	EV14_STATE    volatile.Register32 // 0x370
	EV14_CTRL     volatile.Register32 // 0x374
	EV15_STATE    volatile.Register32 // 0x378
	EV15_CTRL     volatile.Register32 // 0x37C
	_             [384]byte
	OUT0_SET      volatile.Register32 // 0x500
	OUT0_CLR      volatile.Register32 // 0x504
	OUT1_SET      volatile.Register32 // 0x508
	OUT1_CLR      volatile.Register32 // 0x50C
	OUT2_SET      volatile.Register32 // 0x510
	OUT2_CLR      volatile.Register32 // 0x514
	OUT3_SET      volatile.Register32 // 0x518
	OUT3_CLR      volatile.Register32 // 0x51C
	OUT4_SET      volatile.Register32 // 0x520
	OUT4_CLR      volatile.Register32 // 0x524
	OUT5_SET      volatile.Register32 // 0x528
	OUT5_CLR      volatile.Register32 // 0x52C
	OUT6_SET      volatile.Register32 // 0x530
	OUT6_CLR      volatile.Register32 // 0x534
	OUT7_SET      volatile.Register32 // 0x538
	OUT7_CLR      volatile.Register32 // 0x53C
	OUT8_SET      volatile.Register32 // 0x540
	OUT8_CLR      volatile.Register32 // 0x544
	OUT9_SET      volatile.Register32 // 0x548
	OUT9_CLR      volatile.Register32 // 0x54C
}

// Small State Configurable Timers 2/3 (SCT2/3)
type SCT2_Type struct {
	CONFIG        volatile.Register32 // 0x0
	CTRL          volatile.Register32 // 0x4
	LIMIT         volatile.Register32 // 0x8
	HALT          volatile.Register32 // 0xC
	STOP          volatile.Register32 // 0x10
	START         volatile.Register32 // 0x14
	_             [40]byte
	COUNT         volatile.Register32 // 0x40
	STATE         volatile.Register32 // 0x44
	INPUT         volatile.Register32 // 0x48
	REGMODE       volatile.Register32 // 0x4C
	OUTPUT        volatile.Register32 // 0x50
	OUTPUTDIRCTRL volatile.Register32 // 0x54
	RES           volatile.Register32 // 0x58
	DMAREQ0       volatile.Register32 // 0x5C
	DMAREQ1       volatile.Register32 // 0x60
	_             [140]byte
	EVEN          volatile.Register32 // 0xF0
	EVFLAG        volatile.Register32 // 0xF4
	CONEN         volatile.Register32 // 0xF8
	CONFLAG       volatile.Register32 // 0xFC
	MATCH0        volatile.Register32 // 0x100
	MATCH1        volatile.Register32 // 0x104
	MATCH2        volatile.Register32 // 0x108
	MATCH3        volatile.Register32 // 0x10C
	MATCH4        volatile.Register32 // 0x110
	MATCH5        volatile.Register32 // 0x114
	MATCH6        volatile.Register32 // 0x118
	MATCH7        volatile.Register32 // 0x11C
	_             [224]byte
	MATCHREL0     volatile.Register32 // 0x200
	MATCHREL1     volatile.Register32 // 0x204
	MATCHREL2     volatile.Register32 // 0x208
	MATCHREL3     volatile.Register32 // 0x20C
	MATCHREL4     volatile.Register32 // 0x210
	MATCHREL5     volatile.Register32 // 0x214
	MATCHREL6     volatile.Register32 // 0x218
	MATCHREL7     volatile.Register32 // 0x21C
	_             [224]byte
	EV0_STATE     volatile.Register32 // 0x300
	EV0_CTRL      volatile.Register32 // 0x304
	EV1_STATE     volatile.Register32 // 0x308
	EV1_CTRL      volatile.Register32 // 0x30C
	EV2_STATE     volatile.Register32 // 0x310
	EV2_CTRL      volatile.Register32 // 0x314
	EV3_STATE     volatile.Register32 // 0x318
	EV3_CTRL      volatile.Register32 // 0x31C
	EV4_STATE     volatile.Register32 // 0x320
	EV4_CTRL      volatile.Register32 // 0x324
	EV5_STATE     volatile.Register32 // 0x328
	EV5_CTRL      volatile.Register32 // 0x32C
	EV6_STATE     volatile.Register32 // 0x330
	EV6_CTRL      volatile.Register32 // 0x334
	EV7_STATE     volatile.Register32 // 0x338
	EV7_CTRL      volatile.Register32 // 0x33C
	EV8_STATE     volatile.Register32 // 0x340
	EV8_CTRL      volatile.Register32 // 0x344
	EV9_STATE     volatile.Register32 // 0x348
	EV9_CTRL      volatile.Register32 // 0x34C
	_             [432]byte
	OUT0_SET      volatile.Register32 // 0x500
	OUT0_CLR      volatile.Register32 // 0x504
	OUT1_SET      volatile.Register32 // 0x508
	OUT1_CLR      volatile.Register32 // 0x50C
	OUT2_SET      volatile.Register32 // 0x510
	OUT2_CLR      volatile.Register32 // 0x514
	OUT3_SET      volatile.Register32 // 0x518
	OUT3_CLR      volatile.Register32 // 0x51C
	OUT4_SET      volatile.Register32 // 0x520
	OUT4_CLR      volatile.Register32 // 0x524
	OUT5_SET      volatile.Register32 // 0x528
	OUT5_CLR      volatile.Register32 // 0x52C
}

// 12-bit ADC controller ADC0/1
type ADC_Type struct {
	CTRL        volatile.Register32 // 0x0
	INSEL       volatile.Register32 // 0x4
	SEQA_CTRL   volatile.Register32 // 0x8
	SEQB_CTRL   volatile.Register32 // 0xC
	SEQA_GDAT   volatile.Register32 // 0x10
	SEQB_GDAT   volatile.Register32 // 0x14
	_           [8]byte
	DAT         [12]volatile.Register32 // 0x20
	THR0_LOW    volatile.Register32     // 0x50
	THR1_LOW    volatile.Register32     // 0x54
	THR0_HIGH   volatile.Register32     // 0x58
	THR1_HIGH   volatile.Register32     // 0x5C
	CHAN_THRSEL volatile.Register32     // 0x60
	INTEN       volatile.Register32     // 0x64
	FLAGS       volatile.Register32     // 0x68
	TRM         volatile.Register32     // 0x6C
}

// 12-bit DAC Modification
type DAC_Type struct {
	VAL    volatile.Register32 // 0x0
	CTRL   volatile.Register32 // 0x4
	CNTVAL volatile.Register32 // 0x8
}

// Analog comparators ACMP0/1/2/3
type ACMP_Type struct {
	CTRL      volatile.Register32 // 0x0
	CMP0      volatile.Register32 // 0x4
	CMPFILTR0 volatile.Register32 // 0x8
	CMP1      volatile.Register32 // 0xC
	CMPFILTR1 volatile.Register32 // 0x10
	CMP2      volatile.Register32 // 0x14
	CMPFILTR2 volatile.Register32 // 0x18
	CMP3      volatile.Register32 // 0x1C
	CMPFILTR3 volatile.Register32 // 0x20
}

// Input multiplexing (INMUX)
type INMUX_Type struct {
	SCT0_INMUX      [7]volatile.Register32 // 0x0
	_               [4]byte
	SCT1_INMUX      [7]volatile.Register32 // 0x20
	_               [4]byte
	SCT2_INMUX      [3]volatile.Register32 // 0x40
	_               [20]byte
	SCT3_INMUX      [3]volatile.Register32 // 0x60
	_               [84]byte
	PINTSEL         [8]volatile.Register32  // 0xC0
	DMA_ITRIG_INMUX [18]volatile.Register32 // 0xE0
	_               [24]byte
	DMA_INMUX_INMUX [4]volatile.Register32 // 0x140
	_               [16]byte
	FREQMEAS_REF    volatile.Register32 // 0x160
	FREQMEAS_TARGET volatile.Register32 // 0x164
}

// Real-Time Clock (RTC)
type RTC_Type struct {
	CTRL  volatile.Register32 // 0x0
	MATCH volatile.Register32 // 0x4
	COUNT volatile.Register32 // 0x8
	WAKE  volatile.Register32 // 0xC
}

// Windowed Watchdog Timer (WWDT)
type WWDT_Type struct {
	MOD     volatile.Register32 // 0x0
	TC      volatile.Register32 // 0x4
	FEED    volatile.Register32 // 0x8
	TV      volatile.Register32 // 0xC
	_       [4]byte
	WARNINT volatile.Register32 // 0x14
	WINDOW  volatile.Register32 // 0x18
}

// Switch Matrix (SWM)
type SWM_Type struct {
	PINASSIGN0  volatile.Register32 // 0x0
	PINASSIGN1  volatile.Register32 // 0x4
	PINASSIGN2  volatile.Register32 // 0x8
	PINASSIGN3  volatile.Register32 // 0xC
	PINASSIGN4  volatile.Register32 // 0x10
	PINASSIGN5  volatile.Register32 // 0x14
	PINASSIGN6  volatile.Register32 // 0x18
	PINASSIGN7  volatile.Register32 // 0x1C
	PINASSIGN8  volatile.Register32 // 0x20
	PINASSIGN9  volatile.Register32 // 0x24
	PINASSIGN10 volatile.Register32 // 0x28
	PINASSIGN11 volatile.Register32 // 0x2C
	PINASSIGN12 volatile.Register32 // 0x30
	PINASSIGN13 volatile.Register32 // 0x34
	PINASSIGN14 volatile.Register32 // 0x38
	PINASSIGN15 volatile.Register32 // 0x3C
	_           [384]byte
	PINENABLE0  volatile.Register32 // 0x1C0
	PINENABLE1  volatile.Register32 // 0x1C4
}

// Power Management Unit (PMU)
type PMU_Type struct {
	PCON    volatile.Register32 // 0x0
	GPREG0  volatile.Register32 // 0x4
	GPREG1  volatile.Register32 // 0x8
	GPREG2  volatile.Register32 // 0xC
	GPREG3  volatile.Register32 // 0x10
	DPDCTRL volatile.Register32 // 0x14
}

// USART0
type USART0_Type struct {
	CFG       volatile.Register32 // 0x0
	CTL       volatile.Register32 // 0x4
	STAT      volatile.Register32 // 0x8
	INTENSET  volatile.Register32 // 0xC
	INTENCLR  volatile.Register32 // 0x10
	RXDAT     volatile.Register32 // 0x14
	RXDATSTAT volatile.Register32 // 0x18
	TXDAT     volatile.Register32 // 0x1C
	BRG       volatile.Register32 // 0x20
	INTSTAT   volatile.Register32 // 0x24
	OSR       volatile.Register32 // 0x28
	ADDR      volatile.Register32 // 0x2C
}

// SPI0
type SPI0_Type struct {
	CFG      volatile.Register32 // 0x0
	DLY      volatile.Register32 // 0x4
	STAT     volatile.Register32 // 0x8
	INTENSET volatile.Register32 // 0xC
	INTENCLR volatile.Register32 // 0x10
	RXDAT    volatile.Register32 // 0x14
	TXDATCTL volatile.Register32 // 0x18
	TXDAT    volatile.Register32 // 0x1C
	TXCTL    volatile.Register32 // 0x20
	DIV      volatile.Register32 // 0x24
	INTSTAT  volatile.Register32 // 0x28
}

// I2C-bus interface
type I2C0_Type struct {
	CFG      volatile.Register32 // 0x0
	STAT     volatile.Register32 // 0x4
	INTENSET volatile.Register32 // 0x8
	INTENCLR volatile.Register32 // 0xC
	TIMEOUT  volatile.Register32 // 0x10
	CLKDIV   volatile.Register32 // 0x14
	INTSTAT  volatile.Register32 // 0x18
	_        [4]byte
	MSTCTL   volatile.Register32 // 0x20
	MSTTIME  volatile.Register32 // 0x24
	MSTDAT   volatile.Register32 // 0x28
	_        [20]byte
	SLVCTL   volatile.Register32 // 0x40
	SLVDAT   volatile.Register32 // 0x44
	SLVADR0  volatile.Register32 // 0x48
	SLVADR1  volatile.Register32 // 0x4C
	SLVADR2  volatile.Register32 // 0x50
	SLVADR3  volatile.Register32 // 0x54
	SLVQUAL0 volatile.Register32 // 0x58
	_        [36]byte
	MONRXDAT volatile.Register32 // 0x80
}

// Quadrature Encoder Interface (QEI)
type QEI_Type struct {
	CON       volatile.Register32 // 0x0
	STAT      volatile.Register32 // 0x4
	CONF      volatile.Register32 // 0x8
	POS       volatile.Register32 // 0xC
	MAXPOS    volatile.Register32 // 0x10
	CMPOS0    volatile.Register32 // 0x14
	CMPOS1    volatile.Register32 // 0x18
	CMPOS2    volatile.Register32 // 0x1C
	INXCNT    volatile.Register32 // 0x20
	INXCMP0   volatile.Register32 // 0x24
	LOAD      volatile.Register32 // 0x28
	TIME      volatile.Register32 // 0x2C
	VEL       volatile.Register32 // 0x30
	CAP       volatile.Register32 // 0x34
	VELCOMP   volatile.Register32 // 0x38
	FILTERPHA volatile.Register32 // 0x3C
	FILTERPHB volatile.Register32 // 0x40
	FILTERINX volatile.Register32 // 0x44
	WINDOW    volatile.Register32 // 0x48
	INXCMP1   volatile.Register32 // 0x4C
	INXCMP2   volatile.Register32 // 0x50
	_         [3972]byte
	IEC       volatile.Register32 // 0xFD8
	IES       volatile.Register32 // 0xFDC
	INTSTAT   volatile.Register32 // 0xFE0
	IE        volatile.Register32 // 0xFE4
	CLR       volatile.Register32 // 0xFE8
	SET       volatile.Register32 // 0xFEC
}

// System configuration (SYSCON)
type SYSCON_Type struct {
	SYSMEMREMAP    volatile.Register32 // 0x0
	_              [16]byte
	SYSTCKCAL      volatile.Register32 // 0x14
	_              [4]byte
	NMISRC         volatile.Register32 // 0x1C
	_              [32]byte
	SYSRSTSTAT     volatile.Register32 // 0x40
	PRESETCTRL0    volatile.Register32 // 0x44
	PRESETCTRL1    volatile.Register32 // 0x48
	PIOPORCAP0     volatile.Register32 // 0x4C
	PIOPORCAP1     volatile.Register32 // 0x50
	PIOPORCAP2     volatile.Register32 // 0x54
	_              [40]byte
	MAINCLKSELA    volatile.Register32 // 0x80
	MAINCLKSELB    volatile.Register32 // 0x84
	USBCLKSEL      volatile.Register32 // 0x88
	ADCASYNCCLKSEL volatile.Register32 // 0x8C
	_              [4]byte
	CLKOUTSELA     volatile.Register32 // 0x94
	CLKOUTSELB     volatile.Register32 // 0x98
	_              [4]byte
	SYSPLLCLKSEL   volatile.Register32 // 0xA0
	USBPLLCLKSEL   volatile.Register32 // 0xA4
	SCTPLLCLKSEL   volatile.Register32 // 0xA8
	_              [20]byte
	SYSAHBCLKDIV   volatile.Register32 // 0xC0
	SYSAHBCLKCTRL0 volatile.Register32 // 0xC4
	SYSAHBCLKCTRL1 volatile.Register32 // 0xC8
	SYSTICKCLKDIV  volatile.Register32 // 0xCC
	UARTCLKDIV     volatile.Register32 // 0xD0
	IOCONCLKDIV    volatile.Register32 // 0xD4
	TRACECLKDIV    volatile.Register32 // 0xD8
	_              [16]byte
	USBCLKDIV      volatile.Register32 // 0xEC
	ADCASYNCCLKDIV volatile.Register32 // 0xF0
	_              [4]byte
	CLKOUTDIV      volatile.Register32 // 0xF8
	_              [44]byte
	FRGCTRL        volatile.Register32 // 0x128
	USBCLKCTRL     volatile.Register32 // 0x12C
	USBCLKST       volatile.Register32 // 0x130
	_              [76]byte
	BODCTRL        volatile.Register32 // 0x180
	_              [4]byte
	SYSOSCCTRL     volatile.Register32 // 0x188
	_              [4]byte
	RTCOSCCTRL     volatile.Register32 // 0x190
	_              [4]byte
	SYSPLLCTRL     volatile.Register32 // 0x198
	SYSPLLSTAT     volatile.Register32 // 0x19C
	USBPLLCTRL     volatile.Register32 // 0x1A0
	USBPLLSTAT     volatile.Register32 // 0x1A4
	SCTPLLCTRL     volatile.Register32 // 0x1A8
	SCTPLLSTAT     volatile.Register32 // 0x1AC
	_              [84]byte
	PDAWAKECFG     volatile.Register32 // 0x204
	PDRUNCFG       volatile.Register32 // 0x208
	_              [12]byte
	STARTERP0      volatile.Register32 // 0x218
	STARTERP1      volatile.Register32 // 0x21C
}

// Multi-Rate Timer (MRT)
type MRT_Type struct {
	INTVAL0  volatile.Register32 // 0x0
	TIMER0   volatile.Register32 // 0x4
	CTRL0    volatile.Register32 // 0x8
	STAT0    volatile.Register32 // 0xC
	INTVAL1  volatile.Register32 // 0x10
	TIMER1   volatile.Register32 // 0x14
	CTRL1    volatile.Register32 // 0x18
	STAT1    volatile.Register32 // 0x1C
	INTVAL2  volatile.Register32 // 0x20
	TIMER2   volatile.Register32 // 0x24
	CTRL2    volatile.Register32 // 0x28
	STAT2    volatile.Register32 // 0x2C
	INTVAL3  volatile.Register32 // 0x30
	TIMER3   volatile.Register32 // 0x34
	CTRL3    volatile.Register32 // 0x38
	STAT3    volatile.Register32 // 0x3C
	_        [180]byte
	IDLE_CH  volatile.Register32 // 0xF4
	IRQ_FLAG volatile.Register32 // 0xF8
}

// Pin interrupt and pattern match (PINT)
type PINT_Type struct {
	ISEL   volatile.Register32 // 0x0
	IENR   volatile.Register32 // 0x4
	SIENR  volatile.Register32 // 0x8
	CIENR  volatile.Register32 // 0xC
	IENF   volatile.Register32 // 0x10
	SIENF  volatile.Register32 // 0x14
	CIENF  volatile.Register32 // 0x18
	RISE   volatile.Register32 // 0x1C
	FALL   volatile.Register32 // 0x20
	IST    volatile.Register32 // 0x24
	PMCTRL volatile.Register32 // 0x28
	PMSRC  volatile.Register32 // 0x2C
	PMCFG  volatile.Register32 // 0x30
}

// Group interrupt 0/1 (GINT0/1)
type GINT_Type struct {
	CTRL     volatile.Register32 // 0x0
	_        [28]byte
	PORT_POL [3]volatile.Register32 // 0x20
	_        [20]byte
	PORT_ENA [3]volatile.Register32 // 0x40
}

// Repetitive Interrupt Timer (RIT)
type RIT_Type struct {
	COMPVAL   volatile.Register32 // 0x0
	MASK      volatile.Register32 // 0x4
	CTRL      volatile.Register32 // 0x8
	COUNTER   volatile.Register32 // 0xC
	COMPVAL_H volatile.Register32 // 0x10
	MASK_H    volatile.Register32 // 0x14
	_         [4]byte
	COUNTER_H volatile.Register32 // 0x1C
}

// SCT Input Processing Unit (IPU)
type SCTIPU_Type struct {
	SAMPLE_CTRL   volatile.Register32 // 0x0
	_             [28]byte
	ABORT_ENABLE0 volatile.Register32 // 0x20
	ABORT_SOURCE0 volatile.Register32 // 0x24
	_             [24]byte
	ABORT_ENABLE1 volatile.Register32 // 0x40
	ABORT_SOURCE1 volatile.Register32 // 0x44
	_             [24]byte
	ABORT_ENABLE2 volatile.Register32 // 0x60
	ABORT_SOURCE2 volatile.Register32 // 0x64
	_             [24]byte
	ABORT_ENABLE3 volatile.Register32 // 0x80
	ABORT_SOURCE3 volatile.Register32 // 0x84
}

// Flash controller
type FLASHCTRL_Type struct {
	_        [32]byte
	FMSSTART volatile.Register32 // 0x20
	FMSSTOP  volatile.Register32 // 0x24
	_        [4]byte
	FMSW0    volatile.Register32 // 0x2C
}

// Controller Area Network C_CAN0
type C_CAN0_Type struct {
	CNTL         volatile.Register32 // 0x0
	STAT         volatile.Register32 // 0x4
	EC           volatile.Register32 // 0x8
	BT           volatile.Register32 // 0xC
	INT          volatile.Register32 // 0x10
	TEST         volatile.Register32 // 0x14
	BRPE         volatile.Register32 // 0x18
	_            [4]byte
	IF1_CMDREQ   volatile.Register32 // 0x20
	IF1_CMDMSK_W volatile.Register32 // 0x24
	IF1_MSK1     volatile.Register32 // 0x28
	IF1_MSK2     volatile.Register32 // 0x2C
	IF1_ARB1     volatile.Register32 // 0x30
	IF1_ARB2     volatile.Register32 // 0x34
	IF1_MCTRL    volatile.Register32 // 0x38
	IF1_DA1      volatile.Register32 // 0x3C
	IF1_DA2      volatile.Register32 // 0x40
	IF1_DB1      volatile.Register32 // 0x44
	IF1_DB2      volatile.Register32 // 0x48
	_            [52]byte
	IF2_CMDREQ   volatile.Register32 // 0x80
	IF2_CMDMSK_W volatile.Register32 // 0x84
	IF2_MSK1     volatile.Register32 // 0x88
	IF2_MSK2     volatile.Register32 // 0x8C
	IF2_ARB1     volatile.Register32 // 0x90
	IF2_ARB2     volatile.Register32 // 0x94
	IF2_MCTRL    volatile.Register32 // 0x98
	IF2_DA1      volatile.Register32 // 0x9C
	IF2_DA2      volatile.Register32 // 0xA0
	IF2_DB1      volatile.Register32 // 0xA4
	IF2_DB2      volatile.Register32 // 0xA8
	_            [84]byte
	TXREQ1       volatile.Register32 // 0x100
	TXREQ2       volatile.Register32 // 0x104
	_            [24]byte
	ND1          volatile.Register32 // 0x120
	ND2          volatile.Register32 // 0x124
	_            [24]byte
	IR1          volatile.Register32 // 0x140
	IR2          volatile.Register32 // 0x144
	_            [24]byte
	MSGV1        volatile.Register32 // 0x160
	MSGV2        volatile.Register32 // 0x164
	_            [24]byte
	CLKDIV       volatile.Register32 // 0x180
}

// I/O pin configuration (IOCON)
type IOCON_Type struct {
	PIO0_0  volatile.Register32 // 0x0
	PIO0_1  volatile.Register32 // 0x4
	PIO0_2  volatile.Register32 // 0x8
	PIO0_3  volatile.Register32 // 0xC
	PIO0_4  volatile.Register32 // 0x10
	PIO0_5  volatile.Register32 // 0x14
	PIO0_6  volatile.Register32 // 0x18
	PIO0_7  volatile.Register32 // 0x1C
	PIO0_8  volatile.Register32 // 0x20
	PIO0_9  volatile.Register32 // 0x24
	PIO0_10 volatile.Register32 // 0x28
	PIO0_11 volatile.Register32 // 0x2C
	PIO0_12 volatile.Register32 // 0x30
	PIO0_13 volatile.Register32 // 0x34
	PIO0_14 volatile.Register32 // 0x38
	PIO0_15 volatile.Register32 // 0x3C
	PIO0_16 volatile.Register32 // 0x40
	PIO0_17 volatile.Register32 // 0x44
	PIO0_18 volatile.Register32 // 0x48
	PIO0_19 volatile.Register32 // 0x4C
	PIO0_20 volatile.Register32 // 0x50
	PIO0_21 volatile.Register32 // 0x54
	PIO0_22 volatile.Register32 // 0x58
	PIO0_23 volatile.Register32 // 0x5C
	PIO0_24 volatile.Register32 // 0x60
	PIO0_25 volatile.Register32 // 0x64
	PIO0_26 volatile.Register32 // 0x68
	PIO0_27 volatile.Register32 // 0x6C
	PIO0_28 volatile.Register32 // 0x70
	PIO0_29 volatile.Register32 // 0x74
	PIO0_30 volatile.Register32 // 0x78
	PIO0_31 volatile.Register32 // 0x7C
	PIO1_0  volatile.Register32 // 0x80
	PIO1_1  volatile.Register32 // 0x84
	PIO1_2  volatile.Register32 // 0x88
	PIO1_3  volatile.Register32 // 0x8C
	PIO1_4  volatile.Register32 // 0x90
	PIO1_5  volatile.Register32 // 0x94
	PIO1_6  volatile.Register32 // 0x98
	PIO1_7  volatile.Register32 // 0x9C
	PIO1_8  volatile.Register32 // 0xA0
	PIO1_9  volatile.Register32 // 0xA4
	PIO1_10 volatile.Register32 // 0xA8
	PIO1_11 volatile.Register32 // 0xAC
	PIO1_12 volatile.Register32 // 0xB0
	PIO1_13 volatile.Register32 // 0xB4
	PIO1_14 volatile.Register32 // 0xB8
	PIO1_15 volatile.Register32 // 0xBC
	PIO1_16 volatile.Register32 // 0xC0
	PIO1_17 volatile.Register32 // 0xC4
	PIO1_18 volatile.Register32 // 0xC8
	PIO1_19 volatile.Register32 // 0xCC
	PIO1_20 volatile.Register32 // 0xD0
	PIO1_21 volatile.Register32 // 0xD4
	PIO1_22 volatile.Register32 // 0xD8
	PIO1_23 volatile.Register32 // 0xDC
	PIO1_24 volatile.Register32 // 0xE0
	PIO1_25 volatile.Register32 // 0xE4
	PIO1_26 volatile.Register32 // 0xE8
	PIO1_27 volatile.Register32 // 0xEC
	PIO1_28 volatile.Register32 // 0xF0
	PIO1_29 volatile.Register32 // 0xF4
	PIO1_30 volatile.Register32 // 0xF8
	PIO1_31 volatile.Register32 // 0xFC
	PIO2_0  volatile.Register32 // 0x100
	PIO2_1  volatile.Register32 // 0x104
	PIO2_2  volatile.Register32 // 0x108
	PIO2_3  volatile.Register32 // 0x10C
	PIO2_4  volatile.Register32 // 0x110
	PIO2_5  volatile.Register32 // 0x114
	PIO2_6  volatile.Register32 // 0x118
	PIO2_7  volatile.Register32 // 0x11C
	PIO2_8  volatile.Register32 // 0x120
	PIO2_9  volatile.Register32 // 0x124
	PIO2_10 volatile.Register32 // 0x128
	PIO2_11 volatile.Register32 // 0x12C
	PIO2_12 volatile.Register32 // 0x130
	PIO2_13 volatile.Register32 // 0x134
}

// Bitfields for GPIO_PORT: General Purpose I/O (GPIO)
const (
	// B: Byte pin registers
	// Position of PBYTE field.
	GPIO_B_PBYTE_Pos = 0x0
	// Bit mask of PBYTE field.
	GPIO_B_PBYTE_Msk = 0x1
	// Bit PBYTE.
	GPIO_B_PBYTE = 0x1

	// W: Word pin registers
	// Position of PWORD field.
	GPIO_W_PWORD_Pos = 0x0
	// Bit mask of PWORD field.
	GPIO_W_PWORD_Msk = 0xffffffff

	// DIR: Port Direction registers
	// Position of DIRP0 field.
	GPIO_DIR_DIRP0_Pos = 0x0
	// Bit mask of DIRP0 field.
	GPIO_DIR_DIRP0_Msk = 0x1
	// Bit DIRP0.
	GPIO_DIR_DIRP0 = 0x1
	// Position of DIRP1 field.
	GPIO_DIR_DIRP1_Pos = 0x1
	// Bit mask of DIRP1 field.
	GPIO_DIR_DIRP1_Msk = 0x2
	// Bit DIRP1.
	GPIO_DIR_DIRP1 = 0x2
	// Position of DIRP2 field.
	GPIO_DIR_DIRP2_Pos = 0x2
	// Bit mask of DIRP2 field.
	GPIO_DIR_DIRP2_Msk = 0x4
	// Bit DIRP2.
	GPIO_DIR_DIRP2 = 0x4
	// Position of DIRP3 field.
	GPIO_DIR_DIRP3_Pos = 0x3
	// Bit mask of DIRP3 field.
	GPIO_DIR_DIRP3_Msk = 0x8
	// Bit DIRP3.
	GPIO_DIR_DIRP3 = 0x8
	// Position of DIRP4 field.
	GPIO_DIR_DIRP4_Pos = 0x4
	// Bit mask of DIRP4 field.
	GPIO_DIR_DIRP4_Msk = 0x10
	// Bit DIRP4.
	GPIO_DIR_DIRP4 = 0x10
	// Position of DIRP5 field.
	GPIO_DIR_DIRP5_Pos = 0x5
	// Bit mask of DIRP5 field.
	GPIO_DIR_DIRP5_Msk = 0x20
	// Bit DIRP5.
	GPIO_DIR_DIRP5 = 0x20
	// Position of DIRP6 field.
	GPIO_DIR_DIRP6_Pos = 0x6
	// Bit mask of DIRP6 field.
	GPIO_DIR_DIRP6_Msk = 0x40
	// Bit DIRP6.
	GPIO_DIR_DIRP6 = 0x40
	// Position of DIRP7 field.
	GPIO_DIR_DIRP7_Pos = 0x7
	// Bit mask of DIRP7 field.
	GPIO_DIR_DIRP7_Msk = 0x80
	// Bit DIRP7.
	GPIO_DIR_DIRP7 = 0x80
	// Position of DIRP8 field.
	GPIO_DIR_DIRP8_Pos = 0x8
	// Bit mask of DIRP8 field.
	GPIO_DIR_DIRP8_Msk = 0x100
	// Bit DIRP8.
	GPIO_DIR_DIRP8 = 0x100
	// Position of DIRP9 field.
	GPIO_DIR_DIRP9_Pos = 0x9
	// Bit mask of DIRP9 field.
	GPIO_DIR_DIRP9_Msk = 0x200
	// Bit DIRP9.
	GPIO_DIR_DIRP9 = 0x200
	// Position of DIRP10 field.
	GPIO_DIR_DIRP10_Pos = 0xa
	// Bit mask of DIRP10 field.
	GPIO_DIR_DIRP10_Msk = 0x400
	// Bit DIRP10.
	GPIO_DIR_DIRP10 = 0x400
	// Position of DIRP11 field.
	GPIO_DIR_DIRP11_Pos = 0xb
	// Bit mask of DIRP11 field.
	GPIO_DIR_DIRP11_Msk = 0x800
	// Bit DIRP11.
	GPIO_DIR_DIRP11 = 0x800
	// Position of DIRP12 field.
	GPIO_DIR_DIRP12_Pos = 0xc
	// Bit mask of DIRP12 field.
	GPIO_DIR_DIRP12_Msk = 0x1000
	// Bit DIRP12.
	GPIO_DIR_DIRP12 = 0x1000
	// Position of DIRP13 field.
	GPIO_DIR_DIRP13_Pos = 0xd
	// Bit mask of DIRP13 field.
	GPIO_DIR_DIRP13_Msk = 0x2000
	// Bit DIRP13.
	GPIO_DIR_DIRP13 = 0x2000
	// Position of DIRP14 field.
	GPIO_DIR_DIRP14_Pos = 0xe
	// Bit mask of DIRP14 field.
	GPIO_DIR_DIRP14_Msk = 0x4000
	// Bit DIRP14.
	GPIO_DIR_DIRP14 = 0x4000
	// Position of DIRP15 field.
	GPIO_DIR_DIRP15_Pos = 0xf
	// Bit mask of DIRP15 field.
	GPIO_DIR_DIRP15_Msk = 0x8000
	// Bit DIRP15.
	GPIO_DIR_DIRP15 = 0x8000
	// Position of DIRP16 field.
	GPIO_DIR_DIRP16_Pos = 0x10
	// Bit mask of DIRP16 field.
	GPIO_DIR_DIRP16_Msk = 0x10000
	// Bit DIRP16.
	GPIO_DIR_DIRP16 = 0x10000
	// Position of DIRP17 field.
	GPIO_DIR_DIRP17_Pos = 0x11
	// Bit mask of DIRP17 field.
	GPIO_DIR_DIRP17_Msk = 0x20000
	// Bit DIRP17.
	GPIO_DIR_DIRP17 = 0x20000
	// Position of DIRP18 field.
	GPIO_DIR_DIRP18_Pos = 0x12
	// Bit mask of DIRP18 field.
	GPIO_DIR_DIRP18_Msk = 0x40000
	// Bit DIRP18.
	GPIO_DIR_DIRP18 = 0x40000
	// Position of DIRP19 field.
	GPIO_DIR_DIRP19_Pos = 0x13
	// Bit mask of DIRP19 field.
	GPIO_DIR_DIRP19_Msk = 0x80000
	// Bit DIRP19.
	GPIO_DIR_DIRP19 = 0x80000
	// Position of DIRP20 field.
	GPIO_DIR_DIRP20_Pos = 0x14
	// Bit mask of DIRP20 field.
	GPIO_DIR_DIRP20_Msk = 0x100000
	// Bit DIRP20.
	GPIO_DIR_DIRP20 = 0x100000
	// Position of DIRP21 field.
	GPIO_DIR_DIRP21_Pos = 0x15
	// Bit mask of DIRP21 field.
	GPIO_DIR_DIRP21_Msk = 0x200000
	// Bit DIRP21.
	GPIO_DIR_DIRP21 = 0x200000
	// Position of DIRP22 field.
	GPIO_DIR_DIRP22_Pos = 0x16
	// Bit mask of DIRP22 field.
	GPIO_DIR_DIRP22_Msk = 0x400000
	// Bit DIRP22.
	GPIO_DIR_DIRP22 = 0x400000
	// Position of DIRP23 field.
	GPIO_DIR_DIRP23_Pos = 0x17
	// Bit mask of DIRP23 field.
	GPIO_DIR_DIRP23_Msk = 0x800000
	// Bit DIRP23.
	GPIO_DIR_DIRP23 = 0x800000
	// Position of DIRP24 field.
	GPIO_DIR_DIRP24_Pos = 0x18
	// Bit mask of DIRP24 field.
	GPIO_DIR_DIRP24_Msk = 0x1000000
	// Bit DIRP24.
	GPIO_DIR_DIRP24 = 0x1000000
	// Position of DIRP25 field.
	GPIO_DIR_DIRP25_Pos = 0x19
	// Bit mask of DIRP25 field.
	GPIO_DIR_DIRP25_Msk = 0x2000000
	// Bit DIRP25.
	GPIO_DIR_DIRP25 = 0x2000000
	// Position of DIRP26 field.
	GPIO_DIR_DIRP26_Pos = 0x1a
	// Bit mask of DIRP26 field.
	GPIO_DIR_DIRP26_Msk = 0x4000000
	// Bit DIRP26.
	GPIO_DIR_DIRP26 = 0x4000000
	// Position of DIRP27 field.
	GPIO_DIR_DIRP27_Pos = 0x1b
	// Bit mask of DIRP27 field.
	GPIO_DIR_DIRP27_Msk = 0x8000000
	// Bit DIRP27.
	GPIO_DIR_DIRP27 = 0x8000000
	// Position of DIRP28 field.
	GPIO_DIR_DIRP28_Pos = 0x1c
	// Bit mask of DIRP28 field.
	GPIO_DIR_DIRP28_Msk = 0x10000000
	// Bit DIRP28.
	GPIO_DIR_DIRP28 = 0x10000000
	// Position of DIRP29 field.
	GPIO_DIR_DIRP29_Pos = 0x1d
	// Bit mask of DIRP29 field.
	GPIO_DIR_DIRP29_Msk = 0x20000000
	// Bit DIRP29.
	GPIO_DIR_DIRP29 = 0x20000000
	// Position of DIRP30 field.
	GPIO_DIR_DIRP30_Pos = 0x1e
	// Bit mask of DIRP30 field.
	GPIO_DIR_DIRP30_Msk = 0x40000000
	// Bit DIRP30.
	GPIO_DIR_DIRP30 = 0x40000000
	// Position of DIRP31 field.
	GPIO_DIR_DIRP31_Pos = 0x1f
	// Bit mask of DIRP31 field.
	GPIO_DIR_DIRP31_Msk = 0x80000000
	// Bit DIRP31.
	GPIO_DIR_DIRP31 = 0x80000000

	// MASK: Port Mask register
	// Position of MASKP0 field.
	GPIO_MASK_MASKP0_Pos = 0x0
	// Bit mask of MASKP0 field.
	GPIO_MASK_MASKP0_Msk = 0x1
	// Bit MASKP0.
	GPIO_MASK_MASKP0 = 0x1
	// Position of MASKP1 field.
	GPIO_MASK_MASKP1_Pos = 0x1
	// Bit mask of MASKP1 field.
	GPIO_MASK_MASKP1_Msk = 0x2
	// Bit MASKP1.
	GPIO_MASK_MASKP1 = 0x2
	// Position of MASKP2 field.
	GPIO_MASK_MASKP2_Pos = 0x2
	// Bit mask of MASKP2 field.
	GPIO_MASK_MASKP2_Msk = 0x4
	// Bit MASKP2.
	GPIO_MASK_MASKP2 = 0x4
	// Position of MASKP3 field.
	GPIO_MASK_MASKP3_Pos = 0x3
	// Bit mask of MASKP3 field.
	GPIO_MASK_MASKP3_Msk = 0x8
	// Bit MASKP3.
	GPIO_MASK_MASKP3 = 0x8
	// Position of MASKP4 field.
	GPIO_MASK_MASKP4_Pos = 0x4
	// Bit mask of MASKP4 field.
	GPIO_MASK_MASKP4_Msk = 0x10
	// Bit MASKP4.
	GPIO_MASK_MASKP4 = 0x10
	// Position of MASKP5 field.
	GPIO_MASK_MASKP5_Pos = 0x5
	// Bit mask of MASKP5 field.
	GPIO_MASK_MASKP5_Msk = 0x20
	// Bit MASKP5.
	GPIO_MASK_MASKP5 = 0x20
	// Position of MASKP6 field.
	GPIO_MASK_MASKP6_Pos = 0x6
	// Bit mask of MASKP6 field.
	GPIO_MASK_MASKP6_Msk = 0x40
	// Bit MASKP6.
	GPIO_MASK_MASKP6 = 0x40
	// Position of MASKP7 field.
	GPIO_MASK_MASKP7_Pos = 0x7
	// Bit mask of MASKP7 field.
	GPIO_MASK_MASKP7_Msk = 0x80
	// Bit MASKP7.
	GPIO_MASK_MASKP7 = 0x80
	// Position of MASKP8 field.
	GPIO_MASK_MASKP8_Pos = 0x8
	// Bit mask of MASKP8 field.
	GPIO_MASK_MASKP8_Msk = 0x100
	// Bit MASKP8.
	GPIO_MASK_MASKP8 = 0x100
	// Position of MASKP9 field.
	GPIO_MASK_MASKP9_Pos = 0x9
	// Bit mask of MASKP9 field.
	GPIO_MASK_MASKP9_Msk = 0x200
	// Bit MASKP9.
	GPIO_MASK_MASKP9 = 0x200
	// Position of MASKP10 field.
	GPIO_MASK_MASKP10_Pos = 0xa
	// Bit mask of MASKP10 field.
	GPIO_MASK_MASKP10_Msk = 0x400
	// Bit MASKP10.
	GPIO_MASK_MASKP10 = 0x400
	// Position of MASKP11 field.
	GPIO_MASK_MASKP11_Pos = 0xb
	// Bit mask of MASKP11 field.
	GPIO_MASK_MASKP11_Msk = 0x800
	// Bit MASKP11.
	GPIO_MASK_MASKP11 = 0x800
	// Position of MASKP12 field.
	GPIO_MASK_MASKP12_Pos = 0xc
	// Bit mask of MASKP12 field.
	GPIO_MASK_MASKP12_Msk = 0x1000
	// Bit MASKP12.
	GPIO_MASK_MASKP12 = 0x1000
	// Position of MASKP13 field.
	GPIO_MASK_MASKP13_Pos = 0xd
	// Bit mask of MASKP13 field.
	GPIO_MASK_MASKP13_Msk = 0x2000
	// Bit MASKP13.
	GPIO_MASK_MASKP13 = 0x2000
	// Position of MASKP14 field.
	GPIO_MASK_MASKP14_Pos = 0xe
	// Bit mask of MASKP14 field.
	GPIO_MASK_MASKP14_Msk = 0x4000
	// Bit MASKP14.
	GPIO_MASK_MASKP14 = 0x4000
	// Position of MASKP15 field.
	GPIO_MASK_MASKP15_Pos = 0xf
	// Bit mask of MASKP15 field.
	GPIO_MASK_MASKP15_Msk = 0x8000
	// Bit MASKP15.
	GPIO_MASK_MASKP15 = 0x8000
	// Position of MASKP16 field.
	GPIO_MASK_MASKP16_Pos = 0x10
	// Bit mask of MASKP16 field.
	GPIO_MASK_MASKP16_Msk = 0x10000
	// Bit MASKP16.
	GPIO_MASK_MASKP16 = 0x10000
	// Position of MASKP17 field.
	GPIO_MASK_MASKP17_Pos = 0x11
	// Bit mask of MASKP17 field.
	GPIO_MASK_MASKP17_Msk = 0x20000
	// Bit MASKP17.
	GPIO_MASK_MASKP17 = 0x20000
	// Position of MASKP18 field.
	GPIO_MASK_MASKP18_Pos = 0x12
	// Bit mask of MASKP18 field.
	GPIO_MASK_MASKP18_Msk = 0x40000
	// Bit MASKP18.
	GPIO_MASK_MASKP18 = 0x40000
	// Position of MASKP19 field.
	GPIO_MASK_MASKP19_Pos = 0x13
	// Bit mask of MASKP19 field.
	GPIO_MASK_MASKP19_Msk = 0x80000
	// Bit MASKP19.
	GPIO_MASK_MASKP19 = 0x80000
	// Position of MASKP20 field.
	GPIO_MASK_MASKP20_Pos = 0x14
	// Bit mask of MASKP20 field.
	GPIO_MASK_MASKP20_Msk = 0x100000
	// Bit MASKP20.
	GPIO_MASK_MASKP20 = 0x100000
	// Position of MASKP21 field.
	GPIO_MASK_MASKP21_Pos = 0x15
	// Bit mask of MASKP21 field.
	GPIO_MASK_MASKP21_Msk = 0x200000
	// Bit MASKP21.
	GPIO_MASK_MASKP21 = 0x200000
	// Position of MASKP22 field.
	GPIO_MASK_MASKP22_Pos = 0x16
	// Bit mask of MASKP22 field.
	GPIO_MASK_MASKP22_Msk = 0x400000
	// Bit MASKP22.
	GPIO_MASK_MASKP22 = 0x400000
	// Position of MASKP23 field.
	GPIO_MASK_MASKP23_Pos = 0x17
	// Bit mask of MASKP23 field.
	GPIO_MASK_MASKP23_Msk = 0x800000
	// Bit MASKP23.
	GPIO_MASK_MASKP23 = 0x800000
	// Position of MASKP24 field.
	GPIO_MASK_MASKP24_Pos = 0x18
	// Bit mask of MASKP24 field.
	GPIO_MASK_MASKP24_Msk = 0x1000000
	// Bit MASKP24.
	GPIO_MASK_MASKP24 = 0x1000000
	// Position of MASKP25 field.
	GPIO_MASK_MASKP25_Pos = 0x19
	// Bit mask of MASKP25 field.
	GPIO_MASK_MASKP25_Msk = 0x2000000
	// Bit MASKP25.
	GPIO_MASK_MASKP25 = 0x2000000
	// Position of MASKP26 field.
	GPIO_MASK_MASKP26_Pos = 0x1a
	// Bit mask of MASKP26 field.
	GPIO_MASK_MASKP26_Msk = 0x4000000
	// Bit MASKP26.
	GPIO_MASK_MASKP26 = 0x4000000
	// Position of MASKP27 field.
	GPIO_MASK_MASKP27_Pos = 0x1b
	// Bit mask of MASKP27 field.
	GPIO_MASK_MASKP27_Msk = 0x8000000
	// Bit MASKP27.
	GPIO_MASK_MASKP27 = 0x8000000
	// Position of MASKP28 field.
	GPIO_MASK_MASKP28_Pos = 0x1c
	// Bit mask of MASKP28 field.
	GPIO_MASK_MASKP28_Msk = 0x10000000
	// Bit MASKP28.
	GPIO_MASK_MASKP28 = 0x10000000
	// Position of MASKP29 field.
	GPIO_MASK_MASKP29_Pos = 0x1d
	// Bit mask of MASKP29 field.
	GPIO_MASK_MASKP29_Msk = 0x20000000
	// Bit MASKP29.
	GPIO_MASK_MASKP29 = 0x20000000
	// Position of MASKP30 field.
	GPIO_MASK_MASKP30_Pos = 0x1e
	// Bit mask of MASKP30 field.
	GPIO_MASK_MASKP30_Msk = 0x40000000
	// Bit MASKP30.
	GPIO_MASK_MASKP30 = 0x40000000
	// Position of MASKP31 field.
	GPIO_MASK_MASKP31_Pos = 0x1f
	// Bit mask of MASKP31 field.
	GPIO_MASK_MASKP31_Msk = 0x80000000
	// Bit MASKP31.
	GPIO_MASK_MASKP31 = 0x80000000

	// PIN: Port pin register
	// Position of PORT0 field.
	GPIO_PIN_PORT0_Pos = 0x0
	// Bit mask of PORT0 field.
	GPIO_PIN_PORT0_Msk = 0x1
	// Bit PORT0.
	GPIO_PIN_PORT0 = 0x1
	// Position of PORT1 field.
	GPIO_PIN_PORT1_Pos = 0x1
	// Bit mask of PORT1 field.
	GPIO_PIN_PORT1_Msk = 0x2
	// Bit PORT1.
	GPIO_PIN_PORT1 = 0x2
	// Position of PORT2 field.
	GPIO_PIN_PORT2_Pos = 0x2
	// Bit mask of PORT2 field.
	GPIO_PIN_PORT2_Msk = 0x4
	// Bit PORT2.
	GPIO_PIN_PORT2 = 0x4
	// Position of PORT3 field.
	GPIO_PIN_PORT3_Pos = 0x3
	// Bit mask of PORT3 field.
	GPIO_PIN_PORT3_Msk = 0x8
	// Bit PORT3.
	GPIO_PIN_PORT3 = 0x8
	// Position of PORT4 field.
	GPIO_PIN_PORT4_Pos = 0x4
	// Bit mask of PORT4 field.
	GPIO_PIN_PORT4_Msk = 0x10
	// Bit PORT4.
	GPIO_PIN_PORT4 = 0x10
	// Position of PORT5 field.
	GPIO_PIN_PORT5_Pos = 0x5
	// Bit mask of PORT5 field.
	GPIO_PIN_PORT5_Msk = 0x20
	// Bit PORT5.
	GPIO_PIN_PORT5 = 0x20
	// Position of PORT6 field.
	GPIO_PIN_PORT6_Pos = 0x6
	// Bit mask of PORT6 field.
	GPIO_PIN_PORT6_Msk = 0x40
	// Bit PORT6.
	GPIO_PIN_PORT6 = 0x40
	// Position of PORT7 field.
	GPIO_PIN_PORT7_Pos = 0x7
	// Bit mask of PORT7 field.
	GPIO_PIN_PORT7_Msk = 0x80
	// Bit PORT7.
	GPIO_PIN_PORT7 = 0x80
	// Position of PORT8 field.
	GPIO_PIN_PORT8_Pos = 0x8
	// Bit mask of PORT8 field.
	GPIO_PIN_PORT8_Msk = 0x100
	// Bit PORT8.
	GPIO_PIN_PORT8 = 0x100
	// Position of PORT9 field.
	GPIO_PIN_PORT9_Pos = 0x9
	// Bit mask of PORT9 field.
	GPIO_PIN_PORT9_Msk = 0x200
	// Bit PORT9.
	GPIO_PIN_PORT9 = 0x200
	// Position of PORT10 field.
	GPIO_PIN_PORT10_Pos = 0xa
	// Bit mask of PORT10 field.
	GPIO_PIN_PORT10_Msk = 0x400
	// Bit PORT10.
	GPIO_PIN_PORT10 = 0x400
	// Position of PORT11 field.
	GPIO_PIN_PORT11_Pos = 0xb
	// Bit mask of PORT11 field.
	GPIO_PIN_PORT11_Msk = 0x800
	// Bit PORT11.
	GPIO_PIN_PORT11 = 0x800
	// Position of PORT12 field.
	GPIO_PIN_PORT12_Pos = 0xc
	// Bit mask of PORT12 field.
	GPIO_PIN_PORT12_Msk = 0x1000
	// Bit PORT12.
	GPIO_PIN_PORT12 = 0x1000
	// Position of PORT13 field.
	GPIO_PIN_PORT13_Pos = 0xd
	// Bit mask of PORT13 field.
	GPIO_PIN_PORT13_Msk = 0x2000
	// Bit PORT13.
	GPIO_PIN_PORT13 = 0x2000
	// Position of PORT14 field.
	GPIO_PIN_PORT14_Pos = 0xe
	// Bit mask of PORT14 field.
	GPIO_PIN_PORT14_Msk = 0x4000
	// Bit PORT14.
	GPIO_PIN_PORT14 = 0x4000
	// Position of PORT15 field.
	GPIO_PIN_PORT15_Pos = 0xf
	// Bit mask of PORT15 field.
	GPIO_PIN_PORT15_Msk = 0x8000
	// Bit PORT15.
	GPIO_PIN_PORT15 = 0x8000
	// Position of PORT16 field.
	GPIO_PIN_PORT16_Pos = 0x10
	// Bit mask of PORT16 field.
	GPIO_PIN_PORT16_Msk = 0x10000
	// Bit PORT16.
	GPIO_PIN_PORT16 = 0x10000
	// Position of PORT17 field.
	GPIO_PIN_PORT17_Pos = 0x11
	// Bit mask of PORT17 field.
	GPIO_PIN_PORT17_Msk = 0x20000
	// Bit PORT17.
	GPIO_PIN_PORT17 = 0x20000
	// Position of PORT18 field.
	GPIO_PIN_PORT18_Pos = 0x12
	// Bit mask of PORT18 field.
	GPIO_PIN_PORT18_Msk = 0x40000
	// Bit PORT18.
	GPIO_PIN_PORT18 = 0x40000
	// Position of PORT19 field.
	GPIO_PIN_PORT19_Pos = 0x13
	// Bit mask of PORT19 field.
	GPIO_PIN_PORT19_Msk = 0x80000
	// Bit PORT19.
	GPIO_PIN_PORT19 = 0x80000
	// Position of PORT20 field.
	GPIO_PIN_PORT20_Pos = 0x14
	// Bit mask of PORT20 field.
	GPIO_PIN_PORT20_Msk = 0x100000
	// Bit PORT20.
	GPIO_PIN_PORT20 = 0x100000
	// Position of PORT21 field.
	GPIO_PIN_PORT21_Pos = 0x15
	// Bit mask of PORT21 field.
	GPIO_PIN_PORT21_Msk = 0x200000
	// Bit PORT21.
	GPIO_PIN_PORT21 = 0x200000
	// Position of PORT22 field.
	GPIO_PIN_PORT22_Pos = 0x16
	// Bit mask of PORT22 field.
	GPIO_PIN_PORT22_Msk = 0x400000
	// Bit PORT22.
	GPIO_PIN_PORT22 = 0x400000
	// Position of PORT23 field.
	GPIO_PIN_PORT23_Pos = 0x17
	// Bit mask of PORT23 field.
	GPIO_PIN_PORT23_Msk = 0x800000
	// Bit PORT23.
	GPIO_PIN_PORT23 = 0x800000
	// Position of PORT24 field.
	GPIO_PIN_PORT24_Pos = 0x18
	// Bit mask of PORT24 field.
	GPIO_PIN_PORT24_Msk = 0x1000000
	// Bit PORT24.
	GPIO_PIN_PORT24 = 0x1000000
	// Position of PORT25 field.
	GPIO_PIN_PORT25_Pos = 0x19
	// Bit mask of PORT25 field.
	GPIO_PIN_PORT25_Msk = 0x2000000
	// Bit PORT25.
	GPIO_PIN_PORT25 = 0x2000000
	// Position of PORT26 field.
	GPIO_PIN_PORT26_Pos = 0x1a
	// Bit mask of PORT26 field.
	GPIO_PIN_PORT26_Msk = 0x4000000
	// Bit PORT26.
	GPIO_PIN_PORT26 = 0x4000000
	// Position of PORT27 field.
	GPIO_PIN_PORT27_Pos = 0x1b
	// Bit mask of PORT27 field.
	GPIO_PIN_PORT27_Msk = 0x8000000
	// Bit PORT27.
	GPIO_PIN_PORT27 = 0x8000000
	// Position of PORT28 field.
	GPIO_PIN_PORT28_Pos = 0x1c
	// Bit mask of PORT28 field.
	GPIO_PIN_PORT28_Msk = 0x10000000
	// Bit PORT28.
	GPIO_PIN_PORT28 = 0x10000000
	// Position of PORT29 field.
	GPIO_PIN_PORT29_Pos = 0x1d
	// Bit mask of PORT29 field.
	GPIO_PIN_PORT29_Msk = 0x20000000
	// Bit PORT29.
	GPIO_PIN_PORT29 = 0x20000000
	// Position of PORT30 field.
	GPIO_PIN_PORT30_Pos = 0x1e
	// Bit mask of PORT30 field.
	GPIO_PIN_PORT30_Msk = 0x40000000
	// Bit PORT30.
	GPIO_PIN_PORT30 = 0x40000000
	// Position of PORT31 field.
	GPIO_PIN_PORT31_Pos = 0x1f
	// Bit mask of PORT31 field.
	GPIO_PIN_PORT31_Msk = 0x80000000
	// Bit PORT31.
	GPIO_PIN_PORT31 = 0x80000000

	// MPIN: Masked port register
	// Position of MPORTP0 field.
	GPIO_MPIN_MPORTP0_Pos = 0x0
	// Bit mask of MPORTP0 field.
	GPIO_MPIN_MPORTP0_Msk = 0x1
	// Bit MPORTP0.
	GPIO_MPIN_MPORTP0 = 0x1
	// Position of MPORTP1 field.
	GPIO_MPIN_MPORTP1_Pos = 0x1
	// Bit mask of MPORTP1 field.
	GPIO_MPIN_MPORTP1_Msk = 0x2
	// Bit MPORTP1.
	GPIO_MPIN_MPORTP1 = 0x2
	// Position of MPORTP2 field.
	GPIO_MPIN_MPORTP2_Pos = 0x2
	// Bit mask of MPORTP2 field.
	GPIO_MPIN_MPORTP2_Msk = 0x4
	// Bit MPORTP2.
	GPIO_MPIN_MPORTP2 = 0x4
	// Position of MPORTP3 field.
	GPIO_MPIN_MPORTP3_Pos = 0x3
	// Bit mask of MPORTP3 field.
	GPIO_MPIN_MPORTP3_Msk = 0x8
	// Bit MPORTP3.
	GPIO_MPIN_MPORTP3 = 0x8
	// Position of MPORTP4 field.
	GPIO_MPIN_MPORTP4_Pos = 0x4
	// Bit mask of MPORTP4 field.
	GPIO_MPIN_MPORTP4_Msk = 0x10
	// Bit MPORTP4.
	GPIO_MPIN_MPORTP4 = 0x10
	// Position of MPORTP5 field.
	GPIO_MPIN_MPORTP5_Pos = 0x5
	// Bit mask of MPORTP5 field.
	GPIO_MPIN_MPORTP5_Msk = 0x20
	// Bit MPORTP5.
	GPIO_MPIN_MPORTP5 = 0x20
	// Position of MPORTP6 field.
	GPIO_MPIN_MPORTP6_Pos = 0x6
	// Bit mask of MPORTP6 field.
	GPIO_MPIN_MPORTP6_Msk = 0x40
	// Bit MPORTP6.
	GPIO_MPIN_MPORTP6 = 0x40
	// Position of MPORTP7 field.
	GPIO_MPIN_MPORTP7_Pos = 0x7
	// Bit mask of MPORTP7 field.
	GPIO_MPIN_MPORTP7_Msk = 0x80
	// Bit MPORTP7.
	GPIO_MPIN_MPORTP7 = 0x80
	// Position of MPORTP8 field.
	GPIO_MPIN_MPORTP8_Pos = 0x8
	// Bit mask of MPORTP8 field.
	GPIO_MPIN_MPORTP8_Msk = 0x100
	// Bit MPORTP8.
	GPIO_MPIN_MPORTP8 = 0x100
	// Position of MPORTP9 field.
	GPIO_MPIN_MPORTP9_Pos = 0x9
	// Bit mask of MPORTP9 field.
	GPIO_MPIN_MPORTP9_Msk = 0x200
	// Bit MPORTP9.
	GPIO_MPIN_MPORTP9 = 0x200
	// Position of MPORTP10 field.
	GPIO_MPIN_MPORTP10_Pos = 0xa
	// Bit mask of MPORTP10 field.
	GPIO_MPIN_MPORTP10_Msk = 0x400
	// Bit MPORTP10.
	GPIO_MPIN_MPORTP10 = 0x400
	// Position of MPORTP11 field.
	GPIO_MPIN_MPORTP11_Pos = 0xb
	// Bit mask of MPORTP11 field.
	GPIO_MPIN_MPORTP11_Msk = 0x800
	// Bit MPORTP11.
	GPIO_MPIN_MPORTP11 = 0x800
	// Position of MPORTP12 field.
	GPIO_MPIN_MPORTP12_Pos = 0xc
	// Bit mask of MPORTP12 field.
	GPIO_MPIN_MPORTP12_Msk = 0x1000
	// Bit MPORTP12.
	GPIO_MPIN_MPORTP12 = 0x1000
	// Position of MPORTP13 field.
	GPIO_MPIN_MPORTP13_Pos = 0xd
	// Bit mask of MPORTP13 field.
	GPIO_MPIN_MPORTP13_Msk = 0x2000
	// Bit MPORTP13.
	GPIO_MPIN_MPORTP13 = 0x2000
	// Position of MPORTP14 field.
	GPIO_MPIN_MPORTP14_Pos = 0xe
	// Bit mask of MPORTP14 field.
	GPIO_MPIN_MPORTP14_Msk = 0x4000
	// Bit MPORTP14.
	GPIO_MPIN_MPORTP14 = 0x4000
	// Position of MPORTP15 field.
	GPIO_MPIN_MPORTP15_Pos = 0xf
	// Bit mask of MPORTP15 field.
	GPIO_MPIN_MPORTP15_Msk = 0x8000
	// Bit MPORTP15.
	GPIO_MPIN_MPORTP15 = 0x8000
	// Position of MPORTP16 field.
	GPIO_MPIN_MPORTP16_Pos = 0x10
	// Bit mask of MPORTP16 field.
	GPIO_MPIN_MPORTP16_Msk = 0x10000
	// Bit MPORTP16.
	GPIO_MPIN_MPORTP16 = 0x10000
	// Position of MPORTP17 field.
	GPIO_MPIN_MPORTP17_Pos = 0x11
	// Bit mask of MPORTP17 field.
	GPIO_MPIN_MPORTP17_Msk = 0x20000
	// Bit MPORTP17.
	GPIO_MPIN_MPORTP17 = 0x20000
	// Position of MPORTP18 field.
	GPIO_MPIN_MPORTP18_Pos = 0x12
	// Bit mask of MPORTP18 field.
	GPIO_MPIN_MPORTP18_Msk = 0x40000
	// Bit MPORTP18.
	GPIO_MPIN_MPORTP18 = 0x40000
	// Position of MPORTP19 field.
	GPIO_MPIN_MPORTP19_Pos = 0x13
	// Bit mask of MPORTP19 field.
	GPIO_MPIN_MPORTP19_Msk = 0x80000
	// Bit MPORTP19.
	GPIO_MPIN_MPORTP19 = 0x80000
	// Position of MPORTP20 field.
	GPIO_MPIN_MPORTP20_Pos = 0x14
	// Bit mask of MPORTP20 field.
	GPIO_MPIN_MPORTP20_Msk = 0x100000
	// Bit MPORTP20.
	GPIO_MPIN_MPORTP20 = 0x100000
	// Position of MPORTP21 field.
	GPIO_MPIN_MPORTP21_Pos = 0x15
	// Bit mask of MPORTP21 field.
	GPIO_MPIN_MPORTP21_Msk = 0x200000
	// Bit MPORTP21.
	GPIO_MPIN_MPORTP21 = 0x200000
	// Position of MPORTP22 field.
	GPIO_MPIN_MPORTP22_Pos = 0x16
	// Bit mask of MPORTP22 field.
	GPIO_MPIN_MPORTP22_Msk = 0x400000
	// Bit MPORTP22.
	GPIO_MPIN_MPORTP22 = 0x400000
	// Position of MPORTP23 field.
	GPIO_MPIN_MPORTP23_Pos = 0x17
	// Bit mask of MPORTP23 field.
	GPIO_MPIN_MPORTP23_Msk = 0x800000
	// Bit MPORTP23.
	GPIO_MPIN_MPORTP23 = 0x800000
	// Position of MPORTP24 field.
	GPIO_MPIN_MPORTP24_Pos = 0x18
	// Bit mask of MPORTP24 field.
	GPIO_MPIN_MPORTP24_Msk = 0x1000000
	// Bit MPORTP24.
	GPIO_MPIN_MPORTP24 = 0x1000000
	// Position of MPORTP25 field.
	GPIO_MPIN_MPORTP25_Pos = 0x19
	// Bit mask of MPORTP25 field.
	GPIO_MPIN_MPORTP25_Msk = 0x2000000
	// Bit MPORTP25.
	GPIO_MPIN_MPORTP25 = 0x2000000
	// Position of MPORTP26 field.
	GPIO_MPIN_MPORTP26_Pos = 0x1a
	// Bit mask of MPORTP26 field.
	GPIO_MPIN_MPORTP26_Msk = 0x4000000
	// Bit MPORTP26.
	GPIO_MPIN_MPORTP26 = 0x4000000
	// Position of MPORTP27 field.
	GPIO_MPIN_MPORTP27_Pos = 0x1b
	// Bit mask of MPORTP27 field.
	GPIO_MPIN_MPORTP27_Msk = 0x8000000
	// Bit MPORTP27.
	GPIO_MPIN_MPORTP27 = 0x8000000
	// Position of MPORTP28 field.
	GPIO_MPIN_MPORTP28_Pos = 0x1c
	// Bit mask of MPORTP28 field.
	GPIO_MPIN_MPORTP28_Msk = 0x10000000
	// Bit MPORTP28.
	GPIO_MPIN_MPORTP28 = 0x10000000
	// Position of MPORTP29 field.
	GPIO_MPIN_MPORTP29_Pos = 0x1d
	// Bit mask of MPORTP29 field.
	GPIO_MPIN_MPORTP29_Msk = 0x20000000
	// Bit MPORTP29.
	GPIO_MPIN_MPORTP29 = 0x20000000
	// Position of MPORTP30 field.
	GPIO_MPIN_MPORTP30_Pos = 0x1e
	// Bit mask of MPORTP30 field.
	GPIO_MPIN_MPORTP30_Msk = 0x40000000
	// Bit MPORTP30.
	GPIO_MPIN_MPORTP30 = 0x40000000
	// Position of MPORTP31 field.
	GPIO_MPIN_MPORTP31_Pos = 0x1f
	// Bit mask of MPORTP31 field.
	GPIO_MPIN_MPORTP31_Msk = 0x80000000
	// Bit MPORTP31.
	GPIO_MPIN_MPORTP31 = 0x80000000

	// SET: Write: Set port register Read: port output bits
	// Position of SETP00 field.
	GPIO_SET_SETP00_Pos = 0x0
	// Bit mask of SETP00 field.
	GPIO_SET_SETP00_Msk = 0x1
	// Bit SETP00.
	GPIO_SET_SETP00 = 0x1
	// Position of SETP01 field.
	GPIO_SET_SETP01_Pos = 0x1
	// Bit mask of SETP01 field.
	GPIO_SET_SETP01_Msk = 0x2
	// Bit SETP01.
	GPIO_SET_SETP01 = 0x2
	// Position of SETP02 field.
	GPIO_SET_SETP02_Pos = 0x2
	// Bit mask of SETP02 field.
	GPIO_SET_SETP02_Msk = 0x4
	// Bit SETP02.
	GPIO_SET_SETP02 = 0x4
	// Position of SETP03 field.
	GPIO_SET_SETP03_Pos = 0x3
	// Bit mask of SETP03 field.
	GPIO_SET_SETP03_Msk = 0x8
	// Bit SETP03.
	GPIO_SET_SETP03 = 0x8
	// Position of SETP04 field.
	GPIO_SET_SETP04_Pos = 0x4
	// Bit mask of SETP04 field.
	GPIO_SET_SETP04_Msk = 0x10
	// Bit SETP04.
	GPIO_SET_SETP04 = 0x10
	// Position of SETP05 field.
	GPIO_SET_SETP05_Pos = 0x5
	// Bit mask of SETP05 field.
	GPIO_SET_SETP05_Msk = 0x20
	// Bit SETP05.
	GPIO_SET_SETP05 = 0x20
	// Position of SETP06 field.
	GPIO_SET_SETP06_Pos = 0x6
	// Bit mask of SETP06 field.
	GPIO_SET_SETP06_Msk = 0x40
	// Bit SETP06.
	GPIO_SET_SETP06 = 0x40
	// Position of SETP07 field.
	GPIO_SET_SETP07_Pos = 0x7
	// Bit mask of SETP07 field.
	GPIO_SET_SETP07_Msk = 0x80
	// Bit SETP07.
	GPIO_SET_SETP07 = 0x80
	// Position of SETP08 field.
	GPIO_SET_SETP08_Pos = 0x8
	// Bit mask of SETP08 field.
	GPIO_SET_SETP08_Msk = 0x100
	// Bit SETP08.
	GPIO_SET_SETP08 = 0x100
	// Position of SETP09 field.
	GPIO_SET_SETP09_Pos = 0x9
	// Bit mask of SETP09 field.
	GPIO_SET_SETP09_Msk = 0x200
	// Bit SETP09.
	GPIO_SET_SETP09 = 0x200
	// Position of SETP010 field.
	GPIO_SET_SETP010_Pos = 0xa
	// Bit mask of SETP010 field.
	GPIO_SET_SETP010_Msk = 0x400
	// Bit SETP010.
	GPIO_SET_SETP010 = 0x400
	// Position of SETP011 field.
	GPIO_SET_SETP011_Pos = 0xb
	// Bit mask of SETP011 field.
	GPIO_SET_SETP011_Msk = 0x800
	// Bit SETP011.
	GPIO_SET_SETP011 = 0x800
	// Position of SETP012 field.
	GPIO_SET_SETP012_Pos = 0xc
	// Bit mask of SETP012 field.
	GPIO_SET_SETP012_Msk = 0x1000
	// Bit SETP012.
	GPIO_SET_SETP012 = 0x1000
	// Position of SETP013 field.
	GPIO_SET_SETP013_Pos = 0xd
	// Bit mask of SETP013 field.
	GPIO_SET_SETP013_Msk = 0x2000
	// Bit SETP013.
	GPIO_SET_SETP013 = 0x2000
	// Position of SETP014 field.
	GPIO_SET_SETP014_Pos = 0xe
	// Bit mask of SETP014 field.
	GPIO_SET_SETP014_Msk = 0x4000
	// Bit SETP014.
	GPIO_SET_SETP014 = 0x4000
	// Position of SETP015 field.
	GPIO_SET_SETP015_Pos = 0xf
	// Bit mask of SETP015 field.
	GPIO_SET_SETP015_Msk = 0x8000
	// Bit SETP015.
	GPIO_SET_SETP015 = 0x8000
	// Position of SETP016 field.
	GPIO_SET_SETP016_Pos = 0x10
	// Bit mask of SETP016 field.
	GPIO_SET_SETP016_Msk = 0x10000
	// Bit SETP016.
	GPIO_SET_SETP016 = 0x10000
	// Position of SETP017 field.
	GPIO_SET_SETP017_Pos = 0x11
	// Bit mask of SETP017 field.
	GPIO_SET_SETP017_Msk = 0x20000
	// Bit SETP017.
	GPIO_SET_SETP017 = 0x20000
	// Position of SETP018 field.
	GPIO_SET_SETP018_Pos = 0x12
	// Bit mask of SETP018 field.
	GPIO_SET_SETP018_Msk = 0x40000
	// Bit SETP018.
	GPIO_SET_SETP018 = 0x40000
	// Position of SETP019 field.
	GPIO_SET_SETP019_Pos = 0x13
	// Bit mask of SETP019 field.
	GPIO_SET_SETP019_Msk = 0x80000
	// Bit SETP019.
	GPIO_SET_SETP019 = 0x80000
	// Position of SETP020 field.
	GPIO_SET_SETP020_Pos = 0x14
	// Bit mask of SETP020 field.
	GPIO_SET_SETP020_Msk = 0x100000
	// Bit SETP020.
	GPIO_SET_SETP020 = 0x100000
	// Position of SETP021 field.
	GPIO_SET_SETP021_Pos = 0x15
	// Bit mask of SETP021 field.
	GPIO_SET_SETP021_Msk = 0x200000
	// Bit SETP021.
	GPIO_SET_SETP021 = 0x200000
	// Position of SETP022 field.
	GPIO_SET_SETP022_Pos = 0x16
	// Bit mask of SETP022 field.
	GPIO_SET_SETP022_Msk = 0x400000
	// Bit SETP022.
	GPIO_SET_SETP022 = 0x400000
	// Position of SETP023 field.
	GPIO_SET_SETP023_Pos = 0x17
	// Bit mask of SETP023 field.
	GPIO_SET_SETP023_Msk = 0x800000
	// Bit SETP023.
	GPIO_SET_SETP023 = 0x800000
	// Position of SETP024 field.
	GPIO_SET_SETP024_Pos = 0x18
	// Bit mask of SETP024 field.
	GPIO_SET_SETP024_Msk = 0x1000000
	// Bit SETP024.
	GPIO_SET_SETP024 = 0x1000000
	// Position of SETP025 field.
	GPIO_SET_SETP025_Pos = 0x19
	// Bit mask of SETP025 field.
	GPIO_SET_SETP025_Msk = 0x2000000
	// Bit SETP025.
	GPIO_SET_SETP025 = 0x2000000
	// Position of SETP026 field.
	GPIO_SET_SETP026_Pos = 0x1a
	// Bit mask of SETP026 field.
	GPIO_SET_SETP026_Msk = 0x4000000
	// Bit SETP026.
	GPIO_SET_SETP026 = 0x4000000
	// Position of SETP027 field.
	GPIO_SET_SETP027_Pos = 0x1b
	// Bit mask of SETP027 field.
	GPIO_SET_SETP027_Msk = 0x8000000
	// Bit SETP027.
	GPIO_SET_SETP027 = 0x8000000
	// Position of SETP028 field.
	GPIO_SET_SETP028_Pos = 0x1c
	// Bit mask of SETP028 field.
	GPIO_SET_SETP028_Msk = 0x10000000
	// Bit SETP028.
	GPIO_SET_SETP028 = 0x10000000
	// Position of SETP029 field.
	GPIO_SET_SETP029_Pos = 0x1d
	// Bit mask of SETP029 field.
	GPIO_SET_SETP029_Msk = 0x20000000
	// Bit SETP029.
	GPIO_SET_SETP029 = 0x20000000
	// Position of SETP030 field.
	GPIO_SET_SETP030_Pos = 0x1e
	// Bit mask of SETP030 field.
	GPIO_SET_SETP030_Msk = 0x40000000
	// Bit SETP030.
	GPIO_SET_SETP030 = 0x40000000
	// Position of SETP031 field.
	GPIO_SET_SETP031_Pos = 0x1f
	// Bit mask of SETP031 field.
	GPIO_SET_SETP031_Msk = 0x80000000
	// Bit SETP031.
	GPIO_SET_SETP031 = 0x80000000

	// CLR: Clear port
	// Position of CLRP00 field.
	GPIO_CLR_CLRP00_Pos = 0x0
	// Bit mask of CLRP00 field.
	GPIO_CLR_CLRP00_Msk = 0x1
	// Bit CLRP00.
	GPIO_CLR_CLRP00 = 0x1
	// Position of CLRP01 field.
	GPIO_CLR_CLRP01_Pos = 0x1
	// Bit mask of CLRP01 field.
	GPIO_CLR_CLRP01_Msk = 0x2
	// Bit CLRP01.
	GPIO_CLR_CLRP01 = 0x2
	// Position of CLRP02 field.
	GPIO_CLR_CLRP02_Pos = 0x2
	// Bit mask of CLRP02 field.
	GPIO_CLR_CLRP02_Msk = 0x4
	// Bit CLRP02.
	GPIO_CLR_CLRP02 = 0x4
	// Position of CLRP03 field.
	GPIO_CLR_CLRP03_Pos = 0x3
	// Bit mask of CLRP03 field.
	GPIO_CLR_CLRP03_Msk = 0x8
	// Bit CLRP03.
	GPIO_CLR_CLRP03 = 0x8
	// Position of CLRP04 field.
	GPIO_CLR_CLRP04_Pos = 0x4
	// Bit mask of CLRP04 field.
	GPIO_CLR_CLRP04_Msk = 0x10
	// Bit CLRP04.
	GPIO_CLR_CLRP04 = 0x10
	// Position of CLRP05 field.
	GPIO_CLR_CLRP05_Pos = 0x5
	// Bit mask of CLRP05 field.
	GPIO_CLR_CLRP05_Msk = 0x20
	// Bit CLRP05.
	GPIO_CLR_CLRP05 = 0x20
	// Position of CLRP06 field.
	GPIO_CLR_CLRP06_Pos = 0x6
	// Bit mask of CLRP06 field.
	GPIO_CLR_CLRP06_Msk = 0x40
	// Bit CLRP06.
	GPIO_CLR_CLRP06 = 0x40
	// Position of CLRP07 field.
	GPIO_CLR_CLRP07_Pos = 0x7
	// Bit mask of CLRP07 field.
	GPIO_CLR_CLRP07_Msk = 0x80
	// Bit CLRP07.
	GPIO_CLR_CLRP07 = 0x80
	// Position of CLRP08 field.
	GPIO_CLR_CLRP08_Pos = 0x8
	// Bit mask of CLRP08 field.
	GPIO_CLR_CLRP08_Msk = 0x100
	// Bit CLRP08.
	GPIO_CLR_CLRP08 = 0x100
	// Position of CLRP09 field.
	GPIO_CLR_CLRP09_Pos = 0x9
	// Bit mask of CLRP09 field.
	GPIO_CLR_CLRP09_Msk = 0x200
	// Bit CLRP09.
	GPIO_CLR_CLRP09 = 0x200
	// Position of CLRP010 field.
	GPIO_CLR_CLRP010_Pos = 0xa
	// Bit mask of CLRP010 field.
	GPIO_CLR_CLRP010_Msk = 0x400
	// Bit CLRP010.
	GPIO_CLR_CLRP010 = 0x400
	// Position of CLRP011 field.
	GPIO_CLR_CLRP011_Pos = 0xb
	// Bit mask of CLRP011 field.
	GPIO_CLR_CLRP011_Msk = 0x800
	// Bit CLRP011.
	GPIO_CLR_CLRP011 = 0x800
	// Position of CLRP012 field.
	GPIO_CLR_CLRP012_Pos = 0xc
	// Bit mask of CLRP012 field.
	GPIO_CLR_CLRP012_Msk = 0x1000
	// Bit CLRP012.
	GPIO_CLR_CLRP012 = 0x1000
	// Position of CLRP013 field.
	GPIO_CLR_CLRP013_Pos = 0xd
	// Bit mask of CLRP013 field.
	GPIO_CLR_CLRP013_Msk = 0x2000
	// Bit CLRP013.
	GPIO_CLR_CLRP013 = 0x2000
	// Position of CLRP014 field.
	GPIO_CLR_CLRP014_Pos = 0xe
	// Bit mask of CLRP014 field.
	GPIO_CLR_CLRP014_Msk = 0x4000
	// Bit CLRP014.
	GPIO_CLR_CLRP014 = 0x4000
	// Position of CLRP015 field.
	GPIO_CLR_CLRP015_Pos = 0xf
	// Bit mask of CLRP015 field.
	GPIO_CLR_CLRP015_Msk = 0x8000
	// Bit CLRP015.
	GPIO_CLR_CLRP015 = 0x8000
	// Position of CLRP016 field.
	GPIO_CLR_CLRP016_Pos = 0x10
	// Bit mask of CLRP016 field.
	GPIO_CLR_CLRP016_Msk = 0x10000
	// Bit CLRP016.
	GPIO_CLR_CLRP016 = 0x10000
	// Position of CLRP017 field.
	GPIO_CLR_CLRP017_Pos = 0x11
	// Bit mask of CLRP017 field.
	GPIO_CLR_CLRP017_Msk = 0x20000
	// Bit CLRP017.
	GPIO_CLR_CLRP017 = 0x20000
	// Position of CLRP018 field.
	GPIO_CLR_CLRP018_Pos = 0x12
	// Bit mask of CLRP018 field.
	GPIO_CLR_CLRP018_Msk = 0x40000
	// Bit CLRP018.
	GPIO_CLR_CLRP018 = 0x40000
	// Position of CLRP019 field.
	GPIO_CLR_CLRP019_Pos = 0x13
	// Bit mask of CLRP019 field.
	GPIO_CLR_CLRP019_Msk = 0x80000
	// Bit CLRP019.
	GPIO_CLR_CLRP019 = 0x80000
	// Position of CLRP020 field.
	GPIO_CLR_CLRP020_Pos = 0x14
	// Bit mask of CLRP020 field.
	GPIO_CLR_CLRP020_Msk = 0x100000
	// Bit CLRP020.
	GPIO_CLR_CLRP020 = 0x100000
	// Position of CLRP021 field.
	GPIO_CLR_CLRP021_Pos = 0x15
	// Bit mask of CLRP021 field.
	GPIO_CLR_CLRP021_Msk = 0x200000
	// Bit CLRP021.
	GPIO_CLR_CLRP021 = 0x200000
	// Position of CLRP022 field.
	GPIO_CLR_CLRP022_Pos = 0x16
	// Bit mask of CLRP022 field.
	GPIO_CLR_CLRP022_Msk = 0x400000
	// Bit CLRP022.
	GPIO_CLR_CLRP022 = 0x400000
	// Position of CLRP023 field.
	GPIO_CLR_CLRP023_Pos = 0x17
	// Bit mask of CLRP023 field.
	GPIO_CLR_CLRP023_Msk = 0x800000
	// Bit CLRP023.
	GPIO_CLR_CLRP023 = 0x800000
	// Position of CLRP024 field.
	GPIO_CLR_CLRP024_Pos = 0x18
	// Bit mask of CLRP024 field.
	GPIO_CLR_CLRP024_Msk = 0x1000000
	// Bit CLRP024.
	GPIO_CLR_CLRP024 = 0x1000000
	// Position of CLRP025 field.
	GPIO_CLR_CLRP025_Pos = 0x19
	// Bit mask of CLRP025 field.
	GPIO_CLR_CLRP025_Msk = 0x2000000
	// Bit CLRP025.
	GPIO_CLR_CLRP025 = 0x2000000
	// Position of CLRP026 field.
	GPIO_CLR_CLRP026_Pos = 0x1a
	// Bit mask of CLRP026 field.
	GPIO_CLR_CLRP026_Msk = 0x4000000
	// Bit CLRP026.
	GPIO_CLR_CLRP026 = 0x4000000
	// Position of CLRP027 field.
	GPIO_CLR_CLRP027_Pos = 0x1b
	// Bit mask of CLRP027 field.
	GPIO_CLR_CLRP027_Msk = 0x8000000
	// Bit CLRP027.
	GPIO_CLR_CLRP027 = 0x8000000
	// Position of CLRP028 field.
	GPIO_CLR_CLRP028_Pos = 0x1c
	// Bit mask of CLRP028 field.
	GPIO_CLR_CLRP028_Msk = 0x10000000
	// Bit CLRP028.
	GPIO_CLR_CLRP028 = 0x10000000
	// Position of CLRP029 field.
	GPIO_CLR_CLRP029_Pos = 0x1d
	// Bit mask of CLRP029 field.
	GPIO_CLR_CLRP029_Msk = 0x20000000
	// Bit CLRP029.
	GPIO_CLR_CLRP029 = 0x20000000
	// Position of CLRP030 field.
	GPIO_CLR_CLRP030_Pos = 0x1e
	// Bit mask of CLRP030 field.
	GPIO_CLR_CLRP030_Msk = 0x40000000
	// Bit CLRP030.
	GPIO_CLR_CLRP030 = 0x40000000
	// Position of CLRP031 field.
	GPIO_CLR_CLRP031_Pos = 0x1f
	// Bit mask of CLRP031 field.
	GPIO_CLR_CLRP031_Msk = 0x80000000
	// Bit CLRP031.
	GPIO_CLR_CLRP031 = 0x80000000

	// NOT: Toggle port
	// Position of NOTP00 field.
	GPIO_NOT_NOTP00_Pos = 0x0
	// Bit mask of NOTP00 field.
	GPIO_NOT_NOTP00_Msk = 0x1
	// Bit NOTP00.
	GPIO_NOT_NOTP00 = 0x1
	// Position of NOTP01 field.
	GPIO_NOT_NOTP01_Pos = 0x1
	// Bit mask of NOTP01 field.
	GPIO_NOT_NOTP01_Msk = 0x2
	// Bit NOTP01.
	GPIO_NOT_NOTP01 = 0x2
	// Position of NOTP02 field.
	GPIO_NOT_NOTP02_Pos = 0x2
	// Bit mask of NOTP02 field.
	GPIO_NOT_NOTP02_Msk = 0x4
	// Bit NOTP02.
	GPIO_NOT_NOTP02 = 0x4
	// Position of NOTP03 field.
	GPIO_NOT_NOTP03_Pos = 0x3
	// Bit mask of NOTP03 field.
	GPIO_NOT_NOTP03_Msk = 0x8
	// Bit NOTP03.
	GPIO_NOT_NOTP03 = 0x8
	// Position of NOTP04 field.
	GPIO_NOT_NOTP04_Pos = 0x4
	// Bit mask of NOTP04 field.
	GPIO_NOT_NOTP04_Msk = 0x10
	// Bit NOTP04.
	GPIO_NOT_NOTP04 = 0x10
	// Position of NOTP05 field.
	GPIO_NOT_NOTP05_Pos = 0x5
	// Bit mask of NOTP05 field.
	GPIO_NOT_NOTP05_Msk = 0x20
	// Bit NOTP05.
	GPIO_NOT_NOTP05 = 0x20
	// Position of NOTP06 field.
	GPIO_NOT_NOTP06_Pos = 0x6
	// Bit mask of NOTP06 field.
	GPIO_NOT_NOTP06_Msk = 0x40
	// Bit NOTP06.
	GPIO_NOT_NOTP06 = 0x40
	// Position of NOTP07 field.
	GPIO_NOT_NOTP07_Pos = 0x7
	// Bit mask of NOTP07 field.
	GPIO_NOT_NOTP07_Msk = 0x80
	// Bit NOTP07.
	GPIO_NOT_NOTP07 = 0x80
	// Position of NOTP08 field.
	GPIO_NOT_NOTP08_Pos = 0x8
	// Bit mask of NOTP08 field.
	GPIO_NOT_NOTP08_Msk = 0x100
	// Bit NOTP08.
	GPIO_NOT_NOTP08 = 0x100
	// Position of NOTP09 field.
	GPIO_NOT_NOTP09_Pos = 0x9
	// Bit mask of NOTP09 field.
	GPIO_NOT_NOTP09_Msk = 0x200
	// Bit NOTP09.
	GPIO_NOT_NOTP09 = 0x200
	// Position of NOTP010 field.
	GPIO_NOT_NOTP010_Pos = 0xa
	// Bit mask of NOTP010 field.
	GPIO_NOT_NOTP010_Msk = 0x400
	// Bit NOTP010.
	GPIO_NOT_NOTP010 = 0x400
	// Position of NOTP011 field.
	GPIO_NOT_NOTP011_Pos = 0xb
	// Bit mask of NOTP011 field.
	GPIO_NOT_NOTP011_Msk = 0x800
	// Bit NOTP011.
	GPIO_NOT_NOTP011 = 0x800
	// Position of NOTP012 field.
	GPIO_NOT_NOTP012_Pos = 0xc
	// Bit mask of NOTP012 field.
	GPIO_NOT_NOTP012_Msk = 0x1000
	// Bit NOTP012.
	GPIO_NOT_NOTP012 = 0x1000
	// Position of NOTP013 field.
	GPIO_NOT_NOTP013_Pos = 0xd
	// Bit mask of NOTP013 field.
	GPIO_NOT_NOTP013_Msk = 0x2000
	// Bit NOTP013.
	GPIO_NOT_NOTP013 = 0x2000
	// Position of NOTP014 field.
	GPIO_NOT_NOTP014_Pos = 0xe
	// Bit mask of NOTP014 field.
	GPIO_NOT_NOTP014_Msk = 0x4000
	// Bit NOTP014.
	GPIO_NOT_NOTP014 = 0x4000
	// Position of NOTP015 field.
	GPIO_NOT_NOTP015_Pos = 0xf
	// Bit mask of NOTP015 field.
	GPIO_NOT_NOTP015_Msk = 0x8000
	// Bit NOTP015.
	GPIO_NOT_NOTP015 = 0x8000
	// Position of NOTP016 field.
	GPIO_NOT_NOTP016_Pos = 0x10
	// Bit mask of NOTP016 field.
	GPIO_NOT_NOTP016_Msk = 0x10000
	// Bit NOTP016.
	GPIO_NOT_NOTP016 = 0x10000
	// Position of NOTP017 field.
	GPIO_NOT_NOTP017_Pos = 0x11
	// Bit mask of NOTP017 field.
	GPIO_NOT_NOTP017_Msk = 0x20000
	// Bit NOTP017.
	GPIO_NOT_NOTP017 = 0x20000
	// Position of NOTP018 field.
	GPIO_NOT_NOTP018_Pos = 0x12
	// Bit mask of NOTP018 field.
	GPIO_NOT_NOTP018_Msk = 0x40000
	// Bit NOTP018.
	GPIO_NOT_NOTP018 = 0x40000
	// Position of NOTP019 field.
	GPIO_NOT_NOTP019_Pos = 0x13
	// Bit mask of NOTP019 field.
	GPIO_NOT_NOTP019_Msk = 0x80000
	// Bit NOTP019.
	GPIO_NOT_NOTP019 = 0x80000
	// Position of NOTP020 field.
	GPIO_NOT_NOTP020_Pos = 0x14
	// Bit mask of NOTP020 field.
	GPIO_NOT_NOTP020_Msk = 0x100000
	// Bit NOTP020.
	GPIO_NOT_NOTP020 = 0x100000
	// Position of NOTP021 field.
	GPIO_NOT_NOTP021_Pos = 0x15
	// Bit mask of NOTP021 field.
	GPIO_NOT_NOTP021_Msk = 0x200000
	// Bit NOTP021.
	GPIO_NOT_NOTP021 = 0x200000
	// Position of NOTP022 field.
	GPIO_NOT_NOTP022_Pos = 0x16
	// Bit mask of NOTP022 field.
	GPIO_NOT_NOTP022_Msk = 0x400000
	// Bit NOTP022.
	GPIO_NOT_NOTP022 = 0x400000
	// Position of NOTP023 field.
	GPIO_NOT_NOTP023_Pos = 0x17
	// Bit mask of NOTP023 field.
	GPIO_NOT_NOTP023_Msk = 0x800000
	// Bit NOTP023.
	GPIO_NOT_NOTP023 = 0x800000
	// Position of NOTP024 field.
	GPIO_NOT_NOTP024_Pos = 0x18
	// Bit mask of NOTP024 field.
	GPIO_NOT_NOTP024_Msk = 0x1000000
	// Bit NOTP024.
	GPIO_NOT_NOTP024 = 0x1000000
	// Position of NOTP025 field.
	GPIO_NOT_NOTP025_Pos = 0x19
	// Bit mask of NOTP025 field.
	GPIO_NOT_NOTP025_Msk = 0x2000000
	// Bit NOTP025.
	GPIO_NOT_NOTP025 = 0x2000000
	// Position of NOTP026 field.
	GPIO_NOT_NOTP026_Pos = 0x1a
	// Bit mask of NOTP026 field.
	GPIO_NOT_NOTP026_Msk = 0x4000000
	// Bit NOTP026.
	GPIO_NOT_NOTP026 = 0x4000000
	// Position of NOTP027 field.
	GPIO_NOT_NOTP027_Pos = 0x1b
	// Bit mask of NOTP027 field.
	GPIO_NOT_NOTP027_Msk = 0x8000000
	// Bit NOTP027.
	GPIO_NOT_NOTP027 = 0x8000000
	// Position of NOTP028 field.
	GPIO_NOT_NOTP028_Pos = 0x1c
	// Bit mask of NOTP028 field.
	GPIO_NOT_NOTP028_Msk = 0x10000000
	// Bit NOTP028.
	GPIO_NOT_NOTP028 = 0x10000000
	// Position of NOTP029 field.
	GPIO_NOT_NOTP029_Pos = 0x1d
	// Bit mask of NOTP029 field.
	GPIO_NOT_NOTP029_Msk = 0x20000000
	// Bit NOTP029.
	GPIO_NOT_NOTP029 = 0x20000000
	// Position of NOTP030 field.
	GPIO_NOT_NOTP030_Pos = 0x1e
	// Bit mask of NOTP030 field.
	GPIO_NOT_NOTP030_Msk = 0x40000000
	// Bit NOTP030.
	GPIO_NOT_NOTP030 = 0x40000000
	// Position of NOTP031 field.
	GPIO_NOT_NOTP031_Pos = 0x1f
	// Bit mask of NOTP031 field.
	GPIO_NOT_NOTP031_Msk = 0x80000000
	// Bit NOTP031.
	GPIO_NOT_NOTP031 = 0x80000000
)

// Bitfields for DMA: DMA controller
const (
	// CTRL: DMA control.
	// Position of ENABLE field.
	DMA_CTRL_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	DMA_CTRL_ENABLE_Msk = 0x1
	// Bit ENABLE.
	DMA_CTRL_ENABLE = 0x1
	// Disabled. The DMA controller is disabled. This clears any triggers that were asserted at the point when disabled, but does not prevent re-triggering when the DMA controller is re-enabled.
	DMA_CTRL_ENABLE_DISABLED = 0x0
	// Enabled. The DMA controller is enabled.
	DMA_CTRL_ENABLE_ENABLED = 0x1
	// Position of RESERVED field.
	DMA_CTRL_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	DMA_CTRL_RESERVED_Msk = 0xfffffffe

	// INTSTAT: Interrupt status.
	// Position of RESERVED field.
	DMA_INTSTAT_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	DMA_INTSTAT_RESERVED_Msk = 0x1
	// Bit RESERVED.
	DMA_INTSTAT_RESERVED = 0x1
	// Position of ACTIVEINT field.
	DMA_INTSTAT_ACTIVEINT_Pos = 0x1
	// Bit mask of ACTIVEINT field.
	DMA_INTSTAT_ACTIVEINT_Msk = 0x2
	// Bit ACTIVEINT.
	DMA_INTSTAT_ACTIVEINT = 0x2
	// Not pending. No enabled interrupts are pending.
	DMA_INTSTAT_ACTIVEINT_NOT_PENDING = 0x0
	// Pending. At least one enabled interrupt is pending.
	DMA_INTSTAT_ACTIVEINT_PENDING = 0x1
	// Position of ACTIVEERRINT field.
	DMA_INTSTAT_ACTIVEERRINT_Pos = 0x2
	// Bit mask of ACTIVEERRINT field.
	DMA_INTSTAT_ACTIVEERRINT_Msk = 0x4
	// Bit ACTIVEERRINT.
	DMA_INTSTAT_ACTIVEERRINT = 0x4
	// Not pending. No error interrupts are pending.
	DMA_INTSTAT_ACTIVEERRINT_NOT_PENDING = 0x0
	// Pending. At least one error interrupt is pending.
	DMA_INTSTAT_ACTIVEERRINT_PENDING = 0x1
	// Position of RESERVED field.
	DMA_INTSTAT_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	DMA_INTSTAT_RESERVED_Msk = 0xfffffff8

	// SRAMBASE: SRAM address of the channel configuration table.
	// Position of RESERVED field.
	DMA_SRAMBASE_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	DMA_SRAMBASE_RESERVED_Msk = 0x3ff
	// Position of OFFSET field.
	DMA_SRAMBASE_OFFSET_Pos = 0xa
	// Bit mask of OFFSET field.
	DMA_SRAMBASE_OFFSET_Msk = 0xfffffc00

	// ENABLESET0: Channel Enable read and Set for all DMA channels.
	// Position of ENA0 field.
	DMA_ENABLESET0_ENA0_Pos = 0x0
	// Bit mask of ENA0 field.
	DMA_ENABLESET0_ENA0_Msk = 0x1
	// Bit ENA0.
	DMA_ENABLESET0_ENA0 = 0x1
	// Position of ENA1 field.
	DMA_ENABLESET0_ENA1_Pos = 0x1
	// Bit mask of ENA1 field.
	DMA_ENABLESET0_ENA1_Msk = 0x2
	// Bit ENA1.
	DMA_ENABLESET0_ENA1 = 0x2
	// Position of ENA2 field.
	DMA_ENABLESET0_ENA2_Pos = 0x2
	// Bit mask of ENA2 field.
	DMA_ENABLESET0_ENA2_Msk = 0x4
	// Bit ENA2.
	DMA_ENABLESET0_ENA2 = 0x4
	// Position of ENA3 field.
	DMA_ENABLESET0_ENA3_Pos = 0x3
	// Bit mask of ENA3 field.
	DMA_ENABLESET0_ENA3_Msk = 0x8
	// Bit ENA3.
	DMA_ENABLESET0_ENA3 = 0x8
	// Position of ENA4 field.
	DMA_ENABLESET0_ENA4_Pos = 0x4
	// Bit mask of ENA4 field.
	DMA_ENABLESET0_ENA4_Msk = 0x10
	// Bit ENA4.
	DMA_ENABLESET0_ENA4 = 0x10
	// Position of ENA5 field.
	DMA_ENABLESET0_ENA5_Pos = 0x5
	// Bit mask of ENA5 field.
	DMA_ENABLESET0_ENA5_Msk = 0x20
	// Bit ENA5.
	DMA_ENABLESET0_ENA5 = 0x20
	// Position of ENA6 field.
	DMA_ENABLESET0_ENA6_Pos = 0x6
	// Bit mask of ENA6 field.
	DMA_ENABLESET0_ENA6_Msk = 0x40
	// Bit ENA6.
	DMA_ENABLESET0_ENA6 = 0x40
	// Position of ENA7 field.
	DMA_ENABLESET0_ENA7_Pos = 0x7
	// Bit mask of ENA7 field.
	DMA_ENABLESET0_ENA7_Msk = 0x80
	// Bit ENA7.
	DMA_ENABLESET0_ENA7 = 0x80
	// Position of ENA8 field.
	DMA_ENABLESET0_ENA8_Pos = 0x8
	// Bit mask of ENA8 field.
	DMA_ENABLESET0_ENA8_Msk = 0x100
	// Bit ENA8.
	DMA_ENABLESET0_ENA8 = 0x100
	// Position of ENA9 field.
	DMA_ENABLESET0_ENA9_Pos = 0x9
	// Bit mask of ENA9 field.
	DMA_ENABLESET0_ENA9_Msk = 0x200
	// Bit ENA9.
	DMA_ENABLESET0_ENA9 = 0x200
	// Position of ENA10 field.
	DMA_ENABLESET0_ENA10_Pos = 0xa
	// Bit mask of ENA10 field.
	DMA_ENABLESET0_ENA10_Msk = 0x400
	// Bit ENA10.
	DMA_ENABLESET0_ENA10 = 0x400
	// Position of ENA11 field.
	DMA_ENABLESET0_ENA11_Pos = 0xb
	// Bit mask of ENA11 field.
	DMA_ENABLESET0_ENA11_Msk = 0x800
	// Bit ENA11.
	DMA_ENABLESET0_ENA11 = 0x800
	// Position of ENA12 field.
	DMA_ENABLESET0_ENA12_Pos = 0xc
	// Bit mask of ENA12 field.
	DMA_ENABLESET0_ENA12_Msk = 0x1000
	// Bit ENA12.
	DMA_ENABLESET0_ENA12 = 0x1000
	// Position of ENA13 field.
	DMA_ENABLESET0_ENA13_Pos = 0xd
	// Bit mask of ENA13 field.
	DMA_ENABLESET0_ENA13_Msk = 0x2000
	// Bit ENA13.
	DMA_ENABLESET0_ENA13 = 0x2000
	// Position of ENA14 field.
	DMA_ENABLESET0_ENA14_Pos = 0xe
	// Bit mask of ENA14 field.
	DMA_ENABLESET0_ENA14_Msk = 0x4000
	// Bit ENA14.
	DMA_ENABLESET0_ENA14 = 0x4000
	// Position of ENA15 field.
	DMA_ENABLESET0_ENA15_Pos = 0xf
	// Bit mask of ENA15 field.
	DMA_ENABLESET0_ENA15_Msk = 0x8000
	// Bit ENA15.
	DMA_ENABLESET0_ENA15 = 0x8000
	// Position of ENA16 field.
	DMA_ENABLESET0_ENA16_Pos = 0x10
	// Bit mask of ENA16 field.
	DMA_ENABLESET0_ENA16_Msk = 0x10000
	// Bit ENA16.
	DMA_ENABLESET0_ENA16 = 0x10000
	// Position of ENA17 field.
	DMA_ENABLESET0_ENA17_Pos = 0x11
	// Bit mask of ENA17 field.
	DMA_ENABLESET0_ENA17_Msk = 0x20000
	// Bit ENA17.
	DMA_ENABLESET0_ENA17 = 0x20000
	// Position of RESERVED field.
	DMA_ENABLESET0_RESERVED_Pos = 0x12
	// Bit mask of RESERVED field.
	DMA_ENABLESET0_RESERVED_Msk = 0xfffc0000

	// ENABLECLR0: Channel Enable Clear for all DMA channels.
	// Position of CLR0 field.
	DMA_ENABLECLR0_CLR0_Pos = 0x0
	// Bit mask of CLR0 field.
	DMA_ENABLECLR0_CLR0_Msk = 0x1
	// Bit CLR0.
	DMA_ENABLECLR0_CLR0 = 0x1
	// Position of CLR1 field.
	DMA_ENABLECLR0_CLR1_Pos = 0x1
	// Bit mask of CLR1 field.
	DMA_ENABLECLR0_CLR1_Msk = 0x2
	// Bit CLR1.
	DMA_ENABLECLR0_CLR1 = 0x2
	// Position of CLR2 field.
	DMA_ENABLECLR0_CLR2_Pos = 0x2
	// Bit mask of CLR2 field.
	DMA_ENABLECLR0_CLR2_Msk = 0x4
	// Bit CLR2.
	DMA_ENABLECLR0_CLR2 = 0x4
	// Position of CLR3 field.
	DMA_ENABLECLR0_CLR3_Pos = 0x3
	// Bit mask of CLR3 field.
	DMA_ENABLECLR0_CLR3_Msk = 0x8
	// Bit CLR3.
	DMA_ENABLECLR0_CLR3 = 0x8
	// Position of CLR4 field.
	DMA_ENABLECLR0_CLR4_Pos = 0x4
	// Bit mask of CLR4 field.
	DMA_ENABLECLR0_CLR4_Msk = 0x10
	// Bit CLR4.
	DMA_ENABLECLR0_CLR4 = 0x10
	// Position of CLR5 field.
	DMA_ENABLECLR0_CLR5_Pos = 0x5
	// Bit mask of CLR5 field.
	DMA_ENABLECLR0_CLR5_Msk = 0x20
	// Bit CLR5.
	DMA_ENABLECLR0_CLR5 = 0x20
	// Position of CLR6 field.
	DMA_ENABLECLR0_CLR6_Pos = 0x6
	// Bit mask of CLR6 field.
	DMA_ENABLECLR0_CLR6_Msk = 0x40
	// Bit CLR6.
	DMA_ENABLECLR0_CLR6 = 0x40
	// Position of CLR7 field.
	DMA_ENABLECLR0_CLR7_Pos = 0x7
	// Bit mask of CLR7 field.
	DMA_ENABLECLR0_CLR7_Msk = 0x80
	// Bit CLR7.
	DMA_ENABLECLR0_CLR7 = 0x80
	// Position of CLR8 field.
	DMA_ENABLECLR0_CLR8_Pos = 0x8
	// Bit mask of CLR8 field.
	DMA_ENABLECLR0_CLR8_Msk = 0x100
	// Bit CLR8.
	DMA_ENABLECLR0_CLR8 = 0x100
	// Position of CLR9 field.
	DMA_ENABLECLR0_CLR9_Pos = 0x9
	// Bit mask of CLR9 field.
	DMA_ENABLECLR0_CLR9_Msk = 0x200
	// Bit CLR9.
	DMA_ENABLECLR0_CLR9 = 0x200
	// Position of CLR10 field.
	DMA_ENABLECLR0_CLR10_Pos = 0xa
	// Bit mask of CLR10 field.
	DMA_ENABLECLR0_CLR10_Msk = 0x400
	// Bit CLR10.
	DMA_ENABLECLR0_CLR10 = 0x400
	// Position of CLR11 field.
	DMA_ENABLECLR0_CLR11_Pos = 0xb
	// Bit mask of CLR11 field.
	DMA_ENABLECLR0_CLR11_Msk = 0x800
	// Bit CLR11.
	DMA_ENABLECLR0_CLR11 = 0x800
	// Position of CLR12 field.
	DMA_ENABLECLR0_CLR12_Pos = 0xc
	// Bit mask of CLR12 field.
	DMA_ENABLECLR0_CLR12_Msk = 0x1000
	// Bit CLR12.
	DMA_ENABLECLR0_CLR12 = 0x1000
	// Position of CLR13 field.
	DMA_ENABLECLR0_CLR13_Pos = 0xd
	// Bit mask of CLR13 field.
	DMA_ENABLECLR0_CLR13_Msk = 0x2000
	// Bit CLR13.
	DMA_ENABLECLR0_CLR13 = 0x2000
	// Position of CLR14 field.
	DMA_ENABLECLR0_CLR14_Pos = 0xe
	// Bit mask of CLR14 field.
	DMA_ENABLECLR0_CLR14_Msk = 0x4000
	// Bit CLR14.
	DMA_ENABLECLR0_CLR14 = 0x4000
	// Position of CLR15 field.
	DMA_ENABLECLR0_CLR15_Pos = 0xf
	// Bit mask of CLR15 field.
	DMA_ENABLECLR0_CLR15_Msk = 0x8000
	// Bit CLR15.
	DMA_ENABLECLR0_CLR15 = 0x8000
	// Position of CLR16 field.
	DMA_ENABLECLR0_CLR16_Pos = 0x10
	// Bit mask of CLR16 field.
	DMA_ENABLECLR0_CLR16_Msk = 0x10000
	// Bit CLR16.
	DMA_ENABLECLR0_CLR16 = 0x10000
	// Position of CLR17 field.
	DMA_ENABLECLR0_CLR17_Pos = 0x11
	// Bit mask of CLR17 field.
	DMA_ENABLECLR0_CLR17_Msk = 0x20000
	// Bit CLR17.
	DMA_ENABLECLR0_CLR17 = 0x20000
	// Position of RESERVED field.
	DMA_ENABLECLR0_RESERVED_Pos = 0x12
	// Bit mask of RESERVED field.
	DMA_ENABLECLR0_RESERVED_Msk = 0xfffc0000

	// ACTIVE0: Channel Active status for all DMA channels.
	// Position of ACT0 field.
	DMA_ACTIVE0_ACT0_Pos = 0x0
	// Bit mask of ACT0 field.
	DMA_ACTIVE0_ACT0_Msk = 0x1
	// Bit ACT0.
	DMA_ACTIVE0_ACT0 = 0x1
	// Position of ACT1 field.
	DMA_ACTIVE0_ACT1_Pos = 0x1
	// Bit mask of ACT1 field.
	DMA_ACTIVE0_ACT1_Msk = 0x2
	// Bit ACT1.
	DMA_ACTIVE0_ACT1 = 0x2
	// Position of ACT2 field.
	DMA_ACTIVE0_ACT2_Pos = 0x2
	// Bit mask of ACT2 field.
	DMA_ACTIVE0_ACT2_Msk = 0x4
	// Bit ACT2.
	DMA_ACTIVE0_ACT2 = 0x4
	// Position of ACT3 field.
	DMA_ACTIVE0_ACT3_Pos = 0x3
	// Bit mask of ACT3 field.
	DMA_ACTIVE0_ACT3_Msk = 0x8
	// Bit ACT3.
	DMA_ACTIVE0_ACT3 = 0x8
	// Position of ACT4 field.
	DMA_ACTIVE0_ACT4_Pos = 0x4
	// Bit mask of ACT4 field.
	DMA_ACTIVE0_ACT4_Msk = 0x10
	// Bit ACT4.
	DMA_ACTIVE0_ACT4 = 0x10
	// Position of ACT5 field.
	DMA_ACTIVE0_ACT5_Pos = 0x5
	// Bit mask of ACT5 field.
	DMA_ACTIVE0_ACT5_Msk = 0x20
	// Bit ACT5.
	DMA_ACTIVE0_ACT5 = 0x20
	// Position of ACT6 field.
	DMA_ACTIVE0_ACT6_Pos = 0x6
	// Bit mask of ACT6 field.
	DMA_ACTIVE0_ACT6_Msk = 0x40
	// Bit ACT6.
	DMA_ACTIVE0_ACT6 = 0x40
	// Position of ACT7 field.
	DMA_ACTIVE0_ACT7_Pos = 0x7
	// Bit mask of ACT7 field.
	DMA_ACTIVE0_ACT7_Msk = 0x80
	// Bit ACT7.
	DMA_ACTIVE0_ACT7 = 0x80
	// Position of ACT8 field.
	DMA_ACTIVE0_ACT8_Pos = 0x8
	// Bit mask of ACT8 field.
	DMA_ACTIVE0_ACT8_Msk = 0x100
	// Bit ACT8.
	DMA_ACTIVE0_ACT8 = 0x100
	// Position of ACT9 field.
	DMA_ACTIVE0_ACT9_Pos = 0x9
	// Bit mask of ACT9 field.
	DMA_ACTIVE0_ACT9_Msk = 0x200
	// Bit ACT9.
	DMA_ACTIVE0_ACT9 = 0x200
	// Position of ACT10 field.
	DMA_ACTIVE0_ACT10_Pos = 0xa
	// Bit mask of ACT10 field.
	DMA_ACTIVE0_ACT10_Msk = 0x400
	// Bit ACT10.
	DMA_ACTIVE0_ACT10 = 0x400
	// Position of ACT11 field.
	DMA_ACTIVE0_ACT11_Pos = 0xb
	// Bit mask of ACT11 field.
	DMA_ACTIVE0_ACT11_Msk = 0x800
	// Bit ACT11.
	DMA_ACTIVE0_ACT11 = 0x800
	// Position of ACT12 field.
	DMA_ACTIVE0_ACT12_Pos = 0xc
	// Bit mask of ACT12 field.
	DMA_ACTIVE0_ACT12_Msk = 0x1000
	// Bit ACT12.
	DMA_ACTIVE0_ACT12 = 0x1000
	// Position of ACT13 field.
	DMA_ACTIVE0_ACT13_Pos = 0xd
	// Bit mask of ACT13 field.
	DMA_ACTIVE0_ACT13_Msk = 0x2000
	// Bit ACT13.
	DMA_ACTIVE0_ACT13 = 0x2000
	// Position of ACT14 field.
	DMA_ACTIVE0_ACT14_Pos = 0xe
	// Bit mask of ACT14 field.
	DMA_ACTIVE0_ACT14_Msk = 0x4000
	// Bit ACT14.
	DMA_ACTIVE0_ACT14 = 0x4000
	// Position of ACT15 field.
	DMA_ACTIVE0_ACT15_Pos = 0xf
	// Bit mask of ACT15 field.
	DMA_ACTIVE0_ACT15_Msk = 0x8000
	// Bit ACT15.
	DMA_ACTIVE0_ACT15 = 0x8000
	// Position of ACT16 field.
	DMA_ACTIVE0_ACT16_Pos = 0x10
	// Bit mask of ACT16 field.
	DMA_ACTIVE0_ACT16_Msk = 0x10000
	// Bit ACT16.
	DMA_ACTIVE0_ACT16 = 0x10000
	// Position of ACT17 field.
	DMA_ACTIVE0_ACT17_Pos = 0x11
	// Bit mask of ACT17 field.
	DMA_ACTIVE0_ACT17_Msk = 0x20000
	// Bit ACT17.
	DMA_ACTIVE0_ACT17 = 0x20000
	// Position of RESERVED field.
	DMA_ACTIVE0_RESERVED_Pos = 0x12
	// Bit mask of RESERVED field.
	DMA_ACTIVE0_RESERVED_Msk = 0xfffc0000

	// BUSY0: Channel Busy status for all DMA channels.
	// Position of BSY0 field.
	DMA_BUSY0_BSY0_Pos = 0x0
	// Bit mask of BSY0 field.
	DMA_BUSY0_BSY0_Msk = 0x1
	// Bit BSY0.
	DMA_BUSY0_BSY0 = 0x1
	// Position of BSY1 field.
	DMA_BUSY0_BSY1_Pos = 0x1
	// Bit mask of BSY1 field.
	DMA_BUSY0_BSY1_Msk = 0x2
	// Bit BSY1.
	DMA_BUSY0_BSY1 = 0x2
	// Position of BSY2 field.
	DMA_BUSY0_BSY2_Pos = 0x2
	// Bit mask of BSY2 field.
	DMA_BUSY0_BSY2_Msk = 0x4
	// Bit BSY2.
	DMA_BUSY0_BSY2 = 0x4
	// Position of BSY3 field.
	DMA_BUSY0_BSY3_Pos = 0x3
	// Bit mask of BSY3 field.
	DMA_BUSY0_BSY3_Msk = 0x8
	// Bit BSY3.
	DMA_BUSY0_BSY3 = 0x8
	// Position of BSY4 field.
	DMA_BUSY0_BSY4_Pos = 0x4
	// Bit mask of BSY4 field.
	DMA_BUSY0_BSY4_Msk = 0x10
	// Bit BSY4.
	DMA_BUSY0_BSY4 = 0x10
	// Position of BSY5 field.
	DMA_BUSY0_BSY5_Pos = 0x5
	// Bit mask of BSY5 field.
	DMA_BUSY0_BSY5_Msk = 0x20
	// Bit BSY5.
	DMA_BUSY0_BSY5 = 0x20
	// Position of BSY6 field.
	DMA_BUSY0_BSY6_Pos = 0x6
	// Bit mask of BSY6 field.
	DMA_BUSY0_BSY6_Msk = 0x40
	// Bit BSY6.
	DMA_BUSY0_BSY6 = 0x40
	// Position of BSY7 field.
	DMA_BUSY0_BSY7_Pos = 0x7
	// Bit mask of BSY7 field.
	DMA_BUSY0_BSY7_Msk = 0x80
	// Bit BSY7.
	DMA_BUSY0_BSY7 = 0x80
	// Position of BSY8 field.
	DMA_BUSY0_BSY8_Pos = 0x8
	// Bit mask of BSY8 field.
	DMA_BUSY0_BSY8_Msk = 0x100
	// Bit BSY8.
	DMA_BUSY0_BSY8 = 0x100
	// Position of BSY9 field.
	DMA_BUSY0_BSY9_Pos = 0x9
	// Bit mask of BSY9 field.
	DMA_BUSY0_BSY9_Msk = 0x200
	// Bit BSY9.
	DMA_BUSY0_BSY9 = 0x200
	// Position of BSY10 field.
	DMA_BUSY0_BSY10_Pos = 0xa
	// Bit mask of BSY10 field.
	DMA_BUSY0_BSY10_Msk = 0x400
	// Bit BSY10.
	DMA_BUSY0_BSY10 = 0x400
	// Position of BSY11 field.
	DMA_BUSY0_BSY11_Pos = 0xb
	// Bit mask of BSY11 field.
	DMA_BUSY0_BSY11_Msk = 0x800
	// Bit BSY11.
	DMA_BUSY0_BSY11 = 0x800
	// Position of BSY12 field.
	DMA_BUSY0_BSY12_Pos = 0xc
	// Bit mask of BSY12 field.
	DMA_BUSY0_BSY12_Msk = 0x1000
	// Bit BSY12.
	DMA_BUSY0_BSY12 = 0x1000
	// Position of BSY13 field.
	DMA_BUSY0_BSY13_Pos = 0xd
	// Bit mask of BSY13 field.
	DMA_BUSY0_BSY13_Msk = 0x2000
	// Bit BSY13.
	DMA_BUSY0_BSY13 = 0x2000
	// Position of BSY14 field.
	DMA_BUSY0_BSY14_Pos = 0xe
	// Bit mask of BSY14 field.
	DMA_BUSY0_BSY14_Msk = 0x4000
	// Bit BSY14.
	DMA_BUSY0_BSY14 = 0x4000
	// Position of BSY15 field.
	DMA_BUSY0_BSY15_Pos = 0xf
	// Bit mask of BSY15 field.
	DMA_BUSY0_BSY15_Msk = 0x8000
	// Bit BSY15.
	DMA_BUSY0_BSY15 = 0x8000
	// Position of BSY16 field.
	DMA_BUSY0_BSY16_Pos = 0x10
	// Bit mask of BSY16 field.
	DMA_BUSY0_BSY16_Msk = 0x10000
	// Bit BSY16.
	DMA_BUSY0_BSY16 = 0x10000
	// Position of BSY17 field.
	DMA_BUSY0_BSY17_Pos = 0x11
	// Bit mask of BSY17 field.
	DMA_BUSY0_BSY17_Msk = 0x20000
	// Bit BSY17.
	DMA_BUSY0_BSY17 = 0x20000
	// Position of RESERVED field.
	DMA_BUSY0_RESERVED_Pos = 0x12
	// Bit mask of RESERVED field.
	DMA_BUSY0_RESERVED_Msk = 0xfffc0000

	// ERRINT0: Error Interrupt status for all DMA channels.
	// Position of ERR0 field.
	DMA_ERRINT0_ERR0_Pos = 0x0
	// Bit mask of ERR0 field.
	DMA_ERRINT0_ERR0_Msk = 0x1
	// Bit ERR0.
	DMA_ERRINT0_ERR0 = 0x1
	// Position of ERR1 field.
	DMA_ERRINT0_ERR1_Pos = 0x1
	// Bit mask of ERR1 field.
	DMA_ERRINT0_ERR1_Msk = 0x2
	// Bit ERR1.
	DMA_ERRINT0_ERR1 = 0x2
	// Position of ERR2 field.
	DMA_ERRINT0_ERR2_Pos = 0x2
	// Bit mask of ERR2 field.
	DMA_ERRINT0_ERR2_Msk = 0x4
	// Bit ERR2.
	DMA_ERRINT0_ERR2 = 0x4
	// Position of ERR3 field.
	DMA_ERRINT0_ERR3_Pos = 0x3
	// Bit mask of ERR3 field.
	DMA_ERRINT0_ERR3_Msk = 0x8
	// Bit ERR3.
	DMA_ERRINT0_ERR3 = 0x8
	// Position of ERR4 field.
	DMA_ERRINT0_ERR4_Pos = 0x4
	// Bit mask of ERR4 field.
	DMA_ERRINT0_ERR4_Msk = 0x10
	// Bit ERR4.
	DMA_ERRINT0_ERR4 = 0x10
	// Position of ERR5 field.
	DMA_ERRINT0_ERR5_Pos = 0x5
	// Bit mask of ERR5 field.
	DMA_ERRINT0_ERR5_Msk = 0x20
	// Bit ERR5.
	DMA_ERRINT0_ERR5 = 0x20
	// Position of ERR6 field.
	DMA_ERRINT0_ERR6_Pos = 0x6
	// Bit mask of ERR6 field.
	DMA_ERRINT0_ERR6_Msk = 0x40
	// Bit ERR6.
	DMA_ERRINT0_ERR6 = 0x40
	// Position of ERR7 field.
	DMA_ERRINT0_ERR7_Pos = 0x7
	// Bit mask of ERR7 field.
	DMA_ERRINT0_ERR7_Msk = 0x80
	// Bit ERR7.
	DMA_ERRINT0_ERR7 = 0x80
	// Position of ERR8 field.
	DMA_ERRINT0_ERR8_Pos = 0x8
	// Bit mask of ERR8 field.
	DMA_ERRINT0_ERR8_Msk = 0x100
	// Bit ERR8.
	DMA_ERRINT0_ERR8 = 0x100
	// Position of ERR9 field.
	DMA_ERRINT0_ERR9_Pos = 0x9
	// Bit mask of ERR9 field.
	DMA_ERRINT0_ERR9_Msk = 0x200
	// Bit ERR9.
	DMA_ERRINT0_ERR9 = 0x200
	// Position of ERR10 field.
	DMA_ERRINT0_ERR10_Pos = 0xa
	// Bit mask of ERR10 field.
	DMA_ERRINT0_ERR10_Msk = 0x400
	// Bit ERR10.
	DMA_ERRINT0_ERR10 = 0x400
	// Position of ERR11 field.
	DMA_ERRINT0_ERR11_Pos = 0xb
	// Bit mask of ERR11 field.
	DMA_ERRINT0_ERR11_Msk = 0x800
	// Bit ERR11.
	DMA_ERRINT0_ERR11 = 0x800
	// Position of ERR12 field.
	DMA_ERRINT0_ERR12_Pos = 0xc
	// Bit mask of ERR12 field.
	DMA_ERRINT0_ERR12_Msk = 0x1000
	// Bit ERR12.
	DMA_ERRINT0_ERR12 = 0x1000
	// Position of ERR13 field.
	DMA_ERRINT0_ERR13_Pos = 0xd
	// Bit mask of ERR13 field.
	DMA_ERRINT0_ERR13_Msk = 0x2000
	// Bit ERR13.
	DMA_ERRINT0_ERR13 = 0x2000
	// Position of ERR14 field.
	DMA_ERRINT0_ERR14_Pos = 0xe
	// Bit mask of ERR14 field.
	DMA_ERRINT0_ERR14_Msk = 0x4000
	// Bit ERR14.
	DMA_ERRINT0_ERR14 = 0x4000
	// Position of ERR15 field.
	DMA_ERRINT0_ERR15_Pos = 0xf
	// Bit mask of ERR15 field.
	DMA_ERRINT0_ERR15_Msk = 0x8000
	// Bit ERR15.
	DMA_ERRINT0_ERR15 = 0x8000
	// Position of ERR16 field.
	DMA_ERRINT0_ERR16_Pos = 0x10
	// Bit mask of ERR16 field.
	DMA_ERRINT0_ERR16_Msk = 0x10000
	// Bit ERR16.
	DMA_ERRINT0_ERR16 = 0x10000
	// Position of ERR17 field.
	DMA_ERRINT0_ERR17_Pos = 0x11
	// Bit mask of ERR17 field.
	DMA_ERRINT0_ERR17_Msk = 0x20000
	// Bit ERR17.
	DMA_ERRINT0_ERR17 = 0x20000
	// Position of RESERVED field.
	DMA_ERRINT0_RESERVED_Pos = 0x12
	// Bit mask of RESERVED field.
	DMA_ERRINT0_RESERVED_Msk = 0xfffc0000

	// INTENSET0: Interrupt Enable read and Set for all DMA channels.
	// Position of SET0 field.
	DMA_INTENSET0_SET0_Pos = 0x0
	// Bit mask of SET0 field.
	DMA_INTENSET0_SET0_Msk = 0x1
	// Bit SET0.
	DMA_INTENSET0_SET0 = 0x1
	// Position of SET1 field.
	DMA_INTENSET0_SET1_Pos = 0x1
	// Bit mask of SET1 field.
	DMA_INTENSET0_SET1_Msk = 0x2
	// Bit SET1.
	DMA_INTENSET0_SET1 = 0x2
	// Position of SET2 field.
	DMA_INTENSET0_SET2_Pos = 0x2
	// Bit mask of SET2 field.
	DMA_INTENSET0_SET2_Msk = 0x4
	// Bit SET2.
	DMA_INTENSET0_SET2 = 0x4
	// Position of SET3 field.
	DMA_INTENSET0_SET3_Pos = 0x3
	// Bit mask of SET3 field.
	DMA_INTENSET0_SET3_Msk = 0x8
	// Bit SET3.
	DMA_INTENSET0_SET3 = 0x8
	// Position of SET4 field.
	DMA_INTENSET0_SET4_Pos = 0x4
	// Bit mask of SET4 field.
	DMA_INTENSET0_SET4_Msk = 0x10
	// Bit SET4.
	DMA_INTENSET0_SET4 = 0x10
	// Position of SET5 field.
	DMA_INTENSET0_SET5_Pos = 0x5
	// Bit mask of SET5 field.
	DMA_INTENSET0_SET5_Msk = 0x20
	// Bit SET5.
	DMA_INTENSET0_SET5 = 0x20
	// Position of SET6 field.
	DMA_INTENSET0_SET6_Pos = 0x6
	// Bit mask of SET6 field.
	DMA_INTENSET0_SET6_Msk = 0x40
	// Bit SET6.
	DMA_INTENSET0_SET6 = 0x40
	// Position of SET7 field.
	DMA_INTENSET0_SET7_Pos = 0x7
	// Bit mask of SET7 field.
	DMA_INTENSET0_SET7_Msk = 0x80
	// Bit SET7.
	DMA_INTENSET0_SET7 = 0x80
	// Position of SET8 field.
	DMA_INTENSET0_SET8_Pos = 0x8
	// Bit mask of SET8 field.
	DMA_INTENSET0_SET8_Msk = 0x100
	// Bit SET8.
	DMA_INTENSET0_SET8 = 0x100
	// Position of SET9 field.
	DMA_INTENSET0_SET9_Pos = 0x9
	// Bit mask of SET9 field.
	DMA_INTENSET0_SET9_Msk = 0x200
	// Bit SET9.
	DMA_INTENSET0_SET9 = 0x200
	// Position of SET10 field.
	DMA_INTENSET0_SET10_Pos = 0xa
	// Bit mask of SET10 field.
	DMA_INTENSET0_SET10_Msk = 0x400
	// Bit SET10.
	DMA_INTENSET0_SET10 = 0x400
	// Position of SET11 field.
	DMA_INTENSET0_SET11_Pos = 0xb
	// Bit mask of SET11 field.
	DMA_INTENSET0_SET11_Msk = 0x800
	// Bit SET11.
	DMA_INTENSET0_SET11 = 0x800
	// Position of SET12 field.
	DMA_INTENSET0_SET12_Pos = 0xc
	// Bit mask of SET12 field.
	DMA_INTENSET0_SET12_Msk = 0x1000
	// Bit SET12.
	DMA_INTENSET0_SET12 = 0x1000
	// Position of SET13 field.
	DMA_INTENSET0_SET13_Pos = 0xd
	// Bit mask of SET13 field.
	DMA_INTENSET0_SET13_Msk = 0x2000
	// Bit SET13.
	DMA_INTENSET0_SET13 = 0x2000
	// Position of SET14 field.
	DMA_INTENSET0_SET14_Pos = 0xe
	// Bit mask of SET14 field.
	DMA_INTENSET0_SET14_Msk = 0x4000
	// Bit SET14.
	DMA_INTENSET0_SET14 = 0x4000
	// Position of SET15 field.
	DMA_INTENSET0_SET15_Pos = 0xf
	// Bit mask of SET15 field.
	DMA_INTENSET0_SET15_Msk = 0x8000
	// Bit SET15.
	DMA_INTENSET0_SET15 = 0x8000
	// Position of SET16 field.
	DMA_INTENSET0_SET16_Pos = 0x10
	// Bit mask of SET16 field.
	DMA_INTENSET0_SET16_Msk = 0x10000
	// Bit SET16.
	DMA_INTENSET0_SET16 = 0x10000
	// Position of SET17 field.
	DMA_INTENSET0_SET17_Pos = 0x11
	// Bit mask of SET17 field.
	DMA_INTENSET0_SET17_Msk = 0x20000
	// Bit SET17.
	DMA_INTENSET0_SET17 = 0x20000
	// Position of RESERVED field.
	DMA_INTENSET0_RESERVED_Pos = 0x12
	// Bit mask of RESERVED field.
	DMA_INTENSET0_RESERVED_Msk = 0xfffc0000

	// INTENCLR0: Interrupt Enable Clear for all DMA channels.
	// Position of CLR0 field.
	DMA_INTENCLR0_CLR0_Pos = 0x0
	// Bit mask of CLR0 field.
	DMA_INTENCLR0_CLR0_Msk = 0x1
	// Bit CLR0.
	DMA_INTENCLR0_CLR0 = 0x1
	// Position of CLR1 field.
	DMA_INTENCLR0_CLR1_Pos = 0x1
	// Bit mask of CLR1 field.
	DMA_INTENCLR0_CLR1_Msk = 0x2
	// Bit CLR1.
	DMA_INTENCLR0_CLR1 = 0x2
	// Position of CLR2 field.
	DMA_INTENCLR0_CLR2_Pos = 0x2
	// Bit mask of CLR2 field.
	DMA_INTENCLR0_CLR2_Msk = 0x4
	// Bit CLR2.
	DMA_INTENCLR0_CLR2 = 0x4
	// Position of CLR3 field.
	DMA_INTENCLR0_CLR3_Pos = 0x3
	// Bit mask of CLR3 field.
	DMA_INTENCLR0_CLR3_Msk = 0x8
	// Bit CLR3.
	DMA_INTENCLR0_CLR3 = 0x8
	// Position of CLR4 field.
	DMA_INTENCLR0_CLR4_Pos = 0x4
	// Bit mask of CLR4 field.
	DMA_INTENCLR0_CLR4_Msk = 0x10
	// Bit CLR4.
	DMA_INTENCLR0_CLR4 = 0x10
	// Position of CLR5 field.
	DMA_INTENCLR0_CLR5_Pos = 0x5
	// Bit mask of CLR5 field.
	DMA_INTENCLR0_CLR5_Msk = 0x20
	// Bit CLR5.
	DMA_INTENCLR0_CLR5 = 0x20
	// Position of CLR6 field.
	DMA_INTENCLR0_CLR6_Pos = 0x6
	// Bit mask of CLR6 field.
	DMA_INTENCLR0_CLR6_Msk = 0x40
	// Bit CLR6.
	DMA_INTENCLR0_CLR6 = 0x40
	// Position of CLR7 field.
	DMA_INTENCLR0_CLR7_Pos = 0x7
	// Bit mask of CLR7 field.
	DMA_INTENCLR0_CLR7_Msk = 0x80
	// Bit CLR7.
	DMA_INTENCLR0_CLR7 = 0x80
	// Position of CLR8 field.
	DMA_INTENCLR0_CLR8_Pos = 0x8
	// Bit mask of CLR8 field.
	DMA_INTENCLR0_CLR8_Msk = 0x100
	// Bit CLR8.
	DMA_INTENCLR0_CLR8 = 0x100
	// Position of CLR9 field.
	DMA_INTENCLR0_CLR9_Pos = 0x9
	// Bit mask of CLR9 field.
	DMA_INTENCLR0_CLR9_Msk = 0x200
	// Bit CLR9.
	DMA_INTENCLR0_CLR9 = 0x200
	// Position of CLR10 field.
	DMA_INTENCLR0_CLR10_Pos = 0xa
	// Bit mask of CLR10 field.
	DMA_INTENCLR0_CLR10_Msk = 0x400
	// Bit CLR10.
	DMA_INTENCLR0_CLR10 = 0x400
	// Position of CLR11 field.
	DMA_INTENCLR0_CLR11_Pos = 0xb
	// Bit mask of CLR11 field.
	DMA_INTENCLR0_CLR11_Msk = 0x800
	// Bit CLR11.
	DMA_INTENCLR0_CLR11 = 0x800
	// Position of CLR12 field.
	DMA_INTENCLR0_CLR12_Pos = 0xc
	// Bit mask of CLR12 field.
	DMA_INTENCLR0_CLR12_Msk = 0x1000
	// Bit CLR12.
	DMA_INTENCLR0_CLR12 = 0x1000
	// Position of CLR13 field.
	DMA_INTENCLR0_CLR13_Pos = 0xd
	// Bit mask of CLR13 field.
	DMA_INTENCLR0_CLR13_Msk = 0x2000
	// Bit CLR13.
	DMA_INTENCLR0_CLR13 = 0x2000
	// Position of CLR14 field.
	DMA_INTENCLR0_CLR14_Pos = 0xe
	// Bit mask of CLR14 field.
	DMA_INTENCLR0_CLR14_Msk = 0x4000
	// Bit CLR14.
	DMA_INTENCLR0_CLR14 = 0x4000
	// Position of CLR15 field.
	DMA_INTENCLR0_CLR15_Pos = 0xf
	// Bit mask of CLR15 field.
	DMA_INTENCLR0_CLR15_Msk = 0x8000
	// Bit CLR15.
	DMA_INTENCLR0_CLR15 = 0x8000
	// Position of CLR16 field.
	DMA_INTENCLR0_CLR16_Pos = 0x10
	// Bit mask of CLR16 field.
	DMA_INTENCLR0_CLR16_Msk = 0x10000
	// Bit CLR16.
	DMA_INTENCLR0_CLR16 = 0x10000
	// Position of CLR17 field.
	DMA_INTENCLR0_CLR17_Pos = 0x11
	// Bit mask of CLR17 field.
	DMA_INTENCLR0_CLR17_Msk = 0x20000
	// Bit CLR17.
	DMA_INTENCLR0_CLR17 = 0x20000
	// Position of RESERVED field.
	DMA_INTENCLR0_RESERVED_Pos = 0x12
	// Bit mask of RESERVED field.
	DMA_INTENCLR0_RESERVED_Msk = 0xfffc0000

	// INTA0: Interrupt A status for all DMA channels.
	// Position of IA0 field.
	DMA_INTA0_IA0_Pos = 0x0
	// Bit mask of IA0 field.
	DMA_INTA0_IA0_Msk = 0x1
	// Bit IA0.
	DMA_INTA0_IA0 = 0x1
	// Position of IA1 field.
	DMA_INTA0_IA1_Pos = 0x1
	// Bit mask of IA1 field.
	DMA_INTA0_IA1_Msk = 0x2
	// Bit IA1.
	DMA_INTA0_IA1 = 0x2
	// Position of IA2 field.
	DMA_INTA0_IA2_Pos = 0x2
	// Bit mask of IA2 field.
	DMA_INTA0_IA2_Msk = 0x4
	// Bit IA2.
	DMA_INTA0_IA2 = 0x4
	// Position of IA3 field.
	DMA_INTA0_IA3_Pos = 0x3
	// Bit mask of IA3 field.
	DMA_INTA0_IA3_Msk = 0x8
	// Bit IA3.
	DMA_INTA0_IA3 = 0x8
	// Position of IA4 field.
	DMA_INTA0_IA4_Pos = 0x4
	// Bit mask of IA4 field.
	DMA_INTA0_IA4_Msk = 0x10
	// Bit IA4.
	DMA_INTA0_IA4 = 0x10
	// Position of IA5 field.
	DMA_INTA0_IA5_Pos = 0x5
	// Bit mask of IA5 field.
	DMA_INTA0_IA5_Msk = 0x20
	// Bit IA5.
	DMA_INTA0_IA5 = 0x20
	// Position of IA6 field.
	DMA_INTA0_IA6_Pos = 0x6
	// Bit mask of IA6 field.
	DMA_INTA0_IA6_Msk = 0x40
	// Bit IA6.
	DMA_INTA0_IA6 = 0x40
	// Position of IA7 field.
	DMA_INTA0_IA7_Pos = 0x7
	// Bit mask of IA7 field.
	DMA_INTA0_IA7_Msk = 0x80
	// Bit IA7.
	DMA_INTA0_IA7 = 0x80
	// Position of IA8 field.
	DMA_INTA0_IA8_Pos = 0x8
	// Bit mask of IA8 field.
	DMA_INTA0_IA8_Msk = 0x100
	// Bit IA8.
	DMA_INTA0_IA8 = 0x100
	// Position of IA9 field.
	DMA_INTA0_IA9_Pos = 0x9
	// Bit mask of IA9 field.
	DMA_INTA0_IA9_Msk = 0x200
	// Bit IA9.
	DMA_INTA0_IA9 = 0x200
	// Position of IA10 field.
	DMA_INTA0_IA10_Pos = 0xa
	// Bit mask of IA10 field.
	DMA_INTA0_IA10_Msk = 0x400
	// Bit IA10.
	DMA_INTA0_IA10 = 0x400
	// Position of IA11 field.
	DMA_INTA0_IA11_Pos = 0xb
	// Bit mask of IA11 field.
	DMA_INTA0_IA11_Msk = 0x800
	// Bit IA11.
	DMA_INTA0_IA11 = 0x800
	// Position of IA12 field.
	DMA_INTA0_IA12_Pos = 0xc
	// Bit mask of IA12 field.
	DMA_INTA0_IA12_Msk = 0x1000
	// Bit IA12.
	DMA_INTA0_IA12 = 0x1000
	// Position of IA13 field.
	DMA_INTA0_IA13_Pos = 0xd
	// Bit mask of IA13 field.
	DMA_INTA0_IA13_Msk = 0x2000
	// Bit IA13.
	DMA_INTA0_IA13 = 0x2000
	// Position of IA14 field.
	DMA_INTA0_IA14_Pos = 0xe
	// Bit mask of IA14 field.
	DMA_INTA0_IA14_Msk = 0x4000
	// Bit IA14.
	DMA_INTA0_IA14 = 0x4000
	// Position of IA15 field.
	DMA_INTA0_IA15_Pos = 0xf
	// Bit mask of IA15 field.
	DMA_INTA0_IA15_Msk = 0x8000
	// Bit IA15.
	DMA_INTA0_IA15 = 0x8000
	// Position of IA16 field.
	DMA_INTA0_IA16_Pos = 0x10
	// Bit mask of IA16 field.
	DMA_INTA0_IA16_Msk = 0x10000
	// Bit IA16.
	DMA_INTA0_IA16 = 0x10000
	// Position of IA17 field.
	DMA_INTA0_IA17_Pos = 0x11
	// Bit mask of IA17 field.
	DMA_INTA0_IA17_Msk = 0x20000
	// Bit IA17.
	DMA_INTA0_IA17 = 0x20000
	// Position of RESERVED field.
	DMA_INTA0_RESERVED_Pos = 0x12
	// Bit mask of RESERVED field.
	DMA_INTA0_RESERVED_Msk = 0xfffc0000

	// INTB0: Interrupt B status for all DMA channels.
	// Position of IB0 field.
	DMA_INTB0_IB0_Pos = 0x0
	// Bit mask of IB0 field.
	DMA_INTB0_IB0_Msk = 0x1
	// Bit IB0.
	DMA_INTB0_IB0 = 0x1
	// Position of IB1 field.
	DMA_INTB0_IB1_Pos = 0x1
	// Bit mask of IB1 field.
	DMA_INTB0_IB1_Msk = 0x2
	// Bit IB1.
	DMA_INTB0_IB1 = 0x2
	// Position of IB2 field.
	DMA_INTB0_IB2_Pos = 0x2
	// Bit mask of IB2 field.
	DMA_INTB0_IB2_Msk = 0x4
	// Bit IB2.
	DMA_INTB0_IB2 = 0x4
	// Position of IB3 field.
	DMA_INTB0_IB3_Pos = 0x3
	// Bit mask of IB3 field.
	DMA_INTB0_IB3_Msk = 0x8
	// Bit IB3.
	DMA_INTB0_IB3 = 0x8
	// Position of IB4 field.
	DMA_INTB0_IB4_Pos = 0x4
	// Bit mask of IB4 field.
	DMA_INTB0_IB4_Msk = 0x10
	// Bit IB4.
	DMA_INTB0_IB4 = 0x10
	// Position of IB5 field.
	DMA_INTB0_IB5_Pos = 0x5
	// Bit mask of IB5 field.
	DMA_INTB0_IB5_Msk = 0x20
	// Bit IB5.
	DMA_INTB0_IB5 = 0x20
	// Position of IB6 field.
	DMA_INTB0_IB6_Pos = 0x6
	// Bit mask of IB6 field.
	DMA_INTB0_IB6_Msk = 0x40
	// Bit IB6.
	DMA_INTB0_IB6 = 0x40
	// Position of IB7 field.
	DMA_INTB0_IB7_Pos = 0x7
	// Bit mask of IB7 field.
	DMA_INTB0_IB7_Msk = 0x80
	// Bit IB7.
	DMA_INTB0_IB7 = 0x80
	// Position of IB8 field.
	DMA_INTB0_IB8_Pos = 0x8
	// Bit mask of IB8 field.
	DMA_INTB0_IB8_Msk = 0x100
	// Bit IB8.
	DMA_INTB0_IB8 = 0x100
	// Position of IB9 field.
	DMA_INTB0_IB9_Pos = 0x9
	// Bit mask of IB9 field.
	DMA_INTB0_IB9_Msk = 0x200
	// Bit IB9.
	DMA_INTB0_IB9 = 0x200
	// Position of IB10 field.
	DMA_INTB0_IB10_Pos = 0xa
	// Bit mask of IB10 field.
	DMA_INTB0_IB10_Msk = 0x400
	// Bit IB10.
	DMA_INTB0_IB10 = 0x400
	// Position of IB11 field.
	DMA_INTB0_IB11_Pos = 0xb
	// Bit mask of IB11 field.
	DMA_INTB0_IB11_Msk = 0x800
	// Bit IB11.
	DMA_INTB0_IB11 = 0x800
	// Position of IB12 field.
	DMA_INTB0_IB12_Pos = 0xc
	// Bit mask of IB12 field.
	DMA_INTB0_IB12_Msk = 0x1000
	// Bit IB12.
	DMA_INTB0_IB12 = 0x1000
	// Position of IB13 field.
	DMA_INTB0_IB13_Pos = 0xd
	// Bit mask of IB13 field.
	DMA_INTB0_IB13_Msk = 0x2000
	// Bit IB13.
	DMA_INTB0_IB13 = 0x2000
	// Position of IB14 field.
	DMA_INTB0_IB14_Pos = 0xe
	// Bit mask of IB14 field.
	DMA_INTB0_IB14_Msk = 0x4000
	// Bit IB14.
	DMA_INTB0_IB14 = 0x4000
	// Position of IB15 field.
	DMA_INTB0_IB15_Pos = 0xf
	// Bit mask of IB15 field.
	DMA_INTB0_IB15_Msk = 0x8000
	// Bit IB15.
	DMA_INTB0_IB15 = 0x8000
	// Position of IB16 field.
	DMA_INTB0_IB16_Pos = 0x10
	// Bit mask of IB16 field.
	DMA_INTB0_IB16_Msk = 0x10000
	// Bit IB16.
	DMA_INTB0_IB16 = 0x10000
	// Position of IB17 field.
	DMA_INTB0_IB17_Pos = 0x11
	// Bit mask of IB17 field.
	DMA_INTB0_IB17_Msk = 0x20000
	// Bit IB17.
	DMA_INTB0_IB17 = 0x20000
	// Position of RESERVED field.
	DMA_INTB0_RESERVED_Pos = 0x12
	// Bit mask of RESERVED field.
	DMA_INTB0_RESERVED_Msk = 0xfffc0000

	// SETVALID0: Set ValidPending control bits for all DMA channels.
	// Position of SV0 field.
	DMA_SETVALID0_SV0_Pos = 0x0
	// Bit mask of SV0 field.
	DMA_SETVALID0_SV0_Msk = 0x1
	// Bit SV0.
	DMA_SETVALID0_SV0 = 0x1
	// Position of SV1 field.
	DMA_SETVALID0_SV1_Pos = 0x1
	// Bit mask of SV1 field.
	DMA_SETVALID0_SV1_Msk = 0x2
	// Bit SV1.
	DMA_SETVALID0_SV1 = 0x2
	// Position of SV2 field.
	DMA_SETVALID0_SV2_Pos = 0x2
	// Bit mask of SV2 field.
	DMA_SETVALID0_SV2_Msk = 0x4
	// Bit SV2.
	DMA_SETVALID0_SV2 = 0x4
	// Position of SV3 field.
	DMA_SETVALID0_SV3_Pos = 0x3
	// Bit mask of SV3 field.
	DMA_SETVALID0_SV3_Msk = 0x8
	// Bit SV3.
	DMA_SETVALID0_SV3 = 0x8
	// Position of SV4 field.
	DMA_SETVALID0_SV4_Pos = 0x4
	// Bit mask of SV4 field.
	DMA_SETVALID0_SV4_Msk = 0x10
	// Bit SV4.
	DMA_SETVALID0_SV4 = 0x10
	// Position of SV5 field.
	DMA_SETVALID0_SV5_Pos = 0x5
	// Bit mask of SV5 field.
	DMA_SETVALID0_SV5_Msk = 0x20
	// Bit SV5.
	DMA_SETVALID0_SV5 = 0x20
	// Position of SV6 field.
	DMA_SETVALID0_SV6_Pos = 0x6
	// Bit mask of SV6 field.
	DMA_SETVALID0_SV6_Msk = 0x40
	// Bit SV6.
	DMA_SETVALID0_SV6 = 0x40
	// Position of SV7 field.
	DMA_SETVALID0_SV7_Pos = 0x7
	// Bit mask of SV7 field.
	DMA_SETVALID0_SV7_Msk = 0x80
	// Bit SV7.
	DMA_SETVALID0_SV7 = 0x80
	// Position of SV8 field.
	DMA_SETVALID0_SV8_Pos = 0x8
	// Bit mask of SV8 field.
	DMA_SETVALID0_SV8_Msk = 0x100
	// Bit SV8.
	DMA_SETVALID0_SV8 = 0x100
	// Position of SV9 field.
	DMA_SETVALID0_SV9_Pos = 0x9
	// Bit mask of SV9 field.
	DMA_SETVALID0_SV9_Msk = 0x200
	// Bit SV9.
	DMA_SETVALID0_SV9 = 0x200
	// Position of SV10 field.
	DMA_SETVALID0_SV10_Pos = 0xa
	// Bit mask of SV10 field.
	DMA_SETVALID0_SV10_Msk = 0x400
	// Bit SV10.
	DMA_SETVALID0_SV10 = 0x400
	// Position of SV11 field.
	DMA_SETVALID0_SV11_Pos = 0xb
	// Bit mask of SV11 field.
	DMA_SETVALID0_SV11_Msk = 0x800
	// Bit SV11.
	DMA_SETVALID0_SV11 = 0x800
	// Position of SV12 field.
	DMA_SETVALID0_SV12_Pos = 0xc
	// Bit mask of SV12 field.
	DMA_SETVALID0_SV12_Msk = 0x1000
	// Bit SV12.
	DMA_SETVALID0_SV12 = 0x1000
	// Position of SV13 field.
	DMA_SETVALID0_SV13_Pos = 0xd
	// Bit mask of SV13 field.
	DMA_SETVALID0_SV13_Msk = 0x2000
	// Bit SV13.
	DMA_SETVALID0_SV13 = 0x2000
	// Position of SV14 field.
	DMA_SETVALID0_SV14_Pos = 0xe
	// Bit mask of SV14 field.
	DMA_SETVALID0_SV14_Msk = 0x4000
	// Bit SV14.
	DMA_SETVALID0_SV14 = 0x4000
	// Position of SV15 field.
	DMA_SETVALID0_SV15_Pos = 0xf
	// Bit mask of SV15 field.
	DMA_SETVALID0_SV15_Msk = 0x8000
	// Bit SV15.
	DMA_SETVALID0_SV15 = 0x8000
	// Position of SV16 field.
	DMA_SETVALID0_SV16_Pos = 0x10
	// Bit mask of SV16 field.
	DMA_SETVALID0_SV16_Msk = 0x10000
	// Bit SV16.
	DMA_SETVALID0_SV16 = 0x10000
	// Position of SV17 field.
	DMA_SETVALID0_SV17_Pos = 0x11
	// Bit mask of SV17 field.
	DMA_SETVALID0_SV17_Msk = 0x20000
	// Bit SV17.
	DMA_SETVALID0_SV17 = 0x20000
	// Position of RESERVED field.
	DMA_SETVALID0_RESERVED_Pos = 0x12
	// Bit mask of RESERVED field.
	DMA_SETVALID0_RESERVED_Msk = 0xfffc0000

	// SETTRIG0: Set Trigger control bits for all DMA channels.
	// Position of SETTRIG0 field.
	DMA_SETTRIG0_SETTRIG0_Pos = 0x0
	// Bit mask of SETTRIG0 field.
	DMA_SETTRIG0_SETTRIG0_Msk = 0x1
	// Bit SETTRIG0.
	DMA_SETTRIG0_SETTRIG0 = 0x1
	// Position of SETTRIG1 field.
	DMA_SETTRIG0_SETTRIG1_Pos = 0x1
	// Bit mask of SETTRIG1 field.
	DMA_SETTRIG0_SETTRIG1_Msk = 0x2
	// Bit SETTRIG1.
	DMA_SETTRIG0_SETTRIG1 = 0x2
	// Position of SETTRIG2 field.
	DMA_SETTRIG0_SETTRIG2_Pos = 0x2
	// Bit mask of SETTRIG2 field.
	DMA_SETTRIG0_SETTRIG2_Msk = 0x4
	// Bit SETTRIG2.
	DMA_SETTRIG0_SETTRIG2 = 0x4
	// Position of SETTRIG3 field.
	DMA_SETTRIG0_SETTRIG3_Pos = 0x3
	// Bit mask of SETTRIG3 field.
	DMA_SETTRIG0_SETTRIG3_Msk = 0x8
	// Bit SETTRIG3.
	DMA_SETTRIG0_SETTRIG3 = 0x8
	// Position of SETTRIG4 field.
	DMA_SETTRIG0_SETTRIG4_Pos = 0x4
	// Bit mask of SETTRIG4 field.
	DMA_SETTRIG0_SETTRIG4_Msk = 0x10
	// Bit SETTRIG4.
	DMA_SETTRIG0_SETTRIG4 = 0x10
	// Position of SETTRIG5 field.
	DMA_SETTRIG0_SETTRIG5_Pos = 0x5
	// Bit mask of SETTRIG5 field.
	DMA_SETTRIG0_SETTRIG5_Msk = 0x20
	// Bit SETTRIG5.
	DMA_SETTRIG0_SETTRIG5 = 0x20
	// Position of SETTRIG6 field.
	DMA_SETTRIG0_SETTRIG6_Pos = 0x6
	// Bit mask of SETTRIG6 field.
	DMA_SETTRIG0_SETTRIG6_Msk = 0x40
	// Bit SETTRIG6.
	DMA_SETTRIG0_SETTRIG6 = 0x40
	// Position of SETTRIG7 field.
	DMA_SETTRIG0_SETTRIG7_Pos = 0x7
	// Bit mask of SETTRIG7 field.
	DMA_SETTRIG0_SETTRIG7_Msk = 0x80
	// Bit SETTRIG7.
	DMA_SETTRIG0_SETTRIG7 = 0x80
	// Position of SETTRIG8 field.
	DMA_SETTRIG0_SETTRIG8_Pos = 0x8
	// Bit mask of SETTRIG8 field.
	DMA_SETTRIG0_SETTRIG8_Msk = 0x100
	// Bit SETTRIG8.
	DMA_SETTRIG0_SETTRIG8 = 0x100
	// Position of SETTRIG9 field.
	DMA_SETTRIG0_SETTRIG9_Pos = 0x9
	// Bit mask of SETTRIG9 field.
	DMA_SETTRIG0_SETTRIG9_Msk = 0x200
	// Bit SETTRIG9.
	DMA_SETTRIG0_SETTRIG9 = 0x200
	// Position of SETTRIG10 field.
	DMA_SETTRIG0_SETTRIG10_Pos = 0xa
	// Bit mask of SETTRIG10 field.
	DMA_SETTRIG0_SETTRIG10_Msk = 0x400
	// Bit SETTRIG10.
	DMA_SETTRIG0_SETTRIG10 = 0x400
	// Position of SETTRIG11 field.
	DMA_SETTRIG0_SETTRIG11_Pos = 0xb
	// Bit mask of SETTRIG11 field.
	DMA_SETTRIG0_SETTRIG11_Msk = 0x800
	// Bit SETTRIG11.
	DMA_SETTRIG0_SETTRIG11 = 0x800
	// Position of SETTRIG12 field.
	DMA_SETTRIG0_SETTRIG12_Pos = 0xc
	// Bit mask of SETTRIG12 field.
	DMA_SETTRIG0_SETTRIG12_Msk = 0x1000
	// Bit SETTRIG12.
	DMA_SETTRIG0_SETTRIG12 = 0x1000
	// Position of SETTRIG13 field.
	DMA_SETTRIG0_SETTRIG13_Pos = 0xd
	// Bit mask of SETTRIG13 field.
	DMA_SETTRIG0_SETTRIG13_Msk = 0x2000
	// Bit SETTRIG13.
	DMA_SETTRIG0_SETTRIG13 = 0x2000
	// Position of SETTRIG14 field.
	DMA_SETTRIG0_SETTRIG14_Pos = 0xe
	// Bit mask of SETTRIG14 field.
	DMA_SETTRIG0_SETTRIG14_Msk = 0x4000
	// Bit SETTRIG14.
	DMA_SETTRIG0_SETTRIG14 = 0x4000
	// Position of SETTRIG15 field.
	DMA_SETTRIG0_SETTRIG15_Pos = 0xf
	// Bit mask of SETTRIG15 field.
	DMA_SETTRIG0_SETTRIG15_Msk = 0x8000
	// Bit SETTRIG15.
	DMA_SETTRIG0_SETTRIG15 = 0x8000
	// Position of SETTRIG16 field.
	DMA_SETTRIG0_SETTRIG16_Pos = 0x10
	// Bit mask of SETTRIG16 field.
	DMA_SETTRIG0_SETTRIG16_Msk = 0x10000
	// Bit SETTRIG16.
	DMA_SETTRIG0_SETTRIG16 = 0x10000
	// Position of SETTRIG17 field.
	DMA_SETTRIG0_SETTRIG17_Pos = 0x11
	// Bit mask of SETTRIG17 field.
	DMA_SETTRIG0_SETTRIG17_Msk = 0x20000
	// Bit SETTRIG17.
	DMA_SETTRIG0_SETTRIG17 = 0x20000
	// Position of RESERVED field.
	DMA_SETTRIG0_RESERVED_Pos = 0x12
	// Bit mask of RESERVED field.
	DMA_SETTRIG0_RESERVED_Msk = 0xfffc0000

	// ABORT0: Channel Abort control for all DMA channels.
	// Position of AORTCTRL0 field.
	DMA_ABORT0_AORTCTRL0_Pos = 0x0
	// Bit mask of AORTCTRL0 field.
	DMA_ABORT0_AORTCTRL0_Msk = 0x1
	// Bit AORTCTRL0.
	DMA_ABORT0_AORTCTRL0 = 0x1
	// Position of AORTCTRL1 field.
	DMA_ABORT0_AORTCTRL1_Pos = 0x1
	// Bit mask of AORTCTRL1 field.
	DMA_ABORT0_AORTCTRL1_Msk = 0x2
	// Bit AORTCTRL1.
	DMA_ABORT0_AORTCTRL1 = 0x2
	// Position of AORTCTRL2 field.
	DMA_ABORT0_AORTCTRL2_Pos = 0x2
	// Bit mask of AORTCTRL2 field.
	DMA_ABORT0_AORTCTRL2_Msk = 0x4
	// Bit AORTCTRL2.
	DMA_ABORT0_AORTCTRL2 = 0x4
	// Position of AORTCTRL3 field.
	DMA_ABORT0_AORTCTRL3_Pos = 0x3
	// Bit mask of AORTCTRL3 field.
	DMA_ABORT0_AORTCTRL3_Msk = 0x8
	// Bit AORTCTRL3.
	DMA_ABORT0_AORTCTRL3 = 0x8
	// Position of AORTCTRL4 field.
	DMA_ABORT0_AORTCTRL4_Pos = 0x4
	// Bit mask of AORTCTRL4 field.
	DMA_ABORT0_AORTCTRL4_Msk = 0x10
	// Bit AORTCTRL4.
	DMA_ABORT0_AORTCTRL4 = 0x10
	// Position of AORTCTRL5 field.
	DMA_ABORT0_AORTCTRL5_Pos = 0x5
	// Bit mask of AORTCTRL5 field.
	DMA_ABORT0_AORTCTRL5_Msk = 0x20
	// Bit AORTCTRL5.
	DMA_ABORT0_AORTCTRL5 = 0x20
	// Position of AORTCTRL6 field.
	DMA_ABORT0_AORTCTRL6_Pos = 0x6
	// Bit mask of AORTCTRL6 field.
	DMA_ABORT0_AORTCTRL6_Msk = 0x40
	// Bit AORTCTRL6.
	DMA_ABORT0_AORTCTRL6 = 0x40
	// Position of AORTCTRL7 field.
	DMA_ABORT0_AORTCTRL7_Pos = 0x7
	// Bit mask of AORTCTRL7 field.
	DMA_ABORT0_AORTCTRL7_Msk = 0x80
	// Bit AORTCTRL7.
	DMA_ABORT0_AORTCTRL7 = 0x80
	// Position of AORTCTRL8 field.
	DMA_ABORT0_AORTCTRL8_Pos = 0x8
	// Bit mask of AORTCTRL8 field.
	DMA_ABORT0_AORTCTRL8_Msk = 0x100
	// Bit AORTCTRL8.
	DMA_ABORT0_AORTCTRL8 = 0x100
	// Position of AORTCTRL9 field.
	DMA_ABORT0_AORTCTRL9_Pos = 0x9
	// Bit mask of AORTCTRL9 field.
	DMA_ABORT0_AORTCTRL9_Msk = 0x200
	// Bit AORTCTRL9.
	DMA_ABORT0_AORTCTRL9 = 0x200
	// Position of AORTCTRL10 field.
	DMA_ABORT0_AORTCTRL10_Pos = 0xa
	// Bit mask of AORTCTRL10 field.
	DMA_ABORT0_AORTCTRL10_Msk = 0x400
	// Bit AORTCTRL10.
	DMA_ABORT0_AORTCTRL10 = 0x400
	// Position of AORTCTRL11 field.
	DMA_ABORT0_AORTCTRL11_Pos = 0xb
	// Bit mask of AORTCTRL11 field.
	DMA_ABORT0_AORTCTRL11_Msk = 0x800
	// Bit AORTCTRL11.
	DMA_ABORT0_AORTCTRL11 = 0x800
	// Position of AORTCTRL12 field.
	DMA_ABORT0_AORTCTRL12_Pos = 0xc
	// Bit mask of AORTCTRL12 field.
	DMA_ABORT0_AORTCTRL12_Msk = 0x1000
	// Bit AORTCTRL12.
	DMA_ABORT0_AORTCTRL12 = 0x1000
	// Position of AORTCTRL13 field.
	DMA_ABORT0_AORTCTRL13_Pos = 0xd
	// Bit mask of AORTCTRL13 field.
	DMA_ABORT0_AORTCTRL13_Msk = 0x2000
	// Bit AORTCTRL13.
	DMA_ABORT0_AORTCTRL13 = 0x2000
	// Position of AORTCTRL14 field.
	DMA_ABORT0_AORTCTRL14_Pos = 0xe
	// Bit mask of AORTCTRL14 field.
	DMA_ABORT0_AORTCTRL14_Msk = 0x4000
	// Bit AORTCTRL14.
	DMA_ABORT0_AORTCTRL14 = 0x4000
	// Position of AORTCTRL15 field.
	DMA_ABORT0_AORTCTRL15_Pos = 0xf
	// Bit mask of AORTCTRL15 field.
	DMA_ABORT0_AORTCTRL15_Msk = 0x8000
	// Bit AORTCTRL15.
	DMA_ABORT0_AORTCTRL15 = 0x8000
	// Position of AORTCTRL16 field.
	DMA_ABORT0_AORTCTRL16_Pos = 0x10
	// Bit mask of AORTCTRL16 field.
	DMA_ABORT0_AORTCTRL16_Msk = 0x10000
	// Bit AORTCTRL16.
	DMA_ABORT0_AORTCTRL16 = 0x10000
	// Position of AORTCTRL17 field.
	DMA_ABORT0_AORTCTRL17_Pos = 0x11
	// Bit mask of AORTCTRL17 field.
	DMA_ABORT0_AORTCTRL17_Msk = 0x20000
	// Bit AORTCTRL17.
	DMA_ABORT0_AORTCTRL17 = 0x20000
	// Position of RESERVED field.
	DMA_ABORT0_RESERVED_Pos = 0x12
	// Bit mask of RESERVED field.
	DMA_ABORT0_RESERVED_Msk = 0xfffc0000

	// CFG0: Configuration register for DMA channel 0.
	// Position of PERIPHREQEN field.
	DMA_CFG_PERIPHREQEN_Pos = 0x0
	// Bit mask of PERIPHREQEN field.
	DMA_CFG_PERIPHREQEN_Msk = 0x1
	// Bit PERIPHREQEN.
	DMA_CFG_PERIPHREQEN = 0x1
	// Disabled. Peripheral DMA requests are disabled.
	DMA_CFG_PERIPHREQEN_DISABLED = 0x0
	// Enabled. Peripheral DMA requests are enabled.
	DMA_CFG_PERIPHREQEN_ENABLED = 0x1
	// Position of HWTRIGEN field.
	DMA_CFG_HWTRIGEN_Pos = 0x1
	// Bit mask of HWTRIGEN field.
	DMA_CFG_HWTRIGEN_Msk = 0x2
	// Bit HWTRIGEN.
	DMA_CFG_HWTRIGEN = 0x2
	// Disabled. Hardware triggering is not used.
	DMA_CFG_HWTRIGEN_DISABLED = 0x0
	// Enabled. Use hardware triggering.
	DMA_CFG_HWTRIGEN_ENABLED = 0x1
	// Position of RESERVED field.
	DMA_CFG_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	DMA_CFG_RESERVED_Msk = 0xc
	// Position of TRIGPOL field.
	DMA_CFG_TRIGPOL_Pos = 0x4
	// Bit mask of TRIGPOL field.
	DMA_CFG_TRIGPOL_Msk = 0x10
	// Bit TRIGPOL.
	DMA_CFG_TRIGPOL = 0x10
	// Active low - falling edge. Hardware trigger is active low or falling edge triggered, based on TRIGTYPE.
	DMA_CFG_TRIGPOL_ACTIVE_LOW__FALLING = 0x0
	// Active high - rising edge. Hardware trigger is active high or rising edge triggered, based on TRIGTYPE.
	DMA_CFG_TRIGPOL_ACTIVE_HIGH__RISING = 0x1
	// Position of TRIGTYPE field.
	DMA_CFG_TRIGTYPE_Pos = 0x5
	// Bit mask of TRIGTYPE field.
	DMA_CFG_TRIGTYPE_Msk = 0x20
	// Bit TRIGTYPE.
	DMA_CFG_TRIGTYPE = 0x20
	// Edge. Hardware trigger is edge triggered.
	DMA_CFG_TRIGTYPE_EDGE = 0x0
	// Level. Hardware trigger is level triggered. Note that when level triggering without burst (BURSTPOWER = 0) is selected, only hardware triggers should be used on that channel.
	DMA_CFG_TRIGTYPE_LEVEL = 0x1
	// Position of TRIGBURST field.
	DMA_CFG_TRIGBURST_Pos = 0x6
	// Bit mask of TRIGBURST field.
	DMA_CFG_TRIGBURST_Msk = 0x40
	// Bit TRIGBURST.
	DMA_CFG_TRIGBURST = 0x40
	// Single transfer. Hardware trigger causes a single transfer.
	DMA_CFG_TRIGBURST_SINGLE_TRANSFER = 0x0
	// Burst transfer. When the trigger for this channel is set to edge triggered, a hardware trigger causes a burst transfer, as defined by BURSTPOWER. When the trigger for this channel is set to level triggered, a hardware trigger causes transfers to continue as long as the trigger is asserted, unless the transfer is complete.
	DMA_CFG_TRIGBURST_BURST_TRANSFER = 0x1
	// Position of RESERVED field.
	DMA_CFG_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	DMA_CFG_RESERVED_Msk = 0x80
	// Bit RESERVED.
	DMA_CFG_RESERVED = 0x80
	// Position of BURSTPOWER field.
	DMA_CFG_BURSTPOWER_Pos = 0x8
	// Bit mask of BURSTPOWER field.
	DMA_CFG_BURSTPOWER_Msk = 0xf00
	// Position of RESERVED field.
	DMA_CFG_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	DMA_CFG_RESERVED_Msk = 0x3000
	// Position of SRCBURSTWRAP field.
	DMA_CFG_SRCBURSTWRAP_Pos = 0xe
	// Bit mask of SRCBURSTWRAP field.
	DMA_CFG_SRCBURSTWRAP_Msk = 0x4000
	// Bit SRCBURSTWRAP.
	DMA_CFG_SRCBURSTWRAP = 0x4000
	// Disabled. Source burst wrapping is not enabled for this DMA channel.
	DMA_CFG_SRCBURSTWRAP_DISABLED = 0x0
	// Enabled. Source burst wrapping is enabled for this DMA channel.
	DMA_CFG_SRCBURSTWRAP_ENABLED = 0x1
	// Position of DSTBURSTWRAP field.
	DMA_CFG_DSTBURSTWRAP_Pos = 0xf
	// Bit mask of DSTBURSTWRAP field.
	DMA_CFG_DSTBURSTWRAP_Msk = 0x8000
	// Bit DSTBURSTWRAP.
	DMA_CFG_DSTBURSTWRAP = 0x8000
	// Disabled. Destination burst wrapping is not enabled for this DMA channel.
	DMA_CFG_DSTBURSTWRAP_DISABLED = 0x0
	// Enabled. Destination burst wrapping is enabled for this DMA channel.
	DMA_CFG_DSTBURSTWRAP_ENABLED = 0x1
	// Position of CHPRIORITY field.
	DMA_CFG_CHPRIORITY_Pos = 0x10
	// Bit mask of CHPRIORITY field.
	DMA_CFG_CHPRIORITY_Msk = 0x70000
	// Position of RESERVED field.
	DMA_CFG_RESERVED_Pos = 0x13
	// Bit mask of RESERVED field.
	DMA_CFG_RESERVED_Msk = 0xfff80000

	// CTLSTAT0: Control and status register for DMA channel 0.
	// Position of VALIDPENDING field.
	DMA_CTLSTAT_VALIDPENDING_Pos = 0x0
	// Bit mask of VALIDPENDING field.
	DMA_CTLSTAT_VALIDPENDING_Msk = 0x1
	// Bit VALIDPENDING.
	DMA_CTLSTAT_VALIDPENDING = 0x1
	// No effect on DMA operation.
	DMA_CTLSTAT_VALIDPENDING_NO_EFFECT_ON_DMA_OPE = 0x0
	// Valid pending.
	DMA_CTLSTAT_VALIDPENDING_VALID_PENDING = 0x1
	// Position of RESERVED field.
	DMA_CTLSTAT_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	DMA_CTLSTAT_RESERVED_Msk = 0x2
	// Bit RESERVED.
	DMA_CTLSTAT_RESERVED = 0x2
	// Position of TRIG field.
	DMA_CTLSTAT_TRIG_Pos = 0x2
	// Bit mask of TRIG field.
	DMA_CTLSTAT_TRIG_Msk = 0x4
	// Bit TRIG.
	DMA_CTLSTAT_TRIG = 0x4
	// Not triggered. The trigger for this DMA channel is not set. DMA operations will not be carried out.
	DMA_CTLSTAT_TRIG_NOT_TRIGGERED = 0x0
	// Triggered. The trigger for this DMA channel is set. DMA operations will be carried out.
	DMA_CTLSTAT_TRIG_TRIGGERED = 0x1
	// Position of RESERVED field.
	DMA_CTLSTAT_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	DMA_CTLSTAT_RESERVED_Msk = 0xfffffff8

	// XFERCFG0: Transfer configuration register for DMA channel 0.
	// Position of CFGVALID field.
	DMA_XFERCFG_CFGVALID_Pos = 0x0
	// Bit mask of CFGVALID field.
	DMA_XFERCFG_CFGVALID_Msk = 0x1
	// Bit CFGVALID.
	DMA_XFERCFG_CFGVALID = 0x1
	// Not valid. The current channel descriptor is not considered valid.
	DMA_XFERCFG_CFGVALID_NOT_VALID = 0x0
	// Valid. The current channel descriptor is considered valid.
	DMA_XFERCFG_CFGVALID_VALID = 0x1
	// Position of RELOAD field.
	DMA_XFERCFG_RELOAD_Pos = 0x1
	// Bit mask of RELOAD field.
	DMA_XFERCFG_RELOAD_Msk = 0x2
	// Bit RELOAD.
	DMA_XFERCFG_RELOAD = 0x2
	// Disabled. Do not reload the channels' control structure when the current descriptor is exhausted.
	DMA_XFERCFG_RELOAD_DISABLED = 0x0
	// Enabled. Reload the channels' control structure when the current descriptor is exhausted.
	DMA_XFERCFG_RELOAD_ENABLED = 0x1
	// Position of SWTRIG field.
	DMA_XFERCFG_SWTRIG_Pos = 0x2
	// Bit mask of SWTRIG field.
	DMA_XFERCFG_SWTRIG_Msk = 0x4
	// Bit SWTRIG.
	DMA_XFERCFG_SWTRIG = 0x4
	// Position of CLRTRIG field.
	DMA_XFERCFG_CLRTRIG_Pos = 0x3
	// Bit mask of CLRTRIG field.
	DMA_XFERCFG_CLRTRIG_Msk = 0x8
	// Bit CLRTRIG.
	DMA_XFERCFG_CLRTRIG = 0x8
	// Not cleared. The trigger is not cleared when this descriptor is exhausted. If there is a reload, the next descriptor will be started.
	DMA_XFERCFG_CLRTRIG_NOT_CLEARED = 0x0
	// Cleared. The trigger is cleared when this descriptor is exhausted.
	DMA_XFERCFG_CLRTRIG_CLEARED = 0x1
	// Position of SETINTA field.
	DMA_XFERCFG_SETINTA_Pos = 0x4
	// Bit mask of SETINTA field.
	DMA_XFERCFG_SETINTA_Msk = 0x10
	// Bit SETINTA.
	DMA_XFERCFG_SETINTA = 0x10
	// No effect.
	DMA_XFERCFG_SETINTA_NO_EFFECT = 0x0
	// Set. The INTA flag for this channel will be set when the current descriptor is exhausted.
	DMA_XFERCFG_SETINTA_SET = 0x1
	// Position of SETINTB field.
	DMA_XFERCFG_SETINTB_Pos = 0x5
	// Bit mask of SETINTB field.
	DMA_XFERCFG_SETINTB_Msk = 0x20
	// Bit SETINTB.
	DMA_XFERCFG_SETINTB = 0x20
	// No effect.
	DMA_XFERCFG_SETINTB_NO_EFFECT = 0x0
	// Set. The INTB flag for this channel will be set when the current descriptor is exhausted.
	DMA_XFERCFG_SETINTB_SET = 0x1
	// Position of RESERVED field.
	DMA_XFERCFG_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	DMA_XFERCFG_RESERVED_Msk = 0xc0
	// Position of WIDTH field.
	DMA_XFERCFG_WIDTH_Pos = 0x8
	// Bit mask of WIDTH field.
	DMA_XFERCFG_WIDTH_Msk = 0x300
	// 8-bit transfers are performed (8-bit source reads and destination writes).
	DMA_XFERCFG_WIDTH_8_BIT_TRANSFERS_ARE = 0x0
	// 16-bit transfers are performed (16-bit source reads and destination writes).
	DMA_XFERCFG_WIDTH_16_BIT_TRANSFERS_ARE = 0x1
	// 32-bit transfers are performed (32-bit source reads and destination writes).
	DMA_XFERCFG_WIDTH_32_BIT_TRANSFERS_ARE = 0x2
	// Position of RESERVED field.
	DMA_XFERCFG_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	DMA_XFERCFG_RESERVED_Msk = 0xc00
	// Position of SRCINC field.
	DMA_XFERCFG_SRCINC_Pos = 0xc
	// Bit mask of SRCINC field.
	DMA_XFERCFG_SRCINC_Msk = 0x3000
	// No increment. The source address is not incremented for each transfer. This is the usual case when the source is a peripheral device.
	DMA_XFERCFG_SRCINC_NO_INCREMENT = 0x0
	// 1 x width. The source address is incremented by the amount specified by Width for each transfer. This is the usual case when the source is memory.
	DMA_XFERCFG_SRCINC_1_X_WIDTH = 0x1
	// 2 x width. The source address is incremented by 2 times the amount specified by Width for each transfer.
	DMA_XFERCFG_SRCINC_2_X_WIDTH = 0x2
	// 4 x width. The source address is incremented by 4 times the amount specified by Width for each transfer.
	DMA_XFERCFG_SRCINC_4_X_WIDTH = 0x3
	// Position of DSTINC field.
	DMA_XFERCFG_DSTINC_Pos = 0xe
	// Bit mask of DSTINC field.
	DMA_XFERCFG_DSTINC_Msk = 0xc000
	// No increment. The destination address is not incremented for each transfer. This is the usual case when the destination is a peripheral device.
	DMA_XFERCFG_DSTINC_NO_INCREMENT = 0x0
	// 1 x width. The destination address is incremented by the amount specified by Width for each transfer. This is the usual case when the destination is memory.
	DMA_XFERCFG_DSTINC_1_X_WIDTH = 0x1
	// 2 x width. The destination address is incremented by 2 times the amount specified by Width for each transfer.
	DMA_XFERCFG_DSTINC_2_X_WIDTH = 0x2
	// 4 x width. The destination address is incremented by 4 times the amount specified by Width for each transfer.
	DMA_XFERCFG_DSTINC_4_X_WIDTH = 0x3
	// Position of XFERCOUNT field.
	DMA_XFERCFG_XFERCOUNT_Pos = 0x10
	// Bit mask of XFERCOUNT field.
	DMA_XFERCFG_XFERCOUNT_Msk = 0x3ff0000
	// Position of RESERVED field.
	DMA_XFERCFG_RESERVED_Pos = 0x1a
	// Bit mask of RESERVED field.
	DMA_XFERCFG_RESERVED_Msk = 0xfc000000
)

// Bitfields for USB: USB device controller
const (
	// DEVCMDSTAT: USB Device Command/Status register
	// Position of DEV_ADDR field.
	USB_DEVCMDSTAT_DEV_ADDR_Pos = 0x0
	// Bit mask of DEV_ADDR field.
	USB_DEVCMDSTAT_DEV_ADDR_Msk = 0x7f
	// Position of DEV_EN field.
	USB_DEVCMDSTAT_DEV_EN_Pos = 0x7
	// Bit mask of DEV_EN field.
	USB_DEVCMDSTAT_DEV_EN_Msk = 0x80
	// Bit DEV_EN.
	USB_DEVCMDSTAT_DEV_EN = 0x80
	// Position of SETUP field.
	USB_DEVCMDSTAT_SETUP_Pos = 0x8
	// Bit mask of SETUP field.
	USB_DEVCMDSTAT_SETUP_Msk = 0x100
	// Bit SETUP.
	USB_DEVCMDSTAT_SETUP = 0x100
	// Position of PLL_ON field.
	USB_DEVCMDSTAT_PLL_ON_Pos = 0x9
	// Bit mask of PLL_ON field.
	USB_DEVCMDSTAT_PLL_ON_Msk = 0x200
	// Bit PLL_ON.
	USB_DEVCMDSTAT_PLL_ON = 0x200
	// USB_NeedClk functional
	USB_DEVCMDSTAT_PLL_ON_USB_NEEDCLK_FUNCTION = 0x0
	// USB_NeedClk always 1. Clock will not be stopped in case of suspend.
	USB_DEVCMDSTAT_PLL_ON_USB_NEEDCLK_ALWAYS_1 = 0x1
	// Position of RESERVED field.
	USB_DEVCMDSTAT_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	USB_DEVCMDSTAT_RESERVED_Msk = 0x400
	// Bit RESERVED.
	USB_DEVCMDSTAT_RESERVED = 0x400
	// Position of LPM_SUP field.
	USB_DEVCMDSTAT_LPM_SUP_Pos = 0xb
	// Bit mask of LPM_SUP field.
	USB_DEVCMDSTAT_LPM_SUP_Msk = 0x800
	// Bit LPM_SUP.
	USB_DEVCMDSTAT_LPM_SUP = 0x800
	// LPM not supported.
	USB_DEVCMDSTAT_LPM_SUP_LPM_NOT_SUPPORTED = 0x0
	// LPM supported.
	USB_DEVCMDSTAT_LPM_SUP_LPM_SUPPORTED = 0x1
	// Position of INTONNAK_AO field.
	USB_DEVCMDSTAT_INTONNAK_AO_Pos = 0xc
	// Bit mask of INTONNAK_AO field.
	USB_DEVCMDSTAT_INTONNAK_AO_Msk = 0x1000
	// Bit INTONNAK_AO.
	USB_DEVCMDSTAT_INTONNAK_AO = 0x1000
	// Only acknowledged packets generate an interrupt
	USB_DEVCMDSTAT_INTONNAK_AO_ONLY_ACKNOWLEDGED_PA = 0x0
	// Both acknowledged and NAKed packets generate interrupts.
	USB_DEVCMDSTAT_INTONNAK_AO_BOTH_ACKNOWLEDGED_AN = 0x1
	// Position of INTONNAK_AI field.
	USB_DEVCMDSTAT_INTONNAK_AI_Pos = 0xd
	// Bit mask of INTONNAK_AI field.
	USB_DEVCMDSTAT_INTONNAK_AI_Msk = 0x2000
	// Bit INTONNAK_AI.
	USB_DEVCMDSTAT_INTONNAK_AI = 0x2000
	// Only acknowledged packets generate an interrupt
	USB_DEVCMDSTAT_INTONNAK_AI_ONLY_ACKNOWLEDGED_PA = 0x0
	// Both acknowledged and NAKed packets generate interrupts.
	USB_DEVCMDSTAT_INTONNAK_AI_BOTH_ACKNOWLEDGED_AN = 0x1
	// Position of INTONNAK_CO field.
	USB_DEVCMDSTAT_INTONNAK_CO_Pos = 0xe
	// Bit mask of INTONNAK_CO field.
	USB_DEVCMDSTAT_INTONNAK_CO_Msk = 0x4000
	// Bit INTONNAK_CO.
	USB_DEVCMDSTAT_INTONNAK_CO = 0x4000
	// Only acknowledged packets generate an interrupt
	USB_DEVCMDSTAT_INTONNAK_CO_ONLY_ACKNOWLEDGED_PA = 0x0
	// Both acknowledged and NAKed packets generate interrupts.
	USB_DEVCMDSTAT_INTONNAK_CO_BOTH_ACKNOWLEDGED_AN = 0x1
	// Position of INTONNAK_CI field.
	USB_DEVCMDSTAT_INTONNAK_CI_Pos = 0xf
	// Bit mask of INTONNAK_CI field.
	USB_DEVCMDSTAT_INTONNAK_CI_Msk = 0x8000
	// Bit INTONNAK_CI.
	USB_DEVCMDSTAT_INTONNAK_CI = 0x8000
	// Only acknowledged packets generate an interrupt
	USB_DEVCMDSTAT_INTONNAK_CI_ONLY_ACKNOWLEDGED_PA = 0x0
	// Both acknowledged and NAKed packets generate interrupts.
	USB_DEVCMDSTAT_INTONNAK_CI_BOTH_ACKNOWLEDGED_AN = 0x1
	// Position of DCON field.
	USB_DEVCMDSTAT_DCON_Pos = 0x10
	// Bit mask of DCON field.
	USB_DEVCMDSTAT_DCON_Msk = 0x10000
	// Bit DCON.
	USB_DEVCMDSTAT_DCON = 0x10000
	// Position of DSUS field.
	USB_DEVCMDSTAT_DSUS_Pos = 0x11
	// Bit mask of DSUS field.
	USB_DEVCMDSTAT_DSUS_Msk = 0x20000
	// Bit DSUS.
	USB_DEVCMDSTAT_DSUS = 0x20000
	// Position of RESERVED field.
	USB_DEVCMDSTAT_RESERVED_Pos = 0x12
	// Bit mask of RESERVED field.
	USB_DEVCMDSTAT_RESERVED_Msk = 0x40000
	// Bit RESERVED.
	USB_DEVCMDSTAT_RESERVED = 0x40000
	// Position of LPM_SUS field.
	USB_DEVCMDSTAT_LPM_SUS_Pos = 0x13
	// Bit mask of LPM_SUS field.
	USB_DEVCMDSTAT_LPM_SUS_Msk = 0x80000
	// Bit LPM_SUS.
	USB_DEVCMDSTAT_LPM_SUS = 0x80000
	// Position of LPM_REWP field.
	USB_DEVCMDSTAT_LPM_REWP_Pos = 0x14
	// Bit mask of LPM_REWP field.
	USB_DEVCMDSTAT_LPM_REWP_Msk = 0x100000
	// Bit LPM_REWP.
	USB_DEVCMDSTAT_LPM_REWP = 0x100000
	// Position of RESERVED field.
	USB_DEVCMDSTAT_RESERVED_Pos = 0x15
	// Bit mask of RESERVED field.
	USB_DEVCMDSTAT_RESERVED_Msk = 0xe00000
	// Position of DCON_C field.
	USB_DEVCMDSTAT_DCON_C_Pos = 0x18
	// Bit mask of DCON_C field.
	USB_DEVCMDSTAT_DCON_C_Msk = 0x1000000
	// Bit DCON_C.
	USB_DEVCMDSTAT_DCON_C = 0x1000000
	// Position of DSUS_C field.
	USB_DEVCMDSTAT_DSUS_C_Pos = 0x19
	// Bit mask of DSUS_C field.
	USB_DEVCMDSTAT_DSUS_C_Msk = 0x2000000
	// Bit DSUS_C.
	USB_DEVCMDSTAT_DSUS_C = 0x2000000
	// Position of DRES_C field.
	USB_DEVCMDSTAT_DRES_C_Pos = 0x1a
	// Bit mask of DRES_C field.
	USB_DEVCMDSTAT_DRES_C_Msk = 0x4000000
	// Bit DRES_C.
	USB_DEVCMDSTAT_DRES_C = 0x4000000
	// Position of RESERVED field.
	USB_DEVCMDSTAT_RESERVED_Pos = 0x1b
	// Bit mask of RESERVED field.
	USB_DEVCMDSTAT_RESERVED_Msk = 0x8000000
	// Bit RESERVED.
	USB_DEVCMDSTAT_RESERVED = 0x8000000
	// Position of VBUSDEBOUNCED field.
	USB_DEVCMDSTAT_VBUSDEBOUNCED_Pos = 0x1c
	// Bit mask of VBUSDEBOUNCED field.
	USB_DEVCMDSTAT_VBUSDEBOUNCED_Msk = 0x10000000
	// Bit VBUSDEBOUNCED.
	USB_DEVCMDSTAT_VBUSDEBOUNCED = 0x10000000
	// Position of RESERVED field.
	USB_DEVCMDSTAT_RESERVED_Pos = 0x1d
	// Bit mask of RESERVED field.
	USB_DEVCMDSTAT_RESERVED_Msk = 0xe0000000

	// INFO: USB Info register
	// Position of FRAME_NR field.
	USB_INFO_FRAME_NR_Pos = 0x0
	// Bit mask of FRAME_NR field.
	USB_INFO_FRAME_NR_Msk = 0x7ff
	// Position of ERR_CODE field.
	USB_INFO_ERR_CODE_Pos = 0xb
	// Bit mask of ERR_CODE field.
	USB_INFO_ERR_CODE_Msk = 0x7800
	// No error
	USB_INFO_ERR_CODE_NO_ERROR = 0x0
	// PID encoding error
	USB_INFO_ERR_CODE_PID_ENCODING_ERROR = 0x1
	// PID unknown
	USB_INFO_ERR_CODE_PID_UNKNOWN = 0x2
	// Packet unexpected
	USB_INFO_ERR_CODE_PACKET_UNEXPECTED = 0x3
	// Token CRC error
	USB_INFO_ERR_CODE_TOKEN_CRC_ERROR = 0x4
	// Data CRC error
	USB_INFO_ERR_CODE_DATA_CRC_ERROR = 0x5
	// Time out
	USB_INFO_ERR_CODE_TIME_OUT = 0x6
	// Babble
	USB_INFO_ERR_CODE_BABBLE = 0x7
	// Truncated EOP
	USB_INFO_ERR_CODE_TRUNCATED_EOP = 0x8
	// Sent/Received NAK
	USB_INFO_ERR_CODE_SENT_RECEIVED_NAK = 0x9
	// Sent Stall
	USB_INFO_ERR_CODE_SENT_STALL = 0xa
	// Overrun
	USB_INFO_ERR_CODE_OVERRUN = 0xb
	// Sent empty packet
	USB_INFO_ERR_CODE_SENT_EMPTY_PACKET = 0xc
	// Bitstuff error
	USB_INFO_ERR_CODE_BITSTUFF_ERROR = 0xd
	// Sync error
	USB_INFO_ERR_CODE_SYNC_ERROR = 0xe
	// Wrong data toggle
	USB_INFO_ERR_CODE_WRONG_DATA_TOGGLE = 0xf
	// Position of RESERVED field.
	USB_INFO_RESERVED_Pos = 0xf
	// Bit mask of RESERVED field.
	USB_INFO_RESERVED_Msk = 0x8000
	// Bit RESERVED.
	USB_INFO_RESERVED = 0x8000
	// Position of RESERVED field.
	USB_INFO_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	USB_INFO_RESERVED_Msk = 0xffff0000

	// EPLISTSTART: USB EP Command/Status List start address
	// Position of RESERVED field.
	USB_EPLISTSTART_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	USB_EPLISTSTART_RESERVED_Msk = 0xff
	// Position of EP_LIST field.
	USB_EPLISTSTART_EP_LIST_Pos = 0x8
	// Bit mask of EP_LIST field.
	USB_EPLISTSTART_EP_LIST_Msk = 0xffffff00

	// DATABUFSTART: USB Data buffer start address
	// Position of RESERVED field.
	USB_DATABUFSTART_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	USB_DATABUFSTART_RESERVED_Msk = 0x3fffff
	// Position of DA_BUF field.
	USB_DATABUFSTART_DA_BUF_Pos = 0x16
	// Bit mask of DA_BUF field.
	USB_DATABUFSTART_DA_BUF_Msk = 0xffc00000

	// LPM: Link Power Management register
	// Position of HIRD_HW field.
	USB_LPM_HIRD_HW_Pos = 0x0
	// Bit mask of HIRD_HW field.
	USB_LPM_HIRD_HW_Msk = 0xf
	// Position of HIRD_SW field.
	USB_LPM_HIRD_SW_Pos = 0x4
	// Bit mask of HIRD_SW field.
	USB_LPM_HIRD_SW_Msk = 0xf0
	// Position of DATA_PENDING field.
	USB_LPM_DATA_PENDING_Pos = 0x8
	// Bit mask of DATA_PENDING field.
	USB_LPM_DATA_PENDING_Msk = 0x100
	// Bit DATA_PENDING.
	USB_LPM_DATA_PENDING = 0x100
	// Position of RESERVED field.
	USB_LPM_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	USB_LPM_RESERVED_Msk = 0xfffffe00

	// EPSKIP: USB Endpoint skip
	// Position of SKIP field.
	USB_EPSKIP_SKIP_Pos = 0x0
	// Bit mask of SKIP field.
	USB_EPSKIP_SKIP_Msk = 0x3fffffff
	// Position of RESERVED field.
	USB_EPSKIP_RESERVED_Pos = 0x1e
	// Bit mask of RESERVED field.
	USB_EPSKIP_RESERVED_Msk = 0xc0000000

	// EPINUSE: USB Endpoint Buffer in use
	// Position of RESERVED field.
	USB_EPINUSE_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	USB_EPINUSE_RESERVED_Msk = 0x3
	// Position of BUF field.
	USB_EPINUSE_BUF_Pos = 0x2
	// Bit mask of BUF field.
	USB_EPINUSE_BUF_Msk = 0x3fc
	// Position of RESERVED field.
	USB_EPINUSE_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	USB_EPINUSE_RESERVED_Msk = 0xfffffc00

	// EPBUFCFG: USB Endpoint Buffer Configuration register
	// Position of RESERVED field.
	USB_EPBUFCFG_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	USB_EPBUFCFG_RESERVED_Msk = 0x3
	// Position of BUF_SB field.
	USB_EPBUFCFG_BUF_SB_Pos = 0x2
	// Bit mask of BUF_SB field.
	USB_EPBUFCFG_BUF_SB_Msk = 0x3fc
	// Position of RESERVED field.
	USB_EPBUFCFG_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	USB_EPBUFCFG_RESERVED_Msk = 0xfffffc00

	// INTSTAT: USB interrupt status register
	// Position of EP0OUT field.
	USB_INTSTAT_EP0OUT_Pos = 0x0
	// Bit mask of EP0OUT field.
	USB_INTSTAT_EP0OUT_Msk = 0x1
	// Bit EP0OUT.
	USB_INTSTAT_EP0OUT = 0x1
	// Position of EP0IN field.
	USB_INTSTAT_EP0IN_Pos = 0x1
	// Bit mask of EP0IN field.
	USB_INTSTAT_EP0IN_Msk = 0x2
	// Bit EP0IN.
	USB_INTSTAT_EP0IN = 0x2
	// Position of EP1OUT field.
	USB_INTSTAT_EP1OUT_Pos = 0x2
	// Bit mask of EP1OUT field.
	USB_INTSTAT_EP1OUT_Msk = 0x4
	// Bit EP1OUT.
	USB_INTSTAT_EP1OUT = 0x4
	// Position of EP1IN field.
	USB_INTSTAT_EP1IN_Pos = 0x3
	// Bit mask of EP1IN field.
	USB_INTSTAT_EP1IN_Msk = 0x8
	// Bit EP1IN.
	USB_INTSTAT_EP1IN = 0x8
	// Position of EP2OUT field.
	USB_INTSTAT_EP2OUT_Pos = 0x4
	// Bit mask of EP2OUT field.
	USB_INTSTAT_EP2OUT_Msk = 0x10
	// Bit EP2OUT.
	USB_INTSTAT_EP2OUT = 0x10
	// Position of EP2IN field.
	USB_INTSTAT_EP2IN_Pos = 0x5
	// Bit mask of EP2IN field.
	USB_INTSTAT_EP2IN_Msk = 0x20
	// Bit EP2IN.
	USB_INTSTAT_EP2IN = 0x20
	// Position of EP3OUT field.
	USB_INTSTAT_EP3OUT_Pos = 0x6
	// Bit mask of EP3OUT field.
	USB_INTSTAT_EP3OUT_Msk = 0x40
	// Bit EP3OUT.
	USB_INTSTAT_EP3OUT = 0x40
	// Position of EP3IN field.
	USB_INTSTAT_EP3IN_Pos = 0x7
	// Bit mask of EP3IN field.
	USB_INTSTAT_EP3IN_Msk = 0x80
	// Bit EP3IN.
	USB_INTSTAT_EP3IN = 0x80
	// Position of EP4OUT field.
	USB_INTSTAT_EP4OUT_Pos = 0x8
	// Bit mask of EP4OUT field.
	USB_INTSTAT_EP4OUT_Msk = 0x100
	// Bit EP4OUT.
	USB_INTSTAT_EP4OUT = 0x100
	// Position of EP4IN field.
	USB_INTSTAT_EP4IN_Pos = 0x9
	// Bit mask of EP4IN field.
	USB_INTSTAT_EP4IN_Msk = 0x200
	// Bit EP4IN.
	USB_INTSTAT_EP4IN = 0x200
	// Position of RESERVED field.
	USB_INTSTAT_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	USB_INTSTAT_RESERVED_Msk = 0x3ffffc00
	// Position of FRAME_INT field.
	USB_INTSTAT_FRAME_INT_Pos = 0x1e
	// Bit mask of FRAME_INT field.
	USB_INTSTAT_FRAME_INT_Msk = 0x40000000
	// Bit FRAME_INT.
	USB_INTSTAT_FRAME_INT = 0x40000000
	// Position of DEV_INT field.
	USB_INTSTAT_DEV_INT_Pos = 0x1f
	// Bit mask of DEV_INT field.
	USB_INTSTAT_DEV_INT_Msk = 0x80000000
	// Bit DEV_INT.
	USB_INTSTAT_DEV_INT = 0x80000000

	// INTEN: USB interrupt enable register
	// Position of EP_INT_EN field.
	USB_INTEN_EP_INT_EN_Pos = 0x0
	// Bit mask of EP_INT_EN field.
	USB_INTEN_EP_INT_EN_Msk = 0x3ff
	// Position of RESERVED field.
	USB_INTEN_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	USB_INTEN_RESERVED_Msk = 0x3ffffc00
	// Position of FRAME_INT_EN field.
	USB_INTEN_FRAME_INT_EN_Pos = 0x1e
	// Bit mask of FRAME_INT_EN field.
	USB_INTEN_FRAME_INT_EN_Msk = 0x40000000
	// Bit FRAME_INT_EN.
	USB_INTEN_FRAME_INT_EN = 0x40000000
	// Position of DEV_INT_EN field.
	USB_INTEN_DEV_INT_EN_Pos = 0x1f
	// Bit mask of DEV_INT_EN field.
	USB_INTEN_DEV_INT_EN_Msk = 0x80000000
	// Bit DEV_INT_EN.
	USB_INTEN_DEV_INT_EN = 0x80000000

	// INTSETSTAT: USB set interrupt status register
	// Position of EP_SET_INT field.
	USB_INTSETSTAT_EP_SET_INT_Pos = 0x0
	// Bit mask of EP_SET_INT field.
	USB_INTSETSTAT_EP_SET_INT_Msk = 0x3ff
	// Position of RESERVED field.
	USB_INTSETSTAT_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	USB_INTSETSTAT_RESERVED_Msk = 0x3ffffc00
	// Position of FRAME_SET_INT field.
	USB_INTSETSTAT_FRAME_SET_INT_Pos = 0x1e
	// Bit mask of FRAME_SET_INT field.
	USB_INTSETSTAT_FRAME_SET_INT_Msk = 0x40000000
	// Bit FRAME_SET_INT.
	USB_INTSETSTAT_FRAME_SET_INT = 0x40000000
	// Position of DEV_SET_INT field.
	USB_INTSETSTAT_DEV_SET_INT_Pos = 0x1f
	// Bit mask of DEV_SET_INT field.
	USB_INTSETSTAT_DEV_SET_INT_Msk = 0x80000000
	// Bit DEV_SET_INT.
	USB_INTSETSTAT_DEV_SET_INT = 0x80000000

	// INTROUTING: USB interrupt routing register
	// Position of ROUTE_INT9_0 field.
	USB_INTROUTING_ROUTE_INT9_0_Pos = 0x0
	// Bit mask of ROUTE_INT9_0 field.
	USB_INTROUTING_ROUTE_INT9_0_Msk = 0x3ff
	// Position of RESERVED field.
	USB_INTROUTING_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	USB_INTROUTING_RESERVED_Msk = 0x3ffffc00
	// Position of ROUTE_INT30 field.
	USB_INTROUTING_ROUTE_INT30_Pos = 0x1e
	// Bit mask of ROUTE_INT30 field.
	USB_INTROUTING_ROUTE_INT30_Msk = 0x40000000
	// Bit ROUTE_INT30.
	USB_INTROUTING_ROUTE_INT30 = 0x40000000
	// Position of ROUTE_INT31 field.
	USB_INTROUTING_ROUTE_INT31_Pos = 0x1f
	// Bit mask of ROUTE_INT31 field.
	USB_INTROUTING_ROUTE_INT31_Msk = 0x80000000
	// Bit ROUTE_INT31.
	USB_INTROUTING_ROUTE_INT31 = 0x80000000

	// EPTOGGLE: USB Endpoint toggle register
	// Position of TOGGLE field.
	USB_EPTOGGLE_TOGGLE_Pos = 0x0
	// Bit mask of TOGGLE field.
	USB_EPTOGGLE_TOGGLE_Msk = 0x3ff
	// Position of RESERVED field.
	USB_EPTOGGLE_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	USB_EPTOGGLE_RESERVED_Msk = 0xfffffc00
)

// Bitfields for CRC: Cyclic Redundancy Check (CRC) engine
const (
	// MODE: CRC mode register
	// Position of CRC_POLY field.
	CRC_MODE_CRC_POLY_Pos = 0x0
	// Bit mask of CRC_POLY field.
	CRC_MODE_CRC_POLY_Msk = 0x3
	// Position of BIT_RVS_WR field.
	CRC_MODE_BIT_RVS_WR_Pos = 0x2
	// Bit mask of BIT_RVS_WR field.
	CRC_MODE_BIT_RVS_WR_Msk = 0x4
	// Bit BIT_RVS_WR.
	CRC_MODE_BIT_RVS_WR = 0x4
	// Position of CMPL_WR field.
	CRC_MODE_CMPL_WR_Pos = 0x3
	// Bit mask of CMPL_WR field.
	CRC_MODE_CMPL_WR_Msk = 0x8
	// Bit CMPL_WR.
	CRC_MODE_CMPL_WR = 0x8
	// Position of BIT_RVS_SUM field.
	CRC_MODE_BIT_RVS_SUM_Pos = 0x4
	// Bit mask of BIT_RVS_SUM field.
	CRC_MODE_BIT_RVS_SUM_Msk = 0x10
	// Bit BIT_RVS_SUM.
	CRC_MODE_BIT_RVS_SUM = 0x10
	// Position of CMPL_SUM field.
	CRC_MODE_CMPL_SUM_Pos = 0x5
	// Bit mask of CMPL_SUM field.
	CRC_MODE_CMPL_SUM_Msk = 0x20
	// Bit CMPL_SUM.
	CRC_MODE_CMPL_SUM = 0x20
	// Position of Reserved field.
	CRC_MODE_Reserved_Pos = 0x6
	// Bit mask of Reserved field.
	CRC_MODE_Reserved_Msk = 0xffffffc0

	// SEED: CRC seed register
	// Position of CRC_SEED field.
	CRC_SEED_CRC_SEED_Pos = 0x0
	// Bit mask of CRC_SEED field.
	CRC_SEED_CRC_SEED_Msk = 0xffffffff

	// SUM: CRC checksum register
	// Position of CRC_SUM field.
	CRC_SUM_CRC_SUM_Pos = 0x0
	// Bit mask of CRC_SUM field.
	CRC_SUM_CRC_SUM_Msk = 0xffffffff

	// WR_DATA: CRC data register
	// Position of CRC_WR_DATA field.
	CRC_WR_DATA_CRC_WR_DATA_Pos = 0x0
	// Bit mask of CRC_WR_DATA field.
	CRC_WR_DATA_CRC_WR_DATA_Msk = 0xffffffff
)

// Bitfields for SCT0: Large State Configurable Timers 0/1 (SCT0/1)
const (
	// CONFIG: SCT configuration register
	// Position of UNIFY field.
	SCT0_CONFIG_UNIFY_Pos = 0x0
	// Bit mask of UNIFY field.
	SCT0_CONFIG_UNIFY_Msk = 0x1
	// Bit UNIFY.
	SCT0_CONFIG_UNIFY = 0x1
	// Position of CLKMODE field.
	SCT0_CONFIG_CLKMODE_Pos = 0x1
	// Bit mask of CLKMODE field.
	SCT0_CONFIG_CLKMODE_Msk = 0x6
	// System clock. The system clock clocks the SCT and prescalers.
	SCT0_CONFIG_CLKMODE_SYSTEM_CLOCK = 0x0
	// Prescaled system clock. The SCT clock is the system clock, but the prescalers are enabled to count only when sampling of the input selected by the CKSEL field finds the selected edge. The minimum pulse width on the clock input is 1 bus clock period. This mode is the high-performance sampled-clock mode.
	SCT0_CONFIG_CLKMODE_PRESCALED_SYSTEM_CLO = 0x1
	// SCT input. The input selected by CLKSEL clocks the SCT and prescalers. The input is synchronized to the bus clock and possibly inverted. The minimum pulse width on the clock input is 1 bus clock period. This mode is the low-power sampled-clock mode.
	SCT0_CONFIG_CLKMODE_SCT_INPUT = 0x2
	// Prescaled SCT input. The SCT and prescalers are clocked by the input edge selected by the CLKSEL field. In this mode, most of the SCT is clocked by the (selected polarity of the) input. The outputs are switched synchronously to the input clock. The input clock rate must be at least half the system clock rate and can the same or faster than the system clock.
	SCT0_CONFIG_CLKMODE_PRESCALED_SCT_INPUT = 0x3
	// Position of CLKSEL field.
	SCT0_CONFIG_CLKSEL_Pos = 0x3
	// Bit mask of CLKSEL field.
	SCT0_CONFIG_CLKSEL_Msk = 0x78
	// Position of NORELAOD_L field.
	SCT0_CONFIG_NORELAOD_L_Pos = 0x7
	// Bit mask of NORELAOD_L field.
	SCT0_CONFIG_NORELAOD_L_Msk = 0x80
	// Bit NORELAOD_L.
	SCT0_CONFIG_NORELAOD_L = 0x80
	// Position of NORELOAD_H field.
	SCT0_CONFIG_NORELOAD_H_Pos = 0x8
	// Bit mask of NORELOAD_H field.
	SCT0_CONFIG_NORELOAD_H_Msk = 0x100
	// Bit NORELOAD_H.
	SCT0_CONFIG_NORELOAD_H = 0x100
	// Position of INSYNC field.
	SCT0_CONFIG_INSYNC_Pos = 0x9
	// Bit mask of INSYNC field.
	SCT0_CONFIG_INSYNC_Msk = 0x1fe00
	// Position of AUTOLIMIT_L field.
	SCT0_CONFIG_AUTOLIMIT_L_Pos = 0x11
	// Bit mask of AUTOLIMIT_L field.
	SCT0_CONFIG_AUTOLIMIT_L_Msk = 0x20000
	// Bit AUTOLIMIT_L.
	SCT0_CONFIG_AUTOLIMIT_L = 0x20000
	// Position of AUTOLIMIT_H field.
	SCT0_CONFIG_AUTOLIMIT_H_Pos = 0x12
	// Bit mask of AUTOLIMIT_H field.
	SCT0_CONFIG_AUTOLIMIT_H_Msk = 0x40000
	// Bit AUTOLIMIT_H.
	SCT0_CONFIG_AUTOLIMIT_H = 0x40000
	// Position of RESERVED field.
	SCT0_CONFIG_RESERVED_Pos = 0x13
	// Bit mask of RESERVED field.
	SCT0_CONFIG_RESERVED_Msk = 0xfff80000

	// CTRL: SCT control register
	// Position of DOWN_L field.
	SCT0_CTRL_DOWN_L_Pos = 0x0
	// Bit mask of DOWN_L field.
	SCT0_CTRL_DOWN_L_Msk = 0x1
	// Bit DOWN_L.
	SCT0_CTRL_DOWN_L = 0x1
	// Position of STOP_L field.
	SCT0_CTRL_STOP_L_Pos = 0x1
	// Bit mask of STOP_L field.
	SCT0_CTRL_STOP_L_Msk = 0x2
	// Bit STOP_L.
	SCT0_CTRL_STOP_L = 0x2
	// Position of HALT_L field.
	SCT0_CTRL_HALT_L_Pos = 0x2
	// Bit mask of HALT_L field.
	SCT0_CTRL_HALT_L_Msk = 0x4
	// Bit HALT_L.
	SCT0_CTRL_HALT_L = 0x4
	// Position of CLRCTR_L field.
	SCT0_CTRL_CLRCTR_L_Pos = 0x3
	// Bit mask of CLRCTR_L field.
	SCT0_CTRL_CLRCTR_L_Msk = 0x8
	// Bit CLRCTR_L.
	SCT0_CTRL_CLRCTR_L = 0x8
	// Position of BIDIR_L field.
	SCT0_CTRL_BIDIR_L_Pos = 0x4
	// Bit mask of BIDIR_L field.
	SCT0_CTRL_BIDIR_L_Msk = 0x10
	// Bit BIDIR_L.
	SCT0_CTRL_BIDIR_L = 0x10
	// Position of PRE_L field.
	SCT0_CTRL_PRE_L_Pos = 0x5
	// Bit mask of PRE_L field.
	SCT0_CTRL_PRE_L_Msk = 0x1fe0
	// Position of RESERVED field.
	SCT0_CTRL_RESERVED_Pos = 0xd
	// Bit mask of RESERVED field.
	SCT0_CTRL_RESERVED_Msk = 0xe000
	// Position of DOWN_H field.
	SCT0_CTRL_DOWN_H_Pos = 0x10
	// Bit mask of DOWN_H field.
	SCT0_CTRL_DOWN_H_Msk = 0x10000
	// Bit DOWN_H.
	SCT0_CTRL_DOWN_H = 0x10000
	// Position of STOP_H field.
	SCT0_CTRL_STOP_H_Pos = 0x11
	// Bit mask of STOP_H field.
	SCT0_CTRL_STOP_H_Msk = 0x20000
	// Bit STOP_H.
	SCT0_CTRL_STOP_H = 0x20000
	// Position of HALT_H field.
	SCT0_CTRL_HALT_H_Pos = 0x12
	// Bit mask of HALT_H field.
	SCT0_CTRL_HALT_H_Msk = 0x40000
	// Bit HALT_H.
	SCT0_CTRL_HALT_H = 0x40000
	// Position of CLRCTR_H field.
	SCT0_CTRL_CLRCTR_H_Pos = 0x13
	// Bit mask of CLRCTR_H field.
	SCT0_CTRL_CLRCTR_H_Msk = 0x80000
	// Bit CLRCTR_H.
	SCT0_CTRL_CLRCTR_H = 0x80000
	// Position of BIDIR_H field.
	SCT0_CTRL_BIDIR_H_Pos = 0x14
	// Bit mask of BIDIR_H field.
	SCT0_CTRL_BIDIR_H_Msk = 0x100000
	// Bit BIDIR_H.
	SCT0_CTRL_BIDIR_H = 0x100000
	// Position of PRE_H field.
	SCT0_CTRL_PRE_H_Pos = 0x15
	// Bit mask of PRE_H field.
	SCT0_CTRL_PRE_H_Msk = 0x1fe00000
	// Position of RESERVED field.
	SCT0_CTRL_RESERVED_Pos = 0x1d
	// Bit mask of RESERVED field.
	SCT0_CTRL_RESERVED_Msk = 0xe0000000

	// LIMIT: SCT limit register
	// Position of LIMMSK_L field.
	SCT0_LIMIT_LIMMSK_L_Pos = 0x0
	// Bit mask of LIMMSK_L field.
	SCT0_LIMIT_LIMMSK_L_Msk = 0xffff
	// Position of LIMMSK_H field.
	SCT0_LIMIT_LIMMSK_H_Pos = 0x10
	// Bit mask of LIMMSK_H field.
	SCT0_LIMIT_LIMMSK_H_Msk = 0xffff0000

	// HALT: SCT halt condition register
	// Position of HALTMSK_L field.
	SCT0_HALT_HALTMSK_L_Pos = 0x0
	// Bit mask of HALTMSK_L field.
	SCT0_HALT_HALTMSK_L_Msk = 0xffff
	// Position of HALTMSK_H field.
	SCT0_HALT_HALTMSK_H_Pos = 0x10
	// Bit mask of HALTMSK_H field.
	SCT0_HALT_HALTMSK_H_Msk = 0xffff0000

	// STOP: SCT stop condition register
	// Position of STOPMSK_L field.
	SCT0_STOP_STOPMSK_L_Pos = 0x0
	// Bit mask of STOPMSK_L field.
	SCT0_STOP_STOPMSK_L_Msk = 0xffff
	// Position of STOPMSK_H field.
	SCT0_STOP_STOPMSK_H_Pos = 0x10
	// Bit mask of STOPMSK_H field.
	SCT0_STOP_STOPMSK_H_Msk = 0xffff0000

	// START: SCT start condition register
	// Position of STARTMSK_L field.
	SCT0_START_STARTMSK_L_Pos = 0x0
	// Bit mask of STARTMSK_L field.
	SCT0_START_STARTMSK_L_Msk = 0xffff
	// Position of STARTMSK_H field.
	SCT0_START_STARTMSK_H_Pos = 0x10
	// Bit mask of STARTMSK_H field.
	SCT0_START_STARTMSK_H_Msk = 0xffff0000

	// DITHER: SCT dither condition register
	// Position of DITHMSK_L field.
	SCT0_DITHER_DITHMSK_L_Pos = 0x0
	// Bit mask of DITHMSK_L field.
	SCT0_DITHER_DITHMSK_L_Msk = 0xffff
	// Position of DITHMSK_H field.
	SCT0_DITHER_DITHMSK_H_Pos = 0x10
	// Bit mask of DITHMSK_H field.
	SCT0_DITHER_DITHMSK_H_Msk = 0xffff0000

	// COUNT: SCT counter register
	// Position of CTR_L field.
	SCT0_COUNT_CTR_L_Pos = 0x0
	// Bit mask of CTR_L field.
	SCT0_COUNT_CTR_L_Msk = 0xffff
	// Position of CTR_H field.
	SCT0_COUNT_CTR_H_Pos = 0x10
	// Bit mask of CTR_H field.
	SCT0_COUNT_CTR_H_Msk = 0xffff0000

	// STATE: SCT state register
	// Position of STATE_L field.
	SCT0_STATE_STATE_L_Pos = 0x0
	// Bit mask of STATE_L field.
	SCT0_STATE_STATE_L_Msk = 0x1f
	// Position of RESERVED field.
	SCT0_STATE_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	SCT0_STATE_RESERVED_Msk = 0xffe0
	// Position of STATE_H field.
	SCT0_STATE_STATE_H_Pos = 0x10
	// Bit mask of STATE_H field.
	SCT0_STATE_STATE_H_Msk = 0x1f0000
	// Position of RESERVED field.
	SCT0_STATE_RESERVED_Pos = 0x15
	// Bit mask of RESERVED field.
	SCT0_STATE_RESERVED_Msk = 0xffe00000

	// INPUT: SCT input register
	// Position of AIN0 field.
	SCT0_INPUT_AIN0_Pos = 0x0
	// Bit mask of AIN0 field.
	SCT0_INPUT_AIN0_Msk = 0x1
	// Bit AIN0.
	SCT0_INPUT_AIN0 = 0x1
	// Position of AIN1 field.
	SCT0_INPUT_AIN1_Pos = 0x1
	// Bit mask of AIN1 field.
	SCT0_INPUT_AIN1_Msk = 0x2
	// Bit AIN1.
	SCT0_INPUT_AIN1 = 0x2
	// Position of AIN2 field.
	SCT0_INPUT_AIN2_Pos = 0x2
	// Bit mask of AIN2 field.
	SCT0_INPUT_AIN2_Msk = 0x4
	// Bit AIN2.
	SCT0_INPUT_AIN2 = 0x4
	// Position of AIN3 field.
	SCT0_INPUT_AIN3_Pos = 0x3
	// Bit mask of AIN3 field.
	SCT0_INPUT_AIN3_Msk = 0x8
	// Bit AIN3.
	SCT0_INPUT_AIN3 = 0x8
	// Position of AIN4 field.
	SCT0_INPUT_AIN4_Pos = 0x4
	// Bit mask of AIN4 field.
	SCT0_INPUT_AIN4_Msk = 0x10
	// Bit AIN4.
	SCT0_INPUT_AIN4 = 0x10
	// Position of AIN5 field.
	SCT0_INPUT_AIN5_Pos = 0x5
	// Bit mask of AIN5 field.
	SCT0_INPUT_AIN5_Msk = 0x20
	// Bit AIN5.
	SCT0_INPUT_AIN5 = 0x20
	// Position of AIN6 field.
	SCT0_INPUT_AIN6_Pos = 0x6
	// Bit mask of AIN6 field.
	SCT0_INPUT_AIN6_Msk = 0x40
	// Bit AIN6.
	SCT0_INPUT_AIN6 = 0x40
	// Position of AIN7 field.
	SCT0_INPUT_AIN7_Pos = 0x7
	// Bit mask of AIN7 field.
	SCT0_INPUT_AIN7_Msk = 0x80
	// Bit AIN7.
	SCT0_INPUT_AIN7 = 0x80
	// Position of RESERVED field.
	SCT0_INPUT_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SCT0_INPUT_RESERVED_Msk = 0xff00
	// Position of SIN0 field.
	SCT0_INPUT_SIN0_Pos = 0x10
	// Bit mask of SIN0 field.
	SCT0_INPUT_SIN0_Msk = 0x10000
	// Bit SIN0.
	SCT0_INPUT_SIN0 = 0x10000
	// Position of SIN1 field.
	SCT0_INPUT_SIN1_Pos = 0x11
	// Bit mask of SIN1 field.
	SCT0_INPUT_SIN1_Msk = 0x20000
	// Bit SIN1.
	SCT0_INPUT_SIN1 = 0x20000
	// Position of SIN2 field.
	SCT0_INPUT_SIN2_Pos = 0x12
	// Bit mask of SIN2 field.
	SCT0_INPUT_SIN2_Msk = 0x40000
	// Bit SIN2.
	SCT0_INPUT_SIN2 = 0x40000
	// Position of SIN3 field.
	SCT0_INPUT_SIN3_Pos = 0x13
	// Bit mask of SIN3 field.
	SCT0_INPUT_SIN3_Msk = 0x80000
	// Bit SIN3.
	SCT0_INPUT_SIN3 = 0x80000
	// Position of SIN4 field.
	SCT0_INPUT_SIN4_Pos = 0x14
	// Bit mask of SIN4 field.
	SCT0_INPUT_SIN4_Msk = 0x100000
	// Bit SIN4.
	SCT0_INPUT_SIN4 = 0x100000
	// Position of SIN5 field.
	SCT0_INPUT_SIN5_Pos = 0x15
	// Bit mask of SIN5 field.
	SCT0_INPUT_SIN5_Msk = 0x200000
	// Bit SIN5.
	SCT0_INPUT_SIN5 = 0x200000
	// Position of SIN6 field.
	SCT0_INPUT_SIN6_Pos = 0x16
	// Bit mask of SIN6 field.
	SCT0_INPUT_SIN6_Msk = 0x400000
	// Bit SIN6.
	SCT0_INPUT_SIN6 = 0x400000
	// Position of SIN7 field.
	SCT0_INPUT_SIN7_Pos = 0x17
	// Bit mask of SIN7 field.
	SCT0_INPUT_SIN7_Msk = 0x800000
	// Bit SIN7.
	SCT0_INPUT_SIN7 = 0x800000
	// Position of RESERVED field.
	SCT0_INPUT_RESERVED_Pos = 0x18
	// Bit mask of RESERVED field.
	SCT0_INPUT_RESERVED_Msk = 0xff000000

	// REGMODE: SCT match/capture registers mode register
	// Position of REGMOD_L field.
	SCT0_REGMODE_REGMOD_L_Pos = 0x0
	// Bit mask of REGMOD_L field.
	SCT0_REGMODE_REGMOD_L_Msk = 0xffff
	// Position of REGMOD_H field.
	SCT0_REGMODE_REGMOD_H_Pos = 0x10
	// Bit mask of REGMOD_H field.
	SCT0_REGMODE_REGMOD_H_Msk = 0xffff0000

	// OUTPUT: SCT output register
	// Position of OUT field.
	SCT0_OUTPUT_OUT_Pos = 0x0
	// Bit mask of OUT field.
	SCT0_OUTPUT_OUT_Msk = 0x3ff
	// Position of RESERVED field.
	SCT0_OUTPUT_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	SCT0_OUTPUT_RESERVED_Msk = 0xfffffc00

	// OUTPUTDIRCTRL: SCT output counter direction control register
	// Position of SETCLR0 field.
	SCT0_OUTPUTDIRCTRL_SETCLR0_Pos = 0x0
	// Bit mask of SETCLR0 field.
	SCT0_OUTPUTDIRCTRL_SETCLR0_Msk = 0x3
	// Set and clear do not depend on any counter.
	SCT0_OUTPUTDIRCTRL_SETCLR0_SET_AND_CLEAR_DO_NOT = 0x0
	// Position of SETCLR1 field.
	SCT0_OUTPUTDIRCTRL_SETCLR1_Pos = 0x2
	// Bit mask of SETCLR1 field.
	SCT0_OUTPUTDIRCTRL_SETCLR1_Msk = 0xc
	// Set and clear do not depend on any counter.
	SCT0_OUTPUTDIRCTRL_SETCLR1_SET_AND_CLEAR_DO_NOT = 0x0
	// Position of SETCLR2 field.
	SCT0_OUTPUTDIRCTRL_SETCLR2_Pos = 0x4
	// Bit mask of SETCLR2 field.
	SCT0_OUTPUTDIRCTRL_SETCLR2_Msk = 0x30
	// Set and clear do not depend on any counter.
	SCT0_OUTPUTDIRCTRL_SETCLR2_SET_AND_CLEAR_DO_NOT = 0x0
	// Position of SETCLR3 field.
	SCT0_OUTPUTDIRCTRL_SETCLR3_Pos = 0x6
	// Bit mask of SETCLR3 field.
	SCT0_OUTPUTDIRCTRL_SETCLR3_Msk = 0xc0
	// Set and clear do not depend on any counter.
	SCT0_OUTPUTDIRCTRL_SETCLR3_SET_AND_CLEAR_DO_NOT = 0x0
	// Position of SETCLR4 field.
	SCT0_OUTPUTDIRCTRL_SETCLR4_Pos = 0x8
	// Bit mask of SETCLR4 field.
	SCT0_OUTPUTDIRCTRL_SETCLR4_Msk = 0x300
	// Set and clear do not depend on any counter.
	SCT0_OUTPUTDIRCTRL_SETCLR4_SET_AND_CLEAR_DO_NOT = 0x0
	// Position of SETCLR5 field.
	SCT0_OUTPUTDIRCTRL_SETCLR5_Pos = 0xa
	// Bit mask of SETCLR5 field.
	SCT0_OUTPUTDIRCTRL_SETCLR5_Msk = 0xc00
	// Set and clear do not depend on any counter.
	SCT0_OUTPUTDIRCTRL_SETCLR5_SET_AND_CLEAR_DO_NOT = 0x0
	// Position of SETCLR6 field.
	SCT0_OUTPUTDIRCTRL_SETCLR6_Pos = 0xc
	// Bit mask of SETCLR6 field.
	SCT0_OUTPUTDIRCTRL_SETCLR6_Msk = 0x3000
	// Set and clear do not depend on any counter.
	SCT0_OUTPUTDIRCTRL_SETCLR6_SET_AND_CLEAR_DO_NOT = 0x0
	// Position of SETCLR7 field.
	SCT0_OUTPUTDIRCTRL_SETCLR7_Pos = 0xe
	// Bit mask of SETCLR7 field.
	SCT0_OUTPUTDIRCTRL_SETCLR7_Msk = 0xc000
	// Set and clear do not depend on any counter.
	SCT0_OUTPUTDIRCTRL_SETCLR7_SET_AND_CLEAR_DO_NOT = 0x0
	// Position of SETCLR8 field.
	SCT0_OUTPUTDIRCTRL_SETCLR8_Pos = 0x10
	// Bit mask of SETCLR8 field.
	SCT0_OUTPUTDIRCTRL_SETCLR8_Msk = 0x30000
	// Set and clear do not depend on any counter.
	SCT0_OUTPUTDIRCTRL_SETCLR8_SET_AND_CLEAR_DO_NOT = 0x0
	// Position of SETCLR9 field.
	SCT0_OUTPUTDIRCTRL_SETCLR9_Pos = 0x12
	// Bit mask of SETCLR9 field.
	SCT0_OUTPUTDIRCTRL_SETCLR9_Msk = 0xc0000
	// Set and clear do not depend on any counter.
	SCT0_OUTPUTDIRCTRL_SETCLR9_SET_AND_CLEAR_DO_NOT = 0x0
	// Position of RESERVED field.
	SCT0_OUTPUTDIRCTRL_RESERVED_Pos = 0x14
	// Bit mask of RESERVED field.
	SCT0_OUTPUTDIRCTRL_RESERVED_Msk = 0xfff00000

	// RES: SCT conflict resolution register
	// Position of O0RES field.
	SCT0_RES_O0RES_Pos = 0x0
	// Bit mask of O0RES field.
	SCT0_RES_O0RES_Msk = 0x3
	// No change.
	SCT0_RES_O0RES_NO_CHANGE = 0x0
	// Set output (or clear based on the SETCLR0 field).
	SCT0_RES_O0RES_SET_OUTPUT_OR_CLEAR = 0x1
	// Clear output (or set based on the SETCLR0 field).
	SCT0_RES_O0RES_CLEAR_OUTPUT_OR_SET = 0x2
	// Toggle output.
	SCT0_RES_O0RES_TOGGLE_OUTPUT = 0x3
	// Position of O1RES field.
	SCT0_RES_O1RES_Pos = 0x2
	// Bit mask of O1RES field.
	SCT0_RES_O1RES_Msk = 0xc
	// No change.
	SCT0_RES_O1RES_NO_CHANGE = 0x0
	// Set output (or clear based on the SETCLR1 field).
	SCT0_RES_O1RES_SET_OUTPUT_OR_CLEAR = 0x1
	// Clear output (or set based on the SETCLR1 field).
	SCT0_RES_O1RES_CLEAR_OUTPUT_OR_SET = 0x2
	// Toggle output.
	SCT0_RES_O1RES_TOGGLE_OUTPUT = 0x3
	// Position of O2RES field.
	SCT0_RES_O2RES_Pos = 0x4
	// Bit mask of O2RES field.
	SCT0_RES_O2RES_Msk = 0x30
	// No change.
	SCT0_RES_O2RES_NO_CHANGE = 0x0
	// Set output (or clear based on the SETCLR2 field).
	SCT0_RES_O2RES_SET_OUTPUT_OR_CLEAR = 0x1
	// Clear output n (or set based on the SETCLR2 field).
	SCT0_RES_O2RES_CLEAR_OUTPUT_N_OR_S = 0x2
	// Toggle output.
	SCT0_RES_O2RES_TOGGLE_OUTPUT = 0x3
	// Position of O3RES field.
	SCT0_RES_O3RES_Pos = 0x6
	// Bit mask of O3RES field.
	SCT0_RES_O3RES_Msk = 0xc0
	// No change.
	SCT0_RES_O3RES_NO_CHANGE = 0x0
	// Set output (or clear based on the SETCLR3 field).
	SCT0_RES_O3RES_SET_OUTPUT_OR_CLEAR = 0x1
	// Clear output (or set based on the SETCLR3 field).
	SCT0_RES_O3RES_CLEAR_OUTPUT_OR_SET = 0x2
	// Toggle output.
	SCT0_RES_O3RES_TOGGLE_OUTPUT = 0x3
	// Position of O4RES field.
	SCT0_RES_O4RES_Pos = 0x8
	// Bit mask of O4RES field.
	SCT0_RES_O4RES_Msk = 0x300
	// No change.
	SCT0_RES_O4RES_NO_CHANGE = 0x0
	// Set output (or clear based on the SETCLR4 field).
	SCT0_RES_O4RES_SET_OUTPUT_OR_CLEAR = 0x1
	// Clear output (or set based on the SETCLR4 field).
	SCT0_RES_O4RES_CLEAR_OUTPUT_OR_SET = 0x2
	// Toggle output.
	SCT0_RES_O4RES_TOGGLE_OUTPUT = 0x3
	// Position of O5RES field.
	SCT0_RES_O5RES_Pos = 0xa
	// Bit mask of O5RES field.
	SCT0_RES_O5RES_Msk = 0xc00
	// No change.
	SCT0_RES_O5RES_NO_CHANGE = 0x0
	// Set output (or clear based on the SETCLR5 field).
	SCT0_RES_O5RES_SET_OUTPUT_OR_CLEAR = 0x1
	// Clear output (or set based on the SETCLR5 field).
	SCT0_RES_O5RES_CLEAR_OUTPUT_OR_SET = 0x2
	// Toggle output.
	SCT0_RES_O5RES_TOGGLE_OUTPUT = 0x3
	// Position of O6RES field.
	SCT0_RES_O6RES_Pos = 0xc
	// Bit mask of O6RES field.
	SCT0_RES_O6RES_Msk = 0x3000
	// No change.
	SCT0_RES_O6RES_NO_CHANGE = 0x0
	// Set output (or clear based on the SETCLR6 field).
	SCT0_RES_O6RES_SET_OUTPUT_OR_CLEAR = 0x1
	// Clear output (or set based on the SETCLR6 field).
	SCT0_RES_O6RES_CLEAR_OUTPUT_OR_SET = 0x2
	// Toggle output.
	SCT0_RES_O6RES_TOGGLE_OUTPUT = 0x3
	// Position of O7RES field.
	SCT0_RES_O7RES_Pos = 0xe
	// Bit mask of O7RES field.
	SCT0_RES_O7RES_Msk = 0xc000
	// No change.
	SCT0_RES_O7RES_NO_CHANGE = 0x0
	// Set output (or clear based on the SETCLR7 field).
	SCT0_RES_O7RES_SET_OUTPUT_OR_CLEAR = 0x1
	// Clear output (or set based on the SETCLR7 field).
	SCT0_RES_O7RES_CLEAR_OUTPUT_OR_SET = 0x2
	// Toggle output.
	SCT0_RES_O7RES_TOGGLE_OUTPUT = 0x3
	// Position of O8RES field.
	SCT0_RES_O8RES_Pos = 0x10
	// Bit mask of O8RES field.
	SCT0_RES_O8RES_Msk = 0x30000
	// No change.
	SCT0_RES_O8RES_NO_CHANGE = 0x0
	// Set output (or clear based on the SETCLR8 field).
	SCT0_RES_O8RES_SET_OUTPUT_OR_CLEAR = 0x1
	// Clear output (or set based on the SETCLR8 field).
	SCT0_RES_O8RES_CLEAR_OUTPUT_OR_SET = 0x2
	// Toggle output.
	SCT0_RES_O8RES_TOGGLE_OUTPUT = 0x3
	// Position of O9RES field.
	SCT0_RES_O9RES_Pos = 0x12
	// Bit mask of O9RES field.
	SCT0_RES_O9RES_Msk = 0xc0000
	// No change.
	SCT0_RES_O9RES_NO_CHANGE = 0x0
	// Set output (or clear based on the SETCLR9 field).
	SCT0_RES_O9RES_SET_OUTPUT_OR_CLEAR = 0x1
	// Clear output (or set based on the SETCLR9 field).
	SCT0_RES_O9RES_CLEAR_OUTPUT_OR_SET = 0x2
	// Toggle output.
	SCT0_RES_O9RES_TOGGLE_OUTPUT = 0x3
	// Position of RESERVED field.
	SCT0_RES_RESERVED_Pos = 0x14
	// Bit mask of RESERVED field.
	SCT0_RES_RESERVED_Msk = 0xfff00000

	// DMAREQ0: SCT DMA request 0 register
	// Position of DEV_0 field.
	SCT0_DMAREQ0_DEV_0_Pos = 0x0
	// Bit mask of DEV_0 field.
	SCT0_DMAREQ0_DEV_0_Msk = 0xffff
	// Position of RESERVED field.
	SCT0_DMAREQ0_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	SCT0_DMAREQ0_RESERVED_Msk = 0x3fff0000
	// Position of DRL0 field.
	SCT0_DMAREQ0_DRL0_Pos = 0x1e
	// Bit mask of DRL0 field.
	SCT0_DMAREQ0_DRL0_Msk = 0x40000000
	// Bit DRL0.
	SCT0_DMAREQ0_DRL0 = 0x40000000
	// Position of DRQ0 field.
	SCT0_DMAREQ0_DRQ0_Pos = 0x1f
	// Bit mask of DRQ0 field.
	SCT0_DMAREQ0_DRQ0_Msk = 0x80000000
	// Bit DRQ0.
	SCT0_DMAREQ0_DRQ0 = 0x80000000

	// DMAREQ1: SCT DMA request 1 register
	// Position of DEV_1 field.
	SCT0_DMAREQ1_DEV_1_Pos = 0x0
	// Bit mask of DEV_1 field.
	SCT0_DMAREQ1_DEV_1_Msk = 0xffff
	// Position of RESERVED field.
	SCT0_DMAREQ1_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	SCT0_DMAREQ1_RESERVED_Msk = 0x3fff0000
	// Position of DRL1 field.
	SCT0_DMAREQ1_DRL1_Pos = 0x1e
	// Bit mask of DRL1 field.
	SCT0_DMAREQ1_DRL1_Msk = 0x40000000
	// Bit DRL1.
	SCT0_DMAREQ1_DRL1 = 0x40000000
	// Position of DRQ1 field.
	SCT0_DMAREQ1_DRQ1_Pos = 0x1f
	// Bit mask of DRQ1 field.
	SCT0_DMAREQ1_DRQ1_Msk = 0x80000000
	// Bit DRQ1.
	SCT0_DMAREQ1_DRQ1 = 0x80000000

	// EVEN: SCT event enable register
	// Position of IEN field.
	SCT0_EVEN_IEN_Pos = 0x0
	// Bit mask of IEN field.
	SCT0_EVEN_IEN_Msk = 0xffff
	// Position of RESERVED field.
	SCT0_EVEN_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	SCT0_EVEN_RESERVED_Msk = 0xffff0000

	// EVFLAG: SCT event flag register
	// Position of FLAG field.
	SCT0_EVFLAG_FLAG_Pos = 0x0
	// Bit mask of FLAG field.
	SCT0_EVFLAG_FLAG_Msk = 0xffff
	// Position of RESERVED field.
	SCT0_EVFLAG_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	SCT0_EVFLAG_RESERVED_Msk = 0xffff0000

	// CONEN: SCT conflict enable register
	// Position of NCEN field.
	SCT0_CONEN_NCEN_Pos = 0x0
	// Bit mask of NCEN field.
	SCT0_CONEN_NCEN_Msk = 0x3ff
	// Position of RESERVED field.
	SCT0_CONEN_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	SCT0_CONEN_RESERVED_Msk = 0xfffffc00

	// CONFLAG: SCT conflict flag register
	// Position of NCFLAG field.
	SCT0_CONFLAG_NCFLAG_Pos = 0x0
	// Bit mask of NCFLAG field.
	SCT0_CONFLAG_NCFLAG_Msk = 0x3ff
	// Position of RESERVED field.
	SCT0_CONFLAG_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	SCT0_CONFLAG_RESERVED_Msk = 0x3ffffc00
	// Position of BUSERRL field.
	SCT0_CONFLAG_BUSERRL_Pos = 0x1e
	// Bit mask of BUSERRL field.
	SCT0_CONFLAG_BUSERRL_Msk = 0x40000000
	// Bit BUSERRL.
	SCT0_CONFLAG_BUSERRL = 0x40000000
	// Position of BUSERRH field.
	SCT0_CONFLAG_BUSERRH_Pos = 0x1f
	// Bit mask of BUSERRH field.
	SCT0_CONFLAG_BUSERRH_Msk = 0x80000000
	// Bit BUSERRH.
	SCT0_CONFLAG_BUSERRH = 0x80000000

	// MATCH0: SCT match value register of match channels 0 to 15; REGMOD0 to REGMODE15 = 0
	// Position of MATCHn_L field.
	SCT0_MATCH_MATCHn_L_Pos = 0x0
	// Bit mask of MATCHn_L field.
	SCT0_MATCH_MATCHn_L_Msk = 0xffff
	// Position of MATCHn_H field.
	SCT0_MATCH_MATCHn_H_Pos = 0x10
	// Bit mask of MATCHn_H field.
	SCT0_MATCH_MATCHn_H_Msk = 0xffff0000

	// CAP0: SCT capture register of capture channel 0 to 15; REGMOD0 to REGMODE15 = 1
	// Position of CAPn_L field.
	SCT0_CAP_CAPn_L_Pos = 0x0
	// Bit mask of CAPn_L field.
	SCT0_CAP_CAPn_L_Msk = 0xffff
	// Position of CAPn_H field.
	SCT0_CAP_CAPn_H_Pos = 0x10
	// Bit mask of CAPn_H field.
	SCT0_CAP_CAPn_H_Msk = 0xffff0000

	// FRACMAT0: Fractional match registers 0 to 5 for SCT match value registers 0 to 5.
	// Position of FRACMAT_L field.
	SCT0_FRACMAT_FRACMAT_L_Pos = 0x0
	// Bit mask of FRACMAT_L field.
	SCT0_FRACMAT_FRACMAT_L_Msk = 0xf
	// Position of RESERVED field.
	SCT0_FRACMAT_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	SCT0_FRACMAT_RESERVED_Msk = 0xfff0
	// Position of FRACMAT_H field.
	SCT0_FRACMAT_FRACMAT_H_Pos = 0x10
	// Bit mask of FRACMAT_H field.
	SCT0_FRACMAT_FRACMAT_H_Msk = 0xf0000
	// Position of RESERVED field.
	SCT0_FRACMAT_RESERVED_Pos = 0x14
	// Bit mask of RESERVED field.
	SCT0_FRACMAT_RESERVED_Msk = 0xfff00000

	// MATCHREL0: SCT match reload value register 0 to 15; REGMOD0 = 0 to REGMODE15 = 0
	// Position of RELOADn_L field.
	SCT0_MATCHREL_RELOADn_L_Pos = 0x0
	// Bit mask of RELOADn_L field.
	SCT0_MATCHREL_RELOADn_L_Msk = 0xffff
	// Position of RELOADn_H field.
	SCT0_MATCHREL_RELOADn_H_Pos = 0x10
	// Bit mask of RELOADn_H field.
	SCT0_MATCHREL_RELOADn_H_Msk = 0xffff0000

	// CAPCTRL0: SCT capture control register 0 to 15; REGMOD0 = 1 to REGMODE15 = 1
	// Position of CAPCONn_L field.
	SCT0_CAPCTRL_CAPCONn_L_Pos = 0x0
	// Bit mask of CAPCONn_L field.
	SCT0_CAPCTRL_CAPCONn_L_Msk = 0xffff
	// Position of CAPCONn_H field.
	SCT0_CAPCTRL_CAPCONn_H_Pos = 0x10
	// Bit mask of CAPCONn_H field.
	SCT0_CAPCTRL_CAPCONn_H_Msk = 0xffff0000

	// FRACMATREL0: Fractional match reload registers 0 to 5 for SCT match value registers 0 to 5.
	// Position of RELFRAC_L field.
	SCT0_FRACMATREL_RELFRAC_L_Pos = 0x0
	// Bit mask of RELFRAC_L field.
	SCT0_FRACMATREL_RELFRAC_L_Msk = 0xf
	// Position of RESERVED field.
	SCT0_FRACMATREL_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	SCT0_FRACMATREL_RESERVED_Msk = 0xfff0
	// Position of RELFRAC_H field.
	SCT0_FRACMATREL_RELFRAC_H_Pos = 0x10
	// Bit mask of RELFRAC_H field.
	SCT0_FRACMATREL_RELFRAC_H_Msk = 0xf0000
	// Position of RESERVED field.
	SCT0_FRACMATREL_RESERVED_Pos = 0x14
	// Bit mask of RESERVED field.
	SCT0_FRACMATREL_RESERVED_Msk = 0xfff00000

	// EV0_STATE: SCT event state register 0
	// Position of STATEMSKn field.
	SCT0_EV_STATE_STATEMSKn_Pos = 0x0
	// Bit mask of STATEMSKn field.
	SCT0_EV_STATE_STATEMSKn_Msk = 0xffffffff

	// EV0_CTRL: SCT event control register 0
	// Position of MATCHSEL field.
	SCT0_EV_CTRL_MATCHSEL_Pos = 0x0
	// Bit mask of MATCHSEL field.
	SCT0_EV_CTRL_MATCHSEL_Msk = 0xf
	// Position of HEVENT field.
	SCT0_EV_CTRL_HEVENT_Pos = 0x4
	// Bit mask of HEVENT field.
	SCT0_EV_CTRL_HEVENT_Msk = 0x10
	// Bit HEVENT.
	SCT0_EV_CTRL_HEVENT = 0x10
	// Selects the L state and the L match register selected by MATCHSEL.
	SCT0_EV_CTRL_HEVENT_SELECTS_THE_L_STATE = 0x0
	// Selects the H state and the H match register selected by MATCHSEL.
	SCT0_EV_CTRL_HEVENT_SELECTS_THE_H_STATE = 0x1
	// Position of OUTSEL field.
	SCT0_EV_CTRL_OUTSEL_Pos = 0x5
	// Bit mask of OUTSEL field.
	SCT0_EV_CTRL_OUTSEL_Msk = 0x20
	// Bit OUTSEL.
	SCT0_EV_CTRL_OUTSEL = 0x20
	// Selects the input selected by IOSEL.
	SCT0_EV_CTRL_OUTSEL_SELECTS_THE_INPUT_SE = 0x0
	// Selects the output selected by IOSEL.
	SCT0_EV_CTRL_OUTSEL_SELECTS_THE_OUTPUT_S = 0x1
	// Position of IOSEL field.
	SCT0_EV_CTRL_IOSEL_Pos = 0x6
	// Bit mask of IOSEL field.
	SCT0_EV_CTRL_IOSEL_Msk = 0x3c0
	// Position of IOCOND field.
	SCT0_EV_CTRL_IOCOND_Pos = 0xa
	// Bit mask of IOCOND field.
	SCT0_EV_CTRL_IOCOND_Msk = 0xc00
	// LOW
	SCT0_EV_CTRL_IOCOND_LOW = 0x0
	// Rise
	SCT0_EV_CTRL_IOCOND_RISE = 0x1
	// Fall
	SCT0_EV_CTRL_IOCOND_FALL = 0x2
	// HIGH
	SCT0_EV_CTRL_IOCOND_HIGH = 0x3
	// Position of COMBMODE field.
	SCT0_EV_CTRL_COMBMODE_Pos = 0xc
	// Bit mask of COMBMODE field.
	SCT0_EV_CTRL_COMBMODE_Msk = 0x3000
	// OR. The event occurs when either the specified match or I/O condition occurs.
	SCT0_EV_CTRL_COMBMODE_OR = 0x0
	// MATCH. Uses the specified match only.
	SCT0_EV_CTRL_COMBMODE_MATCH = 0x1
	// IO. Uses the specified I/O condition only.
	SCT0_EV_CTRL_COMBMODE_IO = 0x2
	// AND. The event occurs when the specified match and I/O condition occur simultaneously.
	SCT0_EV_CTRL_COMBMODE_AND = 0x3
	// Position of STATELD field.
	SCT0_EV_CTRL_STATELD_Pos = 0xe
	// Bit mask of STATELD field.
	SCT0_EV_CTRL_STATELD_Msk = 0x4000
	// Bit STATELD.
	SCT0_EV_CTRL_STATELD = 0x4000
	// STATEV value is added into STATE (the carry-out is ignored).
	SCT0_EV_CTRL_STATELD_STATEV_VALUE_IS_ADDE = 0x0
	// STATEV value is loaded into STATE.
	SCT0_EV_CTRL_STATELD_STATEV_VALUE_IS_LOAD = 0x1
	// Position of STATEV field.
	SCT0_EV_CTRL_STATEV_Pos = 0xf
	// Bit mask of STATEV field.
	SCT0_EV_CTRL_STATEV_Msk = 0xf8000
	// Position of MATCHMEM field.
	SCT0_EV_CTRL_MATCHMEM_Pos = 0x14
	// Bit mask of MATCHMEM field.
	SCT0_EV_CTRL_MATCHMEM_Msk = 0x100000
	// Bit MATCHMEM.
	SCT0_EV_CTRL_MATCHMEM = 0x100000
	// Position of DIRECTION field.
	SCT0_EV_CTRL_DIRECTION_Pos = 0x15
	// Bit mask of DIRECTION field.
	SCT0_EV_CTRL_DIRECTION_Msk = 0x600000
	// Direction independent. This event is triggered regardless of the count direction.
	SCT0_EV_CTRL_DIRECTION_DIRECTION_INDEPENDEN = 0x0
	// Counting up. This event is triggered only during up-counting when BIDIR = 1.
	SCT0_EV_CTRL_DIRECTION_COUNTING_UP = 0x1
	// Counting down. This event is triggered only during down-counting when BIDIR = 1.
	SCT0_EV_CTRL_DIRECTION_COUNTING_DOWN = 0x2
	// Position of RESERVED field.
	SCT0_EV_CTRL_RESERVED_Pos = 0x17
	// Bit mask of RESERVED field.
	SCT0_EV_CTRL_RESERVED_Msk = 0xff800000

	// OUT0_SET: SCT output 0 set register
	// Position of SET field.
	SCT0_OUT_SET_SET_Pos = 0x0
	// Bit mask of SET field.
	SCT0_OUT_SET_SET_Msk = 0xffff
	// Position of RESERVED field.
	SCT0_OUT_SET_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	SCT0_OUT_SET_RESERVED_Msk = 0xffff0000

	// OUT0_CLR: SCT output 0 clear register
	// Position of CLR field.
	SCT0_OUT_CLR_CLR_Pos = 0x0
	// Bit mask of CLR field.
	SCT0_OUT_CLR_CLR_Msk = 0xffff
	// Position of RESERVED field.
	SCT0_OUT_CLR_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	SCT0_OUT_CLR_RESERVED_Msk = 0xffff0000
)

// Bitfields for SCT2: Small State Configurable Timers 2/3 (SCT2/3)
const (
	// CONFIG: SCT configuration register
	// Position of UNIFY field.
	SCT2_CONFIG_UNIFY_Pos = 0x0
	// Bit mask of UNIFY field.
	SCT2_CONFIG_UNIFY_Msk = 0x1
	// Bit UNIFY.
	SCT2_CONFIG_UNIFY = 0x1
	// Position of CLKMODE field.
	SCT2_CONFIG_CLKMODE_Pos = 0x1
	// Bit mask of CLKMODE field.
	SCT2_CONFIG_CLKMODE_Msk = 0x6
	// The bus clock clocks the SCT and prescalers.
	SCT2_CONFIG_CLKMODE_THE_BUS_CLOCK_CLOCKS = 0x0
	// The SCT clock is the bus clock, but the prescalers are enabled to count only when sampling of the input selected by the CKSEL field finds the selected edge. The minimum pulse width on the clock input is 1 bus clock period. This mode is the high-performance sampled-clock mode.
	SCT2_CONFIG_CLKMODE_THE_SCT_CLOCK_IS_THE = 0x1
	// The input selected by CKSEL clocks the SCT and prescalers. The input is synchronized to the bus clock and possibly inverted. The minimum pulse width on the clock input is 1 bus clock period. This mode is the low-power sampled-clock mode.
	SCT2_CONFIG_CLKMODE_THE_INPUT_SELECTED_B = 0x2
	// Position of CKSEL field.
	SCT2_CONFIG_CKSEL_Pos = 0x3
	// Bit mask of CKSEL field.
	SCT2_CONFIG_CKSEL_Msk = 0x78
	// Position of NORELAOD_L field.
	SCT2_CONFIG_NORELAOD_L_Pos = 0x7
	// Bit mask of NORELAOD_L field.
	SCT2_CONFIG_NORELAOD_L_Msk = 0x80
	// Bit NORELAOD_L.
	SCT2_CONFIG_NORELAOD_L = 0x80
	// Position of NORELOAD_H field.
	SCT2_CONFIG_NORELOAD_H_Pos = 0x8
	// Bit mask of NORELOAD_H field.
	SCT2_CONFIG_NORELOAD_H_Msk = 0x100
	// Bit NORELOAD_H.
	SCT2_CONFIG_NORELOAD_H = 0x100
	// Position of INSYNC field.
	SCT2_CONFIG_INSYNC_Pos = 0x9
	// Bit mask of INSYNC field.
	SCT2_CONFIG_INSYNC_Msk = 0x1fe00
	// Position of AUTOLIMIT_L field.
	SCT2_CONFIG_AUTOLIMIT_L_Pos = 0x11
	// Bit mask of AUTOLIMIT_L field.
	SCT2_CONFIG_AUTOLIMIT_L_Msk = 0x20000
	// Bit AUTOLIMIT_L.
	SCT2_CONFIG_AUTOLIMIT_L = 0x20000
	// Position of AUTOLIMIT_H field.
	SCT2_CONFIG_AUTOLIMIT_H_Pos = 0x12
	// Bit mask of AUTOLIMIT_H field.
	SCT2_CONFIG_AUTOLIMIT_H_Msk = 0x40000
	// Bit AUTOLIMIT_H.
	SCT2_CONFIG_AUTOLIMIT_H = 0x40000
	// Position of RESERVED field.
	SCT2_CONFIG_RESERVED_Pos = 0x13
	// Bit mask of RESERVED field.
	SCT2_CONFIG_RESERVED_Msk = 0xfff80000

	// CTRL: SCT control register
	// Position of DOWN_L field.
	SCT2_CTRL_DOWN_L_Pos = 0x0
	// Bit mask of DOWN_L field.
	SCT2_CTRL_DOWN_L_Msk = 0x1
	// Bit DOWN_L.
	SCT2_CTRL_DOWN_L = 0x1
	// Position of STOP_L field.
	SCT2_CTRL_STOP_L_Pos = 0x1
	// Bit mask of STOP_L field.
	SCT2_CTRL_STOP_L_Msk = 0x2
	// Bit STOP_L.
	SCT2_CTRL_STOP_L = 0x2
	// Position of HALT_L field.
	SCT2_CTRL_HALT_L_Pos = 0x2
	// Bit mask of HALT_L field.
	SCT2_CTRL_HALT_L_Msk = 0x4
	// Bit HALT_L.
	SCT2_CTRL_HALT_L = 0x4
	// Position of CLRCTR_L field.
	SCT2_CTRL_CLRCTR_L_Pos = 0x3
	// Bit mask of CLRCTR_L field.
	SCT2_CTRL_CLRCTR_L_Msk = 0x8
	// Bit CLRCTR_L.
	SCT2_CTRL_CLRCTR_L = 0x8
	// Position of BIDIR_L field.
	SCT2_CTRL_BIDIR_L_Pos = 0x4
	// Bit mask of BIDIR_L field.
	SCT2_CTRL_BIDIR_L_Msk = 0x10
	// Bit BIDIR_L.
	SCT2_CTRL_BIDIR_L = 0x10
	// Position of PRE_L field.
	SCT2_CTRL_PRE_L_Pos = 0x5
	// Bit mask of PRE_L field.
	SCT2_CTRL_PRE_L_Msk = 0x1fe0
	// Position of RESERVED field.
	SCT2_CTRL_RESERVED_Pos = 0xd
	// Bit mask of RESERVED field.
	SCT2_CTRL_RESERVED_Msk = 0xe000
	// Position of DOWN_H field.
	SCT2_CTRL_DOWN_H_Pos = 0x10
	// Bit mask of DOWN_H field.
	SCT2_CTRL_DOWN_H_Msk = 0x10000
	// Bit DOWN_H.
	SCT2_CTRL_DOWN_H = 0x10000
	// Position of STOP_H field.
	SCT2_CTRL_STOP_H_Pos = 0x11
	// Bit mask of STOP_H field.
	SCT2_CTRL_STOP_H_Msk = 0x20000
	// Bit STOP_H.
	SCT2_CTRL_STOP_H = 0x20000
	// Position of HALT_H field.
	SCT2_CTRL_HALT_H_Pos = 0x12
	// Bit mask of HALT_H field.
	SCT2_CTRL_HALT_H_Msk = 0x40000
	// Bit HALT_H.
	SCT2_CTRL_HALT_H = 0x40000
	// Position of CLRCTR_H field.
	SCT2_CTRL_CLRCTR_H_Pos = 0x13
	// Bit mask of CLRCTR_H field.
	SCT2_CTRL_CLRCTR_H_Msk = 0x80000
	// Bit CLRCTR_H.
	SCT2_CTRL_CLRCTR_H = 0x80000
	// Position of BIDIR_H field.
	SCT2_CTRL_BIDIR_H_Pos = 0x14
	// Bit mask of BIDIR_H field.
	SCT2_CTRL_BIDIR_H_Msk = 0x100000
	// Bit BIDIR_H.
	SCT2_CTRL_BIDIR_H = 0x100000
	// Position of PRE_H field.
	SCT2_CTRL_PRE_H_Pos = 0x15
	// Bit mask of PRE_H field.
	SCT2_CTRL_PRE_H_Msk = 0x1fe00000
	// Position of RESERVED field.
	SCT2_CTRL_RESERVED_Pos = 0x1d
	// Bit mask of RESERVED field.
	SCT2_CTRL_RESERVED_Msk = 0xe0000000

	// LIMIT: SCT limit register
	// Position of LIMMSK_L field.
	SCT2_LIMIT_LIMMSK_L_Pos = 0x0
	// Bit mask of LIMMSK_L field.
	SCT2_LIMIT_LIMMSK_L_Msk = 0xffff
	// Position of LIMMSK_H field.
	SCT2_LIMIT_LIMMSK_H_Pos = 0x10
	// Bit mask of LIMMSK_H field.
	SCT2_LIMIT_LIMMSK_H_Msk = 0xffff0000

	// HALT: SCT halt condition register
	// Position of HALTMSK_L field.
	SCT2_HALT_HALTMSK_L_Pos = 0x0
	// Bit mask of HALTMSK_L field.
	SCT2_HALT_HALTMSK_L_Msk = 0xffff
	// Position of HALTMSK_H field.
	SCT2_HALT_HALTMSK_H_Pos = 0x10
	// Bit mask of HALTMSK_H field.
	SCT2_HALT_HALTMSK_H_Msk = 0xffff0000

	// STOP: SCT stop condition register
	// Position of STOPMSK_L field.
	SCT2_STOP_STOPMSK_L_Pos = 0x0
	// Bit mask of STOPMSK_L field.
	SCT2_STOP_STOPMSK_L_Msk = 0xffff
	// Position of STOPMSK_H field.
	SCT2_STOP_STOPMSK_H_Pos = 0x10
	// Bit mask of STOPMSK_H field.
	SCT2_STOP_STOPMSK_H_Msk = 0xffff0000

	// START: SCT start condition register
	// Position of STARTMSK_L field.
	SCT2_START_STARTMSK_L_Pos = 0x0
	// Bit mask of STARTMSK_L field.
	SCT2_START_STARTMSK_L_Msk = 0xffff
	// Position of STARTMSK_H field.
	SCT2_START_STARTMSK_H_Pos = 0x10
	// Bit mask of STARTMSK_H field.
	SCT2_START_STARTMSK_H_Msk = 0xffff0000

	// COUNT: SCT counter register
	// Position of CTR_L field.
	SCT2_COUNT_CTR_L_Pos = 0x0
	// Bit mask of CTR_L field.
	SCT2_COUNT_CTR_L_Msk = 0xffff
	// Position of CTR_H field.
	SCT2_COUNT_CTR_H_Pos = 0x10
	// Bit mask of CTR_H field.
	SCT2_COUNT_CTR_H_Msk = 0xffff0000

	// STATE: SCT state register
	// Position of STATE_L field.
	SCT2_STATE_STATE_L_Pos = 0x0
	// Bit mask of STATE_L field.
	SCT2_STATE_STATE_L_Msk = 0x1f
	// Position of RESERVED field.
	SCT2_STATE_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	SCT2_STATE_RESERVED_Msk = 0xffe0
	// Position of STATE_H field.
	SCT2_STATE_STATE_H_Pos = 0x10
	// Bit mask of STATE_H field.
	SCT2_STATE_STATE_H_Msk = 0x1f0000
	// Position of RESERVED field.
	SCT2_STATE_RESERVED_Pos = 0x15
	// Bit mask of RESERVED field.
	SCT2_STATE_RESERVED_Msk = 0xffe00000

	// INPUT: SCT input register
	// Position of AIN0 field.
	SCT2_INPUT_AIN0_Pos = 0x0
	// Bit mask of AIN0 field.
	SCT2_INPUT_AIN0_Msk = 0x1
	// Bit AIN0.
	SCT2_INPUT_AIN0 = 0x1
	// Position of AIN1 field.
	SCT2_INPUT_AIN1_Pos = 0x1
	// Bit mask of AIN1 field.
	SCT2_INPUT_AIN1_Msk = 0x2
	// Bit AIN1.
	SCT2_INPUT_AIN1 = 0x2
	// Position of AIN2 field.
	SCT2_INPUT_AIN2_Pos = 0x2
	// Bit mask of AIN2 field.
	SCT2_INPUT_AIN2_Msk = 0x4
	// Bit AIN2.
	SCT2_INPUT_AIN2 = 0x4
	// Position of AIN3 field.
	SCT2_INPUT_AIN3_Pos = 0x3
	// Bit mask of AIN3 field.
	SCT2_INPUT_AIN3_Msk = 0x8
	// Bit AIN3.
	SCT2_INPUT_AIN3 = 0x8
	// Position of RESERVED field.
	SCT2_INPUT_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	SCT2_INPUT_RESERVED_Msk = 0xfff0
	// Position of SIN0 field.
	SCT2_INPUT_SIN0_Pos = 0x10
	// Bit mask of SIN0 field.
	SCT2_INPUT_SIN0_Msk = 0x10000
	// Bit SIN0.
	SCT2_INPUT_SIN0 = 0x10000
	// Position of SIN1 field.
	SCT2_INPUT_SIN1_Pos = 0x11
	// Bit mask of SIN1 field.
	SCT2_INPUT_SIN1_Msk = 0x20000
	// Bit SIN1.
	SCT2_INPUT_SIN1 = 0x20000
	// Position of SIN2 field.
	SCT2_INPUT_SIN2_Pos = 0x12
	// Bit mask of SIN2 field.
	SCT2_INPUT_SIN2_Msk = 0x40000
	// Bit SIN2.
	SCT2_INPUT_SIN2 = 0x40000
	// Position of SIN3 field.
	SCT2_INPUT_SIN3_Pos = 0x13
	// Bit mask of SIN3 field.
	SCT2_INPUT_SIN3_Msk = 0x80000
	// Bit SIN3.
	SCT2_INPUT_SIN3 = 0x80000
	// Position of RESERVED field.
	SCT2_INPUT_RESERVED_Pos = 0x14
	// Bit mask of RESERVED field.
	SCT2_INPUT_RESERVED_Msk = 0xfff00000

	// REGMODE: SCT match/capture registers mode register
	// Position of REGMOD_L field.
	SCT2_REGMODE_REGMOD_L_Pos = 0x0
	// Bit mask of REGMOD_L field.
	SCT2_REGMODE_REGMOD_L_Msk = 0xffff
	// Position of REGMOD_H field.
	SCT2_REGMODE_REGMOD_H_Pos = 0x10
	// Bit mask of REGMOD_H field.
	SCT2_REGMODE_REGMOD_H_Msk = 0xffff0000

	// OUTPUT: SCT output register
	// Position of OUT field.
	SCT2_OUTPUT_OUT_Pos = 0x0
	// Bit mask of OUT field.
	SCT2_OUTPUT_OUT_Msk = 0x3f
	// Position of RESERVED field.
	SCT2_OUTPUT_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	SCT2_OUTPUT_RESERVED_Msk = 0xffffffc0

	// OUTPUTDIRCTRL: SCT output counter direction control register
	// Position of SETCLR0 field.
	SCT2_OUTPUTDIRCTRL_SETCLR0_Pos = 0x0
	// Bit mask of SETCLR0 field.
	SCT2_OUTPUTDIRCTRL_SETCLR0_Msk = 0x3
	// Set and clear do not depend on any counter.
	SCT2_OUTPUTDIRCTRL_SETCLR0_SET_AND_CLEAR_DO_NOT = 0x0
	// Position of SETCLR1 field.
	SCT2_OUTPUTDIRCTRL_SETCLR1_Pos = 0x2
	// Bit mask of SETCLR1 field.
	SCT2_OUTPUTDIRCTRL_SETCLR1_Msk = 0xc
	// Set and clear do not depend on any counter.
	SCT2_OUTPUTDIRCTRL_SETCLR1_SET_AND_CLEAR_DO_NOT = 0x0
	// Position of SETCLR2 field.
	SCT2_OUTPUTDIRCTRL_SETCLR2_Pos = 0x4
	// Bit mask of SETCLR2 field.
	SCT2_OUTPUTDIRCTRL_SETCLR2_Msk = 0x30
	// Set and clear do not depend on any counter.
	SCT2_OUTPUTDIRCTRL_SETCLR2_SET_AND_CLEAR_DO_NOT = 0x0
	// Position of SETCLR3 field.
	SCT2_OUTPUTDIRCTRL_SETCLR3_Pos = 0x6
	// Bit mask of SETCLR3 field.
	SCT2_OUTPUTDIRCTRL_SETCLR3_Msk = 0xc0
	// Set and clear do not depend on any counter.
	SCT2_OUTPUTDIRCTRL_SETCLR3_SET_AND_CLEAR_DO_NOT = 0x0
	// Position of SETCLR4 field.
	SCT2_OUTPUTDIRCTRL_SETCLR4_Pos = 0x8
	// Bit mask of SETCLR4 field.
	SCT2_OUTPUTDIRCTRL_SETCLR4_Msk = 0x300
	// Set and clear do not depend on any counter.
	SCT2_OUTPUTDIRCTRL_SETCLR4_SET_AND_CLEAR_DO_NOT = 0x0
	// Position of SETCLR5 field.
	SCT2_OUTPUTDIRCTRL_SETCLR5_Pos = 0xa
	// Bit mask of SETCLR5 field.
	SCT2_OUTPUTDIRCTRL_SETCLR5_Msk = 0xc00
	// Set and clear do not depend on any counter.
	SCT2_OUTPUTDIRCTRL_SETCLR5_SET_AND_CLEAR_DO_NOT = 0x0
	// Position of RESERVED field.
	SCT2_OUTPUTDIRCTRL_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	SCT2_OUTPUTDIRCTRL_RESERVED_Msk = 0xfffff000

	// RES: SCT conflict resolution register
	// Position of O0RES field.
	SCT2_RES_O0RES_Pos = 0x0
	// Bit mask of O0RES field.
	SCT2_RES_O0RES_Msk = 0x3
	// No change.
	SCT2_RES_O0RES_NO_CHANGE = 0x0
	// Set output (or clear based on the SETCLR0 field).
	SCT2_RES_O0RES_SET_OUTPUT_OR_CLEAR = 0x1
	// Clear output (or set based on the SETCLR0 field).
	SCT2_RES_O0RES_CLEAR_OUTPUT_OR_SET = 0x2
	// Toggle output.
	SCT2_RES_O0RES_TOGGLE_OUTPUT = 0x3
	// Position of O1RES field.
	SCT2_RES_O1RES_Pos = 0x2
	// Bit mask of O1RES field.
	SCT2_RES_O1RES_Msk = 0xc
	// No change.
	SCT2_RES_O1RES_NO_CHANGE = 0x0
	// Set output (or clear based on the SETCLR1 field).
	SCT2_RES_O1RES_SET_OUTPUT_OR_CLEAR = 0x1
	// Clear output (or set based on the SETCLR1 field).
	SCT2_RES_O1RES_CLEAR_OUTPUT_OR_SET = 0x2
	// Toggle output.
	SCT2_RES_O1RES_TOGGLE_OUTPUT = 0x3
	// Position of O2RES field.
	SCT2_RES_O2RES_Pos = 0x4
	// Bit mask of O2RES field.
	SCT2_RES_O2RES_Msk = 0x30
	// No change.
	SCT2_RES_O2RES_NO_CHANGE = 0x0
	// Set output (or clear based on the SETCLR2 field).
	SCT2_RES_O2RES_SET_OUTPUT_OR_CLEAR = 0x1
	// Clear output n (or set based on the SETCLR2 field).
	SCT2_RES_O2RES_CLEAR_OUTPUT_N_OR_S = 0x2
	// Toggle output.
	SCT2_RES_O2RES_TOGGLE_OUTPUT = 0x3
	// Position of O3RES field.
	SCT2_RES_O3RES_Pos = 0x6
	// Bit mask of O3RES field.
	SCT2_RES_O3RES_Msk = 0xc0
	// No change.
	SCT2_RES_O3RES_NO_CHANGE = 0x0
	// Set output (or clear based on the SETCLR3 field).
	SCT2_RES_O3RES_SET_OUTPUT_OR_CLEAR = 0x1
	// Clear output (or set based on the SETCLR3 field).
	SCT2_RES_O3RES_CLEAR_OUTPUT_OR_SET = 0x2
	// Toggle output.
	SCT2_RES_O3RES_TOGGLE_OUTPUT = 0x3
	// Position of O4RES field.
	SCT2_RES_O4RES_Pos = 0x8
	// Bit mask of O4RES field.
	SCT2_RES_O4RES_Msk = 0x300
	// No change.
	SCT2_RES_O4RES_NO_CHANGE = 0x0
	// Set output (or clear based on the SETCLR4 field).
	SCT2_RES_O4RES_SET_OUTPUT_OR_CLEAR = 0x1
	// Clear output (or set based on the SETCLR4 field).
	SCT2_RES_O4RES_CLEAR_OUTPUT_OR_SET = 0x2
	// Toggle output.
	SCT2_RES_O4RES_TOGGLE_OUTPUT = 0x3
	// Position of O5RES field.
	SCT2_RES_O5RES_Pos = 0xa
	// Bit mask of O5RES field.
	SCT2_RES_O5RES_Msk = 0xc00
	// No change.
	SCT2_RES_O5RES_NO_CHANGE = 0x0
	// Set output (or clear based on the SETCLR5 field).
	SCT2_RES_O5RES_SET_OUTPUT_OR_CLEAR = 0x1
	// Clear output (or set based on the SETCLR5 field).
	SCT2_RES_O5RES_CLEAR_OUTPUT_OR_SET = 0x2
	// Toggle output.
	SCT2_RES_O5RES_TOGGLE_OUTPUT = 0x3
	// Position of RESERVED field.
	SCT2_RES_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	SCT2_RES_RESERVED_Msk = 0xfffff000

	// DMAREQ0: SCT DMA request 0 register
	// Position of DEV_0 field.
	SCT2_DMAREQ0_DEV_0_Pos = 0x0
	// Bit mask of DEV_0 field.
	SCT2_DMAREQ0_DEV_0_Msk = 0xffff
	// Position of RESERVED field.
	SCT2_DMAREQ0_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	SCT2_DMAREQ0_RESERVED_Msk = 0x3fff0000
	// Position of DRL0 field.
	SCT2_DMAREQ0_DRL0_Pos = 0x1e
	// Bit mask of DRL0 field.
	SCT2_DMAREQ0_DRL0_Msk = 0x40000000
	// Bit DRL0.
	SCT2_DMAREQ0_DRL0 = 0x40000000
	// Position of DRQ0 field.
	SCT2_DMAREQ0_DRQ0_Pos = 0x1f
	// Bit mask of DRQ0 field.
	SCT2_DMAREQ0_DRQ0_Msk = 0x80000000
	// Bit DRQ0.
	SCT2_DMAREQ0_DRQ0 = 0x80000000

	// DMAREQ1: SCT DMA request 1 register
	// Position of DEV_1 field.
	SCT2_DMAREQ1_DEV_1_Pos = 0x0
	// Bit mask of DEV_1 field.
	SCT2_DMAREQ1_DEV_1_Msk = 0xffff
	// Position of RESERVED field.
	SCT2_DMAREQ1_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	SCT2_DMAREQ1_RESERVED_Msk = 0x3fff0000
	// Position of DRL1 field.
	SCT2_DMAREQ1_DRL1_Pos = 0x1e
	// Bit mask of DRL1 field.
	SCT2_DMAREQ1_DRL1_Msk = 0x40000000
	// Bit DRL1.
	SCT2_DMAREQ1_DRL1 = 0x40000000
	// Position of DRQ1 field.
	SCT2_DMAREQ1_DRQ1_Pos = 0x1f
	// Bit mask of DRQ1 field.
	SCT2_DMAREQ1_DRQ1_Msk = 0x80000000
	// Bit DRQ1.
	SCT2_DMAREQ1_DRQ1 = 0x80000000

	// EVEN: SCT event enable register
	// Position of IEN field.
	SCT2_EVEN_IEN_Pos = 0x0
	// Bit mask of IEN field.
	SCT2_EVEN_IEN_Msk = 0xffff
	// Position of RESERVED field.
	SCT2_EVEN_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	SCT2_EVEN_RESERVED_Msk = 0xffff0000

	// EVFLAG: SCT event flag register
	// Position of FLAG field.
	SCT2_EVFLAG_FLAG_Pos = 0x0
	// Bit mask of FLAG field.
	SCT2_EVFLAG_FLAG_Msk = 0xffff
	// Position of RESERVED field.
	SCT2_EVFLAG_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	SCT2_EVFLAG_RESERVED_Msk = 0xffff0000

	// CONEN: SCT conflict enable register
	// Position of NCEN field.
	SCT2_CONEN_NCEN_Pos = 0x0
	// Bit mask of NCEN field.
	SCT2_CONEN_NCEN_Msk = 0xffff
	// Position of RESERVED field.
	SCT2_CONEN_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	SCT2_CONEN_RESERVED_Msk = 0xffff0000

	// CONFLAG: SCT conflict flag register
	// Position of NCFLAG field.
	SCT2_CONFLAG_NCFLAG_Pos = 0x0
	// Bit mask of NCFLAG field.
	SCT2_CONFLAG_NCFLAG_Msk = 0x3f
	// Position of RESERVED field.
	SCT2_CONFLAG_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	SCT2_CONFLAG_RESERVED_Msk = 0x3fffffc0
	// Position of BUSERRL field.
	SCT2_CONFLAG_BUSERRL_Pos = 0x1e
	// Bit mask of BUSERRL field.
	SCT2_CONFLAG_BUSERRL_Msk = 0x40000000
	// Bit BUSERRL.
	SCT2_CONFLAG_BUSERRL = 0x40000000
	// Position of BUSERRH field.
	SCT2_CONFLAG_BUSERRH_Pos = 0x1f
	// Bit mask of BUSERRH field.
	SCT2_CONFLAG_BUSERRH_Msk = 0x80000000
	// Bit BUSERRH.
	SCT2_CONFLAG_BUSERRH = 0x80000000

	// MATCH0: SCT match value register of match channels 0 to 7; REGMOD0 to REGMODE7 = 0
	// Position of MATCHn_L field.
	SCT2_MATCH_MATCHn_L_Pos = 0x0
	// Bit mask of MATCHn_L field.
	SCT2_MATCH_MATCHn_L_Msk = 0xffff
	// Position of MATCHn_H field.
	SCT2_MATCH_MATCHn_H_Pos = 0x10
	// Bit mask of MATCHn_H field.
	SCT2_MATCH_MATCHn_H_Msk = 0xffff0000

	// CAP0: SCT capture register of capture channel 0 to 7; REGMOD0 to REGMODE7 = 1
	// Position of CAPn_L field.
	SCT2_CAP_CAPn_L_Pos = 0x0
	// Bit mask of CAPn_L field.
	SCT2_CAP_CAPn_L_Msk = 0xffff
	// Position of CAPn_H field.
	SCT2_CAP_CAPn_H_Pos = 0x10
	// Bit mask of CAPn_H field.
	SCT2_CAP_CAPn_H_Msk = 0xffff0000

	// MATCHREL0: SCT match reload value register 0 to 7; REGMOD0 = 0 to REGMODE7 = 0
	// Position of RELOADn_L field.
	SCT2_MATCHREL_RELOADn_L_Pos = 0x0
	// Bit mask of RELOADn_L field.
	SCT2_MATCHREL_RELOADn_L_Msk = 0xffff
	// Position of RELOADn_H field.
	SCT2_MATCHREL_RELOADn_H_Pos = 0x10
	// Bit mask of RELOADn_H field.
	SCT2_MATCHREL_RELOADn_H_Msk = 0xffff0000

	// CAPCTRL0: SCT capture control register 0 to 7; REGMOD0 = 1 to REGMODE7 = 1
	// Position of CAPCONn_L field.
	SCT2_CAPCTRL_CAPCONn_L_Pos = 0x0
	// Bit mask of CAPCONn_L field.
	SCT2_CAPCTRL_CAPCONn_L_Msk = 0x3ff
	// Position of RESERVED field.
	SCT2_CAPCTRL_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	SCT2_CAPCTRL_RESERVED_Msk = 0xfc00
	// Position of CAPCONn_H field.
	SCT2_CAPCTRL_CAPCONn_H_Pos = 0x10
	// Bit mask of CAPCONn_H field.
	SCT2_CAPCTRL_CAPCONn_H_Msk = 0x1ff0000
	// Position of RESERVED field.
	SCT2_CAPCTRL_RESERVED_Pos = 0x19
	// Bit mask of RESERVED field.
	SCT2_CAPCTRL_RESERVED_Msk = 0xfe000000

	// EV0_STATE: SCT event state register 0
	// Position of STATEMSKn field.
	SCT2_EV_STATE_STATEMSKn_Pos = 0x0
	// Bit mask of STATEMSKn field.
	SCT2_EV_STATE_STATEMSKn_Msk = 0x3ff
	// Position of RESERVED field.
	SCT2_EV_STATE_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	SCT2_EV_STATE_RESERVED_Msk = 0xfffffc00

	// EV0_CTRL: SCT event control register 0
	// Position of MATCHSEL field.
	SCT2_EV_CTRL_MATCHSEL_Pos = 0x0
	// Bit mask of MATCHSEL field.
	SCT2_EV_CTRL_MATCHSEL_Msk = 0xf
	// Position of HEVENT field.
	SCT2_EV_CTRL_HEVENT_Pos = 0x4
	// Bit mask of HEVENT field.
	SCT2_EV_CTRL_HEVENT_Msk = 0x10
	// Bit HEVENT.
	SCT2_EV_CTRL_HEVENT = 0x10
	// Selects the L state and the L match register selected by MATCHSEL.
	SCT2_EV_CTRL_HEVENT_SELECTS_THE_L_STATE = 0x0
	// Selects the H state and the H match register selected by MATCHSEL.
	SCT2_EV_CTRL_HEVENT_SELECTS_THE_H_STATE = 0x1
	// Position of OUTSEL field.
	SCT2_EV_CTRL_OUTSEL_Pos = 0x5
	// Bit mask of OUTSEL field.
	SCT2_EV_CTRL_OUTSEL_Msk = 0x20
	// Bit OUTSEL.
	SCT2_EV_CTRL_OUTSEL = 0x20
	// Selects the inputs elected by IOSEL.
	SCT2_EV_CTRL_OUTSEL_SELECTS_THE_INPUTS_E = 0x0
	// Selects the outputs selected by IOSEL.
	SCT2_EV_CTRL_OUTSEL_SELECTS_THE_OUTPUTS = 0x1
	// Position of IOSEL field.
	SCT2_EV_CTRL_IOSEL_Pos = 0x6
	// Bit mask of IOSEL field.
	SCT2_EV_CTRL_IOSEL_Msk = 0x3c0
	// Position of IOCOND field.
	SCT2_EV_CTRL_IOCOND_Pos = 0xa
	// Bit mask of IOCOND field.
	SCT2_EV_CTRL_IOCOND_Msk = 0xc00
	// LOW
	SCT2_EV_CTRL_IOCOND_LOW = 0x0
	// Rise
	SCT2_EV_CTRL_IOCOND_RISE = 0x1
	// Fall
	SCT2_EV_CTRL_IOCOND_FALL = 0x2
	// HIGH
	SCT2_EV_CTRL_IOCOND_HIGH = 0x3
	// Position of COMBMODE field.
	SCT2_EV_CTRL_COMBMODE_Pos = 0xc
	// Bit mask of COMBMODE field.
	SCT2_EV_CTRL_COMBMODE_Msk = 0x3000
	// OR. The event occurs when either the specified match or I/O condition occurs.
	SCT2_EV_CTRL_COMBMODE_OR = 0x0
	// MATCH. Uses the specified match only.
	SCT2_EV_CTRL_COMBMODE_MATCH = 0x1
	// IO. Uses the specified I/O condition only.
	SCT2_EV_CTRL_COMBMODE_IO = 0x2
	// AND. The event occurs when the specified match and I/O condition occur simultaneously.
	SCT2_EV_CTRL_COMBMODE_AND = 0x3
	// Position of STATELD field.
	SCT2_EV_CTRL_STATELD_Pos = 0xe
	// Bit mask of STATELD field.
	SCT2_EV_CTRL_STATELD_Msk = 0x4000
	// Bit STATELD.
	SCT2_EV_CTRL_STATELD = 0x4000
	// STATEV value is added into STATE (the carry-out is ignored).
	SCT2_EV_CTRL_STATELD_STATEV_VALUE_IS_ADDE = 0x0
	// STATEV value is loaded into STATE.
	SCT2_EV_CTRL_STATELD_STATEV_VALUE_IS_LOAD = 0x1
	// Position of STATEV field.
	SCT2_EV_CTRL_STATEV_Pos = 0xf
	// Bit mask of STATEV field.
	SCT2_EV_CTRL_STATEV_Msk = 0xf8000
	// Position of MATCHMEM field.
	SCT2_EV_CTRL_MATCHMEM_Pos = 0x14
	// Bit mask of MATCHMEM field.
	SCT2_EV_CTRL_MATCHMEM_Msk = 0x100000
	// Bit MATCHMEM.
	SCT2_EV_CTRL_MATCHMEM = 0x100000
	// Position of DIRECTION field.
	SCT2_EV_CTRL_DIRECTION_Pos = 0x15
	// Bit mask of DIRECTION field.
	SCT2_EV_CTRL_DIRECTION_Msk = 0x600000
	// Direction independent. This event is triggered regardless of the count direction.
	SCT2_EV_CTRL_DIRECTION_DIRECTION_INDEPENDEN = 0x0
	// Counting up. This event is triggered only during up-counting when BIDIR = 1.
	SCT2_EV_CTRL_DIRECTION_COUNTING_UP = 0x1
	// Counting down. This event is triggered only during down-counting when BIDIR = 1.
	SCT2_EV_CTRL_DIRECTION_COUNTING_DOWN = 0x2
	// Position of RESERVED field.
	SCT2_EV_CTRL_RESERVED_Pos = 0x17
	// Bit mask of RESERVED field.
	SCT2_EV_CTRL_RESERVED_Msk = 0xff800000

	// OUT0_SET: SCT output 0 set register
	// Position of SET field.
	SCT2_OUT_SET_SET_Pos = 0x0
	// Bit mask of SET field.
	SCT2_OUT_SET_SET_Msk = 0x3ff
	// Position of RESERVED field.
	SCT2_OUT_SET_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	SCT2_OUT_SET_RESERVED_Msk = 0xfffffc00

	// OUT0_CLR: SCT output 0 clear register
	// Position of CLR field.
	SCT2_OUT_CLR_CLR_Pos = 0x0
	// Bit mask of CLR field.
	SCT2_OUT_CLR_CLR_Msk = 0x3ff
	// Position of RESERVED field.
	SCT2_OUT_CLR_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	SCT2_OUT_CLR_RESERVED_Msk = 0xfffffc00
)

// Bitfields for ADC0: 12-bit ADC controller ADC0/1
const (
	// CTRL: A/D Control Register. Contains the clock divide value, enable bits for each sequence and the A/D power-down bit.
	// Position of CLKDIV field.
	ADC_CTRL_CLKDIV_Pos = 0x0
	// Bit mask of CLKDIV field.
	ADC_CTRL_CLKDIV_Msk = 0xff
	// Position of ASYNMODE field.
	ADC_CTRL_ASYNMODE_Pos = 0x8
	// Bit mask of ASYNMODE field.
	ADC_CTRL_ASYNMODE_Msk = 0x100
	// Bit ASYNMODE.
	ADC_CTRL_ASYNMODE = 0x100
	// Synchronous mode. The ADC clock is derived from the system clock based on the divide value selected in the CLKDIV field. The ADC clock will be started in a controlled fashion in response to a trigger to eliminate any uncertainty in the launching of an ADC conversion in response to any synchronous (on-chip) trigger. In Synchronous mode with the SYNCBYPASS bit set, sampling of the A/D input and start of conversion will initiate exactly 2 system clocks after the leading edge of a (synchronous) trigger pulse.
	ADC_CTRL_ASYNMODE_SYNCHRONOUS_MODE = 0x0
	// Asynchronous mode. The ADC clock is based on the output of the asynchronous ADC clock divider ADCASYNCCLKSEL in the SYSCON block. The frequency of this clock is limited to 50 MHz max (100 MHz in 10-bit mode). In addition, the ADC clock must never be faster than 10x the system clock.
	ADC_CTRL_ASYNMODE_ASYNCHRONOUS_MODE = 0x1
	// Position of MODE10BIT field.
	ADC_CTRL_MODE10BIT_Pos = 0x9
	// Bit mask of MODE10BIT field.
	ADC_CTRL_MODE10BIT_Msk = 0x200
	// Bit MODE10BIT.
	ADC_CTRL_MODE10BIT = 0x200
	// Disabled. The 10-bit/high-conversion rate mode is disabled.
	ADC_CTRL_MODE10BIT_DISABLED = 0x0
	// Enabled. The 10-bit/high-conversion rate is enabled.
	ADC_CTRL_MODE10BIT_ENABLED = 0x1
	// Position of LPWRMODE field.
	ADC_CTRL_LPWRMODE_Pos = 0xa
	// Bit mask of LPWRMODE field.
	ADC_CTRL_LPWRMODE_Msk = 0x400
	// Bit LPWRMODE.
	ADC_CTRL_LPWRMODE = 0x400
	// Disabled. The low-power ADC mode is disabled. The analog circuitry remains activated even when no conversions are requested.
	ADC_CTRL_LPWRMODE_DISABLED = 0x0
	// Enabled. The low-power ADC mode is enabled.
	ADC_CTRL_LPWRMODE_ENABLED = 0x1
	// Position of RESERVED field.
	ADC_CTRL_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	ADC_CTRL_RESERVED_Msk = 0x3ffff800
	// Position of CALMODE field.
	ADC_CTRL_CALMODE_Pos = 0x1e
	// Bit mask of CALMODE field.
	ADC_CTRL_CALMODE_Msk = 0x40000000
	// Bit CALMODE.
	ADC_CTRL_CALMODE = 0x40000000
	// Position of RESERVED field.
	ADC_CTRL_RESERVED_Pos = 0x1f
	// Bit mask of RESERVED field.
	ADC_CTRL_RESERVED_Msk = 0x80000000
	// Bit RESERVED.
	ADC_CTRL_RESERVED = 0x80000000

	// INSEL: A/D Input Select Register: Selects between external pin and internal source for various channels
	// Position of AD0SEL field.
	ADC_INSEL_AD0SEL_Pos = 0x0
	// Bit mask of AD0SEL field.
	ADC_INSEL_AD0SEL_Msk = 0xf
	// ADCn_0 pin. Voltage on ADC channel 0 input.
	ADC_INSEL_AD0SEL_ADCN_0_PIN = 0x0
	// Core voltage regulator output (1.2V to 1.8V). If the WRAPEN field is 0x2, the core voltage regulator output is also is output on the ADC0/1_0 pin.
	ADC_INSEL_AD0SEL_CORE_VOLTAGE_REGULAT = 0x1
	// Internal voltage reference. If the WRAPEN field is 0x2, the internal voltage reference is also is output on the ADCn_0 pin.
	ADC_INSEL_AD0SEL_INTERNAL_VOLTAGE_REF = 0x2
	// Temperature Sensor. If the WRAPEN field is 0x2, the temperature sensor voltage is also is output on the ADCn_0 pin.
	ADC_INSEL_AD0SEL_TEMPERATURE_SENSOR = 0x3
	// VDDA/2.
	ADC_INSEL_AD0SEL_VDDADIV2 = 0x4
	// No connection or load
	ADC_INSEL_AD0SEL_NO_CONNECTION_OR_LOA = 0xf
	// Position of RESERVED field.
	ADC_INSEL_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	ADC_INSEL_RESERVED_Msk = 0x3ffffff0
	// Position of RESERVED field.
	ADC_INSEL_RESERVED_Pos = 0x1e
	// Bit mask of RESERVED field.
	ADC_INSEL_RESERVED_Msk = 0xc0000000

	// SEQA_CTRL: A/D Conversion Sequence-A control Register: Controls triggering and channel selection for conversion sequence-A. Also specifies interrupt mode for sequence-A.
	// Position of CHANNELS field.
	ADC_SEQA_CTRL_CHANNELS_Pos = 0x0
	// Bit mask of CHANNELS field.
	ADC_SEQA_CTRL_CHANNELS_Msk = 0xfff
	// Position of TRIGGER field.
	ADC_SEQA_CTRL_TRIGGER_Pos = 0xc
	// Bit mask of TRIGGER field.
	ADC_SEQA_CTRL_TRIGGER_Msk = 0xf000
	// Position of RESERVED field.
	ADC_SEQA_CTRL_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	ADC_SEQA_CTRL_RESERVED_Msk = 0x30000
	// Position of TRIGPOL field.
	ADC_SEQA_CTRL_TRIGPOL_Pos = 0x12
	// Bit mask of TRIGPOL field.
	ADC_SEQA_CTRL_TRIGPOL_Msk = 0x40000
	// Bit TRIGPOL.
	ADC_SEQA_CTRL_TRIGPOL = 0x40000
	// Negative edge. A negative edge launches the conversion sequence on the selected trigger input.
	ADC_SEQA_CTRL_TRIGPOL_NEGATIVE_EDGE = 0x0
	// Positive edge. A positive edge launches the conversion sequence on the selected trigger input.
	ADC_SEQA_CTRL_TRIGPOL_POSITIVE_EDGE = 0x1
	// Position of SYNCBYPASS field.
	ADC_SEQA_CTRL_SYNCBYPASS_Pos = 0x13
	// Bit mask of SYNCBYPASS field.
	ADC_SEQA_CTRL_SYNCBYPASS_Msk = 0x80000
	// Bit SYNCBYPASS.
	ADC_SEQA_CTRL_SYNCBYPASS = 0x80000
	// Enable synchronization. The hardware trigger bypass is not enabled.
	ADC_SEQA_CTRL_SYNCBYPASS_ENABLE_SYNCHRONIZATI = 0x0
	// Bypass synchronization. The hardware trigger bypass is enabled.
	ADC_SEQA_CTRL_SYNCBYPASS_BYPASS_SYNCHRONIZATI = 0x1
	// Position of RESERVED field.
	ADC_SEQA_CTRL_RESERVED_Pos = 0x14
	// Bit mask of RESERVED field.
	ADC_SEQA_CTRL_RESERVED_Msk = 0x3f00000
	// Position of START field.
	ADC_SEQA_CTRL_START_Pos = 0x1a
	// Bit mask of START field.
	ADC_SEQA_CTRL_START_Msk = 0x4000000
	// Bit START.
	ADC_SEQA_CTRL_START = 0x4000000
	// Position of BURST field.
	ADC_SEQA_CTRL_BURST_Pos = 0x1b
	// Bit mask of BURST field.
	ADC_SEQA_CTRL_BURST_Msk = 0x8000000
	// Bit BURST.
	ADC_SEQA_CTRL_BURST = 0x8000000
	// Position of SINGLESTEP field.
	ADC_SEQA_CTRL_SINGLESTEP_Pos = 0x1c
	// Bit mask of SINGLESTEP field.
	ADC_SEQA_CTRL_SINGLESTEP_Msk = 0x10000000
	// Bit SINGLESTEP.
	ADC_SEQA_CTRL_SINGLESTEP = 0x10000000
	// Position of LOWPRIO field.
	ADC_SEQA_CTRL_LOWPRIO_Pos = 0x1d
	// Bit mask of LOWPRIO field.
	ADC_SEQA_CTRL_LOWPRIO_Msk = 0x20000000
	// Bit LOWPRIO.
	ADC_SEQA_CTRL_LOWPRIO = 0x20000000
	// Low priority. Any B trigger which occurs while an A conversion sequence is active will be ignored and lost.
	ADC_SEQA_CTRL_LOWPRIO_LOW_PRIORITY = 0x0
	// High priority. Setting this bit to a 1 will permit any enabled B sequence trigger (including a B sequence software start) to immediately interrupt this sequence and launch a B sequence in it's place. The conversion currently in progress will be terminated. The A sequence that was interrupted will automatically resume after the B sequence completes. The channel whose conversion was terminated will be re-sampled and the conversion sequence will resume from that point.
	ADC_SEQA_CTRL_LOWPRIO_HIGH_PRIORITY = 0x1
	// Position of MODE field.
	ADC_SEQA_CTRL_MODE_Pos = 0x1e
	// Bit mask of MODE field.
	ADC_SEQA_CTRL_MODE_Msk = 0x40000000
	// Bit MODE.
	ADC_SEQA_CTRL_MODE = 0x40000000
	// End of conversion. The sequence A interrupt/DMA flag will be set at the end of each individual A/D conversion performed under sequence A. This flag will mirror the DATAVALID bit in the SEQA_GDAT register. The OVERRUN bit in the SEQA_GDAT register will contribute to generation of an overrun interrupt/DMA request if enabled.
	ADC_SEQA_CTRL_MODE_END_OF_CONVERSION = 0x0
	// End of sequence. The sequence A interrupt/DMA flag will be set when the entire set of sequence-A conversions completes. This flag will need to be explicitly cleared by software or by the DMA-clear signal in this mode. The OVERRUN bit in the SEQA_GDAT register will NOT contribute to generation of an overrun interrupt/DMA request since it is assumed this register may not be utilized in this mode.
	ADC_SEQA_CTRL_MODE_END_OF_SEQUENCE = 0x1
	// Position of SEQA_ENA field.
	ADC_SEQA_CTRL_SEQA_ENA_Pos = 0x1f
	// Bit mask of SEQA_ENA field.
	ADC_SEQA_CTRL_SEQA_ENA_Msk = 0x80000000
	// Bit SEQA_ENA.
	ADC_SEQA_CTRL_SEQA_ENA = 0x80000000
	// Disabled. Sequence A is disabled. Sequence A triggers are ignored. If this bit is cleared while sequence A is in progress, the sequence will be halted at the end of the current conversion. After the sequence is re-enabled, a new trigger will be required to restart the sequence beginning with the next enabled channel.
	ADC_SEQA_CTRL_SEQA_ENA_DISABLED = 0x0
	// Enabled. Sequence A is enabled.
	ADC_SEQA_CTRL_SEQA_ENA_ENABLED = 0x1

	// SEQB_CTRL: A/D Conversion Sequence-B Control Register: Controls triggering and channel selection for conversion sequence-B. Also specifies interrupt mode for sequence-B.
	// Position of CHANNELS field.
	ADC_SEQB_CTRL_CHANNELS_Pos = 0x0
	// Bit mask of CHANNELS field.
	ADC_SEQB_CTRL_CHANNELS_Msk = 0xfff
	// Position of TRIGGER field.
	ADC_SEQB_CTRL_TRIGGER_Pos = 0xc
	// Bit mask of TRIGGER field.
	ADC_SEQB_CTRL_TRIGGER_Msk = 0xf000
	// Position of RESERVED field.
	ADC_SEQB_CTRL_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	ADC_SEQB_CTRL_RESERVED_Msk = 0x30000
	// Position of TRIGPOL field.
	ADC_SEQB_CTRL_TRIGPOL_Pos = 0x12
	// Bit mask of TRIGPOL field.
	ADC_SEQB_CTRL_TRIGPOL_Msk = 0x40000
	// Bit TRIGPOL.
	ADC_SEQB_CTRL_TRIGPOL = 0x40000
	// Negative edge. A negative edge launches the conversion sequence on the selected trigger input.
	ADC_SEQB_CTRL_TRIGPOL_NEGATIVE_EDGE = 0x0
	// Positive edge. A positive edge launches the conversion sequence on the selected trigger input.
	ADC_SEQB_CTRL_TRIGPOL_POSITIVE_EDGE = 0x1
	// Position of SYNCBYPASS field.
	ADC_SEQB_CTRL_SYNCBYPASS_Pos = 0x13
	// Bit mask of SYNCBYPASS field.
	ADC_SEQB_CTRL_SYNCBYPASS_Msk = 0x80000
	// Bit SYNCBYPASS.
	ADC_SEQB_CTRL_SYNCBYPASS = 0x80000
	// Enable synchronization. The hardware trigger bypass is not enabled.
	ADC_SEQB_CTRL_SYNCBYPASS_ENABLE_SYNCHRONIZATI = 0x0
	// Bypass synchronization. The hardware trigger bypass is enabled.
	ADC_SEQB_CTRL_SYNCBYPASS_BYPASS_SYNCHRONIZATI = 0x1
	// Position of RESERVED field.
	ADC_SEQB_CTRL_RESERVED_Pos = 0x14
	// Bit mask of RESERVED field.
	ADC_SEQB_CTRL_RESERVED_Msk = 0x3f00000
	// Position of START field.
	ADC_SEQB_CTRL_START_Pos = 0x1a
	// Bit mask of START field.
	ADC_SEQB_CTRL_START_Msk = 0x4000000
	// Bit START.
	ADC_SEQB_CTRL_START = 0x4000000
	// Position of BURST field.
	ADC_SEQB_CTRL_BURST_Pos = 0x1b
	// Bit mask of BURST field.
	ADC_SEQB_CTRL_BURST_Msk = 0x8000000
	// Bit BURST.
	ADC_SEQB_CTRL_BURST = 0x8000000
	// Position of SINGLESTEP field.
	ADC_SEQB_CTRL_SINGLESTEP_Pos = 0x1c
	// Bit mask of SINGLESTEP field.
	ADC_SEQB_CTRL_SINGLESTEP_Msk = 0x10000000
	// Bit SINGLESTEP.
	ADC_SEQB_CTRL_SINGLESTEP = 0x10000000
	// Position of RESERVED field.
	ADC_SEQB_CTRL_RESERVED_Pos = 0x1d
	// Bit mask of RESERVED field.
	ADC_SEQB_CTRL_RESERVED_Msk = 0x20000000
	// Bit RESERVED.
	ADC_SEQB_CTRL_RESERVED = 0x20000000
	// Position of MODE field.
	ADC_SEQB_CTRL_MODE_Pos = 0x1e
	// Bit mask of MODE field.
	ADC_SEQB_CTRL_MODE_Msk = 0x40000000
	// Bit MODE.
	ADC_SEQB_CTRL_MODE = 0x40000000
	// End of conversion. The sequence B interrupt/DMA flag will be set at the end of each individual A/D conversion performed under sequence B. This flag will mirror the DATAVALID bit in the SEQB_GDAT register. The OVERRUN bit in the SEQB_GDAT register will contribute to generation of an overrun interrupt/DMA request if enabled.
	ADC_SEQB_CTRL_MODE_END_OF_CONVERSION = 0x0
	// End of sequence. The sequence B interrupt/DMA flag will be set when the entire set of sequence B conversions completes. This flag will need to be explicitly cleared by software or by the DMA-clear signal in this mode. The OVERRUN bit in the SEQB_GDAT register will NOT contribute to generation of an overrun interrupt/DMA request since it is assumed this register will not be utilized in this mode.
	ADC_SEQB_CTRL_MODE_END_OF_SEQUENCE = 0x1
	// Position of SEQB_ENA field.
	ADC_SEQB_CTRL_SEQB_ENA_Pos = 0x1f
	// Bit mask of SEQB_ENA field.
	ADC_SEQB_CTRL_SEQB_ENA_Msk = 0x80000000
	// Bit SEQB_ENA.
	ADC_SEQB_CTRL_SEQB_ENA = 0x80000000
	// Disabled. Sequence B is disabled. Sequence B triggers are ignored. If this bit is cleared while sequence B is in progress, the sequence will be halted at the end of the current conversion. After the sequence is re-enabled, a new trigger will be required to restart the sequence beginning with the next enabled channel.
	ADC_SEQB_CTRL_SEQB_ENA_DISABLED = 0x0
	// Enabled. Sequence B is enabled.
	ADC_SEQB_CTRL_SEQB_ENA_ENABLED = 0x1

	// SEQA_GDAT: A/D Sequence-A Global Data Register. This register contains the result of the most recent A/D conversion performed under sequence-A
	// Position of RESERVED field.
	ADC_SEQA_GDAT_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	ADC_SEQA_GDAT_RESERVED_Msk = 0xf
	// Position of RESULT field.
	ADC_SEQA_GDAT_RESULT_Pos = 0x4
	// Bit mask of RESULT field.
	ADC_SEQA_GDAT_RESULT_Msk = 0xfff0
	// Position of THCMPRANGE field.
	ADC_SEQA_GDAT_THCMPRANGE_Pos = 0x10
	// Bit mask of THCMPRANGE field.
	ADC_SEQA_GDAT_THCMPRANGE_Msk = 0x30000
	// Position of THCMPCROSS field.
	ADC_SEQA_GDAT_THCMPCROSS_Pos = 0x12
	// Bit mask of THCMPCROSS field.
	ADC_SEQA_GDAT_THCMPCROSS_Msk = 0xc0000
	// Position of RESERVED field.
	ADC_SEQA_GDAT_RESERVED_Pos = 0x14
	// Bit mask of RESERVED field.
	ADC_SEQA_GDAT_RESERVED_Msk = 0x3f00000
	// Position of CHN field.
	ADC_SEQA_GDAT_CHN_Pos = 0x1a
	// Bit mask of CHN field.
	ADC_SEQA_GDAT_CHN_Msk = 0x3c000000
	// Position of OVERRUN field.
	ADC_SEQA_GDAT_OVERRUN_Pos = 0x1e
	// Bit mask of OVERRUN field.
	ADC_SEQA_GDAT_OVERRUN_Msk = 0x40000000
	// Bit OVERRUN.
	ADC_SEQA_GDAT_OVERRUN = 0x40000000
	// Position of DATAVALID field.
	ADC_SEQA_GDAT_DATAVALID_Pos = 0x1f
	// Bit mask of DATAVALID field.
	ADC_SEQA_GDAT_DATAVALID_Msk = 0x80000000
	// Bit DATAVALID.
	ADC_SEQA_GDAT_DATAVALID = 0x80000000

	// SEQB_GDAT: A/D Sequence-B Global Data Register. This register contains the result of the most recent A/D conversion performed under sequence-B
	// Position of RESERVED field.
	ADC_SEQB_GDAT_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	ADC_SEQB_GDAT_RESERVED_Msk = 0xf
	// Position of RESULT field.
	ADC_SEQB_GDAT_RESULT_Pos = 0x4
	// Bit mask of RESULT field.
	ADC_SEQB_GDAT_RESULT_Msk = 0xfff0
	// Position of THCMPRANGE field.
	ADC_SEQB_GDAT_THCMPRANGE_Pos = 0x10
	// Bit mask of THCMPRANGE field.
	ADC_SEQB_GDAT_THCMPRANGE_Msk = 0x30000
	// Position of THCMPCROSS field.
	ADC_SEQB_GDAT_THCMPCROSS_Pos = 0x12
	// Bit mask of THCMPCROSS field.
	ADC_SEQB_GDAT_THCMPCROSS_Msk = 0xc0000
	// Position of RESERVED field.
	ADC_SEQB_GDAT_RESERVED_Pos = 0x14
	// Bit mask of RESERVED field.
	ADC_SEQB_GDAT_RESERVED_Msk = 0x3f00000
	// Position of CHN field.
	ADC_SEQB_GDAT_CHN_Pos = 0x1a
	// Bit mask of CHN field.
	ADC_SEQB_GDAT_CHN_Msk = 0x3c000000
	// Position of OVERRUN field.
	ADC_SEQB_GDAT_OVERRUN_Pos = 0x1e
	// Bit mask of OVERRUN field.
	ADC_SEQB_GDAT_OVERRUN_Msk = 0x40000000
	// Bit OVERRUN.
	ADC_SEQB_GDAT_OVERRUN = 0x40000000
	// Position of DATAVALID field.
	ADC_SEQB_GDAT_DATAVALID_Pos = 0x1f
	// Bit mask of DATAVALID field.
	ADC_SEQB_GDAT_DATAVALID_Msk = 0x80000000
	// Bit DATAVALID.
	ADC_SEQB_GDAT_DATAVALID = 0x80000000

	// DAT: A/D Channel 0 Data Register. This register contains the result of the most recent conversion completed on channel 0.
	// Position of RESERVED field.
	ADC_DAT_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	ADC_DAT_RESERVED_Msk = 0xf
	// Position of RESULT field.
	ADC_DAT_RESULT_Pos = 0x4
	// Bit mask of RESULT field.
	ADC_DAT_RESULT_Msk = 0xfff0
	// Position of THCMPRANGE field.
	ADC_DAT_THCMPRANGE_Pos = 0x10
	// Bit mask of THCMPRANGE field.
	ADC_DAT_THCMPRANGE_Msk = 0x30000
	// Position of THCMPCROSS field.
	ADC_DAT_THCMPCROSS_Pos = 0x12
	// Bit mask of THCMPCROSS field.
	ADC_DAT_THCMPCROSS_Msk = 0xc0000
	// Position of RESERVED field.
	ADC_DAT_RESERVED_Pos = 0x14
	// Bit mask of RESERVED field.
	ADC_DAT_RESERVED_Msk = 0x3f00000
	// Position of CHANNEL field.
	ADC_DAT_CHANNEL_Pos = 0x1a
	// Bit mask of CHANNEL field.
	ADC_DAT_CHANNEL_Msk = 0x3c000000
	// Position of OVERRUN field.
	ADC_DAT_OVERRUN_Pos = 0x1e
	// Bit mask of OVERRUN field.
	ADC_DAT_OVERRUN_Msk = 0x40000000
	// Bit OVERRUN.
	ADC_DAT_OVERRUN = 0x40000000
	// Position of DATAVALID field.
	ADC_DAT_DATAVALID_Pos = 0x1f
	// Bit mask of DATAVALID field.
	ADC_DAT_DATAVALID_Msk = 0x80000000
	// Bit DATAVALID.
	ADC_DAT_DATAVALID = 0x80000000

	// THR0_LOW: A/D Low Compare Threshold Register 0 : Contains the lower threshold level for automatic threshold comparison for any channels linked to threshold pair 0.
	// Position of RESERVED field.
	ADC_THR0_LOW_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	ADC_THR0_LOW_RESERVED_Msk = 0xf
	// Position of THRLOW field.
	ADC_THR0_LOW_THRLOW_Pos = 0x4
	// Bit mask of THRLOW field.
	ADC_THR0_LOW_THRLOW_Msk = 0xfff0
	// Position of RESERVED field.
	ADC_THR0_LOW_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	ADC_THR0_LOW_RESERVED_Msk = 0xffff0000

	// THR1_LOW: A/D Low Compare Threshold Register 1: Contains the lower threshold level for automatic threshold comparison for any channels linked to threshold pair 1.
	// Position of RESERVED field.
	ADC_THR1_LOW_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	ADC_THR1_LOW_RESERVED_Msk = 0xf
	// Position of THRLOW field.
	ADC_THR1_LOW_THRLOW_Pos = 0x4
	// Bit mask of THRLOW field.
	ADC_THR1_LOW_THRLOW_Msk = 0xfff0
	// Position of RESERVED field.
	ADC_THR1_LOW_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	ADC_THR1_LOW_RESERVED_Msk = 0xffff0000

	// THR0_HIGH: A/D High Compare Threshold Register 0: Contains the upper threshold level for automatic threshold comparison for any channels linked to threshold pair 0.
	// Position of RESERVED field.
	ADC_THR0_HIGH_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	ADC_THR0_HIGH_RESERVED_Msk = 0xf
	// Position of THRHIGH field.
	ADC_THR0_HIGH_THRHIGH_Pos = 0x4
	// Bit mask of THRHIGH field.
	ADC_THR0_HIGH_THRHIGH_Msk = 0xfff0
	// Position of RESERVED field.
	ADC_THR0_HIGH_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	ADC_THR0_HIGH_RESERVED_Msk = 0xffff0000

	// THR1_HIGH: A/D High Compare Threshold Register 1: Contains the upper threshold level for automatic threshold comparison for any channels linked to threshold pair 1.
	// Position of RESERVED field.
	ADC_THR1_HIGH_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	ADC_THR1_HIGH_RESERVED_Msk = 0xf
	// Position of THRHIGH field.
	ADC_THR1_HIGH_THRHIGH_Pos = 0x4
	// Bit mask of THRHIGH field.
	ADC_THR1_HIGH_THRHIGH_Msk = 0xfff0
	// Position of RESERVED field.
	ADC_THR1_HIGH_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	ADC_THR1_HIGH_RESERVED_Msk = 0xffff0000

	// CHAN_THRSEL: A/D Channel-Threshold Select Register. Specifies which set of threshold compare registers are to be used for each channel
	// Position of CH0_THRSEL field.
	ADC_CHAN_THRSEL_CH0_THRSEL_Pos = 0x0
	// Bit mask of CH0_THRSEL field.
	ADC_CHAN_THRSEL_CH0_THRSEL_Msk = 0x1
	// Bit CH0_THRSEL.
	ADC_CHAN_THRSEL_CH0_THRSEL = 0x1
	// Threshold 0. Channel 0 results will be compared against the threshold levels indicated in the THR0_LOW and THR0_HIGH registers
	ADC_CHAN_THRSEL_CH0_THRSEL_THRESHOLD_0 = 0x0
	// Threshold 1. Channel 0 results will be compared against the threshold levels indicated in the THR1_LOW and THR1_HIGH registers
	ADC_CHAN_THRSEL_CH0_THRSEL_THRESHOLD_1 = 0x1
	// Position of CH1_THRSEL field.
	ADC_CHAN_THRSEL_CH1_THRSEL_Pos = 0x1
	// Bit mask of CH1_THRSEL field.
	ADC_CHAN_THRSEL_CH1_THRSEL_Msk = 0x2
	// Bit CH1_THRSEL.
	ADC_CHAN_THRSEL_CH1_THRSEL = 0x2
	// Threshold 0. Channel 1 results will be compared against the threshold levels indicated in the THR0_LOW and THR0_HIGH registers
	ADC_CHAN_THRSEL_CH1_THRSEL_THRESHOLD_0 = 0x0
	// Threshold 1. Channel 1 results will be compared against the threshold levels indicated in the THR1_LOW and THR1_HIGH registers
	ADC_CHAN_THRSEL_CH1_THRSEL_THRESHOLD_1 = 0x1
	// Position of CH2_THRSEL field.
	ADC_CHAN_THRSEL_CH2_THRSEL_Pos = 0x2
	// Bit mask of CH2_THRSEL field.
	ADC_CHAN_THRSEL_CH2_THRSEL_Msk = 0x4
	// Bit CH2_THRSEL.
	ADC_CHAN_THRSEL_CH2_THRSEL = 0x4
	// Threshold 0. Channel 2 results will be compared against the threshold levels indicated in the THR0_LOW and THR0_HIGH registers
	ADC_CHAN_THRSEL_CH2_THRSEL_THRESHOLD_0 = 0x0
	// Threshold 1. Channel 2 results will be compared against the threshold levels indicated in the THR1_LOW and THR1_HIGH registers
	ADC_CHAN_THRSEL_CH2_THRSEL_THRESHOLD_1 = 0x1
	// Position of CH3_THRSEL field.
	ADC_CHAN_THRSEL_CH3_THRSEL_Pos = 0x3
	// Bit mask of CH3_THRSEL field.
	ADC_CHAN_THRSEL_CH3_THRSEL_Msk = 0x8
	// Bit CH3_THRSEL.
	ADC_CHAN_THRSEL_CH3_THRSEL = 0x8
	// Threshold 0. Channel 3 results will be compared against the threshold levels indicated in the THR0_LOW and THR0_HIGH registers
	ADC_CHAN_THRSEL_CH3_THRSEL_THRESHOLD_0 = 0x0
	// Threshold 1. Channel 3 results will be compared against the threshold levels indicated in the THR1_LOW and THR1_HIGH registers
	ADC_CHAN_THRSEL_CH3_THRSEL_THRESHOLD_1 = 0x1
	// Position of CH4_THRSEL field.
	ADC_CHAN_THRSEL_CH4_THRSEL_Pos = 0x4
	// Bit mask of CH4_THRSEL field.
	ADC_CHAN_THRSEL_CH4_THRSEL_Msk = 0x10
	// Bit CH4_THRSEL.
	ADC_CHAN_THRSEL_CH4_THRSEL = 0x10
	// Threshold 0. Channel 4 results will be compared against the threshold levels indicated in the THR0_LOW and THR0_HIGH registers
	ADC_CHAN_THRSEL_CH4_THRSEL_THRESHOLD_0 = 0x0
	// Threshold 1. Channel 4 results will be compared against the threshold levels indicated in the THR1_LOW and THR1_HIGH registers
	ADC_CHAN_THRSEL_CH4_THRSEL_THRESHOLD_1 = 0x1
	// Position of CH5_THRSEL field.
	ADC_CHAN_THRSEL_CH5_THRSEL_Pos = 0x5
	// Bit mask of CH5_THRSEL field.
	ADC_CHAN_THRSEL_CH5_THRSEL_Msk = 0x20
	// Bit CH5_THRSEL.
	ADC_CHAN_THRSEL_CH5_THRSEL = 0x20
	// Threshold 0. Channel 5 results will be compared against the threshold levels indicated in the THR0_LOW and THR0_HIGH registers
	ADC_CHAN_THRSEL_CH5_THRSEL_THRESHOLD_0 = 0x0
	// Threshold 1. Channel 5 results will be compared against the threshold levels indicated in the THR1_LOW and THR1_HIGH registers
	ADC_CHAN_THRSEL_CH5_THRSEL_THRESHOLD_1 = 0x1
	// Position of CH6_THRSEL field.
	ADC_CHAN_THRSEL_CH6_THRSEL_Pos = 0x6
	// Bit mask of CH6_THRSEL field.
	ADC_CHAN_THRSEL_CH6_THRSEL_Msk = 0x40
	// Bit CH6_THRSEL.
	ADC_CHAN_THRSEL_CH6_THRSEL = 0x40
	// Threshold 0. Channel 6 results will be compared against the threshold levels indicated in the THR0_LOW and THR0_HIGH registers
	ADC_CHAN_THRSEL_CH6_THRSEL_THRESHOLD_0 = 0x0
	// Threshold 1. Channel 6 results will be compared against the threshold levels indicated in the THR1_LOW and THR1_HIGH registers
	ADC_CHAN_THRSEL_CH6_THRSEL_THRESHOLD_1 = 0x1
	// Position of CH7_THRSEL field.
	ADC_CHAN_THRSEL_CH7_THRSEL_Pos = 0x7
	// Bit mask of CH7_THRSEL field.
	ADC_CHAN_THRSEL_CH7_THRSEL_Msk = 0x80
	// Bit CH7_THRSEL.
	ADC_CHAN_THRSEL_CH7_THRSEL = 0x80
	// Threshold 0. Channel 7 results will be compared against the threshold levels indicated in the THR0_LOW and THR0_HIGH registers
	ADC_CHAN_THRSEL_CH7_THRSEL_THRESHOLD_0 = 0x0
	// Threshold 1. Channel 7 results will be compared against the threshold levels indicated in the THR1_LOW and THR1_HIGH registers
	ADC_CHAN_THRSEL_CH7_THRSEL_THRESHOLD_1 = 0x1
	// Position of CH8_THRSEL field.
	ADC_CHAN_THRSEL_CH8_THRSEL_Pos = 0x8
	// Bit mask of CH8_THRSEL field.
	ADC_CHAN_THRSEL_CH8_THRSEL_Msk = 0x100
	// Bit CH8_THRSEL.
	ADC_CHAN_THRSEL_CH8_THRSEL = 0x100
	// Threshold 0. Channel 8 results will be compared against the threshold levels indicated in the THR0_LOW and THR0_HIGH registers
	ADC_CHAN_THRSEL_CH8_THRSEL_THRESHOLD_0 = 0x0
	// Threshold 1. Channel 8 results will be compared against the threshold levels indicated in the THR1_LOW and THR1_HIGH registers
	ADC_CHAN_THRSEL_CH8_THRSEL_THRESHOLD_1 = 0x1
	// Position of CH9_THRSEL field.
	ADC_CHAN_THRSEL_CH9_THRSEL_Pos = 0x9
	// Bit mask of CH9_THRSEL field.
	ADC_CHAN_THRSEL_CH9_THRSEL_Msk = 0x200
	// Bit CH9_THRSEL.
	ADC_CHAN_THRSEL_CH9_THRSEL = 0x200
	// Threshold 0. Channel 9 results will be compared against the threshold levels indicated in the THR0_LOW and THR0_HIGH registers
	ADC_CHAN_THRSEL_CH9_THRSEL_THRESHOLD_0 = 0x0
	// Threshold 1. Channel 9 results will be compared against the threshold levels indicated in the THR1_LOW and THR1_HIGH registers
	ADC_CHAN_THRSEL_CH9_THRSEL_THRESHOLD_1 = 0x1
	// Position of CH10_THRSEL field.
	ADC_CHAN_THRSEL_CH10_THRSEL_Pos = 0xa
	// Bit mask of CH10_THRSEL field.
	ADC_CHAN_THRSEL_CH10_THRSEL_Msk = 0x400
	// Bit CH10_THRSEL.
	ADC_CHAN_THRSEL_CH10_THRSEL = 0x400
	// Threshold 0. Channel 10 results will be compared against the threshold levels indicated in the THR0_LOW and THR0_HIGH registers
	ADC_CHAN_THRSEL_CH10_THRSEL_THRESHOLD_0 = 0x0
	// Threshold 1. Channel 10 results will be compared against the threshold levels indicated in the THR1_LOW and THR1_HIGH registers
	ADC_CHAN_THRSEL_CH10_THRSEL_THRESHOLD_1 = 0x1
	// Position of CH11_THRSEL field.
	ADC_CHAN_THRSEL_CH11_THRSEL_Pos = 0xb
	// Bit mask of CH11_THRSEL field.
	ADC_CHAN_THRSEL_CH11_THRSEL_Msk = 0x800
	// Bit CH11_THRSEL.
	ADC_CHAN_THRSEL_CH11_THRSEL = 0x800
	// Threshold 0. Channel 11 results will be compared against the threshold levels indicated in the THR0_LOW and THR0_HIGH registers
	ADC_CHAN_THRSEL_CH11_THRSEL_THRESHOLD_0 = 0x0
	// Threshold 1. Channel 11 results will be compared against the threshold levels indicated in the THR1_LOW and THR1_HIGH registers
	ADC_CHAN_THRSEL_CH11_THRSEL_THRESHOLD_1 = 0x1
	// Position of RESERVED field.
	ADC_CHAN_THRSEL_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	ADC_CHAN_THRSEL_RESERVED_Msk = 0xfffff000

	// INTEN: A/D Interrupt Enable Register. This register contains enable bits that enable the sequence-A, sequence-B, threshold compare and data overrun interrupts to be generated.
	// Position of SEQA_INTEN field.
	ADC_INTEN_SEQA_INTEN_Pos = 0x0
	// Bit mask of SEQA_INTEN field.
	ADC_INTEN_SEQA_INTEN_Msk = 0x1
	// Bit SEQA_INTEN.
	ADC_INTEN_SEQA_INTEN = 0x1
	// Disabled. The sequence A interrupt/DMA request is disabled.
	ADC_INTEN_SEQA_INTEN_DISABLED = 0x0
	// Enabled. The sequence A interrupt/DMA request is enabled and will be asserted either upon completion of each individual conversion performed as part of sequence A, or upon completion of the entire A sequence of conversions, depending on the MODE bit in the SEQA_CTRL register.
	ADC_INTEN_SEQA_INTEN_ENABLED = 0x1
	// Position of SEQB_INTEN field.
	ADC_INTEN_SEQB_INTEN_Pos = 0x1
	// Bit mask of SEQB_INTEN field.
	ADC_INTEN_SEQB_INTEN_Msk = 0x2
	// Bit SEQB_INTEN.
	ADC_INTEN_SEQB_INTEN = 0x2
	// Disabled. The sequence B interrupt/DMA request is disabled.
	ADC_INTEN_SEQB_INTEN_DISABLED = 0x0
	// Enabled. The sequence B interrupt/DMA request is enabled and will be asserted either upon completion of each individual conversion performed as part of sequence B, or upon completion of the entire B sequence of conversions, depending on the MODE bit in the SEQB_CTRL register.
	ADC_INTEN_SEQB_INTEN_ENABLED = 0x1
	// Position of OVR_INTEN field.
	ADC_INTEN_OVR_INTEN_Pos = 0x2
	// Bit mask of OVR_INTEN field.
	ADC_INTEN_OVR_INTEN_Msk = 0x4
	// Bit OVR_INTEN.
	ADC_INTEN_OVR_INTEN = 0x4
	// Disabled. The overrun interrupt is disabled.
	ADC_INTEN_OVR_INTEN_DISABLED = 0x0
	// Enabled. The overrun interrupt is enabled. Detection of an overrun condition on any of the 12 channel data registers will cause an overrun interrupt request. In addition, if the MODE bit for a particular sequence is 0, then an overrun in the global data register for that sequence will also cause this interrupt request to be asserted.
	ADC_INTEN_OVR_INTEN_ENABLED = 0x1
	// Position of ADCMPINTEN0 field.
	ADC_INTEN_ADCMPINTEN0_Pos = 0x3
	// Bit mask of ADCMPINTEN0 field.
	ADC_INTEN_ADCMPINTEN0_Msk = 0x18
	// Disabled.
	ADC_INTEN_ADCMPINTEN0_DISABLED = 0x0
	// Outside threshold.
	ADC_INTEN_ADCMPINTEN0_OUTSIDE_THRESHOLD = 0x1
	// Crossing threshold.
	ADC_INTEN_ADCMPINTEN0_CROSSING_THRESHOLD = 0x2
	// Position of ADCMPINTEN1 field.
	ADC_INTEN_ADCMPINTEN1_Pos = 0x5
	// Bit mask of ADCMPINTEN1 field.
	ADC_INTEN_ADCMPINTEN1_Msk = 0x60
	// Disabled.
	ADC_INTEN_ADCMPINTEN1_DISABLED = 0x0
	// Outside threshold.
	ADC_INTEN_ADCMPINTEN1_OUTSIDE_THRESHOLD = 0x1
	// Crossing threshold.
	ADC_INTEN_ADCMPINTEN1_CROSSING_THRESHOLD = 0x2
	// Position of ADCMPINTEN2 field.
	ADC_INTEN_ADCMPINTEN2_Pos = 0x7
	// Bit mask of ADCMPINTEN2 field.
	ADC_INTEN_ADCMPINTEN2_Msk = 0x180
	// Disabled.
	ADC_INTEN_ADCMPINTEN2_DISABLED = 0x0
	// Outside threshold.
	ADC_INTEN_ADCMPINTEN2_OUTSIDE_THRESHOLD = 0x1
	// Crossing threshold.
	ADC_INTEN_ADCMPINTEN2_CROSSING_THRESHOLD = 0x2
	// Position of ADCMPINTEN3 field.
	ADC_INTEN_ADCMPINTEN3_Pos = 0x9
	// Bit mask of ADCMPINTEN3 field.
	ADC_INTEN_ADCMPINTEN3_Msk = 0x600
	// Disabled.
	ADC_INTEN_ADCMPINTEN3_DISABLED = 0x0
	// Outside threshold.
	ADC_INTEN_ADCMPINTEN3_OUTSIDE_THRESHOLD = 0x1
	// Crossing threshold.
	ADC_INTEN_ADCMPINTEN3_CROSSING_THRESHOLD = 0x2
	// Position of ADCMPINTEN4 field.
	ADC_INTEN_ADCMPINTEN4_Pos = 0xb
	// Bit mask of ADCMPINTEN4 field.
	ADC_INTEN_ADCMPINTEN4_Msk = 0x1800
	// Disabled.
	ADC_INTEN_ADCMPINTEN4_DISABLED = 0x0
	// Outside threshold.
	ADC_INTEN_ADCMPINTEN4_OUTSIDE_THRESHOLD = 0x1
	// Crossing threshold.
	ADC_INTEN_ADCMPINTEN4_CROSSING_THRESHOLD = 0x2
	// Position of ADCMPINTEN5 field.
	ADC_INTEN_ADCMPINTEN5_Pos = 0xd
	// Bit mask of ADCMPINTEN5 field.
	ADC_INTEN_ADCMPINTEN5_Msk = 0x6000
	// Disabled.
	ADC_INTEN_ADCMPINTEN5_DISABLED = 0x0
	// Outside threshold.
	ADC_INTEN_ADCMPINTEN5_OUTSIDE_THRESHOLD = 0x1
	// Crossing threshold.
	ADC_INTEN_ADCMPINTEN5_CROSSING_THRESHOLD = 0x2
	// Position of ADCMPINTEN6 field.
	ADC_INTEN_ADCMPINTEN6_Pos = 0xf
	// Bit mask of ADCMPINTEN6 field.
	ADC_INTEN_ADCMPINTEN6_Msk = 0x18000
	// Disabled.
	ADC_INTEN_ADCMPINTEN6_DISABLED = 0x0
	// Outside threshold.
	ADC_INTEN_ADCMPINTEN6_OUTSIDE_THRESHOLD = 0x1
	// Crossing threshold.
	ADC_INTEN_ADCMPINTEN6_CROSSING_THRESHOLD = 0x2
	// Position of ADCMPINTEN7 field.
	ADC_INTEN_ADCMPINTEN7_Pos = 0x11
	// Bit mask of ADCMPINTEN7 field.
	ADC_INTEN_ADCMPINTEN7_Msk = 0x60000
	// Disabled.
	ADC_INTEN_ADCMPINTEN7_DISABLED = 0x0
	// Outside threshold.
	ADC_INTEN_ADCMPINTEN7_OUTSIDE_THRESHOLD = 0x1
	// Crossing threshold.
	ADC_INTEN_ADCMPINTEN7_CROSSING_THRESHOLD = 0x2
	// Position of ADCMPINTEN8 field.
	ADC_INTEN_ADCMPINTEN8_Pos = 0x13
	// Bit mask of ADCMPINTEN8 field.
	ADC_INTEN_ADCMPINTEN8_Msk = 0x180000
	// Disabled.
	ADC_INTEN_ADCMPINTEN8_DISABLED = 0x0
	// Outside threshold.
	ADC_INTEN_ADCMPINTEN8_OUTSIDE_THRESHOLD = 0x1
	// Crossing threshold.
	ADC_INTEN_ADCMPINTEN8_CROSSING_THRESHOLD = 0x2
	// Position of ADCMPINTEN9 field.
	ADC_INTEN_ADCMPINTEN9_Pos = 0x15
	// Bit mask of ADCMPINTEN9 field.
	ADC_INTEN_ADCMPINTEN9_Msk = 0x600000
	// Disabled.
	ADC_INTEN_ADCMPINTEN9_DISABLED = 0x0
	// Outside threshold.
	ADC_INTEN_ADCMPINTEN9_OUTSIDE_THRESHOLD = 0x1
	// Crossing threshold.
	ADC_INTEN_ADCMPINTEN9_CROSSING_THRESHOLD = 0x2
	// Position of ADCMPINTEN10 field.
	ADC_INTEN_ADCMPINTEN10_Pos = 0x17
	// Bit mask of ADCMPINTEN10 field.
	ADC_INTEN_ADCMPINTEN10_Msk = 0x1800000
	// Disabled.
	ADC_INTEN_ADCMPINTEN10_DISABLED = 0x0
	// Outside threshold.
	ADC_INTEN_ADCMPINTEN10_OUTSIDE_THRESHOLD = 0x1
	// Crossing threshold.
	ADC_INTEN_ADCMPINTEN10_CROSSING_THRESHOLD = 0x2
	// Position of ADCMPINTEN11 field.
	ADC_INTEN_ADCMPINTEN11_Pos = 0x19
	// Bit mask of ADCMPINTEN11 field.
	ADC_INTEN_ADCMPINTEN11_Msk = 0x6000000
	// Disabled.
	ADC_INTEN_ADCMPINTEN11_DISABLED = 0x0
	// Outside threshold.
	ADC_INTEN_ADCMPINTEN11_OUTSIDE_THRESHOLD = 0x1
	// Crossing threshold.
	ADC_INTEN_ADCMPINTEN11_CROSSING_THRESHOLD = 0x2
	// Position of RESERVED field.
	ADC_INTEN_RESERVED_Pos = 0x1b
	// Bit mask of RESERVED field.
	ADC_INTEN_RESERVED_Msk = 0xf8000000

	// FLAGS: A/D Flags Register. Contains the four interrupt request flags and the individual component overrun and threshold-compare flags. (The overrun bits replicate information stored in the result registers).
	// Position of THCMP0 field.
	ADC_FLAGS_THCMP0_Pos = 0x0
	// Bit mask of THCMP0 field.
	ADC_FLAGS_THCMP0_Msk = 0x1
	// Bit THCMP0.
	ADC_FLAGS_THCMP0 = 0x1
	// Position of THCMP1 field.
	ADC_FLAGS_THCMP1_Pos = 0x1
	// Bit mask of THCMP1 field.
	ADC_FLAGS_THCMP1_Msk = 0x2
	// Bit THCMP1.
	ADC_FLAGS_THCMP1 = 0x2
	// Position of THCMP2 field.
	ADC_FLAGS_THCMP2_Pos = 0x2
	// Bit mask of THCMP2 field.
	ADC_FLAGS_THCMP2_Msk = 0x4
	// Bit THCMP2.
	ADC_FLAGS_THCMP2 = 0x4
	// Position of THCMP3 field.
	ADC_FLAGS_THCMP3_Pos = 0x3
	// Bit mask of THCMP3 field.
	ADC_FLAGS_THCMP3_Msk = 0x8
	// Bit THCMP3.
	ADC_FLAGS_THCMP3 = 0x8
	// Position of THCMP4 field.
	ADC_FLAGS_THCMP4_Pos = 0x4
	// Bit mask of THCMP4 field.
	ADC_FLAGS_THCMP4_Msk = 0x10
	// Bit THCMP4.
	ADC_FLAGS_THCMP4 = 0x10
	// Position of THCMP5 field.
	ADC_FLAGS_THCMP5_Pos = 0x5
	// Bit mask of THCMP5 field.
	ADC_FLAGS_THCMP5_Msk = 0x20
	// Bit THCMP5.
	ADC_FLAGS_THCMP5 = 0x20
	// Position of THCMP6 field.
	ADC_FLAGS_THCMP6_Pos = 0x6
	// Bit mask of THCMP6 field.
	ADC_FLAGS_THCMP6_Msk = 0x40
	// Bit THCMP6.
	ADC_FLAGS_THCMP6 = 0x40
	// Position of THCMP7 field.
	ADC_FLAGS_THCMP7_Pos = 0x7
	// Bit mask of THCMP7 field.
	ADC_FLAGS_THCMP7_Msk = 0x80
	// Bit THCMP7.
	ADC_FLAGS_THCMP7 = 0x80
	// Position of THCMP8 field.
	ADC_FLAGS_THCMP8_Pos = 0x8
	// Bit mask of THCMP8 field.
	ADC_FLAGS_THCMP8_Msk = 0x100
	// Bit THCMP8.
	ADC_FLAGS_THCMP8 = 0x100
	// Position of THCMP9 field.
	ADC_FLAGS_THCMP9_Pos = 0x9
	// Bit mask of THCMP9 field.
	ADC_FLAGS_THCMP9_Msk = 0x200
	// Bit THCMP9.
	ADC_FLAGS_THCMP9 = 0x200
	// Position of THCMP10 field.
	ADC_FLAGS_THCMP10_Pos = 0xa
	// Bit mask of THCMP10 field.
	ADC_FLAGS_THCMP10_Msk = 0x400
	// Bit THCMP10.
	ADC_FLAGS_THCMP10 = 0x400
	// Position of THCMP11 field.
	ADC_FLAGS_THCMP11_Pos = 0xb
	// Bit mask of THCMP11 field.
	ADC_FLAGS_THCMP11_Msk = 0x800
	// Bit THCMP11.
	ADC_FLAGS_THCMP11 = 0x800
	// Position of OVERRUN0 field.
	ADC_FLAGS_OVERRUN0_Pos = 0xc
	// Bit mask of OVERRUN0 field.
	ADC_FLAGS_OVERRUN0_Msk = 0x1000
	// Bit OVERRUN0.
	ADC_FLAGS_OVERRUN0 = 0x1000
	// Position of OVERRUN1 field.
	ADC_FLAGS_OVERRUN1_Pos = 0xd
	// Bit mask of OVERRUN1 field.
	ADC_FLAGS_OVERRUN1_Msk = 0x2000
	// Bit OVERRUN1.
	ADC_FLAGS_OVERRUN1 = 0x2000
	// Position of OVERRUN2 field.
	ADC_FLAGS_OVERRUN2_Pos = 0xe
	// Bit mask of OVERRUN2 field.
	ADC_FLAGS_OVERRUN2_Msk = 0x4000
	// Bit OVERRUN2.
	ADC_FLAGS_OVERRUN2 = 0x4000
	// Position of OVERRUN3 field.
	ADC_FLAGS_OVERRUN3_Pos = 0xf
	// Bit mask of OVERRUN3 field.
	ADC_FLAGS_OVERRUN3_Msk = 0x8000
	// Bit OVERRUN3.
	ADC_FLAGS_OVERRUN3 = 0x8000
	// Position of OVERRUN4 field.
	ADC_FLAGS_OVERRUN4_Pos = 0x10
	// Bit mask of OVERRUN4 field.
	ADC_FLAGS_OVERRUN4_Msk = 0x10000
	// Bit OVERRUN4.
	ADC_FLAGS_OVERRUN4 = 0x10000
	// Position of OVERRUN5 field.
	ADC_FLAGS_OVERRUN5_Pos = 0x11
	// Bit mask of OVERRUN5 field.
	ADC_FLAGS_OVERRUN5_Msk = 0x20000
	// Bit OVERRUN5.
	ADC_FLAGS_OVERRUN5 = 0x20000
	// Position of OVERRUN6 field.
	ADC_FLAGS_OVERRUN6_Pos = 0x12
	// Bit mask of OVERRUN6 field.
	ADC_FLAGS_OVERRUN6_Msk = 0x40000
	// Bit OVERRUN6.
	ADC_FLAGS_OVERRUN6 = 0x40000
	// Position of OVERRUN7 field.
	ADC_FLAGS_OVERRUN7_Pos = 0x13
	// Bit mask of OVERRUN7 field.
	ADC_FLAGS_OVERRUN7_Msk = 0x80000
	// Bit OVERRUN7.
	ADC_FLAGS_OVERRUN7 = 0x80000
	// Position of OVERRUN8 field.
	ADC_FLAGS_OVERRUN8_Pos = 0x14
	// Bit mask of OVERRUN8 field.
	ADC_FLAGS_OVERRUN8_Msk = 0x100000
	// Bit OVERRUN8.
	ADC_FLAGS_OVERRUN8 = 0x100000
	// Position of OVERRUN9 field.
	ADC_FLAGS_OVERRUN9_Pos = 0x15
	// Bit mask of OVERRUN9 field.
	ADC_FLAGS_OVERRUN9_Msk = 0x200000
	// Bit OVERRUN9.
	ADC_FLAGS_OVERRUN9 = 0x200000
	// Position of OVERRUN10 field.
	ADC_FLAGS_OVERRUN10_Pos = 0x16
	// Bit mask of OVERRUN10 field.
	ADC_FLAGS_OVERRUN10_Msk = 0x400000
	// Bit OVERRUN10.
	ADC_FLAGS_OVERRUN10 = 0x400000
	// Position of OVERRUN11 field.
	ADC_FLAGS_OVERRUN11_Pos = 0x17
	// Bit mask of OVERRUN11 field.
	ADC_FLAGS_OVERRUN11_Msk = 0x800000
	// Bit OVERRUN11.
	ADC_FLAGS_OVERRUN11 = 0x800000
	// Position of SEQA_OVR field.
	ADC_FLAGS_SEQA_OVR_Pos = 0x18
	// Bit mask of SEQA_OVR field.
	ADC_FLAGS_SEQA_OVR_Msk = 0x1000000
	// Bit SEQA_OVR.
	ADC_FLAGS_SEQA_OVR = 0x1000000
	// Position of SEQB_OVR field.
	ADC_FLAGS_SEQB_OVR_Pos = 0x19
	// Bit mask of SEQB_OVR field.
	ADC_FLAGS_SEQB_OVR_Msk = 0x2000000
	// Bit SEQB_OVR.
	ADC_FLAGS_SEQB_OVR = 0x2000000
	// Position of RESERVED field.
	ADC_FLAGS_RESERVED_Pos = 0x1a
	// Bit mask of RESERVED field.
	ADC_FLAGS_RESERVED_Msk = 0xc000000
	// Position of SEQA_INT field.
	ADC_FLAGS_SEQA_INT_Pos = 0x1c
	// Bit mask of SEQA_INT field.
	ADC_FLAGS_SEQA_INT_Msk = 0x10000000
	// Bit SEQA_INT.
	ADC_FLAGS_SEQA_INT = 0x10000000
	// Position of SEQB_INT field.
	ADC_FLAGS_SEQB_INT_Pos = 0x1d
	// Bit mask of SEQB_INT field.
	ADC_FLAGS_SEQB_INT_Msk = 0x20000000
	// Bit SEQB_INT.
	ADC_FLAGS_SEQB_INT = 0x20000000
	// Position of THCMP_INT field.
	ADC_FLAGS_THCMP_INT_Pos = 0x1e
	// Bit mask of THCMP_INT field.
	ADC_FLAGS_THCMP_INT_Msk = 0x40000000
	// Bit THCMP_INT.
	ADC_FLAGS_THCMP_INT = 0x40000000
	// Position of OVR_INT field.
	ADC_FLAGS_OVR_INT_Pos = 0x1f
	// Bit mask of OVR_INT field.
	ADC_FLAGS_OVR_INT_Msk = 0x80000000
	// Bit OVR_INT.
	ADC_FLAGS_OVR_INT = 0x80000000

	// TRM: ADC trim register.
	// Position of RESERVED field.
	ADC_TRM_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	ADC_TRM_RESERVED_Msk = 0x1f
	// Position of VRANGE field.
	ADC_TRM_VRANGE_Pos = 0x5
	// Bit mask of VRANGE field.
	ADC_TRM_VRANGE_Msk = 0x20
	// Bit VRANGE.
	ADC_TRM_VRANGE = 0x20
	// High voltage. VDDA = 2.7 V to 3.6 V.
	ADC_TRM_VRANGE_HIGH_VOLTAGE = 0x0
	// Low voltage. VDDA = 2.4 V to 2.7 V.
	ADC_TRM_VRANGE_LOW_VOLTAGE = 0x1
	// Position of RESERVED field.
	ADC_TRM_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	ADC_TRM_RESERVED_Msk = 0xffffffc0
)

// Bitfields for DAC: 12-bit DAC Modification
const (
	// VAL: D/A Converter Value Register. This register contains the digital value to be converted to analog.
	// Position of RESERVED field.
	DAC_VAL_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	DAC_VAL_RESERVED_Msk = 0xf
	// Position of VALUE field.
	DAC_VAL_VALUE_Pos = 0x4
	// Bit mask of VALUE field.
	DAC_VAL_VALUE_Msk = 0xfff0
	// Position of RESERVED field.
	DAC_VAL_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	DAC_VAL_RESERVED_Msk = 0xffff0000

	// CTRL: DAC Control register. This register contains bits to configure DAC operation and the interrupt/dma request flag.
	// Position of INT_DMA_FLAG field.
	DAC_CTRL_INT_DMA_FLAG_Pos = 0x0
	// Bit mask of INT_DMA_FLAG field.
	DAC_CTRL_INT_DMA_FLAG_Msk = 0x1
	// Bit INT_DMA_FLAG.
	DAC_CTRL_INT_DMA_FLAG = 0x1
	// Position of TRIG_SRC field.
	DAC_CTRL_TRIG_SRC_Pos = 0x1
	// Bit mask of TRIG_SRC field.
	DAC_CTRL_TRIG_SRC_Msk = 0xe
	// Internal. Selects the internal timer as the trigger source provided the timer is enabled (the TIMER_ENA bit is set). Otherwise (if the timer is not enabled), hardware triggering is disabled. If hardware triggering is disabled no interrupt or DMA requests will be generated. Double-buffering of the DAC VAL register is not useful and cannot be enabled when hardware triggering is disabled.
	DAC_CTRL_TRIG_SRC_INTERNAL = 0x0
	// Pin. External DAC_TRIG port input is selected. Also select this function in the PINASSIGN11 register in the switchmatrix.
	DAC_CTRL_TRIG_SRC_PIN = 0x1
	// Position of POLARITY field.
	DAC_CTRL_POLARITY_Pos = 0x4
	// Bit mask of POLARITY field.
	DAC_CTRL_POLARITY_Msk = 0x10
	// Bit POLARITY.
	DAC_CTRL_POLARITY = 0x10
	// Rising. A trigger will be asserted when a RISING edge is detected on the selected external trigger input.
	DAC_CTRL_POLARITY_RISING = 0x0
	// Falling. A trigger will be asserted when a FALLING edge is detected on the selected external trigger input.
	DAC_CTRL_POLARITY_FALLING = 0x1
	// Position of SYNC_BYPASS field.
	DAC_CTRL_SYNC_BYPASS_Pos = 0x5
	// Bit mask of SYNC_BYPASS field.
	DAC_CTRL_SYNC_BYPASS_Msk = 0x20
	// Bit SYNC_BYPASS.
	DAC_CTRL_SYNC_BYPASS = 0x20
	// Synchronize. The selected trigger input will be synchronized to the system clock prior to edge-detection.
	DAC_CTRL_SYNC_BYPASS_SYNCHRONIZE = 0x0
	// Not synchronize. The selected trigger input will not be synchronized to the system clock prior to edge-detection. This will save one clock of latency. This bit should only be set f the selected hardware input trigger is from a source that is guaranteeed to already be synchronous to the system clock.
	DAC_CTRL_SYNC_BYPASS_NOT_SYNCHRONIZE = 0x1
	// Position of TIMER_ENA field.
	DAC_CTRL_TIMER_ENA_Pos = 0x6
	// Bit mask of TIMER_ENA field.
	DAC_CTRL_TIMER_ENA_Msk = 0x40
	// Bit TIMER_ENA.
	DAC_CTRL_TIMER_ENA = 0x40
	// Disabled. The internal timer is disabled. If the TRIG_SEL field is also set to 000 then hardware triggering is disabled.
	DAC_CTRL_TIMER_ENA_DISABLED = 0x0
	// Enabled. The internal timer is enabled and counting. Note: This bit should only be set after a valid count value has been programmed into the DACCNTVAL register.
	DAC_CTRL_TIMER_ENA_ENABLED = 0x1
	// Position of DBLBUF_ENA field.
	DAC_CTRL_DBLBUF_ENA_Pos = 0x7
	// Bit mask of DBLBUF_ENA field.
	DAC_CTRL_DBLBUF_ENA_Msk = 0x80
	// Bit DBLBUF_ENA.
	DAC_CTRL_DBLBUF_ENA = 0x80
	// Disabled. Double-buffering of the DACVAL register is disabled. Software writes to the DACVAL address will directly modify the DAC data presented to the D/A converter. Hardware trigger events, if selected, will not affect the DACVAL contents.
	DAC_CTRL_DBLBUF_ENA_DISABLED = 0x0
	// Enabled. The double-buffering feature in the DACVAL register is enabled. Writes to the DACVAL register are written to a pre-buffer and then transferred to the DACVAL when the specified hardware trigger occurs. Setting this bit will have no effect if hardware triggering is disabled. Double-buffering is of no value under this condition.
	DAC_CTRL_DBLBUF_ENA_ENABLED = 0x1
	// Position of SHUTOFF_ENA field.
	DAC_CTRL_SHUTOFF_ENA_Pos = 0x8
	// Bit mask of SHUTOFF_ENA field.
	DAC_CTRL_SHUTOFF_ENA_Msk = 0x100
	// Bit SHUTOFF_ENA.
	DAC_CTRL_SHUTOFF_ENA = 0x100
	// Disabled. The hardware DAC-shutoff feature is disabled.
	DAC_CTRL_SHUTOFF_ENA_DISABLED = 0x0
	// Enabled. The hardware DAC-shutoff feature is enabled. Whenever the DAC_SHUTOFF (port pin) input is high, the DAC output voltage will be forced to zero. The DAC output will return to the value specifed in the DACVAL register once the input pin returns to the low state.
	DAC_CTRL_SHUTOFF_ENA_ENABLED = 0x1
	// Position of SHUTOFF_FLAG field.
	DAC_CTRL_SHUTOFF_FLAG_Pos = 0x9
	// Bit mask of SHUTOFF_FLAG field.
	DAC_CTRL_SHUTOFF_FLAG_Msk = 0x200
	// Bit SHUTOFF_FLAG.
	DAC_CTRL_SHUTOFF_FLAG = 0x200
	// Position of BIAS field.
	DAC_CTRL_BIAS_Pos = 0xa
	// Bit mask of BIAS field.
	DAC_CTRL_BIAS_Msk = 0x1c00
	// Position of RESERVED field.
	DAC_CTRL_RESERVED_Pos = 0xd
	// Bit mask of RESERVED field.
	DAC_CTRL_RESERVED_Msk = 0xffffe000

	// CNTVAL: DAC Counter Value register. This register contains the reload value for the internal DAC DMA/Interrupt timer.
	// Position of CNTVAL field.
	DAC_CNTVAL_CNTVAL_Pos = 0x0
	// Bit mask of CNTVAL field.
	DAC_CNTVAL_CNTVAL_Msk = 0xffff
	// Position of RESERVED field.
	DAC_CNTVAL_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	DAC_CNTVAL_RESERVED_Msk = 0xffff0000
)

// Bitfields for ACMP: Analog comparators ACMP0/1/2/3
const (
	// CTRL: Comparator block control register
	// Position of RESERVED field.
	ACMP_CTRL_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	ACMP_CTRL_RESERVED_Msk = 0xff
	// Position of ROSCCTL field.
	ACMP_CTRL_ROSCCTL_Pos = 0x8
	// Bit mask of ROSCCTL field.
	ACMP_CTRL_ROSCCTL_Msk = 0x100
	// Bit ROSCCTL.
	ACMP_CTRL_ROSCCTL = 0x100
	// ACMP1/ACMP0. The ROSC output is set by ACMP1 and reset by ACMP0.
	ACMP_CTRL_ROSCCTL_ACMP1_ACMP0 = 0x0
	// ACMP0/ACMP1. The ROSC output is set by ACMP0 and reset by ACMP1.
	ACMP_CTRL_ROSCCTL_ACMP0_ACMP1 = 0x1
	// Position of EXT_RESET field.
	ACMP_CTRL_EXT_RESET_Pos = 0x9
	// Bit mask of EXT_RESET field.
	ACMP_CTRL_EXT_RESET_Msk = 0x200
	// Bit EXT_RESET.
	ACMP_CTRL_EXT_RESET = 0x200
	// Internal. The ROSC output is reset by the internal chip reset.
	ACMP_CTRL_EXT_RESET_INTERNAL = 0x0
	// From pin ROSC_RESET. The ROSC output is reset by the ROSC_RESET input.
	ACMP_CTRL_EXT_RESET_FROM_PIN_ROSC_RESET = 0x1
	// Position of RESERVED field.
	ACMP_CTRL_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	ACMP_CTRL_RESERVED_Msk = 0xfffffc00

	// CMP0: Comparator 0 source control
	// Position of EN field.
	ACMP_CMP0_EN_Pos = 0x0
	// Bit mask of EN field.
	ACMP_CMP0_EN_Msk = 0x1
	// Bit EN.
	ACMP_CMP0_EN = 0x1
	// Disabled. Comparator disabled.
	ACMP_CMP0_EN_DISABLED = 0x0
	// Enabled. Comparator is enabled.
	ACMP_CMP0_EN_ENABLED = 0x1
	// Position of RESERVED field.
	ACMP_CMP0_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	ACMP_CMP0_RESERVED_Msk = 0x2
	// Bit RESERVED.
	ACMP_CMP0_RESERVED = 0x2
	// Position of INTEN field.
	ACMP_CMP0_INTEN_Pos = 0x2
	// Bit mask of INTEN field.
	ACMP_CMP0_INTEN_Msk = 0x4
	// Bit INTEN.
	ACMP_CMP0_INTEN = 0x4
	// Disabled. Interrupts are disabled..
	ACMP_CMP0_INTEN_DISABLED = 0x0
	// Enabled. Interrupts are enabled.. Must set to 1 for interrupts to propagate to the NVIC and start-up logic.
	ACMP_CMP0_INTEN_ENABLED = 0x1
	// Position of STAT field.
	ACMP_CMP0_STAT_Pos = 0x3
	// Bit mask of STAT field.
	ACMP_CMP0_STAT_Msk = 0x8
	// Bit STAT.
	ACMP_CMP0_STAT = 0x8
	// Position of VM field.
	ACMP_CMP0_VM_Pos = 0x4
	// Bit mask of VM field.
	ACMP_CMP0_VM_Msk = 0x70
	// Vref divider 0.
	ACMP_CMP0_VM_VREF_DIVIDER_0 = 0x0
	// ACMP_I1.
	ACMP_CMP0_VM_ACMP_I1 = 0x1
	// ACMP_I2.
	ACMP_CMP0_VM_ACMP_I2 = 0x2
	// ACMP0_I3.
	ACMP_CMP0_VM_ACMP0_I3 = 0x3
	// ACMP0_I4.
	ACMP_CMP0_VM_ACMP0_I4 = 0x4
	// Internal 0.9 V band gap reference.
	ACMP_CMP0_VM_INTERNAL_0 = 0x5
	// Temp sensor.
	ACMP_CMP0_VM_TEMP_SENSOR = 0x6
	// ADC0_2. Input for ADC0 channel 2.
	ACMP_CMP0_VM_ADC0_2 = 0x7
	// Position of RESERVED field.
	ACMP_CMP0_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	ACMP_CMP0_RESERVED_Msk = 0x80
	// Bit RESERVED.
	ACMP_CMP0_RESERVED = 0x80
	// Position of VP field.
	ACMP_CMP0_VP_Pos = 0x8
	// Bit mask of VP field.
	ACMP_CMP0_VP_Msk = 0x700
	// Vref divider 0.
	ACMP_CMP0_VP_VREF_DIVIDER_0 = 0x0
	// ACMP_I1.
	ACMP_CMP0_VP_ACMP_I1 = 0x1
	// ACMP_I2.
	ACMP_CMP0_VP_ACMP_I2 = 0x2
	// ACMP0_I3.
	ACMP_CMP0_VP_ACMP0_I3 = 0x3
	// ACMP0_I4.
	ACMP_CMP0_VP_ACMP0_I4 = 0x4
	// Internal 0.9 V band gap reference.
	ACMP_CMP0_VP_INTERNAL_0 = 0x5
	// Temp sensor.
	ACMP_CMP0_VP_TEMP_SENSOR = 0x6
	// ADC0_2. Input for ADC0 channel 2.
	ACMP_CMP0_VP_ADC0_2 = 0x7
	// Position of RESERVED field.
	ACMP_CMP0_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	ACMP_CMP0_RESERVED_Msk = 0x1800
	// Position of HYS field.
	ACMP_CMP0_HYS_Pos = 0xd
	// Bit mask of HYS field.
	ACMP_CMP0_HYS_Msk = 0x6000
	// Hysteresis is turned off, comparator output will change as the input voltages cross.
	ACMP_CMP0_HYS_HYSTERESIS_IS_TURNED = 0x0
	// Hysteresis = 5 mV.
	ACMP_CMP0_HYS_HYSTERESIS_EQ_5_MV = 0x1
	// Hysteresis = 10 mV.
	ACMP_CMP0_HYS_HYSTERESIS_EQ_10_MV = 0x2
	// Hysteresis = 15 mV.
	ACMP_CMP0_HYS_HYSTERESIS_EQ_15_MV = 0x3
	// Position of INTPOL field.
	ACMP_CMP0_INTPOL_Pos = 0xf
	// Bit mask of INTPOL field.
	ACMP_CMP0_INTPOL_Msk = 0x8000
	// Bit INTPOL.
	ACMP_CMP0_INTPOL = 0x8000
	// Not inverted. The output is used as-is for generating interrupts.
	ACMP_CMP0_INTPOL_NOT_INVERTED = 0x0
	// Inverted. The output is used inverted for generating interrupts.
	ACMP_CMP0_INTPOL_INVERTED = 0x1
	// Position of INTTYPE field.
	ACMP_CMP0_INTTYPE_Pos = 0x10
	// Bit mask of INTTYPE field.
	ACMP_CMP0_INTTYPE_Msk = 0x10000
	// Bit INTTYPE.
	ACMP_CMP0_INTTYPE = 0x10000
	// Edge. Comparator interrupt is edge triggered.
	ACMP_CMP0_INTTYPE_EDGE = 0x0
	// Level. Comparator interrupt is level triggered.
	ACMP_CMP0_INTTYPE_LEVEL = 0x1
	// Position of INTEDGE field.
	ACMP_CMP0_INTEDGE_Pos = 0x11
	// Bit mask of INTEDGE field.
	ACMP_CMP0_INTEDGE_Msk = 0x60000
	// Falling. Comparator interrupt is active on falling edges.
	ACMP_CMP0_INTEDGE_FALLING = 0x0
	// Rising. Comparator interrupt is active on rising edges.
	ACMP_CMP0_INTEDGE_RISING = 0x1
	// Both edges. Comparator Interrupt is active on both edges.
	ACMP_CMP0_INTEDGE_BOTH_EDGES = 0x2
	// Position of INTFLAG field.
	ACMP_CMP0_INTFLAG_Pos = 0x13
	// Bit mask of INTFLAG field.
	ACMP_CMP0_INTFLAG_Msk = 0x80000
	// Bit INTFLAG.
	ACMP_CMP0_INTFLAG = 0x80000
	// Not pending. The Comparator interrupt is not pending.
	ACMP_CMP0_INTFLAG_NOT_PENDING = 0x0
	// Pending. The Comparator interrupt is pending. Writing a 1 to this bit clears the flag.
	ACMP_CMP0_INTFLAG_PENDING = 0x1
	// Position of VLADEN field.
	ACMP_CMP0_VLADEN_Pos = 0x14
	// Bit mask of VLADEN field.
	ACMP_CMP0_VLADEN_Msk = 0x100000
	// Bit VLADEN.
	ACMP_CMP0_VLADEN = 0x100000
	// Disabled. The Comparator voltage ladder is disabled.
	ACMP_CMP0_VLADEN_DISABLED = 0x0
	// Enabled. The Comparator voltage ladder is enabled.
	ACMP_CMP0_VLADEN_ENABLED = 0x1
	// Position of RESERVED field.
	ACMP_CMP0_RESERVED_Pos = 0x15
	// Bit mask of RESERVED field.
	ACMP_CMP0_RESERVED_Msk = 0x200000
	// Bit RESERVED.
	ACMP_CMP0_RESERVED = 0x200000
	// Position of VLADREF field.
	ACMP_CMP0_VLADREF_Pos = 0x16
	// Bit mask of VLADREF field.
	ACMP_CMP0_VLADREF_Msk = 0x400000
	// Bit VLADREF.
	ACMP_CMP0_VLADREF = 0x400000
	// VREF_CMP pin.
	ACMP_CMP0_VLADREF_VREF_CMP_PIN = 0x0
	// VDDA pin.
	ACMP_CMP0_VLADREF_VDDA_PIN = 0x1
	// Position of RESERVED field.
	ACMP_CMP0_RESERVED_Pos = 0x17
	// Bit mask of RESERVED field.
	ACMP_CMP0_RESERVED_Msk = 0x800000
	// Bit RESERVED.
	ACMP_CMP0_RESERVED = 0x800000
	// Position of VSEL field.
	ACMP_CMP0_VSEL_Pos = 0x18
	// Bit mask of VSEL field.
	ACMP_CMP0_VSEL_Msk = 0x1f000000
	// Position of DLY field.
	ACMP_CMP0_DLY_Pos = 0x1d
	// Bit mask of DLY field.
	ACMP_CMP0_DLY_Msk = 0x60000000
	// Position of RESERVED field.
	ACMP_CMP0_RESERVED_Pos = 0x1f
	// Bit mask of RESERVED field.
	ACMP_CMP0_RESERVED_Msk = 0x80000000
	// Bit RESERVED.
	ACMP_CMP0_RESERVED = 0x80000000

	// CMPFILTR0: Comparator 0 pin filter set-up
	// Position of S_MODE field.
	ACMP_CMPFILTR_S_MODE_Pos = 0x0
	// Bit mask of S_MODE field.
	ACMP_CMPFILTR_S_MODE_Msk = 0x3
	// Bypass input filter.
	ACMP_CMPFILTR_S_MODE_BYPASS_INPUT_FILTER = 0x0
	// 1 clock cycle. Input pulses shorter than one filter clock are rejected.
	ACMP_CMPFILTR_S_MODE_1_CLOCK_CYCLE = 0x1
	// 2 clock cycles. Input pulses shorter than two filter clocks are rejected.
	ACMP_CMPFILTR_S_MODE_2_CLOCK_CYCLES = 0x2
	// 3 clock cycles. Input pulses shorter than three filter clocks are rejected.
	ACMP_CMPFILTR_S_MODE_3_CLOCK_CYCLES = 0x3
	// Position of CLKDIV field.
	ACMP_CMPFILTR_CLKDIV_Pos = 0x2
	// Bit mask of CLKDIV field.
	ACMP_CMPFILTR_CLKDIV_Msk = 0x1c
	// CMP_PCLK.
	ACMP_CMPFILTR_CLKDIV_CMP_PCLK = 0x0
	// CMP_PCLK/2.
	ACMP_CMPFILTR_CLKDIV_CMP_PCLKDIV2 = 0x1
	// CMP_PCLK/4.
	ACMP_CMPFILTR_CLKDIV_CMP_PCLKDIV4 = 0x2
	// CMP_PCLK/8.
	ACMP_CMPFILTR_CLKDIV_CMP_PCLKDIV8 = 0x3
	// CMP_PCLK/16.
	ACMP_CMPFILTR_CLKDIV_CMP_PCLKDIV16 = 0x4
	// CMP_PCLK/32.
	ACMP_CMPFILTR_CLKDIV_CMP_PCLKDIV32 = 0x5
	// CMP_PCLK/64.
	ACMP_CMPFILTR_CLKDIV_CMP_PCLKDIV64 = 0x6
	// Position of RESERVED field.
	ACMP_CMPFILTR_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	ACMP_CMPFILTR_RESERVED_Msk = 0xffffffe0

	// CMP1: Comparator 1 source control
	// Position of EN field.
	ACMP_CMP1_EN_Pos = 0x0
	// Bit mask of EN field.
	ACMP_CMP1_EN_Msk = 0x1
	// Bit EN.
	ACMP_CMP1_EN = 0x1
	// Disabled. Comparator disabled.
	ACMP_CMP1_EN_DISABLED = 0x0
	// Enabled. Comparator is enabled.
	ACMP_CMP1_EN_ENABLED = 0x1
	// Position of RESERVED field.
	ACMP_CMP1_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	ACMP_CMP1_RESERVED_Msk = 0x2
	// Bit RESERVED.
	ACMP_CMP1_RESERVED = 0x2
	// Position of INTEN field.
	ACMP_CMP1_INTEN_Pos = 0x2
	// Bit mask of INTEN field.
	ACMP_CMP1_INTEN_Msk = 0x4
	// Bit INTEN.
	ACMP_CMP1_INTEN = 0x4
	// Disabled. Interrupts are disabled..
	ACMP_CMP1_INTEN_DISABLED = 0x0
	// Enabled. Interrupts are enabled.. Must set to 1 for interrupts to propagate to the NVIC and start-up logic.
	ACMP_CMP1_INTEN_ENABLED = 0x1
	// Position of STAT field.
	ACMP_CMP1_STAT_Pos = 0x3
	// Bit mask of STAT field.
	ACMP_CMP1_STAT_Msk = 0x8
	// Bit STAT.
	ACMP_CMP1_STAT = 0x8
	// Position of VM field.
	ACMP_CMP1_VM_Pos = 0x4
	// Bit mask of VM field.
	ACMP_CMP1_VM_Msk = 0x70
	// Vref divider 1.
	ACMP_CMP1_VM_VREF_DIVIDER_1 = 0x0
	// ACMP_I1.
	ACMP_CMP1_VM_ACMP_I1 = 0x1
	// ACMP_I2.
	ACMP_CMP1_VM_ACMP_I2 = 0x2
	// ACMP1_I3.
	ACMP_CMP1_VM_ACMP1_I3 = 0x3
	// ACMP1_I4.
	ACMP_CMP1_VM_ACMP1_I4 = 0x4
	// Internal 0.9 V band gap reference.
	ACMP_CMP1_VM_INTERNAL_0 = 0x5
	// ADC0_1. Input for ADC0 channel 1.
	ACMP_CMP1_VM_ADC0_1 = 0x6
	// ADC0_3. Input for ADC0 channel 3.
	ACMP_CMP1_VM_ADC0_3 = 0x7
	// Position of RESERVED field.
	ACMP_CMP1_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	ACMP_CMP1_RESERVED_Msk = 0x80
	// Bit RESERVED.
	ACMP_CMP1_RESERVED = 0x80
	// Position of VP field.
	ACMP_CMP1_VP_Pos = 0x8
	// Bit mask of VP field.
	ACMP_CMP1_VP_Msk = 0x700
	// Vref divider 1.
	ACMP_CMP1_VP_VREF_DIVIDER_1 = 0x0
	// ACMP_I1.
	ACMP_CMP1_VP_ACMP_I1 = 0x1
	// ACMP_I2.
	ACMP_CMP1_VP_ACMP_I2 = 0x2
	// ACMP1_I3.
	ACMP_CMP1_VP_ACMP1_I3 = 0x3
	// ACMP1_I4.
	ACMP_CMP1_VP_ACMP1_I4 = 0x4
	// Internal 0.9 V band gap reference.
	ACMP_CMP1_VP_INTERNAL_0 = 0x5
	// ADC0_1. Input for ADC0 channel 1.
	ACMP_CMP1_VP_ADC0_1 = 0x6
	// ADC0_3. Input for ADC0 channel 3.
	ACMP_CMP1_VP_ADC0_3 = 0x7
	// Position of RESERVED field.
	ACMP_CMP1_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	ACMP_CMP1_RESERVED_Msk = 0x1800
	// Position of HYS field.
	ACMP_CMP1_HYS_Pos = 0xd
	// Bit mask of HYS field.
	ACMP_CMP1_HYS_Msk = 0x6000
	// Hysteresis is turned off, comparator output will change as the input voltages cross.
	ACMP_CMP1_HYS_HYSTERESIS_IS_TURNED = 0x0
	// Hysteresis = 5 mV.
	ACMP_CMP1_HYS_HYSTERESIS_EQ_5_MV = 0x1
	// Hysteresis = 10 mV.
	ACMP_CMP1_HYS_HYSTERESIS_EQ_10_MV = 0x2
	// Hysteresis = 15 mV.
	ACMP_CMP1_HYS_HYSTERESIS_EQ_15_MV = 0x3
	// Position of INTPOL field.
	ACMP_CMP1_INTPOL_Pos = 0xf
	// Bit mask of INTPOL field.
	ACMP_CMP1_INTPOL_Msk = 0x8000
	// Bit INTPOL.
	ACMP_CMP1_INTPOL = 0x8000
	// Not inverted. The output is used as-is for generating interrupts.
	ACMP_CMP1_INTPOL_NOT_INVERTED = 0x0
	// Inverted. The output is used inverted for generating interrupts.
	ACMP_CMP1_INTPOL_INVERTED = 0x1
	// Position of INTTYPE field.
	ACMP_CMP1_INTTYPE_Pos = 0x10
	// Bit mask of INTTYPE field.
	ACMP_CMP1_INTTYPE_Msk = 0x10000
	// Bit INTTYPE.
	ACMP_CMP1_INTTYPE = 0x10000
	// Edge. Comparator interrupt is edge triggered.
	ACMP_CMP1_INTTYPE_EDGE = 0x0
	// Level. Comparator interrupt is level triggered.
	ACMP_CMP1_INTTYPE_LEVEL = 0x1
	// Position of INTEDGE field.
	ACMP_CMP1_INTEDGE_Pos = 0x11
	// Bit mask of INTEDGE field.
	ACMP_CMP1_INTEDGE_Msk = 0x60000
	// Falling. Comparator interrupt is active on falling edges.
	ACMP_CMP1_INTEDGE_FALLING = 0x0
	// Rising. Comparator interrupt is active on rising edges.
	ACMP_CMP1_INTEDGE_RISING = 0x1
	// Both edges. Comparator Interrupt is active on both edges.
	ACMP_CMP1_INTEDGE_BOTH_EDGES = 0x2
	// Position of INTFLAG field.
	ACMP_CMP1_INTFLAG_Pos = 0x13
	// Bit mask of INTFLAG field.
	ACMP_CMP1_INTFLAG_Msk = 0x80000
	// Bit INTFLAG.
	ACMP_CMP1_INTFLAG = 0x80000
	// Not pending. The Comparator interrupt is not pending.
	ACMP_CMP1_INTFLAG_NOT_PENDING = 0x0
	// Pending. The Comparator interrupt is pending. Writing a 1 to this bit clears the flag.
	ACMP_CMP1_INTFLAG_PENDING = 0x1
	// Position of VLADEN field.
	ACMP_CMP1_VLADEN_Pos = 0x14
	// Bit mask of VLADEN field.
	ACMP_CMP1_VLADEN_Msk = 0x100000
	// Bit VLADEN.
	ACMP_CMP1_VLADEN = 0x100000
	// Disabled. The Comparator voltage ladder is disabled.
	ACMP_CMP1_VLADEN_DISABLED = 0x0
	// Enabled. The Comparator voltage ladder is enabled.
	ACMP_CMP1_VLADEN_ENABLED = 0x1
	// Position of RESERVED field.
	ACMP_CMP1_RESERVED_Pos = 0x15
	// Bit mask of RESERVED field.
	ACMP_CMP1_RESERVED_Msk = 0x200000
	// Bit RESERVED.
	ACMP_CMP1_RESERVED = 0x200000
	// Position of VLADREF field.
	ACMP_CMP1_VLADREF_Pos = 0x16
	// Bit mask of VLADREF field.
	ACMP_CMP1_VLADREF_Msk = 0x400000
	// Bit VLADREF.
	ACMP_CMP1_VLADREF = 0x400000
	// VREF_CMP pin.
	ACMP_CMP1_VLADREF_VREF_CMP_PIN = 0x0
	// VDDA pin.
	ACMP_CMP1_VLADREF_VDDA_PIN = 0x1
	// Position of RESERVED field.
	ACMP_CMP1_RESERVED_Pos = 0x17
	// Bit mask of RESERVED field.
	ACMP_CMP1_RESERVED_Msk = 0x800000
	// Bit RESERVED.
	ACMP_CMP1_RESERVED = 0x800000
	// Position of VSEL field.
	ACMP_CMP1_VSEL_Pos = 0x18
	// Bit mask of VSEL field.
	ACMP_CMP1_VSEL_Msk = 0x1f000000
	// Position of DLY field.
	ACMP_CMP1_DLY_Pos = 0x1d
	// Bit mask of DLY field.
	ACMP_CMP1_DLY_Msk = 0x60000000
	// Position of RESERVED field.
	ACMP_CMP1_RESERVED_Pos = 0x1f
	// Bit mask of RESERVED field.
	ACMP_CMP1_RESERVED_Msk = 0x80000000
	// Bit RESERVED.
	ACMP_CMP1_RESERVED = 0x80000000

	// CMP2: Comparator 2 source control
	// Position of EN field.
	ACMP_CMP2_EN_Pos = 0x0
	// Bit mask of EN field.
	ACMP_CMP2_EN_Msk = 0x1
	// Bit EN.
	ACMP_CMP2_EN = 0x1
	// Disabled. Comparator disabled.
	ACMP_CMP2_EN_DISABLED = 0x0
	// Enabled. Comparator is enabled.
	ACMP_CMP2_EN_ENABLED = 0x1
	// Position of RESERVED field.
	ACMP_CMP2_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	ACMP_CMP2_RESERVED_Msk = 0x2
	// Bit RESERVED.
	ACMP_CMP2_RESERVED = 0x2
	// Position of INTEN field.
	ACMP_CMP2_INTEN_Pos = 0x2
	// Bit mask of INTEN field.
	ACMP_CMP2_INTEN_Msk = 0x4
	// Bit INTEN.
	ACMP_CMP2_INTEN = 0x4
	// Disabled. Interrupts are disabled..
	ACMP_CMP2_INTEN_DISABLED = 0x0
	// Enabled. Interrupts are enabled.. Must set to 1 for interrupts to propagate to the NVIC and start-up logic.
	ACMP_CMP2_INTEN_ENABLED = 0x1
	// Position of STAT field.
	ACMP_CMP2_STAT_Pos = 0x3
	// Bit mask of STAT field.
	ACMP_CMP2_STAT_Msk = 0x8
	// Bit STAT.
	ACMP_CMP2_STAT = 0x8
	// Position of VM field.
	ACMP_CMP2_VM_Pos = 0x4
	// Bit mask of VM field.
	ACMP_CMP2_VM_Msk = 0x70
	// Vref divider 2.
	ACMP_CMP2_VM_VREF_DIVIDER_2 = 0x0
	// ACMP_I1.
	ACMP_CMP2_VM_ACMP_I1 = 0x1
	// ACMP_I2.
	ACMP_CMP2_VM_ACMP_I2 = 0x2
	// ACMP2_I3.
	ACMP_CMP2_VM_ACMP2_I3 = 0x3
	// ACMP2_I4.
	ACMP_CMP2_VM_ACMP2_I4 = 0x4
	// Internal 0.9 V band gap reference.
	ACMP_CMP2_VM_INTERNAL_0 = 0x5
	// ADC0_0. Input for ADC0 channel 0.
	ACMP_CMP2_VM_ADC0_0 = 0x6
	// ADC1_2. Input for ADC1 channel 2.
	ACMP_CMP2_VM_ADC1_2 = 0x7
	// Position of RESERVED field.
	ACMP_CMP2_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	ACMP_CMP2_RESERVED_Msk = 0x80
	// Bit RESERVED.
	ACMP_CMP2_RESERVED = 0x80
	// Position of VP field.
	ACMP_CMP2_VP_Pos = 0x8
	// Bit mask of VP field.
	ACMP_CMP2_VP_Msk = 0x700
	// Vref divider 2.
	ACMP_CMP2_VP_VREF_DIVIDER_2 = 0x0
	// ACMP_I1.
	ACMP_CMP2_VP_ACMP_I1 = 0x1
	// ACMP_I2.
	ACMP_CMP2_VP_ACMP_I2 = 0x2
	// ACMP2_I3.
	ACMP_CMP2_VP_ACMP2_I3 = 0x3
	// ACMP2_I4.
	ACMP_CMP2_VP_ACMP2_I4 = 0x4
	// Internal 0.9 V band gap reference.
	ACMP_CMP2_VP_INTERNAL_0 = 0x5
	// ADC0_0. Input for ADC0 channel 0.
	ACMP_CMP2_VP_ADC0_0 = 0x6
	// ADC1_2. Input for ADC1 channel 2.
	ACMP_CMP2_VP_ADC1_2 = 0x7
	// Position of RESERVED field.
	ACMP_CMP2_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	ACMP_CMP2_RESERVED_Msk = 0x1800
	// Position of HYS field.
	ACMP_CMP2_HYS_Pos = 0xd
	// Bit mask of HYS field.
	ACMP_CMP2_HYS_Msk = 0x6000
	// Hysteresis is turned off, comparator output will change as the input voltages cross.
	ACMP_CMP2_HYS_HYSTERESIS_IS_TURNED = 0x0
	// Hysteresis = 5 mV.
	ACMP_CMP2_HYS_HYSTERESIS_EQ_5_MV = 0x1
	// Hysteresis = 10 mV.
	ACMP_CMP2_HYS_HYSTERESIS_EQ_10_MV = 0x2
	// Hysteresis = 15 mV.
	ACMP_CMP2_HYS_HYSTERESIS_EQ_15_MV = 0x3
	// Position of INTPOL field.
	ACMP_CMP2_INTPOL_Pos = 0xf
	// Bit mask of INTPOL field.
	ACMP_CMP2_INTPOL_Msk = 0x8000
	// Bit INTPOL.
	ACMP_CMP2_INTPOL = 0x8000
	// Not inverted. The output is used as-is for generating interrupts.
	ACMP_CMP2_INTPOL_NOT_INVERTED = 0x0
	// Inverted. The output is used inverted for generating interrupts.
	ACMP_CMP2_INTPOL_INVERTED = 0x1
	// Position of INTTYPE field.
	ACMP_CMP2_INTTYPE_Pos = 0x10
	// Bit mask of INTTYPE field.
	ACMP_CMP2_INTTYPE_Msk = 0x10000
	// Bit INTTYPE.
	ACMP_CMP2_INTTYPE = 0x10000
	// Edge. Comparator interrupt is edge triggered.
	ACMP_CMP2_INTTYPE_EDGE = 0x0
	// Level. Comparator interrupt is level triggered.
	ACMP_CMP2_INTTYPE_LEVEL = 0x1
	// Position of INTEDGE field.
	ACMP_CMP2_INTEDGE_Pos = 0x11
	// Bit mask of INTEDGE field.
	ACMP_CMP2_INTEDGE_Msk = 0x60000
	// Falling. Comparator interrupt is active on falling edges.
	ACMP_CMP2_INTEDGE_FALLING = 0x0
	// Rising. Comparator interrupt is active on rising edges.
	ACMP_CMP2_INTEDGE_RISING = 0x1
	// Both edges. Comparator Interrupt is active on both edges.
	ACMP_CMP2_INTEDGE_BOTH_EDGES = 0x2
	// Position of INTFLAG field.
	ACMP_CMP2_INTFLAG_Pos = 0x13
	// Bit mask of INTFLAG field.
	ACMP_CMP2_INTFLAG_Msk = 0x80000
	// Bit INTFLAG.
	ACMP_CMP2_INTFLAG = 0x80000
	// Not pending. The Comparator interrupt is not pending.
	ACMP_CMP2_INTFLAG_NOT_PENDING = 0x0
	// Pending. The Comparator interrupt is pending. Writing a 1 to this bit clears the flag.
	ACMP_CMP2_INTFLAG_PENDING = 0x1
	// Position of VLADEN field.
	ACMP_CMP2_VLADEN_Pos = 0x14
	// Bit mask of VLADEN field.
	ACMP_CMP2_VLADEN_Msk = 0x100000
	// Bit VLADEN.
	ACMP_CMP2_VLADEN = 0x100000
	// Disabled. The Comparator voltage ladder is disabled.
	ACMP_CMP2_VLADEN_DISABLED = 0x0
	// Enabled. The Comparator voltage ladder is enabled.
	ACMP_CMP2_VLADEN_ENABLED = 0x1
	// Position of RESERVED field.
	ACMP_CMP2_RESERVED_Pos = 0x15
	// Bit mask of RESERVED field.
	ACMP_CMP2_RESERVED_Msk = 0x200000
	// Bit RESERVED.
	ACMP_CMP2_RESERVED = 0x200000
	// Position of VLADREF field.
	ACMP_CMP2_VLADREF_Pos = 0x16
	// Bit mask of VLADREF field.
	ACMP_CMP2_VLADREF_Msk = 0x400000
	// Bit VLADREF.
	ACMP_CMP2_VLADREF = 0x400000
	// VREF_CMP pin.
	ACMP_CMP2_VLADREF_VREF_CMP_PIN = 0x0
	// VDDA pin.
	ACMP_CMP2_VLADREF_VDDA_PIN = 0x1
	// Position of RESERVED field.
	ACMP_CMP2_RESERVED_Pos = 0x17
	// Bit mask of RESERVED field.
	ACMP_CMP2_RESERVED_Msk = 0x800000
	// Bit RESERVED.
	ACMP_CMP2_RESERVED = 0x800000
	// Position of VSEL field.
	ACMP_CMP2_VSEL_Pos = 0x18
	// Bit mask of VSEL field.
	ACMP_CMP2_VSEL_Msk = 0x1f000000
	// Position of DLY field.
	ACMP_CMP2_DLY_Pos = 0x1d
	// Bit mask of DLY field.
	ACMP_CMP2_DLY_Msk = 0x60000000
	// Position of RESERVED field.
	ACMP_CMP2_RESERVED_Pos = 0x1f
	// Bit mask of RESERVED field.
	ACMP_CMP2_RESERVED_Msk = 0x80000000
	// Bit RESERVED.
	ACMP_CMP2_RESERVED = 0x80000000

	// CMP3: Comparator 3 source control
	// Position of EN field.
	ACMP_CMP3_EN_Pos = 0x0
	// Bit mask of EN field.
	ACMP_CMP3_EN_Msk = 0x1
	// Bit EN.
	ACMP_CMP3_EN = 0x1
	// Disabled. Comparator disabled.
	ACMP_CMP3_EN_DISABLED = 0x0
	// Enabled. Comparator is enabled.
	ACMP_CMP3_EN_ENABLED = 0x1
	// Position of RESERVED field.
	ACMP_CMP3_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	ACMP_CMP3_RESERVED_Msk = 0x2
	// Bit RESERVED.
	ACMP_CMP3_RESERVED = 0x2
	// Position of INTEN field.
	ACMP_CMP3_INTEN_Pos = 0x2
	// Bit mask of INTEN field.
	ACMP_CMP3_INTEN_Msk = 0x4
	// Bit INTEN.
	ACMP_CMP3_INTEN = 0x4
	// Disabled. Interrupts are disabled..
	ACMP_CMP3_INTEN_DISABLED = 0x0
	// Enabled. Interrupts are enabled.. Must set to 1 for interrupts to propagate to the NVIC and start-up logic.
	ACMP_CMP3_INTEN_ENABLED = 0x1
	// Position of STAT field.
	ACMP_CMP3_STAT_Pos = 0x3
	// Bit mask of STAT field.
	ACMP_CMP3_STAT_Msk = 0x8
	// Bit STAT.
	ACMP_CMP3_STAT = 0x8
	// Position of VM field.
	ACMP_CMP3_VM_Pos = 0x4
	// Bit mask of VM field.
	ACMP_CMP3_VM_Msk = 0x70
	// Vref divider 3.
	ACMP_CMP3_VM_VREF_DIVIDER_3 = 0x0
	// ACMP_I1.
	ACMP_CMP3_VM_ACMP_I1 = 0x1
	// ACMP_I2.
	ACMP_CMP3_VM_ACMP_I2 = 0x2
	// ACMP3_I3.
	ACMP_CMP3_VM_ACMP3_I3 = 0x3
	// ACMP3_I4.
	ACMP_CMP3_VM_ACMP3_I4 = 0x4
	// Internal 0.9 V band gap reference.
	ACMP_CMP3_VM_INTERNAL_0 = 0x5
	// ADC1_1. Input for ADC1 channel 1.
	ACMP_CMP3_VM_ADC1_1 = 0x6
	// ADC1_3. Input for ADC1 channel 3.
	ACMP_CMP3_VM_ADC1_3 = 0x7
	// Position of RESERVED field.
	ACMP_CMP3_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	ACMP_CMP3_RESERVED_Msk = 0x80
	// Bit RESERVED.
	ACMP_CMP3_RESERVED = 0x80
	// Position of VP field.
	ACMP_CMP3_VP_Pos = 0x8
	// Bit mask of VP field.
	ACMP_CMP3_VP_Msk = 0x700
	// Vref divider 3.
	ACMP_CMP3_VP_VREF_DIVIDER_3 = 0x0
	// ACMP_I1.
	ACMP_CMP3_VP_ACMP_I1 = 0x1
	// ACMP_I2.
	ACMP_CMP3_VP_ACMP_I2 = 0x2
	// ACMP3_I3.
	ACMP_CMP3_VP_ACMP3_I3 = 0x3
	// ACMP3_I4.
	ACMP_CMP3_VP_ACMP3_I4 = 0x4
	// Internal 0.9 V band gap reference.
	ACMP_CMP3_VP_INTERNAL_0 = 0x5
	// ADC1_1. Input for ADC1 channel 1.
	ACMP_CMP3_VP_ADC1_1 = 0x6
	// ADC1_3. Input for ADC1 channel 3.
	ACMP_CMP3_VP_ADC1_3 = 0x7
	// Position of RESERVED field.
	ACMP_CMP3_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	ACMP_CMP3_RESERVED_Msk = 0x1800
	// Position of HYS field.
	ACMP_CMP3_HYS_Pos = 0xd
	// Bit mask of HYS field.
	ACMP_CMP3_HYS_Msk = 0x6000
	// Hysteresis is turned off, comparator output will change as the input voltages cross.
	ACMP_CMP3_HYS_HYSTERESIS_IS_TURNED = 0x0
	// Hysteresis = 5 mV.
	ACMP_CMP3_HYS_HYSTERESIS_EQ_5_MV = 0x1
	// Hysteresis = 10 mV.
	ACMP_CMP3_HYS_HYSTERESIS_EQ_10_MV = 0x2
	// Hysteresis = 15 mV.
	ACMP_CMP3_HYS_HYSTERESIS_EQ_15_MV = 0x3
	// Position of INTPOL field.
	ACMP_CMP3_INTPOL_Pos = 0xf
	// Bit mask of INTPOL field.
	ACMP_CMP3_INTPOL_Msk = 0x8000
	// Bit INTPOL.
	ACMP_CMP3_INTPOL = 0x8000
	// Not inverted. The output is used as-is for generating interrupts.
	ACMP_CMP3_INTPOL_NOT_INVERTED = 0x0
	// Inverted. The output is used inverted for generating interrupts.
	ACMP_CMP3_INTPOL_INVERTED = 0x1
	// Position of INTTYPE field.
	ACMP_CMP3_INTTYPE_Pos = 0x10
	// Bit mask of INTTYPE field.
	ACMP_CMP3_INTTYPE_Msk = 0x10000
	// Bit INTTYPE.
	ACMP_CMP3_INTTYPE = 0x10000
	// Edge. Comparator interrupt is edge triggered.
	ACMP_CMP3_INTTYPE_EDGE = 0x0
	// Level. Comparator interrupt is level triggered.
	ACMP_CMP3_INTTYPE_LEVEL = 0x1
	// Position of INTEDGE field.
	ACMP_CMP3_INTEDGE_Pos = 0x11
	// Bit mask of INTEDGE field.
	ACMP_CMP3_INTEDGE_Msk = 0x60000
	// Falling. Comparator interrupt is active on falling edges.
	ACMP_CMP3_INTEDGE_FALLING = 0x0
	// Rising. Comparator interrupt is active on rising edges.
	ACMP_CMP3_INTEDGE_RISING = 0x1
	// Both edges. Comparator Interrupt is active on both edges.
	ACMP_CMP3_INTEDGE_BOTH_EDGES = 0x2
	// Position of INTFLAG field.
	ACMP_CMP3_INTFLAG_Pos = 0x13
	// Bit mask of INTFLAG field.
	ACMP_CMP3_INTFLAG_Msk = 0x80000
	// Bit INTFLAG.
	ACMP_CMP3_INTFLAG = 0x80000
	// Not pending. The Comparator interrupt is not pending.
	ACMP_CMP3_INTFLAG_NOT_PENDING = 0x0
	// Pending. The Comparator interrupt is pending. Writing a 1 to this bit clears the flag.
	ACMP_CMP3_INTFLAG_PENDING = 0x1
	// Position of VLADEN field.
	ACMP_CMP3_VLADEN_Pos = 0x14
	// Bit mask of VLADEN field.
	ACMP_CMP3_VLADEN_Msk = 0x100000
	// Bit VLADEN.
	ACMP_CMP3_VLADEN = 0x100000
	// Disabled. The Comparator voltage ladder is disabled.
	ACMP_CMP3_VLADEN_DISABLED = 0x0
	// Enabled. The Comparator voltage ladder is enabled.
	ACMP_CMP3_VLADEN_ENABLED = 0x1
	// Position of RESERVED field.
	ACMP_CMP3_RESERVED_Pos = 0x15
	// Bit mask of RESERVED field.
	ACMP_CMP3_RESERVED_Msk = 0x200000
	// Bit RESERVED.
	ACMP_CMP3_RESERVED = 0x200000
	// Position of VLADREF field.
	ACMP_CMP3_VLADREF_Pos = 0x16
	// Bit mask of VLADREF field.
	ACMP_CMP3_VLADREF_Msk = 0x400000
	// Bit VLADREF.
	ACMP_CMP3_VLADREF = 0x400000
	// VREF_CMP pin.
	ACMP_CMP3_VLADREF_VREF_CMP_PIN = 0x0
	// VDDA pin.
	ACMP_CMP3_VLADREF_VDDA_PIN = 0x1
	// Position of RESERVED field.
	ACMP_CMP3_RESERVED_Pos = 0x17
	// Bit mask of RESERVED field.
	ACMP_CMP3_RESERVED_Msk = 0x800000
	// Bit RESERVED.
	ACMP_CMP3_RESERVED = 0x800000
	// Position of VSEL field.
	ACMP_CMP3_VSEL_Pos = 0x18
	// Bit mask of VSEL field.
	ACMP_CMP3_VSEL_Msk = 0x1f000000
	// Position of DLY field.
	ACMP_CMP3_DLY_Pos = 0x1d
	// Bit mask of DLY field.
	ACMP_CMP3_DLY_Msk = 0x60000000
	// Position of RESERVED field.
	ACMP_CMP3_RESERVED_Pos = 0x1f
	// Bit mask of RESERVED field.
	ACMP_CMP3_RESERVED_Msk = 0x80000000
	// Bit RESERVED.
	ACMP_CMP3_RESERVED = 0x80000000
)

// Bitfields for INMUX: Input multiplexing (INMUX)
const (
	// SCT0_INMUX: Pinmux register for SCT0 input 0
	// Position of INP_N field.
	INMUX_SCT0_INMUX_INP_N_Pos = 0x0
	// Bit mask of INP_N field.
	INMUX_SCT0_INMUX_INP_N_Msk = 0x1f
	// PIO0_2 (external pin)
	INMUX_SCT0_INMUX_INP_N_PIO0_2 = 0x0
	// PIO0_3 (external pin)
	INMUX_SCT0_INMUX_INP_N_PIO0_3 = 0x1
	// PIO0_17 (external pin)
	INMUX_SCT0_INMUX_INP_N_PIO0_17 = 0x2
	// PIO0_30 (external pin)
	INMUX_SCT0_INMUX_INP_N_PIO0_30 = 0x3
	// PIO1_6 (external pin)
	INMUX_SCT0_INMUX_INP_N_PIO1_6 = 0x4
	// PIO1_7 (external pin)
	INMUX_SCT0_INMUX_INP_N_PIO1_7 = 0x5
	// PIO1_12 (external pin)
	INMUX_SCT0_INMUX_INP_N_PIO1_12 = 0x6
	// PIO1_13 (external pin)
	INMUX_SCT0_INMUX_INP_N_PIO1_13 = 0x7
	// SCT1_OUT4 (large SCT1 output 4)
	INMUX_SCT0_INMUX_INP_N_SCT1_OUT4 = 0x8
	// SCT2_OUT4 (small SCT2 output 4)
	INMUX_SCT0_INMUX_INP_N_SCT2_OUT4 = 0x9
	// SCT2_OUT5 (small SCT2 output 5)
	INMUX_SCT0_INMUX_INP_N_SCT2_OUT5 = 0xa
	// ADC0_THCMP_IRQ (ADC0 threshold compare interrupt)
	INMUX_SCT0_INMUX_INP_N_ADC0_THCMP_IRQ = 0xb
	// ADC1_THCMP_IRQ (ADC1 threshold compare interrupt)
	INMUX_SCT0_INMUX_INP_N_ADC1_THCMP_IRQ = 0xc
	// ACMP0_OUT (One output from each analog comparator)
	INMUX_SCT0_INMUX_INP_N_ACMP0_OUT = 0xd
	// ACMP1_OUT (One output from each analog comparator)
	INMUX_SCT0_INMUX_INP_N_ACMP1_OUT = 0xe
	// ACMP2_OUT (One output from each analog comparator)
	INMUX_SCT0_INMUX_INP_N_ACMP2_OUT = 0xf
	// ACMP3_OUT (One output from each analog comparator)
	INMUX_SCT0_INMUX_INP_N_ACMP3_OUT = 0x10
	// SCTIPU_ABORT
	INMUX_SCT0_INMUX_INP_N_SCTIPU_ABORT = 0x11
	// SCTIPU_SAMPLE0
	INMUX_SCT0_INMUX_INP_N_SCTIPU_SAMPLE0 = 0x12
	// SCTIPU_SAMPLE1
	INMUX_SCT0_INMUX_INP_N_SCTIPU_SAMPLE1 = 0x13
	// SCTIPU_SAMPLE2
	INMUX_SCT0_INMUX_INP_N_SCTIPU_SAMPLE2 = 0x14
	// SCTIPU_SAMPLE3
	INMUX_SCT0_INMUX_INP_N_SCTIPU_SAMPLE3 = 0x15
	// ARM DEBUG HALTED
	INMUX_SCT0_INMUX_INP_N_DEBUG_HALTED = 0x16
	// Position of RESERVED field.
	INMUX_SCT0_INMUX_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	INMUX_SCT0_INMUX_RESERVED_Msk = 0xffffffe0

	// SCT1_INMUX: Pinmux register for SCT1 input 0
	// Position of INP_N field.
	INMUX_SCT1_INMUX_INP_N_Pos = 0x0
	// Bit mask of INP_N field.
	INMUX_SCT1_INMUX_INP_N_Msk = 0x1f
	// Position of RESERVED field.
	INMUX_SCT1_INMUX_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	INMUX_SCT1_INMUX_RESERVED_Msk = 0xffffffe0

	// SCT2_INMUX: Pinmux register for SCT2 input 0
	// Position of INP_N field.
	INMUX_SCT2_INMUX_INP_N_Pos = 0x0
	// Bit mask of INP_N field.
	INMUX_SCT2_INMUX_INP_N_Msk = 0x1f
	// Position of RESERVED field.
	INMUX_SCT2_INMUX_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	INMUX_SCT2_INMUX_RESERVED_Msk = 0xffffffe0

	// SCT3_INMUX: Pinmux register for SCT3 input 0
	// Position of INP_N field.
	INMUX_SCT3_INMUX_INP_N_Pos = 0x0
	// Bit mask of INP_N field.
	INMUX_SCT3_INMUX_INP_N_Msk = 0x1f
	// Position of RESERVED field.
	INMUX_SCT3_INMUX_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	INMUX_SCT3_INMUX_RESERVED_Msk = 0xffffffe0

	// PINTSEL: Pin interrupt select register 0
	// Position of INTPIN field.
	INMUX_PINTSEL_INTPIN_Pos = 0x0
	// Bit mask of INTPIN field.
	INMUX_PINTSEL_INTPIN_Msk = 0xff
	// Position of RESERVED field.
	INMUX_PINTSEL_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	INMUX_PINTSEL_RESERVED_Msk = 0xffffff80

	// DMA_ITRIG_INMUX: Trigger input for DMA channel 0 select register.
	// Position of INP_N field.
	INMUX_DMA_ITRIG_INMUX_INP_N_Pos = 0x0
	// Bit mask of INP_N field.
	INMUX_DMA_ITRIG_INMUX_INP_N_Msk = 0x1f
	// Position of RESERVED field.
	INMUX_DMA_ITRIG_INMUX_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	INMUX_DMA_ITRIG_INMUX_RESERVED_Msk = 0xffffffe0

	// DMA_INMUX_INMUX: DMA trigger input select register.
	// Position of INP field.
	INMUX_DMA_INMUX_INMUX_INP_Pos = 0x0
	// Bit mask of INP field.
	INMUX_DMA_INMUX_INMUX_INP_Msk = 0x1f
	// Position of RESERVED field.
	INMUX_DMA_INMUX_INMUX_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	INMUX_DMA_INMUX_INMUX_RESERVED_Msk = 0xffffffe0

	// FREQMEAS_REF: Clock selection for frequency measurement function reference clock
	// Position of CLKIN field.
	INMUX_FREQMEAS_REF_CLKIN_Pos = 0x0
	// Bit mask of CLKIN field.
	INMUX_FREQMEAS_REF_CLKIN_Msk = 0xf
	// Position of RESERVED field.
	INMUX_FREQMEAS_REF_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	INMUX_FREQMEAS_REF_RESERVED_Msk = 0xfffffff0

	// FREQMEAS_TARGET: Clock selection for frequency measurement function target clock
	// Position of CLKIN field.
	INMUX_FREQMEAS_TARGET_CLKIN_Pos = 0x0
	// Bit mask of CLKIN field.
	INMUX_FREQMEAS_TARGET_CLKIN_Msk = 0xf
	// Position of RESERVED field.
	INMUX_FREQMEAS_TARGET_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	INMUX_FREQMEAS_TARGET_RESERVED_Msk = 0xfffffff0
)

// Bitfields for RTC: Real-Time Clock (RTC)
const (
	// CTRL: RTC control register
	// Position of SWRESET field.
	RTC_CTRL_SWRESET_Pos = 0x0
	// Bit mask of SWRESET field.
	RTC_CTRL_SWRESET_Msk = 0x1
	// Bit SWRESET.
	RTC_CTRL_SWRESET = 0x1
	// Not in reset. The RTC is not held in reset. This bit must be cleared prior to configuring or initiating any operation of the RTC.
	RTC_CTRL_SWRESET_NOT_IN_RESET = 0x0
	// In reset. The RTC is held in reset. All register bits within the RTC will be forced to their reset value except the OFD bit. This bit must be cleared before writing to any register in the RTC - including writes to set any of the other bits within this register. Do not attempt to write to any bits of this register at the same time that the reset bit is being cleared. This bit may also serve as a Power Fail Detect flag for the always-on voltage domain.
	RTC_CTRL_SWRESET_IN_RESET = 0x1
	// Position of OFD field.
	RTC_CTRL_OFD_Pos = 0x1
	// Bit mask of OFD field.
	RTC_CTRL_OFD_Msk = 0x2
	// Bit OFD.
	RTC_CTRL_OFD = 0x2
	// Run. The RTC oscillator is running properly. Writing a 0 has no effect.
	RTC_CTRL_OFD_RUN = 0x0
	// Fail. RTC oscillator fail detected. Clear this flag after the following power-up. Writing a 1 clears this bit.
	RTC_CTRL_OFD_FAIL = 0x1
	// Position of ALARM1HZ field.
	RTC_CTRL_ALARM1HZ_Pos = 0x2
	// Bit mask of ALARM1HZ field.
	RTC_CTRL_ALARM1HZ_Msk = 0x4
	// Bit ALARM1HZ.
	RTC_CTRL_ALARM1HZ = 0x4
	// No match. No match has occurred on the 1 Hz RTC timer. Writing a 0 has no effect.
	RTC_CTRL_ALARM1HZ_NO_MATCH = 0x0
	// Match. A match condition has occurred on the 1 Hz RTC timer. This flag generates an RTC alarm interrupt request RTC_ALARM which can also wake up the part from any low power mode. Writing a 1 clears this bit.
	RTC_CTRL_ALARM1HZ_MATCH = 0x1
	// Position of WAKE1KHZ field.
	RTC_CTRL_WAKE1KHZ_Pos = 0x3
	// Bit mask of WAKE1KHZ field.
	RTC_CTRL_WAKE1KHZ_Msk = 0x8
	// Bit WAKE1KHZ.
	RTC_CTRL_WAKE1KHZ = 0x8
	// Run. The RTC 1 kHz timer is running. Writing a 0 has no effect.
	RTC_CTRL_WAKE1KHZ_RUN = 0x0
	// Time-out. The 1 kHz high-resolution/wake-up timer has timed out. This flag generates an RTC wake-up interrupt request RTC-WAKE which can also wake up the part from any low power mode. Writing a 1 clears this bit.
	RTC_CTRL_WAKE1KHZ_TIME_OUT = 0x1
	// Position of ALARMDPD_EN field.
	RTC_CTRL_ALARMDPD_EN_Pos = 0x4
	// Bit mask of ALARMDPD_EN field.
	RTC_CTRL_ALARMDPD_EN_Msk = 0x10
	// Bit ALARMDPD_EN.
	RTC_CTRL_ALARMDPD_EN = 0x10
	// Disable. A match on the 1 Hz RTC timer will not bring the part out of Deep power-down mode.
	RTC_CTRL_ALARMDPD_EN_DISABLE = 0x0
	// Enable. A match on the 1 Hz RTC timer bring the part out of Deep power-down mode.
	RTC_CTRL_ALARMDPD_EN_ENABLE = 0x1
	// Position of WAKEDPD_EN field.
	RTC_CTRL_WAKEDPD_EN_Pos = 0x5
	// Bit mask of WAKEDPD_EN field.
	RTC_CTRL_WAKEDPD_EN_Msk = 0x20
	// Bit WAKEDPD_EN.
	RTC_CTRL_WAKEDPD_EN = 0x20
	// Disable. A match on the 1 kHz RTC timer will not bring the part out of Deep power-down mode.
	RTC_CTRL_WAKEDPD_EN_DISABLE = 0x0
	// Enable. A match on the 1 kHz RTC timer bring the part out of Deep power-down mode.
	RTC_CTRL_WAKEDPD_EN_ENABLE = 0x1
	// Position of RTC1KHZ_EN field.
	RTC_CTRL_RTC1KHZ_EN_Pos = 0x6
	// Bit mask of RTC1KHZ_EN field.
	RTC_CTRL_RTC1KHZ_EN_Msk = 0x40
	// Bit RTC1KHZ_EN.
	RTC_CTRL_RTC1KHZ_EN = 0x40
	// Disable. A match on the 1 kHz RTC timer will not bring the part out of Deep power-down mode.
	RTC_CTRL_RTC1KHZ_EN_DISABLE = 0x0
	// Enable. The 1 kHz RTC timer is enabled.
	RTC_CTRL_RTC1KHZ_EN_ENABLE = 0x1
	// Position of RTC_EN field.
	RTC_CTRL_RTC_EN_Pos = 0x7
	// Bit mask of RTC_EN field.
	RTC_CTRL_RTC_EN_Msk = 0x80
	// Bit RTC_EN.
	RTC_CTRL_RTC_EN = 0x80
	// Disable. The RTC 1 Hz and 1 kHz clocks are shut down and the RTC operation is disabled. This bit should be 0 when writing to load a value in the RTC counter register.
	RTC_CTRL_RTC_EN_DISABLE = 0x0
	// Enable. The 1 Hz RTC clock is running and RTC operation is enabled. You must set this bit to initiate operation of the RTC. The first clock to the RTC counter occurs 1 s after this bit is set. To also enable the high-resolution, 1 kHz clock, set bit 6 in this register.
	RTC_CTRL_RTC_EN_ENABLE = 0x1
	// Position of RESERVED field.
	RTC_CTRL_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	RTC_CTRL_RESERVED_Msk = 0xffffff00

	// MATCH: RTC match register
	// Position of MATVAL field.
	RTC_MATCH_MATVAL_Pos = 0x0
	// Bit mask of MATVAL field.
	RTC_MATCH_MATVAL_Msk = 0xffffffff

	// COUNT: RTC counter register
	// Position of VAL field.
	RTC_COUNT_VAL_Pos = 0x0
	// Bit mask of VAL field.
	RTC_COUNT_VAL_Msk = 0xffffffff

	// WAKE: RTC high-resolution/wake-up timer control register
	// Position of VAL field.
	RTC_WAKE_VAL_Pos = 0x0
	// Bit mask of VAL field.
	RTC_WAKE_VAL_Msk = 0xffff
	// Position of RESERVED field.
	RTC_WAKE_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	RTC_WAKE_RESERVED_Msk = 0xffff0000
)

// Bitfields for WWDT: Windowed Watchdog Timer (WWDT)
const (
	// MOD: Watchdog mode register. This register contains the basic mode and status of the Watchdog Timer.
	// Position of WDEN field.
	WWDT_MOD_WDEN_Pos = 0x0
	// Bit mask of WDEN field.
	WWDT_MOD_WDEN_Msk = 0x1
	// Bit WDEN.
	WWDT_MOD_WDEN = 0x1
	// Stop. The watchdog timer is stopped.
	WWDT_MOD_WDEN_STOP = 0x0
	// Run. The watchdog timer is running.
	WWDT_MOD_WDEN_RUN = 0x1
	// Position of WDRESET field.
	WWDT_MOD_WDRESET_Pos = 0x1
	// Bit mask of WDRESET field.
	WWDT_MOD_WDRESET_Msk = 0x2
	// Bit WDRESET.
	WWDT_MOD_WDRESET = 0x2
	// Interrupt. A watchdog time-out will not cause a chip reset.
	WWDT_MOD_WDRESET_INTERRUPT = 0x0
	// Reset. A watchdog time-out will cause a chip reset.
	WWDT_MOD_WDRESET_RESET = 0x1
	// Position of WDTOF field.
	WWDT_MOD_WDTOF_Pos = 0x2
	// Bit mask of WDTOF field.
	WWDT_MOD_WDTOF_Msk = 0x4
	// Bit WDTOF.
	WWDT_MOD_WDTOF = 0x4
	// Position of WDINT field.
	WWDT_MOD_WDINT_Pos = 0x3
	// Bit mask of WDINT field.
	WWDT_MOD_WDINT_Msk = 0x8
	// Bit WDINT.
	WWDT_MOD_WDINT = 0x8
	// Position of WDPROTECT field.
	WWDT_MOD_WDPROTECT_Pos = 0x4
	// Bit mask of WDPROTECT field.
	WWDT_MOD_WDPROTECT_Msk = 0x10
	// Bit WDPROTECT.
	WWDT_MOD_WDPROTECT = 0x10
	// Flexible. The watchdog time-out value (TC) can be changed at any time.
	WWDT_MOD_WDPROTECT_FLEXIBLE = 0x0
	// Threshold. The watchdog time-out value (TC) can be changed only after the counter is below the value of WDWARNINT and WDWINDOW.
	WWDT_MOD_WDPROTECT_THRESHOLD = 0x1
	// Position of LOCK field.
	WWDT_MOD_LOCK_Pos = 0x5
	// Bit mask of LOCK field.
	WWDT_MOD_LOCK_Msk = 0x20
	// Bit LOCK.
	WWDT_MOD_LOCK = 0x20
	// Position of RESERVED field.
	WWDT_MOD_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	WWDT_MOD_RESERVED_Msk = 0xffffffc0

	// TC: Watchdog timer constant register. This 24-bit register determines the time-out value.
	// Position of COUNT field.
	WWDT_TC_COUNT_Pos = 0x0
	// Bit mask of COUNT field.
	WWDT_TC_COUNT_Msk = 0xffffff
	// Position of RESERVED field.
	WWDT_TC_RESERVED_Pos = 0x18
	// Bit mask of RESERVED field.
	WWDT_TC_RESERVED_Msk = 0xff000000

	// FEED: Watchdog feed sequence register. Writing 0xAA followed by 0x55 to this register reloads the Watchdog timer with the value contained in WDTC.
	// Position of FEED field.
	WWDT_FEED_FEED_Pos = 0x0
	// Bit mask of FEED field.
	WWDT_FEED_FEED_Msk = 0xff
	// Position of RESERVED field.
	WWDT_FEED_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	WWDT_FEED_RESERVED_Msk = 0xffffff00

	// TV: Watchdog timer value register. This 24-bit register reads out the current value of the Watchdog timer.
	// Position of COUNT field.
	WWDT_TV_COUNT_Pos = 0x0
	// Bit mask of COUNT field.
	WWDT_TV_COUNT_Msk = 0xffffff
	// Position of RESERVED field.
	WWDT_TV_RESERVED_Pos = 0x18
	// Bit mask of RESERVED field.
	WWDT_TV_RESERVED_Msk = 0xff000000

	// WARNINT: Watchdog Warning Interrupt compare value.
	// Position of WARNINT field.
	WWDT_WARNINT_WARNINT_Pos = 0x0
	// Bit mask of WARNINT field.
	WWDT_WARNINT_WARNINT_Msk = 0x3ff
	// Position of RESERVED field.
	WWDT_WARNINT_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	WWDT_WARNINT_RESERVED_Msk = 0xfffffc00

	// WINDOW: Watchdog Window compare value.
	// Position of WINDOW field.
	WWDT_WINDOW_WINDOW_Pos = 0x0
	// Bit mask of WINDOW field.
	WWDT_WINDOW_WINDOW_Msk = 0xffffff
	// Position of RESERVED field.
	WWDT_WINDOW_RESERVED_Pos = 0x18
	// Bit mask of RESERVED field.
	WWDT_WINDOW_RESERVED_Msk = 0xff000000
)

// Bitfields for SWM: Switch Matrix (SWM)
const (
	// PINASSIGN0: Pin assign register 0. Assign movable functions U0_TXD, U0_RXD, U0_RTS, U0_CTS.
	// Position of UART0_TXD_O field.
	SWM_PINASSIGN0_UART0_TXD_O_Pos = 0x0
	// Bit mask of UART0_TXD_O field.
	SWM_PINASSIGN0_UART0_TXD_O_Msk = 0xff
	// Position of UART0_RXD_I field.
	SWM_PINASSIGN0_UART0_RXD_I_Pos = 0x8
	// Bit mask of UART0_RXD_I field.
	SWM_PINASSIGN0_UART0_RXD_I_Msk = 0xff00
	// Position of UART0_RTS_O field.
	SWM_PINASSIGN0_UART0_RTS_O_Pos = 0x10
	// Bit mask of UART0_RTS_O field.
	SWM_PINASSIGN0_UART0_RTS_O_Msk = 0xff0000
	// Position of UART0_CTS_I field.
	SWM_PINASSIGN0_UART0_CTS_I_Pos = 0x18
	// Bit mask of UART0_CTS_I field.
	SWM_PINASSIGN0_UART0_CTS_I_Msk = 0xff000000

	// PINASSIGN1: Pin assign register 1. Assign movable functions U0_SCLK, U1_TXD, U1_RXD, U1_RTS.
	// Position of UART0_SCLK_IO field.
	SWM_PINASSIGN1_UART0_SCLK_IO_Pos = 0x0
	// Bit mask of UART0_SCLK_IO field.
	SWM_PINASSIGN1_UART0_SCLK_IO_Msk = 0xff
	// Position of UART1_TXD_O field.
	SWM_PINASSIGN1_UART1_TXD_O_Pos = 0x8
	// Bit mask of UART1_TXD_O field.
	SWM_PINASSIGN1_UART1_TXD_O_Msk = 0xff00
	// Position of UART1_RXD_I field.
	SWM_PINASSIGN1_UART1_RXD_I_Pos = 0x10
	// Bit mask of UART1_RXD_I field.
	SWM_PINASSIGN1_UART1_RXD_I_Msk = 0xff0000
	// Position of UART1_RTS_O field.
	SWM_PINASSIGN1_UART1_RTS_O_Pos = 0x18
	// Bit mask of UART1_RTS_O field.
	SWM_PINASSIGN1_UART1_RTS_O_Msk = 0xff000000

	// PINASSIGN2: Pin assign register 2. Assign movable functions U1_CTS, U1_SCLK, U2_TXD, U2_RXD.
	// Position of UART1_CTS_I field.
	SWM_PINASSIGN2_UART1_CTS_I_Pos = 0x0
	// Bit mask of UART1_CTS_I field.
	SWM_PINASSIGN2_UART1_CTS_I_Msk = 0xff
	// Position of UART1_SCLK_IO field.
	SWM_PINASSIGN2_UART1_SCLK_IO_Pos = 0x8
	// Bit mask of UART1_SCLK_IO field.
	SWM_PINASSIGN2_UART1_SCLK_IO_Msk = 0xff00
	// Position of UART2_TXD_O field.
	SWM_PINASSIGN2_UART2_TXD_O_Pos = 0x10
	// Bit mask of UART2_TXD_O field.
	SWM_PINASSIGN2_UART2_TXD_O_Msk = 0xff0000
	// Position of UART2_RXD_I field.
	SWM_PINASSIGN2_UART2_RXD_I_Pos = 0x18
	// Bit mask of UART2_RXD_I field.
	SWM_PINASSIGN2_UART2_RXD_I_Msk = 0xff000000

	// PINASSIGN3: Pin assign register 3. Assign movable function .
	// Position of UART2_SCLK_IO field.
	SWM_PINASSIGN3_UART2_SCLK_IO_Pos = 0x0
	// Bit mask of UART2_SCLK_IO field.
	SWM_PINASSIGN3_UART2_SCLK_IO_Msk = 0xff
	// Position of SSP0_SCK_IO field.
	SWM_PINASSIGN3_SSP0_SCK_IO_Pos = 0x8
	// Bit mask of SSP0_SCK_IO field.
	SWM_PINASSIGN3_SSP0_SCK_IO_Msk = 0xff00
	// Position of SSP0_MOSI_IO field.
	SWM_PINASSIGN3_SSP0_MOSI_IO_Pos = 0x10
	// Bit mask of SSP0_MOSI_IO field.
	SWM_PINASSIGN3_SSP0_MOSI_IO_Msk = 0xff0000
	// Position of SSP0_MISO_IO field.
	SWM_PINASSIGN3_SSP0_MISO_IO_Pos = 0x18
	// Bit mask of SSP0_MISO_IO field.
	SWM_PINASSIGN3_SSP0_MISO_IO_Msk = 0xff000000

	// PINASSIGN4: Pin assign register 4. Assign movable functions
	// Position of SSP0_SSELSN_0_IO field.
	SWM_PINASSIGN4_SSP0_SSELSN_0_IO_Pos = 0x0
	// Bit mask of SSP0_SSELSN_0_IO field.
	SWM_PINASSIGN4_SSP0_SSELSN_0_IO_Msk = 0xff
	// Position of SSP0_SSELSN_1_IO field.
	SWM_PINASSIGN4_SSP0_SSELSN_1_IO_Pos = 0x8
	// Bit mask of SSP0_SSELSN_1_IO field.
	SWM_PINASSIGN4_SSP0_SSELSN_1_IO_Msk = 0xff00
	// Position of SSP0_SSELSN_2_IO field.
	SWM_PINASSIGN4_SSP0_SSELSN_2_IO_Pos = 0x10
	// Bit mask of SSP0_SSELSN_2_IO field.
	SWM_PINASSIGN4_SSP0_SSELSN_2_IO_Msk = 0xff0000
	// Position of SSP0_SSELSN_3_IO field.
	SWM_PINASSIGN4_SSP0_SSELSN_3_IO_Pos = 0x18
	// Bit mask of SSP0_SSELSN_3_IO field.
	SWM_PINASSIGN4_SSP0_SSELSN_3_IO_Msk = 0xff000000

	// PINASSIGN5: Pin assign register 5. Assign movable functions
	// Position of SSP1_SCK_IO field.
	SWM_PINASSIGN5_SSP1_SCK_IO_Pos = 0x0
	// Bit mask of SSP1_SCK_IO field.
	SWM_PINASSIGN5_SSP1_SCK_IO_Msk = 0xff
	// Position of SSP1_MOSI_IO field.
	SWM_PINASSIGN5_SSP1_MOSI_IO_Pos = 0x8
	// Bit mask of SSP1_MOSI_IO field.
	SWM_PINASSIGN5_SSP1_MOSI_IO_Msk = 0xff00
	// Position of SSP1_MISO_IO field.
	SWM_PINASSIGN5_SSP1_MISO_IO_Pos = 0x10
	// Bit mask of SSP1_MISO_IO field.
	SWM_PINASSIGN5_SSP1_MISO_IO_Msk = 0xff0000
	// Position of SSP1_SSELSN_0_IO field.
	SWM_PINASSIGN5_SSP1_SSELSN_0_IO_Pos = 0x18
	// Bit mask of SSP1_SSELSN_0_IO field.
	SWM_PINASSIGN5_SSP1_SSELSN_0_IO_Msk = 0xff000000

	// PINASSIGN6: Pin assign register 6. Assign movable functions
	// Position of SSP1_SSELSN_1_IO field.
	SWM_PINASSIGN6_SSP1_SSELSN_1_IO_Pos = 0x0
	// Bit mask of SSP1_SSELSN_1_IO field.
	SWM_PINASSIGN6_SSP1_SSELSN_1_IO_Msk = 0xff
	// Position of CAN_TD1_O field.
	SWM_PINASSIGN6_CAN_TD1_O_Pos = 0x8
	// Bit mask of CAN_TD1_O field.
	SWM_PINASSIGN6_CAN_TD1_O_Msk = 0xff00
	// Position of CAN_RD1_I field.
	SWM_PINASSIGN6_CAN_RD1_I_Pos = 0x10
	// Bit mask of CAN_RD1_I field.
	SWM_PINASSIGN6_CAN_RD1_I_Msk = 0xff0000
	// Position of USB_CONNECTN_O field.
	SWM_PINASSIGN6_USB_CONNECTN_O_Pos = 0x18
	// Bit mask of USB_CONNECTN_O field.
	SWM_PINASSIGN6_USB_CONNECTN_O_Msk = 0xff000000

	// PINASSIGN7: Pin assign register 7. Assign movable functions
	// Position of USB_VBUS_I field.
	SWM_PINASSIGN7_USB_VBUS_I_Pos = 0x0
	// Bit mask of USB_VBUS_I field.
	SWM_PINASSIGN7_USB_VBUS_I_Msk = 0xff
	// Position of SCT0_OUT0_O field.
	SWM_PINASSIGN7_SCT0_OUT0_O_Pos = 0x8
	// Bit mask of SCT0_OUT0_O field.
	SWM_PINASSIGN7_SCT0_OUT0_O_Msk = 0xff00
	// Position of SCT0_OUT1_O field.
	SWM_PINASSIGN7_SCT0_OUT1_O_Pos = 0x10
	// Bit mask of SCT0_OUT1_O field.
	SWM_PINASSIGN7_SCT0_OUT1_O_Msk = 0xff0000
	// Position of SCT0_OUT2_O field.
	SWM_PINASSIGN7_SCT0_OUT2_O_Pos = 0x18
	// Bit mask of SCT0_OUT2_O field.
	SWM_PINASSIGN7_SCT0_OUT2_O_Msk = 0xff000000

	// PINASSIGN8: Pin assign register 8. Assign movable functions
	// Position of SCT1_OUT0_O field.
	SWM_PINASSIGN8_SCT1_OUT0_O_Pos = 0x0
	// Bit mask of SCT1_OUT0_O field.
	SWM_PINASSIGN8_SCT1_OUT0_O_Msk = 0xff
	// Position of SCT1_OUT1_O field.
	SWM_PINASSIGN8_SCT1_OUT1_O_Pos = 0x8
	// Bit mask of SCT1_OUT1_O field.
	SWM_PINASSIGN8_SCT1_OUT1_O_Msk = 0xff00
	// Position of SCT1_OUT2_O field.
	SWM_PINASSIGN8_SCT1_OUT2_O_Pos = 0x10
	// Bit mask of SCT1_OUT2_O field.
	SWM_PINASSIGN8_SCT1_OUT2_O_Msk = 0xff0000
	// Position of SCT2_OUT0_O field.
	SWM_PINASSIGN8_SCT2_OUT0_O_Pos = 0x18
	// Bit mask of SCT2_OUT0_O field.
	SWM_PINASSIGN8_SCT2_OUT0_O_Msk = 0xff000000

	// PINASSIGN9: Pin assign register 9. Assign movable functions
	// Position of SCT2_OUT1_O field.
	SWM_PINASSIGN9_SCT2_OUT1_O_Pos = 0x0
	// Bit mask of SCT2_OUT1_O field.
	SWM_PINASSIGN9_SCT2_OUT1_O_Msk = 0xff
	// Position of SCT2_OUT2_O field.
	SWM_PINASSIGN9_SCT2_OUT2_O_Pos = 0x8
	// Bit mask of SCT2_OUT2_O field.
	SWM_PINASSIGN9_SCT2_OUT2_O_Msk = 0xff00
	// Position of SCT3_OUT0_O field.
	SWM_PINASSIGN9_SCT3_OUT0_O_Pos = 0x10
	// Bit mask of SCT3_OUT0_O field.
	SWM_PINASSIGN9_SCT3_OUT0_O_Msk = 0xff0000
	// Position of SCT3_OUT1_O field.
	SWM_PINASSIGN9_SCT3_OUT1_O_Pos = 0x18
	// Bit mask of SCT3_OUT1_O field.
	SWM_PINASSIGN9_SCT3_OUT1_O_Msk = 0xff000000

	// PINASSIGN10: Pin assign register 10. Assign movable functions
	// Position of SCT3_OUT2_O field.
	SWM_PINASSIGN10_SCT3_OUT2_O_Pos = 0x0
	// Bit mask of SCT3_OUT2_O field.
	SWM_PINASSIGN10_SCT3_OUT2_O_Msk = 0xff
	// Position of SCT_ABORT0_I field.
	SWM_PINASSIGN10_SCT_ABORT0_I_Pos = 0x8
	// Bit mask of SCT_ABORT0_I field.
	SWM_PINASSIGN10_SCT_ABORT0_I_Msk = 0xff00
	// Position of SCT_ABORT1_I field.
	SWM_PINASSIGN10_SCT_ABORT1_I_Pos = 0x10
	// Bit mask of SCT_ABORT1_I field.
	SWM_PINASSIGN10_SCT_ABORT1_I_Msk = 0xff0000
	// Position of ADC0_PIN_TRIG0_I field.
	SWM_PINASSIGN10_ADC0_PIN_TRIG0_I_Pos = 0x18
	// Bit mask of ADC0_PIN_TRIG0_I field.
	SWM_PINASSIGN10_ADC0_PIN_TRIG0_I_Msk = 0xff000000

	// PINASSIGN11: Pin assign register 11. Assign movable functions
	// Position of ADC0_PIN_TRIG1_I field.
	SWM_PINASSIGN11_ADC0_PIN_TRIG1_I_Pos = 0x0
	// Bit mask of ADC0_PIN_TRIG1_I field.
	SWM_PINASSIGN11_ADC0_PIN_TRIG1_I_Msk = 0xff
	// Position of ADC1_PIN_TRIG0_I field.
	SWM_PINASSIGN11_ADC1_PIN_TRIG0_I_Pos = 0x8
	// Bit mask of ADC1_PIN_TRIG0_I field.
	SWM_PINASSIGN11_ADC1_PIN_TRIG0_I_Msk = 0xff00
	// Position of ADC1_PIN_TRIG1_I field.
	SWM_PINASSIGN11_ADC1_PIN_TRIG1_I_Pos = 0x10
	// Bit mask of ADC1_PIN_TRIG1_I field.
	SWM_PINASSIGN11_ADC1_PIN_TRIG1_I_Msk = 0xff0000
	// Position of DAC_PIN_TRIG_I field.
	SWM_PINASSIGN11_DAC_PIN_TRIG_I_Pos = 0x18
	// Bit mask of DAC_PIN_TRIG_I field.
	SWM_PINASSIGN11_DAC_PIN_TRIG_I_Msk = 0xff000000

	// PINASSIGN12: Pin assign register 12. Assign movable functions
	// Position of DAC_SHUTOFF_I field.
	SWM_PINASSIGN12_DAC_SHUTOFF_I_Pos = 0x0
	// Bit mask of DAC_SHUTOFF_I field.
	SWM_PINASSIGN12_DAC_SHUTOFF_I_Msk = 0xff
	// Position of ACMP0_OUT_O field.
	SWM_PINASSIGN12_ACMP0_OUT_O_Pos = 0x8
	// Bit mask of ACMP0_OUT_O field.
	SWM_PINASSIGN12_ACMP0_OUT_O_Msk = 0xff00
	// Position of ACMP1_OUT_O field.
	SWM_PINASSIGN12_ACMP1_OUT_O_Pos = 0x10
	// Bit mask of ACMP1_OUT_O field.
	SWM_PINASSIGN12_ACMP1_OUT_O_Msk = 0xff0000
	// Position of ACMP2_OUT_O field.
	SWM_PINASSIGN12_ACMP2_OUT_O_Pos = 0x18
	// Bit mask of ACMP2_OUT_O field.
	SWM_PINASSIGN12_ACMP2_OUT_O_Msk = 0xff000000

	// PINASSIGN13: Pin assign register 13. Assign movable functions
	// Position of ACMP3_OUT_O field.
	SWM_PINASSIGN13_ACMP3_OUT_O_Pos = 0x0
	// Bit mask of ACMP3_OUT_O field.
	SWM_PINASSIGN13_ACMP3_OUT_O_Msk = 0xff
	// Position of CLK_OUT_O field.
	SWM_PINASSIGN13_CLK_OUT_O_Pos = 0x8
	// Bit mask of CLK_OUT_O field.
	SWM_PINASSIGN13_CLK_OUT_O_Msk = 0xff00
	// Position of ROSC0_O field.
	SWM_PINASSIGN13_ROSC0_O_Pos = 0x10
	// Bit mask of ROSC0_O field.
	SWM_PINASSIGN13_ROSC0_O_Msk = 0xff0000
	// Position of ROSC_RST0_I field.
	SWM_PINASSIGN13_ROSC_RST0_I_Pos = 0x18
	// Bit mask of ROSC_RST0_I field.
	SWM_PINASSIGN13_ROSC_RST0_I_Msk = 0xff000000

	// PINASSIGN14: Pin assign register 14. Assign movable functions
	// Position of USB_FRAME_TOG_O field.
	SWM_PINASSIGN14_USB_FRAME_TOG_O_Pos = 0x0
	// Bit mask of USB_FRAME_TOG_O field.
	SWM_PINASSIGN14_USB_FRAME_TOG_O_Msk = 0xff
	// Position of QEI0_PHA_I field.
	SWM_PINASSIGN14_QEI0_PHA_I_Pos = 0x8
	// Bit mask of QEI0_PHA_I field.
	SWM_PINASSIGN14_QEI0_PHA_I_Msk = 0xff00
	// Position of QEI0_PHB_I field.
	SWM_PINASSIGN14_QEI0_PHB_I_Pos = 0x10
	// Bit mask of QEI0_PHB_I field.
	SWM_PINASSIGN14_QEI0_PHB_I_Msk = 0xff0000
	// Position of QEI0_IDX_I field.
	SWM_PINASSIGN14_QEI0_IDX_I_Pos = 0x18
	// Bit mask of QEI0_IDX_I field.
	SWM_PINASSIGN14_QEI0_IDX_I_Msk = 0xff000000

	// PINASSIGN15: Pin assign register 15. Assign movable functions
	// Position of GPIO_INT_BMATCH_O field.
	SWM_PINASSIGN15_GPIO_INT_BMATCH_O_Pos = 0x0
	// Bit mask of GPIO_INT_BMATCH_O field.
	SWM_PINASSIGN15_GPIO_INT_BMATCH_O_Msk = 0xff
	// Position of SWO_O field.
	SWM_PINASSIGN15_SWO_O_Pos = 0x8
	// Bit mask of SWO_O field.
	SWM_PINASSIGN15_SWO_O_Msk = 0xff00
	// Position of RESERVED field.
	SWM_PINASSIGN15_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	SWM_PINASSIGN15_RESERVED_Msk = 0xff0000
	// Position of RESERVED field.
	SWM_PINASSIGN15_RESERVED_Pos = 0x18
	// Bit mask of RESERVED field.
	SWM_PINASSIGN15_RESERVED_Msk = 0xff000000

	// PINENABLE0: Pin enable register 0. Enables fixed-pin functions
	// Position of ADC0_0 field.
	SWM_PINENABLE0_ADC0_0_Pos = 0x0
	// Bit mask of ADC0_0 field.
	SWM_PINENABLE0_ADC0_0_Msk = 0x1
	// Bit ADC0_0.
	SWM_PINENABLE0_ADC0_0 = 0x1
	// Enabled on pin P0_08.
	SWM_PINENABLE0_ADC0_0_ENABLED_ON_PIN_P0_08 = 0x0
	// Disabled.
	SWM_PINENABLE0_ADC0_0_DISABLED = 0x1
	// Position of ADC0_1 field.
	SWM_PINENABLE0_ADC0_1_Pos = 0x1
	// Bit mask of ADC0_1 field.
	SWM_PINENABLE0_ADC0_1_Msk = 0x2
	// Bit ADC0_1.
	SWM_PINENABLE0_ADC0_1 = 0x2
	// Enabled on pin P0_07.
	SWM_PINENABLE0_ADC0_1_ENABLED_ON_PIN_P0_07 = 0x0
	// Disabled.
	SWM_PINENABLE0_ADC0_1_DISABLED = 0x1
	// Position of ADC0_2 field.
	SWM_PINENABLE0_ADC0_2_Pos = 0x2
	// Bit mask of ADC0_2 field.
	SWM_PINENABLE0_ADC0_2_Msk = 0x4
	// Bit ADC0_2.
	SWM_PINENABLE0_ADC0_2 = 0x4
	// Enabled on pin P0_06.
	SWM_PINENABLE0_ADC0_2_ENABLED_ON_PIN_P0_06 = 0x0
	// Disabled.
	SWM_PINENABLE0_ADC0_2_DISABLED = 0x1
	// Position of ADC0_3 field.
	SWM_PINENABLE0_ADC0_3_Pos = 0x3
	// Bit mask of ADC0_3 field.
	SWM_PINENABLE0_ADC0_3_Msk = 0x8
	// Bit ADC0_3.
	SWM_PINENABLE0_ADC0_3 = 0x8
	// Enabled on pin P0_05.
	SWM_PINENABLE0_ADC0_3_ENABLED_ON_PIN_P0_05 = 0x0
	// Disabled.
	SWM_PINENABLE0_ADC0_3_DISABLED = 0x1
	// Position of ADC0_4 field.
	SWM_PINENABLE0_ADC0_4_Pos = 0x4
	// Bit mask of ADC0_4 field.
	SWM_PINENABLE0_ADC0_4_Msk = 0x10
	// Bit ADC0_4.
	SWM_PINENABLE0_ADC0_4 = 0x10
	// Enabled on pin P0_04.
	SWM_PINENABLE0_ADC0_4_ENABLED_ON_PIN_P0_04 = 0x0
	// Disabled.
	SWM_PINENABLE0_ADC0_4_DISABLED = 0x1
	// Position of ADC0_5 field.
	SWM_PINENABLE0_ADC0_5_Pos = 0x5
	// Bit mask of ADC0_5 field.
	SWM_PINENABLE0_ADC0_5_Msk = 0x20
	// Bit ADC0_5.
	SWM_PINENABLE0_ADC0_5 = 0x20
	// Enabled on pin P0_03.
	SWM_PINENABLE0_ADC0_5_ENABLED_ON_PIN_P0_03 = 0x0
	// Disabled.
	SWM_PINENABLE0_ADC0_5_DISABLED = 0x1
	// Position of ADC0_6 field.
	SWM_PINENABLE0_ADC0_6_Pos = 0x6
	// Bit mask of ADC0_6 field.
	SWM_PINENABLE0_ADC0_6_Msk = 0x40
	// Bit ADC0_6.
	SWM_PINENABLE0_ADC0_6 = 0x40
	// Enabled on pin P0_02.
	SWM_PINENABLE0_ADC0_6_ENABLED_ON_PIN_P0_02 = 0x0
	// Disabled.
	SWM_PINENABLE0_ADC0_6_DISABLED = 0x1
	// Position of ADC0_7 field.
	SWM_PINENABLE0_ADC0_7_Pos = 0x7
	// Bit mask of ADC0_7 field.
	SWM_PINENABLE0_ADC0_7_Msk = 0x80
	// Bit ADC0_7.
	SWM_PINENABLE0_ADC0_7 = 0x80
	// Enabled on pin P0_01.
	SWM_PINENABLE0_ADC0_7_ENABLED_ON_PIN_P0_01 = 0x0
	// Disabled.
	SWM_PINENABLE0_ADC0_7_DISABLED = 0x1
	// Position of ADC0_8 field.
	SWM_PINENABLE0_ADC0_8_Pos = 0x8
	// Bit mask of ADC0_8 field.
	SWM_PINENABLE0_ADC0_8_Msk = 0x100
	// Bit ADC0_8.
	SWM_PINENABLE0_ADC0_8 = 0x100
	// Enabled on pin P1_00 .
	SWM_PINENABLE0_ADC0_8_ENABLED_ON_PIN_P1_00 = 0x0
	// Disabled.
	SWM_PINENABLE0_ADC0_8_DISABLED = 0x1
	// Position of ADC0_9 field.
	SWM_PINENABLE0_ADC0_9_Pos = 0x9
	// Bit mask of ADC0_9 field.
	SWM_PINENABLE0_ADC0_9_Msk = 0x200
	// Bit ADC0_9.
	SWM_PINENABLE0_ADC0_9 = 0x200
	// Enabled on pin P0_31.
	SWM_PINENABLE0_ADC0_9_ENABLED_ON_PIN_P0_31 = 0x0
	// Disabled.
	SWM_PINENABLE0_ADC0_9_DISABLED = 0x1
	// Position of ADC0_10 field.
	SWM_PINENABLE0_ADC0_10_Pos = 0xa
	// Bit mask of ADC0_10 field.
	SWM_PINENABLE0_ADC0_10_Msk = 0x400
	// Bit ADC0_10.
	SWM_PINENABLE0_ADC0_10 = 0x400
	// Enabled on pin P0_00.
	SWM_PINENABLE0_ADC0_10_ENABLED_ON_PIN_P0_00 = 0x0
	// Disabled.
	SWM_PINENABLE0_ADC0_10_DISABLED = 0x1
	// Position of ADC0_11 field.
	SWM_PINENABLE0_ADC0_11_Pos = 0xb
	// Bit mask of ADC0_11 field.
	SWM_PINENABLE0_ADC0_11_Msk = 0x800
	// Bit ADC0_11.
	SWM_PINENABLE0_ADC0_11 = 0x800
	// Enabled on pin P0_30.
	SWM_PINENABLE0_ADC0_11_ENABLED_ON_PIN_P0_30 = 0x0
	// Disabled.
	SWM_PINENABLE0_ADC0_11_DISABLED = 0x1
	// Position of ADC1_0 field.
	SWM_PINENABLE0_ADC1_0_Pos = 0xc
	// Bit mask of ADC1_0 field.
	SWM_PINENABLE0_ADC1_0_Msk = 0x1000
	// Bit ADC1_0.
	SWM_PINENABLE0_ADC1_0 = 0x1000
	// Enabled on pin P1_01.
	SWM_PINENABLE0_ADC1_0_ENABLED_ON_PIN_P1_01 = 0x0
	// Disabled.
	SWM_PINENABLE0_ADC1_0_DISABLED = 0x1
	// Position of ADC1_1 field.
	SWM_PINENABLE0_ADC1_1_Pos = 0xd
	// Bit mask of ADC1_1 field.
	SWM_PINENABLE0_ADC1_1_Msk = 0x2000
	// Bit ADC1_1.
	SWM_PINENABLE0_ADC1_1 = 0x2000
	// Enabled on pin P0_09.
	SWM_PINENABLE0_ADC1_1_ENABLED_ON_PIN_P0_09 = 0x0
	// Disabled.
	SWM_PINENABLE0_ADC1_1_DISABLED = 0x1
	// Position of ADC1_2 field.
	SWM_PINENABLE0_ADC1_2_Pos = 0xe
	// Bit mask of ADC1_2 field.
	SWM_PINENABLE0_ADC1_2_Msk = 0x4000
	// Bit ADC1_2.
	SWM_PINENABLE0_ADC1_2 = 0x4000
	// Enabled on pin P0_10.
	SWM_PINENABLE0_ADC1_2_ENABLED_ON_PIN_P0_10 = 0x0
	// Disabled.
	SWM_PINENABLE0_ADC1_2_DISABLED = 0x1
	// Position of ADC1_3 field.
	SWM_PINENABLE0_ADC1_3_Pos = 0xf
	// Bit mask of ADC1_3 field.
	SWM_PINENABLE0_ADC1_3_Msk = 0x8000
	// Bit ADC1_3.
	SWM_PINENABLE0_ADC1_3 = 0x8000
	// Enabled on pin P0_11.
	SWM_PINENABLE0_ADC1_3_ENABLED_ON_PIN_P0_11 = 0x0
	// Disabled.
	SWM_PINENABLE0_ADC1_3_DISABLED = 0x1
	// Position of ADC1_4 field.
	SWM_PINENABLE0_ADC1_4_Pos = 0x10
	// Bit mask of ADC1_4 field.
	SWM_PINENABLE0_ADC1_4_Msk = 0x10000
	// Bit ADC1_4.
	SWM_PINENABLE0_ADC1_4 = 0x10000
	// Enabled on pin P1_02.
	SWM_PINENABLE0_ADC1_4_ENABLED_ON_PIN_P1_02 = 0x0
	// Disabled.
	SWM_PINENABLE0_ADC1_4_DISABLED = 0x1
	// Position of ADC1_5 field.
	SWM_PINENABLE0_ADC1_5_Pos = 0x11
	// Bit mask of ADC1_5 field.
	SWM_PINENABLE0_ADC1_5_Msk = 0x20000
	// Bit ADC1_5.
	SWM_PINENABLE0_ADC1_5 = 0x20000
	// Enabled on pin P1_03.
	SWM_PINENABLE0_ADC1_5_ENABLED_ON_PIN_P1_03 = 0x0
	// Disabled.
	SWM_PINENABLE0_ADC1_5_DISABLED = 0x1
	// Position of ADC1_6 field.
	SWM_PINENABLE0_ADC1_6_Pos = 0x12
	// Bit mask of ADC1_6 field.
	SWM_PINENABLE0_ADC1_6_Msk = 0x40000
	// Bit ADC1_6.
	SWM_PINENABLE0_ADC1_6 = 0x40000
	// Enabled on pin P0_13.
	SWM_PINENABLE0_ADC1_6_ENABLED_ON_PIN_P0_13 = 0x0
	// Disabled.
	SWM_PINENABLE0_ADC1_6_DISABLED = 0x1
	// Position of ADC1_7 field.
	SWM_PINENABLE0_ADC1_7_Pos = 0x13
	// Bit mask of ADC1_7 field.
	SWM_PINENABLE0_ADC1_7_Msk = 0x80000
	// Bit ADC1_7.
	SWM_PINENABLE0_ADC1_7 = 0x80000
	// Enabled on pin P0_14.
	SWM_PINENABLE0_ADC1_7_ENABLED_ON_PIN_P0_14 = 0x0
	// Disabled.
	SWM_PINENABLE0_ADC1_7_DISABLED = 0x1
	// Position of ADC1_8 field.
	SWM_PINENABLE0_ADC1_8_Pos = 0x14
	// Bit mask of ADC1_8 field.
	SWM_PINENABLE0_ADC1_8_Msk = 0x100000
	// Bit ADC1_8.
	SWM_PINENABLE0_ADC1_8 = 0x100000
	// Enabled on pin P0_15.
	SWM_PINENABLE0_ADC1_8_ENABLED_ON_PIN_P0_15 = 0x0
	// Disabled.
	SWM_PINENABLE0_ADC1_8_DISABLED = 0x1
	// Position of ADC1_9 field.
	SWM_PINENABLE0_ADC1_9_Pos = 0x15
	// Bit mask of ADC1_9 field.
	SWM_PINENABLE0_ADC1_9_Msk = 0x200000
	// Bit ADC1_9.
	SWM_PINENABLE0_ADC1_9 = 0x200000
	// Enabled on pin P0_16.
	SWM_PINENABLE0_ADC1_9_ENABLED_ON_PIN_P0_16 = 0x0
	// Disabled.
	SWM_PINENABLE0_ADC1_9_DISABLED = 0x1
	// Position of ADC1_10 field.
	SWM_PINENABLE0_ADC1_10_Pos = 0x16
	// Bit mask of ADC1_10 field.
	SWM_PINENABLE0_ADC1_10_Msk = 0x400000
	// Bit ADC1_10.
	SWM_PINENABLE0_ADC1_10 = 0x400000
	// Enabled on pin P1_04.
	SWM_PINENABLE0_ADC1_10_ENABLED_ON_PIN_P1_04 = 0x0
	// Disabled.
	SWM_PINENABLE0_ADC1_10_DISABLED = 0x1
	// Position of ADC1_11 field.
	SWM_PINENABLE0_ADC1_11_Pos = 0x17
	// Bit mask of ADC1_11 field.
	SWM_PINENABLE0_ADC1_11_Msk = 0x800000
	// Bit ADC1_11.
	SWM_PINENABLE0_ADC1_11 = 0x800000
	// Enabled on pin P1_05.
	SWM_PINENABLE0_ADC1_11_ENABLED_ON_PIN_P1_05 = 0x0
	// Disabled.
	SWM_PINENABLE0_ADC1_11_DISABLED = 0x1
	// Position of DAC_OUT field.
	SWM_PINENABLE0_DAC_OUT_Pos = 0x18
	// Bit mask of DAC_OUT field.
	SWM_PINENABLE0_DAC_OUT_Msk = 0x1000000
	// Bit DAC_OUT.
	SWM_PINENABLE0_DAC_OUT = 0x1000000
	// Enabled on pin P0_12.
	SWM_PINENABLE0_DAC_OUT_ENABLED_ON_PIN_P0_12 = 0x0
	// Disabled.
	SWM_PINENABLE0_DAC_OUT_DISABLED = 0x1
	// Position of ACMP_I1 field.
	SWM_PINENABLE0_ACMP_I1_Pos = 0x19
	// Bit mask of ACMP_I1 field.
	SWM_PINENABLE0_ACMP_I1_Msk = 0x2000000
	// Bit ACMP_I1.
	SWM_PINENABLE0_ACMP_I1 = 0x2000000
	// Enabled on pin P0_27.
	SWM_PINENABLE0_ACMP_I1_ENABLED_ON_PIN_P0_27 = 0x0
	// Disabled.
	SWM_PINENABLE0_ACMP_I1_DISABLED = 0x1
	// Position of ACMP_I2 field.
	SWM_PINENABLE0_ACMP_I2_Pos = 0x1a
	// Bit mask of ACMP_I2 field.
	SWM_PINENABLE0_ACMP_I2_Msk = 0x4000000
	// Bit ACMP_I2.
	SWM_PINENABLE0_ACMP_I2 = 0x4000000
	// Enabled on pin P1_06.
	SWM_PINENABLE0_ACMP_I2_ENABLED_ON_PIN_P1_06 = 0x0
	// Disabled.
	SWM_PINENABLE0_ACMP_I2_DISABLED = 0x1
	// Position of ACMP0_I3 field.
	SWM_PINENABLE0_ACMP0_I3_Pos = 0x1b
	// Bit mask of ACMP0_I3 field.
	SWM_PINENABLE0_ACMP0_I3_Msk = 0x8000000
	// Bit ACMP0_I3.
	SWM_PINENABLE0_ACMP0_I3 = 0x8000000
	// Enabled on pin P0_26.
	SWM_PINENABLE0_ACMP0_I3_ENABLED_ON_PIN_P0_26 = 0x0
	// Disabled.
	SWM_PINENABLE0_ACMP0_I3_DISABLED = 0x1
	// Position of ACMP0_I4 field.
	SWM_PINENABLE0_ACMP0_I4_Pos = 0x1c
	// Bit mask of ACMP0_I4 field.
	SWM_PINENABLE0_ACMP0_I4_Msk = 0x10000000
	// Bit ACMP0_I4.
	SWM_PINENABLE0_ACMP0_I4 = 0x10000000
	// Enabled on pin P0_25.
	SWM_PINENABLE0_ACMP0_I4_ENABLED_ON_PIN_P0_25 = 0x0
	// Disabled.
	SWM_PINENABLE0_ACMP0_I4_DISABLED = 0x1
	// Position of ACMP1_I3 field.
	SWM_PINENABLE0_ACMP1_I3_Pos = 0x1d
	// Bit mask of ACMP1_I3 field.
	SWM_PINENABLE0_ACMP1_I3_Msk = 0x20000000
	// Bit ACMP1_I3.
	SWM_PINENABLE0_ACMP1_I3 = 0x20000000
	// Enabled on pin P0_28.
	SWM_PINENABLE0_ACMP1_I3_ENABLED_ON_PIN_P0_28 = 0x0
	// Disabled.
	SWM_PINENABLE0_ACMP1_I3_DISABLED = 0x1
	// Position of ACMP1_I4 field.
	SWM_PINENABLE0_ACMP1_I4_Pos = 0x1e
	// Bit mask of ACMP1_I4 field.
	SWM_PINENABLE0_ACMP1_I4_Msk = 0x40000000
	// Bit ACMP1_I4.
	SWM_PINENABLE0_ACMP1_I4 = 0x40000000
	// Enabled on pin P1_10.
	SWM_PINENABLE0_ACMP1_I4_ENABLED_ON_PIN_P1_10 = 0x0
	// Disabled.
	SWM_PINENABLE0_ACMP1_I4_DISABLED = 0x1
	// Position of ACMP2_I3 field.
	SWM_PINENABLE0_ACMP2_I3_Pos = 0x1f
	// Bit mask of ACMP2_I3 field.
	SWM_PINENABLE0_ACMP2_I3_Msk = 0x80000000
	// Bit ACMP2_I3.
	SWM_PINENABLE0_ACMP2_I3 = 0x80000000
	// Enabled on pin P0_29.
	SWM_PINENABLE0_ACMP2_I3_ENABLED_ON_PIN_P0_29 = 0x0
	// Disabled.
	SWM_PINENABLE0_ACMP2_I3_DISABLED = 0x1

	// PINENABLE1: Pin enable register 0. Enables fixed-pin functions
	// Position of ACMP2_I4 field.
	SWM_PINENABLE1_ACMP2_I4_Pos = 0x0
	// Bit mask of ACMP2_I4 field.
	SWM_PINENABLE1_ACMP2_I4_Msk = 0x1
	// Bit ACMP2_I4.
	SWM_PINENABLE1_ACMP2_I4 = 0x1
	// Enabled on pin P1_09.
	SWM_PINENABLE1_ACMP2_I4_ENABLED_ON_PIN_P1_09 = 0x0
	// Disabled.
	SWM_PINENABLE1_ACMP2_I4_DISABLED = 0x1
	// Position of ACMP3_I3 field.
	SWM_PINENABLE1_ACMP3_I3_Pos = 0x1
	// Bit mask of ACMP3_I3 field.
	SWM_PINENABLE1_ACMP3_I3_Msk = 0x2
	// Bit ACMP3_I3.
	SWM_PINENABLE1_ACMP3_I3 = 0x2
	// Enabled on pin P1_08.
	SWM_PINENABLE1_ACMP3_I3_ENABLED_ON_PIN_P1_08 = 0x0
	// Disabled.
	SWM_PINENABLE1_ACMP3_I3_DISABLED = 0x1
	// Position of ACMP3_I4 field.
	SWM_PINENABLE1_ACMP3_I4_Pos = 0x2
	// Bit mask of ACMP3_I4 field.
	SWM_PINENABLE1_ACMP3_I4_Msk = 0x4
	// Bit ACMP3_I4.
	SWM_PINENABLE1_ACMP3_I4 = 0x4
	// Enabled on pin P1_07.
	SWM_PINENABLE1_ACMP3_I4_ENABLED_ON_PIN_P1_07 = 0x0
	// Disabled.
	SWM_PINENABLE1_ACMP3_I4_DISABLED = 0x1
	// Position of I2C0_SDA field.
	SWM_PINENABLE1_I2C0_SDA_Pos = 0x3
	// Bit mask of I2C0_SDA field.
	SWM_PINENABLE1_I2C0_SDA_Msk = 0x8
	// Bit I2C0_SDA.
	SWM_PINENABLE1_I2C0_SDA = 0x8
	// Enabled on pin P0_23.
	SWM_PINENABLE1_I2C0_SDA_ENABLED_ON_PIN_P0_23 = 0x0
	// Disabled.
	SWM_PINENABLE1_I2C0_SDA_DISABLED = 0x1
	// Position of I2C0_SCL field.
	SWM_PINENABLE1_I2C0_SCL_Pos = 0x4
	// Bit mask of I2C0_SCL field.
	SWM_PINENABLE1_I2C0_SCL_Msk = 0x10
	// Bit I2C0_SCL.
	SWM_PINENABLE1_I2C0_SCL = 0x10
	// Enabled on pin P0_22.
	SWM_PINENABLE1_I2C0_SCL_ENABLED_ON_PIN_P0_22 = 0x0
	// Disabled.
	SWM_PINENABLE1_I2C0_SCL_DISABLED = 0x1
	// Position of SCT0_OUT3 field.
	SWM_PINENABLE1_SCT0_OUT3_Pos = 0x5
	// Bit mask of SCT0_OUT3 field.
	SWM_PINENABLE1_SCT0_OUT3_Msk = 0x20
	// Bit SCT0_OUT3.
	SWM_PINENABLE1_SCT0_OUT3 = 0x20
	// Enabled on pin P0_00.
	SWM_PINENABLE1_SCT0_OUT3_ENABLED_ON_PIN_P0_00 = 0x0
	// Disabled.
	SWM_PINENABLE1_SCT0_OUT3_DISABLED = 0x1
	// Position of SCT0_OUT4 field.
	SWM_PINENABLE1_SCT0_OUT4_Pos = 0x6
	// Bit mask of SCT0_OUT4 field.
	SWM_PINENABLE1_SCT0_OUT4_Msk = 0x40
	// Bit SCT0_OUT4.
	SWM_PINENABLE1_SCT0_OUT4 = 0x40
	// Enabled on pin P0_01.
	SWM_PINENABLE1_SCT0_OUT4_ENABLED_ON_PIN_P0_01 = 0x0
	// Disabled.
	SWM_PINENABLE1_SCT0_OUT4_DISABLED = 0x1
	// Position of SCT0_OUT5 field.
	SWM_PINENABLE1_SCT0_OUT5_Pos = 0x7
	// Bit mask of SCT0_OUT5 field.
	SWM_PINENABLE1_SCT0_OUT5_Msk = 0x80
	// Bit SCT0_OUT5.
	SWM_PINENABLE1_SCT0_OUT5 = 0x80
	// Enabled on pin P0_18.
	SWM_PINENABLE1_SCT0_OUT5_ENABLED_ON_PIN_P0_18 = 0x0
	// Disabled.
	SWM_PINENABLE1_SCT0_OUT5_DISABLED = 0x1
	// Position of SCT0_OUT6 field.
	SWM_PINENABLE1_SCT0_OUT6_Pos = 0x8
	// Bit mask of SCT0_OUT6 field.
	SWM_PINENABLE1_SCT0_OUT6_Msk = 0x100
	// Bit SCT0_OUT6.
	SWM_PINENABLE1_SCT0_OUT6 = 0x100
	// Enabled on pin P0_24.
	SWM_PINENABLE1_SCT0_OUT6_ENABLED_ON_PIN_P0_24 = 0x0
	// Disabled.
	SWM_PINENABLE1_SCT0_OUT6_DISABLED = 0x1
	// Position of SCT0_OUT7 field.
	SWM_PINENABLE1_SCT0_OUT7_Pos = 0x9
	// Bit mask of SCT0_OUT7 field.
	SWM_PINENABLE1_SCT0_OUT7_Msk = 0x200
	// Bit SCT0_OUT7.
	SWM_PINENABLE1_SCT0_OUT7 = 0x200
	// Enabled on pin P1_14.
	SWM_PINENABLE1_SCT0_OUT7_ENABLED_ON_PIN_P1_14 = 0x0
	// Disabled.
	SWM_PINENABLE1_SCT0_OUT7_DISABLED = 0x1
	// Position of SCT1_OUT3 field.
	SWM_PINENABLE1_SCT1_OUT3_Pos = 0xa
	// Bit mask of SCT1_OUT3 field.
	SWM_PINENABLE1_SCT1_OUT3_Msk = 0x400
	// Bit SCT1_OUT3.
	SWM_PINENABLE1_SCT1_OUT3 = 0x400
	// Enabled on pin P0_02.
	SWM_PINENABLE1_SCT1_OUT3_ENABLED_ON_PIN_P0_02 = 0x0
	// Disabled.
	SWM_PINENABLE1_SCT1_OUT3_DISABLED = 0x1
	// Position of SCT1_OUT4 field.
	SWM_PINENABLE1_SCT1_OUT4_Pos = 0xb
	// Bit mask of SCT1_OUT4 field.
	SWM_PINENABLE1_SCT1_OUT4_Msk = 0x800
	// Bit SCT1_OUT4.
	SWM_PINENABLE1_SCT1_OUT4 = 0x800
	// Enabled on pin P0_03.
	SWM_PINENABLE1_SCT1_OUT4_ENABLED_ON_PIN_P0_03 = 0x0
	// Disabled.
	SWM_PINENABLE1_SCT1_OUT4_DISABLED = 0x1
	// Position of SCT1_OUT5 field.
	SWM_PINENABLE1_SCT1_OUT5_Pos = 0xc
	// Bit mask of SCT1_OUT5 field.
	SWM_PINENABLE1_SCT1_OUT5_Msk = 0x1000
	// Bit SCT1_OUT5.
	SWM_PINENABLE1_SCT1_OUT5 = 0x1000
	// Enabled on pin P0_14.
	SWM_PINENABLE1_SCT1_OUT5_ENABLED_ON_PIN_P0_14 = 0x0
	// Disabled.
	SWM_PINENABLE1_SCT1_OUT5_DISABLED = 0x1
	// Position of SCT1_OUT6 field.
	SWM_PINENABLE1_SCT1_OUT6_Pos = 0xd
	// Bit mask of SCT1_OUT6 field.
	SWM_PINENABLE1_SCT1_OUT6_Msk = 0x2000
	// Bit SCT1_OUT6.
	SWM_PINENABLE1_SCT1_OUT6 = 0x2000
	// Enabled on pin P0_20.
	SWM_PINENABLE1_SCT1_OUT6_ENABLED_ON_PIN_P0_20 = 0x0
	// Disabled.
	SWM_PINENABLE1_SCT1_OUT6_DISABLED = 0x1
	// Position of SCT1_OUT7 field.
	SWM_PINENABLE1_SCT1_OUT7_Pos = 0xe
	// Bit mask of SCT1_OUT7 field.
	SWM_PINENABLE1_SCT1_OUT7_Msk = 0x4000
	// Bit SCT1_OUT7.
	SWM_PINENABLE1_SCT1_OUT7 = 0x4000
	// Enabled on pin P1_17.
	SWM_PINENABLE1_SCT1_OUT7_ENABLED_ON_PIN_P1_17 = 0x0
	// Disabled.
	SWM_PINENABLE1_SCT1_OUT7_DISABLED = 0x1
	// Position of SCT2_OUT3 field.
	SWM_PINENABLE1_SCT2_OUT3_Pos = 0xf
	// Bit mask of SCT2_OUT3 field.
	SWM_PINENABLE1_SCT2_OUT3_Msk = 0x8000
	// Bit SCT2_OUT3.
	SWM_PINENABLE1_SCT2_OUT3 = 0x8000
	// Enabled on pin P0_06.
	SWM_PINENABLE1_SCT2_OUT3_ENABLED_ON_PIN_P0_06 = 0x0
	// Disabled.
	SWM_PINENABLE1_SCT2_OUT3_DISABLED = 0x1
	// Position of SCT2_OUT4 field.
	SWM_PINENABLE1_SCT2_OUT4_Pos = 0x10
	// Bit mask of SCT2_OUT4 field.
	SWM_PINENABLE1_SCT2_OUT4_Msk = 0x10000
	// Bit SCT2_OUT4.
	SWM_PINENABLE1_SCT2_OUT4 = 0x10000
	// Enabled on pin P0_29.
	SWM_PINENABLE1_SCT2_OUT4_ENABLED_ON_PIN_P0_29 = 0x0
	// Disabled.
	SWM_PINENABLE1_SCT2_OUT4_DISABLED = 0x1
	// Position of SCT2_OUT5 field.
	SWM_PINENABLE1_SCT2_OUT5_Pos = 0x11
	// Bit mask of SCT2_OUT5 field.
	SWM_PINENABLE1_SCT2_OUT5_Msk = 0x20000
	// Bit SCT2_OUT5.
	SWM_PINENABLE1_SCT2_OUT5 = 0x20000
	// Enabled on pin P1_20.
	SWM_PINENABLE1_SCT2_OUT5_ENABLED_ON_PIN_P1_20 = 0x0
	// Disabled.
	SWM_PINENABLE1_SCT2_OUT5_DISABLED = 0x1
	// Position of SCT3_OUT3 field.
	SWM_PINENABLE1_SCT3_OUT3_Pos = 0x12
	// Bit mask of SCT3_OUT3 field.
	SWM_PINENABLE1_SCT3_OUT3_Msk = 0x40000
	// Bit SCT3_OUT3.
	SWM_PINENABLE1_SCT3_OUT3 = 0x40000
	// Enabled on pin P0_26.
	SWM_PINENABLE1_SCT3_OUT3_ENABLED_ON_PIN_P0_26 = 0x0
	// Disabled.
	SWM_PINENABLE1_SCT3_OUT3_DISABLED = 0x1
	// Position of SCT3_OUT4 field.
	SWM_PINENABLE1_SCT3_OUT4_Pos = 0x13
	// Bit mask of SCT3_OUT4 field.
	SWM_PINENABLE1_SCT3_OUT4_Msk = 0x80000
	// Bit SCT3_OUT4.
	SWM_PINENABLE1_SCT3_OUT4 = 0x80000
	// Enabled on pin P1_08.
	SWM_PINENABLE1_SCT3_OUT4_ENABLED_ON_PIN_P1_08 = 0x0
	// Disabled.
	SWM_PINENABLE1_SCT3_OUT4_DISABLED = 0x1
	// Position of SCT3_OUT5 field.
	SWM_PINENABLE1_SCT3_OUT5_Pos = 0x14
	// Bit mask of SCT3_OUT5 field.
	SWM_PINENABLE1_SCT3_OUT5_Msk = 0x100000
	// Bit SCT3_OUT5.
	SWM_PINENABLE1_SCT3_OUT5 = 0x100000
	// Enabled on pin P1_24.
	SWM_PINENABLE1_SCT3_OUT5_ENABLED_ON_PIN_P1_24 = 0x0
	// Disabled.
	SWM_PINENABLE1_SCT3_OUT5_DISABLED = 0x1
	// Position of RESETN field.
	SWM_PINENABLE1_RESETN_Pos = 0x15
	// Bit mask of RESETN field.
	SWM_PINENABLE1_RESETN_Msk = 0x200000
	// Bit RESETN.
	SWM_PINENABLE1_RESETN = 0x200000
	// Enabled on pin P0_21.
	SWM_PINENABLE1_RESETN_ENABLED_ON_PIN_P0_21 = 0x0
	// Disabled.
	SWM_PINENABLE1_RESETN_DISABLED = 0x1
	// Position of SWCLK_TCK field.
	SWM_PINENABLE1_SWCLK_TCK_Pos = 0x16
	// Bit mask of SWCLK_TCK field.
	SWM_PINENABLE1_SWCLK_TCK_Msk = 0x400000
	// Bit SWCLK_TCK.
	SWM_PINENABLE1_SWCLK_TCK = 0x400000
	// Enabled on pin P0_19.
	SWM_PINENABLE1_SWCLK_TCK_ENABLED_ON_PIN_P0_19 = 0x0
	// Disabled.
	SWM_PINENABLE1_SWCLK_TCK_DISABLED = 0x1
	// Position of SWDIO field.
	SWM_PINENABLE1_SWDIO_Pos = 0x17
	// Bit mask of SWDIO field.
	SWM_PINENABLE1_SWDIO_Msk = 0x800000
	// Bit SWDIO.
	SWM_PINENABLE1_SWDIO = 0x800000
	// Enabled on pin P0_20.
	SWM_PINENABLE1_SWDIO_ENABLED_ON_PIN_P0_20 = 0x0
	// Disabled.
	SWM_PINENABLE1_SWDIO_DISABLED = 0x1
	// Position of RESERVED field.
	SWM_PINENABLE1_RESERVED_Pos = 0x18
	// Bit mask of RESERVED field.
	SWM_PINENABLE1_RESERVED_Msk = 0x1000000
	// Bit RESERVED.
	SWM_PINENABLE1_RESERVED = 0x1000000
	// Position of RESERVED field.
	SWM_PINENABLE1_RESERVED_Pos = 0x19
	// Bit mask of RESERVED field.
	SWM_PINENABLE1_RESERVED_Msk = 0x2000000
	// Bit RESERVED.
	SWM_PINENABLE1_RESERVED = 0x2000000
	// Position of RESERVED field.
	SWM_PINENABLE1_RESERVED_Pos = 0x1a
	// Bit mask of RESERVED field.
	SWM_PINENABLE1_RESERVED_Msk = 0x4000000
	// Bit RESERVED.
	SWM_PINENABLE1_RESERVED = 0x4000000
	// Position of RESERVED field.
	SWM_PINENABLE1_RESERVED_Pos = 0x1b
	// Bit mask of RESERVED field.
	SWM_PINENABLE1_RESERVED_Msk = 0x8000000
	// Bit RESERVED.
	SWM_PINENABLE1_RESERVED = 0x8000000
	// Position of RESERVED field.
	SWM_PINENABLE1_RESERVED_Pos = 0x1c
	// Bit mask of RESERVED field.
	SWM_PINENABLE1_RESERVED_Msk = 0x10000000
	// Bit RESERVED.
	SWM_PINENABLE1_RESERVED = 0x10000000
	// Position of RESERVED field.
	SWM_PINENABLE1_RESERVED_Pos = 0x1d
	// Bit mask of RESERVED field.
	SWM_PINENABLE1_RESERVED_Msk = 0x20000000
	// Bit RESERVED.
	SWM_PINENABLE1_RESERVED = 0x20000000
	// Position of RESERVED field.
	SWM_PINENABLE1_RESERVED_Pos = 0x1e
	// Bit mask of RESERVED field.
	SWM_PINENABLE1_RESERVED_Msk = 0x40000000
	// Bit RESERVED.
	SWM_PINENABLE1_RESERVED = 0x40000000
	// Position of RESERVED field.
	SWM_PINENABLE1_RESERVED_Pos = 0x1f
	// Bit mask of RESERVED field.
	SWM_PINENABLE1_RESERVED_Msk = 0x80000000
	// Bit RESERVED.
	SWM_PINENABLE1_RESERVED = 0x80000000
)

// Bitfields for PMU: Power Management Unit (PMU)
const (
	// PCON: Power control register
	// Position of NODPD field.
	PMU_PCON_NODPD_Pos = 0x3
	// Bit mask of NODPD field.
	PMU_PCON_NODPD_Msk = 0x8
	// Bit NODPD.
	PMU_PCON_NODPD = 0x8
	// Position of RESERVED field.
	PMU_PCON_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	PMU_PCON_RESERVED_Msk = 0xf0
	// Position of SLEEPFLAG field.
	PMU_PCON_SLEEPFLAG_Pos = 0x8
	// Bit mask of SLEEPFLAG field.
	PMU_PCON_SLEEPFLAG_Msk = 0x100
	// Bit SLEEPFLAG.
	PMU_PCON_SLEEPFLAG = 0x100
	// Read: No power-down mode entered. The part is in Active mode. Write: No effect.
	PMU_PCON_SLEEPFLAG_READ_NO_POWER_DOWN = 0x0
	// Read: Sleep/Deep-sleep or Deep power-down mode entered. Write: Writing a 1 clears the SLEEPFLAG bit to 0.
	PMU_PCON_SLEEPFLAG_SLEEP_DEEP_SLEEP = 0x1
	// Position of RESERVED field.
	PMU_PCON_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	PMU_PCON_RESERVED_Msk = 0x600
	// Position of DPDFLAG field.
	PMU_PCON_DPDFLAG_Pos = 0xb
	// Bit mask of DPDFLAG field.
	PMU_PCON_DPDFLAG_Msk = 0x800
	// Bit DPDFLAG.
	PMU_PCON_DPDFLAG = 0x800
	// Position of RESERVED field.
	PMU_PCON_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	PMU_PCON_RESERVED_Msk = 0xfffff000

	// GPREG0: General purpose register 0
	// Position of GPDATA field.
	PMU_GPREG_GPDATA_Pos = 0x0
	// Bit mask of GPDATA field.
	PMU_GPREG_GPDATA_Msk = 0xffffffff

	// DPDCTRL: Deep power-down control register
	// Position of WAKEUPHYS field.
	PMU_DPDCTRL_WAKEUPHYS_Pos = 0x0
	// Bit mask of WAKEUPHYS field.
	PMU_DPDCTRL_WAKEUPHYS_Msk = 0x1
	// Bit WAKEUPHYS.
	PMU_DPDCTRL_WAKEUPHYS = 0x1
	// Disabled. Hysteresis for WAKEUP pin disabled.
	PMU_DPDCTRL_WAKEUPHYS_DISABLED = 0x0
	// Enabled. Hysteresis for WAKEUP pin enabled.
	PMU_DPDCTRL_WAKEUPHYS_ENABLED = 0x1
	// Position of WAKEPAD_DISABLE field.
	PMU_DPDCTRL_WAKEPAD_DISABLE_Pos = 0x1
	// Bit mask of WAKEPAD_DISABLE field.
	PMU_DPDCTRL_WAKEPAD_DISABLE_Msk = 0x2
	// Bit WAKEPAD_DISABLE.
	PMU_DPDCTRL_WAKEPAD_DISABLE = 0x2
	// Enabled. The wake-up function is enabled on pin PIO0_4.
	PMU_DPDCTRL_WAKEPAD_DISABLE_ENABLED = 0x0
	// Disabled. Setting this bit disables the wake-up function on pin PIO0_4.
	PMU_DPDCTRL_WAKEPAD_DISABLE_DISABLED = 0x1
	// Position of LPOSCEN field.
	PMU_DPDCTRL_LPOSCEN_Pos = 0x2
	// Bit mask of LPOSCEN field.
	PMU_DPDCTRL_LPOSCEN_Msk = 0x4
	// Bit LPOSCEN.
	PMU_DPDCTRL_LPOSCEN = 0x4
	// Disabled.
	PMU_DPDCTRL_LPOSCEN_DISABLED = 0x0
	// Enabled.
	PMU_DPDCTRL_LPOSCEN_ENABLED = 0x1
	// Position of LPOSCDPDEN field.
	PMU_DPDCTRL_LPOSCDPDEN_Pos = 0x3
	// Bit mask of LPOSCDPDEN field.
	PMU_DPDCTRL_LPOSCDPDEN_Msk = 0x8
	// Bit LPOSCDPDEN.
	PMU_DPDCTRL_LPOSCDPDEN = 0x8
	// Disabled.
	PMU_DPDCTRL_LPOSCDPDEN_DISABLED = 0x0
	// Enabled.
	PMU_DPDCTRL_LPOSCDPDEN_ENABLED = 0x1
	// Position of RESERVED field.
	PMU_DPDCTRL_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	PMU_DPDCTRL_RESERVED_Msk = 0xfffffff0
)

// Bitfields for USART0: USART0
const (
	// CFG: USART Configuration register. Basic USART configuration settings that typically are not changed during operation.
	// Position of ENABLE field.
	USART0_CFG_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	USART0_CFG_ENABLE_Msk = 0x1
	// Bit ENABLE.
	USART0_CFG_ENABLE = 0x1
	// Disabled. The USART is disabled and the internal state machine and counters are reset. While Enable = 0, all USART interrupts and DMA transfers are disabled. When Enable is set again, CFG and most other control bits remain unchanged. For instance, when re-enabled, the USART will immediately generate a TxRdy interrupt (if enabled in the INTENSET register) or a DMA transfer request because the transmitter has been reset and is therefore available.
	USART0_CFG_ENABLE_DISABLED = 0x0
	// Enabled. The USART is enabled for operation.
	USART0_CFG_ENABLE_ENABLED = 0x1
	// Position of RESERVED field.
	USART0_CFG_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	USART0_CFG_RESERVED_Msk = 0x2
	// Bit RESERVED.
	USART0_CFG_RESERVED = 0x2
	// Position of DATALEN field.
	USART0_CFG_DATALEN_Pos = 0x2
	// Bit mask of DATALEN field.
	USART0_CFG_DATALEN_Msk = 0xc
	// 7 bit Data length.
	USART0_CFG_DATALEN_7_BIT_DATA_LENGTH = 0x0
	// 8 bit Data length.
	USART0_CFG_DATALEN_8_BIT_DATA_LENGTH = 0x1
	// 9 bit data length. The 9th bit is commonly used for addressing in multidrop mode. See the ADDRDET bit in the CTL register.
	USART0_CFG_DATALEN_9_BIT_DATA_LENGTH = 0x2
	// Position of PARITYSEL field.
	USART0_CFG_PARITYSEL_Pos = 0x4
	// Bit mask of PARITYSEL field.
	USART0_CFG_PARITYSEL_Msk = 0x30
	// No parity.
	USART0_CFG_PARITYSEL_NO_PARITY = 0x0
	// Even parity. Adds a bit to each character such that the number of 1s in a transmitted character is even, and the number of 1s in a received character is expected to be even.
	USART0_CFG_PARITYSEL_EVEN_PARITY = 0x2
	// Odd parity. Adds a bit to each character such that the number of 1s in a transmitted character is odd, and the number of 1s in a received character is expected to be odd.
	USART0_CFG_PARITYSEL_ODD_PARITY = 0x3
	// Position of STOPLEN field.
	USART0_CFG_STOPLEN_Pos = 0x6
	// Bit mask of STOPLEN field.
	USART0_CFG_STOPLEN_Msk = 0x40
	// Bit STOPLEN.
	USART0_CFG_STOPLEN = 0x40
	// 1 stop bit.
	USART0_CFG_STOPLEN_1_STOP_BIT = 0x0
	// 2 stop bits. This setting should only be used for asynchronous communication.
	USART0_CFG_STOPLEN_2_STOP_BITS = 0x1
	// Position of RESERVED field.
	USART0_CFG_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	USART0_CFG_RESERVED_Msk = 0x80
	// Bit RESERVED.
	USART0_CFG_RESERVED = 0x80
	// Position of MODE32K field.
	USART0_CFG_MODE32K_Pos = 0x7
	// Bit mask of MODE32K field.
	USART0_CFG_MODE32K_Msk = 0x80
	// Bit MODE32K.
	USART0_CFG_MODE32K = 0x80
	// UART uses standard clocking.
	USART0_CFG_MODE32K_UART_USES_STANDARD_C = 0x0
	// UART uses the 32 kHz clock from the RTC oscillator as the clock source to the BRG, and uses a special bit clocking scheme.
	USART0_CFG_MODE32K_UART_USES_THE_32_KHZ = 0x1
	// Position of RESERVED field.
	USART0_CFG_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	USART0_CFG_RESERVED_Msk = 0x100
	// Bit RESERVED.
	USART0_CFG_RESERVED = 0x100
	// Position of CTSEN field.
	USART0_CFG_CTSEN_Pos = 0x9
	// Bit mask of CTSEN field.
	USART0_CFG_CTSEN_Msk = 0x200
	// Bit CTSEN.
	USART0_CFG_CTSEN = 0x200
	// No flow control. The transmitter does not receive any automatic flow control signal.
	USART0_CFG_CTSEN_NO_FLOW_CONTROL = 0x0
	// Flow control enabled. The transmitter uses the CTS input (or RTS output in loopback mode) for flow control purposes.
	USART0_CFG_CTSEN_FLOW_CONTROL_ENABLED = 0x1
	// Position of RESERVED field.
	USART0_CFG_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	USART0_CFG_RESERVED_Msk = 0x400
	// Bit RESERVED.
	USART0_CFG_RESERVED = 0x400
	// Position of SYNCEN field.
	USART0_CFG_SYNCEN_Pos = 0xb
	// Bit mask of SYNCEN field.
	USART0_CFG_SYNCEN_Msk = 0x800
	// Bit SYNCEN.
	USART0_CFG_SYNCEN = 0x800
	// Asynchronous mode is selected.
	USART0_CFG_SYNCEN_ASYNCHRONOUS_MODE_IS = 0x0
	// Synchronous mode is selected.
	USART0_CFG_SYNCEN_SYNCHRONOUS_MODE_IS = 0x1
	// Position of CLKPOL field.
	USART0_CFG_CLKPOL_Pos = 0xc
	// Bit mask of CLKPOL field.
	USART0_CFG_CLKPOL_Msk = 0x1000
	// Bit CLKPOL.
	USART0_CFG_CLKPOL = 0x1000
	// Falling edge. Un_RXD is sampled on the falling edge of SCLK.
	USART0_CFG_CLKPOL_FALLING_EDGE = 0x0
	// Rising edge. Un_RXD is sampled on the rising edge of SCLK.
	USART0_CFG_CLKPOL_RISING_EDGE = 0x1
	// Position of RESERVED field.
	USART0_CFG_RESERVED_Pos = 0xd
	// Bit mask of RESERVED field.
	USART0_CFG_RESERVED_Msk = 0x2000
	// Bit RESERVED.
	USART0_CFG_RESERVED = 0x2000
	// Position of SYNCMST field.
	USART0_CFG_SYNCMST_Pos = 0xe
	// Bit mask of SYNCMST field.
	USART0_CFG_SYNCMST_Msk = 0x4000
	// Bit SYNCMST.
	USART0_CFG_SYNCMST = 0x4000
	// Slave. When synchronous mode is enabled, the USART is a slave.
	USART0_CFG_SYNCMST_SLAVE = 0x0
	// Master. When synchronous mode is enabled, the USART is a master.
	USART0_CFG_SYNCMST_MASTER = 0x1
	// Position of LOOP field.
	USART0_CFG_LOOP_Pos = 0xf
	// Bit mask of LOOP field.
	USART0_CFG_LOOP_Msk = 0x8000
	// Bit LOOP.
	USART0_CFG_LOOP = 0x8000
	// Normal operation.
	USART0_CFG_LOOP_NORMAL_OPERATION = 0x0
	// Loopback mode. This provides a mechanism to perform diagnostic loopback testing for USART data. Serial data from the transmitter (Un_TXD) is connected internally to serial input of the receive (Un_RXD). Un_TXD and Un_RTS activity will also appear on external pins if these functions are configured to appear on device pins. The receiver RTS signal is also looped back to CTS and performs flow control if enabled by CTSEN.
	USART0_CFG_LOOP_LOOPBACK_MODE = 0x1
	// Position of RESERVED field.
	USART0_CFG_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	USART0_CFG_RESERVED_Msk = 0x30000
	// Position of OETA field.
	USART0_CFG_OETA_Pos = 0x12
	// Bit mask of OETA field.
	USART0_CFG_OETA_Msk = 0x40000
	// Bit OETA.
	USART0_CFG_OETA = 0x40000
	// Disabled. If selected by OESEL, the Output Enable signal deasserted at the end of the last stop bit of a transmission.
	USART0_CFG_OETA_DISABLED = 0x0
	// Enabled. If selected by OESEL, the Output Enable signal remains asserted for one character time after the end of the last stop bit of a transmission. OE will also remain asserted if another transmit begins before it is deasserted.
	USART0_CFG_OETA_ENABLED = 0x1
	// Position of AUTOADDR field.
	USART0_CFG_AUTOADDR_Pos = 0x13
	// Bit mask of AUTOADDR field.
	USART0_CFG_AUTOADDR_Msk = 0x80000
	// Bit AUTOADDR.
	USART0_CFG_AUTOADDR = 0x80000
	// Disabled. When addressing is enabled by ADDRDET, address matching is done by software. This provides the possibility of versatile addressing (e.g. respond to more than one address).
	USART0_CFG_AUTOADDR_DISABLED = 0x0
	// Enabled. When addressing is enabled by ADDRDET, address matching is done by hardware, using the value in the ADDR register as the address to match.
	USART0_CFG_AUTOADDR_ENABLED = 0x1
	// Position of OESEL field.
	USART0_CFG_OESEL_Pos = 0x14
	// Bit mask of OESEL field.
	USART0_CFG_OESEL_Msk = 0x100000
	// Bit OESEL.
	USART0_CFG_OESEL = 0x100000
	// Standard. The RTS signal is used as the standard flow control function.
	USART0_CFG_OESEL_STANDARD = 0x0
	// RS-485. The RTS signal configured to provide an output enable signal to control an RS-485 transceiver.
	USART0_CFG_OESEL_RS_485 = 0x1
	// Position of OEPOL field.
	USART0_CFG_OEPOL_Pos = 0x15
	// Bit mask of OEPOL field.
	USART0_CFG_OEPOL_Msk = 0x200000
	// Bit OEPOL.
	USART0_CFG_OEPOL = 0x200000
	// Low. If selected by OESEL, the output enable is active low.
	USART0_CFG_OEPOL_LOW = 0x0
	// High. If selected by OESEL, the output enable is active high.
	USART0_CFG_OEPOL_HIGH = 0x1
	// Position of RXPOL field.
	USART0_CFG_RXPOL_Pos = 0x16
	// Bit mask of RXPOL field.
	USART0_CFG_RXPOL_Msk = 0x400000
	// Bit RXPOL.
	USART0_CFG_RXPOL = 0x400000
	// Standard. The RX signal is used as it arrives from the pin. This means that the RX rest value is 1, start bit is 0, data is not inverted, and the stop bit is 1.
	USART0_CFG_RXPOL_STANDARD = 0x0
	// Inverted. The RX signal is inverted before being used by the UART. This means that the RX rest value is 0, start bit is 1, data is inverted, and the stop bit is 0.
	USART0_CFG_RXPOL_INVERTED = 0x1
	// Position of TXPOL field.
	USART0_CFG_TXPOL_Pos = 0x17
	// Bit mask of TXPOL field.
	USART0_CFG_TXPOL_Msk = 0x800000
	// Bit TXPOL.
	USART0_CFG_TXPOL = 0x800000
	// Standard. The TX signal is sent out without change. This means that the TX rest value is 1, start bit is 0, data is not inverted, and the stop bit is 1.
	USART0_CFG_TXPOL_STANDARD = 0x0
	// Inverted. The TX signal is inverted by the UART before being sent out. This means that the TX rest value is 0, start bit is 1, data is inverted, and the stop bit is 0.
	USART0_CFG_TXPOL_INVERTED = 0x1
	// Position of RESERVED field.
	USART0_CFG_RESERVED_Pos = 0x18
	// Bit mask of RESERVED field.
	USART0_CFG_RESERVED_Msk = 0xff000000

	// CTL: USART Control register. USART control settings that are more likely to change during operation.
	// Position of RESERVED field.
	USART0_CTL_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	USART0_CTL_RESERVED_Msk = 0x1
	// Bit RESERVED.
	USART0_CTL_RESERVED = 0x1
	// Position of TXBRKEN field.
	USART0_CTL_TXBRKEN_Pos = 0x1
	// Bit mask of TXBRKEN field.
	USART0_CTL_TXBRKEN_Msk = 0x2
	// Bit TXBRKEN.
	USART0_CTL_TXBRKEN = 0x2
	// Normal operation.
	USART0_CTL_TXBRKEN_NORMAL_OPERATION = 0x0
	// Continuous break is sent immediately when this bit is set, and remains until this bit is cleared. A break may be sent without danger of corrupting any currently transmitting character if the transmitter is first disabled (TXDIS in CTL is set) and then waiting for the transmitter to be disabled (TXDISINT in STAT = 1) before writing 1 to TXBRKEN.
	USART0_CTL_TXBRKEN_CONTINUOUS_BREAK_IS = 0x1
	// Position of ADDRDET field.
	USART0_CTL_ADDRDET_Pos = 0x2
	// Bit mask of ADDRDET field.
	USART0_CTL_ADDRDET_Msk = 0x4
	// Bit ADDRDET.
	USART0_CTL_ADDRDET = 0x4
	// Disabled. The USART presents all incoming data.
	USART0_CTL_ADDRDET_DISABLED = 0x0
	// Enabled. The USART receiver ignores incoming data that does not have the most significant bit of the data (typically the 9th bit) = 1. When the data MSB bit = 1, the receiver treats the incoming data normally, generating a received data interrupt. Software can then check the data to see if this is an address that should be handled. If it is, the ADDRDET bit is cleared by software and further incoming data is handled normally.
	USART0_CTL_ADDRDET_ENABLED = 0x1
	// Position of RESERVED field.
	USART0_CTL_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	USART0_CTL_RESERVED_Msk = 0x38
	// Position of TXDIS field.
	USART0_CTL_TXDIS_Pos = 0x6
	// Bit mask of TXDIS field.
	USART0_CTL_TXDIS_Msk = 0x40
	// Bit TXDIS.
	USART0_CTL_TXDIS = 0x40
	// Not disabled. USART transmitter is not disabled.
	USART0_CTL_TXDIS_NOT_DISABLED = 0x0
	// Disabled. USART transmitter is disabled after any character currently being transmitted is complete. This feature can be used to facilitate software flow control.
	USART0_CTL_TXDIS_DISABLED = 0x1
	// Position of RESERVED field.
	USART0_CTL_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	USART0_CTL_RESERVED_Msk = 0x80
	// Bit RESERVED.
	USART0_CTL_RESERVED = 0x80
	// Position of CC field.
	USART0_CTL_CC_Pos = 0x8
	// Bit mask of CC field.
	USART0_CTL_CC_Msk = 0x100
	// Bit CC.
	USART0_CTL_CC = 0x100
	// Clock on character. In synchronous mode, SCLK cycles only when characters are being sent on Un_TXD or to complete a character that is being received.
	USART0_CTL_CC_CLOCK_ON_CHARACTER = 0x0
	// Continuous clock. SCLK runs continuously in synchronous mode, allowing characters to be received on Un_RxD independently from transmission on Un_TXD).
	USART0_CTL_CC_CONTINUOUS_CLOCK = 0x1
	// Position of CLRCCONRX field.
	USART0_CTL_CLRCCONRX_Pos = 0x9
	// Bit mask of CLRCCONRX field.
	USART0_CTL_CLRCCONRX_Msk = 0x200
	// Bit CLRCCONRX.
	USART0_CTL_CLRCCONRX = 0x200
	// No affect on the CC bit.
	USART0_CTL_CLRCCONRX_NO_AFFECT_ON_THE_CC = 0x0
	// Auto-clear. The CC bit is automatically cleared when a complete character has been received. This bit is cleared at the same time.
	USART0_CTL_CLRCCONRX_AUTO_CLEAR = 0x1
	// Position of RESERVED field.
	USART0_CTL_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	USART0_CTL_RESERVED_Msk = 0xfc00
	// Position of AUTOBAUD field.
	USART0_CTL_AUTOBAUD_Pos = 0x10
	// Bit mask of AUTOBAUD field.
	USART0_CTL_AUTOBAUD_Msk = 0x10000
	// Bit AUTOBAUD.
	USART0_CTL_AUTOBAUD = 0x10000
	// Disabled. UART is in normal operating mode.
	USART0_CTL_AUTOBAUD_DISABLED = 0x0
	// Enabled. UART is in autobaud mode. This bit should only be set when the UART receiver is idle. The first start bit of RX is measured and used the update the BRG register to match the received data rate. AUTOBAUD is cleared once this process is complete, or if there is an AERR.
	USART0_CTL_AUTOBAUD_ENABLED = 0x1
	// Position of RESERVED field.
	USART0_CTL_RESERVED_Pos = 0x11
	// Bit mask of RESERVED field.
	USART0_CTL_RESERVED_Msk = 0xfffe0000

	// STAT: USART Status register. The complete status value can be read here. Writing ones clears some bits in the register. Some bits can be cleared by writing a 1 to them.
	// Position of RXRDY field.
	USART0_STAT_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	USART0_STAT_RXRDY_Msk = 0x1
	// Bit RXRDY.
	USART0_STAT_RXRDY = 0x1
	// Position of RXIDLE field.
	USART0_STAT_RXIDLE_Pos = 0x1
	// Bit mask of RXIDLE field.
	USART0_STAT_RXIDLE_Msk = 0x2
	// Bit RXIDLE.
	USART0_STAT_RXIDLE = 0x2
	// Position of TXRDY field.
	USART0_STAT_TXRDY_Pos = 0x2
	// Bit mask of TXRDY field.
	USART0_STAT_TXRDY_Msk = 0x4
	// Bit TXRDY.
	USART0_STAT_TXRDY = 0x4
	// Position of TXIDLE field.
	USART0_STAT_TXIDLE_Pos = 0x3
	// Bit mask of TXIDLE field.
	USART0_STAT_TXIDLE_Msk = 0x8
	// Bit TXIDLE.
	USART0_STAT_TXIDLE = 0x8
	// Position of CTS field.
	USART0_STAT_CTS_Pos = 0x4
	// Bit mask of CTS field.
	USART0_STAT_CTS_Msk = 0x10
	// Bit CTS.
	USART0_STAT_CTS = 0x10
	// Position of DELTACTS field.
	USART0_STAT_DELTACTS_Pos = 0x5
	// Bit mask of DELTACTS field.
	USART0_STAT_DELTACTS_Msk = 0x20
	// Bit DELTACTS.
	USART0_STAT_DELTACTS = 0x20
	// Position of TXDISSTAT field.
	USART0_STAT_TXDISSTAT_Pos = 0x6
	// Bit mask of TXDISSTAT field.
	USART0_STAT_TXDISSTAT_Msk = 0x40
	// Bit TXDISSTAT.
	USART0_STAT_TXDISSTAT = 0x40
	// Position of RESERVED field.
	USART0_STAT_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	USART0_STAT_RESERVED_Msk = 0x80
	// Bit RESERVED.
	USART0_STAT_RESERVED = 0x80
	// Position of OVERRUNINT field.
	USART0_STAT_OVERRUNINT_Pos = 0x8
	// Bit mask of OVERRUNINT field.
	USART0_STAT_OVERRUNINT_Msk = 0x100
	// Bit OVERRUNINT.
	USART0_STAT_OVERRUNINT = 0x100
	// Position of RESERVED field.
	USART0_STAT_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	USART0_STAT_RESERVED_Msk = 0x200
	// Bit RESERVED.
	USART0_STAT_RESERVED = 0x200
	// Position of RXBRK field.
	USART0_STAT_RXBRK_Pos = 0xa
	// Bit mask of RXBRK field.
	USART0_STAT_RXBRK_Msk = 0x400
	// Bit RXBRK.
	USART0_STAT_RXBRK = 0x400
	// Position of DELTARXBRK field.
	USART0_STAT_DELTARXBRK_Pos = 0xb
	// Bit mask of DELTARXBRK field.
	USART0_STAT_DELTARXBRK_Msk = 0x800
	// Bit DELTARXBRK.
	USART0_STAT_DELTARXBRK = 0x800
	// Position of START field.
	USART0_STAT_START_Pos = 0xc
	// Bit mask of START field.
	USART0_STAT_START_Msk = 0x1000
	// Bit START.
	USART0_STAT_START = 0x1000
	// Position of FRAMERRINT field.
	USART0_STAT_FRAMERRINT_Pos = 0xd
	// Bit mask of FRAMERRINT field.
	USART0_STAT_FRAMERRINT_Msk = 0x2000
	// Bit FRAMERRINT.
	USART0_STAT_FRAMERRINT = 0x2000
	// Position of PARITYERRINT field.
	USART0_STAT_PARITYERRINT_Pos = 0xe
	// Bit mask of PARITYERRINT field.
	USART0_STAT_PARITYERRINT_Msk = 0x4000
	// Bit PARITYERRINT.
	USART0_STAT_PARITYERRINT = 0x4000
	// Position of RXNOISEINT field.
	USART0_STAT_RXNOISEINT_Pos = 0xf
	// Bit mask of RXNOISEINT field.
	USART0_STAT_RXNOISEINT_Msk = 0x8000
	// Bit RXNOISEINT.
	USART0_STAT_RXNOISEINT = 0x8000
	// Position of ABERR field.
	USART0_STAT_ABERR_Pos = 0x10
	// Bit mask of ABERR field.
	USART0_STAT_ABERR_Msk = 0x10000
	// Bit ABERR.
	USART0_STAT_ABERR = 0x10000
	// Position of RESERVED field.
	USART0_STAT_RESERVED_Pos = 0x11
	// Bit mask of RESERVED field.
	USART0_STAT_RESERVED_Msk = 0xfffe0000

	// INTENSET: Interrupt Enable read and Set register. Contains an individual interrupt enable bit for each potential USART interrupt. A complete value may be read from this register. Writing a 1 to any implemented bit position causes that bit to be set.
	// Position of RXRDYEN field.
	USART0_INTENSET_RXRDYEN_Pos = 0x0
	// Bit mask of RXRDYEN field.
	USART0_INTENSET_RXRDYEN_Msk = 0x1
	// Bit RXRDYEN.
	USART0_INTENSET_RXRDYEN = 0x1
	// Position of RESERVED field.
	USART0_INTENSET_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	USART0_INTENSET_RESERVED_Msk = 0x2
	// Bit RESERVED.
	USART0_INTENSET_RESERVED = 0x2
	// Position of TXRDYEN field.
	USART0_INTENSET_TXRDYEN_Pos = 0x2
	// Bit mask of TXRDYEN field.
	USART0_INTENSET_TXRDYEN_Msk = 0x4
	// Bit TXRDYEN.
	USART0_INTENSET_TXRDYEN = 0x4
	// Position of TXIDLEEN field.
	USART0_INTENSET_TXIDLEEN_Pos = 0x3
	// Bit mask of TXIDLEEN field.
	USART0_INTENSET_TXIDLEEN_Msk = 0x8
	// Bit TXIDLEEN.
	USART0_INTENSET_TXIDLEEN = 0x8
	// Position of RESERVED field.
	USART0_INTENSET_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	USART0_INTENSET_RESERVED_Msk = 0x10
	// Bit RESERVED.
	USART0_INTENSET_RESERVED = 0x10
	// Position of DELTACTSEN field.
	USART0_INTENSET_DELTACTSEN_Pos = 0x5
	// Bit mask of DELTACTSEN field.
	USART0_INTENSET_DELTACTSEN_Msk = 0x20
	// Bit DELTACTSEN.
	USART0_INTENSET_DELTACTSEN = 0x20
	// Position of TXDISEN field.
	USART0_INTENSET_TXDISEN_Pos = 0x6
	// Bit mask of TXDISEN field.
	USART0_INTENSET_TXDISEN_Msk = 0x40
	// Bit TXDISEN.
	USART0_INTENSET_TXDISEN = 0x40
	// Position of RESERVED field.
	USART0_INTENSET_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	USART0_INTENSET_RESERVED_Msk = 0x80
	// Bit RESERVED.
	USART0_INTENSET_RESERVED = 0x80
	// Position of OVERRUNEN field.
	USART0_INTENSET_OVERRUNEN_Pos = 0x8
	// Bit mask of OVERRUNEN field.
	USART0_INTENSET_OVERRUNEN_Msk = 0x100
	// Bit OVERRUNEN.
	USART0_INTENSET_OVERRUNEN = 0x100
	// Position of RESERVED field.
	USART0_INTENSET_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	USART0_INTENSET_RESERVED_Msk = 0x600
	// Position of DELTARXBRKEN field.
	USART0_INTENSET_DELTARXBRKEN_Pos = 0xb
	// Bit mask of DELTARXBRKEN field.
	USART0_INTENSET_DELTARXBRKEN_Msk = 0x800
	// Bit DELTARXBRKEN.
	USART0_INTENSET_DELTARXBRKEN = 0x800
	// Position of STARTEN field.
	USART0_INTENSET_STARTEN_Pos = 0xc
	// Bit mask of STARTEN field.
	USART0_INTENSET_STARTEN_Msk = 0x1000
	// Bit STARTEN.
	USART0_INTENSET_STARTEN = 0x1000
	// Position of FRAMERREN field.
	USART0_INTENSET_FRAMERREN_Pos = 0xd
	// Bit mask of FRAMERREN field.
	USART0_INTENSET_FRAMERREN_Msk = 0x2000
	// Bit FRAMERREN.
	USART0_INTENSET_FRAMERREN = 0x2000
	// Position of PARITYERREN field.
	USART0_INTENSET_PARITYERREN_Pos = 0xe
	// Bit mask of PARITYERREN field.
	USART0_INTENSET_PARITYERREN_Msk = 0x4000
	// Bit PARITYERREN.
	USART0_INTENSET_PARITYERREN = 0x4000
	// Position of RXNOISEEN field.
	USART0_INTENSET_RXNOISEEN_Pos = 0xf
	// Bit mask of RXNOISEEN field.
	USART0_INTENSET_RXNOISEEN_Msk = 0x8000
	// Bit RXNOISEEN.
	USART0_INTENSET_RXNOISEEN = 0x8000
	// Position of ABERREN field.
	USART0_INTENSET_ABERREN_Pos = 0x10
	// Bit mask of ABERREN field.
	USART0_INTENSET_ABERREN_Msk = 0x10000
	// Bit ABERREN.
	USART0_INTENSET_ABERREN = 0x10000
	// Position of RESERVED field.
	USART0_INTENSET_RESERVED_Pos = 0x11
	// Bit mask of RESERVED field.
	USART0_INTENSET_RESERVED_Msk = 0xfffe0000

	// INTENCLR: Interrupt Enable Clear register. Allows clearing any combination of bits in the INTENSET register. Writing a 1 to any implemented bit position causes the corresponding bit to be cleared.
	// Position of RXRDYCLR field.
	USART0_INTENCLR_RXRDYCLR_Pos = 0x0
	// Bit mask of RXRDYCLR field.
	USART0_INTENCLR_RXRDYCLR_Msk = 0x1
	// Bit RXRDYCLR.
	USART0_INTENCLR_RXRDYCLR = 0x1
	// Position of RESERVED field.
	USART0_INTENCLR_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	USART0_INTENCLR_RESERVED_Msk = 0x2
	// Bit RESERVED.
	USART0_INTENCLR_RESERVED = 0x2
	// Position of TXRDYCLR field.
	USART0_INTENCLR_TXRDYCLR_Pos = 0x2
	// Bit mask of TXRDYCLR field.
	USART0_INTENCLR_TXRDYCLR_Msk = 0x4
	// Bit TXRDYCLR.
	USART0_INTENCLR_TXRDYCLR = 0x4
	// Position of TXIDLECLR field.
	USART0_INTENCLR_TXIDLECLR_Pos = 0x3
	// Bit mask of TXIDLECLR field.
	USART0_INTENCLR_TXIDLECLR_Msk = 0x8
	// Bit TXIDLECLR.
	USART0_INTENCLR_TXIDLECLR = 0x8
	// Position of RESERVED field.
	USART0_INTENCLR_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	USART0_INTENCLR_RESERVED_Msk = 0x10
	// Bit RESERVED.
	USART0_INTENCLR_RESERVED = 0x10
	// Position of DELTACTSCLR field.
	USART0_INTENCLR_DELTACTSCLR_Pos = 0x5
	// Bit mask of DELTACTSCLR field.
	USART0_INTENCLR_DELTACTSCLR_Msk = 0x20
	// Bit DELTACTSCLR.
	USART0_INTENCLR_DELTACTSCLR = 0x20
	// Position of TXDISCLR field.
	USART0_INTENCLR_TXDISCLR_Pos = 0x6
	// Bit mask of TXDISCLR field.
	USART0_INTENCLR_TXDISCLR_Msk = 0x40
	// Bit TXDISCLR.
	USART0_INTENCLR_TXDISCLR = 0x40
	// Position of RESERVED field.
	USART0_INTENCLR_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	USART0_INTENCLR_RESERVED_Msk = 0x80
	// Bit RESERVED.
	USART0_INTENCLR_RESERVED = 0x80
	// Position of OVERRUNCLR field.
	USART0_INTENCLR_OVERRUNCLR_Pos = 0x8
	// Bit mask of OVERRUNCLR field.
	USART0_INTENCLR_OVERRUNCLR_Msk = 0x100
	// Bit OVERRUNCLR.
	USART0_INTENCLR_OVERRUNCLR = 0x100
	// Position of RESERVED field.
	USART0_INTENCLR_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	USART0_INTENCLR_RESERVED_Msk = 0x600
	// Position of DELTARXBRKCLR field.
	USART0_INTENCLR_DELTARXBRKCLR_Pos = 0xb
	// Bit mask of DELTARXBRKCLR field.
	USART0_INTENCLR_DELTARXBRKCLR_Msk = 0x800
	// Bit DELTARXBRKCLR.
	USART0_INTENCLR_DELTARXBRKCLR = 0x800
	// Position of STARTCLR field.
	USART0_INTENCLR_STARTCLR_Pos = 0xc
	// Bit mask of STARTCLR field.
	USART0_INTENCLR_STARTCLR_Msk = 0x1000
	// Bit STARTCLR.
	USART0_INTENCLR_STARTCLR = 0x1000
	// Position of FRAMERRCLR field.
	USART0_INTENCLR_FRAMERRCLR_Pos = 0xd
	// Bit mask of FRAMERRCLR field.
	USART0_INTENCLR_FRAMERRCLR_Msk = 0x2000
	// Bit FRAMERRCLR.
	USART0_INTENCLR_FRAMERRCLR = 0x2000
	// Position of PARITYERRCLR field.
	USART0_INTENCLR_PARITYERRCLR_Pos = 0xe
	// Bit mask of PARITYERRCLR field.
	USART0_INTENCLR_PARITYERRCLR_Msk = 0x4000
	// Bit PARITYERRCLR.
	USART0_INTENCLR_PARITYERRCLR = 0x4000
	// Position of RXNOISECLR field.
	USART0_INTENCLR_RXNOISECLR_Pos = 0xf
	// Bit mask of RXNOISECLR field.
	USART0_INTENCLR_RXNOISECLR_Msk = 0x8000
	// Bit RXNOISECLR.
	USART0_INTENCLR_RXNOISECLR = 0x8000
	// Position of ABERRCLR field.
	USART0_INTENCLR_ABERRCLR_Pos = 0x10
	// Bit mask of ABERRCLR field.
	USART0_INTENCLR_ABERRCLR_Msk = 0x10000
	// Bit ABERRCLR.
	USART0_INTENCLR_ABERRCLR = 0x10000
	// Position of RESERVED field.
	USART0_INTENCLR_RESERVED_Pos = 0x11
	// Bit mask of RESERVED field.
	USART0_INTENCLR_RESERVED_Msk = 0xfffe0000

	// RXDAT: Receiver Data register. Contains the last character received.
	// Position of DATA field.
	USART0_RXDAT_DATA_Pos = 0x0
	// Bit mask of DATA field.
	USART0_RXDAT_DATA_Msk = 0x1ff
	// Position of RESERVED field.
	USART0_RXDAT_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	USART0_RXDAT_RESERVED_Msk = 0xfffffe00

	// RXDATSTAT: Receiver Data with Status register. Combines the last character received with the current USART receive status. Allows DMA or software to recover incoming data and status together.
	// Position of RXDATA field.
	USART0_RXDATSTAT_RXDATA_Pos = 0x0
	// Bit mask of RXDATA field.
	USART0_RXDATSTAT_RXDATA_Msk = 0x1ff
	// Position of RESERVED field.
	USART0_RXDATSTAT_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	USART0_RXDATSTAT_RESERVED_Msk = 0x1e00
	// Position of FRAMERR field.
	USART0_RXDATSTAT_FRAMERR_Pos = 0xd
	// Bit mask of FRAMERR field.
	USART0_RXDATSTAT_FRAMERR_Msk = 0x2000
	// Bit FRAMERR.
	USART0_RXDATSTAT_FRAMERR = 0x2000
	// Position of PARITYERR field.
	USART0_RXDATSTAT_PARITYERR_Pos = 0xe
	// Bit mask of PARITYERR field.
	USART0_RXDATSTAT_PARITYERR_Msk = 0x4000
	// Bit PARITYERR.
	USART0_RXDATSTAT_PARITYERR = 0x4000
	// Position of RXNOISE field.
	USART0_RXDATSTAT_RXNOISE_Pos = 0xf
	// Bit mask of RXNOISE field.
	USART0_RXDATSTAT_RXNOISE_Msk = 0x8000
	// Bit RXNOISE.
	USART0_RXDATSTAT_RXNOISE = 0x8000
	// Position of RESERVED field.
	USART0_RXDATSTAT_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	USART0_RXDATSTAT_RESERVED_Msk = 0xffff0000

	// TXDAT: Transmit Data register. Data to be transmitted is written here.
	// Position of TXDATA field.
	USART0_TXDAT_TXDATA_Pos = 0x0
	// Bit mask of TXDATA field.
	USART0_TXDAT_TXDATA_Msk = 0x1ff
	// Position of RESERVED field.
	USART0_TXDAT_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	USART0_TXDAT_RESERVED_Msk = 0xfffffe00

	// BRG: Baud Rate Generator register. 16-bit integer baud rate divisor value.
	// Position of BRGVAL field.
	USART0_BRG_BRGVAL_Pos = 0x0
	// Bit mask of BRGVAL field.
	USART0_BRG_BRGVAL_Msk = 0xffff
	// Position of RESERVED field.
	USART0_BRG_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	USART0_BRG_RESERVED_Msk = 0xffff0000

	// INTSTAT: Interrupt status register. Reflects interrupts that are currently enabled.
	// Position of RXRDY field.
	USART0_INTSTAT_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	USART0_INTSTAT_RXRDY_Msk = 0x1
	// Bit RXRDY.
	USART0_INTSTAT_RXRDY = 0x1
	// Position of RESERVED field.
	USART0_INTSTAT_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	USART0_INTSTAT_RESERVED_Msk = 0x2
	// Bit RESERVED.
	USART0_INTSTAT_RESERVED = 0x2
	// Position of TXRDY field.
	USART0_INTSTAT_TXRDY_Pos = 0x2
	// Bit mask of TXRDY field.
	USART0_INTSTAT_TXRDY_Msk = 0x4
	// Bit TXRDY.
	USART0_INTSTAT_TXRDY = 0x4
	// Position of TXIDLE field.
	USART0_INTSTAT_TXIDLE_Pos = 0x3
	// Bit mask of TXIDLE field.
	USART0_INTSTAT_TXIDLE_Msk = 0x8
	// Bit TXIDLE.
	USART0_INTSTAT_TXIDLE = 0x8
	// Position of RESERVED field.
	USART0_INTSTAT_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	USART0_INTSTAT_RESERVED_Msk = 0x10
	// Bit RESERVED.
	USART0_INTSTAT_RESERVED = 0x10
	// Position of DELTACTS field.
	USART0_INTSTAT_DELTACTS_Pos = 0x5
	// Bit mask of DELTACTS field.
	USART0_INTSTAT_DELTACTS_Msk = 0x20
	// Bit DELTACTS.
	USART0_INTSTAT_DELTACTS = 0x20
	// Position of TXDISINT field.
	USART0_INTSTAT_TXDISINT_Pos = 0x6
	// Bit mask of TXDISINT field.
	USART0_INTSTAT_TXDISINT_Msk = 0x40
	// Bit TXDISINT.
	USART0_INTSTAT_TXDISINT = 0x40
	// Position of RESERVED field.
	USART0_INTSTAT_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	USART0_INTSTAT_RESERVED_Msk = 0x80
	// Bit RESERVED.
	USART0_INTSTAT_RESERVED = 0x80
	// Position of OVERRUNINT field.
	USART0_INTSTAT_OVERRUNINT_Pos = 0x8
	// Bit mask of OVERRUNINT field.
	USART0_INTSTAT_OVERRUNINT_Msk = 0x100
	// Bit OVERRUNINT.
	USART0_INTSTAT_OVERRUNINT = 0x100
	// Position of RESERVED field.
	USART0_INTSTAT_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	USART0_INTSTAT_RESERVED_Msk = 0x600
	// Position of DELTARXBRK field.
	USART0_INTSTAT_DELTARXBRK_Pos = 0xb
	// Bit mask of DELTARXBRK field.
	USART0_INTSTAT_DELTARXBRK_Msk = 0x800
	// Bit DELTARXBRK.
	USART0_INTSTAT_DELTARXBRK = 0x800
	// Position of START field.
	USART0_INTSTAT_START_Pos = 0xc
	// Bit mask of START field.
	USART0_INTSTAT_START_Msk = 0x1000
	// Bit START.
	USART0_INTSTAT_START = 0x1000
	// Position of FRAMERRINT field.
	USART0_INTSTAT_FRAMERRINT_Pos = 0xd
	// Bit mask of FRAMERRINT field.
	USART0_INTSTAT_FRAMERRINT_Msk = 0x2000
	// Bit FRAMERRINT.
	USART0_INTSTAT_FRAMERRINT = 0x2000
	// Position of PARITYERRINT field.
	USART0_INTSTAT_PARITYERRINT_Pos = 0xe
	// Bit mask of PARITYERRINT field.
	USART0_INTSTAT_PARITYERRINT_Msk = 0x4000
	// Bit PARITYERRINT.
	USART0_INTSTAT_PARITYERRINT = 0x4000
	// Position of RXNOISEINT field.
	USART0_INTSTAT_RXNOISEINT_Pos = 0xf
	// Bit mask of RXNOISEINT field.
	USART0_INTSTAT_RXNOISEINT_Msk = 0x8000
	// Bit RXNOISEINT.
	USART0_INTSTAT_RXNOISEINT = 0x8000
	// Position of ABERRINT field.
	USART0_INTSTAT_ABERRINT_Pos = 0x10
	// Bit mask of ABERRINT field.
	USART0_INTSTAT_ABERRINT_Msk = 0x10000
	// Bit ABERRINT.
	USART0_INTSTAT_ABERRINT = 0x10000
	// Position of RESERVED field.
	USART0_INTSTAT_RESERVED_Pos = 0x11
	// Bit mask of RESERVED field.
	USART0_INTSTAT_RESERVED_Msk = 0xfffe0000

	// OSR: Oversample selection register for asynchronous communication.
	// Position of OSRVAL field.
	USART0_OSR_OSRVAL_Pos = 0x0
	// Bit mask of OSRVAL field.
	USART0_OSR_OSRVAL_Msk = 0xf
	// Position of RESERVED field.
	USART0_OSR_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	USART0_OSR_RESERVED_Msk = 0xfffffff0

	// ADDR: Address register for automatic address matching.
	// Position of ADDRESS field.
	USART0_ADDR_ADDRESS_Pos = 0x0
	// Bit mask of ADDRESS field.
	USART0_ADDR_ADDRESS_Msk = 0xff
	// Position of RESERVED field.
	USART0_ADDR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	USART0_ADDR_RESERVED_Msk = 0xffffff00
)

// Bitfields for SPI0: SPI0
const (
	// CFG: SPI Configuration register
	// Position of ENABLE field.
	SPI0_CFG_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	SPI0_CFG_ENABLE_Msk = 0x1
	// Bit ENABLE.
	SPI0_CFG_ENABLE = 0x1
	// Disabled. The SPI is disabled and the internal state machine and counters are reset.
	SPI0_CFG_ENABLE_DISABLED = 0x0
	// Enabled. The SPI is enabled for operation.
	SPI0_CFG_ENABLE_ENABLED = 0x1
	// Position of RESERVED field.
	SPI0_CFG_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	SPI0_CFG_RESERVED_Msk = 0x2
	// Bit RESERVED.
	SPI0_CFG_RESERVED = 0x2
	// Position of MASTER field.
	SPI0_CFG_MASTER_Pos = 0x2
	// Bit mask of MASTER field.
	SPI0_CFG_MASTER_Msk = 0x4
	// Bit MASTER.
	SPI0_CFG_MASTER = 0x4
	// Slave mode. The SPI will operate in slave mode. SCK, MOSI, and the SSEL signals are inputs, MISO is an output.
	SPI0_CFG_MASTER_SLAVE_MODE = 0x0
	// Master mode. The SPI will operate in master mode. SCK, MOSI, and the SSEL signals are outputs, MISO is an input.
	SPI0_CFG_MASTER_MASTER_MODE = 0x1
	// Position of LSBF field.
	SPI0_CFG_LSBF_Pos = 0x3
	// Bit mask of LSBF field.
	SPI0_CFG_LSBF_Msk = 0x8
	// Bit LSBF.
	SPI0_CFG_LSBF = 0x8
	// Standard. Data is transmitted and received in standard MSB first order.
	SPI0_CFG_LSBF_STANDARD = 0x0
	// Reverse. Data is transmitted and received in reverse order (LSB first).
	SPI0_CFG_LSBF_REVERSE = 0x1
	// Position of CPHA field.
	SPI0_CFG_CPHA_Pos = 0x4
	// Bit mask of CPHA field.
	SPI0_CFG_CPHA_Msk = 0x10
	// Bit CPHA.
	SPI0_CFG_CPHA = 0x10
	// Change. The SPI captures serial data on the first clock transition of the frame (when the clock changes away from the rest state). Data is changed on the following edge.
	SPI0_CFG_CPHA_CHANGE = 0x0
	// Capture. The SPI changes serial data on the first clock transition of the frame (when the clock changes away from the rest state). Data is captured on the following edge.
	SPI0_CFG_CPHA_CAPTURE = 0x1
	// Position of CPOL field.
	SPI0_CFG_CPOL_Pos = 0x5
	// Bit mask of CPOL field.
	SPI0_CFG_CPOL_Msk = 0x20
	// Bit CPOL.
	SPI0_CFG_CPOL = 0x20
	// Low. The rest state of the clock (between frames) is low.
	SPI0_CFG_CPOL_LOW = 0x0
	// High. The rest state of the clock (between frames) is high.
	SPI0_CFG_CPOL_HIGH = 0x1
	// Position of RESERVED field.
	SPI0_CFG_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	SPI0_CFG_RESERVED_Msk = 0x40
	// Bit RESERVED.
	SPI0_CFG_RESERVED = 0x40
	// Position of LOOP field.
	SPI0_CFG_LOOP_Pos = 0x7
	// Bit mask of LOOP field.
	SPI0_CFG_LOOP_Msk = 0x80
	// Bit LOOP.
	SPI0_CFG_LOOP = 0x80
	// Disabled.
	SPI0_CFG_LOOP_DISABLED = 0x0
	// Enabled.
	SPI0_CFG_LOOP_ENABLED = 0x1
	// Position of SPOL0 field.
	SPI0_CFG_SPOL0_Pos = 0x8
	// Bit mask of SPOL0 field.
	SPI0_CFG_SPOL0_Msk = 0x100
	// Bit SPOL0.
	SPI0_CFG_SPOL0 = 0x100
	// Low. The SSEL0 pin is active low. The value in the SSEL0 fields of the RXDAT, TXDATCTL, and TXCTL registers related to SSEL0 is not inverted relative to the pins.
	SPI0_CFG_SPOL0_LOW = 0x0
	// High. The SSEL0 pin is active high. The value in the SSEL0 fields of the RXDAT, TXDATCTL, and TXCTL registers related to SSEL0 is inverted relative to the pins.
	SPI0_CFG_SPOL0_HIGH = 0x1
	// Position of SPOL1 field.
	SPI0_CFG_SPOL1_Pos = 0x9
	// Bit mask of SPOL1 field.
	SPI0_CFG_SPOL1_Msk = 0x200
	// Bit SPOL1.
	SPI0_CFG_SPOL1 = 0x200
	// Low. The SSEL1 pin is active low. The value in the SSEL1 fields of the RXDAT, TXDATCTL, and TXCTL registers related to SSEL1 is not inverted relative to the pins.
	SPI0_CFG_SPOL1_LOW = 0x0
	// High. The SSEL1 pin is active high. The value in the SSEL1 fields of the RXDAT, TXDATCTL, and TXCTL registers related to SSEL1 is inverted relative to the pins.
	SPI0_CFG_SPOL1_HIGH = 0x1
	// Position of SPOL2 field.
	SPI0_CFG_SPOL2_Pos = 0xa
	// Bit mask of SPOL2 field.
	SPI0_CFG_SPOL2_Msk = 0x400
	// Bit SPOL2.
	SPI0_CFG_SPOL2 = 0x400
	// Low. The SSEL2 pin is active low. The value in the SSEL2 fields of the RXDAT, TXDATCTL, and TXCTL registers related to SSEL2 is not inverted relative to the pins.
	SPI0_CFG_SPOL2_LOW = 0x0
	// High. The SSEL2 pin is active high. The value in the SSEL2 fields of the RXDAT, TXDATCTL, and TXCTL registers related to SSEL2 is inverted relative to the pins.
	SPI0_CFG_SPOL2_HIGH = 0x1
	// Position of SPOL3 field.
	SPI0_CFG_SPOL3_Pos = 0xb
	// Bit mask of SPOL3 field.
	SPI0_CFG_SPOL3_Msk = 0x800
	// Bit SPOL3.
	SPI0_CFG_SPOL3 = 0x800
	// Low. The SSEL3 pin is active low. The value in the SSEL3 fields of the RXDAT, TXDATCTL, and TXCTL registers related to SSEL3 is not inverted relative to the pins.
	SPI0_CFG_SPOL3_LOW = 0x0
	// High. The SSEL3 pin is active high. The value in the SSEL3 fields of the RXDAT, TXDATCTL, and TXCTL registers related to SSEL3 is inverted relative to the pins.
	SPI0_CFG_SPOL3_HIGH = 0x1
	// Position of RESERVED field.
	SPI0_CFG_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	SPI0_CFG_RESERVED_Msk = 0xfffff000

	// DLY: SPI Delay register
	// Position of PRE_DELAY field.
	SPI0_DLY_PRE_DELAY_Pos = 0x0
	// Bit mask of PRE_DELAY field.
	SPI0_DLY_PRE_DELAY_Msk = 0xf
	// Position of POST_DELAY field.
	SPI0_DLY_POST_DELAY_Pos = 0x4
	// Bit mask of POST_DELAY field.
	SPI0_DLY_POST_DELAY_Msk = 0xf0
	// Position of FRAME_DELAY field.
	SPI0_DLY_FRAME_DELAY_Pos = 0x8
	// Bit mask of FRAME_DELAY field.
	SPI0_DLY_FRAME_DELAY_Msk = 0xf00
	// Position of TRANSFER_DELAY field.
	SPI0_DLY_TRANSFER_DELAY_Pos = 0xc
	// Bit mask of TRANSFER_DELAY field.
	SPI0_DLY_TRANSFER_DELAY_Msk = 0xf000
	// Position of RESERVED field.
	SPI0_DLY_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	SPI0_DLY_RESERVED_Msk = 0xffff0000

	// STAT: SPI Status. Some status flags can be cleared by writing a 1 to that bit position
	// Position of RXRDY field.
	SPI0_STAT_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	SPI0_STAT_RXRDY_Msk = 0x1
	// Bit RXRDY.
	SPI0_STAT_RXRDY = 0x1
	// Position of TXRDY field.
	SPI0_STAT_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	SPI0_STAT_TXRDY_Msk = 0x2
	// Bit TXRDY.
	SPI0_STAT_TXRDY = 0x2
	// Position of RXOV field.
	SPI0_STAT_RXOV_Pos = 0x2
	// Bit mask of RXOV field.
	SPI0_STAT_RXOV_Msk = 0x4
	// Bit RXOV.
	SPI0_STAT_RXOV = 0x4
	// Position of TXUR field.
	SPI0_STAT_TXUR_Pos = 0x3
	// Bit mask of TXUR field.
	SPI0_STAT_TXUR_Msk = 0x8
	// Bit TXUR.
	SPI0_STAT_TXUR = 0x8
	// Position of SSA field.
	SPI0_STAT_SSA_Pos = 0x4
	// Bit mask of SSA field.
	SPI0_STAT_SSA_Msk = 0x10
	// Bit SSA.
	SPI0_STAT_SSA = 0x10
	// Position of SSD field.
	SPI0_STAT_SSD_Pos = 0x5
	// Bit mask of SSD field.
	SPI0_STAT_SSD_Msk = 0x20
	// Bit SSD.
	SPI0_STAT_SSD = 0x20
	// Position of STALLED field.
	SPI0_STAT_STALLED_Pos = 0x6
	// Bit mask of STALLED field.
	SPI0_STAT_STALLED_Msk = 0x40
	// Bit STALLED.
	SPI0_STAT_STALLED = 0x40
	// Position of ENDTRANSFER field.
	SPI0_STAT_ENDTRANSFER_Pos = 0x7
	// Bit mask of ENDTRANSFER field.
	SPI0_STAT_ENDTRANSFER_Msk = 0x80
	// Bit ENDTRANSFER.
	SPI0_STAT_ENDTRANSFER = 0x80
	// Position of IDLE field.
	SPI0_STAT_IDLE_Pos = 0x8
	// Bit mask of IDLE field.
	SPI0_STAT_IDLE_Msk = 0x100
	// Bit IDLE.
	SPI0_STAT_IDLE = 0x100
	// Position of RESERVED field.
	SPI0_STAT_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	SPI0_STAT_RESERVED_Msk = 0xfffffe00

	// INTENSET: SPI Interrupt Enable read and Set. A complete value may be read from this register. Writing a 1 to any implemented bit position causes that bit to be set.
	// Position of RXRDYEN field.
	SPI0_INTENSET_RXRDYEN_Pos = 0x0
	// Bit mask of RXRDYEN field.
	SPI0_INTENSET_RXRDYEN_Msk = 0x1
	// Bit RXRDYEN.
	SPI0_INTENSET_RXRDYEN = 0x1
	// No interrupt will be generated when receiver data is available.
	SPI0_INTENSET_RXRDYEN_NO_INTERRUPT_WILL_BE = 0x0
	// An interrupt will be generated when receiver data is available in the RXDAT register.
	SPI0_INTENSET_RXRDYEN_AN_INTERRUPT_WILL_BE = 0x1
	// Position of TXRDYEN field.
	SPI0_INTENSET_TXRDYEN_Pos = 0x1
	// Bit mask of TXRDYEN field.
	SPI0_INTENSET_TXRDYEN_Msk = 0x2
	// Bit TXRDYEN.
	SPI0_INTENSET_TXRDYEN = 0x2
	// No interrupt will be generated when the transmitter holding register is available.
	SPI0_INTENSET_TXRDYEN_NO_INTERRUPT_WILL_BE = 0x0
	// An interrupt will be generated when data may be written to TXDAT.
	SPI0_INTENSET_TXRDYEN_AN_INTERRUPT_WILL_BE = 0x1
	// Position of RXOVEN field.
	SPI0_INTENSET_RXOVEN_Pos = 0x2
	// Bit mask of RXOVEN field.
	SPI0_INTENSET_RXOVEN_Msk = 0x4
	// Bit RXOVEN.
	SPI0_INTENSET_RXOVEN = 0x4
	// No interrupt will be generated when a receiver overrun occurs.
	SPI0_INTENSET_RXOVEN_NO_INTERRUPT_WILL_BE = 0x0
	// An interrupt will be generated if a receiver overrun occurs.
	SPI0_INTENSET_RXOVEN_AN_INTERRUPT_WILL_BE = 0x1
	// Position of TXUREN field.
	SPI0_INTENSET_TXUREN_Pos = 0x3
	// Bit mask of TXUREN field.
	SPI0_INTENSET_TXUREN_Msk = 0x8
	// Bit TXUREN.
	SPI0_INTENSET_TXUREN = 0x8
	// No interrupt will be generated when the transmitter underruns.
	SPI0_INTENSET_TXUREN_NO_INTERRUPT_WILL_BE = 0x0
	// An interrupt will be generated if the transmitter underruns.
	SPI0_INTENSET_TXUREN_AN_INTERRUPT_WILL_BE = 0x1
	// Position of SSAEN field.
	SPI0_INTENSET_SSAEN_Pos = 0x4
	// Bit mask of SSAEN field.
	SPI0_INTENSET_SSAEN_Msk = 0x10
	// Bit SSAEN.
	SPI0_INTENSET_SSAEN = 0x10
	// No interrupt will be generated when any Slave Select transitions from deasserted to asserted.
	SPI0_INTENSET_SSAEN_NO_INTERRUPT_WILL_BE = 0x0
	// An interrupt will be generated when any Slave Select transitions from deasserted to asserted.
	SPI0_INTENSET_SSAEN_AN_INTERRUPT_WILL_BE = 0x1
	// Position of SSDEN field.
	SPI0_INTENSET_SSDEN_Pos = 0x5
	// Bit mask of SSDEN field.
	SPI0_INTENSET_SSDEN_Msk = 0x20
	// Bit SSDEN.
	SPI0_INTENSET_SSDEN = 0x20
	// No interrupt will be generated when all asserted Slave Selects transition to deasserted.
	SPI0_INTENSET_SSDEN_NO_INTERRUPT_WILL_BE = 0x0
	// An interrupt will be generated when all asserted Slave Selects transition to deasserted.
	SPI0_INTENSET_SSDEN_AN_INTERRUPT_WILL_BE = 0x1
	// Position of RESERVED field.
	SPI0_INTENSET_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	SPI0_INTENSET_RESERVED_Msk = 0xffffffc0

	// INTENCLR: SPI Interrupt Enable Clear. Writing a 1 to any implemented bit position causes the corresponding bit in INTENSET to be cleared.
	// Position of RXRDYEN field.
	SPI0_INTENCLR_RXRDYEN_Pos = 0x0
	// Bit mask of RXRDYEN field.
	SPI0_INTENCLR_RXRDYEN_Msk = 0x1
	// Bit RXRDYEN.
	SPI0_INTENCLR_RXRDYEN = 0x1
	// Position of TXRDYEN field.
	SPI0_INTENCLR_TXRDYEN_Pos = 0x1
	// Bit mask of TXRDYEN field.
	SPI0_INTENCLR_TXRDYEN_Msk = 0x2
	// Bit TXRDYEN.
	SPI0_INTENCLR_TXRDYEN = 0x2
	// Position of RXOVEN field.
	SPI0_INTENCLR_RXOVEN_Pos = 0x2
	// Bit mask of RXOVEN field.
	SPI0_INTENCLR_RXOVEN_Msk = 0x4
	// Bit RXOVEN.
	SPI0_INTENCLR_RXOVEN = 0x4
	// Position of TXUREN field.
	SPI0_INTENCLR_TXUREN_Pos = 0x3
	// Bit mask of TXUREN field.
	SPI0_INTENCLR_TXUREN_Msk = 0x8
	// Bit TXUREN.
	SPI0_INTENCLR_TXUREN = 0x8
	// Position of SSAEN field.
	SPI0_INTENCLR_SSAEN_Pos = 0x4
	// Bit mask of SSAEN field.
	SPI0_INTENCLR_SSAEN_Msk = 0x10
	// Bit SSAEN.
	SPI0_INTENCLR_SSAEN = 0x10
	// Position of SSDEN field.
	SPI0_INTENCLR_SSDEN_Pos = 0x5
	// Bit mask of SSDEN field.
	SPI0_INTENCLR_SSDEN_Msk = 0x20
	// Bit SSDEN.
	SPI0_INTENCLR_SSDEN = 0x20
	// Position of RESERVED field.
	SPI0_INTENCLR_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	SPI0_INTENCLR_RESERVED_Msk = 0xffffffc0

	// RXDAT: SPI Receive Data
	// Position of RXDAT field.
	SPI0_RXDAT_RXDAT_Pos = 0x0
	// Bit mask of RXDAT field.
	SPI0_RXDAT_RXDAT_Msk = 0xffff
	// Position of RXSSEL0 field.
	SPI0_RXDAT_RXSSEL0_Pos = 0x10
	// Bit mask of RXSSEL0 field.
	SPI0_RXDAT_RXSSEL0_Msk = 0x10000
	// Bit RXSSEL0.
	SPI0_RXDAT_RXSSEL0 = 0x10000
	// Position of RXSSEL1 field.
	SPI0_RXDAT_RXSSEL1_Pos = 0x11
	// Bit mask of RXSSEL1 field.
	SPI0_RXDAT_RXSSEL1_Msk = 0x20000
	// Bit RXSSEL1.
	SPI0_RXDAT_RXSSEL1 = 0x20000
	// Position of RXSSEL2 field.
	SPI0_RXDAT_RXSSEL2_Pos = 0x12
	// Bit mask of RXSSEL2 field.
	SPI0_RXDAT_RXSSEL2_Msk = 0x40000
	// Bit RXSSEL2.
	SPI0_RXDAT_RXSSEL2 = 0x40000
	// Position of RXSSEL3 field.
	SPI0_RXDAT_RXSSEL3_Pos = 0x13
	// Bit mask of RXSSEL3 field.
	SPI0_RXDAT_RXSSEL3_Msk = 0x80000
	// Bit RXSSEL3.
	SPI0_RXDAT_RXSSEL3 = 0x80000
	// Position of SOT field.
	SPI0_RXDAT_SOT_Pos = 0x14
	// Bit mask of SOT field.
	SPI0_RXDAT_SOT_Msk = 0x100000
	// Bit SOT.
	SPI0_RXDAT_SOT = 0x100000
	// Position of RESERVED field.
	SPI0_RXDAT_RESERVED_Pos = 0x15
	// Bit mask of RESERVED field.
	SPI0_RXDAT_RESERVED_Msk = 0xffe00000

	// TXDATCTL: SPI Transmit Data with Control
	// Position of TXDAT field.
	SPI0_TXDATCTL_TXDAT_Pos = 0x0
	// Bit mask of TXDAT field.
	SPI0_TXDATCTL_TXDAT_Msk = 0xffff
	// Position of TXSSEL0 field.
	SPI0_TXDATCTL_TXSSEL0_Pos = 0x10
	// Bit mask of TXSSEL0 field.
	SPI0_TXDATCTL_TXSSEL0_Msk = 0x10000
	// Bit TXSSEL0.
	SPI0_TXDATCTL_TXSSEL0 = 0x10000
	// SSEL0 asserted.
	SPI0_TXDATCTL_TXSSEL0_SSEL0_ASSERTED = 0x0
	// SSEL0 not asserted.
	SPI0_TXDATCTL_TXSSEL0_SSEL0_NOT_ASSERTED = 0x1
	// Position of TXSSEL1 field.
	SPI0_TXDATCTL_TXSSEL1_Pos = 0x11
	// Bit mask of TXSSEL1 field.
	SPI0_TXDATCTL_TXSSEL1_Msk = 0x20000
	// Bit TXSSEL1.
	SPI0_TXDATCTL_TXSSEL1 = 0x20000
	// SSEL1 asserted.
	SPI0_TXDATCTL_TXSSEL1_SSEL1_ASSERTED = 0x0
	// SSEL1 not asserted.
	SPI0_TXDATCTL_TXSSEL1_SSEL1_NOT_ASSERTED = 0x1
	// Position of TXSSEL2 field.
	SPI0_TXDATCTL_TXSSEL2_Pos = 0x12
	// Bit mask of TXSSEL2 field.
	SPI0_TXDATCTL_TXSSEL2_Msk = 0x40000
	// Bit TXSSEL2.
	SPI0_TXDATCTL_TXSSEL2 = 0x40000
	// SSEL2 asserted.
	SPI0_TXDATCTL_TXSSEL2_SSEL2_ASSERTED = 0x0
	// SSEL2 not asserted.
	SPI0_TXDATCTL_TXSSEL2_SSEL2_NOT_ASSERTED = 0x1
	// Position of TXSSEL3 field.
	SPI0_TXDATCTL_TXSSEL3_Pos = 0x13
	// Bit mask of TXSSEL3 field.
	SPI0_TXDATCTL_TXSSEL3_Msk = 0x80000
	// Bit TXSSEL3.
	SPI0_TXDATCTL_TXSSEL3 = 0x80000
	// SSEL3 asserted.
	SPI0_TXDATCTL_TXSSEL3_SSEL3_ASSERTED = 0x0
	// SSEL3 not asserted.
	SPI0_TXDATCTL_TXSSEL3_SSEL3_NOT_ASSERTED = 0x1
	// Position of EOT field.
	SPI0_TXDATCTL_EOT_Pos = 0x14
	// Bit mask of EOT field.
	SPI0_TXDATCTL_EOT_Msk = 0x100000
	// Bit EOT.
	SPI0_TXDATCTL_EOT = 0x100000
	// SSEL not deasserted. This piece of data is not treated as the end of a transfer. SSEL will not be deasserted at the end of this data.
	SPI0_TXDATCTL_EOT_SSEL_NOT_DEASSERTED = 0x0
	// SSEL deasserted. This piece of data is treated as the end of a transfer. SSEL will be deasserted at the end of this piece of data.
	SPI0_TXDATCTL_EOT_SSEL_DEASSERTED = 0x1
	// Position of EOF field.
	SPI0_TXDATCTL_EOF_Pos = 0x15
	// Bit mask of EOF field.
	SPI0_TXDATCTL_EOF_Msk = 0x200000
	// Bit EOF.
	SPI0_TXDATCTL_EOF = 0x200000
	// Data not EOF. This piece of data transmitted is not treated as the end of a frame.
	SPI0_TXDATCTL_EOF_DATA_NOT_EOF = 0x0
	// Data EOF. This piece of data is treated as the end of a frame, causing the FRAME_DELAY time to be inserted before subsequent data is transmitted.
	SPI0_TXDATCTL_EOF_DATA_EOF = 0x1
	// Position of RXIGNORE field.
	SPI0_TXDATCTL_RXIGNORE_Pos = 0x16
	// Bit mask of RXIGNORE field.
	SPI0_TXDATCTL_RXIGNORE_Msk = 0x400000
	// Bit RXIGNORE.
	SPI0_TXDATCTL_RXIGNORE = 0x400000
	// Read received data. Received data must be read in order to allow transmission to progress. In slave mode, an overrun error will occur if received data is not read before new data is received.
	SPI0_TXDATCTL_RXIGNORE_READ_RECEIVED_DATA = 0x0
	// Ignore received data. Received data is ignored, allowing transmission without reading unneeded received data. No receiver flags are generated.
	SPI0_TXDATCTL_RXIGNORE_IGNORE_RECEIVED_DATA = 0x1
	// Position of RESERVED field.
	SPI0_TXDATCTL_RESERVED_Pos = 0x17
	// Bit mask of RESERVED field.
	SPI0_TXDATCTL_RESERVED_Msk = 0x800000
	// Bit RESERVED.
	SPI0_TXDATCTL_RESERVED = 0x800000
	// Position of FLEN field.
	SPI0_TXDATCTL_FLEN_Pos = 0x18
	// Bit mask of FLEN field.
	SPI0_TXDATCTL_FLEN_Msk = 0xf000000
	// Position of RESERVED field.
	SPI0_TXDATCTL_RESERVED_Pos = 0x1c
	// Bit mask of RESERVED field.
	SPI0_TXDATCTL_RESERVED_Msk = 0xf0000000

	// TXDAT: SPI Transmit Data with Control
	// Position of DATA field.
	SPI0_TXDAT_DATA_Pos = 0x0
	// Bit mask of DATA field.
	SPI0_TXDAT_DATA_Msk = 0xffff
	// Position of RESERVED field.
	SPI0_TXDAT_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	SPI0_TXDAT_RESERVED_Msk = 0xffff0000

	// TXCTL: SPI Transmit Control
	// Position of RESERVED field.
	SPI0_TXCTL_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	SPI0_TXCTL_RESERVED_Msk = 0xffff
	// Position of TXSSEL0 field.
	SPI0_TXCTL_TXSSEL0_Pos = 0x10
	// Bit mask of TXSSEL0 field.
	SPI0_TXCTL_TXSSEL0_Msk = 0x10000
	// Bit TXSSEL0.
	SPI0_TXCTL_TXSSEL0 = 0x10000
	// Position of TXSSEL1 field.
	SPI0_TXCTL_TXSSEL1_Pos = 0x11
	// Bit mask of TXSSEL1 field.
	SPI0_TXCTL_TXSSEL1_Msk = 0x20000
	// Bit TXSSEL1.
	SPI0_TXCTL_TXSSEL1 = 0x20000
	// Position of TXSSEL2 field.
	SPI0_TXCTL_TXSSEL2_Pos = 0x12
	// Bit mask of TXSSEL2 field.
	SPI0_TXCTL_TXSSEL2_Msk = 0x40000
	// Bit TXSSEL2.
	SPI0_TXCTL_TXSSEL2 = 0x40000
	// Position of TXSSEL3 field.
	SPI0_TXCTL_TXSSEL3_Pos = 0x13
	// Bit mask of TXSSEL3 field.
	SPI0_TXCTL_TXSSEL3_Msk = 0x80000
	// Bit TXSSEL3.
	SPI0_TXCTL_TXSSEL3 = 0x80000
	// Position of EOT field.
	SPI0_TXCTL_EOT_Pos = 0x14
	// Bit mask of EOT field.
	SPI0_TXCTL_EOT_Msk = 0x100000
	// Bit EOT.
	SPI0_TXCTL_EOT = 0x100000
	// Position of EOF field.
	SPI0_TXCTL_EOF_Pos = 0x15
	// Bit mask of EOF field.
	SPI0_TXCTL_EOF_Msk = 0x200000
	// Bit EOF.
	SPI0_TXCTL_EOF = 0x200000
	// Position of RXIGNORE field.
	SPI0_TXCTL_RXIGNORE_Pos = 0x16
	// Bit mask of RXIGNORE field.
	SPI0_TXCTL_RXIGNORE_Msk = 0x400000
	// Bit RXIGNORE.
	SPI0_TXCTL_RXIGNORE = 0x400000
	// Position of RESERVED field.
	SPI0_TXCTL_RESERVED_Pos = 0x17
	// Bit mask of RESERVED field.
	SPI0_TXCTL_RESERVED_Msk = 0x800000
	// Bit RESERVED.
	SPI0_TXCTL_RESERVED = 0x800000
	// Position of FLEN field.
	SPI0_TXCTL_FLEN_Pos = 0x18
	// Bit mask of FLEN field.
	SPI0_TXCTL_FLEN_Msk = 0xf000000
	// Position of RESERVED field.
	SPI0_TXCTL_RESERVED_Pos = 0x1c
	// Bit mask of RESERVED field.
	SPI0_TXCTL_RESERVED_Msk = 0xf0000000

	// DIV: SPI clock Divider
	// Position of DIVVAL field.
	SPI0_DIV_DIVVAL_Pos = 0x0
	// Bit mask of DIVVAL field.
	SPI0_DIV_DIVVAL_Msk = 0xffff
	// Position of RESERVED field.
	SPI0_DIV_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	SPI0_DIV_RESERVED_Msk = 0xffff0000

	// INTSTAT: SPI Interrupt Status
	// Position of RXRDY field.
	SPI0_INTSTAT_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	SPI0_INTSTAT_RXRDY_Msk = 0x1
	// Bit RXRDY.
	SPI0_INTSTAT_RXRDY = 0x1
	// Position of TXRDY field.
	SPI0_INTSTAT_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	SPI0_INTSTAT_TXRDY_Msk = 0x2
	// Bit TXRDY.
	SPI0_INTSTAT_TXRDY = 0x2
	// Position of RXOV field.
	SPI0_INTSTAT_RXOV_Pos = 0x2
	// Bit mask of RXOV field.
	SPI0_INTSTAT_RXOV_Msk = 0x4
	// Bit RXOV.
	SPI0_INTSTAT_RXOV = 0x4
	// Position of TXUR field.
	SPI0_INTSTAT_TXUR_Pos = 0x3
	// Bit mask of TXUR field.
	SPI0_INTSTAT_TXUR_Msk = 0x8
	// Bit TXUR.
	SPI0_INTSTAT_TXUR = 0x8
	// Position of SSA field.
	SPI0_INTSTAT_SSA_Pos = 0x4
	// Bit mask of SSA field.
	SPI0_INTSTAT_SSA_Msk = 0x10
	// Bit SSA.
	SPI0_INTSTAT_SSA = 0x10
	// Position of SSD field.
	SPI0_INTSTAT_SSD_Pos = 0x5
	// Bit mask of SSD field.
	SPI0_INTSTAT_SSD_Msk = 0x20
	// Bit SSD.
	SPI0_INTSTAT_SSD = 0x20
	// Position of RESERVED field.
	SPI0_INTSTAT_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	SPI0_INTSTAT_RESERVED_Msk = 0xffffffc0
)

// Bitfields for I2C0: I2C-bus interface
const (
	// CFG: Configuration for shared functions.
	// Position of MSTEN field.
	I2C0_CFG_MSTEN_Pos = 0x0
	// Bit mask of MSTEN field.
	I2C0_CFG_MSTEN_Msk = 0x1
	// Bit MSTEN.
	I2C0_CFG_MSTEN = 0x1
	// Disabled. The I2C Master function is disabled.
	I2C0_CFG_MSTEN_DISABLED = 0x0
	// Enabled. The I2C Master function is enabled.
	I2C0_CFG_MSTEN_ENABLED = 0x1
	// Position of SLVEN field.
	I2C0_CFG_SLVEN_Pos = 0x1
	// Bit mask of SLVEN field.
	I2C0_CFG_SLVEN_Msk = 0x2
	// Bit SLVEN.
	I2C0_CFG_SLVEN = 0x2
	// Disabled. The I2C slave function is disabled.
	I2C0_CFG_SLVEN_DISABLED = 0x0
	// Enabled. The I2C slave function is enabled.
	I2C0_CFG_SLVEN_ENABLED = 0x1
	// Position of MONEN field.
	I2C0_CFG_MONEN_Pos = 0x2
	// Bit mask of MONEN field.
	I2C0_CFG_MONEN_Msk = 0x4
	// Bit MONEN.
	I2C0_CFG_MONEN = 0x4
	// Disabled. The I2C monitor function is disabled.
	I2C0_CFG_MONEN_DISABLED = 0x0
	// Enabled. The I2C monitor function is enabled.
	I2C0_CFG_MONEN_ENABLED = 0x1
	// Position of TIMEOUTEN field.
	I2C0_CFG_TIMEOUTEN_Pos = 0x3
	// Bit mask of TIMEOUTEN field.
	I2C0_CFG_TIMEOUTEN_Msk = 0x8
	// Bit TIMEOUTEN.
	I2C0_CFG_TIMEOUTEN = 0x8
	// Disabled. Time-out function is disabled.
	I2C0_CFG_TIMEOUTEN_DISABLED = 0x0
	// Enabled. Time-out function is enabled. Both types of time-out flags will be generated and will cause interrupts if they are enabled. Typically, only one time-out will be used in a system.
	I2C0_CFG_TIMEOUTEN_ENABLED = 0x1
	// Position of MONCLKSTR field.
	I2C0_CFG_MONCLKSTR_Pos = 0x4
	// Bit mask of MONCLKSTR field.
	I2C0_CFG_MONCLKSTR_Msk = 0x10
	// Bit MONCLKSTR.
	I2C0_CFG_MONCLKSTR = 0x10
	// Disabled. The monitor function will not perform clock stretching. Software or DMA may not always be able to read data provided by the monitor function before it is overwritten. This mode may be used when non-invasive monitoring is critical.
	I2C0_CFG_MONCLKSTR_DISABLED = 0x0
	// Enabled. The monitor function will perform clock stretching in order to ensure that software or DMA can read all incoming data supplied by the monitor function.
	I2C0_CFG_MONCLKSTR_ENABLED = 0x1
	// Position of RESERVED field.
	I2C0_CFG_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	I2C0_CFG_RESERVED_Msk = 0xffffffe0

	// STAT: Status register for Master, Slave, and Monitor functions.
	// Position of MSTPENDING field.
	I2C0_STAT_MSTPENDING_Pos = 0x0
	// Bit mask of MSTPENDING field.
	I2C0_STAT_MSTPENDING_Msk = 0x1
	// Bit MSTPENDING.
	I2C0_STAT_MSTPENDING = 0x1
	// In progress. Communication is in progress and the Master function is busy and cannot currently accept a command.
	I2C0_STAT_MSTPENDING_IN_PROGRESS = 0x0
	// Pending. The Master function needs software service or is in the idle state. If the master is not in the idle state, it is waiting to receive or transmit data or the NACK bit.
	I2C0_STAT_MSTPENDING_PENDING = 0x1
	// Position of MSTSTATE field.
	I2C0_STAT_MSTSTATE_Pos = 0x1
	// Bit mask of MSTSTATE field.
	I2C0_STAT_MSTSTATE_Msk = 0xe
	// Idle. The Master function is available to be used for a new transaction.
	I2C0_STAT_MSTSTATE_IDLE = 0x0
	// Receive ready. Received data available (Master Receiver mode). Address plus Read was previously sent and Acknowledged by slave.
	I2C0_STAT_MSTSTATE_RECEIVE_READY = 0x1
	// Transmit ready. Data can be transmitted (Master Transmitter mode). Address plus Write was previously sent and Acknowledged by slave.
	I2C0_STAT_MSTSTATE_TRANSMIT_READY = 0x2
	// NACK Address. Slave NACKed address.
	I2C0_STAT_MSTSTATE_NACK_ADDRESS = 0x3
	// NACK Data. Slave NACKed transmitted data.
	I2C0_STAT_MSTSTATE_NACK_DATA = 0x4
	// Position of MSTARBLOSS field.
	I2C0_STAT_MSTARBLOSS_Pos = 0x4
	// Bit mask of MSTARBLOSS field.
	I2C0_STAT_MSTARBLOSS_Msk = 0x10
	// Bit MSTARBLOSS.
	I2C0_STAT_MSTARBLOSS = 0x10
	// No loss. No Arbitration Loss has occurred.
	I2C0_STAT_MSTARBLOSS_NO_LOSS = 0x0
	// Arbitration loss. The Master function has experienced an Arbitration Loss. At this point, the Master function has already stopped driving the bus and gone to an idle state. Software can respond by doing nothing, or by sending a Start in order to attempt to gain control of the bus when it next becomes idle.
	I2C0_STAT_MSTARBLOSS_ARBITRATION_LOSS = 0x1
	// Position of RESERVED field.
	I2C0_STAT_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	I2C0_STAT_RESERVED_Msk = 0x20
	// Bit RESERVED.
	I2C0_STAT_RESERVED = 0x20
	// Position of MSTSTSTPERR field.
	I2C0_STAT_MSTSTSTPERR_Pos = 0x6
	// Bit mask of MSTSTSTPERR field.
	I2C0_STAT_MSTSTSTPERR_Msk = 0x40
	// Bit MSTSTSTPERR.
	I2C0_STAT_MSTSTSTPERR = 0x40
	// No Start/Stop Error has occurred.
	I2C0_STAT_MSTSTSTPERR_NO_STARTSTOP_ERROR = 0x0
	// Start/stop error has occurred. The Master function has experienced a Start/Stop Error. A Start or Stop was detected at a time when it is not allowed by the I2C specification. The Master interface has stopped driving the bus and gone to an idle state, no action is required. A request for a Start could be made, or software could attempt to insure that the bus has not stalled.
	I2C0_STAT_MSTSTSTPERR_STARTSTOP_ERROR_HAS = 0x1
	// Position of RESERVED field.
	I2C0_STAT_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	I2C0_STAT_RESERVED_Msk = 0x80
	// Bit RESERVED.
	I2C0_STAT_RESERVED = 0x80
	// Position of SLVPENDING field.
	I2C0_STAT_SLVPENDING_Pos = 0x8
	// Bit mask of SLVPENDING field.
	I2C0_STAT_SLVPENDING_Msk = 0x100
	// Bit SLVPENDING.
	I2C0_STAT_SLVPENDING = 0x100
	// In progress. The Slave function does not currently need service.
	I2C0_STAT_SLVPENDING_IN_PROGRESS = 0x0
	// Pending. The Slave function needs service. Information on what is needed can be found in the adjacent SLVSTATE field.
	I2C0_STAT_SLVPENDING_PENDING = 0x1
	// Position of SLVSTATE field.
	I2C0_STAT_SLVSTATE_Pos = 0x9
	// Bit mask of SLVSTATE field.
	I2C0_STAT_SLVSTATE_Msk = 0x600
	// Slave address. Address plus R/W received. At least one of the four slave addresses has been matched by hardware.
	I2C0_STAT_SLVSTATE_SLAVE_ADDRESS = 0x0
	// Slave receive. Received data is available (Slave Receiver mode).
	I2C0_STAT_SLVSTATE_SLAVE_RECEIVE = 0x1
	// Slave transmit. Data can be transmitted (Slave Transmitter mode).
	I2C0_STAT_SLVSTATE_SLAVE_TRANSMIT = 0x2
	// Position of SLVNOTSTR field.
	I2C0_STAT_SLVNOTSTR_Pos = 0xb
	// Bit mask of SLVNOTSTR field.
	I2C0_STAT_SLVNOTSTR_Msk = 0x800
	// Bit SLVNOTSTR.
	I2C0_STAT_SLVNOTSTR = 0x800
	// Stretching. The slave function is currently stretching the I2C bus clock. Deep-Sleep or Power-down mode cannot be entered at this time.
	I2C0_STAT_SLVNOTSTR_STRETCHING = 0x0
	// Not stretching. The slave function is not currently stretching the I2C bus clock. Deep-sleep or Power-down mode could be entered at this time.
	I2C0_STAT_SLVNOTSTR_NOT_STRETCHING = 0x1
	// Position of SLVIDX field.
	I2C0_STAT_SLVIDX_Pos = 0xc
	// Bit mask of SLVIDX field.
	I2C0_STAT_SLVIDX_Msk = 0x3000
	// Slave address 0 was matched.
	I2C0_STAT_SLVIDX_SLAVE_ADDRESS_0_WAS = 0x0
	// Slave address 1 was matched.
	I2C0_STAT_SLVIDX_SLAVE_ADDRESS_1_WAS = 0x1
	// Slave address 2 was matched.
	I2C0_STAT_SLVIDX_SLAVE_ADDRESS_2_WAS = 0x2
	// Slave address 3 was matched.
	I2C0_STAT_SLVIDX_SLAVE_ADDRESS_3_WAS = 0x3
	// Position of SLVSEL field.
	I2C0_STAT_SLVSEL_Pos = 0xe
	// Bit mask of SLVSEL field.
	I2C0_STAT_SLVSEL_Msk = 0x4000
	// Bit SLVSEL.
	I2C0_STAT_SLVSEL = 0x4000
	// Not selected. The Slave function is not currently selected.
	I2C0_STAT_SLVSEL_NOT_SELECTED = 0x0
	// Selected. The Slave function is currently selected.
	I2C0_STAT_SLVSEL_SELECTED = 0x1
	// Position of SLVDESEL field.
	I2C0_STAT_SLVDESEL_Pos = 0xf
	// Bit mask of SLVDESEL field.
	I2C0_STAT_SLVDESEL_Msk = 0x8000
	// Bit SLVDESEL.
	I2C0_STAT_SLVDESEL = 0x8000
	// Not deselected. The Slave function has not become deselected. This does not mean that it is currently selected. That information can be found in the SLVSEL flag.
	I2C0_STAT_SLVDESEL_NOT_DESELECTED = 0x0
	// Deselected. The Slave function has become deselected. This is specifically caused by the SLVSEL flag changing from 1 to 0. See the description of SLVSEL for details on when that event occurs.
	I2C0_STAT_SLVDESEL_DESELECTED = 0x1
	// Position of MONRDY field.
	I2C0_STAT_MONRDY_Pos = 0x10
	// Bit mask of MONRDY field.
	I2C0_STAT_MONRDY_Msk = 0x10000
	// Bit MONRDY.
	I2C0_STAT_MONRDY = 0x10000
	// No data. The Monitor function does not currently have data available.
	I2C0_STAT_MONRDY_NO_DATA = 0x0
	// Data waiting. The Monitor function has data waiting to be read.
	I2C0_STAT_MONRDY_DATA_WAITING = 0x1
	// Position of MONOV field.
	I2C0_STAT_MONOV_Pos = 0x11
	// Bit mask of MONOV field.
	I2C0_STAT_MONOV_Msk = 0x20000
	// Bit MONOV.
	I2C0_STAT_MONOV = 0x20000
	// No overrun. Monitor data has not overrun.
	I2C0_STAT_MONOV_NO_OVERRUN = 0x0
	// Overrun. A Monitor data overrun has occurred. This can only happen when Monitor clock stretching not enabled via the MONCLKSTR bit in the CFG register. Writing 1 to this bit clears the flag.
	I2C0_STAT_MONOV_OVERRUN = 0x1
	// Position of MONACTIVE field.
	I2C0_STAT_MONACTIVE_Pos = 0x12
	// Bit mask of MONACTIVE field.
	I2C0_STAT_MONACTIVE_Msk = 0x40000
	// Bit MONACTIVE.
	I2C0_STAT_MONACTIVE = 0x40000
	// Inactive. The Monitor function considers the I2C bus to be inactive.
	I2C0_STAT_MONACTIVE_INACTIVE = 0x0
	// Active. The Monitor function considers the I2C bus to be active.
	I2C0_STAT_MONACTIVE_ACTIVE = 0x1
	// Position of MONIDLE field.
	I2C0_STAT_MONIDLE_Pos = 0x13
	// Bit mask of MONIDLE field.
	I2C0_STAT_MONIDLE_Msk = 0x80000
	// Bit MONIDLE.
	I2C0_STAT_MONIDLE = 0x80000
	// Not idle. The I2C bus is not idle, or this flag has been cleared by software.
	I2C0_STAT_MONIDLE_NOT_IDLE = 0x0
	// Idle. The I2C bus has gone idle at least once since the last time this flag was cleared by software.
	I2C0_STAT_MONIDLE_IDLE = 0x1
	// Position of RESERVED field.
	I2C0_STAT_RESERVED_Pos = 0x14
	// Bit mask of RESERVED field.
	I2C0_STAT_RESERVED_Msk = 0xf00000
	// Position of EVENTTIMEOUT field.
	I2C0_STAT_EVENTTIMEOUT_Pos = 0x18
	// Bit mask of EVENTTIMEOUT field.
	I2C0_STAT_EVENTTIMEOUT_Msk = 0x1000000
	// Bit EVENTTIMEOUT.
	I2C0_STAT_EVENTTIMEOUT = 0x1000000
	// No time-out. I2C bus events have not caused a time-out.
	I2C0_STAT_EVENTTIMEOUT_NO_TIME_OUT = 0x0
	// Event time-out. The time between I2C bus events has been longer than the time specified by the I2C TIMEOUT register.
	I2C0_STAT_EVENTTIMEOUT_EVENT_TIME_OUT = 0x1
	// Position of SCLTIMEOUT field.
	I2C0_STAT_SCLTIMEOUT_Pos = 0x19
	// Bit mask of SCLTIMEOUT field.
	I2C0_STAT_SCLTIMEOUT_Msk = 0x2000000
	// Bit SCLTIMEOUT.
	I2C0_STAT_SCLTIMEOUT = 0x2000000
	// No time-out. SCL low time has not caused a time-out.
	I2C0_STAT_SCLTIMEOUT_NO_TIME_OUT = 0x0
	// Time-out. SCL low time has caused a time-out.
	I2C0_STAT_SCLTIMEOUT_TIME_OUT = 0x1
	// Position of RESERVED field.
	I2C0_STAT_RESERVED_Pos = 0x1a
	// Bit mask of RESERVED field.
	I2C0_STAT_RESERVED_Msk = 0xfc000000

	// INTENSET: Interrupt Enable Set and read register.
	// Position of MSTPENDINGEN field.
	I2C0_INTENSET_MSTPENDINGEN_Pos = 0x0
	// Bit mask of MSTPENDINGEN field.
	I2C0_INTENSET_MSTPENDINGEN_Msk = 0x1
	// Bit MSTPENDINGEN.
	I2C0_INTENSET_MSTPENDINGEN = 0x1
	// Position of RESERVED field.
	I2C0_INTENSET_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	I2C0_INTENSET_RESERVED_Msk = 0xe
	// Position of MSTARBLOSSEN field.
	I2C0_INTENSET_MSTARBLOSSEN_Pos = 0x4
	// Bit mask of MSTARBLOSSEN field.
	I2C0_INTENSET_MSTARBLOSSEN_Msk = 0x10
	// Bit MSTARBLOSSEN.
	I2C0_INTENSET_MSTARBLOSSEN = 0x10
	// Position of RESERVED field.
	I2C0_INTENSET_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	I2C0_INTENSET_RESERVED_Msk = 0x20
	// Bit RESERVED.
	I2C0_INTENSET_RESERVED = 0x20
	// Position of MSTSTSTPERREN field.
	I2C0_INTENSET_MSTSTSTPERREN_Pos = 0x6
	// Bit mask of MSTSTSTPERREN field.
	I2C0_INTENSET_MSTSTSTPERREN_Msk = 0x40
	// Bit MSTSTSTPERREN.
	I2C0_INTENSET_MSTSTSTPERREN = 0x40
	// Position of RESERVED field.
	I2C0_INTENSET_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	I2C0_INTENSET_RESERVED_Msk = 0x80
	// Bit RESERVED.
	I2C0_INTENSET_RESERVED = 0x80
	// Position of SLVPENDINGEN field.
	I2C0_INTENSET_SLVPENDINGEN_Pos = 0x8
	// Bit mask of SLVPENDINGEN field.
	I2C0_INTENSET_SLVPENDINGEN_Msk = 0x100
	// Bit SLVPENDINGEN.
	I2C0_INTENSET_SLVPENDINGEN = 0x100
	// Position of RESERVED field.
	I2C0_INTENSET_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	I2C0_INTENSET_RESERVED_Msk = 0x600
	// Position of SLVNOTSTREN field.
	I2C0_INTENSET_SLVNOTSTREN_Pos = 0xb
	// Bit mask of SLVNOTSTREN field.
	I2C0_INTENSET_SLVNOTSTREN_Msk = 0x800
	// Bit SLVNOTSTREN.
	I2C0_INTENSET_SLVNOTSTREN = 0x800
	// Position of RESERVED field.
	I2C0_INTENSET_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	I2C0_INTENSET_RESERVED_Msk = 0x7000
	// Position of SLVDESELEN field.
	I2C0_INTENSET_SLVDESELEN_Pos = 0xf
	// Bit mask of SLVDESELEN field.
	I2C0_INTENSET_SLVDESELEN_Msk = 0x8000
	// Bit SLVDESELEN.
	I2C0_INTENSET_SLVDESELEN = 0x8000
	// Position of MONRDYEN field.
	I2C0_INTENSET_MONRDYEN_Pos = 0x10
	// Bit mask of MONRDYEN field.
	I2C0_INTENSET_MONRDYEN_Msk = 0x10000
	// Bit MONRDYEN.
	I2C0_INTENSET_MONRDYEN = 0x10000
	// Position of MONOVEN field.
	I2C0_INTENSET_MONOVEN_Pos = 0x11
	// Bit mask of MONOVEN field.
	I2C0_INTENSET_MONOVEN_Msk = 0x20000
	// Bit MONOVEN.
	I2C0_INTENSET_MONOVEN = 0x20000
	// Position of RESERVED field.
	I2C0_INTENSET_RESERVED_Pos = 0x12
	// Bit mask of RESERVED field.
	I2C0_INTENSET_RESERVED_Msk = 0x40000
	// Bit RESERVED.
	I2C0_INTENSET_RESERVED = 0x40000
	// Position of MONIDLEEN field.
	I2C0_INTENSET_MONIDLEEN_Pos = 0x13
	// Bit mask of MONIDLEEN field.
	I2C0_INTENSET_MONIDLEEN_Msk = 0x80000
	// Bit MONIDLEEN.
	I2C0_INTENSET_MONIDLEEN = 0x80000
	// Position of RESERVED field.
	I2C0_INTENSET_RESERVED_Pos = 0x14
	// Bit mask of RESERVED field.
	I2C0_INTENSET_RESERVED_Msk = 0xf00000
	// Position of EVENTTIMEOUTEN field.
	I2C0_INTENSET_EVENTTIMEOUTEN_Pos = 0x18
	// Bit mask of EVENTTIMEOUTEN field.
	I2C0_INTENSET_EVENTTIMEOUTEN_Msk = 0x1000000
	// Bit EVENTTIMEOUTEN.
	I2C0_INTENSET_EVENTTIMEOUTEN = 0x1000000
	// Position of SCLTIMEOUTEN field.
	I2C0_INTENSET_SCLTIMEOUTEN_Pos = 0x19
	// Bit mask of SCLTIMEOUTEN field.
	I2C0_INTENSET_SCLTIMEOUTEN_Msk = 0x2000000
	// Bit SCLTIMEOUTEN.
	I2C0_INTENSET_SCLTIMEOUTEN = 0x2000000
	// Position of RESERVED field.
	I2C0_INTENSET_RESERVED_Pos = 0x1a
	// Bit mask of RESERVED field.
	I2C0_INTENSET_RESERVED_Msk = 0xfc000000

	// INTENCLR: Interrupt Enable Clear register.
	// Position of MSTPENDINGCLR field.
	I2C0_INTENCLR_MSTPENDINGCLR_Pos = 0x0
	// Bit mask of MSTPENDINGCLR field.
	I2C0_INTENCLR_MSTPENDINGCLR_Msk = 0x1
	// Bit MSTPENDINGCLR.
	I2C0_INTENCLR_MSTPENDINGCLR = 0x1
	// Position of RESERVED field.
	I2C0_INTENCLR_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	I2C0_INTENCLR_RESERVED_Msk = 0xe
	// Position of MSTARBLOSSCLR field.
	I2C0_INTENCLR_MSTARBLOSSCLR_Pos = 0x4
	// Bit mask of MSTARBLOSSCLR field.
	I2C0_INTENCLR_MSTARBLOSSCLR_Msk = 0x10
	// Bit MSTARBLOSSCLR.
	I2C0_INTENCLR_MSTARBLOSSCLR = 0x10
	// Position of RESERVED field.
	I2C0_INTENCLR_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	I2C0_INTENCLR_RESERVED_Msk = 0x20
	// Bit RESERVED.
	I2C0_INTENCLR_RESERVED = 0x20
	// Position of MSTSTSTPERRCLR field.
	I2C0_INTENCLR_MSTSTSTPERRCLR_Pos = 0x6
	// Bit mask of MSTSTSTPERRCLR field.
	I2C0_INTENCLR_MSTSTSTPERRCLR_Msk = 0x40
	// Bit MSTSTSTPERRCLR.
	I2C0_INTENCLR_MSTSTSTPERRCLR = 0x40
	// Position of RESERVED field.
	I2C0_INTENCLR_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	I2C0_INTENCLR_RESERVED_Msk = 0x80
	// Bit RESERVED.
	I2C0_INTENCLR_RESERVED = 0x80
	// Position of SLVPENDINGCLR field.
	I2C0_INTENCLR_SLVPENDINGCLR_Pos = 0x8
	// Bit mask of SLVPENDINGCLR field.
	I2C0_INTENCLR_SLVPENDINGCLR_Msk = 0x100
	// Bit SLVPENDINGCLR.
	I2C0_INTENCLR_SLVPENDINGCLR = 0x100
	// Position of RESERVED field.
	I2C0_INTENCLR_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	I2C0_INTENCLR_RESERVED_Msk = 0x600
	// Position of SLVNOTSTRCLR field.
	I2C0_INTENCLR_SLVNOTSTRCLR_Pos = 0xb
	// Bit mask of SLVNOTSTRCLR field.
	I2C0_INTENCLR_SLVNOTSTRCLR_Msk = 0x800
	// Bit SLVNOTSTRCLR.
	I2C0_INTENCLR_SLVNOTSTRCLR = 0x800
	// Position of RESERVED field.
	I2C0_INTENCLR_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	I2C0_INTENCLR_RESERVED_Msk = 0x7000
	// Position of SLVDESELCLR field.
	I2C0_INTENCLR_SLVDESELCLR_Pos = 0xf
	// Bit mask of SLVDESELCLR field.
	I2C0_INTENCLR_SLVDESELCLR_Msk = 0x8000
	// Bit SLVDESELCLR.
	I2C0_INTENCLR_SLVDESELCLR = 0x8000
	// Position of MONRDYCLR field.
	I2C0_INTENCLR_MONRDYCLR_Pos = 0x10
	// Bit mask of MONRDYCLR field.
	I2C0_INTENCLR_MONRDYCLR_Msk = 0x10000
	// Bit MONRDYCLR.
	I2C0_INTENCLR_MONRDYCLR = 0x10000
	// Position of MONOVCLR field.
	I2C0_INTENCLR_MONOVCLR_Pos = 0x11
	// Bit mask of MONOVCLR field.
	I2C0_INTENCLR_MONOVCLR_Msk = 0x20000
	// Bit MONOVCLR.
	I2C0_INTENCLR_MONOVCLR = 0x20000
	// Position of RESERVED field.
	I2C0_INTENCLR_RESERVED_Pos = 0x12
	// Bit mask of RESERVED field.
	I2C0_INTENCLR_RESERVED_Msk = 0x40000
	// Bit RESERVED.
	I2C0_INTENCLR_RESERVED = 0x40000
	// Position of MONIDLECLR field.
	I2C0_INTENCLR_MONIDLECLR_Pos = 0x13
	// Bit mask of MONIDLECLR field.
	I2C0_INTENCLR_MONIDLECLR_Msk = 0x80000
	// Bit MONIDLECLR.
	I2C0_INTENCLR_MONIDLECLR = 0x80000
	// Position of RESERVED field.
	I2C0_INTENCLR_RESERVED_Pos = 0x14
	// Bit mask of RESERVED field.
	I2C0_INTENCLR_RESERVED_Msk = 0xf00000
	// Position of EVENTTIMEOUTCLR field.
	I2C0_INTENCLR_EVENTTIMEOUTCLR_Pos = 0x18
	// Bit mask of EVENTTIMEOUTCLR field.
	I2C0_INTENCLR_EVENTTIMEOUTCLR_Msk = 0x1000000
	// Bit EVENTTIMEOUTCLR.
	I2C0_INTENCLR_EVENTTIMEOUTCLR = 0x1000000
	// Position of SCLTIMEOUTCLR field.
	I2C0_INTENCLR_SCLTIMEOUTCLR_Pos = 0x19
	// Bit mask of SCLTIMEOUTCLR field.
	I2C0_INTENCLR_SCLTIMEOUTCLR_Msk = 0x2000000
	// Bit SCLTIMEOUTCLR.
	I2C0_INTENCLR_SCLTIMEOUTCLR = 0x2000000
	// Position of RESERVED field.
	I2C0_INTENCLR_RESERVED_Pos = 0x1a
	// Bit mask of RESERVED field.
	I2C0_INTENCLR_RESERVED_Msk = 0xfc000000

	// TIMEOUT: Time-out value register.
	// Position of TOMIN field.
	I2C0_TIMEOUT_TOMIN_Pos = 0x0
	// Bit mask of TOMIN field.
	I2C0_TIMEOUT_TOMIN_Msk = 0xf
	// Position of TO field.
	I2C0_TIMEOUT_TO_Pos = 0x4
	// Bit mask of TO field.
	I2C0_TIMEOUT_TO_Msk = 0xfff0
	// Position of RESERVED field.
	I2C0_TIMEOUT_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	I2C0_TIMEOUT_RESERVED_Msk = 0xffff0000

	// CLKDIV: Clock pre-divider for the entire I2C block. This determines what time increments are used for the MSTTIME and SLVTIME registers.
	// Position of DIVVAL field.
	I2C0_CLKDIV_DIVVAL_Pos = 0x0
	// Bit mask of DIVVAL field.
	I2C0_CLKDIV_DIVVAL_Msk = 0xffff
	// Position of RESERVED field.
	I2C0_CLKDIV_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	I2C0_CLKDIV_RESERVED_Msk = 0xffff0000

	// INTSTAT: Interrupt Status register for Master, Slave, and Monitor functions.
	// Position of MSTPENDING field.
	I2C0_INTSTAT_MSTPENDING_Pos = 0x0
	// Bit mask of MSTPENDING field.
	I2C0_INTSTAT_MSTPENDING_Msk = 0x1
	// Bit MSTPENDING.
	I2C0_INTSTAT_MSTPENDING = 0x1
	// Position of RESERVED field.
	I2C0_INTSTAT_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	I2C0_INTSTAT_RESERVED_Msk = 0xe
	// Position of MSTARBLOSS field.
	I2C0_INTSTAT_MSTARBLOSS_Pos = 0x4
	// Bit mask of MSTARBLOSS field.
	I2C0_INTSTAT_MSTARBLOSS_Msk = 0x10
	// Bit MSTARBLOSS.
	I2C0_INTSTAT_MSTARBLOSS = 0x10
	// Position of RESERVED field.
	I2C0_INTSTAT_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	I2C0_INTSTAT_RESERVED_Msk = 0x20
	// Bit RESERVED.
	I2C0_INTSTAT_RESERVED = 0x20
	// Position of MSTSTSTPERR field.
	I2C0_INTSTAT_MSTSTSTPERR_Pos = 0x6
	// Bit mask of MSTSTSTPERR field.
	I2C0_INTSTAT_MSTSTSTPERR_Msk = 0x40
	// Bit MSTSTSTPERR.
	I2C0_INTSTAT_MSTSTSTPERR = 0x40
	// Position of RESERVED field.
	I2C0_INTSTAT_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	I2C0_INTSTAT_RESERVED_Msk = 0x80
	// Bit RESERVED.
	I2C0_INTSTAT_RESERVED = 0x80
	// Position of SLVPENDING field.
	I2C0_INTSTAT_SLVPENDING_Pos = 0x8
	// Bit mask of SLVPENDING field.
	I2C0_INTSTAT_SLVPENDING_Msk = 0x100
	// Bit SLVPENDING.
	I2C0_INTSTAT_SLVPENDING = 0x100
	// Position of RESERVED field.
	I2C0_INTSTAT_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	I2C0_INTSTAT_RESERVED_Msk = 0x600
	// Position of SLVNOTSTR field.
	I2C0_INTSTAT_SLVNOTSTR_Pos = 0xb
	// Bit mask of SLVNOTSTR field.
	I2C0_INTSTAT_SLVNOTSTR_Msk = 0x800
	// Bit SLVNOTSTR.
	I2C0_INTSTAT_SLVNOTSTR = 0x800
	// Position of RESERVED field.
	I2C0_INTSTAT_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	I2C0_INTSTAT_RESERVED_Msk = 0x7000
	// Position of SLVDESEL field.
	I2C0_INTSTAT_SLVDESEL_Pos = 0xf
	// Bit mask of SLVDESEL field.
	I2C0_INTSTAT_SLVDESEL_Msk = 0x8000
	// Bit SLVDESEL.
	I2C0_INTSTAT_SLVDESEL = 0x8000
	// Position of MONRDY field.
	I2C0_INTSTAT_MONRDY_Pos = 0x10
	// Bit mask of MONRDY field.
	I2C0_INTSTAT_MONRDY_Msk = 0x10000
	// Bit MONRDY.
	I2C0_INTSTAT_MONRDY = 0x10000
	// Position of MONOV field.
	I2C0_INTSTAT_MONOV_Pos = 0x11
	// Bit mask of MONOV field.
	I2C0_INTSTAT_MONOV_Msk = 0x20000
	// Bit MONOV.
	I2C0_INTSTAT_MONOV = 0x20000
	// Position of RESERVED field.
	I2C0_INTSTAT_RESERVED_Pos = 0x12
	// Bit mask of RESERVED field.
	I2C0_INTSTAT_RESERVED_Msk = 0x40000
	// Bit RESERVED.
	I2C0_INTSTAT_RESERVED = 0x40000
	// Position of MONIDLE field.
	I2C0_INTSTAT_MONIDLE_Pos = 0x13
	// Bit mask of MONIDLE field.
	I2C0_INTSTAT_MONIDLE_Msk = 0x80000
	// Bit MONIDLE.
	I2C0_INTSTAT_MONIDLE = 0x80000
	// Position of RESERVED field.
	I2C0_INTSTAT_RESERVED_Pos = 0x14
	// Bit mask of RESERVED field.
	I2C0_INTSTAT_RESERVED_Msk = 0xf00000
	// Position of EVENTTIMEOUT field.
	I2C0_INTSTAT_EVENTTIMEOUT_Pos = 0x18
	// Bit mask of EVENTTIMEOUT field.
	I2C0_INTSTAT_EVENTTIMEOUT_Msk = 0x1000000
	// Bit EVENTTIMEOUT.
	I2C0_INTSTAT_EVENTTIMEOUT = 0x1000000
	// Position of SCLTIMEOUT field.
	I2C0_INTSTAT_SCLTIMEOUT_Pos = 0x19
	// Bit mask of SCLTIMEOUT field.
	I2C0_INTSTAT_SCLTIMEOUT_Msk = 0x2000000
	// Bit SCLTIMEOUT.
	I2C0_INTSTAT_SCLTIMEOUT = 0x2000000
	// Position of RESERVED field.
	I2C0_INTSTAT_RESERVED_Pos = 0x1a
	// Bit mask of RESERVED field.
	I2C0_INTSTAT_RESERVED_Msk = 0xfc000000

	// MSTCTL: Master control register.
	// Position of MSTCONTINUE field.
	I2C0_MSTCTL_MSTCONTINUE_Pos = 0x0
	// Bit mask of MSTCONTINUE field.
	I2C0_MSTCTL_MSTCONTINUE_Msk = 0x1
	// Bit MSTCONTINUE.
	I2C0_MSTCTL_MSTCONTINUE = 0x1
	// No effect.
	I2C0_MSTCTL_MSTCONTINUE_NO_EFFECT = 0x0
	// Continue. Informs the Master function to continue to the next operation. This must done after writing transmit data, reading received data, or any other housekeeping related to the next bus operation.
	I2C0_MSTCTL_MSTCONTINUE_CONTINUE = 0x1
	// Position of MSTSTART field.
	I2C0_MSTCTL_MSTSTART_Pos = 0x1
	// Bit mask of MSTSTART field.
	I2C0_MSTCTL_MSTSTART_Msk = 0x2
	// Bit MSTSTART.
	I2C0_MSTCTL_MSTSTART = 0x2
	// No effect.
	I2C0_MSTCTL_MSTSTART_NO_EFFECT = 0x0
	// Start. A Start will be generated on the I2C bus at the next allowed time.
	I2C0_MSTCTL_MSTSTART_START = 0x1
	// Position of MSTSTOP field.
	I2C0_MSTCTL_MSTSTOP_Pos = 0x2
	// Bit mask of MSTSTOP field.
	I2C0_MSTCTL_MSTSTOP_Msk = 0x4
	// Bit MSTSTOP.
	I2C0_MSTCTL_MSTSTOP = 0x4
	// No effect.
	I2C0_MSTCTL_MSTSTOP_NO_EFFECT = 0x0
	// Stop. A Stop will be generated on the I2C bus at the next allowed time, preceded by a NACK to the slave if the master is receiving data from the slave (Master Receiver mode).
	I2C0_MSTCTL_MSTSTOP_STOP = 0x1
	// Position of MSTDMA field.
	I2C0_MSTCTL_MSTDMA_Pos = 0x3
	// Bit mask of MSTDMA field.
	I2C0_MSTCTL_MSTDMA_Msk = 0x8
	// Bit MSTDMA.
	I2C0_MSTCTL_MSTDMA = 0x8
	// Disable. No DMA requests are generated for master operation.
	I2C0_MSTCTL_MSTDMA_DISABLE = 0x0
	// Enable. A DMA request is generated for I2C master data operations. When this I2C master is generating Acknowledge bits in Master Receiver mode, the acknowledge is generated automatically.
	I2C0_MSTCTL_MSTDMA_ENABLE = 0x1
	// Position of RESERVED field.
	I2C0_MSTCTL_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	I2C0_MSTCTL_RESERVED_Msk = 0xfffffff0

	// MSTTIME: Master timing configuration.
	// Position of MSTSCLLOW field.
	I2C0_MSTTIME_MSTSCLLOW_Pos = 0x0
	// Bit mask of MSTSCLLOW field.
	I2C0_MSTTIME_MSTSCLLOW_Msk = 0x7
	// 2 clocks. Minimum SCL low time is 2 clocks of the I2C clock pre-divider.
	I2C0_MSTTIME_MSTSCLLOW_2_CLOCKS = 0x0
	// 3 clocks. Minimum SCL low time is 3 clocks of the I2C clock pre-divider.
	I2C0_MSTTIME_MSTSCLLOW_3_CLOCKS = 0x1
	// 4 clocks. Minimum SCL low time is 4 clocks of the I2C clock pre-divider.
	I2C0_MSTTIME_MSTSCLLOW_4_CLOCKS = 0x2
	// 5 clocks. Minimum SCL low time is 5 clocks of the I2C clock pre-divider.
	I2C0_MSTTIME_MSTSCLLOW_5_CLOCKS = 0x3
	// 6 clocks. Minimum SCL low time is 6 clocks of the I2C clock pre-divider.
	I2C0_MSTTIME_MSTSCLLOW_6_CLOCKS = 0x4
	// 7 clocks. Minimum SCL low time is 7 clocks of the I2C clock pre-divider.
	I2C0_MSTTIME_MSTSCLLOW_7_CLOCKS = 0x5
	// 8 clocks. Minimum SCL low time is 8 clocks of the I2C clock pre-divider.
	I2C0_MSTTIME_MSTSCLLOW_8_CLOCKS = 0x6
	// 9 clocks. Minimum SCL low time is 9 clocks of the I2C clock pre-divider.
	I2C0_MSTTIME_MSTSCLLOW_9_CLOCKS = 0x7
	// Position of RESERVED field.
	I2C0_MSTTIME_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	I2C0_MSTTIME_RESERVED_Msk = 0x8
	// Bit RESERVED.
	I2C0_MSTTIME_RESERVED = 0x8
	// Position of MSTSCLHIGH field.
	I2C0_MSTTIME_MSTSCLHIGH_Pos = 0x4
	// Bit mask of MSTSCLHIGH field.
	I2C0_MSTTIME_MSTSCLHIGH_Msk = 0x70
	// 2 clocks. Minimum SCL high time is 2 clock of the I2C clock pre-divider.
	I2C0_MSTTIME_MSTSCLHIGH_2_CLOCKS = 0x0
	// 3 clocks. Minimum SCL high time is 3 clocks of the I2C clock pre-divider .
	I2C0_MSTTIME_MSTSCLHIGH_3_CLOCKS = 0x1
	// 4 clocks. Minimum SCL high time is 4 clock of the I2C clock pre-divider.
	I2C0_MSTTIME_MSTSCLHIGH_4_CLOCKS = 0x2
	// 5 clocks. Minimum SCL high time is 5 clock of the I2C clock pre-divider.
	I2C0_MSTTIME_MSTSCLHIGH_5_CLOCKS = 0x3
	// 6 clocks. Minimum SCL high time is 6 clock of the I2C clock pre-divider.
	I2C0_MSTTIME_MSTSCLHIGH_6_CLOCKS = 0x4
	// 7 clocks. Minimum SCL high time is 7 clock of the I2C clock pre-divider.
	I2C0_MSTTIME_MSTSCLHIGH_7_CLOCKS = 0x5
	// 8 clocks. Minimum SCL high time is 8 clock of the I2C clock pre-divider.
	I2C0_MSTTIME_MSTSCLHIGH_8_CLOCKS = 0x6
	// 9 clocks. Minimum SCL high time is 9 clocks of the I2C clock pre-divider.
	I2C0_MSTTIME_MSTSCLHIGH_9_CLOCKS = 0x7
	// Position of RESERVED field.
	I2C0_MSTTIME_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	I2C0_MSTTIME_RESERVED_Msk = 0xffffff80

	// MSTDAT: Combined Master receiver and transmitter data register.
	// Position of DATA field.
	I2C0_MSTDAT_DATA_Pos = 0x0
	// Bit mask of DATA field.
	I2C0_MSTDAT_DATA_Msk = 0xff
	// Position of RESERVED field.
	I2C0_MSTDAT_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	I2C0_MSTDAT_RESERVED_Msk = 0xffffff00

	// SLVCTL: Slave control register.
	// Position of SLVCONTINUE field.
	I2C0_SLVCTL_SLVCONTINUE_Pos = 0x0
	// Bit mask of SLVCONTINUE field.
	I2C0_SLVCTL_SLVCONTINUE_Msk = 0x1
	// Bit SLVCONTINUE.
	I2C0_SLVCTL_SLVCONTINUE = 0x1
	// No effect.
	I2C0_SLVCTL_SLVCONTINUE_NO_EFFECT = 0x0
	// Continue. Informs the Slave function to continue to the next operation. This must done after writing transmit data, reading received data, or any other housekeeping related to the next bus operation.
	I2C0_SLVCTL_SLVCONTINUE_CONTINUE = 0x1
	// Position of SLVNACK field.
	I2C0_SLVCTL_SLVNACK_Pos = 0x1
	// Bit mask of SLVNACK field.
	I2C0_SLVCTL_SLVNACK_Msk = 0x2
	// Bit SLVNACK.
	I2C0_SLVCTL_SLVNACK = 0x2
	// No effect.
	I2C0_SLVCTL_SLVNACK_NO_EFFECT = 0x0
	// NACK. Causes the Slave function to NACK the master when the slave is receiving data from the master (Slave Receiver mode).
	I2C0_SLVCTL_SLVNACK_NACK = 0x1
	// Position of RESERVED field.
	I2C0_SLVCTL_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	I2C0_SLVCTL_RESERVED_Msk = 0x4
	// Bit RESERVED.
	I2C0_SLVCTL_RESERVED = 0x4
	// Position of SLVDMA field.
	I2C0_SLVCTL_SLVDMA_Pos = 0x3
	// Bit mask of SLVDMA field.
	I2C0_SLVCTL_SLVDMA_Msk = 0x8
	// Bit SLVDMA.
	I2C0_SLVCTL_SLVDMA = 0x8
	// Disabled. No DMA requests are issued for Slave mode operation.
	I2C0_SLVCTL_SLVDMA_DISABLED = 0x0
	// Enabled. DMA requests are issued for I2C slave data transmission and reception.
	I2C0_SLVCTL_SLVDMA_ENABLED = 0x1
	// Position of RESERVED field.
	I2C0_SLVCTL_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	I2C0_SLVCTL_RESERVED_Msk = 0xfffffff0

	// SLVDAT: Combined Slave receiver and transmitter data register.
	// Position of DATA field.
	I2C0_SLVDAT_DATA_Pos = 0x0
	// Bit mask of DATA field.
	I2C0_SLVDAT_DATA_Msk = 0xff
	// Position of RESERVED field.
	I2C0_SLVDAT_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	I2C0_SLVDAT_RESERVED_Msk = 0xffffff00

	// SLVADR0: Slave address 0.
	// Position of SADISABLE field.
	I2C0_SLVADR_SADISABLE_Pos = 0x0
	// Bit mask of SADISABLE field.
	I2C0_SLVADR_SADISABLE_Msk = 0x1
	// Bit SADISABLE.
	I2C0_SLVADR_SADISABLE = 0x1
	// Enabled. Slave Address n is enabled and will be recognized with any changes specified by the SLVQUAL0 register.
	I2C0_SLVADR_SADISABLE_ENABLED = 0x0
	// Ignored Slave Address n is ignored.
	I2C0_SLVADR_SADISABLE_IGNORED_SLAVE_ADDRES = 0x1
	// Position of SLVADR field.
	I2C0_SLVADR_SLVADR_Pos = 0x1
	// Bit mask of SLVADR field.
	I2C0_SLVADR_SLVADR_Msk = 0xfe
	// Position of RESERVED field.
	I2C0_SLVADR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	I2C0_SLVADR_RESERVED_Msk = 0xffffff00

	// SLVQUAL0: Slave Qualification for address 0.
	// Position of QUALMODE0 field.
	I2C0_SLVQUAL0_QUALMODE0_Pos = 0x0
	// Bit mask of QUALMODE0 field.
	I2C0_SLVQUAL0_QUALMODE0_Msk = 0x1
	// Bit QUALMODE0.
	I2C0_SLVQUAL0_QUALMODE0 = 0x1
	// Position of SLVQUAL0 field.
	I2C0_SLVQUAL0_SLVQUAL0_Pos = 0x1
	// Bit mask of SLVQUAL0 field.
	I2C0_SLVQUAL0_SLVQUAL0_Msk = 0xfe
	// Position of RESERVED field.
	I2C0_SLVQUAL0_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	I2C0_SLVQUAL0_RESERVED_Msk = 0xffffff00

	// MONRXDAT: Monitor receiver data register.
	// Position of MONRXDAT field.
	I2C0_MONRXDAT_MONRXDAT_Pos = 0x0
	// Bit mask of MONRXDAT field.
	I2C0_MONRXDAT_MONRXDAT_Msk = 0xff
	// Position of MONSTART field.
	I2C0_MONRXDAT_MONSTART_Pos = 0x8
	// Bit mask of MONSTART field.
	I2C0_MONRXDAT_MONSTART_Msk = 0x100
	// Bit MONSTART.
	I2C0_MONRXDAT_MONSTART = 0x100
	// No detect. The monitor function has not detected a Start event on the I2C bus.
	I2C0_MONRXDAT_MONSTART_NO_DETECT = 0x0
	// Start detect. The monitor function has detected a Start event on the I2C bus.
	I2C0_MONRXDAT_MONSTART_START_DETECT = 0x1
	// Position of MONRESTART field.
	I2C0_MONRXDAT_MONRESTART_Pos = 0x9
	// Bit mask of MONRESTART field.
	I2C0_MONRXDAT_MONRESTART_Msk = 0x200
	// Bit MONRESTART.
	I2C0_MONRXDAT_MONRESTART = 0x200
	// No start detect. The monitor function has not detected a Repeated Start event on the I2C bus.
	I2C0_MONRXDAT_MONRESTART_NO_START_DETECT = 0x0
	// Repeated start detect. The monitor function has detected a Repeated Start event on the I 2C bus.
	I2C0_MONRXDAT_MONRESTART_REPEATED_START_DETEC = 0x1
	// Position of MONNACK field.
	I2C0_MONRXDAT_MONNACK_Pos = 0xa
	// Bit mask of MONNACK field.
	I2C0_MONRXDAT_MONNACK_Msk = 0x400
	// Bit MONNACK.
	I2C0_MONRXDAT_MONNACK = 0x400
	// Acknowledged. The data currently being provided by the monitor function was acknowledged by at least one master or slave receiver.
	I2C0_MONRXDAT_MONNACK_ACKNOWLEDGED = 0x0
	// Not acknowledged. The data currently being provided by the monitor function was not acknowledged by any receiver.
	I2C0_MONRXDAT_MONNACK_NOT_ACKNOWLEDGED = 0x1
	// Position of RESERVED field.
	I2C0_MONRXDAT_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	I2C0_MONRXDAT_RESERVED_Msk = 0xfffff800
)

// Bitfields for QEI: Quadrature Encoder Interface (QEI)
const (
	// CON: Control register
	// Position of RESP field.
	QEI_CON_RESP_Pos = 0x0
	// Bit mask of RESP field.
	QEI_CON_RESP_Msk = 0x1
	// Bit RESP.
	QEI_CON_RESP = 0x1
	// Position of RESPI field.
	QEI_CON_RESPI_Pos = 0x1
	// Bit mask of RESPI field.
	QEI_CON_RESPI_Msk = 0x2
	// Bit RESPI.
	QEI_CON_RESPI = 0x2
	// Position of RESV field.
	QEI_CON_RESV_Pos = 0x2
	// Bit mask of RESV field.
	QEI_CON_RESV_Msk = 0x4
	// Bit RESV.
	QEI_CON_RESV = 0x4
	// Position of RESI field.
	QEI_CON_RESI_Pos = 0x3
	// Bit mask of RESI field.
	QEI_CON_RESI_Msk = 0x8
	// Bit RESI.
	QEI_CON_RESI = 0x8
	// Position of RESERVED field.
	QEI_CON_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	QEI_CON_RESERVED_Msk = 0xfffffff0

	// STAT: Encoder status register
	// Position of DIR field.
	QEI_STAT_DIR_Pos = 0x0
	// Bit mask of DIR field.
	QEI_STAT_DIR_Msk = 0x1
	// Bit DIR.
	QEI_STAT_DIR = 0x1
	// Position of RESERVED field.
	QEI_STAT_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	QEI_STAT_RESERVED_Msk = 0xfffffffe

	// CONF: Configuration register
	// Position of DIRINV field.
	QEI_CONF_DIRINV_Pos = 0x0
	// Bit mask of DIRINV field.
	QEI_CONF_DIRINV_Msk = 0x1
	// Bit DIRINV.
	QEI_CONF_DIRINV = 0x1
	// Position of SIGMODE field.
	QEI_CONF_SIGMODE_Pos = 0x1
	// Bit mask of SIGMODE field.
	QEI_CONF_SIGMODE_Msk = 0x2
	// Bit SIGMODE.
	QEI_CONF_SIGMODE = 0x2
	// Position of CAPMODE field.
	QEI_CONF_CAPMODE_Pos = 0x2
	// Bit mask of CAPMODE field.
	QEI_CONF_CAPMODE_Msk = 0x4
	// Bit CAPMODE.
	QEI_CONF_CAPMODE = 0x4
	// Position of INVINX field.
	QEI_CONF_INVINX_Pos = 0x3
	// Bit mask of INVINX field.
	QEI_CONF_INVINX_Msk = 0x8
	// Bit INVINX.
	QEI_CONF_INVINX = 0x8
	// Position of CRESPI field.
	QEI_CONF_CRESPI_Pos = 0x4
	// Bit mask of CRESPI field.
	QEI_CONF_CRESPI_Msk = 0x10
	// Bit CRESPI.
	QEI_CONF_CRESPI = 0x10
	// Position of RESERVED field.
	QEI_CONF_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	QEI_CONF_RESERVED_Msk = 0xffe0
	// Position of INXGATE field.
	QEI_CONF_INXGATE_Pos = 0x10
	// Bit mask of INXGATE field.
	QEI_CONF_INXGATE_Msk = 0xf0000
	// Position of RESERVED field.
	QEI_CONF_RESERVED_Pos = 0x14
	// Bit mask of RESERVED field.
	QEI_CONF_RESERVED_Msk = 0xfff00000

	// POS: Position register
	// Position of POS field.
	QEI_POS_POS_Pos = 0x0
	// Bit mask of POS field.
	QEI_POS_POS_Msk = 0xffffffff

	// MAXPOS: Maximum position register
	// Position of MAXPOS field.
	QEI_MAXPOS_MAXPOS_Pos = 0x0
	// Bit mask of MAXPOS field.
	QEI_MAXPOS_MAXPOS_Msk = 0xffffffff

	// CMPOS0: position compare register 0
	// Position of PCMP0 field.
	QEI_CMPOS0_PCMP0_Pos = 0x0
	// Bit mask of PCMP0 field.
	QEI_CMPOS0_PCMP0_Msk = 0xffffffff

	// CMPOS1: position compare register 1
	// Position of PCMP1 field.
	QEI_CMPOS1_PCMP1_Pos = 0x0
	// Bit mask of PCMP1 field.
	QEI_CMPOS1_PCMP1_Msk = 0xffffffff

	// CMPOS2: position compare register 2
	// Position of PCMP2 field.
	QEI_CMPOS2_PCMP2_Pos = 0x0
	// Bit mask of PCMP2 field.
	QEI_CMPOS2_PCMP2_Msk = 0xffffffff

	// INXCNT: Index count register
	// Position of ENCPOS field.
	QEI_INXCNT_ENCPOS_Pos = 0x0
	// Bit mask of ENCPOS field.
	QEI_INXCNT_ENCPOS_Msk = 0xffffffff

	// INXCMP0: Index compare register 0
	// Position of ICMP0 field.
	QEI_INXCMP0_ICMP0_Pos = 0x0
	// Bit mask of ICMP0 field.
	QEI_INXCMP0_ICMP0_Msk = 0xffffffff

	// LOAD: Velocity timer reload register
	// Position of VELLOAD field.
	QEI_LOAD_VELLOAD_Pos = 0x0
	// Bit mask of VELLOAD field.
	QEI_LOAD_VELLOAD_Msk = 0xffffffff

	// TIME: Velocity timer register
	// Position of VELVAL field.
	QEI_TIME_VELVAL_Pos = 0x0
	// Bit mask of VELVAL field.
	QEI_TIME_VELVAL_Msk = 0xffffffff

	// VEL: Velocity counter register
	// Position of VELPC field.
	QEI_VEL_VELPC_Pos = 0x0
	// Bit mask of VELPC field.
	QEI_VEL_VELPC_Msk = 0xffffffff

	// CAP: Velocity capture register
	// Position of VELCAP field.
	QEI_CAP_VELCAP_Pos = 0x0
	// Bit mask of VELCAP field.
	QEI_CAP_VELCAP_Msk = 0xffffffff

	// VELCOMP: Velocity compare register
	// Position of VELCMP field.
	QEI_VELCOMP_VELCMP_Pos = 0x0
	// Bit mask of VELCMP field.
	QEI_VELCOMP_VELCMP_Msk = 0xffffffff

	// FILTERPHA: Digital filter register on input phase A (QEI_A)
	// Position of FILTA field.
	QEI_FILTERPHA_FILTA_Pos = 0x0
	// Bit mask of FILTA field.
	QEI_FILTERPHA_FILTA_Msk = 0xffffffff

	// FILTERPHB: Digital filter register on input phase B (QEI_B)
	// Position of FILTB field.
	QEI_FILTERPHB_FILTB_Pos = 0x0
	// Bit mask of FILTB field.
	QEI_FILTERPHB_FILTB_Msk = 0xffffffff

	// FILTERINX: Digital filter register on input index (QEI_IDX)
	// Position of FITLINX field.
	QEI_FILTERINX_FITLINX_Pos = 0x0
	// Bit mask of FITLINX field.
	QEI_FILTERINX_FITLINX_Msk = 0xffffffff

	// WINDOW: Index acceptance window register
	// Position of WINDOW field.
	QEI_WINDOW_WINDOW_Pos = 0x0
	// Bit mask of WINDOW field.
	QEI_WINDOW_WINDOW_Msk = 0xffffffff

	// INXCMP1: Index compare register 1
	// Position of ICMP1 field.
	QEI_INXCMP1_ICMP1_Pos = 0x0
	// Bit mask of ICMP1 field.
	QEI_INXCMP1_ICMP1_Msk = 0xffffffff

	// INXCMP2: Index compare register 2
	// Position of ICMP2 field.
	QEI_INXCMP2_ICMP2_Pos = 0x0
	// Bit mask of ICMP2 field.
	QEI_INXCMP2_ICMP2_Msk = 0xffffffff

	// IEC: Interrupt enable clear register
	// Position of INX_EN field.
	QEI_IEC_INX_EN_Pos = 0x0
	// Bit mask of INX_EN field.
	QEI_IEC_INX_EN_Msk = 0x1
	// Bit INX_EN.
	QEI_IEC_INX_EN = 0x1
	// Position of TIM_EN field.
	QEI_IEC_TIM_EN_Pos = 0x1
	// Bit mask of TIM_EN field.
	QEI_IEC_TIM_EN_Msk = 0x2
	// Bit TIM_EN.
	QEI_IEC_TIM_EN = 0x2
	// Position of VELC_EN field.
	QEI_IEC_VELC_EN_Pos = 0x2
	// Bit mask of VELC_EN field.
	QEI_IEC_VELC_EN_Msk = 0x4
	// Bit VELC_EN.
	QEI_IEC_VELC_EN = 0x4
	// Position of DIR_EN field.
	QEI_IEC_DIR_EN_Pos = 0x3
	// Bit mask of DIR_EN field.
	QEI_IEC_DIR_EN_Msk = 0x8
	// Bit DIR_EN.
	QEI_IEC_DIR_EN = 0x8
	// Position of ERR_EN field.
	QEI_IEC_ERR_EN_Pos = 0x4
	// Bit mask of ERR_EN field.
	QEI_IEC_ERR_EN_Msk = 0x10
	// Bit ERR_EN.
	QEI_IEC_ERR_EN = 0x10
	// Position of ENCLK_EN field.
	QEI_IEC_ENCLK_EN_Pos = 0x5
	// Bit mask of ENCLK_EN field.
	QEI_IEC_ENCLK_EN_Msk = 0x20
	// Bit ENCLK_EN.
	QEI_IEC_ENCLK_EN = 0x20
	// Position of POS0_INT field.
	QEI_IEC_POS0_INT_Pos = 0x6
	// Bit mask of POS0_INT field.
	QEI_IEC_POS0_INT_Msk = 0x40
	// Bit POS0_INT.
	QEI_IEC_POS0_INT = 0x40
	// Position of POS1_INT field.
	QEI_IEC_POS1_INT_Pos = 0x7
	// Bit mask of POS1_INT field.
	QEI_IEC_POS1_INT_Msk = 0x80
	// Bit POS1_INT.
	QEI_IEC_POS1_INT = 0x80
	// Position of POS2_INT field.
	QEI_IEC_POS2_INT_Pos = 0x8
	// Bit mask of POS2_INT field.
	QEI_IEC_POS2_INT_Msk = 0x100
	// Bit POS2_INT.
	QEI_IEC_POS2_INT = 0x100
	// Position of REV0_INT field.
	QEI_IEC_REV0_INT_Pos = 0x9
	// Bit mask of REV0_INT field.
	QEI_IEC_REV0_INT_Msk = 0x200
	// Bit REV0_INT.
	QEI_IEC_REV0_INT = 0x200
	// Position of POS0REV_INT field.
	QEI_IEC_POS0REV_INT_Pos = 0xa
	// Bit mask of POS0REV_INT field.
	QEI_IEC_POS0REV_INT_Msk = 0x400
	// Bit POS0REV_INT.
	QEI_IEC_POS0REV_INT = 0x400
	// Position of POS1REV_INT field.
	QEI_IEC_POS1REV_INT_Pos = 0xb
	// Bit mask of POS1REV_INT field.
	QEI_IEC_POS1REV_INT_Msk = 0x800
	// Bit POS1REV_INT.
	QEI_IEC_POS1REV_INT = 0x800
	// Position of POS2REV_INT field.
	QEI_IEC_POS2REV_INT_Pos = 0xc
	// Bit mask of POS2REV_INT field.
	QEI_IEC_POS2REV_INT_Msk = 0x1000
	// Bit POS2REV_INT.
	QEI_IEC_POS2REV_INT = 0x1000
	// Position of REV1_INT field.
	QEI_IEC_REV1_INT_Pos = 0xd
	// Bit mask of REV1_INT field.
	QEI_IEC_REV1_INT_Msk = 0x2000
	// Bit REV1_INT.
	QEI_IEC_REV1_INT = 0x2000
	// Position of REV2_INT field.
	QEI_IEC_REV2_INT_Pos = 0xe
	// Bit mask of REV2_INT field.
	QEI_IEC_REV2_INT_Msk = 0x4000
	// Bit REV2_INT.
	QEI_IEC_REV2_INT = 0x4000
	// Position of MAXPOS_INT field.
	QEI_IEC_MAXPOS_INT_Pos = 0xf
	// Bit mask of MAXPOS_INT field.
	QEI_IEC_MAXPOS_INT_Msk = 0x8000
	// Bit MAXPOS_INT.
	QEI_IEC_MAXPOS_INT = 0x8000
	// Position of RESERVED field.
	QEI_IEC_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	QEI_IEC_RESERVED_Msk = 0xffff0000

	// IES: Interrupt enable set register
	// Position of INX_EN field.
	QEI_IES_INX_EN_Pos = 0x0
	// Bit mask of INX_EN field.
	QEI_IES_INX_EN_Msk = 0x1
	// Bit INX_EN.
	QEI_IES_INX_EN = 0x1
	// Position of TIM_EN field.
	QEI_IES_TIM_EN_Pos = 0x1
	// Bit mask of TIM_EN field.
	QEI_IES_TIM_EN_Msk = 0x2
	// Bit TIM_EN.
	QEI_IES_TIM_EN = 0x2
	// Position of VELC_EN field.
	QEI_IES_VELC_EN_Pos = 0x2
	// Bit mask of VELC_EN field.
	QEI_IES_VELC_EN_Msk = 0x4
	// Bit VELC_EN.
	QEI_IES_VELC_EN = 0x4
	// Position of DIR_EN field.
	QEI_IES_DIR_EN_Pos = 0x3
	// Bit mask of DIR_EN field.
	QEI_IES_DIR_EN_Msk = 0x8
	// Bit DIR_EN.
	QEI_IES_DIR_EN = 0x8
	// Position of ERR_EN field.
	QEI_IES_ERR_EN_Pos = 0x4
	// Bit mask of ERR_EN field.
	QEI_IES_ERR_EN_Msk = 0x10
	// Bit ERR_EN.
	QEI_IES_ERR_EN = 0x10
	// Position of ENCLK_EN field.
	QEI_IES_ENCLK_EN_Pos = 0x5
	// Bit mask of ENCLK_EN field.
	QEI_IES_ENCLK_EN_Msk = 0x20
	// Bit ENCLK_EN.
	QEI_IES_ENCLK_EN = 0x20
	// Position of POS0_INT field.
	QEI_IES_POS0_INT_Pos = 0x6
	// Bit mask of POS0_INT field.
	QEI_IES_POS0_INT_Msk = 0x40
	// Bit POS0_INT.
	QEI_IES_POS0_INT = 0x40
	// Position of POS1_INT field.
	QEI_IES_POS1_INT_Pos = 0x7
	// Bit mask of POS1_INT field.
	QEI_IES_POS1_INT_Msk = 0x80
	// Bit POS1_INT.
	QEI_IES_POS1_INT = 0x80
	// Position of POS2_INT field.
	QEI_IES_POS2_INT_Pos = 0x8
	// Bit mask of POS2_INT field.
	QEI_IES_POS2_INT_Msk = 0x100
	// Bit POS2_INT.
	QEI_IES_POS2_INT = 0x100
	// Position of REV0_INT field.
	QEI_IES_REV0_INT_Pos = 0x9
	// Bit mask of REV0_INT field.
	QEI_IES_REV0_INT_Msk = 0x200
	// Bit REV0_INT.
	QEI_IES_REV0_INT = 0x200
	// Position of POS0REV_INT field.
	QEI_IES_POS0REV_INT_Pos = 0xa
	// Bit mask of POS0REV_INT field.
	QEI_IES_POS0REV_INT_Msk = 0x400
	// Bit POS0REV_INT.
	QEI_IES_POS0REV_INT = 0x400
	// Position of POS1REV_INT field.
	QEI_IES_POS1REV_INT_Pos = 0xb
	// Bit mask of POS1REV_INT field.
	QEI_IES_POS1REV_INT_Msk = 0x800
	// Bit POS1REV_INT.
	QEI_IES_POS1REV_INT = 0x800
	// Position of POS2REV_INT field.
	QEI_IES_POS2REV_INT_Pos = 0xc
	// Bit mask of POS2REV_INT field.
	QEI_IES_POS2REV_INT_Msk = 0x1000
	// Bit POS2REV_INT.
	QEI_IES_POS2REV_INT = 0x1000
	// Position of REV1_INT field.
	QEI_IES_REV1_INT_Pos = 0xd
	// Bit mask of REV1_INT field.
	QEI_IES_REV1_INT_Msk = 0x2000
	// Bit REV1_INT.
	QEI_IES_REV1_INT = 0x2000
	// Position of REV2_INT field.
	QEI_IES_REV2_INT_Pos = 0xe
	// Bit mask of REV2_INT field.
	QEI_IES_REV2_INT_Msk = 0x4000
	// Bit REV2_INT.
	QEI_IES_REV2_INT = 0x4000
	// Position of MAXPOS_INT field.
	QEI_IES_MAXPOS_INT_Pos = 0xf
	// Bit mask of MAXPOS_INT field.
	QEI_IES_MAXPOS_INT_Msk = 0x8000
	// Bit MAXPOS_INT.
	QEI_IES_MAXPOS_INT = 0x8000
	// Position of RESERVED field.
	QEI_IES_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	QEI_IES_RESERVED_Msk = 0xffff0000

	// INTSTAT: Interrupt status register
	// Position of INX_INT field.
	QEI_INTSTAT_INX_INT_Pos = 0x0
	// Bit mask of INX_INT field.
	QEI_INTSTAT_INX_INT_Msk = 0x1
	// Bit INX_INT.
	QEI_INTSTAT_INX_INT = 0x1
	// Position of TIM_INT field.
	QEI_INTSTAT_TIM_INT_Pos = 0x1
	// Bit mask of TIM_INT field.
	QEI_INTSTAT_TIM_INT_Msk = 0x2
	// Bit TIM_INT.
	QEI_INTSTAT_TIM_INT = 0x2
	// Position of VELC_INT field.
	QEI_INTSTAT_VELC_INT_Pos = 0x2
	// Bit mask of VELC_INT field.
	QEI_INTSTAT_VELC_INT_Msk = 0x4
	// Bit VELC_INT.
	QEI_INTSTAT_VELC_INT = 0x4
	// Position of DIR_INT field.
	QEI_INTSTAT_DIR_INT_Pos = 0x3
	// Bit mask of DIR_INT field.
	QEI_INTSTAT_DIR_INT_Msk = 0x8
	// Bit DIR_INT.
	QEI_INTSTAT_DIR_INT = 0x8
	// Position of ERR_INT field.
	QEI_INTSTAT_ERR_INT_Pos = 0x4
	// Bit mask of ERR_INT field.
	QEI_INTSTAT_ERR_INT_Msk = 0x10
	// Bit ERR_INT.
	QEI_INTSTAT_ERR_INT = 0x10
	// Position of ENCLK_INT field.
	QEI_INTSTAT_ENCLK_INT_Pos = 0x5
	// Bit mask of ENCLK_INT field.
	QEI_INTSTAT_ENCLK_INT_Msk = 0x20
	// Bit ENCLK_INT.
	QEI_INTSTAT_ENCLK_INT = 0x20
	// Position of POS0_INT field.
	QEI_INTSTAT_POS0_INT_Pos = 0x6
	// Bit mask of POS0_INT field.
	QEI_INTSTAT_POS0_INT_Msk = 0x40
	// Bit POS0_INT.
	QEI_INTSTAT_POS0_INT = 0x40
	// Position of POS1_INT field.
	QEI_INTSTAT_POS1_INT_Pos = 0x7
	// Bit mask of POS1_INT field.
	QEI_INTSTAT_POS1_INT_Msk = 0x80
	// Bit POS1_INT.
	QEI_INTSTAT_POS1_INT = 0x80
	// Position of POS2_INT field.
	QEI_INTSTAT_POS2_INT_Pos = 0x8
	// Bit mask of POS2_INT field.
	QEI_INTSTAT_POS2_INT_Msk = 0x100
	// Bit POS2_INT.
	QEI_INTSTAT_POS2_INT = 0x100
	// Position of REV0_INT field.
	QEI_INTSTAT_REV0_INT_Pos = 0x9
	// Bit mask of REV0_INT field.
	QEI_INTSTAT_REV0_INT_Msk = 0x200
	// Bit REV0_INT.
	QEI_INTSTAT_REV0_INT = 0x200
	// Position of POS0REV_INT field.
	QEI_INTSTAT_POS0REV_INT_Pos = 0xa
	// Bit mask of POS0REV_INT field.
	QEI_INTSTAT_POS0REV_INT_Msk = 0x400
	// Bit POS0REV_INT.
	QEI_INTSTAT_POS0REV_INT = 0x400
	// Position of POS1REV_INT field.
	QEI_INTSTAT_POS1REV_INT_Pos = 0xb
	// Bit mask of POS1REV_INT field.
	QEI_INTSTAT_POS1REV_INT_Msk = 0x800
	// Bit POS1REV_INT.
	QEI_INTSTAT_POS1REV_INT = 0x800
	// Position of POS2REV_INT field.
	QEI_INTSTAT_POS2REV_INT_Pos = 0xc
	// Bit mask of POS2REV_INT field.
	QEI_INTSTAT_POS2REV_INT_Msk = 0x1000
	// Bit POS2REV_INT.
	QEI_INTSTAT_POS2REV_INT = 0x1000
	// Position of REV1_INT field.
	QEI_INTSTAT_REV1_INT_Pos = 0xd
	// Bit mask of REV1_INT field.
	QEI_INTSTAT_REV1_INT_Msk = 0x2000
	// Bit REV1_INT.
	QEI_INTSTAT_REV1_INT = 0x2000
	// Position of REV2_INT field.
	QEI_INTSTAT_REV2_INT_Pos = 0xe
	// Bit mask of REV2_INT field.
	QEI_INTSTAT_REV2_INT_Msk = 0x4000
	// Bit REV2_INT.
	QEI_INTSTAT_REV2_INT = 0x4000
	// Position of MAXPOS_INT field.
	QEI_INTSTAT_MAXPOS_INT_Pos = 0xf
	// Bit mask of MAXPOS_INT field.
	QEI_INTSTAT_MAXPOS_INT_Msk = 0x8000
	// Bit MAXPOS_INT.
	QEI_INTSTAT_MAXPOS_INT = 0x8000
	// Position of RESERVED field.
	QEI_INTSTAT_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	QEI_INTSTAT_RESERVED_Msk = 0xffff0000

	// IE: Interrupt enable clear register
	// Position of INX_INT field.
	QEI_IE_INX_INT_Pos = 0x0
	// Bit mask of INX_INT field.
	QEI_IE_INX_INT_Msk = 0x1
	// Bit INX_INT.
	QEI_IE_INX_INT = 0x1
	// Position of TIM_INT field.
	QEI_IE_TIM_INT_Pos = 0x1
	// Bit mask of TIM_INT field.
	QEI_IE_TIM_INT_Msk = 0x2
	// Bit TIM_INT.
	QEI_IE_TIM_INT = 0x2
	// Position of VELC_INT field.
	QEI_IE_VELC_INT_Pos = 0x2
	// Bit mask of VELC_INT field.
	QEI_IE_VELC_INT_Msk = 0x4
	// Bit VELC_INT.
	QEI_IE_VELC_INT = 0x4
	// Position of DIR_INT field.
	QEI_IE_DIR_INT_Pos = 0x3
	// Bit mask of DIR_INT field.
	QEI_IE_DIR_INT_Msk = 0x8
	// Bit DIR_INT.
	QEI_IE_DIR_INT = 0x8
	// Position of ERR_INT field.
	QEI_IE_ERR_INT_Pos = 0x4
	// Bit mask of ERR_INT field.
	QEI_IE_ERR_INT_Msk = 0x10
	// Bit ERR_INT.
	QEI_IE_ERR_INT = 0x10
	// Position of ENCLK_INT field.
	QEI_IE_ENCLK_INT_Pos = 0x5
	// Bit mask of ENCLK_INT field.
	QEI_IE_ENCLK_INT_Msk = 0x20
	// Bit ENCLK_INT.
	QEI_IE_ENCLK_INT = 0x20
	// Position of POS0_INT field.
	QEI_IE_POS0_INT_Pos = 0x6
	// Bit mask of POS0_INT field.
	QEI_IE_POS0_INT_Msk = 0x40
	// Bit POS0_INT.
	QEI_IE_POS0_INT = 0x40
	// Position of POS1_INT field.
	QEI_IE_POS1_INT_Pos = 0x7
	// Bit mask of POS1_INT field.
	QEI_IE_POS1_INT_Msk = 0x80
	// Bit POS1_INT.
	QEI_IE_POS1_INT = 0x80
	// Position of POS2_INT field.
	QEI_IE_POS2_INT_Pos = 0x8
	// Bit mask of POS2_INT field.
	QEI_IE_POS2_INT_Msk = 0x100
	// Bit POS2_INT.
	QEI_IE_POS2_INT = 0x100
	// Position of REV0_INT field.
	QEI_IE_REV0_INT_Pos = 0x9
	// Bit mask of REV0_INT field.
	QEI_IE_REV0_INT_Msk = 0x200
	// Bit REV0_INT.
	QEI_IE_REV0_INT = 0x200
	// Position of POS0REV_INT field.
	QEI_IE_POS0REV_INT_Pos = 0xa
	// Bit mask of POS0REV_INT field.
	QEI_IE_POS0REV_INT_Msk = 0x400
	// Bit POS0REV_INT.
	QEI_IE_POS0REV_INT = 0x400
	// Position of POS1REV_INT field.
	QEI_IE_POS1REV_INT_Pos = 0xb
	// Bit mask of POS1REV_INT field.
	QEI_IE_POS1REV_INT_Msk = 0x800
	// Bit POS1REV_INT.
	QEI_IE_POS1REV_INT = 0x800
	// Position of POS2REV_INT field.
	QEI_IE_POS2REV_INT_Pos = 0xc
	// Bit mask of POS2REV_INT field.
	QEI_IE_POS2REV_INT_Msk = 0x1000
	// Bit POS2REV_INT.
	QEI_IE_POS2REV_INT = 0x1000
	// Position of REV1_INT field.
	QEI_IE_REV1_INT_Pos = 0xd
	// Bit mask of REV1_INT field.
	QEI_IE_REV1_INT_Msk = 0x2000
	// Bit REV1_INT.
	QEI_IE_REV1_INT = 0x2000
	// Position of REV2_INT field.
	QEI_IE_REV2_INT_Pos = 0xe
	// Bit mask of REV2_INT field.
	QEI_IE_REV2_INT_Msk = 0x4000
	// Bit REV2_INT.
	QEI_IE_REV2_INT = 0x4000
	// Position of MAXPOS_INT field.
	QEI_IE_MAXPOS_INT_Pos = 0xf
	// Bit mask of MAXPOS_INT field.
	QEI_IE_MAXPOS_INT_Msk = 0x8000
	// Bit MAXPOS_INT.
	QEI_IE_MAXPOS_INT = 0x8000
	// Position of RESERVED field.
	QEI_IE_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	QEI_IE_RESERVED_Msk = 0xffff0000

	// CLR: Interrupt status clear register
	// Position of INX_INT field.
	QEI_CLR_INX_INT_Pos = 0x0
	// Bit mask of INX_INT field.
	QEI_CLR_INX_INT_Msk = 0x1
	// Bit INX_INT.
	QEI_CLR_INX_INT = 0x1
	// Position of TIM_INT field.
	QEI_CLR_TIM_INT_Pos = 0x1
	// Bit mask of TIM_INT field.
	QEI_CLR_TIM_INT_Msk = 0x2
	// Bit TIM_INT.
	QEI_CLR_TIM_INT = 0x2
	// Position of VELC_INT field.
	QEI_CLR_VELC_INT_Pos = 0x2
	// Bit mask of VELC_INT field.
	QEI_CLR_VELC_INT_Msk = 0x4
	// Bit VELC_INT.
	QEI_CLR_VELC_INT = 0x4
	// Position of DIR_INT field.
	QEI_CLR_DIR_INT_Pos = 0x3
	// Bit mask of DIR_INT field.
	QEI_CLR_DIR_INT_Msk = 0x8
	// Bit DIR_INT.
	QEI_CLR_DIR_INT = 0x8
	// Position of ERR_INT field.
	QEI_CLR_ERR_INT_Pos = 0x4
	// Bit mask of ERR_INT field.
	QEI_CLR_ERR_INT_Msk = 0x10
	// Bit ERR_INT.
	QEI_CLR_ERR_INT = 0x10
	// Position of ENCLK_INT field.
	QEI_CLR_ENCLK_INT_Pos = 0x5
	// Bit mask of ENCLK_INT field.
	QEI_CLR_ENCLK_INT_Msk = 0x20
	// Bit ENCLK_INT.
	QEI_CLR_ENCLK_INT = 0x20
	// Position of POS0_INT field.
	QEI_CLR_POS0_INT_Pos = 0x6
	// Bit mask of POS0_INT field.
	QEI_CLR_POS0_INT_Msk = 0x40
	// Bit POS0_INT.
	QEI_CLR_POS0_INT = 0x40
	// Position of POS1_INT field.
	QEI_CLR_POS1_INT_Pos = 0x7
	// Bit mask of POS1_INT field.
	QEI_CLR_POS1_INT_Msk = 0x80
	// Bit POS1_INT.
	QEI_CLR_POS1_INT = 0x80
	// Position of POS2_INT field.
	QEI_CLR_POS2_INT_Pos = 0x8
	// Bit mask of POS2_INT field.
	QEI_CLR_POS2_INT_Msk = 0x100
	// Bit POS2_INT.
	QEI_CLR_POS2_INT = 0x100
	// Position of REV0_INT field.
	QEI_CLR_REV0_INT_Pos = 0x9
	// Bit mask of REV0_INT field.
	QEI_CLR_REV0_INT_Msk = 0x200
	// Bit REV0_INT.
	QEI_CLR_REV0_INT = 0x200
	// Position of POS0REV_INT field.
	QEI_CLR_POS0REV_INT_Pos = 0xa
	// Bit mask of POS0REV_INT field.
	QEI_CLR_POS0REV_INT_Msk = 0x400
	// Bit POS0REV_INT.
	QEI_CLR_POS0REV_INT = 0x400
	// Position of POS1REV_INT field.
	QEI_CLR_POS1REV_INT_Pos = 0xb
	// Bit mask of POS1REV_INT field.
	QEI_CLR_POS1REV_INT_Msk = 0x800
	// Bit POS1REV_INT.
	QEI_CLR_POS1REV_INT = 0x800
	// Position of POS2REV_INT field.
	QEI_CLR_POS2REV_INT_Pos = 0xc
	// Bit mask of POS2REV_INT field.
	QEI_CLR_POS2REV_INT_Msk = 0x1000
	// Bit POS2REV_INT.
	QEI_CLR_POS2REV_INT = 0x1000
	// Position of REV1_INT field.
	QEI_CLR_REV1_INT_Pos = 0xd
	// Bit mask of REV1_INT field.
	QEI_CLR_REV1_INT_Msk = 0x2000
	// Bit REV1_INT.
	QEI_CLR_REV1_INT = 0x2000
	// Position of REV2_INT field.
	QEI_CLR_REV2_INT_Pos = 0xe
	// Bit mask of REV2_INT field.
	QEI_CLR_REV2_INT_Msk = 0x4000
	// Bit REV2_INT.
	QEI_CLR_REV2_INT = 0x4000
	// Position of MAXPOS_INT field.
	QEI_CLR_MAXPOS_INT_Pos = 0xf
	// Bit mask of MAXPOS_INT field.
	QEI_CLR_MAXPOS_INT_Msk = 0x8000
	// Bit MAXPOS_INT.
	QEI_CLR_MAXPOS_INT = 0x8000
	// Position of RESERVED field.
	QEI_CLR_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	QEI_CLR_RESERVED_Msk = 0xffff0000

	// SET: Interrupt status set register
	// Position of INX_INT field.
	QEI_SET_INX_INT_Pos = 0x0
	// Bit mask of INX_INT field.
	QEI_SET_INX_INT_Msk = 0x1
	// Bit INX_INT.
	QEI_SET_INX_INT = 0x1
	// Position of TIM_INT field.
	QEI_SET_TIM_INT_Pos = 0x1
	// Bit mask of TIM_INT field.
	QEI_SET_TIM_INT_Msk = 0x2
	// Bit TIM_INT.
	QEI_SET_TIM_INT = 0x2
	// Position of VELC_INT field.
	QEI_SET_VELC_INT_Pos = 0x2
	// Bit mask of VELC_INT field.
	QEI_SET_VELC_INT_Msk = 0x4
	// Bit VELC_INT.
	QEI_SET_VELC_INT = 0x4
	// Position of DIR_INT field.
	QEI_SET_DIR_INT_Pos = 0x3
	// Bit mask of DIR_INT field.
	QEI_SET_DIR_INT_Msk = 0x8
	// Bit DIR_INT.
	QEI_SET_DIR_INT = 0x8
	// Position of ERR_INT field.
	QEI_SET_ERR_INT_Pos = 0x4
	// Bit mask of ERR_INT field.
	QEI_SET_ERR_INT_Msk = 0x10
	// Bit ERR_INT.
	QEI_SET_ERR_INT = 0x10
	// Position of ENCLK_INT field.
	QEI_SET_ENCLK_INT_Pos = 0x5
	// Bit mask of ENCLK_INT field.
	QEI_SET_ENCLK_INT_Msk = 0x20
	// Bit ENCLK_INT.
	QEI_SET_ENCLK_INT = 0x20
	// Position of POS0_INT field.
	QEI_SET_POS0_INT_Pos = 0x6
	// Bit mask of POS0_INT field.
	QEI_SET_POS0_INT_Msk = 0x40
	// Bit POS0_INT.
	QEI_SET_POS0_INT = 0x40
	// Position of POS1_INT field.
	QEI_SET_POS1_INT_Pos = 0x7
	// Bit mask of POS1_INT field.
	QEI_SET_POS1_INT_Msk = 0x80
	// Bit POS1_INT.
	QEI_SET_POS1_INT = 0x80
	// Position of POS2_INT field.
	QEI_SET_POS2_INT_Pos = 0x8
	// Bit mask of POS2_INT field.
	QEI_SET_POS2_INT_Msk = 0x100
	// Bit POS2_INT.
	QEI_SET_POS2_INT = 0x100
	// Position of REV0_INT field.
	QEI_SET_REV0_INT_Pos = 0x9
	// Bit mask of REV0_INT field.
	QEI_SET_REV0_INT_Msk = 0x200
	// Bit REV0_INT.
	QEI_SET_REV0_INT = 0x200
	// Position of POS0REV_INT field.
	QEI_SET_POS0REV_INT_Pos = 0xa
	// Bit mask of POS0REV_INT field.
	QEI_SET_POS0REV_INT_Msk = 0x400
	// Bit POS0REV_INT.
	QEI_SET_POS0REV_INT = 0x400
	// Position of POS1REV_INT field.
	QEI_SET_POS1REV_INT_Pos = 0xb
	// Bit mask of POS1REV_INT field.
	QEI_SET_POS1REV_INT_Msk = 0x800
	// Bit POS1REV_INT.
	QEI_SET_POS1REV_INT = 0x800
	// Position of POS2REV_INT field.
	QEI_SET_POS2REV_INT_Pos = 0xc
	// Bit mask of POS2REV_INT field.
	QEI_SET_POS2REV_INT_Msk = 0x1000
	// Bit POS2REV_INT.
	QEI_SET_POS2REV_INT = 0x1000
	// Position of REV1_INT field.
	QEI_SET_REV1_INT_Pos = 0xd
	// Bit mask of REV1_INT field.
	QEI_SET_REV1_INT_Msk = 0x2000
	// Bit REV1_INT.
	QEI_SET_REV1_INT = 0x2000
	// Position of REV2_INT field.
	QEI_SET_REV2_INT_Pos = 0xe
	// Bit mask of REV2_INT field.
	QEI_SET_REV2_INT_Msk = 0x4000
	// Bit REV2_INT.
	QEI_SET_REV2_INT = 0x4000
	// Position of MAXPOS_INT field.
	QEI_SET_MAXPOS_INT_Pos = 0xf
	// Bit mask of MAXPOS_INT field.
	QEI_SET_MAXPOS_INT_Msk = 0x8000
	// Bit MAXPOS_INT.
	QEI_SET_MAXPOS_INT = 0x8000
	// Position of RESERVED field.
	QEI_SET_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	QEI_SET_RESERVED_Msk = 0xffff0000
)

// Bitfields for SYSCON: System configuration (SYSCON)
const (
	// SYSMEMREMAP: System memory remap
	// Position of MAP field.
	SYSCON_SYSMEMREMAP_MAP_Pos = 0x0
	// Bit mask of MAP field.
	SYSCON_SYSMEMREMAP_MAP_Msk = 0x3
	// Position of RESERVED field.
	SYSCON_SYSMEMREMAP_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	SYSCON_SYSMEMREMAP_RESERVED_Msk = 0xfffffffc

	// SYSTCKCAL: System tick counter calibration
	// Position of CAL field.
	SYSCON_SYSTCKCAL_CAL_Pos = 0x0
	// Bit mask of CAL field.
	SYSCON_SYSTCKCAL_CAL_Msk = 0x3ffffff
	// Position of RESERVED field.
	SYSCON_SYSTCKCAL_RESERVED_Pos = 0x1a
	// Bit mask of RESERVED field.
	SYSCON_SYSTCKCAL_RESERVED_Msk = 0xfc000000

	// NMISRC: NMI Source Control
	// Position of IRQNO field.
	SYSCON_NMISRC_IRQNO_Pos = 0x0
	// Bit mask of IRQNO field.
	SYSCON_NMISRC_IRQNO_Msk = 0x1f
	// Position of RESERVED field.
	SYSCON_NMISRC_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	SYSCON_NMISRC_RESERVED_Msk = 0x7fffffe0
	// Position of NMIEN field.
	SYSCON_NMISRC_NMIEN_Pos = 0x1f
	// Bit mask of NMIEN field.
	SYSCON_NMISRC_NMIEN_Msk = 0x80000000
	// Bit NMIEN.
	SYSCON_NMISRC_NMIEN = 0x80000000

	// SYSRSTSTAT: System reset status register
	// Position of POR field.
	SYSCON_SYSRSTSTAT_POR_Pos = 0x0
	// Bit mask of POR field.
	SYSCON_SYSRSTSTAT_POR_Msk = 0x1
	// Bit POR.
	SYSCON_SYSRSTSTAT_POR = 0x1
	// No POR detected
	SYSCON_SYSRSTSTAT_POR_NO_POR_DETECTED = 0x0
	// POR detected. Writing a one clears this reset.
	SYSCON_SYSRSTSTAT_POR_POR_DETECTED_WRITIN = 0x1
	// Position of EXTRST field.
	SYSCON_SYSRSTSTAT_EXTRST_Pos = 0x1
	// Bit mask of EXTRST field.
	SYSCON_SYSRSTSTAT_EXTRST_Msk = 0x2
	// Bit EXTRST.
	SYSCON_SYSRSTSTAT_EXTRST = 0x2
	// No reset event detected.
	SYSCON_SYSRSTSTAT_EXTRST_NO_RESET_EVENT_DETEC = 0x0
	// Reset detected. Writing a one clears this reset.
	SYSCON_SYSRSTSTAT_EXTRST_RESET_DETECTED_WRIT = 0x1
	// Position of WDT field.
	SYSCON_SYSRSTSTAT_WDT_Pos = 0x2
	// Bit mask of WDT field.
	SYSCON_SYSRSTSTAT_WDT_Msk = 0x4
	// Bit WDT.
	SYSCON_SYSRSTSTAT_WDT = 0x4
	// No WDT reset detected
	SYSCON_SYSRSTSTAT_WDT_NO_WDT_RESET_DETECTE = 0x0
	// WDT reset detected. Writing a one clears this reset.
	SYSCON_SYSRSTSTAT_WDT_WDT_RESET_DETECTED_ = 0x1
	// Position of BOD field.
	SYSCON_SYSRSTSTAT_BOD_Pos = 0x3
	// Bit mask of BOD field.
	SYSCON_SYSRSTSTAT_BOD_Msk = 0x8
	// Bit BOD.
	SYSCON_SYSRSTSTAT_BOD = 0x8
	// No BOD reset detected
	SYSCON_SYSRSTSTAT_BOD_NO_BOD_RESET_DETECTE = 0x0
	// BOD reset detected. Writing a one clears this reset.
	SYSCON_SYSRSTSTAT_BOD_BOD_RESET_DETECTED_ = 0x1
	// Position of SYSRST field.
	SYSCON_SYSRSTSTAT_SYSRST_Pos = 0x4
	// Bit mask of SYSRST field.
	SYSCON_SYSRSTSTAT_SYSRST_Msk = 0x10
	// Bit SYSRST.
	SYSCON_SYSRSTSTAT_SYSRST = 0x10
	// No System reset detected
	SYSCON_SYSRSTSTAT_SYSRST_NO_SYSTEM_RESET_DETE = 0x0
	// System reset detected. Writing a one clears this reset.
	SYSCON_SYSRSTSTAT_SYSRST_SYSTEM_RESET_DETECTE = 0x1
	// Position of RESERVED field.
	SYSCON_SYSRSTSTAT_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	SYSCON_SYSRSTSTAT_RESERVED_Msk = 0xffffffe0

	// PRESETCTRL0: Peripheral reset control 0
	// Position of RESERVED field.
	SYSCON_PRESETCTRL0_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	SYSCON_PRESETCTRL0_RESERVED_Msk = 0x7f
	// Position of FLASH_RST field.
	SYSCON_PRESETCTRL0_FLASH_RST_Pos = 0x7
	// Bit mask of FLASH_RST field.
	SYSCON_PRESETCTRL0_FLASH_RST_Msk = 0x80
	// Bit FLASH_RST.
	SYSCON_PRESETCTRL0_FLASH_RST = 0x80
	// Clear flash reset.
	SYSCON_PRESETCTRL0_FLASH_RST_CLEAR_FLASH_RESET_ = 0x0
	// Assert flash reset.
	SYSCON_PRESETCTRL0_FLASH_RST_ASSERT_FLASH_RESET_ = 0x1
	// Position of FMC_RST field.
	SYSCON_PRESETCTRL0_FMC_RST_Pos = 0x8
	// Bit mask of FMC_RST field.
	SYSCON_PRESETCTRL0_FMC_RST_Msk = 0x100
	// Bit FMC_RST.
	SYSCON_PRESETCTRL0_FMC_RST = 0x100
	// Clear FMC reset.
	SYSCON_PRESETCTRL0_FMC_RST_CLEAR_FMC_RESET_ = 0x0
	// Assert FMC reset.
	SYSCON_PRESETCTRL0_FMC_RST_ASSERT_FMC_RESET_ = 0x1
	// Position of EEPROM_RST field.
	SYSCON_PRESETCTRL0_EEPROM_RST_Pos = 0x9
	// Bit mask of EEPROM_RST field.
	SYSCON_PRESETCTRL0_EEPROM_RST_Msk = 0x200
	// Bit EEPROM_RST.
	SYSCON_PRESETCTRL0_EEPROM_RST = 0x200
	// Clear EEPROM reset.
	SYSCON_PRESETCTRL0_EEPROM_RST_CLEAR_EEPROM_RESET_ = 0x0
	// Assert EEPROM reset.
	SYSCON_PRESETCTRL0_EEPROM_RST_ASSERT_EEPROM_RESET_ = 0x1
	// Position of RESERVED field.
	SYSCON_PRESETCTRL0_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	SYSCON_PRESETCTRL0_RESERVED_Msk = 0x400
	// Bit RESERVED.
	SYSCON_PRESETCTRL0_RESERVED = 0x400
	// Position of PMUX_RST field.
	SYSCON_PRESETCTRL0_PMUX_RST_Pos = 0xb
	// Bit mask of PMUX_RST field.
	SYSCON_PRESETCTRL0_PMUX_RST_Msk = 0x800
	// Bit PMUX_RST.
	SYSCON_PRESETCTRL0_PMUX_RST = 0x800
	// Clear pin mux reset.
	SYSCON_PRESETCTRL0_PMUX_RST_CLEAR_PIN_MUX_RESET_ = 0x0
	// Assert pin mux reset.
	SYSCON_PRESETCTRL0_PMUX_RST_ASSERT_PIN_MUX_RESET = 0x1
	// Position of RESERVED field.
	SYSCON_PRESETCTRL0_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	SYSCON_PRESETCTRL0_RESERVED_Msk = 0x1000
	// Bit RESERVED.
	SYSCON_PRESETCTRL0_RESERVED = 0x1000
	// Position of IOCON_RST field.
	SYSCON_PRESETCTRL0_IOCON_RST_Pos = 0xd
	// Bit mask of IOCON_RST field.
	SYSCON_PRESETCTRL0_IOCON_RST_Msk = 0x2000
	// Bit IOCON_RST.
	SYSCON_PRESETCTRL0_IOCON_RST = 0x2000
	// Clear IOCON reset.
	SYSCON_PRESETCTRL0_IOCON_RST_CLEAR_IOCON_RESET_ = 0x0
	// Assert IOCON reset.
	SYSCON_PRESETCTRL0_IOCON_RST_ASSERT_IOCON_RESET_ = 0x1
	// Position of GPIO0_RST field.
	SYSCON_PRESETCTRL0_GPIO0_RST_Pos = 0xe
	// Bit mask of GPIO0_RST field.
	SYSCON_PRESETCTRL0_GPIO0_RST_Msk = 0x4000
	// Bit GPIO0_RST.
	SYSCON_PRESETCTRL0_GPIO0_RST = 0x4000
	// Clear GPIO0 reset.
	SYSCON_PRESETCTRL0_GPIO0_RST_CLEAR_GPIO0_RESET_ = 0x0
	// Assert GPIO0 reset.
	SYSCON_PRESETCTRL0_GPIO0_RST_ASSERT_GPIO0_RESET_ = 0x1
	// Position of GPIO1_RST field.
	SYSCON_PRESETCTRL0_GPIO1_RST_Pos = 0xf
	// Bit mask of GPIO1_RST field.
	SYSCON_PRESETCTRL0_GPIO1_RST_Msk = 0x8000
	// Bit GPIO1_RST.
	SYSCON_PRESETCTRL0_GPIO1_RST = 0x8000
	// Clear GPIO1 reset.
	SYSCON_PRESETCTRL0_GPIO1_RST_CLEAR_GPIO1_RESET_ = 0x0
	// Assert GPIO1 reset.
	SYSCON_PRESETCTRL0_GPIO1_RST_ASSERT_GPIO1_RESET_ = 0x1
	// Position of GPIO2_RST field.
	SYSCON_PRESETCTRL0_GPIO2_RST_Pos = 0x10
	// Bit mask of GPIO2_RST field.
	SYSCON_PRESETCTRL0_GPIO2_RST_Msk = 0x10000
	// Bit GPIO2_RST.
	SYSCON_PRESETCTRL0_GPIO2_RST = 0x10000
	// Clear GPIO2 reset.
	SYSCON_PRESETCTRL0_GPIO2_RST_CLEAR_GPIO2_RESET_ = 0x0
	// Assert GPIO2 reset.
	SYSCON_PRESETCTRL0_GPIO2_RST_ASSERT_GPIO2_RESET_ = 0x1
	// Position of RESERVED field.
	SYSCON_PRESETCTRL0_RESERVED_Pos = 0x11
	// Bit mask of RESERVED field.
	SYSCON_PRESETCTRL0_RESERVED_Msk = 0x20000
	// Bit RESERVED.
	SYSCON_PRESETCTRL0_RESERVED = 0x20000
	// Position of PINT_RST field.
	SYSCON_PRESETCTRL0_PINT_RST_Pos = 0x12
	// Bit mask of PINT_RST field.
	SYSCON_PRESETCTRL0_PINT_RST_Msk = 0x40000
	// Bit PINT_RST.
	SYSCON_PRESETCTRL0_PINT_RST = 0x40000
	// Clear PINT reset.
	SYSCON_PRESETCTRL0_PINT_RST_CLEAR_PINT_RESET_ = 0x0
	// Assert PINT reset.
	SYSCON_PRESETCTRL0_PINT_RST_ASSERT_PINT_RESET_ = 0x1
	// Position of GINT_RST field.
	SYSCON_PRESETCTRL0_GINT_RST_Pos = 0x13
	// Bit mask of GINT_RST field.
	SYSCON_PRESETCTRL0_GINT_RST_Msk = 0x80000
	// Bit GINT_RST.
	SYSCON_PRESETCTRL0_GINT_RST = 0x80000
	// Clear GINT reset.
	SYSCON_PRESETCTRL0_GINT_RST_CLEAR_GINT_RESET_ = 0x0
	// Assert GINT reset.
	SYSCON_PRESETCTRL0_GINT_RST_ASSERT_GINT_RESET_ = 0x1
	// Position of DMA_RST field.
	SYSCON_PRESETCTRL0_DMA_RST_Pos = 0x14
	// Bit mask of DMA_RST field.
	SYSCON_PRESETCTRL0_DMA_RST_Msk = 0x100000
	// Bit DMA_RST.
	SYSCON_PRESETCTRL0_DMA_RST = 0x100000
	// Clear DMA reset.
	SYSCON_PRESETCTRL0_DMA_RST_CLEAR_DMA_RESET_ = 0x0
	// Assert DMA reset.
	SYSCON_PRESETCTRL0_DMA_RST_ASSERT_DMA_RESET_ = 0x1
	// Position of CRC_RST field.
	SYSCON_PRESETCTRL0_CRC_RST_Pos = 0x15
	// Bit mask of CRC_RST field.
	SYSCON_PRESETCTRL0_CRC_RST_Msk = 0x200000
	// Bit CRC_RST.
	SYSCON_PRESETCTRL0_CRC_RST = 0x200000
	// Clear CRC reset.
	SYSCON_PRESETCTRL0_CRC_RST_CLEAR_CRC_RESET_ = 0x0
	// Assert CRC reset.
	SYSCON_PRESETCTRL0_CRC_RST_ASSERT_CRC_RESET_ = 0x1
	// Position of RESERVED field.
	SYSCON_PRESETCTRL0_RESERVED_Pos = 0x16
	// Bit mask of RESERVED field.
	SYSCON_PRESETCTRL0_RESERVED_Msk = 0x7c00000
	// Position of ADC0_RST field.
	SYSCON_PRESETCTRL0_ADC0_RST_Pos = 0x1b
	// Bit mask of ADC0_RST field.
	SYSCON_PRESETCTRL0_ADC0_RST_Msk = 0x8000000
	// Bit ADC0_RST.
	SYSCON_PRESETCTRL0_ADC0_RST = 0x8000000
	// Clear ADC0 reset.
	SYSCON_PRESETCTRL0_ADC0_RST_CLEAR_ADC0_RESET_ = 0x0
	// Assert ADC0 reset.
	SYSCON_PRESETCTRL0_ADC0_RST_ASSERT_ADC0_RESET_ = 0x1
	// Position of ADC1_RST field.
	SYSCON_PRESETCTRL0_ADC1_RST_Pos = 0x1c
	// Bit mask of ADC1_RST field.
	SYSCON_PRESETCTRL0_ADC1_RST_Msk = 0x10000000
	// Bit ADC1_RST.
	SYSCON_PRESETCTRL0_ADC1_RST = 0x10000000
	// Clear ADC1 reset.
	SYSCON_PRESETCTRL0_ADC1_RST_CLEAR_ADC1_RESET_ = 0x0
	// Assert ADC1 reset.
	SYSCON_PRESETCTRL0_ADC1_RST_ASSERT_ADC1_RESET_ = 0x1
	// Position of DAC_RST field.
	SYSCON_PRESETCTRL0_DAC_RST_Pos = 0x1d
	// Bit mask of DAC_RST field.
	SYSCON_PRESETCTRL0_DAC_RST_Msk = 0x20000000
	// Bit DAC_RST.
	SYSCON_PRESETCTRL0_DAC_RST = 0x20000000
	// Clear DAC reset.
	SYSCON_PRESETCTRL0_DAC_RST_CLEAR_DAC_RESET_ = 0x0
	// Assert DAC reset.
	SYSCON_PRESETCTRL0_DAC_RST_ASSERT_DAC_RESET_ = 0x1
	// Position of ACMP_RST field.
	SYSCON_PRESETCTRL0_ACMP_RST_Pos = 0x1e
	// Bit mask of ACMP_RST field.
	SYSCON_PRESETCTRL0_ACMP_RST_Msk = 0x40000000
	// Bit ACMP_RST.
	SYSCON_PRESETCTRL0_ACMP_RST = 0x40000000
	// Clear CMP reset.
	SYSCON_PRESETCTRL0_ACMP_RST_CLEAR_CMP_RESET_ = 0x0
	// Assert CMP reset.
	SYSCON_PRESETCTRL0_ACMP_RST_ASSERT_CMP_RESET_ = 0x1
	// Position of RESERVED field.
	SYSCON_PRESETCTRL0_RESERVED_Pos = 0x1f
	// Bit mask of RESERVED field.
	SYSCON_PRESETCTRL0_RESERVED_Msk = 0x80000000
	// Bit RESERVED.
	SYSCON_PRESETCTRL0_RESERVED = 0x80000000

	// PRESETCTRL1: Peripheral reset control 1
	// Position of MRT_RST field.
	SYSCON_PRESETCTRL1_MRT_RST_Pos = 0x0
	// Bit mask of MRT_RST field.
	SYSCON_PRESETCTRL1_MRT_RST_Msk = 0x1
	// Bit MRT_RST.
	SYSCON_PRESETCTRL1_MRT_RST = 0x1
	// Clear MRT reset.
	SYSCON_PRESETCTRL1_MRT_RST_CLEAR_MRT_RESET_ = 0x0
	// Assert MRT reset.
	SYSCON_PRESETCTRL1_MRT_RST_ASSERT_MRT_RESET_ = 0x1
	// Position of RIT_RST field.
	SYSCON_PRESETCTRL1_RIT_RST_Pos = 0x1
	// Bit mask of RIT_RST field.
	SYSCON_PRESETCTRL1_RIT_RST_Msk = 0x2
	// Bit RIT_RST.
	SYSCON_PRESETCTRL1_RIT_RST = 0x2
	// Clear RIT reset.
	SYSCON_PRESETCTRL1_RIT_RST_CLEAR_RIT_RESET_ = 0x0
	// Assert RIT reset.
	SYSCON_PRESETCTRL1_RIT_RST_ASSERT_RIT_RESET_ = 0x1
	// Position of SCT0_RST field.
	SYSCON_PRESETCTRL1_SCT0_RST_Pos = 0x2
	// Bit mask of SCT0_RST field.
	SYSCON_PRESETCTRL1_SCT0_RST_Msk = 0x4
	// Bit SCT0_RST.
	SYSCON_PRESETCTRL1_SCT0_RST = 0x4
	// Clear SCT0 reset.
	SYSCON_PRESETCTRL1_SCT0_RST_CLEAR_SCT0_RESET_ = 0x0
	// Assert SCT0 reset.
	SYSCON_PRESETCTRL1_SCT0_RST_ASSERT_SCT0_RESET_ = 0x1
	// Position of SCT1_RST field.
	SYSCON_PRESETCTRL1_SCT1_RST_Pos = 0x3
	// Bit mask of SCT1_RST field.
	SYSCON_PRESETCTRL1_SCT1_RST_Msk = 0x8
	// Bit SCT1_RST.
	SYSCON_PRESETCTRL1_SCT1_RST = 0x8
	// Clear SCT1 reset.
	SYSCON_PRESETCTRL1_SCT1_RST_CLEAR_SCT1_RESET_ = 0x0
	// Assert SCT1 reset.
	SYSCON_PRESETCTRL1_SCT1_RST_ASSERT_SCT1_RESET_ = 0x1
	// Position of SCT2_RST field.
	SYSCON_PRESETCTRL1_SCT2_RST_Pos = 0x4
	// Bit mask of SCT2_RST field.
	SYSCON_PRESETCTRL1_SCT2_RST_Msk = 0x10
	// Bit SCT2_RST.
	SYSCON_PRESETCTRL1_SCT2_RST = 0x10
	// Clear SCT2 reset.
	SYSCON_PRESETCTRL1_SCT2_RST_CLEAR_SCT2_RESET_ = 0x0
	// Assert SCT2 reset.
	SYSCON_PRESETCTRL1_SCT2_RST_ASSERT_SCT2_RESET_ = 0x1
	// Position of SCT3_RST field.
	SYSCON_PRESETCTRL1_SCT3_RST_Pos = 0x5
	// Bit mask of SCT3_RST field.
	SYSCON_PRESETCTRL1_SCT3_RST_Msk = 0x20
	// Bit SCT3_RST.
	SYSCON_PRESETCTRL1_SCT3_RST = 0x20
	// Clear SCT3 reset.
	SYSCON_PRESETCTRL1_SCT3_RST_CLEAR_SCT3_RESET_ = 0x0
	// Assert SCT3 reset.
	SYSCON_PRESETCTRL1_SCT3_RST_ASSERT_SCT3_RESET_ = 0x1
	// Position of SCTIPU_RST field.
	SYSCON_PRESETCTRL1_SCTIPU_RST_Pos = 0x6
	// Bit mask of SCTIPU_RST field.
	SYSCON_PRESETCTRL1_SCTIPU_RST_Msk = 0x40
	// Bit SCTIPU_RST.
	SYSCON_PRESETCTRL1_SCTIPU_RST = 0x40
	// Clear SCTIPU reset.
	SYSCON_PRESETCTRL1_SCTIPU_RST_CLEAR_SCTIPU_RESET_ = 0x0
	// Assert SCTIPU reset.
	SYSCON_PRESETCTRL1_SCTIPU_RST_ASSERT_SCTIPU_RESET_ = 0x1
	// Position of CCAN_RST field.
	SYSCON_PRESETCTRL1_CCAN_RST_Pos = 0x7
	// Bit mask of CCAN_RST field.
	SYSCON_PRESETCTRL1_CCAN_RST_Msk = 0x80
	// Bit CCAN_RST.
	SYSCON_PRESETCTRL1_CCAN_RST = 0x80
	// Clear CCAN reset.
	SYSCON_PRESETCTRL1_CCAN_RST_CLEAR_CCAN_RESET_ = 0x0
	// Assert CCAN reset.
	SYSCON_PRESETCTRL1_CCAN_RST_ASSERT_CCAN_RESET_ = 0x1
	// Position of RESERVED field.
	SYSCON_PRESETCTRL1_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_PRESETCTRL1_RESERVED_Msk = 0x100
	// Bit RESERVED.
	SYSCON_PRESETCTRL1_RESERVED = 0x100
	// Position of SPI0_RST field.
	SYSCON_PRESETCTRL1_SPI0_RST_Pos = 0x9
	// Bit mask of SPI0_RST field.
	SYSCON_PRESETCTRL1_SPI0_RST_Msk = 0x200
	// Bit SPI0_RST.
	SYSCON_PRESETCTRL1_SPI0_RST = 0x200
	// Clear SPI0 reset.
	SYSCON_PRESETCTRL1_SPI0_RST_CLEAR_SPI0_RESET_ = 0x0
	// Assert SPI0 reset.
	SYSCON_PRESETCTRL1_SPI0_RST_ASSERT_SPI0_RESET_ = 0x1
	// Position of SPI1_RST field.
	SYSCON_PRESETCTRL1_SPI1_RST_Pos = 0xa
	// Bit mask of SPI1_RST field.
	SYSCON_PRESETCTRL1_SPI1_RST_Msk = 0x400
	// Bit SPI1_RST.
	SYSCON_PRESETCTRL1_SPI1_RST = 0x400
	// Clear SPI1 reset.
	SYSCON_PRESETCTRL1_SPI1_RST_CLEAR_SPI1_RESET_ = 0x0
	// Assert SPI1 reset.
	SYSCON_PRESETCTRL1_SPI1_RST_ASSERT_SPI1_RESET_ = 0x1
	// Position of RESERVED field.
	SYSCON_PRESETCTRL1_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	SYSCON_PRESETCTRL1_RESERVED_Msk = 0x1800
	// Position of I2C0_RST field.
	SYSCON_PRESETCTRL1_I2C0_RST_Pos = 0xd
	// Bit mask of I2C0_RST field.
	SYSCON_PRESETCTRL1_I2C0_RST_Msk = 0x2000
	// Bit I2C0_RST.
	SYSCON_PRESETCTRL1_I2C0_RST = 0x2000
	// Clear I2C0 reset.
	SYSCON_PRESETCTRL1_I2C0_RST_CLEAR_I2C0_RESET_ = 0x0
	// Assert I2C0 reset.
	SYSCON_PRESETCTRL1_I2C0_RST_ASSERT_I2C0_RESET_ = 0x1
	// Position of RESERVED field.
	SYSCON_PRESETCTRL1_RESERVED_Pos = 0xe
	// Bit mask of RESERVED field.
	SYSCON_PRESETCTRL1_RESERVED_Msk = 0x1c000
	// Position of UART0_RST field.
	SYSCON_PRESETCTRL1_UART0_RST_Pos = 0x11
	// Bit mask of UART0_RST field.
	SYSCON_PRESETCTRL1_UART0_RST_Msk = 0x20000
	// Bit UART0_RST.
	SYSCON_PRESETCTRL1_UART0_RST = 0x20000
	// Clear UART0 reset.
	SYSCON_PRESETCTRL1_UART0_RST_CLEAR_UART0_RESET_ = 0x0
	// Assert UART0 reset.
	SYSCON_PRESETCTRL1_UART0_RST_ASSERT_UART0_RESET_ = 0x1
	// Position of UART1_RST field.
	SYSCON_PRESETCTRL1_UART1_RST_Pos = 0x12
	// Bit mask of UART1_RST field.
	SYSCON_PRESETCTRL1_UART1_RST_Msk = 0x40000
	// Bit UART1_RST.
	SYSCON_PRESETCTRL1_UART1_RST = 0x40000
	// Clear UART1 reset.
	SYSCON_PRESETCTRL1_UART1_RST_CLEAR_UART1_RESET_ = 0x0
	// Assert UART1 reset.
	SYSCON_PRESETCTRL1_UART1_RST_ASSERT_UART1_RESET_ = 0x1
	// Position of UART2_RST field.
	SYSCON_PRESETCTRL1_UART2_RST_Pos = 0x13
	// Bit mask of UART2_RST field.
	SYSCON_PRESETCTRL1_UART2_RST_Msk = 0x80000
	// Bit UART2_RST.
	SYSCON_PRESETCTRL1_UART2_RST = 0x80000
	// Clear UART2 reset.
	SYSCON_PRESETCTRL1_UART2_RST_CLEAR_UART2_RESET_ = 0x0
	// Assert UART2 reset.
	SYSCON_PRESETCTRL1_UART2_RST_ASSERT_UART2_RESET_ = 0x1
	// Position of RESERVED field.
	SYSCON_PRESETCTRL1_RESERVED_Pos = 0x14
	// Bit mask of RESERVED field.
	SYSCON_PRESETCTRL1_RESERVED_Msk = 0x100000
	// Bit RESERVED.
	SYSCON_PRESETCTRL1_RESERVED = 0x100000
	// Position of QEI0_RST field.
	SYSCON_PRESETCTRL1_QEI0_RST_Pos = 0x15
	// Bit mask of QEI0_RST field.
	SYSCON_PRESETCTRL1_QEI0_RST_Msk = 0x200000
	// Bit QEI0_RST.
	SYSCON_PRESETCTRL1_QEI0_RST = 0x200000
	// Clear QEI0 reset.
	SYSCON_PRESETCTRL1_QEI0_RST_CLEAR_QEI0_RESET_ = 0x0
	// Assert QEI0 reset.
	SYSCON_PRESETCTRL1_QEI0_RST_ASSERT_QEI0_RESET_ = 0x1
	// Position of RESERVED field.
	SYSCON_PRESETCTRL1_RESERVED_Pos = 0x16
	// Bit mask of RESERVED field.
	SYSCON_PRESETCTRL1_RESERVED_Msk = 0x400000
	// Bit RESERVED.
	SYSCON_PRESETCTRL1_RESERVED = 0x400000
	// Position of USB_RST field.
	SYSCON_PRESETCTRL1_USB_RST_Pos = 0x17
	// Bit mask of USB_RST field.
	SYSCON_PRESETCTRL1_USB_RST_Msk = 0x800000
	// Bit USB_RST.
	SYSCON_PRESETCTRL1_USB_RST = 0x800000
	// Clear USB reset.
	SYSCON_PRESETCTRL1_USB_RST_CLEAR_USB_RESET_ = 0x0
	// Assert USB reset.
	SYSCON_PRESETCTRL1_USB_RST_ASSERT_USB_RESET_ = 0x1
	// Position of RESERVED field.
	SYSCON_PRESETCTRL1_RESERVED_Pos = 0x18
	// Bit mask of RESERVED field.
	SYSCON_PRESETCTRL1_RESERVED_Msk = 0xff000000

	// PIOPORCAP0: POR captured PIO status 0
	// Position of PIOSTAT field.
	SYSCON_PIOPORCAP0_PIOSTAT_Pos = 0x0
	// Bit mask of PIOSTAT field.
	SYSCON_PIOPORCAP0_PIOSTAT_Msk = 0xffffffff

	// PIOPORCAP1: POR captured PIO status 1
	// Position of PIOSTAT field.
	SYSCON_PIOPORCAP1_PIOSTAT_Pos = 0x0
	// Bit mask of PIOSTAT field.
	SYSCON_PIOPORCAP1_PIOSTAT_Msk = 0xffffffff

	// PIOPORCAP2: POR captured PIO status 2
	// Position of PIOSTAT field.
	SYSCON_PIOPORCAP2_PIOSTAT_Pos = 0x0
	// Bit mask of PIOSTAT field.
	SYSCON_PIOPORCAP2_PIOSTAT_Msk = 0xfff
	// Position of RESERVED field.
	SYSCON_PIOPORCAP2_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	SYSCON_PIOPORCAP2_RESERVED_Msk = 0xfffff000

	// MAINCLKSELA: Main clock source select A
	// Position of SEL field.
	SYSCON_MAINCLKSELA_SEL_Pos = 0x0
	// Bit mask of SEL field.
	SYSCON_MAINCLKSELA_SEL_Msk = 0x3
	// IRC Oscillator
	SYSCON_MAINCLKSELA_SEL_IRC_OSCILLATOR = 0x0
	// System oscillator
	SYSCON_MAINCLKSELA_SEL_SYSTEM_OSCILLATOR = 0x1
	// Watchdog oscillator
	SYSCON_MAINCLKSELA_SEL_WATCHDOG_OSCILLATOR = 0x2
	// Position of RESERVED field.
	SYSCON_MAINCLKSELA_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	SYSCON_MAINCLKSELA_RESERVED_Msk = 0xfffffffc

	// MAINCLKSELB: Main clock source select B
	// Position of SEL field.
	SYSCON_MAINCLKSELB_SEL_Pos = 0x0
	// Bit mask of SEL field.
	SYSCON_MAINCLKSELB_SEL_Msk = 0x3
	// MAINCLKSELA. Clock source selected in MAINCLKSELA register.
	SYSCON_MAINCLKSELB_SEL_MAINCLKSELA_CLOCK_S = 0x0
	// System PLL input.
	SYSCON_MAINCLKSELB_SEL_SYSTEM_PLL_INPUT_ = 0x1
	// System PLL output.
	SYSCON_MAINCLKSELB_SEL_SYSTEM_PLL_OUTPUT_ = 0x2
	// RTC oscillator 32 kHz output.
	SYSCON_MAINCLKSELB_SEL_RTC_OSCILLATOR_32_KH = 0x3
	// Position of RESERVED field.
	SYSCON_MAINCLKSELB_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	SYSCON_MAINCLKSELB_RESERVED_Msk = 0xfffffffc

	// USBCLKSEL: USB clock source select
	// Position of SEL field.
	SYSCON_USBCLKSEL_SEL_Pos = 0x0
	// Bit mask of SEL field.
	SYSCON_USBCLKSEL_SEL_Msk = 0x3
	// IRC Oscillator
	SYSCON_USBCLKSEL_SEL_IRC_OSCILLATOR = 0x0
	// System oscillator
	SYSCON_USBCLKSEL_SEL_SYSTEM_OSCILLATOR = 0x1
	// USB PLL out
	SYSCON_USBCLKSEL_SEL_USB_PLL_OUT = 0x2
	// Main clock
	SYSCON_USBCLKSEL_SEL_MAIN_CLOCK = 0x3
	// Position of RESERVED field.
	SYSCON_USBCLKSEL_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	SYSCON_USBCLKSEL_RESERVED_Msk = 0xfffffffc

	// ADCASYNCCLKSEL: ADC asynchronous clock source select
	// Position of SEL field.
	SYSCON_ADCASYNCCLKSEL_SEL_Pos = 0x0
	// Bit mask of SEL field.
	SYSCON_ADCASYNCCLKSEL_SEL_Msk = 0x3
	// IRC Oscillator
	SYSCON_ADCASYNCCLKSEL_SEL_IRC_OSCILLATOR = 0x0
	// System PLL output
	SYSCON_ADCASYNCCLKSEL_SEL_SYSTEM_PLL_OUTPUT = 0x1
	// USB PLL output
	SYSCON_ADCASYNCCLKSEL_SEL_USB_PLL_OUTPUT = 0x2
	// SCT PLL output
	SYSCON_ADCASYNCCLKSEL_SEL_SCT_PLL_OUTPUT = 0x3
	// Position of RESERVED field.
	SYSCON_ADCASYNCCLKSEL_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	SYSCON_ADCASYNCCLKSEL_RESERVED_Msk = 0xfffffffc

	// CLKOUTSELA: CLKOUT clock source select A
	// Position of SEL field.
	SYSCON_CLKOUTSELA_SEL_Pos = 0x0
	// Bit mask of SEL field.
	SYSCON_CLKOUTSELA_SEL_Msk = 0x3
	// IRC oscillator
	SYSCON_CLKOUTSELA_SEL_IRC_OSCILLATOR = 0x0
	// Crystal oscillator (SYSOSC)
	SYSCON_CLKOUTSELA_SEL_CRYSTAL_OSCILLATOR_ = 0x1
	// Watchdog oscillator
	SYSCON_CLKOUTSELA_SEL_WATCHDOG_OSCILLATOR = 0x2
	// Main clock
	SYSCON_CLKOUTSELA_SEL_MAIN_CLOCK = 0x3
	// Position of RESERVED field.
	SYSCON_CLKOUTSELA_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	SYSCON_CLKOUTSELA_RESERVED_Msk = 0xfffffffc

	// CLKOUTSELB: CLKOUT clock source select B
	// Position of SEL field.
	SYSCON_CLKOUTSELB_SEL_Pos = 0x0
	// Bit mask of SEL field.
	SYSCON_CLKOUTSELB_SEL_Msk = 0x3
	// CLKOUTSELA. Clock source selected in the CLKOUTSELA register.
	SYSCON_CLKOUTSELB_SEL_CLKOUTSELA_CLOCK_SO = 0x0
	// USB PLL output .
	SYSCON_CLKOUTSELB_SEL_USB_PLL_OUTPUT_ = 0x1
	// SCT PLL output .
	SYSCON_CLKOUTSELB_SEL_SCT_PLL_OUTPUT_ = 0x2
	// RTC 32 kHz output.
	SYSCON_CLKOUTSELB_SEL_RTC_32_KHZ_OUTPUT_ = 0x3
	// Position of RESERVED field.
	SYSCON_CLKOUTSELB_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	SYSCON_CLKOUTSELB_RESERVED_Msk = 0xfffffffc

	// SYSPLLCLKSEL: System PLL clock source select
	// Position of SEL field.
	SYSCON_SYSPLLCLKSEL_SEL_Pos = 0x0
	// Bit mask of SEL field.
	SYSCON_SYSPLLCLKSEL_SEL_Msk = 0x3
	// IRC
	SYSCON_SYSPLLCLKSEL_SEL_IRC = 0x0
	// Crystal Oscillator (SYSOSC)
	SYSCON_SYSPLLCLKSEL_SEL_CRYSTAL_OSCILLATOR_ = 0x1
	// Position of RESERVED field.
	SYSCON_SYSPLLCLKSEL_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	SYSCON_SYSPLLCLKSEL_RESERVED_Msk = 0xfffffffc

	// USBPLLCLKSEL: USB PLL clock source select
	// Position of SEL field.
	SYSCON_USBPLLCLKSEL_SEL_Pos = 0x0
	// Bit mask of SEL field.
	SYSCON_USBPLLCLKSEL_SEL_Msk = 0x3
	// IRC. The USB PLL clock source must be switched to system oscillator for correct USB operation.In low-speed mode IRC is ok?
	SYSCON_USBPLLCLKSEL_SEL_IRC_THE_USB_PLL_CLO = 0x0
	// System oscillator
	SYSCON_USBPLLCLKSEL_SEL_SYSTEM_OSCILLATOR = 0x1
	// Position of RESERVED field.
	SYSCON_USBPLLCLKSEL_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	SYSCON_USBPLLCLKSEL_RESERVED_Msk = 0xfffffffc

	// SCTPLLCLKSEL: SCT PLL clock source select
	// Position of SEL field.
	SYSCON_SCTPLLCLKSEL_SEL_Pos = 0x0
	// Bit mask of SEL field.
	SYSCON_SCTPLLCLKSEL_SEL_Msk = 0x3
	// IRC
	SYSCON_SCTPLLCLKSEL_SEL_IRC = 0x0
	// System oscillator
	SYSCON_SCTPLLCLKSEL_SEL_SYSTEM_OSCILLATOR = 0x1
	// Position of RESERVED field.
	SYSCON_SCTPLLCLKSEL_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	SYSCON_SCTPLLCLKSEL_RESERVED_Msk = 0xfffffffc

	// SYSAHBCLKDIV: System clock divider
	// Position of DIV field.
	SYSCON_SYSAHBCLKDIV_DIV_Pos = 0x0
	// Bit mask of DIV field.
	SYSCON_SYSAHBCLKDIV_DIV_Msk = 0xff
	// Position of RESERVED field.
	SYSCON_SYSAHBCLKDIV_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_SYSAHBCLKDIV_RESERVED_Msk = 0xffffff00

	// SYSAHBCLKCTRL0: System clock control 0
	// Position of SYS field.
	SYSCON_SYSAHBCLKCTRL0_SYS_Pos = 0x0
	// Bit mask of SYS field.
	SYSCON_SYSAHBCLKCTRL0_SYS_Msk = 0x1
	// Bit SYS.
	SYSCON_SYSAHBCLKCTRL0_SYS = 0x1
	// Enable
	SYSCON_SYSAHBCLKCTRL0_SYS_ENABLE = 0x1
	// Position of ROM field.
	SYSCON_SYSAHBCLKCTRL0_ROM_Pos = 0x1
	// Bit mask of ROM field.
	SYSCON_SYSAHBCLKCTRL0_ROM_Msk = 0x2
	// Bit ROM.
	SYSCON_SYSAHBCLKCTRL0_ROM = 0x2
	// Disable
	SYSCON_SYSAHBCLKCTRL0_ROM_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL0_ROM_ENABLE = 0x1
	// Position of RESERVED field.
	SYSCON_SYSAHBCLKCTRL0_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	SYSCON_SYSAHBCLKCTRL0_RESERVED_Msk = 0x4
	// Bit RESERVED.
	SYSCON_SYSAHBCLKCTRL0_RESERVED = 0x4
	// Position of SRAM1 field.
	SYSCON_SYSAHBCLKCTRL0_SRAM1_Pos = 0x3
	// Bit mask of SRAM1 field.
	SYSCON_SYSAHBCLKCTRL0_SRAM1_Msk = 0x8
	// Bit SRAM1.
	SYSCON_SYSAHBCLKCTRL0_SRAM1 = 0x8
	// Disable
	SYSCON_SYSAHBCLKCTRL0_SRAM1_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL0_SRAM1_ENABLE = 0x1
	// Position of SRAM2 field.
	SYSCON_SYSAHBCLKCTRL0_SRAM2_Pos = 0x4
	// Bit mask of SRAM2 field.
	SYSCON_SYSAHBCLKCTRL0_SRAM2_Msk = 0x10
	// Bit SRAM2.
	SYSCON_SYSAHBCLKCTRL0_SRAM2 = 0x10
	// Disable
	SYSCON_SYSAHBCLKCTRL0_SRAM2_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL0_SRAM2_ENABLE = 0x1
	// Position of RESERVED field.
	SYSCON_SYSAHBCLKCTRL0_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	SYSCON_SYSAHBCLKCTRL0_RESERVED_Msk = 0x60
	// Position of FLASH field.
	SYSCON_SYSAHBCLKCTRL0_FLASH_Pos = 0x7
	// Bit mask of FLASH field.
	SYSCON_SYSAHBCLKCTRL0_FLASH_Msk = 0x80
	// Bit FLASH.
	SYSCON_SYSAHBCLKCTRL0_FLASH = 0x80
	// Disable
	SYSCON_SYSAHBCLKCTRL0_FLASH_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL0_FLASH_ENABLE = 0x1
	// Position of FMC field.
	SYSCON_SYSAHBCLKCTRL0_FMC_Pos = 0x8
	// Bit mask of FMC field.
	SYSCON_SYSAHBCLKCTRL0_FMC_Msk = 0x100
	// Bit FMC.
	SYSCON_SYSAHBCLKCTRL0_FMC = 0x100
	// Disable
	SYSCON_SYSAHBCLKCTRL0_FMC_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL0_FMC_ENABLE = 0x1
	// Position of EEPROM field.
	SYSCON_SYSAHBCLKCTRL0_EEPROM_Pos = 0x9
	// Bit mask of EEPROM field.
	SYSCON_SYSAHBCLKCTRL0_EEPROM_Msk = 0x200
	// Bit EEPROM.
	SYSCON_SYSAHBCLKCTRL0_EEPROM = 0x200
	// Disable
	SYSCON_SYSAHBCLKCTRL0_EEPROM_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL0_EEPROM_ENABLE = 0x1
	// Position of RESERVED field.
	SYSCON_SYSAHBCLKCTRL0_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	SYSCON_SYSAHBCLKCTRL0_RESERVED_Msk = 0x400
	// Bit RESERVED.
	SYSCON_SYSAHBCLKCTRL0_RESERVED = 0x400
	// Position of PMUX field.
	SYSCON_SYSAHBCLKCTRL0_PMUX_Pos = 0xb
	// Bit mask of PMUX field.
	SYSCON_SYSAHBCLKCTRL0_PMUX_Msk = 0x800
	// Bit PMUX.
	SYSCON_SYSAHBCLKCTRL0_PMUX = 0x800
	// Disable
	SYSCON_SYSAHBCLKCTRL0_PMUX_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL0_PMUX_ENABLE = 0x1
	// Position of SWM field.
	SYSCON_SYSAHBCLKCTRL0_SWM_Pos = 0xc
	// Bit mask of SWM field.
	SYSCON_SYSAHBCLKCTRL0_SWM_Msk = 0x1000
	// Bit SWM.
	SYSCON_SYSAHBCLKCTRL0_SWM = 0x1000
	// Disable
	SYSCON_SYSAHBCLKCTRL0_SWM_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL0_SWM_ENABLE = 0x1
	// Position of IOCON field.
	SYSCON_SYSAHBCLKCTRL0_IOCON_Pos = 0xd
	// Bit mask of IOCON field.
	SYSCON_SYSAHBCLKCTRL0_IOCON_Msk = 0x2000
	// Bit IOCON.
	SYSCON_SYSAHBCLKCTRL0_IOCON = 0x2000
	// Disable
	SYSCON_SYSAHBCLKCTRL0_IOCON_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL0_IOCON_ENABLE = 0x1
	// Position of GPIO0 field.
	SYSCON_SYSAHBCLKCTRL0_GPIO0_Pos = 0xe
	// Bit mask of GPIO0 field.
	SYSCON_SYSAHBCLKCTRL0_GPIO0_Msk = 0x4000
	// Bit GPIO0.
	SYSCON_SYSAHBCLKCTRL0_GPIO0 = 0x4000
	// Disable
	SYSCON_SYSAHBCLKCTRL0_GPIO0_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL0_GPIO0_ENABLE = 0x1
	// Position of GPIO1 field.
	SYSCON_SYSAHBCLKCTRL0_GPIO1_Pos = 0xf
	// Bit mask of GPIO1 field.
	SYSCON_SYSAHBCLKCTRL0_GPIO1_Msk = 0x8000
	// Bit GPIO1.
	SYSCON_SYSAHBCLKCTRL0_GPIO1 = 0x8000
	// Disable
	SYSCON_SYSAHBCLKCTRL0_GPIO1_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL0_GPIO1_ENABLE = 0x1
	// Position of GPIO2 field.
	SYSCON_SYSAHBCLKCTRL0_GPIO2_Pos = 0x10
	// Bit mask of GPIO2 field.
	SYSCON_SYSAHBCLKCTRL0_GPIO2_Msk = 0x10000
	// Bit GPIO2.
	SYSCON_SYSAHBCLKCTRL0_GPIO2 = 0x10000
	// Disable
	SYSCON_SYSAHBCLKCTRL0_GPIO2_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL0_GPIO2_ENABLE = 0x1
	// Position of RESERVED field.
	SYSCON_SYSAHBCLKCTRL0_RESERVED_Pos = 0x11
	// Bit mask of RESERVED field.
	SYSCON_SYSAHBCLKCTRL0_RESERVED_Msk = 0x20000
	// Bit RESERVED.
	SYSCON_SYSAHBCLKCTRL0_RESERVED = 0x20000
	// Position of PINT field.
	SYSCON_SYSAHBCLKCTRL0_PINT_Pos = 0x12
	// Bit mask of PINT field.
	SYSCON_SYSAHBCLKCTRL0_PINT_Msk = 0x40000
	// Bit PINT.
	SYSCON_SYSAHBCLKCTRL0_PINT = 0x40000
	// Disable
	SYSCON_SYSAHBCLKCTRL0_PINT_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL0_PINT_ENABLE = 0x1
	// Position of GINT field.
	SYSCON_SYSAHBCLKCTRL0_GINT_Pos = 0x13
	// Bit mask of GINT field.
	SYSCON_SYSAHBCLKCTRL0_GINT_Msk = 0x80000
	// Bit GINT.
	SYSCON_SYSAHBCLKCTRL0_GINT = 0x80000
	// Disable
	SYSCON_SYSAHBCLKCTRL0_GINT_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL0_GINT_ENABLE = 0x1
	// Position of DMA field.
	SYSCON_SYSAHBCLKCTRL0_DMA_Pos = 0x14
	// Bit mask of DMA field.
	SYSCON_SYSAHBCLKCTRL0_DMA_Msk = 0x100000
	// Bit DMA.
	SYSCON_SYSAHBCLKCTRL0_DMA = 0x100000
	// Disable
	SYSCON_SYSAHBCLKCTRL0_DMA_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL0_DMA_ENABLE = 0x1
	// Position of CRC field.
	SYSCON_SYSAHBCLKCTRL0_CRC_Pos = 0x15
	// Bit mask of CRC field.
	SYSCON_SYSAHBCLKCTRL0_CRC_Msk = 0x200000
	// Bit CRC.
	SYSCON_SYSAHBCLKCTRL0_CRC = 0x200000
	// Disable
	SYSCON_SYSAHBCLKCTRL0_CRC_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL0_CRC_ENABLE = 0x1
	// Position of WWDT field.
	SYSCON_SYSAHBCLKCTRL0_WWDT_Pos = 0x16
	// Bit mask of WWDT field.
	SYSCON_SYSAHBCLKCTRL0_WWDT_Msk = 0x400000
	// Bit WWDT.
	SYSCON_SYSAHBCLKCTRL0_WWDT = 0x400000
	// Disable
	SYSCON_SYSAHBCLKCTRL0_WWDT_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL0_WWDT_ENABLE = 0x1
	// Position of RTC field.
	SYSCON_SYSAHBCLKCTRL0_RTC_Pos = 0x17
	// Bit mask of RTC field.
	SYSCON_SYSAHBCLKCTRL0_RTC_Msk = 0x800000
	// Bit RTC.
	SYSCON_SYSAHBCLKCTRL0_RTC = 0x800000
	// Disable
	SYSCON_SYSAHBCLKCTRL0_RTC_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL0_RTC_ENABLE = 0x1
	// Position of RESERVED field.
	SYSCON_SYSAHBCLKCTRL0_RESERVED_Pos = 0x18
	// Bit mask of RESERVED field.
	SYSCON_SYSAHBCLKCTRL0_RESERVED_Msk = 0x7000000
	// Position of ADC0 field.
	SYSCON_SYSAHBCLKCTRL0_ADC0_Pos = 0x1b
	// Bit mask of ADC0 field.
	SYSCON_SYSAHBCLKCTRL0_ADC0_Msk = 0x8000000
	// Bit ADC0.
	SYSCON_SYSAHBCLKCTRL0_ADC0 = 0x8000000
	// Disable
	SYSCON_SYSAHBCLKCTRL0_ADC0_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL0_ADC0_ENABLE = 0x1
	// Position of ADC1 field.
	SYSCON_SYSAHBCLKCTRL0_ADC1_Pos = 0x1c
	// Bit mask of ADC1 field.
	SYSCON_SYSAHBCLKCTRL0_ADC1_Msk = 0x10000000
	// Bit ADC1.
	SYSCON_SYSAHBCLKCTRL0_ADC1 = 0x10000000
	// Disable
	SYSCON_SYSAHBCLKCTRL0_ADC1_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL0_ADC1_ENABLE = 0x1
	// Position of DAC field.
	SYSCON_SYSAHBCLKCTRL0_DAC_Pos = 0x1d
	// Bit mask of DAC field.
	SYSCON_SYSAHBCLKCTRL0_DAC_Msk = 0x20000000
	// Bit DAC.
	SYSCON_SYSAHBCLKCTRL0_DAC = 0x20000000
	// Disable
	SYSCON_SYSAHBCLKCTRL0_DAC_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL0_DAC_ENABLE = 0x1
	// Position of CMP field.
	SYSCON_SYSAHBCLKCTRL0_CMP_Pos = 0x1e
	// Bit mask of CMP field.
	SYSCON_SYSAHBCLKCTRL0_CMP_Msk = 0x40000000
	// Bit CMP.
	SYSCON_SYSAHBCLKCTRL0_CMP = 0x40000000
	// Disable
	SYSCON_SYSAHBCLKCTRL0_CMP_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL0_CMP_ENABLE = 0x1
	// Position of RESERVED field.
	SYSCON_SYSAHBCLKCTRL0_RESERVED_Pos = 0x1f
	// Bit mask of RESERVED field.
	SYSCON_SYSAHBCLKCTRL0_RESERVED_Msk = 0x80000000
	// Bit RESERVED.
	SYSCON_SYSAHBCLKCTRL0_RESERVED = 0x80000000

	// SYSAHBCLKCTRL1: System clock control 1
	// Position of MRT field.
	SYSCON_SYSAHBCLKCTRL1_MRT_Pos = 0x0
	// Bit mask of MRT field.
	SYSCON_SYSAHBCLKCTRL1_MRT_Msk = 0x1
	// Bit MRT.
	SYSCON_SYSAHBCLKCTRL1_MRT = 0x1
	// Disable
	SYSCON_SYSAHBCLKCTRL1_MRT_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL1_MRT_ENABLE = 0x1
	// Position of RIT field.
	SYSCON_SYSAHBCLKCTRL1_RIT_Pos = 0x1
	// Bit mask of RIT field.
	SYSCON_SYSAHBCLKCTRL1_RIT_Msk = 0x2
	// Bit RIT.
	SYSCON_SYSAHBCLKCTRL1_RIT = 0x2
	// Disable
	SYSCON_SYSAHBCLKCTRL1_RIT_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL1_RIT_ENABLE = 0x1
	// Position of SCT0 field.
	SYSCON_SYSAHBCLKCTRL1_SCT0_Pos = 0x2
	// Bit mask of SCT0 field.
	SYSCON_SYSAHBCLKCTRL1_SCT0_Msk = 0x4
	// Bit SCT0.
	SYSCON_SYSAHBCLKCTRL1_SCT0 = 0x4
	// Disable
	SYSCON_SYSAHBCLKCTRL1_SCT0_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL1_SCT0_ENABLE = 0x1
	// Position of SCT1 field.
	SYSCON_SYSAHBCLKCTRL1_SCT1_Pos = 0x3
	// Bit mask of SCT1 field.
	SYSCON_SYSAHBCLKCTRL1_SCT1_Msk = 0x8
	// Bit SCT1.
	SYSCON_SYSAHBCLKCTRL1_SCT1 = 0x8
	// Disable
	SYSCON_SYSAHBCLKCTRL1_SCT1_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL1_SCT1_ENABLE = 0x1
	// Position of SCT2 field.
	SYSCON_SYSAHBCLKCTRL1_SCT2_Pos = 0x4
	// Bit mask of SCT2 field.
	SYSCON_SYSAHBCLKCTRL1_SCT2_Msk = 0x10
	// Bit SCT2.
	SYSCON_SYSAHBCLKCTRL1_SCT2 = 0x10
	// Disable
	SYSCON_SYSAHBCLKCTRL1_SCT2_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL1_SCT2_ENABLE = 0x1
	// Position of SCT3 field.
	SYSCON_SYSAHBCLKCTRL1_SCT3_Pos = 0x5
	// Bit mask of SCT3 field.
	SYSCON_SYSAHBCLKCTRL1_SCT3_Msk = 0x20
	// Bit SCT3.
	SYSCON_SYSAHBCLKCTRL1_SCT3 = 0x20
	// Disable
	SYSCON_SYSAHBCLKCTRL1_SCT3_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL1_SCT3_ENABLE = 0x1
	// Position of SCTIPU field.
	SYSCON_SYSAHBCLKCTRL1_SCTIPU_Pos = 0x6
	// Bit mask of SCTIPU field.
	SYSCON_SYSAHBCLKCTRL1_SCTIPU_Msk = 0x40
	// Bit SCTIPU.
	SYSCON_SYSAHBCLKCTRL1_SCTIPU = 0x40
	// Disable
	SYSCON_SYSAHBCLKCTRL1_SCTIPU_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL1_SCTIPU_ENABLE = 0x1
	// Position of CCAN field.
	SYSCON_SYSAHBCLKCTRL1_CCAN_Pos = 0x7
	// Bit mask of CCAN field.
	SYSCON_SYSAHBCLKCTRL1_CCAN_Msk = 0x80
	// Bit CCAN.
	SYSCON_SYSAHBCLKCTRL1_CCAN = 0x80
	// Disable
	SYSCON_SYSAHBCLKCTRL1_CCAN_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL1_CCAN_ENABLE = 0x1
	// Position of RESERVED field.
	SYSCON_SYSAHBCLKCTRL1_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_SYSAHBCLKCTRL1_RESERVED_Msk = 0x100
	// Bit RESERVED.
	SYSCON_SYSAHBCLKCTRL1_RESERVED = 0x100
	// Position of SPI0 field.
	SYSCON_SYSAHBCLKCTRL1_SPI0_Pos = 0x9
	// Bit mask of SPI0 field.
	SYSCON_SYSAHBCLKCTRL1_SPI0_Msk = 0x200
	// Bit SPI0.
	SYSCON_SYSAHBCLKCTRL1_SPI0 = 0x200
	// Disable
	SYSCON_SYSAHBCLKCTRL1_SPI0_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL1_SPI0_ENABLE = 0x1
	// Position of SPI1 field.
	SYSCON_SYSAHBCLKCTRL1_SPI1_Pos = 0xa
	// Bit mask of SPI1 field.
	SYSCON_SYSAHBCLKCTRL1_SPI1_Msk = 0x400
	// Bit SPI1.
	SYSCON_SYSAHBCLKCTRL1_SPI1 = 0x400
	// Disable
	SYSCON_SYSAHBCLKCTRL1_SPI1_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL1_SPI1_ENABLE = 0x1
	// Position of RESERVED field.
	SYSCON_SYSAHBCLKCTRL1_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	SYSCON_SYSAHBCLKCTRL1_RESERVED_Msk = 0x1800
	// Position of I2C0 field.
	SYSCON_SYSAHBCLKCTRL1_I2C0_Pos = 0xd
	// Bit mask of I2C0 field.
	SYSCON_SYSAHBCLKCTRL1_I2C0_Msk = 0x2000
	// Bit I2C0.
	SYSCON_SYSAHBCLKCTRL1_I2C0 = 0x2000
	// Disable
	SYSCON_SYSAHBCLKCTRL1_I2C0_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL1_I2C0_ENABLE = 0x1
	// Position of I2C1 field.
	SYSCON_SYSAHBCLKCTRL1_I2C1_Pos = 0xe
	// Bit mask of I2C1 field.
	SYSCON_SYSAHBCLKCTRL1_I2C1_Msk = 0x4000
	// Bit I2C1.
	SYSCON_SYSAHBCLKCTRL1_I2C1 = 0x4000
	// Disable
	SYSCON_SYSAHBCLKCTRL1_I2C1_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL1_I2C1_ENABLE = 0x1
	// Position of RESERVED field.
	SYSCON_SYSAHBCLKCTRL1_RESERVED_Pos = 0xf
	// Bit mask of RESERVED field.
	SYSCON_SYSAHBCLKCTRL1_RESERVED_Msk = 0x18000
	// Position of UART0 field.
	SYSCON_SYSAHBCLKCTRL1_UART0_Pos = 0x11
	// Bit mask of UART0 field.
	SYSCON_SYSAHBCLKCTRL1_UART0_Msk = 0x20000
	// Bit UART0.
	SYSCON_SYSAHBCLKCTRL1_UART0 = 0x20000
	// Disable
	SYSCON_SYSAHBCLKCTRL1_UART0_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL1_UART0_ENABLE = 0x1
	// Position of UART1 field.
	SYSCON_SYSAHBCLKCTRL1_UART1_Pos = 0x12
	// Bit mask of UART1 field.
	SYSCON_SYSAHBCLKCTRL1_UART1_Msk = 0x40000
	// Bit UART1.
	SYSCON_SYSAHBCLKCTRL1_UART1 = 0x40000
	// Disable
	SYSCON_SYSAHBCLKCTRL1_UART1_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL1_UART1_ENABLE = 0x1
	// Position of UART2 field.
	SYSCON_SYSAHBCLKCTRL1_UART2_Pos = 0x13
	// Bit mask of UART2 field.
	SYSCON_SYSAHBCLKCTRL1_UART2_Msk = 0x80000
	// Bit UART2.
	SYSCON_SYSAHBCLKCTRL1_UART2 = 0x80000
	// Disable
	SYSCON_SYSAHBCLKCTRL1_UART2_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL1_UART2_ENABLE = 0x1
	// Position of RESERVED field.
	SYSCON_SYSAHBCLKCTRL1_RESERVED_Pos = 0x14
	// Bit mask of RESERVED field.
	SYSCON_SYSAHBCLKCTRL1_RESERVED_Msk = 0x100000
	// Bit RESERVED.
	SYSCON_SYSAHBCLKCTRL1_RESERVED = 0x100000
	// Position of QEI field.
	SYSCON_SYSAHBCLKCTRL1_QEI_Pos = 0x15
	// Bit mask of QEI field.
	SYSCON_SYSAHBCLKCTRL1_QEI_Msk = 0x200000
	// Bit QEI.
	SYSCON_SYSAHBCLKCTRL1_QEI = 0x200000
	// Disable
	SYSCON_SYSAHBCLKCTRL1_QEI_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL1_QEI_ENABLE = 0x1
	// Position of RESERVED field.
	SYSCON_SYSAHBCLKCTRL1_RESERVED_Pos = 0x16
	// Bit mask of RESERVED field.
	SYSCON_SYSAHBCLKCTRL1_RESERVED_Msk = 0x400000
	// Bit RESERVED.
	SYSCON_SYSAHBCLKCTRL1_RESERVED = 0x400000
	// Position of USB field.
	SYSCON_SYSAHBCLKCTRL1_USB_Pos = 0x17
	// Bit mask of USB field.
	SYSCON_SYSAHBCLKCTRL1_USB_Msk = 0x800000
	// Bit USB.
	SYSCON_SYSAHBCLKCTRL1_USB = 0x800000
	// Disable
	SYSCON_SYSAHBCLKCTRL1_USB_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL1_USB_ENABLE = 0x1
	// Position of RESERVED field.
	SYSCON_SYSAHBCLKCTRL1_RESERVED_Pos = 0x18
	// Bit mask of RESERVED field.
	SYSCON_SYSAHBCLKCTRL1_RESERVED_Msk = 0xff000000

	// SYSTICKCLKDIV: SYSTICK clock divider
	// Position of DIV field.
	SYSCON_SYSTICKCLKDIV_DIV_Pos = 0x0
	// Bit mask of DIV field.
	SYSCON_SYSTICKCLKDIV_DIV_Msk = 0xff
	// Position of RESERVED field.
	SYSCON_SYSTICKCLKDIV_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_SYSTICKCLKDIV_RESERVED_Msk = 0xffffff00

	// UARTCLKDIV: USART clock divider. Clock divider for the USART fractional baud rate generator.
	// Position of DIV field.
	SYSCON_UARTCLKDIV_DIV_Pos = 0x0
	// Bit mask of DIV field.
	SYSCON_UARTCLKDIV_DIV_Msk = 0xff
	// Position of RESERVED field.
	SYSCON_UARTCLKDIV_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_UARTCLKDIV_RESERVED_Msk = 0xffffff00

	// IOCONCLKDIV: Peripheral clock to the IOCON block for programmable glitch filter
	// Position of DIV field.
	SYSCON_IOCONCLKDIV_DIV_Pos = 0x0
	// Bit mask of DIV field.
	SYSCON_IOCONCLKDIV_DIV_Msk = 0xff
	// Position of RESERVED field.
	SYSCON_IOCONCLKDIV_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_IOCONCLKDIV_RESERVED_Msk = 0xffffff00

	// TRACECLKDIV: ARM trace clock divider
	// Position of DIV field.
	SYSCON_TRACECLKDIV_DIV_Pos = 0x0
	// Bit mask of DIV field.
	SYSCON_TRACECLKDIV_DIV_Msk = 0xff
	// Position of RESERVED field.
	SYSCON_TRACECLKDIV_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_TRACECLKDIV_RESERVED_Msk = 0xffffff00

	// USBCLKDIV: USB clock divider
	// Position of DIV field.
	SYSCON_USBCLKDIV_DIV_Pos = 0x0
	// Bit mask of DIV field.
	SYSCON_USBCLKDIV_DIV_Msk = 0xff
	// Position of RESERVED field.
	SYSCON_USBCLKDIV_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_USBCLKDIV_RESERVED_Msk = 0xffffff00

	// ADCASYNCCLKDIV: Asynchronous ADC clock divider
	// Position of DIV field.
	SYSCON_ADCASYNCCLKDIV_DIV_Pos = 0x0
	// Bit mask of DIV field.
	SYSCON_ADCASYNCCLKDIV_DIV_Msk = 0xff
	// Position of RESERVED field.
	SYSCON_ADCASYNCCLKDIV_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_ADCASYNCCLKDIV_RESERVED_Msk = 0xffffff00

	// CLKOUTDIV: CLKOUT clock divider
	// Position of DIV field.
	SYSCON_CLKOUTDIV_DIV_Pos = 0x0
	// Bit mask of DIV field.
	SYSCON_CLKOUTDIV_DIV_Msk = 0xff
	// Position of RESERVED field.
	SYSCON_CLKOUTDIV_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_CLKOUTDIV_RESERVED_Msk = 0xffffff00

	// FRGCTRL: USART fractional baud rate generator control
	// Position of DIV field.
	SYSCON_FRGCTRL_DIV_Pos = 0x0
	// Bit mask of DIV field.
	SYSCON_FRGCTRL_DIV_Msk = 0xff
	// Position of MULT field.
	SYSCON_FRGCTRL_MULT_Pos = 0x8
	// Bit mask of MULT field.
	SYSCON_FRGCTRL_MULT_Msk = 0xff00
	// Position of RESERVED field.
	SYSCON_FRGCTRL_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	SYSCON_FRGCTRL_RESERVED_Msk = 0xffff0000

	// USBCLKCTRL: USB clock control
	// Position of AP_CLK field.
	SYSCON_USBCLKCTRL_AP_CLK_Pos = 0x0
	// Bit mask of AP_CLK field.
	SYSCON_USBCLKCTRL_AP_CLK_Msk = 0x1
	// Bit AP_CLK.
	SYSCON_USBCLKCTRL_AP_CLK = 0x1
	// Under hardware control.
	SYSCON_USBCLKCTRL_AP_CLK_UNDER_HARDWARE_CONTR = 0x0
	// Forced HIGH.
	SYSCON_USBCLKCTRL_AP_CLK_FORCED_HIGH_ = 0x1
	// Position of POL_CLK field.
	SYSCON_USBCLKCTRL_POL_CLK_Pos = 0x1
	// Bit mask of POL_CLK field.
	SYSCON_USBCLKCTRL_POL_CLK_Msk = 0x2
	// Bit POL_CLK.
	SYSCON_USBCLKCTRL_POL_CLK = 0x2
	// Falling edge of the USB need_clock triggers the USB wake-up (default).
	SYSCON_USBCLKCTRL_POL_CLK_FALLING_EDGE_OF_THE_ = 0x0
	// Rising edge of the USB need_clock triggers the USB wake-up.
	SYSCON_USBCLKCTRL_POL_CLK_RISING_EDGE_OF_THE_U = 0x1
	// Position of RESERVED field.
	SYSCON_USBCLKCTRL_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	SYSCON_USBCLKCTRL_RESERVED_Msk = 0xfffffffc

	// USBCLKST: USB clock status
	// Position of NEED_CLKST field.
	SYSCON_USBCLKST_NEED_CLKST_Pos = 0x0
	// Bit mask of NEED_CLKST field.
	SYSCON_USBCLKST_NEED_CLKST_Msk = 0x1
	// Bit NEED_CLKST.
	SYSCON_USBCLKST_NEED_CLKST = 0x1
	// LOW
	SYSCON_USBCLKST_NEED_CLKST_LOW = 0x0
	// HIGH
	SYSCON_USBCLKST_NEED_CLKST_HIGH = 0x1
	// Position of RESERVED field.
	SYSCON_USBCLKST_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	SYSCON_USBCLKST_RESERVED_Msk = 0xfffffffe

	// BODCTRL: Brown-Out Detect
	// Position of BODRSTLEV field.
	SYSCON_BODCTRL_BODRSTLEV_Pos = 0x0
	// Bit mask of BODRSTLEV field.
	SYSCON_BODCTRL_BODRSTLEV_Msk = 0x3
	// Level 0: The reset assertion threshold voltage is ; the reset de-assertion threshold voltage is .
	SYSCON_BODCTRL_BODRSTLEV_LEVEL_0_THE_RESET_A = 0x0
	// Level 1: The reset assertion threshold voltage is ; the reset de-assertion threshold voltage is .
	SYSCON_BODCTRL_BODRSTLEV_LEVEL_1_THE_RESET_A = 0x1
	// Level 2: The reset assertion threshold voltage is ; the reset de-assertion threshold voltage is .
	SYSCON_BODCTRL_BODRSTLEV_LEVEL_2_THE_RESET_A = 0x2
	// Level 3: The reset assertion threshold voltage is ; the reset de-assertion threshold voltage is.
	SYSCON_BODCTRL_BODRSTLEV_LEVEL_3_THE_RESET_A = 0x3
	// Position of BODINTVAL field.
	SYSCON_BODCTRL_BODINTVAL_Pos = 0x2
	// Bit mask of BODINTVAL field.
	SYSCON_BODCTRL_BODINTVAL_Msk = 0xc
	// Level 0: The interrupt assertion threshold voltage is ; the interrupt de-assertion threshold voltage is
	SYSCON_BODCTRL_BODINTVAL_LEVEL_0_THE_INTERRU = 0x0
	// Level 1: The interrupt assertion threshold voltage is ; the interrupt de-assertion threshold voltage is .
	SYSCON_BODCTRL_BODINTVAL_LEVEL_1_THE_INTERRU = 0x1
	// Level 2: The interrupt assertion threshold voltage is ; the interrupt de-assertion threshold voltage is .
	SYSCON_BODCTRL_BODINTVAL_LEVEL_2_THE_INTERRU = 0x2
	// Level 3: The interrupt assertion threshold voltage is ; the interrupt de-assertion threshold voltage is .
	SYSCON_BODCTRL_BODINTVAL_LEVEL_3_THE_INTERRU = 0x3
	// Position of BODRSTENA field.
	SYSCON_BODCTRL_BODRSTENA_Pos = 0x4
	// Bit mask of BODRSTENA field.
	SYSCON_BODCTRL_BODRSTENA_Msk = 0x10
	// Bit BODRSTENA.
	SYSCON_BODCTRL_BODRSTENA = 0x10
	// Disable reset function.
	SYSCON_BODCTRL_BODRSTENA_DISABLE_RESET_FUNCTI = 0x0
	// Enable reset function.
	SYSCON_BODCTRL_BODRSTENA_ENABLE_RESET_FUNCTIO = 0x1
	// Position of RESERVED field.
	SYSCON_BODCTRL_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	SYSCON_BODCTRL_RESERVED_Msk = 0xffffffe0

	// SYSOSCCTRL: System oscillator control
	// Position of BYPASS field.
	SYSCON_SYSOSCCTRL_BYPASS_Pos = 0x0
	// Bit mask of BYPASS field.
	SYSCON_SYSOSCCTRL_BYPASS_Msk = 0x1
	// Bit BYPASS.
	SYSCON_SYSOSCCTRL_BYPASS = 0x1
	// Disabled. Oscillator is not bypassed.
	SYSCON_SYSOSCCTRL_BYPASS_DISABLED_OSCILLATOR = 0x0
	// Enabled. PLL input (sys_osc_clk) is fed directly from the XTALIN pin bypassing the oscillator. Use this mode when using an external clock source instead of the crystal oscillator.
	SYSCON_SYSOSCCTRL_BYPASS_ENABLED_PLL_INPUT_ = 0x1
	// Position of FREQRANGE field.
	SYSCON_SYSOSCCTRL_FREQRANGE_Pos = 0x1
	// Bit mask of FREQRANGE field.
	SYSCON_SYSOSCCTRL_FREQRANGE_Msk = 0x2
	// Bit FREQRANGE.
	SYSCON_SYSOSCCTRL_FREQRANGE = 0x2
	// 1 - 20 MHz frequency range.
	SYSCON_SYSOSCCTRL_FREQRANGE_1__20_MHZ_FREQUENCY = 0x0
	// 15 - 25 MHz frequency range
	SYSCON_SYSOSCCTRL_FREQRANGE_15__25_MHZ_FREQUENC = 0x1
	// Position of RESERVED field.
	SYSCON_SYSOSCCTRL_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	SYSCON_SYSOSCCTRL_RESERVED_Msk = 0xfffffffc

	// RTCOSCCTRL: RTC oscillator control
	// Position of EN field.
	SYSCON_RTCOSCCTRL_EN_Pos = 0x0
	// Bit mask of EN field.
	SYSCON_RTCOSCCTRL_EN_Msk = 0x1
	// Bit EN.
	SYSCON_RTCOSCCTRL_EN = 0x1
	// Disabled. RTC clock off.
	SYSCON_RTCOSCCTRL_EN_DISABLED_RTC_CLOCK_ = 0x0
	// Enabled. RTC clock on.
	SYSCON_RTCOSCCTRL_EN_ENABLED_RTC_CLOCK_O = 0x1
	// Position of RESERVED field.
	SYSCON_RTCOSCCTRL_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	SYSCON_RTCOSCCTRL_RESERVED_Msk = 0xfffffffe

	// SYSPLLCTRL: System PLL control
	// Position of MSEL field.
	SYSCON_SYSPLLCTRL_MSEL_Pos = 0x0
	// Bit mask of MSEL field.
	SYSCON_SYSPLLCTRL_MSEL_Msk = 0x3f
	// Position of PSEL field.
	SYSCON_SYSPLLCTRL_PSEL_Pos = 0x6
	// Bit mask of PSEL field.
	SYSCON_SYSPLLCTRL_PSEL_Msk = 0xc0
	// P = 1
	SYSCON_SYSPLLCTRL_PSEL_P_EQ_1 = 0x0
	// P = 2
	SYSCON_SYSPLLCTRL_PSEL_P_EQ_2 = 0x1
	// P = 4
	SYSCON_SYSPLLCTRL_PSEL_P_EQ_4 = 0x2
	// P = 8
	SYSCON_SYSPLLCTRL_PSEL_P_EQ_8 = 0x3
	// Position of RESERVED field.
	SYSCON_SYSPLLCTRL_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_SYSPLLCTRL_RESERVED_Msk = 0xffffff00

	// SYSPLLSTAT: System PLL status
	// Position of LOCK field.
	SYSCON_SYSPLLSTAT_LOCK_Pos = 0x0
	// Bit mask of LOCK field.
	SYSCON_SYSPLLSTAT_LOCK_Msk = 0x1
	// Bit LOCK.
	SYSCON_SYSPLLSTAT_LOCK = 0x1
	// PLL not locked
	SYSCON_SYSPLLSTAT_LOCK_PLL_NOT_LOCKED = 0x0
	// PLL locked
	SYSCON_SYSPLLSTAT_LOCK_PLL_LOCKED = 0x1
	// Position of RESERVED field.
	SYSCON_SYSPLLSTAT_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	SYSCON_SYSPLLSTAT_RESERVED_Msk = 0xfffffffe

	// USBPLLCTRL: USB PLL control
	// Position of MSEL field.
	SYSCON_USBPLLCTRL_MSEL_Pos = 0x0
	// Bit mask of MSEL field.
	SYSCON_USBPLLCTRL_MSEL_Msk = 0x3f
	// Position of PSEL field.
	SYSCON_USBPLLCTRL_PSEL_Pos = 0x6
	// Bit mask of PSEL field.
	SYSCON_USBPLLCTRL_PSEL_Msk = 0xc0
	// P = 1
	SYSCON_USBPLLCTRL_PSEL_P_EQ_1 = 0x0
	// P = 2
	SYSCON_USBPLLCTRL_PSEL_P_EQ_2 = 0x1
	// P = 4
	SYSCON_USBPLLCTRL_PSEL_P_EQ_4 = 0x2
	// P = 8
	SYSCON_USBPLLCTRL_PSEL_P_EQ_8 = 0x3
	// Position of RESERVED field.
	SYSCON_USBPLLCTRL_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_USBPLLCTRL_RESERVED_Msk = 0xffffff00

	// USBPLLSTAT: USB PLL status
	// Position of LOCK field.
	SYSCON_USBPLLSTAT_LOCK_Pos = 0x0
	// Bit mask of LOCK field.
	SYSCON_USBPLLSTAT_LOCK_Msk = 0x1
	// Bit LOCK.
	SYSCON_USBPLLSTAT_LOCK = 0x1
	// PLL not locked
	SYSCON_USBPLLSTAT_LOCK_PLL_NOT_LOCKED = 0x0
	// PLL locked
	SYSCON_USBPLLSTAT_LOCK_PLL_LOCKED = 0x1
	// Position of RESERVED field.
	SYSCON_USBPLLSTAT_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	SYSCON_USBPLLSTAT_RESERVED_Msk = 0xfffffffe

	// SCTPLLCTRL: SCT PLL control
	// Position of MSEL field.
	SYSCON_SCTPLLCTRL_MSEL_Pos = 0x0
	// Bit mask of MSEL field.
	SYSCON_SCTPLLCTRL_MSEL_Msk = 0x3f
	// Position of PSEL field.
	SYSCON_SCTPLLCTRL_PSEL_Pos = 0x6
	// Bit mask of PSEL field.
	SYSCON_SCTPLLCTRL_PSEL_Msk = 0xc0
	// P = 1
	SYSCON_SCTPLLCTRL_PSEL_P_EQ_1 = 0x0
	// P = 2
	SYSCON_SCTPLLCTRL_PSEL_P_EQ_2 = 0x1
	// P = 4
	SYSCON_SCTPLLCTRL_PSEL_P_EQ_4 = 0x2
	// P = 8
	SYSCON_SCTPLLCTRL_PSEL_P_EQ_8 = 0x3
	// Position of RESERVED field.
	SYSCON_SCTPLLCTRL_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_SCTPLLCTRL_RESERVED_Msk = 0xffffff00

	// SCTPLLSTAT: SCT PLL status
	// Position of LOCK field.
	SYSCON_SCTPLLSTAT_LOCK_Pos = 0x0
	// Bit mask of LOCK field.
	SYSCON_SCTPLLSTAT_LOCK_Msk = 0x1
	// Bit LOCK.
	SYSCON_SCTPLLSTAT_LOCK = 0x1
	// PLL not locked
	SYSCON_SCTPLLSTAT_LOCK_PLL_NOT_LOCKED = 0x0
	// PLL locked
	SYSCON_SCTPLLSTAT_LOCK_PLL_LOCKED = 0x1
	// Position of RESERVED field.
	SYSCON_SCTPLLSTAT_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	SYSCON_SCTPLLSTAT_RESERVED_Msk = 0xfffffffe

	// PDAWAKECFG: Power-down states for wake-up from deep-sleep
	// Position of RESERVED field.
	SYSCON_PDAWAKECFG_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	SYSCON_PDAWAKECFG_RESERVED_Msk = 0x7
	// Position of IRCOUT_PD field.
	SYSCON_PDAWAKECFG_IRCOUT_PD_Pos = 0x3
	// Bit mask of IRCOUT_PD field.
	SYSCON_PDAWAKECFG_IRCOUT_PD_Msk = 0x8
	// Bit IRCOUT_PD.
	SYSCON_PDAWAKECFG_IRCOUT_PD = 0x8
	// Powered
	SYSCON_PDAWAKECFG_IRCOUT_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDAWAKECFG_IRCOUT_PD_POWERED_DOWN = 0x1
	// Position of IRC field.
	SYSCON_PDAWAKECFG_IRC_Pos = 0x4
	// Bit mask of IRC field.
	SYSCON_PDAWAKECFG_IRC_Msk = 0x10
	// Bit IRC.
	SYSCON_PDAWAKECFG_IRC = 0x10
	// Powered
	SYSCON_PDAWAKECFG_IRC_POWERED = 0x0
	// Powered down
	SYSCON_PDAWAKECFG_IRC_POWERED_DOWN = 0x1
	// Position of FLASH field.
	SYSCON_PDAWAKECFG_FLASH_Pos = 0x5
	// Bit mask of FLASH field.
	SYSCON_PDAWAKECFG_FLASH_Msk = 0x20
	// Bit FLASH.
	SYSCON_PDAWAKECFG_FLASH = 0x20
	// Powered
	SYSCON_PDAWAKECFG_FLASH_POWERED = 0x0
	// Powered down
	SYSCON_PDAWAKECFG_FLASH_POWERED_DOWN = 0x1
	// Position of EEPROM field.
	SYSCON_PDAWAKECFG_EEPROM_Pos = 0x6
	// Bit mask of EEPROM field.
	SYSCON_PDAWAKECFG_EEPROM_Msk = 0x40
	// Bit EEPROM.
	SYSCON_PDAWAKECFG_EEPROM = 0x40
	// Powered
	SYSCON_PDAWAKECFG_EEPROM_POWERED = 0x0
	// Powered down
	SYSCON_PDAWAKECFG_EEPROM_POWERED_DOWN = 0x1
	// Position of RESERVED field.
	SYSCON_PDAWAKECFG_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	SYSCON_PDAWAKECFG_RESERVED_Msk = 0x80
	// Bit RESERVED.
	SYSCON_PDAWAKECFG_RESERVED = 0x80
	// Position of BOD_PD field.
	SYSCON_PDAWAKECFG_BOD_PD_Pos = 0x8
	// Bit mask of BOD_PD field.
	SYSCON_PDAWAKECFG_BOD_PD_Msk = 0x100
	// Bit BOD_PD.
	SYSCON_PDAWAKECFG_BOD_PD = 0x100
	// Powered
	SYSCON_PDAWAKECFG_BOD_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDAWAKECFG_BOD_PD_POWERED_DOWN = 0x1
	// Position of USBPHY_PD field.
	SYSCON_PDAWAKECFG_USBPHY_PD_Pos = 0x9
	// Bit mask of USBPHY_PD field.
	SYSCON_PDAWAKECFG_USBPHY_PD_Msk = 0x200
	// Bit USBPHY_PD.
	SYSCON_PDAWAKECFG_USBPHY_PD = 0x200
	// Powered
	SYSCON_PDAWAKECFG_USBPHY_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDAWAKECFG_USBPHY_PD_POWERED_DOWN = 0x1
	// Position of ADC0_PD field.
	SYSCON_PDAWAKECFG_ADC0_PD_Pos = 0xa
	// Bit mask of ADC0_PD field.
	SYSCON_PDAWAKECFG_ADC0_PD_Msk = 0x400
	// Bit ADC0_PD.
	SYSCON_PDAWAKECFG_ADC0_PD = 0x400
	// Powered
	SYSCON_PDAWAKECFG_ADC0_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDAWAKECFG_ADC0_PD_POWERED_DOWN = 0x1
	// Position of ADC1_PD field.
	SYSCON_PDAWAKECFG_ADC1_PD_Pos = 0xb
	// Bit mask of ADC1_PD field.
	SYSCON_PDAWAKECFG_ADC1_PD_Msk = 0x800
	// Bit ADC1_PD.
	SYSCON_PDAWAKECFG_ADC1_PD = 0x800
	// Powered
	SYSCON_PDAWAKECFG_ADC1_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDAWAKECFG_ADC1_PD_POWERED_DOWN = 0x1
	// Position of DAC_PD field.
	SYSCON_PDAWAKECFG_DAC_PD_Pos = 0xc
	// Bit mask of DAC_PD field.
	SYSCON_PDAWAKECFG_DAC_PD_Msk = 0x1000
	// Bit DAC_PD.
	SYSCON_PDAWAKECFG_DAC_PD = 0x1000
	// Powered
	SYSCON_PDAWAKECFG_DAC_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDAWAKECFG_DAC_PD_POWERED_DOWN = 0x1
	// Position of ACMP0_PD field.
	SYSCON_PDAWAKECFG_ACMP0_PD_Pos = 0xd
	// Bit mask of ACMP0_PD field.
	SYSCON_PDAWAKECFG_ACMP0_PD_Msk = 0x2000
	// Bit ACMP0_PD.
	SYSCON_PDAWAKECFG_ACMP0_PD = 0x2000
	// Powered
	SYSCON_PDAWAKECFG_ACMP0_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDAWAKECFG_ACMP0_PD_POWERED_DOWN = 0x1
	// Position of ACMP1_PD field.
	SYSCON_PDAWAKECFG_ACMP1_PD_Pos = 0xe
	// Bit mask of ACMP1_PD field.
	SYSCON_PDAWAKECFG_ACMP1_PD_Msk = 0x4000
	// Bit ACMP1_PD.
	SYSCON_PDAWAKECFG_ACMP1_PD = 0x4000
	// Powered
	SYSCON_PDAWAKECFG_ACMP1_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDAWAKECFG_ACMP1_PD_POWERED_DOWN = 0x1
	// Position of ACMP2_PD field.
	SYSCON_PDAWAKECFG_ACMP2_PD_Pos = 0xf
	// Bit mask of ACMP2_PD field.
	SYSCON_PDAWAKECFG_ACMP2_PD_Msk = 0x8000
	// Bit ACMP2_PD.
	SYSCON_PDAWAKECFG_ACMP2_PD = 0x8000
	// Powered
	SYSCON_PDAWAKECFG_ACMP2_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDAWAKECFG_ACMP2_PD_POWERED_DOWN = 0x1
	// Position of ACMP3_PD field.
	SYSCON_PDAWAKECFG_ACMP3_PD_Pos = 0x10
	// Bit mask of ACMP3_PD field.
	SYSCON_PDAWAKECFG_ACMP3_PD_Msk = 0x10000
	// Bit ACMP3_PD.
	SYSCON_PDAWAKECFG_ACMP3_PD = 0x10000
	// Powered
	SYSCON_PDAWAKECFG_ACMP3_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDAWAKECFG_ACMP3_PD_POWERED_DOWN = 0x1
	// Position of IREF_PD field.
	SYSCON_PDAWAKECFG_IREF_PD_Pos = 0x11
	// Bit mask of IREF_PD field.
	SYSCON_PDAWAKECFG_IREF_PD_Msk = 0x20000
	// Bit IREF_PD.
	SYSCON_PDAWAKECFG_IREF_PD = 0x20000
	// Powered
	SYSCON_PDAWAKECFG_IREF_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDAWAKECFG_IREF_PD_POWERED_DOWN = 0x1
	// Position of TS_PD field.
	SYSCON_PDAWAKECFG_TS_PD_Pos = 0x12
	// Bit mask of TS_PD field.
	SYSCON_PDAWAKECFG_TS_PD_Msk = 0x40000
	// Bit TS_PD.
	SYSCON_PDAWAKECFG_TS_PD = 0x40000
	// Powered
	SYSCON_PDAWAKECFG_TS_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDAWAKECFG_TS_PD_POWERED_DOWN = 0x1
	// Position of VDDADIV_PD field.
	SYSCON_PDAWAKECFG_VDDADIV_PD_Pos = 0x13
	// Bit mask of VDDADIV_PD field.
	SYSCON_PDAWAKECFG_VDDADIV_PD_Msk = 0x80000
	// Bit VDDADIV_PD.
	SYSCON_PDAWAKECFG_VDDADIV_PD = 0x80000
	// Powered
	SYSCON_PDAWAKECFG_VDDADIV_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDAWAKECFG_VDDADIV_PD_POWERED_DOWN = 0x1
	// Position of WDTOSC_PD field.
	SYSCON_PDAWAKECFG_WDTOSC_PD_Pos = 0x14
	// Bit mask of WDTOSC_PD field.
	SYSCON_PDAWAKECFG_WDTOSC_PD_Msk = 0x100000
	// Bit WDTOSC_PD.
	SYSCON_PDAWAKECFG_WDTOSC_PD = 0x100000
	// Powered
	SYSCON_PDAWAKECFG_WDTOSC_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDAWAKECFG_WDTOSC_PD_POWERED_DOWN = 0x1
	// Position of SYSOSC_PD field.
	SYSCON_PDAWAKECFG_SYSOSC_PD_Pos = 0x15
	// Bit mask of SYSOSC_PD field.
	SYSCON_PDAWAKECFG_SYSOSC_PD_Msk = 0x200000
	// Bit SYSOSC_PD.
	SYSCON_PDAWAKECFG_SYSOSC_PD = 0x200000
	// Powered
	SYSCON_PDAWAKECFG_SYSOSC_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDAWAKECFG_SYSOSC_PD_POWERED_DOWN = 0x1
	// Position of SYSPLL_PD field.
	SYSCON_PDAWAKECFG_SYSPLL_PD_Pos = 0x16
	// Bit mask of SYSPLL_PD field.
	SYSCON_PDAWAKECFG_SYSPLL_PD_Msk = 0x400000
	// Bit SYSPLL_PD.
	SYSCON_PDAWAKECFG_SYSPLL_PD = 0x400000
	// Powered
	SYSCON_PDAWAKECFG_SYSPLL_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDAWAKECFG_SYSPLL_PD_POWERED_DOWN = 0x1
	// Position of USBPLL_PD field.
	SYSCON_PDAWAKECFG_USBPLL_PD_Pos = 0x17
	// Bit mask of USBPLL_PD field.
	SYSCON_PDAWAKECFG_USBPLL_PD_Msk = 0x800000
	// Bit USBPLL_PD.
	SYSCON_PDAWAKECFG_USBPLL_PD = 0x800000
	// Powered
	SYSCON_PDAWAKECFG_USBPLL_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDAWAKECFG_USBPLL_PD_POWERED_DOWN = 0x1
	// Position of SCTPLL_PD field.
	SYSCON_PDAWAKECFG_SCTPLL_PD_Pos = 0x18
	// Bit mask of SCTPLL_PD field.
	SYSCON_PDAWAKECFG_SCTPLL_PD_Msk = 0x1000000
	// Bit SCTPLL_PD.
	SYSCON_PDAWAKECFG_SCTPLL_PD = 0x1000000
	// Powered
	SYSCON_PDAWAKECFG_SCTPLL_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDAWAKECFG_SCTPLL_PD_POWERED_DOWN = 0x1
	// Position of RESERVED field.
	SYSCON_PDAWAKECFG_RESERVED_Pos = 0x19
	// Bit mask of RESERVED field.
	SYSCON_PDAWAKECFG_RESERVED_Msk = 0xfe000000

	// PDRUNCFG: Power configuration register
	// Position of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Msk = 0x7
	// Position of IRCOUT_PD field.
	SYSCON_PDRUNCFG_IRCOUT_PD_Pos = 0x3
	// Bit mask of IRCOUT_PD field.
	SYSCON_PDRUNCFG_IRCOUT_PD_Msk = 0x8
	// Bit IRCOUT_PD.
	SYSCON_PDRUNCFG_IRCOUT_PD = 0x8
	// Powered
	SYSCON_PDRUNCFG_IRCOUT_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDRUNCFG_IRCOUT_PD_POWERED_DOWN = 0x1
	// Position of IRC field.
	SYSCON_PDRUNCFG_IRC_Pos = 0x4
	// Bit mask of IRC field.
	SYSCON_PDRUNCFG_IRC_Msk = 0x10
	// Bit IRC.
	SYSCON_PDRUNCFG_IRC = 0x10
	// Powered
	SYSCON_PDRUNCFG_IRC_POWERED = 0x0
	// Powered down
	SYSCON_PDRUNCFG_IRC_POWERED_DOWN = 0x1
	// Position of FLASH field.
	SYSCON_PDRUNCFG_FLASH_Pos = 0x5
	// Bit mask of FLASH field.
	SYSCON_PDRUNCFG_FLASH_Msk = 0x20
	// Bit FLASH.
	SYSCON_PDRUNCFG_FLASH = 0x20
	// Powered
	SYSCON_PDRUNCFG_FLASH_POWERED = 0x0
	// Powered down
	SYSCON_PDRUNCFG_FLASH_POWERED_DOWN = 0x1
	// Position of EEPROM field.
	SYSCON_PDRUNCFG_EEPROM_Pos = 0x6
	// Bit mask of EEPROM field.
	SYSCON_PDRUNCFG_EEPROM_Msk = 0x40
	// Bit EEPROM.
	SYSCON_PDRUNCFG_EEPROM = 0x40
	// Powered
	SYSCON_PDRUNCFG_EEPROM_POWERED = 0x0
	// Powered down
	SYSCON_PDRUNCFG_EEPROM_POWERED_DOWN = 0x1
	// Position of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Msk = 0x80
	// Bit RESERVED.
	SYSCON_PDRUNCFG_RESERVED = 0x80
	// Position of BOD_PD field.
	SYSCON_PDRUNCFG_BOD_PD_Pos = 0x8
	// Bit mask of BOD_PD field.
	SYSCON_PDRUNCFG_BOD_PD_Msk = 0x100
	// Bit BOD_PD.
	SYSCON_PDRUNCFG_BOD_PD = 0x100
	// Powered
	SYSCON_PDRUNCFG_BOD_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDRUNCFG_BOD_PD_POWERED_DOWN = 0x1
	// Position of USBPHY_PD field.
	SYSCON_PDRUNCFG_USBPHY_PD_Pos = 0x9
	// Bit mask of USBPHY_PD field.
	SYSCON_PDRUNCFG_USBPHY_PD_Msk = 0x200
	// Bit USBPHY_PD.
	SYSCON_PDRUNCFG_USBPHY_PD = 0x200
	// Powered
	SYSCON_PDRUNCFG_USBPHY_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDRUNCFG_USBPHY_PD_POWERED_DOWN = 0x1
	// Position of ADC0_PD field.
	SYSCON_PDRUNCFG_ADC0_PD_Pos = 0xa
	// Bit mask of ADC0_PD field.
	SYSCON_PDRUNCFG_ADC0_PD_Msk = 0x400
	// Bit ADC0_PD.
	SYSCON_PDRUNCFG_ADC0_PD = 0x400
	// Powered
	SYSCON_PDRUNCFG_ADC0_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDRUNCFG_ADC0_PD_POWERED_DOWN = 0x1
	// Position of ADC1_PD field.
	SYSCON_PDRUNCFG_ADC1_PD_Pos = 0xb
	// Bit mask of ADC1_PD field.
	SYSCON_PDRUNCFG_ADC1_PD_Msk = 0x800
	// Bit ADC1_PD.
	SYSCON_PDRUNCFG_ADC1_PD = 0x800
	// Powered
	SYSCON_PDRUNCFG_ADC1_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDRUNCFG_ADC1_PD_POWERED_DOWN = 0x1
	// Position of DAC_PD field.
	SYSCON_PDRUNCFG_DAC_PD_Pos = 0xc
	// Bit mask of DAC_PD field.
	SYSCON_PDRUNCFG_DAC_PD_Msk = 0x1000
	// Bit DAC_PD.
	SYSCON_PDRUNCFG_DAC_PD = 0x1000
	// Powered
	SYSCON_PDRUNCFG_DAC_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDRUNCFG_DAC_PD_POWERED_DOWN = 0x1
	// Position of ACMP0_PD field.
	SYSCON_PDRUNCFG_ACMP0_PD_Pos = 0xd
	// Bit mask of ACMP0_PD field.
	SYSCON_PDRUNCFG_ACMP0_PD_Msk = 0x2000
	// Bit ACMP0_PD.
	SYSCON_PDRUNCFG_ACMP0_PD = 0x2000
	// Powered
	SYSCON_PDRUNCFG_ACMP0_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDRUNCFG_ACMP0_PD_POWERED_DOWN = 0x1
	// Position of ACMP1_PD field.
	SYSCON_PDRUNCFG_ACMP1_PD_Pos = 0xe
	// Bit mask of ACMP1_PD field.
	SYSCON_PDRUNCFG_ACMP1_PD_Msk = 0x4000
	// Bit ACMP1_PD.
	SYSCON_PDRUNCFG_ACMP1_PD = 0x4000
	// Powered
	SYSCON_PDRUNCFG_ACMP1_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDRUNCFG_ACMP1_PD_POWERED_DOWN = 0x1
	// Position of ACMP2_PD field.
	SYSCON_PDRUNCFG_ACMP2_PD_Pos = 0xf
	// Bit mask of ACMP2_PD field.
	SYSCON_PDRUNCFG_ACMP2_PD_Msk = 0x8000
	// Bit ACMP2_PD.
	SYSCON_PDRUNCFG_ACMP2_PD = 0x8000
	// Powered
	SYSCON_PDRUNCFG_ACMP2_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDRUNCFG_ACMP2_PD_POWERED_DOWN = 0x1
	// Position of ACMP3_PD field.
	SYSCON_PDRUNCFG_ACMP3_PD_Pos = 0x10
	// Bit mask of ACMP3_PD field.
	SYSCON_PDRUNCFG_ACMP3_PD_Msk = 0x10000
	// Bit ACMP3_PD.
	SYSCON_PDRUNCFG_ACMP3_PD = 0x10000
	// Powered
	SYSCON_PDRUNCFG_ACMP3_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDRUNCFG_ACMP3_PD_POWERED_DOWN = 0x1
	// Position of IREF_PD field.
	SYSCON_PDRUNCFG_IREF_PD_Pos = 0x11
	// Bit mask of IREF_PD field.
	SYSCON_PDRUNCFG_IREF_PD_Msk = 0x20000
	// Bit IREF_PD.
	SYSCON_PDRUNCFG_IREF_PD = 0x20000
	// Powered
	SYSCON_PDRUNCFG_IREF_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDRUNCFG_IREF_PD_POWERED_DOWN = 0x1
	// Position of TS_PD field.
	SYSCON_PDRUNCFG_TS_PD_Pos = 0x12
	// Bit mask of TS_PD field.
	SYSCON_PDRUNCFG_TS_PD_Msk = 0x40000
	// Bit TS_PD.
	SYSCON_PDRUNCFG_TS_PD = 0x40000
	// Powered
	SYSCON_PDRUNCFG_TS_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDRUNCFG_TS_PD_POWERED_DOWN = 0x1
	// Position of VDDADIV_PD field.
	SYSCON_PDRUNCFG_VDDADIV_PD_Pos = 0x13
	// Bit mask of VDDADIV_PD field.
	SYSCON_PDRUNCFG_VDDADIV_PD_Msk = 0x80000
	// Bit VDDADIV_PD.
	SYSCON_PDRUNCFG_VDDADIV_PD = 0x80000
	// Powered
	SYSCON_PDRUNCFG_VDDADIV_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDRUNCFG_VDDADIV_PD_POWERED_DOWN = 0x1
	// Position of WDTOSC_PD field.
	SYSCON_PDRUNCFG_WDTOSC_PD_Pos = 0x14
	// Bit mask of WDTOSC_PD field.
	SYSCON_PDRUNCFG_WDTOSC_PD_Msk = 0x100000
	// Bit WDTOSC_PD.
	SYSCON_PDRUNCFG_WDTOSC_PD = 0x100000
	// Powered
	SYSCON_PDRUNCFG_WDTOSC_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDRUNCFG_WDTOSC_PD_POWERED_DOWN = 0x1
	// Position of SYSOSC_PD field.
	SYSCON_PDRUNCFG_SYSOSC_PD_Pos = 0x15
	// Bit mask of SYSOSC_PD field.
	SYSCON_PDRUNCFG_SYSOSC_PD_Msk = 0x200000
	// Bit SYSOSC_PD.
	SYSCON_PDRUNCFG_SYSOSC_PD = 0x200000
	// Powered
	SYSCON_PDRUNCFG_SYSOSC_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDRUNCFG_SYSOSC_PD_POWERED_DOWN = 0x1
	// Position of SYSPLL_PD field.
	SYSCON_PDRUNCFG_SYSPLL_PD_Pos = 0x16
	// Bit mask of SYSPLL_PD field.
	SYSCON_PDRUNCFG_SYSPLL_PD_Msk = 0x400000
	// Bit SYSPLL_PD.
	SYSCON_PDRUNCFG_SYSPLL_PD = 0x400000
	// Powered
	SYSCON_PDRUNCFG_SYSPLL_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDRUNCFG_SYSPLL_PD_POWERED_DOWN = 0x1
	// Position of USBPLL_PD field.
	SYSCON_PDRUNCFG_USBPLL_PD_Pos = 0x17
	// Bit mask of USBPLL_PD field.
	SYSCON_PDRUNCFG_USBPLL_PD_Msk = 0x800000
	// Bit USBPLL_PD.
	SYSCON_PDRUNCFG_USBPLL_PD = 0x800000
	// Powered
	SYSCON_PDRUNCFG_USBPLL_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDRUNCFG_USBPLL_PD_POWERED_DOWN = 0x1
	// Position of SCTPLL_PD field.
	SYSCON_PDRUNCFG_SCTPLL_PD_Pos = 0x18
	// Bit mask of SCTPLL_PD field.
	SYSCON_PDRUNCFG_SCTPLL_PD_Msk = 0x1000000
	// Bit SCTPLL_PD.
	SYSCON_PDRUNCFG_SCTPLL_PD = 0x1000000
	// Powered
	SYSCON_PDRUNCFG_SCTPLL_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDRUNCFG_SCTPLL_PD_POWERED_DOWN = 0x1
	// Position of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Pos = 0x19
	// Bit mask of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Msk = 0xfe000000

	// STARTERP0: Start logic 0 wake-up enable register
	// Position of WWDT field.
	SYSCON_STARTERP0_WWDT_Pos = 0x0
	// Bit mask of WWDT field.
	SYSCON_STARTERP0_WWDT_Msk = 0x1
	// Bit WWDT.
	SYSCON_STARTERP0_WWDT = 0x1
	// Disabled
	SYSCON_STARTERP0_WWDT_DISABLED = 0x0
	// Enabled
	SYSCON_STARTERP0_WWDT_ENABLED = 0x1
	// Position of BOD field.
	SYSCON_STARTERP0_BOD_Pos = 0x1
	// Bit mask of BOD field.
	SYSCON_STARTERP0_BOD_Msk = 0x2
	// Bit BOD.
	SYSCON_STARTERP0_BOD = 0x2
	// Disabled
	SYSCON_STARTERP0_BOD_DISABLED = 0x0
	// Enabled
	SYSCON_STARTERP0_BOD_ENABLED = 0x1
	// Position of RESERVED field.
	SYSCON_STARTERP0_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	SYSCON_STARTERP0_RESERVED_Msk = 0x1c
	// Position of GINT0 field.
	SYSCON_STARTERP0_GINT0_Pos = 0x5
	// Bit mask of GINT0 field.
	SYSCON_STARTERP0_GINT0_Msk = 0x20
	// Bit GINT0.
	SYSCON_STARTERP0_GINT0 = 0x20
	// Disabled
	SYSCON_STARTERP0_GINT0_DISABLED = 0x0
	// Enabled
	SYSCON_STARTERP0_GINT0_ENABLED = 0x1
	// Position of GINT1 field.
	SYSCON_STARTERP0_GINT1_Pos = 0x6
	// Bit mask of GINT1 field.
	SYSCON_STARTERP0_GINT1_Msk = 0x40
	// Bit GINT1.
	SYSCON_STARTERP0_GINT1 = 0x40
	// Disabled
	SYSCON_STARTERP0_GINT1_DISABLED = 0x0
	// Enabled
	SYSCON_STARTERP0_GINT1_ENABLED = 0x1
	// Position of PINT0 field.
	SYSCON_STARTERP0_PINT0_Pos = 0x7
	// Bit mask of PINT0 field.
	SYSCON_STARTERP0_PINT0_Msk = 0x80
	// Bit PINT0.
	SYSCON_STARTERP0_PINT0 = 0x80
	// Disabled
	SYSCON_STARTERP0_PINT0_DISABLED = 0x0
	// Enabled
	SYSCON_STARTERP0_PINT0_ENABLED = 0x1
	// Position of PINT1 field.
	SYSCON_STARTERP0_PINT1_Pos = 0x8
	// Bit mask of PINT1 field.
	SYSCON_STARTERP0_PINT1_Msk = 0x100
	// Bit PINT1.
	SYSCON_STARTERP0_PINT1 = 0x100
	// Disabled
	SYSCON_STARTERP0_PINT1_DISABLED = 0x0
	// Enabled
	SYSCON_STARTERP0_PINT1_ENABLED = 0x1
	// Position of PINT2 field.
	SYSCON_STARTERP0_PINT2_Pos = 0x9
	// Bit mask of PINT2 field.
	SYSCON_STARTERP0_PINT2_Msk = 0x200
	// Bit PINT2.
	SYSCON_STARTERP0_PINT2 = 0x200
	// Disabled
	SYSCON_STARTERP0_PINT2_DISABLED = 0x0
	// Enabled
	SYSCON_STARTERP0_PINT2_ENABLED = 0x1
	// Position of PINT3 field.
	SYSCON_STARTERP0_PINT3_Pos = 0xa
	// Bit mask of PINT3 field.
	SYSCON_STARTERP0_PINT3_Msk = 0x400
	// Bit PINT3.
	SYSCON_STARTERP0_PINT3 = 0x400
	// Disabled
	SYSCON_STARTERP0_PINT3_DISABLED = 0x0
	// Enabled
	SYSCON_STARTERP0_PINT3_ENABLED = 0x1
	// Position of PINT4 field.
	SYSCON_STARTERP0_PINT4_Pos = 0xb
	// Bit mask of PINT4 field.
	SYSCON_STARTERP0_PINT4_Msk = 0x800
	// Bit PINT4.
	SYSCON_STARTERP0_PINT4 = 0x800
	// Disabled
	SYSCON_STARTERP0_PINT4_DISABLED = 0x0
	// Enabled
	SYSCON_STARTERP0_PINT4_ENABLED = 0x1
	// Position of PINT5 field.
	SYSCON_STARTERP0_PINT5_Pos = 0xc
	// Bit mask of PINT5 field.
	SYSCON_STARTERP0_PINT5_Msk = 0x1000
	// Bit PINT5.
	SYSCON_STARTERP0_PINT5 = 0x1000
	// Disabled
	SYSCON_STARTERP0_PINT5_DISABLED = 0x0
	// Enabled
	SYSCON_STARTERP0_PINT5_ENABLED = 0x1
	// Position of PINT6 field.
	SYSCON_STARTERP0_PINT6_Pos = 0xd
	// Bit mask of PINT6 field.
	SYSCON_STARTERP0_PINT6_Msk = 0x2000
	// Bit PINT6.
	SYSCON_STARTERP0_PINT6 = 0x2000
	// Disabled
	SYSCON_STARTERP0_PINT6_DISABLED = 0x0
	// Enabled
	SYSCON_STARTERP0_PINT6_ENABLED = 0x1
	// Position of PINT7 field.
	SYSCON_STARTERP0_PINT7_Pos = 0xe
	// Bit mask of PINT7 field.
	SYSCON_STARTERP0_PINT7_Msk = 0x4000
	// Bit PINT7.
	SYSCON_STARTERP0_PINT7 = 0x4000
	// Disabled
	SYSCON_STARTERP0_PINT7_DISABLED = 0x0
	// Enabled
	SYSCON_STARTERP0_PINT7_ENABLED = 0x1
	// Position of RESERVED field.
	SYSCON_STARTERP0_RESERVED_Pos = 0xf
	// Bit mask of RESERVED field.
	SYSCON_STARTERP0_RESERVED_Msk = 0x1f8000
	// Position of USART0 field.
	SYSCON_STARTERP0_USART0_Pos = 0x15
	// Bit mask of USART0 field.
	SYSCON_STARTERP0_USART0_Msk = 0x200000
	// Bit USART0.
	SYSCON_STARTERP0_USART0 = 0x200000
	// Disabled
	SYSCON_STARTERP0_USART0_DISABLED = 0x0
	// Enabled
	SYSCON_STARTERP0_USART0_ENABLED = 0x1
	// Position of USART1 field.
	SYSCON_STARTERP0_USART1_Pos = 0x16
	// Bit mask of USART1 field.
	SYSCON_STARTERP0_USART1_Msk = 0x400000
	// Bit USART1.
	SYSCON_STARTERP0_USART1 = 0x400000
	// Disabled
	SYSCON_STARTERP0_USART1_DISABLED = 0x0
	// Enabled
	SYSCON_STARTERP0_USART1_ENABLED = 0x1
	// Position of USART2 field.
	SYSCON_STARTERP0_USART2_Pos = 0x17
	// Bit mask of USART2 field.
	SYSCON_STARTERP0_USART2_Msk = 0x800000
	// Bit USART2.
	SYSCON_STARTERP0_USART2 = 0x800000
	// Disabled
	SYSCON_STARTERP0_USART2_DISABLED = 0x0
	// Enabled
	SYSCON_STARTERP0_USART2_ENABLED = 0x1
	// Position of I2C field.
	SYSCON_STARTERP0_I2C_Pos = 0x18
	// Bit mask of I2C field.
	SYSCON_STARTERP0_I2C_Msk = 0x1000000
	// Bit I2C.
	SYSCON_STARTERP0_I2C = 0x1000000
	// Disabled
	SYSCON_STARTERP0_I2C_DISABLED = 0x0
	// Enabled
	SYSCON_STARTERP0_I2C_ENABLED = 0x1
	// Position of SPI0 field.
	SYSCON_STARTERP0_SPI0_Pos = 0x19
	// Bit mask of SPI0 field.
	SYSCON_STARTERP0_SPI0_Msk = 0x2000000
	// Bit SPI0.
	SYSCON_STARTERP0_SPI0 = 0x2000000
	// Disabled
	SYSCON_STARTERP0_SPI0_DISABLED = 0x0
	// Enabled
	SYSCON_STARTERP0_SPI0_ENABLED = 0x1
	// Position of SPI1 field.
	SYSCON_STARTERP0_SPI1_Pos = 0x1a
	// Bit mask of SPI1 field.
	SYSCON_STARTERP0_SPI1_Msk = 0x4000000
	// Bit SPI1.
	SYSCON_STARTERP0_SPI1 = 0x4000000
	// Disabled
	SYSCON_STARTERP0_SPI1_DISABLED = 0x0
	// Enabled
	SYSCON_STARTERP0_SPI1_ENABLED = 0x1
	// Position of RESERVED field.
	SYSCON_STARTERP0_RESERVED_Pos = 0x1b
	// Bit mask of RESERVED field.
	SYSCON_STARTERP0_RESERVED_Msk = 0x38000000
	// Position of USB_WAKEUP field.
	SYSCON_STARTERP0_USB_WAKEUP_Pos = 0x1e
	// Bit mask of USB_WAKEUP field.
	SYSCON_STARTERP0_USB_WAKEUP_Msk = 0x40000000
	// Bit USB_WAKEUP.
	SYSCON_STARTERP0_USB_WAKEUP = 0x40000000
	// Disabled
	SYSCON_STARTERP0_USB_WAKEUP_DISABLED = 0x0
	// Enabled
	SYSCON_STARTERP0_USB_WAKEUP_ENABLED = 0x1
	// Position of RESERVED field.
	SYSCON_STARTERP0_RESERVED_Pos = 0x1f
	// Bit mask of RESERVED field.
	SYSCON_STARTERP0_RESERVED_Msk = 0x80000000
	// Bit RESERVED.
	SYSCON_STARTERP0_RESERVED = 0x80000000

	// STARTERP1: Start logic 1 wake-up enable register
	// Position of RESERVED field.
	SYSCON_STARTERP1_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	SYSCON_STARTERP1_RESERVED_Msk = 0xff
	// Position of ACMP0 field.
	SYSCON_STARTERP1_ACMP0_Pos = 0x8
	// Bit mask of ACMP0 field.
	SYSCON_STARTERP1_ACMP0_Msk = 0x100
	// Bit ACMP0.
	SYSCON_STARTERP1_ACMP0 = 0x100
	// Disabled
	SYSCON_STARTERP1_ACMP0_DISABLED = 0x0
	// Enabled
	SYSCON_STARTERP1_ACMP0_ENABLED = 0x1
	// Position of ACMP1 field.
	SYSCON_STARTERP1_ACMP1_Pos = 0x9
	// Bit mask of ACMP1 field.
	SYSCON_STARTERP1_ACMP1_Msk = 0x200
	// Bit ACMP1.
	SYSCON_STARTERP1_ACMP1 = 0x200
	// Disabled
	SYSCON_STARTERP1_ACMP1_DISABLED = 0x0
	// Enabled
	SYSCON_STARTERP1_ACMP1_ENABLED = 0x1
	// Position of ACMP2 field.
	SYSCON_STARTERP1_ACMP2_Pos = 0xa
	// Bit mask of ACMP2 field.
	SYSCON_STARTERP1_ACMP2_Msk = 0x400
	// Bit ACMP2.
	SYSCON_STARTERP1_ACMP2 = 0x400
	// Disabled
	SYSCON_STARTERP1_ACMP2_DISABLED = 0x0
	// Enabled
	SYSCON_STARTERP1_ACMP2_ENABLED = 0x1
	// Position of ACMP3 field.
	SYSCON_STARTERP1_ACMP3_Pos = 0xb
	// Bit mask of ACMP3 field.
	SYSCON_STARTERP1_ACMP3_Msk = 0x800
	// Bit ACMP3.
	SYSCON_STARTERP1_ACMP3 = 0x800
	// Disabled
	SYSCON_STARTERP1_ACMP3_DISABLED = 0x0
	// Enabled
	SYSCON_STARTERP1_ACMP3_ENABLED = 0x1
	// Position of RESERVED field.
	SYSCON_STARTERP1_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	SYSCON_STARTERP1_RESERVED_Msk = 0x1000
	// Bit RESERVED.
	SYSCON_STARTERP1_RESERVED = 0x1000
	// Position of RTCALARM field.
	SYSCON_STARTERP1_RTCALARM_Pos = 0xd
	// Bit mask of RTCALARM field.
	SYSCON_STARTERP1_RTCALARM_Msk = 0x2000
	// Bit RTCALARM.
	SYSCON_STARTERP1_RTCALARM = 0x2000
	// Disabled
	SYSCON_STARTERP1_RTCALARM_DISABLED = 0x0
	// Enabled
	SYSCON_STARTERP1_RTCALARM_ENABLED = 0x1
	// Position of RTCWAKE field.
	SYSCON_STARTERP1_RTCWAKE_Pos = 0xe
	// Bit mask of RTCWAKE field.
	SYSCON_STARTERP1_RTCWAKE_Msk = 0x4000
	// Bit RTCWAKE.
	SYSCON_STARTERP1_RTCWAKE = 0x4000
	// Disabled
	SYSCON_STARTERP1_RTCWAKE_DISABLED = 0x0
	// Enabled
	SYSCON_STARTERP1_RTCWAKE_ENABLED = 0x1
	// Position of RESERVED field.
	SYSCON_STARTERP1_RESERVED_Pos = 0xf
	// Bit mask of RESERVED field.
	SYSCON_STARTERP1_RESERVED_Msk = 0xffff8000
)

// Bitfields for MRT: Multi-Rate Timer (MRT)
const (
	// INTVAL0: MRT0 Time interval value register. This value is loaded into the TIMER0 register.
	// Position of IVALUE field.
	MRT_INTVAL_IVALUE_Pos = 0x0
	// Bit mask of IVALUE field.
	MRT_INTVAL_IVALUE_Msk = 0xffffff
	// Position of RESERVED field.
	MRT_INTVAL_RESERVED_Pos = 0x18
	// Bit mask of RESERVED field.
	MRT_INTVAL_RESERVED_Msk = 0x7f000000
	// Position of LOAD field.
	MRT_INTVAL_LOAD_Pos = 0x1f
	// Bit mask of LOAD field.
	MRT_INTVAL_LOAD_Msk = 0x80000000
	// Bit LOAD.
	MRT_INTVAL_LOAD = 0x80000000
	// No force load. The load from the INTVALn register to the TIMERn register is processed at the end of the time interval if the repeat mode is selected.
	MRT_INTVAL_LOAD_NO_FORCE_LOAD = 0x0
	// Force load. The INTVALn interval value IVALUE -1 is immediately loaded into the TIMERn register while TIMERn is running.
	MRT_INTVAL_LOAD_FORCE_LOAD = 0x1

	// TIMER0: MRT0 Timer register. This register reads the value of the down-counter.
	// Position of VALUE field.
	MRT_TIMER_VALUE_Pos = 0x0
	// Bit mask of VALUE field.
	MRT_TIMER_VALUE_Msk = 0xffffff
	// Position of RESERVED field.
	MRT_TIMER_RESERVED_Pos = 0x18
	// Bit mask of RESERVED field.
	MRT_TIMER_RESERVED_Msk = 0xff000000

	// CTRL0: MRT0 Control register. This register controls the MRT0 modes.
	// Position of INTEN field.
	MRT_CTRL_INTEN_Pos = 0x0
	// Bit mask of INTEN field.
	MRT_CTRL_INTEN_Msk = 0x1
	// Bit INTEN.
	MRT_CTRL_INTEN = 0x1
	// Disable.
	MRT_CTRL_INTEN_DISABLE = 0x0
	// Enable.
	MRT_CTRL_INTEN_ENABLE = 0x1
	// Position of MODE field.
	MRT_CTRL_MODE_Pos = 0x1
	// Bit mask of MODE field.
	MRT_CTRL_MODE_Msk = 0x6
	// Repeat interrupt mode.
	MRT_CTRL_MODE_REPEAT_INTERRUPT_MOD = 0x0
	// One-shot interrupt mode.
	MRT_CTRL_MODE_ONE_SHOT_INTERRUPT_M = 0x1
	// Position of RESERVED field.
	MRT_CTRL_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	MRT_CTRL_RESERVED_Msk = 0xfffffff8

	// STAT0: MRT0 Status register.
	// Position of INTFLAG field.
	MRT_STAT_INTFLAG_Pos = 0x0
	// Bit mask of INTFLAG field.
	MRT_STAT_INTFLAG_Msk = 0x1
	// Bit INTFLAG.
	MRT_STAT_INTFLAG = 0x1
	// No pending interrupt. Writing a zero is equivalent to no operation.
	MRT_STAT_INTFLAG_NO_PENDING_INTERRUPT = 0x0
	// Pending interrupt. The interrupt is pending because TIMERn has reached the end of the time interval. If the INTEN bit in the CONTROLn is also set to 1, the interrupt for timer channel n and the global interrupt are raised. Writing a 1 to this bit clears the interrupt request.
	MRT_STAT_INTFLAG_PENDING_INTERRUPT = 0x1
	// Position of RUN field.
	MRT_STAT_RUN_Pos = 0x1
	// Bit mask of RUN field.
	MRT_STAT_RUN_Msk = 0x2
	// Bit RUN.
	MRT_STAT_RUN = 0x2
	// Idle state. TIMERn is stopped.
	MRT_STAT_RUN_IDLE_STATE = 0x0
	// Running. TIMERn is running.
	MRT_STAT_RUN_RUNNING = 0x1
	// Position of RESERVED field.
	MRT_STAT_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	MRT_STAT_RESERVED_Msk = 0xfffffffc

	// IDLE_CH: Idle channel register. This register returns the number of the first idle channel.
	// Position of RESERVED field.
	MRT_IDLE_CH_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	MRT_IDLE_CH_RESERVED_Msk = 0xf
	// Position of CHAN field.
	MRT_IDLE_CH_CHAN_Pos = 0x4
	// Bit mask of CHAN field.
	MRT_IDLE_CH_CHAN_Msk = 0xf0
	// Position of RESERVED field.
	MRT_IDLE_CH_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	MRT_IDLE_CH_RESERVED_Msk = 0xffffff00

	// IRQ_FLAG: Global interrupt flag register
	// Position of GFLAG0 field.
	MRT_IRQ_FLAG_GFLAG0_Pos = 0x0
	// Bit mask of GFLAG0 field.
	MRT_IRQ_FLAG_GFLAG0_Msk = 0x1
	// Bit GFLAG0.
	MRT_IRQ_FLAG_GFLAG0 = 0x1
	// No pending interrupt. Writing a zero is equivalent to no operation.
	MRT_IRQ_FLAG_GFLAG0_NO_PENDING_INTERRUPT = 0x0
	// Pending interrupt. The interrupt is pending because TIMER0 has reached the end of the time interval. If the INTEN bit in the CONTROL0 register is also set to 1, the interrupt for timer channel 0 and the global interrupt are raised. Writing a 1 to this bit clears the interrupt request.
	MRT_IRQ_FLAG_GFLAG0_PENDING_INTERRUPT = 0x1
	// Position of GFLAG1 field.
	MRT_IRQ_FLAG_GFLAG1_Pos = 0x1
	// Bit mask of GFLAG1 field.
	MRT_IRQ_FLAG_GFLAG1_Msk = 0x2
	// Bit GFLAG1.
	MRT_IRQ_FLAG_GFLAG1 = 0x2
	// No pending interrupt. Writing a zero is equivalent to no operation.
	MRT_IRQ_FLAG_GFLAG1_NO_PENDING_INTERRUPT = 0x0
	// Pending interrupt. The interrupt is pending because TIMER1 has reached the end of the time interval. If the INTEN bit in the CONTROL1 register is also set to 1, the interrupt for timer channel 1 and the global interrupt are raised. Writing a 1 to this bit clears the interrupt request.
	MRT_IRQ_FLAG_GFLAG1_PENDING_INTERRUPT = 0x1
	// Position of GFLAG2 field.
	MRT_IRQ_FLAG_GFLAG2_Pos = 0x2
	// Bit mask of GFLAG2 field.
	MRT_IRQ_FLAG_GFLAG2_Msk = 0x4
	// Bit GFLAG2.
	MRT_IRQ_FLAG_GFLAG2 = 0x4
	// No pending interrupt. Writing a zero is equivalent to no operation.
	MRT_IRQ_FLAG_GFLAG2_NO_PENDING_INTERRUPT = 0x0
	// Pending interrupt. The interrupt is pending because TIMER2 has reached the end of the time interval. If the INTEN bit in the CONTROL2 register is also set to 1, the interrupt for timer channel 2 and the global interrupt are raised. Writing a 1 to this bit clears the interrupt request.
	MRT_IRQ_FLAG_GFLAG2_PENDING_INTERRUPT = 0x1
	// Position of GFLAG3 field.
	MRT_IRQ_FLAG_GFLAG3_Pos = 0x3
	// Bit mask of GFLAG3 field.
	MRT_IRQ_FLAG_GFLAG3_Msk = 0x8
	// Bit GFLAG3.
	MRT_IRQ_FLAG_GFLAG3 = 0x8
	// No pending interrupt. Writing a zero is equivalent to no operation.
	MRT_IRQ_FLAG_GFLAG3_NO_PENDING_INTERRUPT = 0x0
	// Pending interrupt. The interrupt is pending because TIMER3 has reached the end of the time interval. If the INTEN bit in the CONTROL3 register is also set to 1, the interrupt for timer channel 3 and the global interrupt are raised. Writing a 1 to this bit clears the interrupt request.
	MRT_IRQ_FLAG_GFLAG3_PENDING_INTERRUPT = 0x1
	// Position of RESERVED field.
	MRT_IRQ_FLAG_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	MRT_IRQ_FLAG_RESERVED_Msk = 0xfffffff0
)

// Bitfields for PINT: Pin interrupt and pattern match (PINT)
const (
	// ISEL: Pin Interrupt Mode register
	// Position of PMODE0 field.
	PINT_ISEL_PMODE0_Pos = 0x0
	// Bit mask of PMODE0 field.
	PINT_ISEL_PMODE0_Msk = 0x1
	// Bit PMODE0.
	PINT_ISEL_PMODE0 = 0x1
	// Position of PMODE1 field.
	PINT_ISEL_PMODE1_Pos = 0x1
	// Bit mask of PMODE1 field.
	PINT_ISEL_PMODE1_Msk = 0x2
	// Bit PMODE1.
	PINT_ISEL_PMODE1 = 0x2
	// Position of PMODE2 field.
	PINT_ISEL_PMODE2_Pos = 0x2
	// Bit mask of PMODE2 field.
	PINT_ISEL_PMODE2_Msk = 0x4
	// Bit PMODE2.
	PINT_ISEL_PMODE2 = 0x4
	// Position of PMODE3 field.
	PINT_ISEL_PMODE3_Pos = 0x3
	// Bit mask of PMODE3 field.
	PINT_ISEL_PMODE3_Msk = 0x8
	// Bit PMODE3.
	PINT_ISEL_PMODE3 = 0x8
	// Position of PMODE4 field.
	PINT_ISEL_PMODE4_Pos = 0x4
	// Bit mask of PMODE4 field.
	PINT_ISEL_PMODE4_Msk = 0x10
	// Bit PMODE4.
	PINT_ISEL_PMODE4 = 0x10
	// Position of PMODE5 field.
	PINT_ISEL_PMODE5_Pos = 0x5
	// Bit mask of PMODE5 field.
	PINT_ISEL_PMODE5_Msk = 0x20
	// Bit PMODE5.
	PINT_ISEL_PMODE5 = 0x20
	// Position of PMODE6 field.
	PINT_ISEL_PMODE6_Pos = 0x6
	// Bit mask of PMODE6 field.
	PINT_ISEL_PMODE6_Msk = 0x40
	// Bit PMODE6.
	PINT_ISEL_PMODE6 = 0x40
	// Position of PMODE7 field.
	PINT_ISEL_PMODE7_Pos = 0x7
	// Bit mask of PMODE7 field.
	PINT_ISEL_PMODE7_Msk = 0x80
	// Bit PMODE7.
	PINT_ISEL_PMODE7 = 0x80
	// Position of RESERVED field.
	PINT_ISEL_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	PINT_ISEL_RESERVED_Msk = 0xffffff00

	// IENR: Pin interrupt level or rising edge interrupt enable register
	// Position of ENRL0 field.
	PINT_IENR_ENRL0_Pos = 0x0
	// Bit mask of ENRL0 field.
	PINT_IENR_ENRL0_Msk = 0x1
	// Bit ENRL0.
	PINT_IENR_ENRL0 = 0x1
	// Position of ENRL1 field.
	PINT_IENR_ENRL1_Pos = 0x1
	// Bit mask of ENRL1 field.
	PINT_IENR_ENRL1_Msk = 0x2
	// Bit ENRL1.
	PINT_IENR_ENRL1 = 0x2
	// Position of ENRL2 field.
	PINT_IENR_ENRL2_Pos = 0x2
	// Bit mask of ENRL2 field.
	PINT_IENR_ENRL2_Msk = 0x4
	// Bit ENRL2.
	PINT_IENR_ENRL2 = 0x4
	// Position of ENRL3 field.
	PINT_IENR_ENRL3_Pos = 0x3
	// Bit mask of ENRL3 field.
	PINT_IENR_ENRL3_Msk = 0x8
	// Bit ENRL3.
	PINT_IENR_ENRL3 = 0x8
	// Position of ENRL4 field.
	PINT_IENR_ENRL4_Pos = 0x4
	// Bit mask of ENRL4 field.
	PINT_IENR_ENRL4_Msk = 0x10
	// Bit ENRL4.
	PINT_IENR_ENRL4 = 0x10
	// Position of ENRL5 field.
	PINT_IENR_ENRL5_Pos = 0x5
	// Bit mask of ENRL5 field.
	PINT_IENR_ENRL5_Msk = 0x20
	// Bit ENRL5.
	PINT_IENR_ENRL5 = 0x20
	// Position of ENRL6 field.
	PINT_IENR_ENRL6_Pos = 0x6
	// Bit mask of ENRL6 field.
	PINT_IENR_ENRL6_Msk = 0x40
	// Bit ENRL6.
	PINT_IENR_ENRL6 = 0x40
	// Position of ENRL7 field.
	PINT_IENR_ENRL7_Pos = 0x7
	// Bit mask of ENRL7 field.
	PINT_IENR_ENRL7_Msk = 0x80
	// Bit ENRL7.
	PINT_IENR_ENRL7 = 0x80
	// Position of RESERVED field.
	PINT_IENR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	PINT_IENR_RESERVED_Msk = 0xffffff00

	// SIENR: Pin interrupt level or rising edge interrupt set register
	// Position of SETENRL0 field.
	PINT_SIENR_SETENRL0_Pos = 0x0
	// Bit mask of SETENRL0 field.
	PINT_SIENR_SETENRL0_Msk = 0x1
	// Bit SETENRL0.
	PINT_SIENR_SETENRL0 = 0x1
	// Position of SETENRL1 field.
	PINT_SIENR_SETENRL1_Pos = 0x1
	// Bit mask of SETENRL1 field.
	PINT_SIENR_SETENRL1_Msk = 0x2
	// Bit SETENRL1.
	PINT_SIENR_SETENRL1 = 0x2
	// Position of SETENRL2 field.
	PINT_SIENR_SETENRL2_Pos = 0x2
	// Bit mask of SETENRL2 field.
	PINT_SIENR_SETENRL2_Msk = 0x4
	// Bit SETENRL2.
	PINT_SIENR_SETENRL2 = 0x4
	// Position of SETENRL3 field.
	PINT_SIENR_SETENRL3_Pos = 0x3
	// Bit mask of SETENRL3 field.
	PINT_SIENR_SETENRL3_Msk = 0x8
	// Bit SETENRL3.
	PINT_SIENR_SETENRL3 = 0x8
	// Position of SETENRL4 field.
	PINT_SIENR_SETENRL4_Pos = 0x4
	// Bit mask of SETENRL4 field.
	PINT_SIENR_SETENRL4_Msk = 0x10
	// Bit SETENRL4.
	PINT_SIENR_SETENRL4 = 0x10
	// Position of SETENRL5 field.
	PINT_SIENR_SETENRL5_Pos = 0x5
	// Bit mask of SETENRL5 field.
	PINT_SIENR_SETENRL5_Msk = 0x20
	// Bit SETENRL5.
	PINT_SIENR_SETENRL5 = 0x20
	// Position of SETENRL6 field.
	PINT_SIENR_SETENRL6_Pos = 0x6
	// Bit mask of SETENRL6 field.
	PINT_SIENR_SETENRL6_Msk = 0x40
	// Bit SETENRL6.
	PINT_SIENR_SETENRL6 = 0x40
	// Position of SETENRL7 field.
	PINT_SIENR_SETENRL7_Pos = 0x7
	// Bit mask of SETENRL7 field.
	PINT_SIENR_SETENRL7_Msk = 0x80
	// Bit SETENRL7.
	PINT_SIENR_SETENRL7 = 0x80
	// Position of RESERVED field.
	PINT_SIENR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	PINT_SIENR_RESERVED_Msk = 0xffffff00

	// CIENR: Pin interrupt level (rising edge interrupt) clear register
	// Position of CENRL0 field.
	PINT_CIENR_CENRL0_Pos = 0x0
	// Bit mask of CENRL0 field.
	PINT_CIENR_CENRL0_Msk = 0x1
	// Bit CENRL0.
	PINT_CIENR_CENRL0 = 0x1
	// Position of CENRL1 field.
	PINT_CIENR_CENRL1_Pos = 0x1
	// Bit mask of CENRL1 field.
	PINT_CIENR_CENRL1_Msk = 0x2
	// Bit CENRL1.
	PINT_CIENR_CENRL1 = 0x2
	// Position of CENRL2 field.
	PINT_CIENR_CENRL2_Pos = 0x2
	// Bit mask of CENRL2 field.
	PINT_CIENR_CENRL2_Msk = 0x4
	// Bit CENRL2.
	PINT_CIENR_CENRL2 = 0x4
	// Position of CENRL3 field.
	PINT_CIENR_CENRL3_Pos = 0x3
	// Bit mask of CENRL3 field.
	PINT_CIENR_CENRL3_Msk = 0x8
	// Bit CENRL3.
	PINT_CIENR_CENRL3 = 0x8
	// Position of CENRL4 field.
	PINT_CIENR_CENRL4_Pos = 0x4
	// Bit mask of CENRL4 field.
	PINT_CIENR_CENRL4_Msk = 0x10
	// Bit CENRL4.
	PINT_CIENR_CENRL4 = 0x10
	// Position of CENRL5 field.
	PINT_CIENR_CENRL5_Pos = 0x5
	// Bit mask of CENRL5 field.
	PINT_CIENR_CENRL5_Msk = 0x20
	// Bit CENRL5.
	PINT_CIENR_CENRL5 = 0x20
	// Position of CENRL6 field.
	PINT_CIENR_CENRL6_Pos = 0x6
	// Bit mask of CENRL6 field.
	PINT_CIENR_CENRL6_Msk = 0x40
	// Bit CENRL6.
	PINT_CIENR_CENRL6 = 0x40
	// Position of CENRL7 field.
	PINT_CIENR_CENRL7_Pos = 0x7
	// Bit mask of CENRL7 field.
	PINT_CIENR_CENRL7_Msk = 0x80
	// Bit CENRL7.
	PINT_CIENR_CENRL7 = 0x80
	// Position of RESERVED field.
	PINT_CIENR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	PINT_CIENR_RESERVED_Msk = 0xffffff00

	// IENF: Pin interrupt active level or falling edge interrupt enable register
	// Position of ENAF0 field.
	PINT_IENF_ENAF0_Pos = 0x0
	// Bit mask of ENAF0 field.
	PINT_IENF_ENAF0_Msk = 0x1
	// Bit ENAF0.
	PINT_IENF_ENAF0 = 0x1
	// Position of ENAF1 field.
	PINT_IENF_ENAF1_Pos = 0x1
	// Bit mask of ENAF1 field.
	PINT_IENF_ENAF1_Msk = 0x2
	// Bit ENAF1.
	PINT_IENF_ENAF1 = 0x2
	// Position of ENAF2 field.
	PINT_IENF_ENAF2_Pos = 0x2
	// Bit mask of ENAF2 field.
	PINT_IENF_ENAF2_Msk = 0x4
	// Bit ENAF2.
	PINT_IENF_ENAF2 = 0x4
	// Position of ENAF3 field.
	PINT_IENF_ENAF3_Pos = 0x3
	// Bit mask of ENAF3 field.
	PINT_IENF_ENAF3_Msk = 0x8
	// Bit ENAF3.
	PINT_IENF_ENAF3 = 0x8
	// Position of ENAF4 field.
	PINT_IENF_ENAF4_Pos = 0x4
	// Bit mask of ENAF4 field.
	PINT_IENF_ENAF4_Msk = 0x10
	// Bit ENAF4.
	PINT_IENF_ENAF4 = 0x10
	// Position of ENAF5 field.
	PINT_IENF_ENAF5_Pos = 0x5
	// Bit mask of ENAF5 field.
	PINT_IENF_ENAF5_Msk = 0x20
	// Bit ENAF5.
	PINT_IENF_ENAF5 = 0x20
	// Position of ENAF6 field.
	PINT_IENF_ENAF6_Pos = 0x6
	// Bit mask of ENAF6 field.
	PINT_IENF_ENAF6_Msk = 0x40
	// Bit ENAF6.
	PINT_IENF_ENAF6 = 0x40
	// Position of ENAF7 field.
	PINT_IENF_ENAF7_Pos = 0x7
	// Bit mask of ENAF7 field.
	PINT_IENF_ENAF7_Msk = 0x80
	// Bit ENAF7.
	PINT_IENF_ENAF7 = 0x80
	// Position of RESERVED field.
	PINT_IENF_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	PINT_IENF_RESERVED_Msk = 0xffffff00

	// SIENF: Pin interrupt active level or falling edge interrupt set register
	// Position of SETENAF0 field.
	PINT_SIENF_SETENAF0_Pos = 0x0
	// Bit mask of SETENAF0 field.
	PINT_SIENF_SETENAF0_Msk = 0x1
	// Bit SETENAF0.
	PINT_SIENF_SETENAF0 = 0x1
	// Position of SETENAF1 field.
	PINT_SIENF_SETENAF1_Pos = 0x1
	// Bit mask of SETENAF1 field.
	PINT_SIENF_SETENAF1_Msk = 0x2
	// Bit SETENAF1.
	PINT_SIENF_SETENAF1 = 0x2
	// Position of SETENAF2 field.
	PINT_SIENF_SETENAF2_Pos = 0x2
	// Bit mask of SETENAF2 field.
	PINT_SIENF_SETENAF2_Msk = 0x4
	// Bit SETENAF2.
	PINT_SIENF_SETENAF2 = 0x4
	// Position of SETENAF3 field.
	PINT_SIENF_SETENAF3_Pos = 0x3
	// Bit mask of SETENAF3 field.
	PINT_SIENF_SETENAF3_Msk = 0x8
	// Bit SETENAF3.
	PINT_SIENF_SETENAF3 = 0x8
	// Position of SETENAF4 field.
	PINT_SIENF_SETENAF4_Pos = 0x4
	// Bit mask of SETENAF4 field.
	PINT_SIENF_SETENAF4_Msk = 0x10
	// Bit SETENAF4.
	PINT_SIENF_SETENAF4 = 0x10
	// Position of SETENAF5 field.
	PINT_SIENF_SETENAF5_Pos = 0x5
	// Bit mask of SETENAF5 field.
	PINT_SIENF_SETENAF5_Msk = 0x20
	// Bit SETENAF5.
	PINT_SIENF_SETENAF5 = 0x20
	// Position of SETENAF6 field.
	PINT_SIENF_SETENAF6_Pos = 0x6
	// Bit mask of SETENAF6 field.
	PINT_SIENF_SETENAF6_Msk = 0x40
	// Bit SETENAF6.
	PINT_SIENF_SETENAF6 = 0x40
	// Position of SETENAF7 field.
	PINT_SIENF_SETENAF7_Pos = 0x7
	// Bit mask of SETENAF7 field.
	PINT_SIENF_SETENAF7_Msk = 0x80
	// Bit SETENAF7.
	PINT_SIENF_SETENAF7 = 0x80
	// Position of RESERVED field.
	PINT_SIENF_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	PINT_SIENF_RESERVED_Msk = 0xffffff00

	// CIENF: Pin interrupt active level or falling edge interrupt clear register
	// Position of CENAF0 field.
	PINT_CIENF_CENAF0_Pos = 0x0
	// Bit mask of CENAF0 field.
	PINT_CIENF_CENAF0_Msk = 0x1
	// Bit CENAF0.
	PINT_CIENF_CENAF0 = 0x1
	// Position of CENAF1 field.
	PINT_CIENF_CENAF1_Pos = 0x1
	// Bit mask of CENAF1 field.
	PINT_CIENF_CENAF1_Msk = 0x2
	// Bit CENAF1.
	PINT_CIENF_CENAF1 = 0x2
	// Position of CENAF2 field.
	PINT_CIENF_CENAF2_Pos = 0x2
	// Bit mask of CENAF2 field.
	PINT_CIENF_CENAF2_Msk = 0x4
	// Bit CENAF2.
	PINT_CIENF_CENAF2 = 0x4
	// Position of CENAF3 field.
	PINT_CIENF_CENAF3_Pos = 0x3
	// Bit mask of CENAF3 field.
	PINT_CIENF_CENAF3_Msk = 0x8
	// Bit CENAF3.
	PINT_CIENF_CENAF3 = 0x8
	// Position of CENAF4 field.
	PINT_CIENF_CENAF4_Pos = 0x4
	// Bit mask of CENAF4 field.
	PINT_CIENF_CENAF4_Msk = 0x10
	// Bit CENAF4.
	PINT_CIENF_CENAF4 = 0x10
	// Position of CENAF5 field.
	PINT_CIENF_CENAF5_Pos = 0x5
	// Bit mask of CENAF5 field.
	PINT_CIENF_CENAF5_Msk = 0x20
	// Bit CENAF5.
	PINT_CIENF_CENAF5 = 0x20
	// Position of CENAF6 field.
	PINT_CIENF_CENAF6_Pos = 0x6
	// Bit mask of CENAF6 field.
	PINT_CIENF_CENAF6_Msk = 0x40
	// Bit CENAF6.
	PINT_CIENF_CENAF6 = 0x40
	// Position of CENAF7 field.
	PINT_CIENF_CENAF7_Pos = 0x7
	// Bit mask of CENAF7 field.
	PINT_CIENF_CENAF7_Msk = 0x80
	// Bit CENAF7.
	PINT_CIENF_CENAF7 = 0x80
	// Position of RESERVED field.
	PINT_CIENF_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	PINT_CIENF_RESERVED_Msk = 0xffffff00

	// RISE: Pin interrupt rising edge register
	// Position of RDET0 field.
	PINT_RISE_RDET0_Pos = 0x0
	// Bit mask of RDET0 field.
	PINT_RISE_RDET0_Msk = 0x1
	// Bit RDET0.
	PINT_RISE_RDET0 = 0x1
	// Position of RDET1 field.
	PINT_RISE_RDET1_Pos = 0x1
	// Bit mask of RDET1 field.
	PINT_RISE_RDET1_Msk = 0x2
	// Bit RDET1.
	PINT_RISE_RDET1 = 0x2
	// Position of RDET2 field.
	PINT_RISE_RDET2_Pos = 0x2
	// Bit mask of RDET2 field.
	PINT_RISE_RDET2_Msk = 0x4
	// Bit RDET2.
	PINT_RISE_RDET2 = 0x4
	// Position of RDET3 field.
	PINT_RISE_RDET3_Pos = 0x3
	// Bit mask of RDET3 field.
	PINT_RISE_RDET3_Msk = 0x8
	// Bit RDET3.
	PINT_RISE_RDET3 = 0x8
	// Position of RDET4 field.
	PINT_RISE_RDET4_Pos = 0x4
	// Bit mask of RDET4 field.
	PINT_RISE_RDET4_Msk = 0x10
	// Bit RDET4.
	PINT_RISE_RDET4 = 0x10
	// Position of RDET5 field.
	PINT_RISE_RDET5_Pos = 0x5
	// Bit mask of RDET5 field.
	PINT_RISE_RDET5_Msk = 0x20
	// Bit RDET5.
	PINT_RISE_RDET5 = 0x20
	// Position of RDET6 field.
	PINT_RISE_RDET6_Pos = 0x6
	// Bit mask of RDET6 field.
	PINT_RISE_RDET6_Msk = 0x40
	// Bit RDET6.
	PINT_RISE_RDET6 = 0x40
	// Position of RDET7 field.
	PINT_RISE_RDET7_Pos = 0x7
	// Bit mask of RDET7 field.
	PINT_RISE_RDET7_Msk = 0x80
	// Bit RDET7.
	PINT_RISE_RDET7 = 0x80
	// Position of RESERVED field.
	PINT_RISE_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	PINT_RISE_RESERVED_Msk = 0xffffff00

	// FALL: Pin interrupt falling edge register
	// Position of FDET0 field.
	PINT_FALL_FDET0_Pos = 0x0
	// Bit mask of FDET0 field.
	PINT_FALL_FDET0_Msk = 0x1
	// Bit FDET0.
	PINT_FALL_FDET0 = 0x1
	// Position of FDET1 field.
	PINT_FALL_FDET1_Pos = 0x1
	// Bit mask of FDET1 field.
	PINT_FALL_FDET1_Msk = 0x2
	// Bit FDET1.
	PINT_FALL_FDET1 = 0x2
	// Position of FDET2 field.
	PINT_FALL_FDET2_Pos = 0x2
	// Bit mask of FDET2 field.
	PINT_FALL_FDET2_Msk = 0x4
	// Bit FDET2.
	PINT_FALL_FDET2 = 0x4
	// Position of FDET3 field.
	PINT_FALL_FDET3_Pos = 0x3
	// Bit mask of FDET3 field.
	PINT_FALL_FDET3_Msk = 0x8
	// Bit FDET3.
	PINT_FALL_FDET3 = 0x8
	// Position of FDET4 field.
	PINT_FALL_FDET4_Pos = 0x4
	// Bit mask of FDET4 field.
	PINT_FALL_FDET4_Msk = 0x10
	// Bit FDET4.
	PINT_FALL_FDET4 = 0x10
	// Position of FDET5 field.
	PINT_FALL_FDET5_Pos = 0x5
	// Bit mask of FDET5 field.
	PINT_FALL_FDET5_Msk = 0x20
	// Bit FDET5.
	PINT_FALL_FDET5 = 0x20
	// Position of FDET6 field.
	PINT_FALL_FDET6_Pos = 0x6
	// Bit mask of FDET6 field.
	PINT_FALL_FDET6_Msk = 0x40
	// Bit FDET6.
	PINT_FALL_FDET6 = 0x40
	// Position of FDET7 field.
	PINT_FALL_FDET7_Pos = 0x7
	// Bit mask of FDET7 field.
	PINT_FALL_FDET7_Msk = 0x80
	// Bit FDET7.
	PINT_FALL_FDET7 = 0x80
	// Position of RESERVED field.
	PINT_FALL_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	PINT_FALL_RESERVED_Msk = 0xffffff00

	// IST: Pin interrupt status register
	// Position of PSTAT0 field.
	PINT_IST_PSTAT0_Pos = 0x0
	// Bit mask of PSTAT0 field.
	PINT_IST_PSTAT0_Msk = 0x1
	// Bit PSTAT0.
	PINT_IST_PSTAT0 = 0x1
	// Position of PSTAT1 field.
	PINT_IST_PSTAT1_Pos = 0x1
	// Bit mask of PSTAT1 field.
	PINT_IST_PSTAT1_Msk = 0x2
	// Bit PSTAT1.
	PINT_IST_PSTAT1 = 0x2
	// Position of PSTAT2 field.
	PINT_IST_PSTAT2_Pos = 0x2
	// Bit mask of PSTAT2 field.
	PINT_IST_PSTAT2_Msk = 0x4
	// Bit PSTAT2.
	PINT_IST_PSTAT2 = 0x4
	// Position of PSTAT3 field.
	PINT_IST_PSTAT3_Pos = 0x3
	// Bit mask of PSTAT3 field.
	PINT_IST_PSTAT3_Msk = 0x8
	// Bit PSTAT3.
	PINT_IST_PSTAT3 = 0x8
	// Position of PSTAT4 field.
	PINT_IST_PSTAT4_Pos = 0x4
	// Bit mask of PSTAT4 field.
	PINT_IST_PSTAT4_Msk = 0x10
	// Bit PSTAT4.
	PINT_IST_PSTAT4 = 0x10
	// Position of PSTAT5 field.
	PINT_IST_PSTAT5_Pos = 0x5
	// Bit mask of PSTAT5 field.
	PINT_IST_PSTAT5_Msk = 0x20
	// Bit PSTAT5.
	PINT_IST_PSTAT5 = 0x20
	// Position of PSTAT6 field.
	PINT_IST_PSTAT6_Pos = 0x6
	// Bit mask of PSTAT6 field.
	PINT_IST_PSTAT6_Msk = 0x40
	// Bit PSTAT6.
	PINT_IST_PSTAT6 = 0x40
	// Position of PSTAT7 field.
	PINT_IST_PSTAT7_Pos = 0x7
	// Bit mask of PSTAT7 field.
	PINT_IST_PSTAT7_Msk = 0x80
	// Bit PSTAT7.
	PINT_IST_PSTAT7 = 0x80
	// Position of RESERVED field.
	PINT_IST_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	PINT_IST_RESERVED_Msk = 0xffffff00

	// PMCTRL: Pattern match interrupt control register
	// Position of SEL_PMATCH field.
	PINT_PMCTRL_SEL_PMATCH_Pos = 0x0
	// Bit mask of SEL_PMATCH field.
	PINT_PMCTRL_SEL_PMATCH_Msk = 0x1
	// Bit SEL_PMATCH.
	PINT_PMCTRL_SEL_PMATCH = 0x1
	// Pin interrupt. Interrupts are driven in response to the standard pin interrupt function
	PINT_PMCTRL_SEL_PMATCH_PIN_INTERRUPT_INTER = 0x0
	// Pattern match. Interrupts are driven in response to pattern matches.
	PINT_PMCTRL_SEL_PMATCH_PATTERN_MATCH_INTER = 0x1
	// Position of ENA_RXEV field.
	PINT_PMCTRL_ENA_RXEV_Pos = 0x1
	// Bit mask of ENA_RXEV field.
	PINT_PMCTRL_ENA_RXEV_Msk = 0x2
	// Bit ENA_RXEV.
	PINT_PMCTRL_ENA_RXEV = 0x2
	// Disabled. RXEV output to the cpu is disabled.
	PINT_PMCTRL_ENA_RXEV_DISABLED_RXEV_OUTPU = 0x0
	// Enabled. RXEV output to the cpu is enabled.
	PINT_PMCTRL_ENA_RXEV_ENABLED_RXEV_OUTPUT = 0x1
	// Position of RESERVED field.
	PINT_PMCTRL_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	PINT_PMCTRL_RESERVED_Msk = 0xfffffc
	// Position of PMAT field.
	PINT_PMCTRL_PMAT_Pos = 0x18
	// Bit mask of PMAT field.
	PINT_PMCTRL_PMAT_Msk = 0xff000000

	// PMSRC: Pattern match interrupt bit-slice source register
	// Position of Reserved field.
	PINT_PMSRC_Reserved_Pos = 0x0
	// Bit mask of Reserved field.
	PINT_PMSRC_Reserved_Msk = 0xff
	// Position of SRC0 field.
	PINT_PMSRC_SRC0_Pos = 0x8
	// Bit mask of SRC0 field.
	PINT_PMSRC_SRC0_Msk = 0x700
	// Input 0. Selects the output of pin interrupt select register 0 as the source to bit slice 0.
	PINT_PMSRC_SRC0_INPUT_0_SELECTS_PIN = 0x0
	// Input 1. Selects the output of pin interrupt select register 1 as the source to bit slice 0.
	PINT_PMSRC_SRC0_INPUT_1_SELECTS_PIN = 0x1
	// Input 2. Selects the output of pin interrupt select register 2 as the source to bit slice 0.
	PINT_PMSRC_SRC0_INPUT_2_SELECTS_PIN = 0x2
	// Input 3. Selects the output of pin interrupt select register 3 as the source to bit slice 0.
	PINT_PMSRC_SRC0_INPUT_3_SELECTS_PIN = 0x3
	// Input 4. Selects the output of pin interrupt select register 4 as the source to bit slice 0.
	PINT_PMSRC_SRC0_INPUT_4_SELECTS_PIN = 0x4
	// Input 5. Selects the output of pin interrupt select register 5 as the source to bit slice 0.
	PINT_PMSRC_SRC0_INPUT_5_SELECTS_PIN = 0x5
	// Input 6. Selects the output of pin interrupt select register 6 as the source to bit slice 0.
	PINT_PMSRC_SRC0_INPUT_6_SELECTS_PIN = 0x6
	// Input 7. Selects the output of pin interrupt select register 7 as the source to bit slice 0.
	PINT_PMSRC_SRC0_INPUT_7_SELECTS_PIN = 0x7
	// Position of SRC1 field.
	PINT_PMSRC_SRC1_Pos = 0xb
	// Bit mask of SRC1 field.
	PINT_PMSRC_SRC1_Msk = 0x3800
	// Input 0. Selects pin interrupt input 0 as the source to bit slice 1.
	PINT_PMSRC_SRC1_INPUT_0_SELECTS_PIN = 0x0
	// Input 1. Selects pin interrupt input 1 as the source to bit slice 1.
	PINT_PMSRC_SRC1_INPUT_1_SELECTS_PIN = 0x1
	// Input 2. Selects pin interrupt input 2 as the source to bit slice 1.
	PINT_PMSRC_SRC1_INPUT_2_SELECTS_PIN = 0x2
	// Input 3. Selects pin interrupt input 3 as the source to bit slice 1.
	PINT_PMSRC_SRC1_INPUT_3_SELECTS_PIN = 0x3
	// Input 4. Selects pin interrupt input 4 as the source to bit slice 1.
	PINT_PMSRC_SRC1_INPUT_4_SELECTS_PIN = 0x4
	// Input 5. Selects pin interrupt input 5 as the source to bit slice 1.
	PINT_PMSRC_SRC1_INPUT_5_SELECTS_PIN = 0x5
	// Input 6. Selects pin interrupt input 6 as the source to bit slice 1.
	PINT_PMSRC_SRC1_INPUT_6_SELECTS_PIN = 0x6
	// Input 7. Selects pin interrupt input 7 as the source to bit slice 1.
	PINT_PMSRC_SRC1_INPUT_7_SELECTS_PIN = 0x7
	// Position of SRC2 field.
	PINT_PMSRC_SRC2_Pos = 0xe
	// Bit mask of SRC2 field.
	PINT_PMSRC_SRC2_Msk = 0x1c000
	// Input 0. Selects pin interrupt input 0 as the source to bit slice 2.
	PINT_PMSRC_SRC2_INPUT_0_SELECTS_PIN = 0x0
	// Input 1. Selects pin interrupt input 1 as the source to bit slice 2.
	PINT_PMSRC_SRC2_INPUT_1_SELECTS_PIN = 0x1
	// Input 2. Selects pin interrupt input 2 as the source to bit slice 2.
	PINT_PMSRC_SRC2_INPUT_2_SELECTS_PIN = 0x2
	// Input 3. Selects pin interrupt input 3 as the source to bit slice 2.
	PINT_PMSRC_SRC2_INPUT_3_SELECTS_PIN = 0x3
	// Input 4. Selects pin interrupt input 4 as the source to bit slice 2.
	PINT_PMSRC_SRC2_INPUT_4_SELECTS_PIN = 0x4
	// Input 5. Selects pin interrupt input 5 as the source to bit slice 2.
	PINT_PMSRC_SRC2_INPUT_5_SELECTS_PIN = 0x5
	// Input 6. Selects pin interrupt input 6 as the source to bit slice 2.
	PINT_PMSRC_SRC2_INPUT_6_SELECTS_PIN = 0x6
	// Input 7. Selects pin interrupt input 7 as the source to bit slice 2.
	PINT_PMSRC_SRC2_INPUT_7_SELECTS_PIN = 0x7
	// Position of SRC3 field.
	PINT_PMSRC_SRC3_Pos = 0x11
	// Bit mask of SRC3 field.
	PINT_PMSRC_SRC3_Msk = 0xe0000
	// Input 0. Selects pin interrupt input 0 as the source to bit slice 3.
	PINT_PMSRC_SRC3_INPUT_0_SELECTS_PIN = 0x0
	// Input 1. Selects pin interrupt input 1 as the source to bit slice 3.
	PINT_PMSRC_SRC3_INPUT_1_SELECTS_PIN = 0x1
	// Input 2. Selects pin interrupt input 2 as the source to bit slice 3.
	PINT_PMSRC_SRC3_INPUT_2_SELECTS_PIN = 0x2
	// Input 3. Selects pin interrupt input 3 as the source to bit slice 3.
	PINT_PMSRC_SRC3_INPUT_3_SELECTS_PIN = 0x3
	// Input 4. Selects pin interrupt input 4 as the source to bit slice 3.
	PINT_PMSRC_SRC3_INPUT_4_SELECTS_PIN = 0x4
	// Input 5. Selects pin interrupt input 5 as the source to bit slice 3.
	PINT_PMSRC_SRC3_INPUT_5_SELECTS_PIN = 0x5
	// Input 6. Selects pin interrupt input 6 as the source to bit slice 3.
	PINT_PMSRC_SRC3_INPUT_6_SELECTS_PIN = 0x6
	// Input 7. Selects pin interrupt input 7 as the source to bit slice 3.
	PINT_PMSRC_SRC3_INPUT_7_SELECTS_PIN = 0x7
	// Position of SRC4 field.
	PINT_PMSRC_SRC4_Pos = 0x14
	// Bit mask of SRC4 field.
	PINT_PMSRC_SRC4_Msk = 0x700000
	// Input 0. Selects pin interrupt input 0 as the source to bit slice 4.
	PINT_PMSRC_SRC4_INPUT_0_SELECTS_PIN = 0x0
	// Input 1. Selects pin interrupt input 1 as the source to bit slice 4.
	PINT_PMSRC_SRC4_INPUT_1_SELECTS_PIN = 0x1
	// Input 2. Selects pin interrupt input 2 as the source to bit slice 4.
	PINT_PMSRC_SRC4_INPUT_2_SELECTS_PIN = 0x2
	// Input 3. Selects pin interrupt input 3 as the source to bit slice 4.
	PINT_PMSRC_SRC4_INPUT_3_SELECTS_PIN = 0x3
	// Input 4. Selects pin interrupt input 4 as the source to bit slice 4.
	PINT_PMSRC_SRC4_INPUT_4_SELECTS_PIN = 0x4
	// Input 5. Selects pin interrupt input 5 as the source to bit slice 4.
	PINT_PMSRC_SRC4_INPUT_5_SELECTS_PIN = 0x5
	// Input 6. Selects pin interrupt input 6 as the source to bit slice 4.
	PINT_PMSRC_SRC4_INPUT_6_SELECTS_PIN = 0x6
	// Input 7. Selects pin interrupt input 7 as the source to bit slice 4.
	PINT_PMSRC_SRC4_INPUT_7_SELECTS_PIN = 0x7
	// Position of SRC5 field.
	PINT_PMSRC_SRC5_Pos = 0x17
	// Bit mask of SRC5 field.
	PINT_PMSRC_SRC5_Msk = 0x3800000
	// Input 0. Selects pin interrupt input 0 as the source to bit slice 5.
	PINT_PMSRC_SRC5_INPUT_0_SELECTS_PIN = 0x0
	// Input 1. Selects pin interrupt input 1 as the source to bit slice 5.
	PINT_PMSRC_SRC5_INPUT_1_SELECTS_PIN = 0x1
	// Input 2. Selects pin interrupt input 2 as the source to bit slice 5.
	PINT_PMSRC_SRC5_INPUT_2_SELECTS_PIN = 0x2
	// Input 3. Selects pin interrupt input 3 as the source to bit slice 5.
	PINT_PMSRC_SRC5_INPUT_3_SELECTS_PIN = 0x3
	// Input 4. Selects pin interrupt input 4 as the source to bit slice 5.
	PINT_PMSRC_SRC5_INPUT_4_SELECTS_PIN = 0x4
	// Input 5. Selects pin interrupt input 5 as the source to bit slice 5.
	PINT_PMSRC_SRC5_INPUT_5_SELECTS_PIN = 0x5
	// Input 6. Selects pin interrupt input 6 as the source to bit slice 5.
	PINT_PMSRC_SRC5_INPUT_6_SELECTS_PIN = 0x6
	// Input 7. Selects pin interrupt input 7 as the source to bit slice 5.
	PINT_PMSRC_SRC5_INPUT_7_SELECTS_PIN = 0x7
	// Position of SRC6 field.
	PINT_PMSRC_SRC6_Pos = 0x1a
	// Bit mask of SRC6 field.
	PINT_PMSRC_SRC6_Msk = 0x1c000000
	// Input 0. Selects pin interrupt input 0 as the source to bit slice 6.
	PINT_PMSRC_SRC6_INPUT_0_SELECTS_PIN = 0x0
	// Input 1. Selects pin interrupt input 1 as the source to bit slice 6.
	PINT_PMSRC_SRC6_INPUT_1_SELECTS_PIN = 0x1
	// Input 2. Selects pin interrupt input 2 as the source to bit slice 6.
	PINT_PMSRC_SRC6_INPUT_2_SELECTS_PIN = 0x2
	// Input 3. Selects pin interrupt input 3 as the source to bit slice 6.
	PINT_PMSRC_SRC6_INPUT_3_SELECTS_PIN = 0x3
	// Input 4. Selects pin interrupt input 4 as the source to bit slice 6.
	PINT_PMSRC_SRC6_INPUT_4_SELECTS_PIN = 0x4
	// Input 5. Selects pin interrupt input 5 as the source to bit slice 6.
	PINT_PMSRC_SRC6_INPUT_5_SELECTS_PIN = 0x5
	// Input 6. Selects pin interrupt input 6 as the source to bit slice 6.
	PINT_PMSRC_SRC6_INPUT_6_SELECTS_PIN = 0x6
	// Input 7. Selects pin interrupt input 7 as the source to bit slice 6.
	PINT_PMSRC_SRC6_INPUT_7_SELECTS_PIN = 0x7
	// Position of SRC7 field.
	PINT_PMSRC_SRC7_Pos = 0x1d
	// Bit mask of SRC7 field.
	PINT_PMSRC_SRC7_Msk = 0xe0000000
	// Input 0. Selects pin interrupt input 0 as the source to bit slice 7.
	PINT_PMSRC_SRC7_INPUT_0_SELECTS_PIN = 0x0
	// Input 1. Selects pin interrupt input 1 as the source to bit slice 7.
	PINT_PMSRC_SRC7_INPUT_1_SELECTS_PIN = 0x1
	// Input 2. Selects pin interrupt input 2 as the source to bit slice 7.
	PINT_PMSRC_SRC7_INPUT_2_SELECTS_PIN = 0x2
	// Input 3. Selects pin interrupt input 3 as the source to bit slice 7.
	PINT_PMSRC_SRC7_INPUT_3_SELECTS_PIN = 0x3
	// Input 4. Selects pin interrupt input 4 as the source to bit slice 7.
	PINT_PMSRC_SRC7_INPUT_4_SELECTS_PIN = 0x4
	// Input 5. Selects pin interrupt input 5 as the source to bit slice 7.
	PINT_PMSRC_SRC7_INPUT_5_SELECTS_PIN = 0x5
	// Input 6. Selects pin interrupt input 6 as the source to bit slice 7.
	PINT_PMSRC_SRC7_INPUT_6_SELECTS_PIN = 0x6
	// Input 7. Selects pin interrupt input 7 as the source to bit slice 7.
	PINT_PMSRC_SRC7_INPUT_7_SELECTS_PIN = 0x7

	// PMCFG: Pattern match interrupt bit slice configuration register
	// Position of PROD_ENDPTS field.
	PINT_PMCFG_PROD_ENDPTS_Pos = 0x0
	// Bit mask of PROD_ENDPTS field.
	PINT_PMCFG_PROD_ENDPTS_Msk = 0x7f
	// Position of RESERVED field.
	PINT_PMCFG_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	PINT_PMCFG_RESERVED_Msk = 0x80
	// Bit RESERVED.
	PINT_PMCFG_RESERVED = 0x80
	// Position of CFG0 field.
	PINT_PMCFG_CFG0_Pos = 0x8
	// Bit mask of CFG0 field.
	PINT_PMCFG_CFG0_Msk = 0x700
	// Constant HIGH. This bit slice always contributes to a product term match.
	PINT_PMCFG_CFG0_CONSTANT_HIGH_THIS_ = 0x0
	// Sticky rising edgeMatch occurs if a rising edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the PMSRC registers are written to.
	PINT_PMCFG_CFG0_STICKY_RISING_EDGEMA = 0x1
	// Sticky falling edge. Match occurs if a falling edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the PMSRC registers are written to.
	PINT_PMCFG_CFG0_STICKY_FALLING_EDGE_ = 0x2
	// Sticky rising or falling edge. Match occurs if either a rising or falling edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the PMSRC registers are written to.
	PINT_PMCFG_CFG0_STICKY_RISING_OR_FAL = 0x3
	// High level. Match (for this bit slice) occurs when there is a high level on the input specified for this bit slice in the PMSRC register.
	PINT_PMCFG_CFG0_HIGH_LEVEL_MATCH_F = 0x4
	// Low level. Match occurs when there is a low level on the specified input.
	PINT_PMCFG_CFG0_LOW_LEVEL_MATCH_OCC = 0x5
	// Constant 0. This bit slice never contributes to a match (should be used to disable any unused bit slices).
	PINT_PMCFG_CFG0_CONSTANT_0_THIS_BIT = 0x6
	// Event. Non-sticky rising or falling edge. Match occurs on an event - i.e. when either a rising or falling edge is first detected on the specified input (this is a non-sticky version of option 3) . This bit is cleared after one clock cycle.
	PINT_PMCFG_CFG0_EVENT_NON_STICKY_RI = 0x7
	// Position of CFG1 field.
	PINT_PMCFG_CFG1_Pos = 0xb
	// Bit mask of CFG1 field.
	PINT_PMCFG_CFG1_Msk = 0x3800
	// Constant HIGH. This bit slice always contributes to a product term match.
	PINT_PMCFG_CFG1_CONSTANT_HIGH_THIS_ = 0x0
	// Sticky rising edgeMatch occurs if a rising edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the PMSRC registers are written to.
	PINT_PMCFG_CFG1_STICKY_RISING_EDGEMA = 0x1
	// Sticky falling edge. Match occurs if a falling edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the PMSRC registers are written to.
	PINT_PMCFG_CFG1_STICKY_FALLING_EDGE_ = 0x2
	// Sticky rising or falling edge. Match occurs if either a rising or falling edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the PMSRC registers are written to.
	PINT_PMCFG_CFG1_STICKY_RISING_OR_FAL = 0x3
	// High level. Match (for this bit slice) occurs when there is a high level on the input specified for this bit slice in the PMSRC register.
	PINT_PMCFG_CFG1_HIGH_LEVEL_MATCH_F = 0x4
	// Low level. Match occurs when there is a low level on the specified input.
	PINT_PMCFG_CFG1_LOW_LEVEL_MATCH_OCC = 0x5
	// Constant 0. This bit slice never contributes to a match (should be used to disable any unused bit slices).
	PINT_PMCFG_CFG1_CONSTANT_0_THIS_BIT = 0x6
	// Event. Non-sticky rising or falling edge. Match occurs on an event - i.e. when either a rising or falling edge is first detected on the specified input (this is a non-sticky version of option 3) . This bit is cleared after one clock cycle.
	PINT_PMCFG_CFG1_EVENT_NON_STICKY_RI = 0x7
	// Position of CFG2 field.
	PINT_PMCFG_CFG2_Pos = 0xe
	// Bit mask of CFG2 field.
	PINT_PMCFG_CFG2_Msk = 0x1c000
	// Constant HIGH. This bit slice always contributes to a product term match.
	PINT_PMCFG_CFG2_CONSTANT_HIGH_THIS_ = 0x0
	// Sticky rising edgeMatch occurs if a rising edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the PMSRC registers are written to.
	PINT_PMCFG_CFG2_STICKY_RISING_EDGEMA = 0x1
	// Sticky falling edge. Match occurs if a falling edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the PMSRC registers are written to.
	PINT_PMCFG_CFG2_STICKY_FALLING_EDGE_ = 0x2
	// Sticky rising or falling edge. Match occurs if either a rising or falling edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the PMSRC registers are written to.
	PINT_PMCFG_CFG2_STICKY_RISING_OR_FAL = 0x3
	// High level. Match (for this bit slice) occurs when there is a high level on the input specified for this bit slice in the PMSRC register.
	PINT_PMCFG_CFG2_HIGH_LEVEL_MATCH_F = 0x4
	// Low level. Match occurs when there is a low level on the specified input.
	PINT_PMCFG_CFG2_LOW_LEVEL_MATCH_OCC = 0x5
	// Constant 0. This bit slice never contributes to a match (should be used to disable any unused bit slices).
	PINT_PMCFG_CFG2_CONSTANT_0_THIS_BIT = 0x6
	// Event. Non-sticky rising or falling edge. Match occurs on an event - i.e. when either a rising or falling edge is first detected on the specified input (this is a non-sticky version of option 3) . This bit is cleared after one clock cycle.
	PINT_PMCFG_CFG2_EVENT_NON_STICKY_RI = 0x7
	// Position of CFG3 field.
	PINT_PMCFG_CFG3_Pos = 0x11
	// Bit mask of CFG3 field.
	PINT_PMCFG_CFG3_Msk = 0xe0000
	// Constant HIGH. This bit slice always contributes to a product term match.
	PINT_PMCFG_CFG3_CONSTANT_HIGH_THIS_ = 0x0
	// Sticky rising edgeMatch occurs if a rising edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the PMSRC registers are written to.
	PINT_PMCFG_CFG3_STICKY_RISING_EDGEMA = 0x1
	// Sticky falling edge. Match occurs if a falling edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the PMSRC registers are written to.
	PINT_PMCFG_CFG3_STICKY_FALLING_EDGE_ = 0x2
	// Sticky rising or falling edge. Match occurs if either a rising or falling edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the PMSRC registers are written to.
	PINT_PMCFG_CFG3_STICKY_RISING_OR_FAL = 0x3
	// High level. Match (for this bit slice) occurs when there is a high level on the input specified for this bit slice in the PMSRC register.
	PINT_PMCFG_CFG3_HIGH_LEVEL_MATCH_F = 0x4
	// Low level. Match occurs when there is a low level on the specified input.
	PINT_PMCFG_CFG3_LOW_LEVEL_MATCH_OCC = 0x5
	// Constant 0. This bit slice never contributes to a match (should be used to disable any unused bit slices).
	PINT_PMCFG_CFG3_CONSTANT_0_THIS_BIT = 0x6
	// Event. Non-sticky rising or falling edge. Match occurs on an event - i.e. when either a rising or falling edge is first detected on the specified input (this is a non-sticky version of option 3) . This bit is cleared after one clock cycle.
	PINT_PMCFG_CFG3_EVENT_NON_STICKY_RI = 0x7
	// Position of CFG4 field.
	PINT_PMCFG_CFG4_Pos = 0x14
	// Bit mask of CFG4 field.
	PINT_PMCFG_CFG4_Msk = 0x700000
	// Constant HIGH. This bit slice always contributes to a product term match.
	PINT_PMCFG_CFG4_CONSTANT_HIGH_THIS_ = 0x0
	// Sticky rising edgeMatch occurs if a rising edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the PMSRC registers are written to.
	PINT_PMCFG_CFG4_STICKY_RISING_EDGEMA = 0x1
	// Sticky falling edge. Match occurs if a falling edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the PMSRC registers are written to.
	PINT_PMCFG_CFG4_STICKY_FALLING_EDGE_ = 0x2
	// Sticky rising or falling edge. Match occurs if either a rising or falling edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the PMSRC registers are written to.
	PINT_PMCFG_CFG4_STICKY_RISING_OR_FAL = 0x3
	// High level. Match (for this bit slice) occurs when there is a high level on the input specified for this bit slice in the PMSRC register.
	PINT_PMCFG_CFG4_HIGH_LEVEL_MATCH_F = 0x4
	// Low level. Match occurs when there is a low level on the specified input.
	PINT_PMCFG_CFG4_LOW_LEVEL_MATCH_OCC = 0x5
	// Constant 0. This bit slice never contributes to a match (should be used to disable any unused bit slices).
	PINT_PMCFG_CFG4_CONSTANT_0_THIS_BIT = 0x6
	// Event. Non-sticky rising or falling edge. Match occurs on an event - i.e. when either a rising or falling edge is first detected on the specified input (this is a non-sticky version of option 3) . This bit is cleared after one clock cycle.
	PINT_PMCFG_CFG4_EVENT_NON_STICKY_RI = 0x7
	// Position of CFG5 field.
	PINT_PMCFG_CFG5_Pos = 0x17
	// Bit mask of CFG5 field.
	PINT_PMCFG_CFG5_Msk = 0x3800000
	// Constant HIGH. This bit slice always contributes to a product term match.
	PINT_PMCFG_CFG5_CONSTANT_HIGH_THIS_ = 0x0
	// Sticky rising edgeMatch occurs if a rising edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the PMSRC registers are written to.
	PINT_PMCFG_CFG5_STICKY_RISING_EDGEMA = 0x1
	// Sticky falling edge. Match occurs if a falling edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the PMSRC registers are written to.
	PINT_PMCFG_CFG5_STICKY_FALLING_EDGE_ = 0x2
	// Sticky rising or falling edge. Match occurs if either a rising or falling edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the PMSRC registers are written to.
	PINT_PMCFG_CFG5_STICKY_RISING_OR_FAL = 0x3
	// High level. Match (for this bit slice) occurs when there is a high level on the input specified for this bit slice in the PMSRC register.
	PINT_PMCFG_CFG5_HIGH_LEVEL_MATCH_F = 0x4
	// Low level. Match occurs when there is a low level on the specified input.
	PINT_PMCFG_CFG5_LOW_LEVEL_MATCH_OCC = 0x5
	// Constant 0. This bit slice never contributes to a match (should be used to disable any unused bit slices).
	PINT_PMCFG_CFG5_CONSTANT_0_THIS_BIT = 0x6
	// Event. Non-sticky rising or falling edge. Match occurs on an event - i.e. when either a rising or falling edge is first detected on the specified input (this is a non-sticky version of option 3) . This bit is cleared after one clock cycle.
	PINT_PMCFG_CFG5_EVENT_NON_STICKY_RI = 0x7
	// Position of CFG6 field.
	PINT_PMCFG_CFG6_Pos = 0x1a
	// Bit mask of CFG6 field.
	PINT_PMCFG_CFG6_Msk = 0x1c000000
	// Constant HIGH. This bit slice always contributes to a product term match.
	PINT_PMCFG_CFG6_CONSTANT_HIGH_THIS_ = 0x0
	// Sticky rising edgeMatch occurs if a rising edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the PMSRC registers are written to.
	PINT_PMCFG_CFG6_STICKY_RISING_EDGEMA = 0x1
	// Sticky falling edge. Match occurs if a falling edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the PMSRC registers are written to.
	PINT_PMCFG_CFG6_STICKY_FALLING_EDGE_ = 0x2
	// Sticky rising or falling edge. Match occurs if either a rising or falling edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the PMSRC registers are written to.
	PINT_PMCFG_CFG6_STICKY_RISING_OR_FAL = 0x3
	// High level. Match (for this bit slice) occurs when there is a high level on the input specified for this bit slice in the PMSRC register.
	PINT_PMCFG_CFG6_HIGH_LEVEL_MATCH_F = 0x4
	// Low level. Match occurs when there is a low level on the specified input.
	PINT_PMCFG_CFG6_LOW_LEVEL_MATCH_OCC = 0x5
	// Constant 0. This bit slice never contributes to a match (should be used to disable any unused bit slices).
	PINT_PMCFG_CFG6_CONSTANT_0_THIS_BIT = 0x6
	// Event. Non-sticky rising or falling edge. Match occurs on an event - i.e. when either a rising or falling edge is first detected on the specified input (this is a non-sticky version of option 3) . This bit is cleared after one clock cycle.
	PINT_PMCFG_CFG6_EVENT_NON_STICKY_RI = 0x7
	// Position of CFG7 field.
	PINT_PMCFG_CFG7_Pos = 0x1d
	// Bit mask of CFG7 field.
	PINT_PMCFG_CFG7_Msk = 0xe0000000
	// Constant HIGH. This bit slice always contributes to a product term match.
	PINT_PMCFG_CFG7_CONSTANT_HIGH_THIS_ = 0x0
	// Sticky rising edgeMatch occurs if a rising edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the PMSRC registers are written to.
	PINT_PMCFG_CFG7_STICKY_RISING_EDGEMA = 0x1
	// Sticky falling edge. Match occurs if a falling edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the PMSRC registers are written to.
	PINT_PMCFG_CFG7_STICKY_FALLING_EDGE_ = 0x2
	// Sticky rising or falling edge. Match occurs if either a rising or falling edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the PMSRC registers are written to.
	PINT_PMCFG_CFG7_STICKY_RISING_OR_FAL = 0x3
	// High level. Match (for this bit slice) occurs when there is a high level on the input specified for this bit slice in the PMSRC register.
	PINT_PMCFG_CFG7_HIGH_LEVEL_MATCH_F = 0x4
	// Low level. Match occurs when there is a low level on the specified input.
	PINT_PMCFG_CFG7_LOW_LEVEL_MATCH_OCC = 0x5
	// Constant 0. This bit slice never contributes to a match (should be used to disable any unused bit slices).
	PINT_PMCFG_CFG7_CONSTANT_0_THIS_BIT = 0x6
	// Event. Non-sticky rising or falling edge. Match occurs on an event - i.e. when either a rising or falling edge is first detected on the specified input (this is a non-sticky version of option 3) . This bit is cleared after one clock cycle.
	PINT_PMCFG_CFG7_EVENT_NON_STICKY_RI = 0x7
)

// Bitfields for GINT0: Group interrupt 0/1 (GINT0/1)
const (
	// CTRL: GPIO grouped interrupt control register
	// Position of INT field.
	GINT_CTRL_INT_Pos = 0x0
	// Bit mask of INT field.
	GINT_CTRL_INT_Msk = 0x1
	// Bit INT.
	GINT_CTRL_INT = 0x1
	// No interrupt request is pending.
	GINT_CTRL_INT_NO_INTERRUPT_REQUEST = 0x0
	// Interrupt request is active.
	GINT_CTRL_INT_INTERRUPT_REQUEST_IS = 0x1
	// Position of COMB field.
	GINT_CTRL_COMB_Pos = 0x1
	// Bit mask of COMB field.
	GINT_CTRL_COMB_Msk = 0x2
	// Bit COMB.
	GINT_CTRL_COMB = 0x2
	// OR functionality: A grouped interrupt is generated when any one of the enabled inputs is active (based on its programmed polarity).
	GINT_CTRL_COMB_OR_FUNCTIONALITY_A_ = 0x0
	// AND functionality: An interrupt is generated when all enabled bits are active (based on their programmed polarity).
	GINT_CTRL_COMB_AND_FUNCTIONALITY_A = 0x1
	// Position of TRIG field.
	GINT_CTRL_TRIG_Pos = 0x2
	// Bit mask of TRIG field.
	GINT_CTRL_TRIG_Msk = 0x4
	// Bit TRIG.
	GINT_CTRL_TRIG = 0x4
	// Edge-triggered
	GINT_CTRL_TRIG_EDGE_TRIGGERED = 0x0
	// Level-triggered
	GINT_CTRL_TRIG_LEVEL_TRIGGERED = 0x1
	// Position of RESERVED field.
	GINT_CTRL_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	GINT_CTRL_RESERVED_Msk = 0xfffffff8

	// PORT_POL: GPIO grouped interrupt port 0 polarity register
	// Position of POL0 field.
	GINT_PORT_POL_POL0_Pos = 0x0
	// Bit mask of POL0 field.
	GINT_PORT_POL_POL0_Msk = 0x1
	// Bit POL0.
	GINT_PORT_POL_POL0 = 0x1
	// Position of POL1 field.
	GINT_PORT_POL_POL1_Pos = 0x1
	// Bit mask of POL1 field.
	GINT_PORT_POL_POL1_Msk = 0x2
	// Bit POL1.
	GINT_PORT_POL_POL1 = 0x2
	// Position of POL2 field.
	GINT_PORT_POL_POL2_Pos = 0x2
	// Bit mask of POL2 field.
	GINT_PORT_POL_POL2_Msk = 0x4
	// Bit POL2.
	GINT_PORT_POL_POL2 = 0x4
	// Position of POL3 field.
	GINT_PORT_POL_POL3_Pos = 0x3
	// Bit mask of POL3 field.
	GINT_PORT_POL_POL3_Msk = 0x8
	// Bit POL3.
	GINT_PORT_POL_POL3 = 0x8
	// Position of POL4 field.
	GINT_PORT_POL_POL4_Pos = 0x4
	// Bit mask of POL4 field.
	GINT_PORT_POL_POL4_Msk = 0x10
	// Bit POL4.
	GINT_PORT_POL_POL4 = 0x10
	// Position of POL5 field.
	GINT_PORT_POL_POL5_Pos = 0x5
	// Bit mask of POL5 field.
	GINT_PORT_POL_POL5_Msk = 0x20
	// Bit POL5.
	GINT_PORT_POL_POL5 = 0x20
	// Position of POL6 field.
	GINT_PORT_POL_POL6_Pos = 0x6
	// Bit mask of POL6 field.
	GINT_PORT_POL_POL6_Msk = 0x40
	// Bit POL6.
	GINT_PORT_POL_POL6 = 0x40
	// Position of POL7 field.
	GINT_PORT_POL_POL7_Pos = 0x7
	// Bit mask of POL7 field.
	GINT_PORT_POL_POL7_Msk = 0x80
	// Bit POL7.
	GINT_PORT_POL_POL7 = 0x80
	// Position of POL8 field.
	GINT_PORT_POL_POL8_Pos = 0x8
	// Bit mask of POL8 field.
	GINT_PORT_POL_POL8_Msk = 0x100
	// Bit POL8.
	GINT_PORT_POL_POL8 = 0x100
	// Position of POL9 field.
	GINT_PORT_POL_POL9_Pos = 0x9
	// Bit mask of POL9 field.
	GINT_PORT_POL_POL9_Msk = 0x200
	// Bit POL9.
	GINT_PORT_POL_POL9 = 0x200
	// Position of POL10 field.
	GINT_PORT_POL_POL10_Pos = 0xa
	// Bit mask of POL10 field.
	GINT_PORT_POL_POL10_Msk = 0x400
	// Bit POL10.
	GINT_PORT_POL_POL10 = 0x400
	// Position of POL11 field.
	GINT_PORT_POL_POL11_Pos = 0xb
	// Bit mask of POL11 field.
	GINT_PORT_POL_POL11_Msk = 0x800
	// Bit POL11.
	GINT_PORT_POL_POL11 = 0x800
	// Position of POL12 field.
	GINT_PORT_POL_POL12_Pos = 0xc
	// Bit mask of POL12 field.
	GINT_PORT_POL_POL12_Msk = 0x1000
	// Bit POL12.
	GINT_PORT_POL_POL12 = 0x1000
	// Position of POL13 field.
	GINT_PORT_POL_POL13_Pos = 0xd
	// Bit mask of POL13 field.
	GINT_PORT_POL_POL13_Msk = 0x2000
	// Bit POL13.
	GINT_PORT_POL_POL13 = 0x2000
	// Position of POL14 field.
	GINT_PORT_POL_POL14_Pos = 0xe
	// Bit mask of POL14 field.
	GINT_PORT_POL_POL14_Msk = 0x4000
	// Bit POL14.
	GINT_PORT_POL_POL14 = 0x4000
	// Position of POL15 field.
	GINT_PORT_POL_POL15_Pos = 0xf
	// Bit mask of POL15 field.
	GINT_PORT_POL_POL15_Msk = 0x8000
	// Bit POL15.
	GINT_PORT_POL_POL15 = 0x8000
	// Position of POL16 field.
	GINT_PORT_POL_POL16_Pos = 0x10
	// Bit mask of POL16 field.
	GINT_PORT_POL_POL16_Msk = 0x10000
	// Bit POL16.
	GINT_PORT_POL_POL16 = 0x10000
	// Position of POL17 field.
	GINT_PORT_POL_POL17_Pos = 0x11
	// Bit mask of POL17 field.
	GINT_PORT_POL_POL17_Msk = 0x20000
	// Bit POL17.
	GINT_PORT_POL_POL17 = 0x20000
	// Position of POL18 field.
	GINT_PORT_POL_POL18_Pos = 0x12
	// Bit mask of POL18 field.
	GINT_PORT_POL_POL18_Msk = 0x40000
	// Bit POL18.
	GINT_PORT_POL_POL18 = 0x40000
	// Position of POL19 field.
	GINT_PORT_POL_POL19_Pos = 0x13
	// Bit mask of POL19 field.
	GINT_PORT_POL_POL19_Msk = 0x80000
	// Bit POL19.
	GINT_PORT_POL_POL19 = 0x80000
	// Position of POL20 field.
	GINT_PORT_POL_POL20_Pos = 0x14
	// Bit mask of POL20 field.
	GINT_PORT_POL_POL20_Msk = 0x100000
	// Bit POL20.
	GINT_PORT_POL_POL20 = 0x100000
	// Position of POL21 field.
	GINT_PORT_POL_POL21_Pos = 0x15
	// Bit mask of POL21 field.
	GINT_PORT_POL_POL21_Msk = 0x200000
	// Bit POL21.
	GINT_PORT_POL_POL21 = 0x200000
	// Position of POL22 field.
	GINT_PORT_POL_POL22_Pos = 0x16
	// Bit mask of POL22 field.
	GINT_PORT_POL_POL22_Msk = 0x400000
	// Bit POL22.
	GINT_PORT_POL_POL22 = 0x400000
	// Position of POL23 field.
	GINT_PORT_POL_POL23_Pos = 0x17
	// Bit mask of POL23 field.
	GINT_PORT_POL_POL23_Msk = 0x800000
	// Bit POL23.
	GINT_PORT_POL_POL23 = 0x800000
	// Position of POL24 field.
	GINT_PORT_POL_POL24_Pos = 0x18
	// Bit mask of POL24 field.
	GINT_PORT_POL_POL24_Msk = 0x1000000
	// Bit POL24.
	GINT_PORT_POL_POL24 = 0x1000000
	// Position of POL25 field.
	GINT_PORT_POL_POL25_Pos = 0x19
	// Bit mask of POL25 field.
	GINT_PORT_POL_POL25_Msk = 0x2000000
	// Bit POL25.
	GINT_PORT_POL_POL25 = 0x2000000
	// Position of POL26 field.
	GINT_PORT_POL_POL26_Pos = 0x1a
	// Bit mask of POL26 field.
	GINT_PORT_POL_POL26_Msk = 0x4000000
	// Bit POL26.
	GINT_PORT_POL_POL26 = 0x4000000
	// Position of POL27 field.
	GINT_PORT_POL_POL27_Pos = 0x1b
	// Bit mask of POL27 field.
	GINT_PORT_POL_POL27_Msk = 0x8000000
	// Bit POL27.
	GINT_PORT_POL_POL27 = 0x8000000
	// Position of POL28 field.
	GINT_PORT_POL_POL28_Pos = 0x1c
	// Bit mask of POL28 field.
	GINT_PORT_POL_POL28_Msk = 0x10000000
	// Bit POL28.
	GINT_PORT_POL_POL28 = 0x10000000
	// Position of POL29 field.
	GINT_PORT_POL_POL29_Pos = 0x1d
	// Bit mask of POL29 field.
	GINT_PORT_POL_POL29_Msk = 0x20000000
	// Bit POL29.
	GINT_PORT_POL_POL29 = 0x20000000
	// Position of POL30 field.
	GINT_PORT_POL_POL30_Pos = 0x1e
	// Bit mask of POL30 field.
	GINT_PORT_POL_POL30_Msk = 0x40000000
	// Bit POL30.
	GINT_PORT_POL_POL30 = 0x40000000
	// Position of POL31 field.
	GINT_PORT_POL_POL31_Pos = 0x1f
	// Bit mask of POL31 field.
	GINT_PORT_POL_POL31_Msk = 0x80000000
	// Bit POL31.
	GINT_PORT_POL_POL31 = 0x80000000

	// PORT_ENA: GPIO grouped interrupt port 0 enable register
	// Position of ENA0 field.
	GINT_PORT_ENA_ENA0_Pos = 0x0
	// Bit mask of ENA0 field.
	GINT_PORT_ENA_ENA0_Msk = 0x1
	// Bit ENA0.
	GINT_PORT_ENA_ENA0 = 0x1
	// Position of ENA1 field.
	GINT_PORT_ENA_ENA1_Pos = 0x1
	// Bit mask of ENA1 field.
	GINT_PORT_ENA_ENA1_Msk = 0x2
	// Bit ENA1.
	GINT_PORT_ENA_ENA1 = 0x2
	// Position of ENA2 field.
	GINT_PORT_ENA_ENA2_Pos = 0x2
	// Bit mask of ENA2 field.
	GINT_PORT_ENA_ENA2_Msk = 0x4
	// Bit ENA2.
	GINT_PORT_ENA_ENA2 = 0x4
	// Position of ENA3 field.
	GINT_PORT_ENA_ENA3_Pos = 0x3
	// Bit mask of ENA3 field.
	GINT_PORT_ENA_ENA3_Msk = 0x8
	// Bit ENA3.
	GINT_PORT_ENA_ENA3 = 0x8
	// Position of ENA4 field.
	GINT_PORT_ENA_ENA4_Pos = 0x4
	// Bit mask of ENA4 field.
	GINT_PORT_ENA_ENA4_Msk = 0x10
	// Bit ENA4.
	GINT_PORT_ENA_ENA4 = 0x10
	// Position of ENA5 field.
	GINT_PORT_ENA_ENA5_Pos = 0x5
	// Bit mask of ENA5 field.
	GINT_PORT_ENA_ENA5_Msk = 0x20
	// Bit ENA5.
	GINT_PORT_ENA_ENA5 = 0x20
	// Position of ENA6 field.
	GINT_PORT_ENA_ENA6_Pos = 0x6
	// Bit mask of ENA6 field.
	GINT_PORT_ENA_ENA6_Msk = 0x40
	// Bit ENA6.
	GINT_PORT_ENA_ENA6 = 0x40
	// Position of ENA7 field.
	GINT_PORT_ENA_ENA7_Pos = 0x7
	// Bit mask of ENA7 field.
	GINT_PORT_ENA_ENA7_Msk = 0x80
	// Bit ENA7.
	GINT_PORT_ENA_ENA7 = 0x80
	// Position of ENA8 field.
	GINT_PORT_ENA_ENA8_Pos = 0x8
	// Bit mask of ENA8 field.
	GINT_PORT_ENA_ENA8_Msk = 0x100
	// Bit ENA8.
	GINT_PORT_ENA_ENA8 = 0x100
	// Position of ENA9 field.
	GINT_PORT_ENA_ENA9_Pos = 0x9
	// Bit mask of ENA9 field.
	GINT_PORT_ENA_ENA9_Msk = 0x200
	// Bit ENA9.
	GINT_PORT_ENA_ENA9 = 0x200
	// Position of ENA10 field.
	GINT_PORT_ENA_ENA10_Pos = 0xa
	// Bit mask of ENA10 field.
	GINT_PORT_ENA_ENA10_Msk = 0x400
	// Bit ENA10.
	GINT_PORT_ENA_ENA10 = 0x400
	// Position of ENA11 field.
	GINT_PORT_ENA_ENA11_Pos = 0xb
	// Bit mask of ENA11 field.
	GINT_PORT_ENA_ENA11_Msk = 0x800
	// Bit ENA11.
	GINT_PORT_ENA_ENA11 = 0x800
	// Position of ENA12 field.
	GINT_PORT_ENA_ENA12_Pos = 0xc
	// Bit mask of ENA12 field.
	GINT_PORT_ENA_ENA12_Msk = 0x1000
	// Bit ENA12.
	GINT_PORT_ENA_ENA12 = 0x1000
	// Position of ENA13 field.
	GINT_PORT_ENA_ENA13_Pos = 0xd
	// Bit mask of ENA13 field.
	GINT_PORT_ENA_ENA13_Msk = 0x2000
	// Bit ENA13.
	GINT_PORT_ENA_ENA13 = 0x2000
	// Position of ENA14 field.
	GINT_PORT_ENA_ENA14_Pos = 0xe
	// Bit mask of ENA14 field.
	GINT_PORT_ENA_ENA14_Msk = 0x4000
	// Bit ENA14.
	GINT_PORT_ENA_ENA14 = 0x4000
	// Position of ENA15 field.
	GINT_PORT_ENA_ENA15_Pos = 0xf
	// Bit mask of ENA15 field.
	GINT_PORT_ENA_ENA15_Msk = 0x8000
	// Bit ENA15.
	GINT_PORT_ENA_ENA15 = 0x8000
	// Position of ENA16 field.
	GINT_PORT_ENA_ENA16_Pos = 0x10
	// Bit mask of ENA16 field.
	GINT_PORT_ENA_ENA16_Msk = 0x10000
	// Bit ENA16.
	GINT_PORT_ENA_ENA16 = 0x10000
	// Position of ENA17 field.
	GINT_PORT_ENA_ENA17_Pos = 0x11
	// Bit mask of ENA17 field.
	GINT_PORT_ENA_ENA17_Msk = 0x20000
	// Bit ENA17.
	GINT_PORT_ENA_ENA17 = 0x20000
	// Position of ENA18 field.
	GINT_PORT_ENA_ENA18_Pos = 0x12
	// Bit mask of ENA18 field.
	GINT_PORT_ENA_ENA18_Msk = 0x40000
	// Bit ENA18.
	GINT_PORT_ENA_ENA18 = 0x40000
	// Position of ENA19 field.
	GINT_PORT_ENA_ENA19_Pos = 0x13
	// Bit mask of ENA19 field.
	GINT_PORT_ENA_ENA19_Msk = 0x80000
	// Bit ENA19.
	GINT_PORT_ENA_ENA19 = 0x80000
	// Position of ENA20 field.
	GINT_PORT_ENA_ENA20_Pos = 0x14
	// Bit mask of ENA20 field.
	GINT_PORT_ENA_ENA20_Msk = 0x100000
	// Bit ENA20.
	GINT_PORT_ENA_ENA20 = 0x100000
	// Position of ENA21 field.
	GINT_PORT_ENA_ENA21_Pos = 0x15
	// Bit mask of ENA21 field.
	GINT_PORT_ENA_ENA21_Msk = 0x200000
	// Bit ENA21.
	GINT_PORT_ENA_ENA21 = 0x200000
	// Position of ENA22 field.
	GINT_PORT_ENA_ENA22_Pos = 0x16
	// Bit mask of ENA22 field.
	GINT_PORT_ENA_ENA22_Msk = 0x400000
	// Bit ENA22.
	GINT_PORT_ENA_ENA22 = 0x400000
	// Position of ENA23 field.
	GINT_PORT_ENA_ENA23_Pos = 0x17
	// Bit mask of ENA23 field.
	GINT_PORT_ENA_ENA23_Msk = 0x800000
	// Bit ENA23.
	GINT_PORT_ENA_ENA23 = 0x800000
	// Position of ENA24 field.
	GINT_PORT_ENA_ENA24_Pos = 0x18
	// Bit mask of ENA24 field.
	GINT_PORT_ENA_ENA24_Msk = 0x1000000
	// Bit ENA24.
	GINT_PORT_ENA_ENA24 = 0x1000000
	// Position of ENA25 field.
	GINT_PORT_ENA_ENA25_Pos = 0x19
	// Bit mask of ENA25 field.
	GINT_PORT_ENA_ENA25_Msk = 0x2000000
	// Bit ENA25.
	GINT_PORT_ENA_ENA25 = 0x2000000
	// Position of ENA26 field.
	GINT_PORT_ENA_ENA26_Pos = 0x1a
	// Bit mask of ENA26 field.
	GINT_PORT_ENA_ENA26_Msk = 0x4000000
	// Bit ENA26.
	GINT_PORT_ENA_ENA26 = 0x4000000
	// Position of ENA27 field.
	GINT_PORT_ENA_ENA27_Pos = 0x1b
	// Bit mask of ENA27 field.
	GINT_PORT_ENA_ENA27_Msk = 0x8000000
	// Bit ENA27.
	GINT_PORT_ENA_ENA27 = 0x8000000
	// Position of ENA28 field.
	GINT_PORT_ENA_ENA28_Pos = 0x1c
	// Bit mask of ENA28 field.
	GINT_PORT_ENA_ENA28_Msk = 0x10000000
	// Bit ENA28.
	GINT_PORT_ENA_ENA28 = 0x10000000
	// Position of ENA29 field.
	GINT_PORT_ENA_ENA29_Pos = 0x1d
	// Bit mask of ENA29 field.
	GINT_PORT_ENA_ENA29_Msk = 0x20000000
	// Bit ENA29.
	GINT_PORT_ENA_ENA29 = 0x20000000
	// Position of ENA30 field.
	GINT_PORT_ENA_ENA30_Pos = 0x1e
	// Bit mask of ENA30 field.
	GINT_PORT_ENA_ENA30_Msk = 0x40000000
	// Bit ENA30.
	GINT_PORT_ENA_ENA30 = 0x40000000
	// Position of ENA31 field.
	GINT_PORT_ENA_ENA31_Pos = 0x1f
	// Bit mask of ENA31 field.
	GINT_PORT_ENA_ENA31_Msk = 0x80000000
	// Bit ENA31.
	GINT_PORT_ENA_ENA31 = 0x80000000
)

// Bitfields for RIT: Repetitive Interrupt Timer (RIT)
const (
	// COMPVAL: Compare value LSB register. Holds the 32 LSBs of the compare value.
	// Position of RICOMP field.
	RIT_COMPVAL_RICOMP_Pos = 0x0
	// Bit mask of RICOMP field.
	RIT_COMPVAL_RICOMP_Msk = 0xffffffff

	// MASK: Mask LSB register. This register holds the 32 LSB s of the mask value. A 1 written to any bit will force a compare on the corresponding bit of the counter and compare register.
	// Position of RIMASK field.
	RIT_MASK_RIMASK_Pos = 0x0
	// Bit mask of RIMASK field.
	RIT_MASK_RIMASK_Msk = 0xffffffff

	// CTRL: Control register.
	// Position of RITINT field.
	RIT_CTRL_RITINT_Pos = 0x0
	// Bit mask of RITINT field.
	RIT_CTRL_RITINT_Msk = 0x1
	// Bit RITINT.
	RIT_CTRL_RITINT = 0x1
	// This bit is set to 1 by hardware whenever the counter value equals the masked compare value specified by the contents of RICOMPVAL and RIMASK registers. Writing a 1 to this bit will clear it to 0. Writing a 0 has no effect.
	RIT_CTRL_RITINT_THIS_BIT_IS_SET_TO_1 = 0x1
	// The counter value does not equal the masked compare value.
	RIT_CTRL_RITINT_THE_COUNTER_VALUE_DO = 0x0
	// Position of RITENCLR field.
	RIT_CTRL_RITENCLR_Pos = 0x1
	// Bit mask of RITENCLR field.
	RIT_CTRL_RITENCLR_Msk = 0x2
	// Bit RITENCLR.
	RIT_CTRL_RITENCLR = 0x2
	// The timer will be cleared to 0 whenever the counter value equals the masked compare value specified by the contents of COMPVAL/COMPVAL_H and MASK/MASK_H registers. This will occur on the same clock that sets the interrupt flag.
	RIT_CTRL_RITENCLR_THE_TIMER_WILL_BE_CL = 0x1
	// The timer will not be cleared to 0.
	RIT_CTRL_RITENCLR_THE_TIMER_WILL_NOT_B = 0x0
	// Position of RITENBR field.
	RIT_CTRL_RITENBR_Pos = 0x2
	// Bit mask of RITENBR field.
	RIT_CTRL_RITENBR_Msk = 0x4
	// Bit RITENBR.
	RIT_CTRL_RITENBR = 0x4
	// The timer is halted when the processor is halted for debugging.
	RIT_CTRL_RITENBR_THE_TIMER_IS_HALTED = 0x1
	// Debug has no effect on the timer operation.
	RIT_CTRL_RITENBR_DEBUG_HAS_NO_EFFECT = 0x0
	// Position of RITEN field.
	RIT_CTRL_RITEN_Pos = 0x3
	// Bit mask of RITEN field.
	RIT_CTRL_RITEN_Msk = 0x8
	// Bit RITEN.
	RIT_CTRL_RITEN = 0x8
	// Timer enabled. This can be overruled by a debug halt if enabled in bit 2.
	RIT_CTRL_RITEN_TIMER_ENABLED = 0x1
	// Timer disabled.
	RIT_CTRL_RITEN_TIMER_DISABLED = 0x0
	// Position of RESERVED field.
	RIT_CTRL_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	RIT_CTRL_RESERVED_Msk = 0xfffffff0

	// COUNTER: Counter LSB register. 32 LSBs of the counter.
	// Position of RICOUNTER field.
	RIT_COUNTER_RICOUNTER_Pos = 0x0
	// Bit mask of RICOUNTER field.
	RIT_COUNTER_RICOUNTER_Msk = 0xffffffff

	// COMPVAL_H: Compare value MSB register. Holds the 16 MSBs of the compare value.
	// Position of RICOMP field.
	RIT_COMPVAL_H_RICOMP_Pos = 0x0
	// Bit mask of RICOMP field.
	RIT_COMPVAL_H_RICOMP_Msk = 0xffff
	// Position of RESERVED field.
	RIT_COMPVAL_H_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	RIT_COMPVAL_H_RESERVED_Msk = 0xffff0000

	// MASK_H: Mask MSB register. This register holds the 16 MSBs of the mask value. A 1 written to any bit will force a compare on the corresponding bit of the counter and compare register.
	// Position of RIMASK field.
	RIT_MASK_H_RIMASK_Pos = 0x0
	// Bit mask of RIMASK field.
	RIT_MASK_H_RIMASK_Msk = 0xffff
	// Position of RESERVED field.
	RIT_MASK_H_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	RIT_MASK_H_RESERVED_Msk = 0xffff0000

	// COUNTER_H: Counter MSB register. 16 MSBs of the counter.
	// Position of RICOUNTER field.
	RIT_COUNTER_H_RICOUNTER_Pos = 0x0
	// Bit mask of RICOUNTER field.
	RIT_COUNTER_H_RICOUNTER_Msk = 0xffff
	// Position of RESERVED field.
	RIT_COUNTER_H_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	RIT_COUNTER_H_RESERVED_Msk = 0xffff0000
)

// Bitfields for SCTIPU: SCT Input Processing Unit (IPU)
const (
	// SAMPLE_CTRL: SCT IPU sample control register. Contains the input mux selects, latch/sample-enable mux selects, and sample overrride bits for the SAMPLE module.
	// Position of IN0SEL field.
	SCTIPU_SAMPLE_CTRL_IN0SEL_Pos = 0x0
	// Bit mask of IN0SEL field.
	SCTIPU_SAMPLE_CTRL_IN0SEL_Msk = 0x1
	// Bit IN0SEL.
	SCTIPU_SAMPLE_CTRL_IN0SEL = 0x1
	// SAMPE_IN_A0. Select input SAMPLE_IN_A0.
	SCTIPU_SAMPLE_CTRL_IN0SEL_SAMPE_IN_A0_SELECT_ = 0x0
	// SAMPE_IN_B0. Select input SAMPLE_IN_B0.
	SCTIPU_SAMPLE_CTRL_IN0SEL_SAMPE_IN_B0_SELECT_ = 0x1
	// Position of IN1SEL field.
	SCTIPU_SAMPLE_CTRL_IN1SEL_Pos = 0x1
	// Bit mask of IN1SEL field.
	SCTIPU_SAMPLE_CTRL_IN1SEL_Msk = 0x2
	// Bit IN1SEL.
	SCTIPU_SAMPLE_CTRL_IN1SEL = 0x2
	// SAMPE_IN_A1. Select input SAMPLE_IN_A1.
	SCTIPU_SAMPLE_CTRL_IN1SEL_SAMPE_IN_A1_SELECT_ = 0x0
	// SAMPE_IN_B1. Select input SAMPLE_IN_B1.
	SCTIPU_SAMPLE_CTRL_IN1SEL_SAMPE_IN_B1_SELECT_ = 0x1
	// Position of IN2SEL field.
	SCTIPU_SAMPLE_CTRL_IN2SEL_Pos = 0x2
	// Bit mask of IN2SEL field.
	SCTIPU_SAMPLE_CTRL_IN2SEL_Msk = 0x4
	// Bit IN2SEL.
	SCTIPU_SAMPLE_CTRL_IN2SEL = 0x4
	// SAMPE_IN_A2. Select input SAMPLE_IN_A2.
	SCTIPU_SAMPLE_CTRL_IN2SEL_SAMPE_IN_A2_SELECT_ = 0x0
	// SAMPE_IN_B2. Select input SAMPLE_IN_B2.
	SCTIPU_SAMPLE_CTRL_IN2SEL_SAMPE_IN_B2_SELECT_ = 0x1
	// Position of IN3SEL field.
	SCTIPU_SAMPLE_CTRL_IN3SEL_Pos = 0x3
	// Bit mask of IN3SEL field.
	SCTIPU_SAMPLE_CTRL_IN3SEL_Msk = 0x8
	// Bit IN3SEL.
	SCTIPU_SAMPLE_CTRL_IN3SEL = 0x8
	// SAMPE_IN_A3. Select input SAMPLE_IN_A3.
	SCTIPU_SAMPLE_CTRL_IN3SEL_SAMPE_IN_A3_SELECT_ = 0x0
	// SAMPE_IN_B3. Select input SAMPLE_IN_B3.
	SCTIPU_SAMPLE_CTRL_IN3SEL_SAMPE_IN_B3_SELECT_ = 0x1
	// Position of SAMPLE_EN0SEL field.
	SCTIPU_SAMPLE_CTRL_SAMPLE_EN0SEL_Pos = 0x4
	// Bit mask of SAMPLE_EN0SEL field.
	SCTIPU_SAMPLE_CTRL_SAMPLE_EN0SEL_Msk = 0x30
	// Position of SAMPLE_EN1SEL field.
	SCTIPU_SAMPLE_CTRL_SAMPLE_EN1SEL_Pos = 0x6
	// Bit mask of SAMPLE_EN1SEL field.
	SCTIPU_SAMPLE_CTRL_SAMPLE_EN1SEL_Msk = 0xc0
	// Position of SAMPLE_EN2SEL field.
	SCTIPU_SAMPLE_CTRL_SAMPLE_EN2SEL_Pos = 0x8
	// Bit mask of SAMPLE_EN2SEL field.
	SCTIPU_SAMPLE_CTRL_SAMPLE_EN2SEL_Msk = 0x300
	// Position of SAMPLE_EN3SEL field.
	SCTIPU_SAMPLE_CTRL_SAMPLE_EN3SEL_Pos = 0xa
	// Bit mask of SAMPLE_EN3SEL field.
	SCTIPU_SAMPLE_CTRL_SAMPLE_EN3SEL_Msk = 0xc00
	// Position of LATCHEN0 field.
	SCTIPU_SAMPLE_CTRL_LATCHEN0_Pos = 0xc
	// Bit mask of LATCHEN0 field.
	SCTIPU_SAMPLE_CTRL_LATCHEN0_Msk = 0x1000
	// Bit LATCHEN0.
	SCTIPU_SAMPLE_CTRL_LATCHEN0 = 0x1000
	// Transparent mode. Sample_Output(0) latch is forced into transparent mode. The selected Sample_Input is passed directly through to Sample_Output(0). The sample-enable control line selected for this latch has no effect.
	SCTIPU_SAMPLE_CTRL_LATCHEN0_TRANSPARENT_MODE_SA = 0x0
	// Latched mode. The Sample_Output(0) latch is operational and will sample or latch based on the state of the selected sample-enable control signal.
	SCTIPU_SAMPLE_CTRL_LATCHEN0_LATCHED_MODE_THE_SA = 0x1
	// Position of LATCHEN1 field.
	SCTIPU_SAMPLE_CTRL_LATCHEN1_Pos = 0xd
	// Bit mask of LATCHEN1 field.
	SCTIPU_SAMPLE_CTRL_LATCHEN1_Msk = 0x2000
	// Bit LATCHEN1.
	SCTIPU_SAMPLE_CTRL_LATCHEN1 = 0x2000
	// Transparent mode. Sample_Output(1) latch is forced into transparent mode. The selected Sample_Input is passed directly through to Sample_Output(1). The sample-enable control line selected for this latch has no effect.
	SCTIPU_SAMPLE_CTRL_LATCHEN1_TRANSPARENT_MODE_SA = 0x0
	// Latched mode. The Sample_Output(1) latch is operational and will sample or latch based on the state of the selected sample-enable control signal.
	SCTIPU_SAMPLE_CTRL_LATCHEN1_LATCHED_MODE_THE_SA = 0x1
	// Position of LATCHEN2 field.
	SCTIPU_SAMPLE_CTRL_LATCHEN2_Pos = 0xe
	// Bit mask of LATCHEN2 field.
	SCTIPU_SAMPLE_CTRL_LATCHEN2_Msk = 0x4000
	// Bit LATCHEN2.
	SCTIPU_SAMPLE_CTRL_LATCHEN2 = 0x4000
	// Transparent mode. Sample_Output(2) latch is forced into transparent mode. The selected Sample_Input is passed directly through to Sample_Output(2). The sample-enable control line selected for this latch has no effect.
	SCTIPU_SAMPLE_CTRL_LATCHEN2_TRANSPARENT_MODE_SA = 0x0
	// Latched mode. The Sample_Output(2) latch is operational and will sample or latch based on the state of the selected sample-enable control signal.
	SCTIPU_SAMPLE_CTRL_LATCHEN2_LATCHED_MODE_THE_SA = 0x1
	// Position of LATCHEN3 field.
	SCTIPU_SAMPLE_CTRL_LATCHEN3_Pos = 0xf
	// Bit mask of LATCHEN3 field.
	SCTIPU_SAMPLE_CTRL_LATCHEN3_Msk = 0x8000
	// Bit LATCHEN3.
	SCTIPU_SAMPLE_CTRL_LATCHEN3 = 0x8000
	// Transparent mode. Sample_Output(3) latch is forced into transparent mode. The selected Sample_Input is passed directly through to Sample_Output(3). The sample-enable control line selected for this latch has no effect.
	SCTIPU_SAMPLE_CTRL_LATCHEN3_TRANSPARENT_MODE_SA = 0x0
	// Latched mode. The Sample_Output(3) latch is operational and will sample or latch based on the state of the selected sample-enable control signal.
	SCTIPU_SAMPLE_CTRL_LATCHEN3_LATCHED_MODE_THE_SA = 0x1

	// ABORT_ENABLE0: SCT IPU abort enable register: Selects which input source contributes to ORed Abort Output 0.
	// Position of ENA0 field.
	SCTIPU_ABORT_ENABLE_ENA0_Pos = 0x0
	// Bit mask of ENA0 field.
	SCTIPU_ABORT_ENABLE_ENA0_Msk = 0x1
	// Bit ENA0.
	SCTIPU_ABORT_ENABLE_ENA0 = 0x1
	// Disabled.
	SCTIPU_ABORT_ENABLE_ENA0_DISABLED_ = 0x0
	// Enabled.
	SCTIPU_ABORT_ENABLE_ENA0_ENABLED_ = 0x1
	// Position of ENA1 field.
	SCTIPU_ABORT_ENABLE_ENA1_Pos = 0x1
	// Bit mask of ENA1 field.
	SCTIPU_ABORT_ENABLE_ENA1_Msk = 0x2
	// Bit ENA1.
	SCTIPU_ABORT_ENABLE_ENA1 = 0x2
	// Disabled.
	SCTIPU_ABORT_ENABLE_ENA1_DISABLED_ = 0x0
	// Enabled.
	SCTIPU_ABORT_ENABLE_ENA1_ENABLED_ = 0x1
	// Position of ENA2 field.
	SCTIPU_ABORT_ENABLE_ENA2_Pos = 0x2
	// Bit mask of ENA2 field.
	SCTIPU_ABORT_ENABLE_ENA2_Msk = 0x4
	// Bit ENA2.
	SCTIPU_ABORT_ENABLE_ENA2 = 0x4
	// Disabled.
	SCTIPU_ABORT_ENABLE_ENA2_DISABLED_ = 0x0
	// Enabled.
	SCTIPU_ABORT_ENABLE_ENA2_ENABLED_ = 0x1
	// Position of ENA3 field.
	SCTIPU_ABORT_ENABLE_ENA3_Pos = 0x3
	// Bit mask of ENA3 field.
	SCTIPU_ABORT_ENABLE_ENA3_Msk = 0x8
	// Bit ENA3.
	SCTIPU_ABORT_ENABLE_ENA3 = 0x8
	// Disabled.
	SCTIPU_ABORT_ENABLE_ENA3_DISABLED_ = 0x0
	// Enabled.
	SCTIPU_ABORT_ENABLE_ENA3_ENABLED_ = 0x1
	// Position of ENA4 field.
	SCTIPU_ABORT_ENABLE_ENA4_Pos = 0x4
	// Bit mask of ENA4 field.
	SCTIPU_ABORT_ENABLE_ENA4_Msk = 0x10
	// Bit ENA4.
	SCTIPU_ABORT_ENABLE_ENA4 = 0x10
	// Disabled.
	SCTIPU_ABORT_ENABLE_ENA4_DISABLED_ = 0x0
	// Enabled.
	SCTIPU_ABORT_ENABLE_ENA4_ENABLED_ = 0x1
	// Position of ENA5 field.
	SCTIPU_ABORT_ENABLE_ENA5_Pos = 0x5
	// Bit mask of ENA5 field.
	SCTIPU_ABORT_ENABLE_ENA5_Msk = 0x20
	// Bit ENA5.
	SCTIPU_ABORT_ENABLE_ENA5 = 0x20
	// Disabled.
	SCTIPU_ABORT_ENABLE_ENA5_DISABLED_ = 0x0
	// Enabled.
	SCTIPU_ABORT_ENABLE_ENA5_ENABLED_ = 0x1
	// Position of ENA6 field.
	SCTIPU_ABORT_ENABLE_ENA6_Pos = 0x6
	// Bit mask of ENA6 field.
	SCTIPU_ABORT_ENABLE_ENA6_Msk = 0x40
	// Bit ENA6.
	SCTIPU_ABORT_ENABLE_ENA6 = 0x40
	// Disabled.
	SCTIPU_ABORT_ENABLE_ENA6_DISABLED_ = 0x0
	// Enabled.
	SCTIPU_ABORT_ENABLE_ENA6_ENABLED_ = 0x1
	// Position of ENA7 field.
	SCTIPU_ABORT_ENABLE_ENA7_Pos = 0x7
	// Bit mask of ENA7 field.
	SCTIPU_ABORT_ENABLE_ENA7_Msk = 0x80
	// Bit ENA7.
	SCTIPU_ABORT_ENABLE_ENA7 = 0x80
	// Disabled.
	SCTIPU_ABORT_ENABLE_ENA7_DISABLED_ = 0x0
	// Enabled.
	SCTIPU_ABORT_ENABLE_ENA7_ENABLED_ = 0x1
	// Position of ENA8 field.
	SCTIPU_ABORT_ENABLE_ENA8_Pos = 0x8
	// Bit mask of ENA8 field.
	SCTIPU_ABORT_ENABLE_ENA8_Msk = 0x100
	// Bit ENA8.
	SCTIPU_ABORT_ENABLE_ENA8 = 0x100
	// Disabled.
	SCTIPU_ABORT_ENABLE_ENA8_DISABLED_ = 0x0
	// Enabled.
	SCTIPU_ABORT_ENABLE_ENA8_ENABLED_ = 0x1

	// ABORT_SOURCE0: SCT IPU abort source register: Status register indicating which input source caused abort output 0.
	// Position of ACT0 field.
	SCTIPU_ABORT_SOURCE_ACT0_Pos = 0x0
	// Bit mask of ACT0 field.
	SCTIPU_ABORT_SOURCE_ACT0_Msk = 0x1
	// Bit ACT0.
	SCTIPU_ABORT_SOURCE_ACT0 = 0x1
	// Not activated.
	SCTIPU_ABORT_SOURCE_ACT0_NOT_ACTIVATED_ = 0x0
	// Activated.
	SCTIPU_ABORT_SOURCE_ACT0_ACTIVATED_ = 0x1
	// Position of ACT1 field.
	SCTIPU_ABORT_SOURCE_ACT1_Pos = 0x1
	// Bit mask of ACT1 field.
	SCTIPU_ABORT_SOURCE_ACT1_Msk = 0x2
	// Bit ACT1.
	SCTIPU_ABORT_SOURCE_ACT1 = 0x2
	// Not activated.
	SCTIPU_ABORT_SOURCE_ACT1_NOT_ACTIVATED_ = 0x0
	// Activated.
	SCTIPU_ABORT_SOURCE_ACT1_ACTIVATED_ = 0x1
	// Position of ACT2 field.
	SCTIPU_ABORT_SOURCE_ACT2_Pos = 0x2
	// Bit mask of ACT2 field.
	SCTIPU_ABORT_SOURCE_ACT2_Msk = 0x4
	// Bit ACT2.
	SCTIPU_ABORT_SOURCE_ACT2 = 0x4
	// Not activated.
	SCTIPU_ABORT_SOURCE_ACT2_NOT_ACTIVATED_ = 0x0
	// Activated.
	SCTIPU_ABORT_SOURCE_ACT2_ACTIVATED_ = 0x1
	// Position of ACT3 field.
	SCTIPU_ABORT_SOURCE_ACT3_Pos = 0x3
	// Bit mask of ACT3 field.
	SCTIPU_ABORT_SOURCE_ACT3_Msk = 0x8
	// Bit ACT3.
	SCTIPU_ABORT_SOURCE_ACT3 = 0x8
	// Not activated.
	SCTIPU_ABORT_SOURCE_ACT3_NOT_ACTIVATED_ = 0x0
	// Activated.
	SCTIPU_ABORT_SOURCE_ACT3_ACTIVATED_ = 0x1
	// Position of ACT4 field.
	SCTIPU_ABORT_SOURCE_ACT4_Pos = 0x4
	// Bit mask of ACT4 field.
	SCTIPU_ABORT_SOURCE_ACT4_Msk = 0x10
	// Bit ACT4.
	SCTIPU_ABORT_SOURCE_ACT4 = 0x10
	// Not activated.
	SCTIPU_ABORT_SOURCE_ACT4_NOT_ACTIVATED_ = 0x0
	// Activated.
	SCTIPU_ABORT_SOURCE_ACT4_ACTIVATED_ = 0x1
	// Position of ACT5 field.
	SCTIPU_ABORT_SOURCE_ACT5_Pos = 0x5
	// Bit mask of ACT5 field.
	SCTIPU_ABORT_SOURCE_ACT5_Msk = 0x20
	// Bit ACT5.
	SCTIPU_ABORT_SOURCE_ACT5 = 0x20
	// Not activated.
	SCTIPU_ABORT_SOURCE_ACT5_NOT_ACTIVATED_ = 0x0
	// Activated.
	SCTIPU_ABORT_SOURCE_ACT5_ACTIVATED_ = 0x1
	// Position of ACT6 field.
	SCTIPU_ABORT_SOURCE_ACT6_Pos = 0x6
	// Bit mask of ACT6 field.
	SCTIPU_ABORT_SOURCE_ACT6_Msk = 0x40
	// Bit ACT6.
	SCTIPU_ABORT_SOURCE_ACT6 = 0x40
	// Not activated.
	SCTIPU_ABORT_SOURCE_ACT6_NOT_ACTIVATED_ = 0x0
	// Activated.
	SCTIPU_ABORT_SOURCE_ACT6_ACTIVATED_ = 0x1
	// Position of ACT7 field.
	SCTIPU_ABORT_SOURCE_ACT7_Pos = 0x7
	// Bit mask of ACT7 field.
	SCTIPU_ABORT_SOURCE_ACT7_Msk = 0x80
	// Bit ACT7.
	SCTIPU_ABORT_SOURCE_ACT7 = 0x80
	// Not activated.
	SCTIPU_ABORT_SOURCE_ACT7_NOT_ACTIVATED_ = 0x0
	// Activated.
	SCTIPU_ABORT_SOURCE_ACT7_ACTIVATED_ = 0x1
	// Position of ACT8 field.
	SCTIPU_ABORT_SOURCE_ACT8_Pos = 0x8
	// Bit mask of ACT8 field.
	SCTIPU_ABORT_SOURCE_ACT8_Msk = 0x100
	// Bit ACT8.
	SCTIPU_ABORT_SOURCE_ACT8 = 0x100
	// Not activated.
	SCTIPU_ABORT_SOURCE_ACT8_NOT_ACTIVATED_ = 0x0
	// Activated.
	SCTIPU_ABORT_SOURCE_ACT8_ACTIVATED_ = 0x1
)

// Bitfields for FLASHCTRL: Flash controller
const (
	// FMSSTART: Signature start address register
	// Position of START field.
	FLASHCTRL_FMSSTART_START_Pos = 0x0
	// Bit mask of START field.
	FLASHCTRL_FMSSTART_START_Msk = 0x1ffff
	// Position of RESERVED field.
	FLASHCTRL_FMSSTART_RESERVED_Pos = 0x11
	// Bit mask of RESERVED field.
	FLASHCTRL_FMSSTART_RESERVED_Msk = 0xfffe0000

	// FMSSTOP: Signature stop-address register
	// Position of STOPA field.
	FLASHCTRL_FMSSTOP_STOPA_Pos = 0x0
	// Bit mask of STOPA field.
	FLASHCTRL_FMSSTOP_STOPA_Msk = 0x1ffff
	// Position of RESERVED field.
	FLASHCTRL_FMSSTOP_RESERVED_Pos = 0x11
	// Bit mask of RESERVED field.
	FLASHCTRL_FMSSTOP_RESERVED_Msk = 0x7ffe0000
	// Position of STRTBIST field.
	FLASHCTRL_FMSSTOP_STRTBIST_Pos = 0x1f
	// Bit mask of STRTBIST field.
	FLASHCTRL_FMSSTOP_STRTBIST_Msk = 0x80000000
	// Bit STRTBIST.
	FLASHCTRL_FMSSTOP_STRTBIST = 0x80000000

	// FMSW0: Signature word
	// Position of SIG field.
	FLASHCTRL_FMSW0_SIG_Pos = 0x0
	// Bit mask of SIG field.
	FLASHCTRL_FMSW0_SIG_Msk = 0xffffffff
)

// Bitfields for C_CAN0: Controller Area Network C_CAN0
const (
	// CNTL: CAN control
	// Position of INIT field.
	C_CAN0_CNTL_INIT_Pos = 0x0
	// Bit mask of INIT field.
	C_CAN0_CNTL_INIT_Msk = 0x1
	// Bit INIT.
	C_CAN0_CNTL_INIT = 0x1
	// Normal operation.
	C_CAN0_CNTL_INIT_NORMAL_OPERATION = 0x0
	// Started. Initialization is started. On reset, software needs to initialize the CAN controller.
	C_CAN0_CNTL_INIT_STARTED = 0x1
	// Position of IE field.
	C_CAN0_CNTL_IE_Pos = 0x1
	// Bit mask of IE field.
	C_CAN0_CNTL_IE_Msk = 0x2
	// Bit IE.
	C_CAN0_CNTL_IE = 0x2
	// Disable CAN interrupts. The interrupt line is always HIGH.
	C_CAN0_CNTL_IE_DISABLE_CAN_INTERRUP = 0x0
	// Enable CAN interrupts. The interrupt line is set to LOW and remains LOW until all pending interrupts are cleared.
	C_CAN0_CNTL_IE_ENABLE_CAN_INTERRUPT = 0x1
	// Position of SIE field.
	C_CAN0_CNTL_SIE_Pos = 0x2
	// Bit mask of SIE field.
	C_CAN0_CNTL_SIE_Msk = 0x4
	// Bit SIE.
	C_CAN0_CNTL_SIE = 0x4
	// Disable status change interrupts. No status change interrupt will be generated.
	C_CAN0_CNTL_SIE_DISABLE_STATUS_CHANG = 0x0
	// Enable status change interrupts. A status change interrupt will be generated when a message transfer is successfully completed or a CAN bus error is detected.
	C_CAN0_CNTL_SIE_ENABLE_STATUS_CHANGE = 0x1
	// Position of EIE field.
	C_CAN0_CNTL_EIE_Pos = 0x3
	// Bit mask of EIE field.
	C_CAN0_CNTL_EIE_Msk = 0x8
	// Bit EIE.
	C_CAN0_CNTL_EIE = 0x8
	// Disable error interrupt. No error status interrupt will be generated.
	C_CAN0_CNTL_EIE_DISABLE_ERROR_INTERR = 0x0
	// Enable error interrupt. A change in the bits BOFF or EWARN in the CANSTAT registers will generate an interrupt.
	C_CAN0_CNTL_EIE_ENABLE_ERROR_INTERRU = 0x1
	// Position of RESERVED field.
	C_CAN0_CNTL_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	C_CAN0_CNTL_RESERVED_Msk = 0x10
	// Bit RESERVED.
	C_CAN0_CNTL_RESERVED = 0x10
	// Position of DAR field.
	C_CAN0_CNTL_DAR_Pos = 0x5
	// Bit mask of DAR field.
	C_CAN0_CNTL_DAR_Msk = 0x20
	// Bit DAR.
	C_CAN0_CNTL_DAR = 0x20
	// Enabled. Automatic retransmission of disturbed messages enabled.
	C_CAN0_CNTL_DAR_ENABLED = 0x0
	// Disabled. Automatic retransmission disabled.
	C_CAN0_CNTL_DAR_DISABLED = 0x1
	// Position of CCE field.
	C_CAN0_CNTL_CCE_Pos = 0x6
	// Bit mask of CCE field.
	C_CAN0_CNTL_CCE_Msk = 0x40
	// Bit CCE.
	C_CAN0_CNTL_CCE = 0x40
	// No write access. The CPU has no write access to the bit timing register.
	C_CAN0_CNTL_CCE_NO_WRITE_ACCESS = 0x0
	// Write access. The CPU has write access to the CANBT register while the INIT bit is one.
	C_CAN0_CNTL_CCE_WRITE_ACCESS = 0x1
	// Position of TEST field.
	C_CAN0_CNTL_TEST_Pos = 0x7
	// Bit mask of TEST field.
	C_CAN0_CNTL_TEST_Msk = 0x80
	// Bit TEST.
	C_CAN0_CNTL_TEST = 0x80
	// Normal operation.
	C_CAN0_CNTL_TEST_NORMAL_OPERATION = 0x0
	// Test mode.
	C_CAN0_CNTL_TEST_TEST_MODE = 0x1
	// Position of RESERVED field.
	C_CAN0_CNTL_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	C_CAN0_CNTL_RESERVED_Msk = 0xffffff00

	// STAT: Status register
	// Position of LEC field.
	C_CAN0_STAT_LEC_Pos = 0x0
	// Bit mask of LEC field.
	C_CAN0_STAT_LEC_Msk = 0x7
	// No error.
	C_CAN0_STAT_LEC_NO_ERROR = 0x0
	// Stuff error. More than 5 equal bits in a sequence have occurred in a part of a received message where this is not allowed.
	C_CAN0_STAT_LEC_STUFF_ERROR = 0x1
	// Form error. A fixed format part of a received frame has the wrong format.
	C_CAN0_STAT_LEC_FORM_ERROR = 0x2
	// AckError. The message this CAN core transmitted was not acknowledged.
	C_CAN0_STAT_LEC_ACKERROR = 0x3
	// Bit1Error. During the transmission of a message (with the exception of the arbitration field), the device wanted to send a HIGH/recessive level (bit of logical value 1), but the monitored bus value was LOW/dominant.
	C_CAN0_STAT_LEC_BIT1ERROR = 0x4
	// Bit0Error. During the transmission of a message (or acknowledge bit, or active error flag, or overload flag), the device wanted to send a LOW/dominant level (data or identifier bit logical value 0), but the monitored Bus value was HIGH/recessive. During busoff recovery this status is set each time a sequence of 11 HIGH/recessive bits has been monitored. This enables the CPU to monitor the proceeding of the busoff recovery sequence (indicating the bus is not stuck at LOW/dominant or continuously disturbed).
	C_CAN0_STAT_LEC_BIT0ERROR = 0x5
	// CRCError. The CRC checksum was incorrect in the message received.
	C_CAN0_STAT_LEC_CRCERROR = 0x6
	// Unused. No CAN bus event was detected (written by the CPU).
	C_CAN0_STAT_LEC_UNUSED = 0x7
	// Position of TXOK field.
	C_CAN0_STAT_TXOK_Pos = 0x3
	// Bit mask of TXOK field.
	C_CAN0_STAT_TXOK_Msk = 0x8
	// Bit TXOK.
	C_CAN0_STAT_TXOK = 0x8
	// No transmit. Since this bit was last reset by the CPU, no message has been successfully transmitted.
	C_CAN0_STAT_TXOK_NO_TRANSMIT = 0x0
	// Successful transmit. Since this bit was last reset by the CPU, a message has been successfully transmitted (error free and acknowledged by at least one other node).
	C_CAN0_STAT_TXOK_SUCCESSFUL_TRANSMIT = 0x1
	// Position of RXOK field.
	C_CAN0_STAT_RXOK_Pos = 0x4
	// Bit mask of RXOK field.
	C_CAN0_STAT_RXOK_Msk = 0x10
	// Bit RXOK.
	C_CAN0_STAT_RXOK = 0x10
	// No receive. Since this bit was last reset by the CPU, no message has been successfully received.
	C_CAN0_STAT_RXOK_NO_RECEIVE = 0x0
	// Successful receive.Since this bit was last set to zero by the CPU, a message has been successfully received independent of the result of acceptance filtering.
	C_CAN0_STAT_RXOK_SUCCESSFUL_RECEIVE = 0x1
	// Position of EPASS field.
	C_CAN0_STAT_EPASS_Pos = 0x5
	// Bit mask of EPASS field.
	C_CAN0_STAT_EPASS_Msk = 0x20
	// Bit EPASS.
	C_CAN0_STAT_EPASS = 0x20
	// Active. The CAN controller is in the error active state.
	C_CAN0_STAT_EPASS_ACTIVE = 0x0
	// Passive. The CAN controller is in the error passive state as defined in the CAN 2.0 specification.
	C_CAN0_STAT_EPASS_PASSIVE = 0x1
	// Position of EWARN field.
	C_CAN0_STAT_EWARN_Pos = 0x6
	// Bit mask of EWARN field.
	C_CAN0_STAT_EWARN_Msk = 0x40
	// Bit EWARN.
	C_CAN0_STAT_EWARN = 0x40
	// Below limit. Both error counters are below the error warning limit of 96.
	C_CAN0_STAT_EWARN_BELOW_LIMIT = 0x0
	// At limit. At least one of the error counters in the EC has reached the error warning limit of 96.
	C_CAN0_STAT_EWARN_AT_LIMIT = 0x1
	// Position of BOFF field.
	C_CAN0_STAT_BOFF_Pos = 0x7
	// Bit mask of BOFF field.
	C_CAN0_STAT_BOFF_Msk = 0x80
	// Bit BOFF.
	C_CAN0_STAT_BOFF = 0x80
	// The CAN module is not in busoff.
	C_CAN0_STAT_BOFF_THE_CAN_MODULE_IS_NO = 0x0
	// The CAN controller is in busoff state.
	C_CAN0_STAT_BOFF_THE_CAN_CONTROLLER_I = 0x1
	// Position of RESERVED field.
	C_CAN0_STAT_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	C_CAN0_STAT_RESERVED_Msk = 0xffffff00

	// EC: Error counter
	// Position of TEC7_0 field.
	C_CAN0_EC_TEC7_0_Pos = 0x0
	// Bit mask of TEC7_0 field.
	C_CAN0_EC_TEC7_0_Msk = 0xff
	// Position of REC6_0 field.
	C_CAN0_EC_REC6_0_Pos = 0x8
	// Bit mask of REC6_0 field.
	C_CAN0_EC_REC6_0_Msk = 0x7f00
	// Position of RP field.
	C_CAN0_EC_RP_Pos = 0xf
	// Bit mask of RP field.
	C_CAN0_EC_RP_Msk = 0x8000
	// Bit RP.
	C_CAN0_EC_RP = 0x8000
	// Below error level. The receive counter is below the error passive level.
	C_CAN0_EC_RP_BELOW_ERROR_LEVEL = 0x0
	// At error level. The receive counter has reached the error passive level as defined in the CAN2.0 specification.
	C_CAN0_EC_RP_AT_ERROR_LEVEL = 0x1
	// Position of RESERVED field.
	C_CAN0_EC_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	C_CAN0_EC_RESERVED_Msk = 0xffff0000

	// BT: Bit timing register
	// Position of BRP field.
	C_CAN0_BT_BRP_Pos = 0x0
	// Bit mask of BRP field.
	C_CAN0_BT_BRP_Msk = 0x3f
	// Position of SJW field.
	C_CAN0_BT_SJW_Pos = 0x6
	// Bit mask of SJW field.
	C_CAN0_BT_SJW_Msk = 0xc0
	// Position of TSEG1 field.
	C_CAN0_BT_TSEG1_Pos = 0x8
	// Bit mask of TSEG1 field.
	C_CAN0_BT_TSEG1_Msk = 0xf00
	// Position of TSEG2 field.
	C_CAN0_BT_TSEG2_Pos = 0xc
	// Bit mask of TSEG2 field.
	C_CAN0_BT_TSEG2_Msk = 0x7000
	// Position of RESERVED field.
	C_CAN0_BT_RESERVED_Pos = 0xf
	// Bit mask of RESERVED field.
	C_CAN0_BT_RESERVED_Msk = 0xffff8000

	// INT: Interrupt register
	// Position of INTID field.
	C_CAN0_INT_INTID_Pos = 0x0
	// Bit mask of INTID field.
	C_CAN0_INT_INTID_Msk = 0xffff
	// Position of RESERVED field.
	C_CAN0_INT_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	C_CAN0_INT_RESERVED_Msk = 0xffff0000

	// TEST: Test register
	// Position of RESERVED field.
	C_CAN0_TEST_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	C_CAN0_TEST_RESERVED_Msk = 0x3
	// Position of BASIC field.
	C_CAN0_TEST_BASIC_Pos = 0x2
	// Bit mask of BASIC field.
	C_CAN0_TEST_BASIC_Msk = 0x4
	// Bit BASIC.
	C_CAN0_TEST_BASIC = 0x4
	// Disabled. Basic mode disabled.
	C_CAN0_TEST_BASIC_DISABLED = 0x0
	// Enabled. IF1 registers used as TX buffer, IF2 registers used as RX buffer.
	C_CAN0_TEST_BASIC_ENABLED = 0x1
	// Position of SILENT field.
	C_CAN0_TEST_SILENT_Pos = 0x3
	// Bit mask of SILENT field.
	C_CAN0_TEST_SILENT_Msk = 0x8
	// Bit SILENT.
	C_CAN0_TEST_SILENT = 0x8
	// Normal operation.
	C_CAN0_TEST_SILENT_NORMAL_OPERATION = 0x0
	// Silent mode. The module is in silent mode.
	C_CAN0_TEST_SILENT_SILENT_MODE = 0x1
	// Position of LBACK field.
	C_CAN0_TEST_LBACK_Pos = 0x4
	// Bit mask of LBACK field.
	C_CAN0_TEST_LBACK_Msk = 0x10
	// Bit LBACK.
	C_CAN0_TEST_LBACK = 0x10
	// Disabled. Loop back mode is disabled.
	C_CAN0_TEST_LBACK_DISABLED = 0x0
	// Enabled. Loop back mode is enabled.
	C_CAN0_TEST_LBACK_ENABLED = 0x1
	// Position of TX field.
	C_CAN0_TEST_TX_Pos = 0x5
	// Bit mask of TX field.
	C_CAN0_TEST_TX_Msk = 0x60
	// Controller. Level at the CAN_TXD pin is controlled by the CAN controller. This is the value at reset.
	C_CAN0_TEST_TX_CONTROLLER = 0x0
	// Sample point. The sample point can be monitored at the CAN_TXD pin.
	C_CAN0_TEST_TX_SAMPLE_POINT = 0x1
	// Low. CAN_TXD pin is driven LOW/dominant.
	C_CAN0_TEST_TX_LOW = 0x2
	// Hogh. CAN_TXD pin is driven HIGH/recessive.
	C_CAN0_TEST_TX_HOGH = 0x3
	// Position of RX field.
	C_CAN0_TEST_RX_Pos = 0x7
	// Bit mask of RX field.
	C_CAN0_TEST_RX_Msk = 0x80
	// Bit RX.
	C_CAN0_TEST_RX = 0x80
	// Recessive. The CAN bus is recessive (CAN_RXD = 1).
	C_CAN0_TEST_RX_RECESSIVE = 0x0
	// Dominant. The CAN bus is dominant (CAN_RXD = 0).
	C_CAN0_TEST_RX_DOMINANT = 0x1
	// Position of RESERVED field.
	C_CAN0_TEST_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	C_CAN0_TEST_RESERVED_Msk = 0xffffff00

	// BRPE: Baud rate prescaler extension register
	// Position of BRPE field.
	C_CAN0_BRPE_BRPE_Pos = 0x0
	// Bit mask of BRPE field.
	C_CAN0_BRPE_BRPE_Msk = 0xf
	// Position of RESERVED field.
	C_CAN0_BRPE_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	C_CAN0_BRPE_RESERVED_Msk = 0xfffffff0

	// IF1_CMDREQ: Message interface command request
	// Position of MN field.
	C_CAN0_IF_CMDREQ_MN_Pos = 0x0
	// Bit mask of MN field.
	C_CAN0_IF_CMDREQ_MN_Msk = 0x3f
	// Position of RESERVED field.
	C_CAN0_IF_CMDREQ_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	C_CAN0_IF_CMDREQ_RESERVED_Msk = 0x7fc0
	// Position of BUSY field.
	C_CAN0_IF_CMDREQ_BUSY_Pos = 0xf
	// Bit mask of BUSY field.
	C_CAN0_IF_CMDREQ_BUSY_Msk = 0x8000
	// Bit BUSY.
	C_CAN0_IF_CMDREQ_BUSY = 0x8000
	// Done. Set to zero by hardware when read/write action to this Command request register has finished.
	C_CAN0_IF_CMDREQ_BUSY_DONE = 0x0
	// Busy. Set to one by hardware when writing to this Command request register.
	C_CAN0_IF_CMDREQ_BUSY_BUSY = 0x1
	// Position of RESERVED field.
	C_CAN0_IF_CMDREQ_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	C_CAN0_IF_CMDREQ_RESERVED_Msk = 0xffff0000

	// IF1_CMDMSK_W: Message interface command mask (write direction)
	// Position of DATA_B field.
	C_CAN0_IF_CMDMSK_W_DATA_B_Pos = 0x0
	// Bit mask of DATA_B field.
	C_CAN0_IF_CMDMSK_W_DATA_B_Msk = 0x1
	// Bit DATA_B.
	C_CAN0_IF_CMDMSK_W_DATA_B = 0x1
	// Unchanged. Data bytes 4-7 unchanged.
	C_CAN0_IF_CMDMSK_W_DATA_B_UNCHANGED = 0x0
	// Transfer. Transfer data bytes 4-7 to message object.
	C_CAN0_IF_CMDMSK_W_DATA_B_TRANSFER = 0x1
	// Position of DATA_A field.
	C_CAN0_IF_CMDMSK_W_DATA_A_Pos = 0x1
	// Bit mask of DATA_A field.
	C_CAN0_IF_CMDMSK_W_DATA_A_Msk = 0x2
	// Bit DATA_A.
	C_CAN0_IF_CMDMSK_W_DATA_A = 0x2
	// Unchanged. Data bytes 0-3 unchanged.
	C_CAN0_IF_CMDMSK_W_DATA_A_UNCHANGED = 0x0
	// Transfer. Transfer data bytes 0-3 to message object.
	C_CAN0_IF_CMDMSK_W_DATA_A_TRANSFER = 0x1
	// Position of TXRQST field.
	C_CAN0_IF_CMDMSK_W_TXRQST_Pos = 0x2
	// Bit mask of TXRQST field.
	C_CAN0_IF_CMDMSK_W_TXRQST_Msk = 0x4
	// Bit TXRQST.
	C_CAN0_IF_CMDMSK_W_TXRQST = 0x4
	// No transmission request. TXRQSRT bit unchanged in IF1/2_MCTRL. If a transmission is requested by programming this bit, the TXRQST bit in the CANIFn_MCTRL register is ignored.
	C_CAN0_IF_CMDMSK_W_TXRQST_NO_TRANSMISSION_REQU = 0x0
	// Request a transmission. Set the TXRQST bit IF1/2_MCTRL.
	C_CAN0_IF_CMDMSK_W_TXRQST_REQUEST_A_TRANSMISSI = 0x1
	// Position of CLRINTPND field.
	C_CAN0_IF_CMDMSK_W_CLRINTPND_Pos = 0x3
	// Bit mask of CLRINTPND field.
	C_CAN0_IF_CMDMSK_W_CLRINTPND_Msk = 0x8
	// Bit CLRINTPND.
	C_CAN0_IF_CMDMSK_W_CLRINTPND = 0x8
	// Position of CTRL field.
	C_CAN0_IF_CMDMSK_W_CTRL_Pos = 0x4
	// Bit mask of CTRL field.
	C_CAN0_IF_CMDMSK_W_CTRL_Msk = 0x10
	// Bit CTRL.
	C_CAN0_IF_CMDMSK_W_CTRL = 0x10
	// Unchanged. Control bits unchanged.
	C_CAN0_IF_CMDMSK_W_CTRL_UNCHANGED = 0x0
	// Transfer. Transfer control bits to message object
	C_CAN0_IF_CMDMSK_W_CTRL_TRANSFER = 0x1
	// Position of ARB field.
	C_CAN0_IF_CMDMSK_W_ARB_Pos = 0x5
	// Bit mask of ARB field.
	C_CAN0_IF_CMDMSK_W_ARB_Msk = 0x20
	// Bit ARB.
	C_CAN0_IF_CMDMSK_W_ARB = 0x20
	// Unchanged. Arbitration bits unchanged.
	C_CAN0_IF_CMDMSK_W_ARB_UNCHANGED = 0x0
	// Transfer. Transfer Identifier, DIR, XTD, and MSGVAL bits to message object.
	C_CAN0_IF_CMDMSK_W_ARB_TRANSFER = 0x1
	// Position of MASK field.
	C_CAN0_IF_CMDMSK_W_MASK_Pos = 0x6
	// Bit mask of MASK field.
	C_CAN0_IF_CMDMSK_W_MASK_Msk = 0x40
	// Bit MASK.
	C_CAN0_IF_CMDMSK_W_MASK = 0x40
	// Unchanged. Mask bits unchanged.
	C_CAN0_IF_CMDMSK_W_MASK_UNCHANGED = 0x0
	// Transfer. Transfer Identifier MASK + MDIR + MXTD to message object.
	C_CAN0_IF_CMDMSK_W_MASK_TRANSFER = 0x1
	// Position of WR_RD field.
	C_CAN0_IF_CMDMSK_W_WR_RD_Pos = 0x7
	// Bit mask of WR_RD field.
	C_CAN0_IF_CMDMSK_W_WR_RD_Msk = 0x80
	// Bit WR_RD.
	C_CAN0_IF_CMDMSK_W_WR_RD = 0x80
	// Position of RESERVED field.
	C_CAN0_IF_CMDMSK_W_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	C_CAN0_IF_CMDMSK_W_RESERVED_Msk = 0xffffff00

	// IF1_CMDMSK_R: Message interface command mask (read direction)
	// Position of DATA_B field.
	C_CAN0_IF_CMDMSK_R_DATA_B_Pos = 0x0
	// Bit mask of DATA_B field.
	C_CAN0_IF_CMDMSK_R_DATA_B_Msk = 0x1
	// Bit DATA_B.
	C_CAN0_IF_CMDMSK_R_DATA_B = 0x1
	// Unchanged. Data bytes 4-7 unchanged.
	C_CAN0_IF_CMDMSK_R_DATA_B_UNCHANGED = 0x0
	// Transfer. Transfer data bytes 4-7 to IFx message buffer register.
	C_CAN0_IF_CMDMSK_R_DATA_B_TRANSFER = 0x1
	// Position of DATA_A field.
	C_CAN0_IF_CMDMSK_R_DATA_A_Pos = 0x1
	// Bit mask of DATA_A field.
	C_CAN0_IF_CMDMSK_R_DATA_A_Msk = 0x2
	// Bit DATA_A.
	C_CAN0_IF_CMDMSK_R_DATA_A = 0x2
	// Unchanged. Data bytes 0-3 unchanged.
	C_CAN0_IF_CMDMSK_R_DATA_A_UNCHANGED = 0x0
	// Transfer. Transfer data bytes 0-3 to IFx message buffer.
	C_CAN0_IF_CMDMSK_R_DATA_A_TRANSFER = 0x1
	// Position of NEWDAT field.
	C_CAN0_IF_CMDMSK_R_NEWDAT_Pos = 0x2
	// Bit mask of NEWDAT field.
	C_CAN0_IF_CMDMSK_R_NEWDAT_Msk = 0x4
	// Bit NEWDAT.
	C_CAN0_IF_CMDMSK_R_NEWDAT = 0x4
	// Unchanged. NEWDAT bit remains unchanged. A read access to a message object can be combined with the reset of the control bits INTPND and NEWDAT in IF1/2_MCTRL. The values of these bits transferred to the IFx Message Control Register always reflect the status before resetting these bits.
	C_CAN0_IF_CMDMSK_R_NEWDAT_UNCHANGED = 0x0
	// Clear. Clear NEWDAT bit in the message object.
	C_CAN0_IF_CMDMSK_R_NEWDAT_CLEAR = 0x1
	// Position of CLRINTPND field.
	C_CAN0_IF_CMDMSK_R_CLRINTPND_Pos = 0x3
	// Bit mask of CLRINTPND field.
	C_CAN0_IF_CMDMSK_R_CLRINTPND_Msk = 0x8
	// Bit CLRINTPND.
	C_CAN0_IF_CMDMSK_R_CLRINTPND = 0x8
	// Unchanged. INTPND bit remains unchanged.
	C_CAN0_IF_CMDMSK_R_CLRINTPND_UNCHANGED = 0x0
	// Clear. Clear INTPND bit in the message object.
	C_CAN0_IF_CMDMSK_R_CLRINTPND_CLEAR = 0x1
	// Position of CTRL field.
	C_CAN0_IF_CMDMSK_R_CTRL_Pos = 0x4
	// Bit mask of CTRL field.
	C_CAN0_IF_CMDMSK_R_CTRL_Msk = 0x10
	// Bit CTRL.
	C_CAN0_IF_CMDMSK_R_CTRL = 0x10
	// Unchanged. Control bits unchanged.
	C_CAN0_IF_CMDMSK_R_CTRL_UNCHANGED = 0x0
	// Transfer. Transfer control bits to IFx message buffer.
	C_CAN0_IF_CMDMSK_R_CTRL_TRANSFER = 0x1
	// Position of ARB field.
	C_CAN0_IF_CMDMSK_R_ARB_Pos = 0x5
	// Bit mask of ARB field.
	C_CAN0_IF_CMDMSK_R_ARB_Msk = 0x20
	// Bit ARB.
	C_CAN0_IF_CMDMSK_R_ARB = 0x20
	// Unchanged. Arbitration bits unchanged.
	C_CAN0_IF_CMDMSK_R_ARB_UNCHANGED = 0x0
	// Transfer. Transfer Identifier, DIR, XTD, and MSGVAL bits to IFx message buffer register.
	C_CAN0_IF_CMDMSK_R_ARB_TRANSFER = 0x1
	// Position of MASK field.
	C_CAN0_IF_CMDMSK_R_MASK_Pos = 0x6
	// Bit mask of MASK field.
	C_CAN0_IF_CMDMSK_R_MASK_Msk = 0x40
	// Bit MASK.
	C_CAN0_IF_CMDMSK_R_MASK = 0x40
	// Unchanged. Mask bits unchanged.
	C_CAN0_IF_CMDMSK_R_MASK_UNCHANGED = 0x0
	// Transfer. Transfer Identifier MASK + MDIR + MXTD to IFx message buffer register.
	C_CAN0_IF_CMDMSK_R_MASK_TRANSFER = 0x1
	// Position of WR_RD field.
	C_CAN0_IF_CMDMSK_R_WR_RD_Pos = 0x7
	// Bit mask of WR_RD field.
	C_CAN0_IF_CMDMSK_R_WR_RD_Msk = 0x80
	// Bit WR_RD.
	C_CAN0_IF_CMDMSK_R_WR_RD = 0x80
	// Position of RESERVED field.
	C_CAN0_IF_CMDMSK_R_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	C_CAN0_IF_CMDMSK_R_RESERVED_Msk = 0xffffff00

	// IF1_MSK1: Message interface mask 1
	// Position of MSK15_0 field.
	C_CAN0_IF_MSK1_MSK15_0_Pos = 0x0
	// Bit mask of MSK15_0 field.
	C_CAN0_IF_MSK1_MSK15_0_Msk = 0xffff
	// Match. The corresponding bit in the identifier of the message cannot inhibit the match in the acceptance filtering.
	C_CAN0_IF_MSK1_MSK15_0_MATCH = 0x0
	// Mask. The corresponding identifier bit is used for acceptance filtering.
	C_CAN0_IF_MSK1_MSK15_0_MASK = 0x1
	// Position of RESERVED field.
	C_CAN0_IF_MSK1_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	C_CAN0_IF_MSK1_RESERVED_Msk = 0xffff0000

	// IF1_MSK2: Message interface mask 2
	// Position of MSK28_16 field.
	C_CAN0_IF_MSK2_MSK28_16_Pos = 0x0
	// Bit mask of MSK28_16 field.
	C_CAN0_IF_MSK2_MSK28_16_Msk = 0x1fff
	// Match. The corresponding bit in the identifier of the message cannot inhibit the match in the acceptance filtering.
	C_CAN0_IF_MSK2_MSK28_16_MATCH = 0x0
	// Mask. The corresponding identifier bit is used for acceptance filtering.
	C_CAN0_IF_MSK2_MSK28_16_MASK = 0x1
	// Position of RESERVED field.
	C_CAN0_IF_MSK2_RESERVED_Pos = 0xd
	// Bit mask of RESERVED field.
	C_CAN0_IF_MSK2_RESERVED_Msk = 0x2000
	// Bit RESERVED.
	C_CAN0_IF_MSK2_RESERVED = 0x2000
	// Position of MDIR field.
	C_CAN0_IF_MSK2_MDIR_Pos = 0xe
	// Bit mask of MDIR field.
	C_CAN0_IF_MSK2_MDIR_Msk = 0x4000
	// Bit MDIR.
	C_CAN0_IF_MSK2_MDIR = 0x4000
	// Without DIR bit. The message direction bit (DIR) has no effect on acceptance filtering.
	C_CAN0_IF_MSK2_MDIR_WITHOUT_DIR_BIT = 0x0
	// With DIR bit. The message direction bit (DIR) is used for acceptance filtering.
	C_CAN0_IF_MSK2_MDIR_WITH_DIR_BIT = 0x1
	// Position of MXTD field.
	C_CAN0_IF_MSK2_MXTD_Pos = 0xf
	// Bit mask of MXTD field.
	C_CAN0_IF_MSK2_MXTD_Msk = 0x8000
	// Bit MXTD.
	C_CAN0_IF_MSK2_MXTD = 0x8000
	// Without XTD. The extended identifier bit (XTD) has no effect on acceptance filtering.
	C_CAN0_IF_MSK2_MXTD_WITHOUT_XTD = 0x0
	// With XTD. The extended identifier bit (XTD) is used for acceptance filtering.
	C_CAN0_IF_MSK2_MXTD_WITH_XTD = 0x1
	// Position of RESERVED field.
	C_CAN0_IF_MSK2_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	C_CAN0_IF_MSK2_RESERVED_Msk = 0xffff0000

	// IF1_ARB1: Message interface arbitration 1
	// Position of ID15_0 field.
	C_CAN0_IF_ARB1_ID15_0_Pos = 0x0
	// Bit mask of ID15_0 field.
	C_CAN0_IF_ARB1_ID15_0_Msk = 0xffff
	// Position of RESERVED field.
	C_CAN0_IF_ARB1_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	C_CAN0_IF_ARB1_RESERVED_Msk = 0xffff0000

	// IF1_ARB2: Message interface arbitration 2
	// Position of ID28_16 field.
	C_CAN0_IF_ARB2_ID28_16_Pos = 0x0
	// Bit mask of ID28_16 field.
	C_CAN0_IF_ARB2_ID28_16_Msk = 0x1fff
	// Position of DIR field.
	C_CAN0_IF_ARB2_DIR_Pos = 0xd
	// Bit mask of DIR field.
	C_CAN0_IF_ARB2_DIR_Msk = 0x2000
	// Bit DIR.
	C_CAN0_IF_ARB2_DIR = 0x2000
	// Receive. On TXRQST, a Remote Frame with the identifier of this Message Object is transmitted. On reception of a Data Frame with matching identifier, that message is stored in this Message Object.
	C_CAN0_IF_ARB2_DIR_RECEIVE = 0x0
	// Tansmit. On TXRQST, the respective Message Object is transmitted as a Data Frame. On reception of a Remote Frame with matching identifier, the TXRQST bit of this Message Object is set (if RMTEN = one).
	C_CAN0_IF_ARB2_DIR_TANSMIT = 0x1
	// Position of XTD field.
	C_CAN0_IF_ARB2_XTD_Pos = 0xe
	// Bit mask of XTD field.
	C_CAN0_IF_ARB2_XTD_Msk = 0x4000
	// Bit XTD.
	C_CAN0_IF_ARB2_XTD = 0x4000
	// Standard. The 11-bit standard identifier will be used for this message object.
	C_CAN0_IF_ARB2_XTD_STANDARD = 0x0
	// Extended. The 29-bit extended identifier will be used for this message object.
	C_CAN0_IF_ARB2_XTD_EXTENDED = 0x1
	// Position of MSGVAL field.
	C_CAN0_IF_ARB2_MSGVAL_Pos = 0xf
	// Bit mask of MSGVAL field.
	C_CAN0_IF_ARB2_MSGVAL_Msk = 0x8000
	// Bit MSGVAL.
	C_CAN0_IF_ARB2_MSGVAL = 0x8000
	// Invalid. The message object is ignored by the message handler.
	C_CAN0_IF_ARB2_MSGVAL_INVALID = 0x0
	// Valid. The message object is configured and should be considered by the message handler.
	C_CAN0_IF_ARB2_MSGVAL_VALID = 0x1
	// Position of RESERVED field.
	C_CAN0_IF_ARB2_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	C_CAN0_IF_ARB2_RESERVED_Msk = 0xffff0000

	// IF1_MCTRL: Message interface message control
	// Position of DLC3_0 field.
	C_CAN0_IF_MCTRL_DLC3_0_Pos = 0x0
	// Bit mask of DLC3_0 field.
	C_CAN0_IF_MCTRL_DLC3_0_Msk = 0xf
	// Position of RESERVED field.
	C_CAN0_IF_MCTRL_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	C_CAN0_IF_MCTRL_RESERVED_Msk = 0x70
	// Position of EOB field.
	C_CAN0_IF_MCTRL_EOB_Pos = 0x7
	// Bit mask of EOB field.
	C_CAN0_IF_MCTRL_EOB_Msk = 0x80
	// Bit EOB.
	C_CAN0_IF_MCTRL_EOB = 0x80
	// Not end of buffer. Message object belongs to a FIFO buffer and is not the last message object of that FIFO buffer.
	C_CAN0_IF_MCTRL_EOB_NOT_END_OF_BUFFER = 0x0
	// End of buffer. Single message object or last message object of a FIFO buffer.
	C_CAN0_IF_MCTRL_EOB_END_OF_BUFFER = 0x1
	// Position of TXRQST field.
	C_CAN0_IF_MCTRL_TXRQST_Pos = 0x8
	// Bit mask of TXRQST field.
	C_CAN0_IF_MCTRL_TXRQST_Msk = 0x100
	// Bit TXRQST.
	C_CAN0_IF_MCTRL_TXRQST = 0x100
	// Not waiting. This message object is not waiting for transmission.
	C_CAN0_IF_MCTRL_TXRQST_NOT_WAITING = 0x0
	// Waiting. The transmission of this message object is requested and is not yet done
	C_CAN0_IF_MCTRL_TXRQST_WAITING = 0x1
	// Position of RMTEN field.
	C_CAN0_IF_MCTRL_RMTEN_Pos = 0x9
	// Bit mask of RMTEN field.
	C_CAN0_IF_MCTRL_RMTEN_Msk = 0x200
	// Bit RMTEN.
	C_CAN0_IF_MCTRL_RMTEN = 0x200
	// TXRQST unchanged. At the reception of a remote frame, TXRQST is left unchanged.
	C_CAN0_IF_MCTRL_RMTEN_TXRQST_UNCHANGED = 0x0
	// TXRQST set. At the reception of a remote frame, TXRQST is set.
	C_CAN0_IF_MCTRL_RMTEN_TXRQST_SET = 0x1
	// Position of RXIE field.
	C_CAN0_IF_MCTRL_RXIE_Pos = 0xa
	// Bit mask of RXIE field.
	C_CAN0_IF_MCTRL_RXIE_Msk = 0x400
	// Bit RXIE.
	C_CAN0_IF_MCTRL_RXIE = 0x400
	// INTPND unchanged. INTPND will be left unchanged after successful reception of a frame.
	C_CAN0_IF_MCTRL_RXIE_INTPND_UNCHANGED = 0x0
	// INTPND set. INTPND will be set after successful reception of a frame.
	C_CAN0_IF_MCTRL_RXIE_INTPND_SET = 0x1
	// Position of TXIE field.
	C_CAN0_IF_MCTRL_TXIE_Pos = 0xb
	// Bit mask of TXIE field.
	C_CAN0_IF_MCTRL_TXIE_Msk = 0x800
	// Bit TXIE.
	C_CAN0_IF_MCTRL_TXIE = 0x800
	// INTPND unchanged. The INTPND bit will be left unchanged after a successful transmission of a frame.
	C_CAN0_IF_MCTRL_TXIE_INTPND_UNCHANGED = 0x0
	// INTPND set. INTPND will be set after a successful transmission of a frame.
	C_CAN0_IF_MCTRL_TXIE_INTPND_SET = 0x1
	// Position of UMASK field.
	C_CAN0_IF_MCTRL_UMASK_Pos = 0xc
	// Bit mask of UMASK field.
	C_CAN0_IF_MCTRL_UMASK_Msk = 0x1000
	// Bit UMASK.
	C_CAN0_IF_MCTRL_UMASK = 0x1000
	// Ignore. Mask ignored.
	C_CAN0_IF_MCTRL_UMASK_IGNORE = 0x0
	// Use. Use mask (MSK[28:0], MXTD, and MDIR) for acceptance filtering.
	C_CAN0_IF_MCTRL_UMASK_USE = 0x1
	// Position of INTPND field.
	C_CAN0_IF_MCTRL_INTPND_Pos = 0xd
	// Bit mask of INTPND field.
	C_CAN0_IF_MCTRL_INTPND_Msk = 0x2000
	// Bit INTPND.
	C_CAN0_IF_MCTRL_INTPND = 0x2000
	// Not pending. This message object is not the source of an interrupt.
	C_CAN0_IF_MCTRL_INTPND_NOT_PENDING = 0x0
	// Pending. This message object is the source of an interrupt. The Interrupt Identifier in the Interrupt Register will point to this message object if there is no other interrupt source with higher priority.
	C_CAN0_IF_MCTRL_INTPND_PENDING = 0x1
	// Position of MSGLST field.
	C_CAN0_IF_MCTRL_MSGLST_Pos = 0xe
	// Bit mask of MSGLST field.
	C_CAN0_IF_MCTRL_MSGLST_Msk = 0x4000
	// Bit MSGLST.
	C_CAN0_IF_MCTRL_MSGLST = 0x4000
	// Not lost. No message lost since this bit was reset last by the CPU.
	C_CAN0_IF_MCTRL_MSGLST_NOT_LOST = 0x0
	// Lost. The Message Handler stored a new message into this object when NEWDAT was still set, the CPU has lost a message.
	C_CAN0_IF_MCTRL_MSGLST_LOST = 0x1
	// Position of NEWDAT field.
	C_CAN0_IF_MCTRL_NEWDAT_Pos = 0xf
	// Bit mask of NEWDAT field.
	C_CAN0_IF_MCTRL_NEWDAT_Msk = 0x8000
	// Bit NEWDAT.
	C_CAN0_IF_MCTRL_NEWDAT = 0x8000
	// No new data. No new data has been written into the data portion of this message object by the message handler since this flag was cleared last by the CPU.
	C_CAN0_IF_MCTRL_NEWDAT_NO_NEW_DATA = 0x0
	// New data. The message handler or the CPU has written new data into the data portion of this message object.
	C_CAN0_IF_MCTRL_NEWDAT_NEW_DATA = 0x1
	// Position of RESERVED field.
	C_CAN0_IF_MCTRL_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	C_CAN0_IF_MCTRL_RESERVED_Msk = 0xffff0000

	// IF1_DA1: Message interface data A1
	// Position of DATA0 field.
	C_CAN0_IF_DA1_DATA0_Pos = 0x0
	// Bit mask of DATA0 field.
	C_CAN0_IF_DA1_DATA0_Msk = 0xff
	// Position of DATA1 field.
	C_CAN0_IF_DA1_DATA1_Pos = 0x8
	// Bit mask of DATA1 field.
	C_CAN0_IF_DA1_DATA1_Msk = 0xff00
	// Position of RESERVED field.
	C_CAN0_IF_DA1_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	C_CAN0_IF_DA1_RESERVED_Msk = 0xffff0000

	// IF1_DA2: Message interface 1 data A2
	// Position of DATA2 field.
	C_CAN0_IF_DA2_DATA2_Pos = 0x0
	// Bit mask of DATA2 field.
	C_CAN0_IF_DA2_DATA2_Msk = 0xff
	// Position of DATA3 field.
	C_CAN0_IF_DA2_DATA3_Pos = 0x8
	// Bit mask of DATA3 field.
	C_CAN0_IF_DA2_DATA3_Msk = 0xff00
	// Position of RESERVED field.
	C_CAN0_IF_DA2_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	C_CAN0_IF_DA2_RESERVED_Msk = 0xffff0000

	// IF1_DB1: Message interface 1 data B1
	// Position of DATA4 field.
	C_CAN0_IF_DB1_DATA4_Pos = 0x0
	// Bit mask of DATA4 field.
	C_CAN0_IF_DB1_DATA4_Msk = 0xff
	// Position of DATA5 field.
	C_CAN0_IF_DB1_DATA5_Pos = 0x8
	// Bit mask of DATA5 field.
	C_CAN0_IF_DB1_DATA5_Msk = 0xff00
	// Position of RESERVED field.
	C_CAN0_IF_DB1_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	C_CAN0_IF_DB1_RESERVED_Msk = 0xffff0000

	// IF1_DB2: Message interface 1 data B2
	// Position of DATA6 field.
	C_CAN0_IF_DB2_DATA6_Pos = 0x0
	// Bit mask of DATA6 field.
	C_CAN0_IF_DB2_DATA6_Msk = 0xff
	// Position of DATA7 field.
	C_CAN0_IF_DB2_DATA7_Pos = 0x8
	// Bit mask of DATA7 field.
	C_CAN0_IF_DB2_DATA7_Msk = 0xff00
	// Position of RESERVED field.
	C_CAN0_IF_DB2_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	C_CAN0_IF_DB2_RESERVED_Msk = 0xffff0000

	// TXREQ1: Transmission request 1
	// Position of TXRQST16_1 field.
	C_CAN0_TXREQ1_TXRQST16_1_Pos = 0x0
	// Bit mask of TXRQST16_1 field.
	C_CAN0_TXREQ1_TXRQST16_1_Msk = 0xffff
	// Position of RESERVED field.
	C_CAN0_TXREQ1_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	C_CAN0_TXREQ1_RESERVED_Msk = 0xffff0000

	// TXREQ2: Transmission request 2
	// Position of TXRQST32_17 field.
	C_CAN0_TXREQ2_TXRQST32_17_Pos = 0x0
	// Bit mask of TXRQST32_17 field.
	C_CAN0_TXREQ2_TXRQST32_17_Msk = 0xffff
	// Position of RESERVED field.
	C_CAN0_TXREQ2_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	C_CAN0_TXREQ2_RESERVED_Msk = 0xffff0000

	// ND1: New data 1
	// Position of NEWDAT16_1 field.
	C_CAN0_ND1_NEWDAT16_1_Pos = 0x0
	// Bit mask of NEWDAT16_1 field.
	C_CAN0_ND1_NEWDAT16_1_Msk = 0xffff
	// Position of RESERVED field.
	C_CAN0_ND1_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	C_CAN0_ND1_RESERVED_Msk = 0xffff0000

	// ND2: New data 2
	// Position of NEWDAT32_17 field.
	C_CAN0_ND2_NEWDAT32_17_Pos = 0x0
	// Bit mask of NEWDAT32_17 field.
	C_CAN0_ND2_NEWDAT32_17_Msk = 0xffff
	// Position of RESERVED field.
	C_CAN0_ND2_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	C_CAN0_ND2_RESERVED_Msk = 0xffff0000

	// IR1: Interrupt pending 1
	// Position of INTPND16_1 field.
	C_CAN0_IR1_INTPND16_1_Pos = 0x0
	// Bit mask of INTPND16_1 field.
	C_CAN0_IR1_INTPND16_1_Msk = 0xffff
	// Position of RESERVED field.
	C_CAN0_IR1_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	C_CAN0_IR1_RESERVED_Msk = 0xffff0000

	// IR2: Interrupt pending 2
	// Position of INTPND32_17 field.
	C_CAN0_IR2_INTPND32_17_Pos = 0x0
	// Bit mask of INTPND32_17 field.
	C_CAN0_IR2_INTPND32_17_Msk = 0xffff
	// Position of RESERVED field.
	C_CAN0_IR2_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	C_CAN0_IR2_RESERVED_Msk = 0xffff0000

	// MSGV1: Message valid 1
	// Position of MSGVAL16_1 field.
	C_CAN0_MSGV1_MSGVAL16_1_Pos = 0x0
	// Bit mask of MSGVAL16_1 field.
	C_CAN0_MSGV1_MSGVAL16_1_Msk = 0xffff
	// Position of RESERVED field.
	C_CAN0_MSGV1_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	C_CAN0_MSGV1_RESERVED_Msk = 0xffff0000

	// MSGV2: Message valid 2
	// Position of MSGVAL32_17 field.
	C_CAN0_MSGV2_MSGVAL32_17_Pos = 0x0
	// Bit mask of MSGVAL32_17 field.
	C_CAN0_MSGV2_MSGVAL32_17_Msk = 0xffff
	// Position of RESERVED field.
	C_CAN0_MSGV2_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	C_CAN0_MSGV2_RESERVED_Msk = 0xffff0000

	// CLKDIV: CAN clock divider register
	// Position of CLKDIVVAL field.
	C_CAN0_CLKDIV_CLKDIVVAL_Pos = 0x0
	// Bit mask of CLKDIVVAL field.
	C_CAN0_CLKDIV_CLKDIVVAL_Msk = 0xf
	// Position of RESERVED field.
	C_CAN0_CLKDIV_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	C_CAN0_CLKDIV_RESERVED_Msk = 0xfffffff0
)

// Bitfields for IOCON: I/O pin configuration (IOCON)
const (
	// PIO0_0: Digital I/O control for port 0 pins PIO0_0 to PIO0_17. With glitch filter.
	// Position of RESERVED field.
	IOCON_PIO0_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	IOCON_PIO0_RESERVED_Msk = 0x7
	// Position of MODE field.
	IOCON_PIO0_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO0_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO0_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO0_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO0_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO0_MODE_REPEATER_MODE = 0x3
	// Position of HYS field.
	IOCON_PIO0_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO0_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO0_HYS = 0x20
	// Disable.
	IOCON_PIO0_HYS_DISABLE = 0x0
	// Enable.
	IOCON_PIO0_HYS_ENABLE = 0x1
	// Position of INV field.
	IOCON_PIO0_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO0_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO0_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1; LOW on pin reads as 0).
	IOCON_PIO0_INV_INPUT_NOT_INVERTED = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO0_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO0_RESERVED_Msk = 0x80
	// Bit RESERVED.
	IOCON_PIO0_RESERVED = 0x80
	// Position of FILTR field.
	IOCON_PIO0_FILTR_Pos = 0x8
	// Bit mask of FILTR field.
	IOCON_PIO0_FILTR_Msk = 0x100
	// Bit FILTR.
	IOCON_PIO0_FILTR = 0x100
	// Filter enabled.
	IOCON_PIO0_FILTR_FILTER_ENABLED_ = 0x0
	// Filter disabled.
	IOCON_PIO0_FILTR_FILTER_DISABLED_ = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	IOCON_PIO0_RESERVED_Msk = 0x200
	// Bit RESERVED.
	IOCON_PIO0_RESERVED = 0x200
	// Position of OD field.
	IOCON_PIO0_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO0_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO0_OD = 0x400
	// Disable.
	IOCON_PIO0_OD_DISABLE = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_PIO0_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of S_MODE field.
	IOCON_PIO0_S_MODE_Pos = 0xb
	// Bit mask of S_MODE field.
	IOCON_PIO0_S_MODE_Msk = 0x1800
	// Bypass input filter.
	IOCON_PIO0_S_MODE_BYPASS_INPUT_FILTER = 0x0
	// 1 clock cycle. Input pulses shorter than one filter clock are rejected.
	IOCON_PIO0_S_MODE_1_CLOCK_CYCLE = 0x1
	// 2 clock cycles. Input pulses shorter than two filter clocks are rejected.
	IOCON_PIO0_S_MODE_2_CLOCK_CYCLES = 0x2
	// 3 clock cycles. Input pulses shorter than three filter clocks are rejected.
	IOCON_PIO0_S_MODE_3_CLOCK_CYCLES = 0x3
	// Position of CLKDIV field.
	IOCON_PIO0_CLKDIV_Pos = 0xd
	// Bit mask of CLKDIV field.
	IOCON_PIO0_CLKDIV_Msk = 0xe000
	// CMP_PCLK.
	IOCON_PIO0_CLKDIV_CMP_PCLK = 0x0
	// CMP_PCLK/2.
	IOCON_PIO0_CLKDIV_CMP_PCLKDIV2 = 0x1
	// CMP_PCLK/4.
	IOCON_PIO0_CLKDIV_CMP_PCLKDIV4 = 0x2
	// CMP_PCLK/8.
	IOCON_PIO0_CLKDIV_CMP_PCLKDIV8 = 0x3
	// CMP_PCLK/16.
	IOCON_PIO0_CLKDIV_CMP_PCLKDIV16 = 0x4
	// CMP_PCLK/32.
	IOCON_PIO0_CLKDIV_CMP_PCLKDIV32 = 0x5
	// CMP_PCLK/64.
	IOCON_PIO0_CLKDIV_CMP_PCLKDIV64 = 0x6
	// Position of RESERVED field.
	IOCON_PIO0_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	IOCON_PIO0_RESERVED_Msk = 0xffff0000

	// PIO0_18: Digital I/O control for port 0 pins PIO0_18 to PIO0_21. Without glitch filter.
	// Position of RESERVED field.
	IOCON_PIO0_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	IOCON_PIO0_RESERVED_Msk = 0x7
	// Position of MODE field.
	IOCON_PIO0_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO0_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO0_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO0_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO0_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO0_MODE_REPEATER_MODE = 0x3
	// Position of HYS field.
	IOCON_PIO0_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO0_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO0_HYS = 0x20
	// Disable.
	IOCON_PIO0_HYS_DISABLE = 0x0
	// Enable.
	IOCON_PIO0_HYS_ENABLE = 0x1
	// Position of INV field.
	IOCON_PIO0_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO0_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO0_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1; LOW on pin reads as 0).
	IOCON_PIO0_INV_INPUT_NOT_INVERTED = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO0_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO0_RESERVED_Msk = 0x380
	// Position of OD field.
	IOCON_PIO0_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO0_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO0_OD = 0x400
	// Disable.
	IOCON_PIO0_OD_DISABLE = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_PIO0_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of S_MODE field.
	IOCON_PIO0_S_MODE_Pos = 0xb
	// Bit mask of S_MODE field.
	IOCON_PIO0_S_MODE_Msk = 0x1800
	// Bypass input filter.
	IOCON_PIO0_S_MODE_BYPASS_INPUT_FILTER = 0x0
	// 1 clock cycle. Input pulses shorter than one filter clock are rejected.
	IOCON_PIO0_S_MODE_1_CLOCK_CYCLE = 0x1
	// 2 clock cycles. Input pulses shorter than two filter clocks are rejected.
	IOCON_PIO0_S_MODE_2_CLOCK_CYCLES = 0x2
	// 3 clock cycles. Input pulses shorter than three filter clocks are rejected.
	IOCON_PIO0_S_MODE_3_CLOCK_CYCLES = 0x3
	// Position of CLKDIV field.
	IOCON_PIO0_CLKDIV_Pos = 0xd
	// Bit mask of CLKDIV field.
	IOCON_PIO0_CLKDIV_Msk = 0xe000
	// CMP_PCLK.
	IOCON_PIO0_CLKDIV_CMP_PCLK = 0x0
	// CMP_PCLK/2.
	IOCON_PIO0_CLKDIV_CMP_PCLKDIV2 = 0x1
	// CMP_PCLK/4.
	IOCON_PIO0_CLKDIV_CMP_PCLKDIV4 = 0x2
	// CMP_PCLK/8.
	IOCON_PIO0_CLKDIV_CMP_PCLKDIV8 = 0x3
	// CMP_PCLK/16.
	IOCON_PIO0_CLKDIV_CMP_PCLKDIV16 = 0x4
	// CMP_PCLK/32.
	IOCON_PIO0_CLKDIV_CMP_PCLKDIV32 = 0x5
	// CMP_PCLK/64.
	IOCON_PIO0_CLKDIV_CMP_PCLKDIV64 = 0x6
	// Position of RESERVED field.
	IOCON_PIO0_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	IOCON_PIO0_RESERVED_Msk = 0xffff0000

	// PIO0_22: I/O control for open-drain pin PIO0_22. This pin is used for the I2C-bus SCL function.
	// Position of RESERVED field.
	IOCON_PIO0_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	IOCON_PIO0_RESERVED_Msk = 0x3f
	// Position of INV field.
	IOCON_PIO0_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO0_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO0_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1; LOW on pin reads as 0).
	IOCON_PIO0_INV_INPUT_NOT_INVERTED = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO0_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO0_RESERVED_Msk = 0x80
	// Bit RESERVED.
	IOCON_PIO0_RESERVED = 0x80
	// Position of I2CMODE field.
	IOCON_PIO0_I2CMODE_Pos = 0x8
	// Bit mask of I2CMODE field.
	IOCON_PIO0_I2CMODE_Msk = 0x300
	// Standard mode/ Fast-mode I2C.
	IOCON_PIO0_I2CMODE_STANDARD_MODE = 0x0
	// Standard I/O functionality
	IOCON_PIO0_I2CMODE_STANDARD_IO_FUNCTIO = 0x1
	// Fast-mode Plus I2C
	IOCON_PIO0_I2CMODE_FAST_MODE_PLUS_I2C = 0x2
	// Position of RESERVED field.
	IOCON_PIO0_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	IOCON_PIO0_RESERVED_Msk = 0x400
	// Bit RESERVED.
	IOCON_PIO0_RESERVED = 0x400
	// Position of S_MODE field.
	IOCON_PIO0_S_MODE_Pos = 0xb
	// Bit mask of S_MODE field.
	IOCON_PIO0_S_MODE_Msk = 0x1800
	// Bypass input filter.
	IOCON_PIO0_S_MODE_BYPASS_INPUT_FILTER = 0x0
	// 1 clock cycle. Input pulses shorter than one filter clock are rejected.
	IOCON_PIO0_S_MODE_1_CLOCK_CYCLE = 0x1
	// 2 clock cycles. Input pulses shorter than two filter clocks are rejected.
	IOCON_PIO0_S_MODE_2_CLOCK_CYCLES = 0x2
	// 3 clock cycles. Input pulses shorter than three filter clocks are rejected.
	IOCON_PIO0_S_MODE_3_CLOCK_CYCLES = 0x3
	// Position of CLKDIV field.
	IOCON_PIO0_CLKDIV_Pos = 0xd
	// Bit mask of CLKDIV field.
	IOCON_PIO0_CLKDIV_Msk = 0xe000
	// CMP_PCLK.
	IOCON_PIO0_CLKDIV_CMP_PCLK = 0x0
	// CMP_PCLK/2.
	IOCON_PIO0_CLKDIV_CMP_PCLKDIV2 = 0x1
	// CMP_PCLK/4.
	IOCON_PIO0_CLKDIV_CMP_PCLKDIV4 = 0x2
	// CMP_PCLK/8.
	IOCON_PIO0_CLKDIV_CMP_PCLKDIV8 = 0x3
	// CMP_PCLK/16.
	IOCON_PIO0_CLKDIV_CMP_PCLKDIV16 = 0x4
	// CMP_PCLK/32.
	IOCON_PIO0_CLKDIV_CMP_PCLKDIV32 = 0x5
	// CMP_PCLK/64.
	IOCON_PIO0_CLKDIV_CMP_PCLKDIV64 = 0x6
	// Position of RESERVED field.
	IOCON_PIO0_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	IOCON_PIO0_RESERVED_Msk = 0xffff0000

	// PIO0_24: Digital I/O control for port 0 pins PIO0_24. Without glitch filter.
	// Position of RESERVED field.
	IOCON_PIO0_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	IOCON_PIO0_RESERVED_Msk = 0x7
	// Position of MODE field.
	IOCON_PIO0_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO0_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO0_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO0_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO0_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO0_MODE_REPEATER_MODE = 0x3
	// Position of HYS field.
	IOCON_PIO0_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO0_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO0_HYS = 0x20
	// Disable.
	IOCON_PIO0_HYS_DISABLE = 0x0
	// Enable.
	IOCON_PIO0_HYS_ENABLE = 0x1
	// Position of INV field.
	IOCON_PIO0_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO0_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO0_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1; LOW on pin reads as 0).
	IOCON_PIO0_INV_INPUT_NOT_INVERTED = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO0_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO0_RESERVED_Msk = 0x380
	// Position of OD field.
	IOCON_PIO0_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO0_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO0_OD = 0x400
	// Disable.
	IOCON_PIO0_OD_DISABLE = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_PIO0_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of S_MODE field.
	IOCON_PIO0_S_MODE_Pos = 0xb
	// Bit mask of S_MODE field.
	IOCON_PIO0_S_MODE_Msk = 0x1800
	// Bypass input filter.
	IOCON_PIO0_S_MODE_BYPASS_INPUT_FILTER = 0x0
	// 1 clock cycle. Input pulses shorter than one filter clock are rejected.
	IOCON_PIO0_S_MODE_1_CLOCK_CYCLE = 0x1
	// 2 clock cycles. Input pulses shorter than two filter clocks are rejected.
	IOCON_PIO0_S_MODE_2_CLOCK_CYCLES = 0x2
	// 3 clock cycles. Input pulses shorter than three filter clocks are rejected.
	IOCON_PIO0_S_MODE_3_CLOCK_CYCLES = 0x3
	// Position of CLKDIV field.
	IOCON_PIO0_CLKDIV_Pos = 0xd
	// Bit mask of CLKDIV field.
	IOCON_PIO0_CLKDIV_Msk = 0xe000
	// CMP_PCLK.
	IOCON_PIO0_CLKDIV_CMP_PCLK = 0x0
	// CMP_PCLK/2.
	IOCON_PIO0_CLKDIV_CMP_PCLKDIV2 = 0x1
	// CMP_PCLK/4.
	IOCON_PIO0_CLKDIV_CMP_PCLKDIV4 = 0x2
	// CMP_PCLK/8.
	IOCON_PIO0_CLKDIV_CMP_PCLKDIV8 = 0x3
	// CMP_PCLK/16.
	IOCON_PIO0_CLKDIV_CMP_PCLKDIV16 = 0x4
	// CMP_PCLK/32.
	IOCON_PIO0_CLKDIV_CMP_PCLKDIV32 = 0x5
	// CMP_PCLK/64.
	IOCON_PIO0_CLKDIV_CMP_PCLKDIV64 = 0x6
	// Position of RESERVED field.
	IOCON_PIO0_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	IOCON_PIO0_RESERVED_Msk = 0xffff0000

	// PIO0_25: Digital I/O control for port 0 pins PIO0_25 to PIO0_31. With glitch filter.
	// Position of RESERVED field.
	IOCON_PIO0_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	IOCON_PIO0_RESERVED_Msk = 0x7
	// Position of MODE field.
	IOCON_PIO0_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO0_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO0_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO0_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO0_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO0_MODE_REPEATER_MODE = 0x3
	// Position of HYS field.
	IOCON_PIO0_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO0_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO0_HYS = 0x20
	// Disable.
	IOCON_PIO0_HYS_DISABLE = 0x0
	// Enable.
	IOCON_PIO0_HYS_ENABLE = 0x1
	// Position of INV field.
	IOCON_PIO0_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO0_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO0_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1; LOW on pin reads as 0).
	IOCON_PIO0_INV_INPUT_NOT_INVERTED = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO0_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO0_RESERVED_Msk = 0x80
	// Bit RESERVED.
	IOCON_PIO0_RESERVED = 0x80
	// Position of FILTR field.
	IOCON_PIO0_FILTR_Pos = 0x8
	// Bit mask of FILTR field.
	IOCON_PIO0_FILTR_Msk = 0x100
	// Bit FILTR.
	IOCON_PIO0_FILTR = 0x100
	// Filter enabled.
	IOCON_PIO0_FILTR_FILTER_ENABLED_ = 0x0
	// Filter disabled.
	IOCON_PIO0_FILTR_FILTER_DISABLED_ = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	IOCON_PIO0_RESERVED_Msk = 0x200
	// Bit RESERVED.
	IOCON_PIO0_RESERVED = 0x200
	// Position of OD field.
	IOCON_PIO0_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO0_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO0_OD = 0x400
	// Disable.
	IOCON_PIO0_OD_DISABLE = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_PIO0_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of S_MODE field.
	IOCON_PIO0_S_MODE_Pos = 0xb
	// Bit mask of S_MODE field.
	IOCON_PIO0_S_MODE_Msk = 0x1800
	// Bypass input filter.
	IOCON_PIO0_S_MODE_BYPASS_INPUT_FILTER = 0x0
	// 1 clock cycle. Input pulses shorter than one filter clock are rejected.
	IOCON_PIO0_S_MODE_1_CLOCK_CYCLE = 0x1
	// 2 clock cycles. Input pulses shorter than two filter clocks are rejected.
	IOCON_PIO0_S_MODE_2_CLOCK_CYCLES = 0x2
	// 3 clock cycles. Input pulses shorter than three filter clocks are rejected.
	IOCON_PIO0_S_MODE_3_CLOCK_CYCLES = 0x3
	// Position of CLKDIV field.
	IOCON_PIO0_CLKDIV_Pos = 0xd
	// Bit mask of CLKDIV field.
	IOCON_PIO0_CLKDIV_Msk = 0xe000
	// CMP_PCLK.
	IOCON_PIO0_CLKDIV_CMP_PCLK = 0x0
	// CMP_PCLK/2.
	IOCON_PIO0_CLKDIV_CMP_PCLKDIV2 = 0x1
	// CMP_PCLK/4.
	IOCON_PIO0_CLKDIV_CMP_PCLKDIV4 = 0x2
	// CMP_PCLK/8.
	IOCON_PIO0_CLKDIV_CMP_PCLKDIV8 = 0x3
	// CMP_PCLK/16.
	IOCON_PIO0_CLKDIV_CMP_PCLKDIV16 = 0x4
	// CMP_PCLK/32.
	IOCON_PIO0_CLKDIV_CMP_PCLKDIV32 = 0x5
	// CMP_PCLK/64.
	IOCON_PIO0_CLKDIV_CMP_PCLKDIV64 = 0x6
	// Position of RESERVED field.
	IOCON_PIO0_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	IOCON_PIO0_RESERVED_Msk = 0xffff0000

	// PIO1_0: Digital I/O control for port 1 pins PIO1_0 to PIO1_10. With glitch filter.
	// Position of RESERVED field.
	IOCON_PIO1_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	IOCON_PIO1_RESERVED_Msk = 0x7
	// Position of MODE field.
	IOCON_PIO1_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO1_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO1_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO1_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO1_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO1_MODE_REPEATER_MODE = 0x3
	// Position of HYS field.
	IOCON_PIO1_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO1_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO1_HYS = 0x20
	// Disable.
	IOCON_PIO1_HYS_DISABLE = 0x0
	// Enable.
	IOCON_PIO1_HYS_ENABLE = 0x1
	// Position of INV field.
	IOCON_PIO1_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO1_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO1_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1; LOW on pin reads as 0).
	IOCON_PIO1_INV_INPUT_NOT_INVERTED = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO1_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO1_RESERVED_Msk = 0x80
	// Bit RESERVED.
	IOCON_PIO1_RESERVED = 0x80
	// Position of FILTR field.
	IOCON_PIO1_FILTR_Pos = 0x8
	// Bit mask of FILTR field.
	IOCON_PIO1_FILTR_Msk = 0x100
	// Bit FILTR.
	IOCON_PIO1_FILTR = 0x100
	// Filter enabled.
	IOCON_PIO1_FILTR_FILTER_ENABLED_ = 0x0
	// Filter disabled.
	IOCON_PIO1_FILTR_FILTER_DISABLED_ = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	IOCON_PIO1_RESERVED_Msk = 0x200
	// Bit RESERVED.
	IOCON_PIO1_RESERVED = 0x200
	// Position of OD field.
	IOCON_PIO1_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO1_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO1_OD = 0x400
	// Disable.
	IOCON_PIO1_OD_DISABLE = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_PIO1_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of S_MODE field.
	IOCON_PIO1_S_MODE_Pos = 0xb
	// Bit mask of S_MODE field.
	IOCON_PIO1_S_MODE_Msk = 0x1800
	// Bypass input filter.
	IOCON_PIO1_S_MODE_BYPASS_INPUT_FILTER = 0x0
	// 1 clock cycle. Input pulses shorter than one filter clock are rejected.
	IOCON_PIO1_S_MODE_1_CLOCK_CYCLE = 0x1
	// 2 clock cycles. Input pulses shorter than two filter clocks are rejected.
	IOCON_PIO1_S_MODE_2_CLOCK_CYCLES = 0x2
	// 3 clock cycles. Input pulses shorter than three filter clocks are rejected.
	IOCON_PIO1_S_MODE_3_CLOCK_CYCLES = 0x3
	// Position of CLKDIV field.
	IOCON_PIO1_CLKDIV_Pos = 0xd
	// Bit mask of CLKDIV field.
	IOCON_PIO1_CLKDIV_Msk = 0xe000
	// CMP_PCLK.
	IOCON_PIO1_CLKDIV_CMP_PCLK = 0x0
	// CMP_PCLK/2.
	IOCON_PIO1_CLKDIV_CMP_PCLKDIV2 = 0x1
	// CMP_PCLK/4.
	IOCON_PIO1_CLKDIV_CMP_PCLKDIV4 = 0x2
	// CMP_PCLK/8.
	IOCON_PIO1_CLKDIV_CMP_PCLKDIV8 = 0x3
	// CMP_PCLK/16.
	IOCON_PIO1_CLKDIV_CMP_PCLKDIV16 = 0x4
	// CMP_PCLK/32.
	IOCON_PIO1_CLKDIV_CMP_PCLKDIV32 = 0x5
	// CMP_PCLK/64.
	IOCON_PIO1_CLKDIV_CMP_PCLKDIV64 = 0x6
	// Position of RESERVED field.
	IOCON_PIO1_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	IOCON_PIO1_RESERVED_Msk = 0xffff0000

	// PIO1_11: Digital I/O control for port 1 pins PIO1_11 to PIO1_31. Without glitch filter.
	// Position of RESERVED field.
	IOCON_PIO1_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	IOCON_PIO1_RESERVED_Msk = 0x7
	// Position of MODE field.
	IOCON_PIO1_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO1_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO1_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO1_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO1_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO1_MODE_REPEATER_MODE = 0x3
	// Position of HYS field.
	IOCON_PIO1_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO1_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO1_HYS = 0x20
	// Disable.
	IOCON_PIO1_HYS_DISABLE = 0x0
	// Enable.
	IOCON_PIO1_HYS_ENABLE = 0x1
	// Position of INV field.
	IOCON_PIO1_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO1_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO1_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1; LOW on pin reads as 0).
	IOCON_PIO1_INV_INPUT_NOT_INVERTED = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO1_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO1_RESERVED_Msk = 0x380
	// Position of OD field.
	IOCON_PIO1_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO1_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO1_OD = 0x400
	// Disable.
	IOCON_PIO1_OD_DISABLE = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_PIO1_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of S_MODE field.
	IOCON_PIO1_S_MODE_Pos = 0xb
	// Bit mask of S_MODE field.
	IOCON_PIO1_S_MODE_Msk = 0x1800
	// Bypass input filter.
	IOCON_PIO1_S_MODE_BYPASS_INPUT_FILTER = 0x0
	// 1 clock cycle. Input pulses shorter than one filter clock are rejected.
	IOCON_PIO1_S_MODE_1_CLOCK_CYCLE = 0x1
	// 2 clock cycles. Input pulses shorter than two filter clocks are rejected.
	IOCON_PIO1_S_MODE_2_CLOCK_CYCLES = 0x2
	// 3 clock cycles. Input pulses shorter than three filter clocks are rejected.
	IOCON_PIO1_S_MODE_3_CLOCK_CYCLES = 0x3
	// Position of CLKDIV field.
	IOCON_PIO1_CLKDIV_Pos = 0xd
	// Bit mask of CLKDIV field.
	IOCON_PIO1_CLKDIV_Msk = 0xe000
	// CMP_PCLK.
	IOCON_PIO1_CLKDIV_CMP_PCLK = 0x0
	// CMP_PCLK/2.
	IOCON_PIO1_CLKDIV_CMP_PCLKDIV2 = 0x1
	// CMP_PCLK/4.
	IOCON_PIO1_CLKDIV_CMP_PCLKDIV4 = 0x2
	// CMP_PCLK/8.
	IOCON_PIO1_CLKDIV_CMP_PCLKDIV8 = 0x3
	// CMP_PCLK/16.
	IOCON_PIO1_CLKDIV_CMP_PCLKDIV16 = 0x4
	// CMP_PCLK/32.
	IOCON_PIO1_CLKDIV_CMP_PCLKDIV32 = 0x5
	// CMP_PCLK/64.
	IOCON_PIO1_CLKDIV_CMP_PCLKDIV64 = 0x6
	// Position of RESERVED field.
	IOCON_PIO1_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	IOCON_PIO1_RESERVED_Msk = 0xffff0000

	// PIO2_0: Digital I/O control for port 2 pins PIO2_0 to PIO2_13. Without glitch filter.
	// Position of RESERVED field.
	IOCON_PIO2_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	IOCON_PIO2_RESERVED_Msk = 0x7
	// Position of MODE field.
	IOCON_PIO2_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO2_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO2_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO2_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO2_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO2_MODE_REPEATER_MODE = 0x3
	// Position of HYS field.
	IOCON_PIO2_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO2_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO2_HYS = 0x20
	// Disable.
	IOCON_PIO2_HYS_DISABLE = 0x0
	// Enable.
	IOCON_PIO2_HYS_ENABLE = 0x1
	// Position of INV field.
	IOCON_PIO2_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO2_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO2_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1; LOW on pin reads as 0).
	IOCON_PIO2_INV_INPUT_NOT_INVERTED = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO2_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO2_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO2_RESERVED_Msk = 0x380
	// Position of OD field.
	IOCON_PIO2_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO2_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO2_OD = 0x400
	// Disable.
	IOCON_PIO2_OD_DISABLE = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_PIO2_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of S_MODE field.
	IOCON_PIO2_S_MODE_Pos = 0xb
	// Bit mask of S_MODE field.
	IOCON_PIO2_S_MODE_Msk = 0x1800
	// Bypass input filter.
	IOCON_PIO2_S_MODE_BYPASS_INPUT_FILTER = 0x0
	// 1 clock cycle. Input pulses shorter than one filter clock are rejected.
	IOCON_PIO2_S_MODE_1_CLOCK_CYCLE = 0x1
	// 2 clock cycles. Input pulses shorter than two filter clocks are rejected.
	IOCON_PIO2_S_MODE_2_CLOCK_CYCLES = 0x2
	// 3 clock cycles. Input pulses shorter than three filter clocks are rejected.
	IOCON_PIO2_S_MODE_3_CLOCK_CYCLES = 0x3
	// Position of CLKDIV field.
	IOCON_PIO2_CLKDIV_Pos = 0xd
	// Bit mask of CLKDIV field.
	IOCON_PIO2_CLKDIV_Msk = 0xe000
	// CMP_PCLK.
	IOCON_PIO2_CLKDIV_CMP_PCLK = 0x0
	// CMP_PCLK/2.
	IOCON_PIO2_CLKDIV_CMP_PCLKDIV2 = 0x1
	// CMP_PCLK/4.
	IOCON_PIO2_CLKDIV_CMP_PCLKDIV4 = 0x2
	// CMP_PCLK/8.
	IOCON_PIO2_CLKDIV_CMP_PCLKDIV8 = 0x3
	// CMP_PCLK/16.
	IOCON_PIO2_CLKDIV_CMP_PCLKDIV16 = 0x4
	// CMP_PCLK/32.
	IOCON_PIO2_CLKDIV_CMP_PCLKDIV32 = 0x5
	// CMP_PCLK/64.
	IOCON_PIO2_CLKDIV_CMP_PCLKDIV64 = 0x6
	// Position of RESERVED field.
	IOCON_PIO2_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	IOCON_PIO2_RESERVED_Msk = 0xffff0000
)
