/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.SessionScoped;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Model;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.internal.MavenWorkspaceReader;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.repository.WorkspaceRepository;
import org.eclipse.aether.util.artifact.ArtifactIdUtils;

@Named(value="reactor")
@SessionScoped
class ReactorReader
implements MavenWorkspaceReader {
    public static final String HINT = "reactor";
    private static final Collection<String> COMPILE_PHASE_TYPES = Arrays.asList("jar", "ejb-client", "war", "rar", "ejb3", "par", "sar", "wsr", "har", "app-client");
    private Map<String, MavenProject> projectsByGAV;
    private Map<String, List<MavenProject>> projectsByGA;
    private WorkspaceRepository repository;

    @Inject
    ReactorReader(MavenSession session) {
        this.projectsByGAV = session.getProjectMap();
        this.projectsByGA = new HashMap<String, List<MavenProject>>(this.projectsByGAV.size() * 2);
        for (MavenProject project2 : this.projectsByGAV.values()) {
            String key2 = ArtifactUtils.versionlessKey(project2.getGroupId(), project2.getArtifactId());
            List<MavenProject> projects = this.projectsByGA.get(key2);
            if (projects == null) {
                projects = new ArrayList<MavenProject>(1);
                this.projectsByGA.put(key2, projects);
            }
            projects.add(project2);
        }
        this.repository = new WorkspaceRepository(HINT, new HashSet<String>(this.projectsByGAV.keySet()));
    }

    @Override
    public WorkspaceRepository getRepository() {
        return this.repository;
    }

    @Override
    public File findArtifact(Artifact artifact) {
        String projectKey = ArtifactUtils.key(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
        MavenProject project2 = this.projectsByGAV.get(projectKey);
        if (project2 != null) {
            File file2 = this.find(project2, artifact);
            if (file2 == null && project2 != project2.getExecutionProject()) {
                file2 = this.find(project2.getExecutionProject(), artifact);
            }
            return file2;
        }
        return null;
    }

    @Override
    public List<String> findVersions(Artifact artifact) {
        String key2 = ArtifactUtils.versionlessKey(artifact.getGroupId(), artifact.getArtifactId());
        List<MavenProject> projects = this.projectsByGA.get(key2);
        if (projects == null || projects.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> versions = new ArrayList<String>();
        for (MavenProject project2 : projects) {
            if (this.find(project2, artifact) == null) continue;
            versions.add(project2.getVersion());
        }
        return Collections.unmodifiableList(versions);
    }

    @Override
    public Model findModel(Artifact artifact) {
        String projectKey = ArtifactUtils.key(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
        MavenProject project2 = this.projectsByGAV.get(projectKey);
        return project2 == null ? null : project2.getModel();
    }

    private File find(MavenProject project2, Artifact artifact) {
        if ("pom".equals(artifact.getExtension())) {
            return project2.getFile();
        }
        Artifact projectArtifact = this.findMatchingArtifact(project2, artifact);
        if (this.hasArtifactFileFromPackagePhase(projectArtifact)) {
            return projectArtifact.getFile();
        }
        if (!this.hasBeenPackaged(project2)) {
            if (ReactorReader.isTestArtifact(artifact)) {
                if (project2.hasLifecyclePhase("test-compile")) {
                    return new File(project2.getBuild().getTestOutputDirectory());
                }
            } else {
                String type2 = artifact.getProperty("type", "");
                if (project2.hasLifecyclePhase("compile") && COMPILE_PHASE_TYPES.contains(type2)) {
                    return new File(project2.getBuild().getOutputDirectory());
                }
            }
        }
        return null;
    }

    private boolean hasArtifactFileFromPackagePhase(Artifact projectArtifact) {
        return projectArtifact != null && projectArtifact.getFile() != null && projectArtifact.getFile().exists();
    }

    private boolean hasBeenPackaged(MavenProject project2) {
        return project2.hasLifecyclePhase("package") || project2.hasLifecyclePhase("install") || project2.hasLifecyclePhase("deploy");
    }

    private Artifact findMatchingArtifact(MavenProject project2, Artifact requestedArtifact) {
        Artifact mainArtifact;
        String requestedRepositoryConflictId = ArtifactIdUtils.toVersionlessId(requestedArtifact);
        if (requestedRepositoryConflictId.equals(ArtifactIdUtils.toVersionlessId(mainArtifact = RepositoryUtils.toArtifact(project2.getArtifact())))) {
            return mainArtifact;
        }
        for (Artifact attachedArtifact : RepositoryUtils.toArtifacts(project2.getAttachedArtifacts())) {
            if (!this.attachedArtifactComparison(requestedArtifact, attachedArtifact)) continue;
            return attachedArtifact;
        }
        return null;
    }

    private boolean attachedArtifactComparison(Artifact requested, Artifact attached) {
        return requested.getArtifactId().equals(attached.getArtifactId()) && requested.getGroupId().equals(attached.getGroupId()) && requested.getVersion().equals(attached.getVersion()) && requested.getExtension().equals(attached.getExtension()) && requested.getClassifier().equals(attached.getClassifier());
    }

    private static boolean isTestArtifact(Artifact artifact) {
        return "test-jar".equals(artifact.getProperty("type", "")) || "jar".equals(artifact.getExtension()) && "tests".equals(artifact.getClassifier());
    }
}

